/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.multivar;

import cc.redberry.rings.ChineseRemainders;
import cc.redberry.rings.Integers;
import cc.redberry.rings.IntegersZp;
import cc.redberry.rings.IntegersZp64;
import cc.redberry.rings.Rational;
import cc.redberry.rings.RationalReconstruction;
import cc.redberry.rings.Rationals;
import cc.redberry.rings.Ring;
import cc.redberry.rings.Rings;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.bigint.BigIntegerUtil;
import cc.redberry.rings.linear.LinearSolver;
import cc.redberry.rings.poly.IPolynomial;
import cc.redberry.rings.poly.MultivariateRing;
import cc.redberry.rings.poly.UnivariateRing;
import cc.redberry.rings.poly.Util;
import cc.redberry.rings.poly.multivar.AMonomial;
import cc.redberry.rings.poly.multivar.AMultivariatePolynomial;
import cc.redberry.rings.poly.multivar.Conversions64bit;
import cc.redberry.rings.poly.multivar.DegreeVector;
import cc.redberry.rings.poly.multivar.IMonomialAlgebra;
import cc.redberry.rings.poly.multivar.Monomial;
import cc.redberry.rings.poly.multivar.MonomialOrder;
import cc.redberry.rings.poly.multivar.MonomialSetView;
import cc.redberry.rings.poly.multivar.MonomialZp64;
import cc.redberry.rings.poly.multivar.MultivariateDivision;
import cc.redberry.rings.poly.multivar.MultivariateGCD;
import cc.redberry.rings.poly.multivar.MultivariatePolynomial;
import cc.redberry.rings.poly.multivar.MultivariatePolynomialZp64;
import cc.redberry.rings.poly.multivar.PairedIterator;
import cc.redberry.rings.poly.univar.IUnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariateDivision;
import cc.redberry.rings.poly.univar.UnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariatePolynomialArithmetic;
import cc.redberry.rings.primes.PrimesIterator;
import cc.redberry.rings.util.ArraysUtil;
import cc.redberry.rings.util.ListWrapper;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class GroebnerBases {
    private static final boolean USE_MODULAR_ALGORITHM = true;
    private static final int MODULAR_ALGORITHM_MAX_N_VARIABLES = 3;
    public static MinimizationStrategy NO_MINIMIZATION = (prev, curr) -> false;
    private static final int F4_MIN_SELECTION_SIZE = 0;
    private static final int F4_OVER_FIELD_LINALG_THRESHOLD = 16;
    private static final int F4_OVER_EUCLID_LINALG_THRESHOLD = 6;
    private static final double DENSE_FILLING_THRESHOLD = 0.1;
    private static final int N_UNKNOWNS_THRESHOLD = 32;
    private static final int N_BUCHBERGER_STEPS_THRESHOLD = 64;
    private static final int N_MOD_STEPS_THRESHOLD = 4;
    private static final int N_BUCHBERGER_STEPS_REDUNDANCY_DELTA = 9;
    private static Comparator<HilbertSeries> ModHilbertSeriesComparator = (a, b) -> {
        UnivariatePolynomial<Rational<BigInteger>> bHilbert;
        UnivariatePolynomial<Rational<BigInteger>> aHilbert = a.hilbertPolynomial();
        if (aHilbert.equals(bHilbert = b.hilbertPolynomial())) {
            return 0;
        }
        int n = Math.max(a.numerator.degree(), b.numerator.degree()) + 1;
        int c;
        while ((c = aHilbert.evaluate((Rational<BigInteger>)((long)n)).compareTo(bHilbert.evaluate((Rational<BigInteger>)((long)n)))) == 0) {
            ++n;
        }
        return c;
    };
    private static final int DROP_SOLVED_VARIABLES_THRESHOLD = 128;
    private static final double DROP_SOLVED_VARIABLES_RELATIVE_THRESHOLD = 0.1;

    private GroebnerBases() {
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> List<Poly> GroebnerBasis(List<Poly> generators, Comparator<DegreeVector> monomialOrder) {
        if (generators.isEmpty()) {
            return Collections.emptyList();
        }
        if (monomialOrder instanceof MonomialOrder.GrevLexWithPermutation) {
            GroebnerAlgorithm ga = (p, o, s) -> GBResult.notBuchberger(GroebnerBases.GroebnerBasis(p, o));
            return GroebnerBases.GroebnerBasisRegardingGrevLexWithPermutation(generators, ga, (MonomialOrder.GrevLexWithPermutation)monomialOrder);
        }
        AMultivariatePolynomial factory = (AMultivariatePolynomial)generators.get(0);
        if (factory.isOverFiniteField()) {
            return GroebnerBases.GroebnerBasisInGF(generators, monomialOrder, null);
        }
        if (factory.isOverZ()) {
            return GroebnerBases.GroebnerBasisInZ(generators, monomialOrder, null, true);
        }
        if (Util.isOverRationals(factory) && ((MultivariatePolynomial)factory).ring.equals(Rings.Q)) {
            return GroebnerBases.GroebnerBasisInQ(generators, monomialOrder, null, true);
        }
        return GroebnerBases.BuchbergerGB(generators, monomialOrder);
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> GBResult<Term, Poly> GroebnerBasisInGF(List<Poly> generators, Comparator<DegreeVector> monomialOrder, HilbertSeries hilbertSeries) {
        AMultivariatePolynomial factory = (AMultivariatePolynomial)generators.get(0);
        if (!factory.isOverFiniteField()) {
            throw new IllegalArgumentException("not over finite field");
        }
        if (Conversions64bit.canConvertToZp64(factory)) {
            GBResult<Term, MultivariatePolynomialZp64> r = GroebnerBases.GroebnerBasisInGF(Conversions64bit.asOverZp64(generators), monomialOrder, hilbertSeries);
            return new GBResult(Conversions64bit.convertFromZp64(r), r);
        }
        if (MonomialOrder.isGradedOrder(monomialOrder)) {
            return GroebnerBases.F4GB(generators, monomialOrder, hilbertSeries);
        }
        if (hilbertSeries != null) {
            return GroebnerBases.BuchbergerGB(generators, monomialOrder, hilbertSeries);
        }
        if (GroebnerBases.isHomogeneousIdeal(generators) || GroebnerBases.isHomogenizationCompatibleOrder(monomialOrder)) {
            return GroebnerBases.HilbertGB(generators, monomialOrder);
        }
        return GroebnerBases.BuchbergerGB(generators, monomialOrder);
    }

    public static GBResult<Monomial<BigInteger>, MultivariatePolynomial<BigInteger>> GroebnerBasisInZ(List<MultivariatePolynomial<BigInteger>> generators, Comparator<DegreeVector> monomialOrder, HilbertSeries hilbertSeries, boolean tryModular) {
        MultivariatePolynomial<BigInteger> factory = generators.get(0);
        if (!factory.isOverZ()) {
            throw new IllegalArgumentException();
        }
        if ((MonomialOrder.isGradedOrder(monomialOrder) || GroebnerBases.isHomogeneousIdeal(generators)) && tryModular && factory.nVariables <= 3) {
            return GroebnerBases.ModularGB(generators, monomialOrder, hilbertSeries);
        }
        if (MonomialOrder.isGradedOrder(monomialOrder)) {
            return GroebnerBases.F4GB(generators, monomialOrder, hilbertSeries);
        }
        if (hilbertSeries != null) {
            return GroebnerBases.BuchbergerGB(generators, monomialOrder, hilbertSeries);
        }
        if (GroebnerBases.isHomogeneousIdeal(generators) || GroebnerBases.isHomogenizationCompatibleOrder(monomialOrder)) {
            return GroebnerBases.HilbertGB(generators, monomialOrder);
        }
        return GroebnerBases.BuchbergerGB(generators, monomialOrder);
    }

    public static List<MultivariatePolynomial<Rational<BigInteger>>> GroebnerBasisInQ(List<MultivariatePolynomial<Rational<BigInteger>>> generators, Comparator<DegreeVector> monomialOrder, HilbertSeries hilbertSeries, boolean tryModular) {
        return GroebnerBases.FracGB(generators, monomialOrder, hilbertSeries, (p, o, s) -> GroebnerBases.GroebnerBasisInZ(p, o, s, tryModular));
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> List<Poly> ConvertBasis(List<Poly> generators, Comparator<DegreeVector> desiredOrder) {
        return GroebnerBases.HilbertConvertBasis(generators, desiredOrder);
    }

    static <Poly extends AMultivariatePolynomial<?, Poly>> void setMonomialOrder(List<Poly> list, Comparator<DegreeVector> order) {
        for (int i = 0; i < list.size(); ++i) {
            AMultivariatePolynomial p = (AMultivariatePolynomial)list.get(i);
            if (order.equals(p.ordering)) continue;
            list.set(i, p.setOrdering(order));
        }
    }

    static <Poly extends AMultivariatePolynomial<?, Poly>> List<Poly> canonicalize(List<Poly> list) {
        if (Util.isOverRationals((AMultivariatePolynomial)list.get(0))) {
            GroebnerBases.canonicalizeFrac(list);
        } else {
            list.forEach(IPolynomial::canonical);
        }
        list.sort(Comparable::compareTo);
        return list;
    }

    static <E> void canonicalizeFrac(List<MultivariatePolynomial<Rational<E>>> list) {
        Ring fRing = ((Rational)list.get((int)0).ring.getOne()).ring;
        list.replaceAll(p -> ((MultivariatePolynomial)((MultivariatePolynomial)Util.toCommonDenominator(p)._1).canonical()).mapCoefficients(p.ring, c -> new Rational<Object>(fRing, c)));
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> List<Poly> prepareGenerators(List<Poly> generators, Comparator<DegreeVector> monomialOrder) {
        generators = generators.stream().map(p -> p.setOrdering(monomialOrder)).map(IPolynomial::canonical).collect(Collectors.toList());
        AMultivariatePolynomial factory = (AMultivariatePolynomial)generators.get(0);
        if (factory.nVariables == 1) {
            return GroebnerBases.canonicalize(Collections.singletonList(MultivariateGCD.PolynomialGCD(generators)));
        }
        generators.removeIf(AMultivariatePolynomial::isZero);
        if (generators.isEmpty()) {
            generators.add((AMultivariatePolynomial)factory.createZero());
            return generators;
        }
        GroebnerBases.removeRedundant(generators);
        generators.removeIf(AMultivariatePolynomial::isZero);
        if (generators.isEmpty()) {
            generators.add((AMultivariatePolynomial)factory.createZero());
            return generators;
        }
        if (generators.stream().anyMatch(IPolynomial::isConstant)) {
            return Collections.singletonList((AMultivariatePolynomial)factory.createOne());
        }
        return generators;
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> void minimizeGroebnerBases(List<Poly> basis) {
        block0: for (int i = basis.size() - 1; i >= 1; --i) {
            for (int j = i - 1; j >= 0; --j) {
                AMultivariatePolynomial pi = (AMultivariatePolynomial)basis.get(i);
                AMultivariatePolynomial pj = (AMultivariatePolynomial)basis.get(j);
                if (((DegreeVector)pi.lt()).dvDivisibleBy((DegreeVector)pj.lt())) {
                    basis.remove(i);
                    continue block0;
                }
                if (!((DegreeVector)pj.lt()).dvDivisibleBy((DegreeVector)pi.lt())) continue;
                basis.remove(j);
                --i;
            }
        }
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> void removeRedundant(List<Poly> basis) {
        int size = basis.size();
        for (int i = 0; i < size; ++i) {
            AMultivariatePolynomial el = (AMultivariatePolynomial)basis.remove(i);
            List<Poly> r = MultivariateDivision.pseudoRemainder(el, basis);
            if (((AMultivariatePolynomial)((Object)r)).isZero()) {
                --i;
                --size;
                continue;
            }
            basis.add(i, r);
        }
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly syzygy(Poly a, Poly b) {
        return GroebnerBases.syzygy(new DegreeVector(GroebnerBases.lcm(a.multidegree(), b.multidegree())), a, b);
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly syzygy(SyzygyPair<Term, Poly> sPair) {
        return (Poly)GroebnerBases.syzygy(sPair.syzygyGamma, (AMultivariatePolynomial)sPair.fi, (AMultivariatePolynomial)sPair.fj);
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly syzygy(DegreeVector dvlcm, Poly a, Poly b) {
        IMonomialAlgebra mAlgebra = a.monomialAlgebra;
        Object lcm = a.isOverField() ? mAlgebra.create(dvlcm) : new Monomial(dvlcm, ((MultivariatePolynomial)a).ring.lcm(((MultivariatePolynomial)a).lc(), ((MultivariatePolynomial)b).lc()));
        Object aReduced = ((AMultivariatePolynomial)a.clone()).multiply(mAlgebra.divideExact(lcm, a.lt()));
        Object bReduced = ((AMultivariatePolynomial)b.clone()).multiply(mAlgebra.divideExact(lcm, b.lt()));
        Poly syzygy = ((AMultivariatePolynomial)aReduced).subtract(bReduced);
        return syzygy;
    }

    private static <Term extends AMonomial<Term>, Poly extends MonomialSetView<Term>> void updateBasis(List<Poly> basis, SyzygySet<Term, Poly> sPairs, Poly newElement) {
        int i;
        assert (!newElement.collection().isEmpty());
        int[][] lcm = new int[basis.size()][];
        Object newLeadTerm = newElement.lt();
        for (int i2 = 0; i2 < basis.size(); ++i2) {
            MonomialSetView fi = (MonomialSetView)basis.get(i2);
            if (fi == null) continue;
            lcm[i2] = GroebnerBases.lcm(((AMonomial)fi.lt()).exponents, ((AMonomial)newLeadTerm).exponents);
        }
        TIntArrayList pairsToAdd = new TIntArrayList();
        block1: for (int iIndex = 0; iIndex < basis.size(); ++iIndex) {
            MonomialSetView fi = (MonomialSetView)basis.get(iIndex);
            if (fi == null) continue;
            if (!GroebnerBases.shareVariablesQ(fi.lt(), newLeadTerm)) {
                pairsToAdd.add(iIndex);
                continue;
            }
            for (i = 0; i < pairsToAdd.size(); ++i) {
                int jIndex = pairsToAdd.get(i);
                MonomialSetView fj = (MonomialSetView)basis.get(jIndex);
                assert (fj != null);
                if (GroebnerBases.dividesQ(lcm[jIndex], lcm[iIndex])) continue block1;
            }
            for (int jIndex = iIndex + 1; jIndex < basis.size(); ++jIndex) {
                MonomialSetView fj = (MonomialSetView)basis.get(jIndex);
                if (fj != null && GroebnerBases.dividesQ(lcm[jIndex], lcm[iIndex])) continue block1;
            }
            pairsToAdd.add(iIndex);
        }
        for (int i3 = pairsToAdd.size() - 1; i3 >= 0; --i3) {
            if (GroebnerBases.shareVariablesQ(((MonomialSetView)basis.get(pairsToAdd.get(i3))).lt(), newLeadTerm)) continue;
            pairsToAdd.removeAt(i3);
        }
        Iterator<TreeSet<SyzygyPair<Term, Poly>>> it = sPairs.allSets().iterator();
        while (it.hasNext()) {
            TreeSet<SyzygyPair<Term, Poly>> c = it.next();
            c.removeIf(sPair -> GroebnerBases.dividesQ(newLeadTerm, sPair.syzygyGamma) && !Arrays.equals(sPair.fi == basis.get(sPair.i) ? lcm[sPair.i] : GroebnerBases.lcm(((AMonomial)sPair.fi.lt()).exponents, newLeadTerm.exponents), sPair.syzygyGamma.exponents) && !Arrays.equals(sPair.fj == basis.get(sPair.j) ? lcm[sPair.j] : GroebnerBases.lcm(((AMonomial)sPair.fj.lt()).exponents, newLeadTerm.exponents), sPair.syzygyGamma.exponents));
            if (!c.isEmpty()) continue;
            it.remove();
        }
        int oldSize = basis.size();
        basis.add(newElement);
        for (i = 0; i < pairsToAdd.size(); ++i) {
            int iIndex = pairsToAdd.get(i);
            assert (basis.get(iIndex) != null);
            sPairs.add(new SyzygyPair(iIndex, oldSize, basis));
        }
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> boolean isGroebnerBasis(List<Poly> ideal, List<Poly> generators, Comparator<DegreeVector> monomialOrder) {
        SyzygyTreeSet sPairs = new SyzygyTreeSet(new TreeSet(GroebnerBases.defaultSelectionStrategy(monomialOrder)));
        ArrayList tmp = new ArrayList();
        ideal.forEach(g -> GroebnerBases.updateBasis(tmp, sPairs, g));
        AMultivariatePolynomial factory = (AMultivariatePolynomial)ideal.get(0);
        AMultivariatePolynomial[] gb = generators.toArray((AMultivariatePolynomial[])factory.createArray(generators.size()));
        return sPairs.allSets().stream().flatMap(Collection::stream).allMatch(p -> MultivariateDivision.pseudoRemainder(GroebnerBases.syzygy(p), gb).isZero());
    }

    public static Comparator<SyzygyPair> normalSelectionStrategy(Comparator<DegreeVector> monomialOrder) {
        return (sa, sb) -> {
            int c = monomialOrder.compare(sa.syzygyGamma, sb.syzygyGamma);
            if (c != 0) {
                return c;
            }
            c = Integer.compare(sa.j, sb.j);
            if (c != 0) {
                return c;
            }
            return Integer.compare(sa.i, sb.i);
        };
    }

    public static Comparator<SyzygyPair> withSugar(Comparator<SyzygyPair> initial) {
        return (sa, sb) -> {
            int c = Integer.compare(sa.sugar, sb.sugar);
            if (c != 0) {
                return c;
            }
            return initial.compare((SyzygyPair)sa, (SyzygyPair)sb);
        };
    }

    public static Comparator<SyzygyPair> defaultSelectionStrategy(Comparator<DegreeVector> monomialOrder) {
        Comparator<SyzygyPair> selectionStrategy = GroebnerBases.normalSelectionStrategy(monomialOrder);
        if (!MonomialOrder.isGradedOrder(monomialOrder)) {
            selectionStrategy = GroebnerBases.withSugar(selectionStrategy);
        }
        return selectionStrategy;
    }

    static boolean isHomogenizationCompatibleOrder(Comparator<DegreeVector> monomialOrder) {
        return MonomialOrder.isGradedOrder(monomialOrder) || monomialOrder == MonomialOrder.LEX;
    }

    static boolean isEasyOrder(Comparator<DegreeVector> monomialOrder) {
        return MonomialOrder.isGradedOrder(monomialOrder);
    }

    static DegreeVector lcm(DegreeVector a, DegreeVector b) {
        return new DegreeVector(GroebnerBases.lcm(a.exponents, b.exponents));
    }

    static int[] lcm(int[] a, int[] b) {
        return ArraysUtil.max(a, b);
    }

    private static boolean dividesQ(int[] divider, int[] dividend) {
        for (int i = 0; i < dividend.length; ++i) {
            if (dividend[i] >= divider[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean dividesQ(DegreeVector divider, DegreeVector dividend) {
        return dividend.dvDivisibleBy(divider);
    }

    static boolean shareVariablesQ(DegreeVector a, DegreeVector b) {
        for (int i = 0; i < a.exponents.length; ++i) {
            if (a.exponents[i] == 0 || b.exponents[i] == 0) continue;
            return true;
        }
        return false;
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> List<Poly> homogenize(List<Poly> ideal) {
        return ideal.stream().map(p -> p.homogenize(p.nVariables)).collect(Collectors.toList());
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> List<Poly> dehomogenize(List<Poly> ideal) {
        return ideal.stream().map(p -> p.dropVariable(p.nVariables - 1)).collect(Collectors.toList());
    }

    static <E> List<MultivariatePolynomial<E>> toIntegral(List<MultivariatePolynomial<Rational<E>>> ideal) {
        return ideal.stream().map(p -> (MultivariatePolynomial)Util.toCommonDenominator(p)._1).collect(Collectors.toList());
    }

    static <E> List<MultivariatePolynomial<Rational<E>>> toFractions(List<MultivariatePolynomial<E>> ideal) {
        Rationals ring = Rings.Frac(ideal.get((int)0).ring);
        return ideal.stream().map(p -> p.mapCoefficients(ring, c -> new Rational<Object>(p.ring, c))).collect(Collectors.toList());
    }

    static <E> GBResult<Monomial<Rational<E>>, MultivariatePolynomial<Rational<E>>> FracGB(List<MultivariatePolynomial<Rational<E>>> ideal, Comparator<DegreeVector> monomialOrder, HilbertSeries hps, GroebnerAlgorithm<Monomial<E>, MultivariatePolynomial<E>> algorithm) {
        return GroebnerBases.FracGB(algorithm).GroebnerBasis(ideal, monomialOrder, hps);
    }

    static <E> GroebnerAlgorithm<Monomial<Rational<E>>, MultivariatePolynomial<Rational<E>>> FracGB(GroebnerAlgorithm<Monomial<E>, MultivariatePolynomial<E>> algorithm) {
        return (gens, ord, hilb) -> {
            GBResult r = algorithm.GroebnerBasis(GroebnerBases.toIntegral(gens), ord, hilb);
            return new GBResult(GroebnerBases.toFractions(r), r);
        };
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> GBResult<Term, Poly> BuchbergerGB(List<Poly> generators, Comparator<DegreeVector> monomialOrder) {
        return GroebnerBases.BuchbergerGB(generators, monomialOrder, (HilbertSeries)null);
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> GBResult<Term, Poly> BuchbergerGB(List<Poly> generators, Comparator<DegreeVector> monomialOrder, Comparator<SyzygyPair> strategy) {
        return GroebnerBases.BuchbergerGB(generators, monomialOrder, () -> new SyzygyTreeSet(new TreeSet(strategy)), null);
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> GBResult<Term, Poly> BuchbergerGB(List<Poly> generators, Comparator<DegreeVector> monomialOrder, HilbertSeries hilbertSeries) {
        if (Util.isOverRationals((AMultivariatePolynomial)generators.get(0))) {
            return GroebnerBases.FracGB(generators, monomialOrder, hilbertSeries, GroebnerBases::BuchbergerGB);
        }
        Comparator<SyzygyPair> strategy = GroebnerBases.defaultSelectionStrategy(monomialOrder);
        return GroebnerBases.BuchbergerGB(generators, monomialOrder, hilbertSeries == null ? () -> new SyzygyTreeSet(new TreeSet(strategy)) : () -> new GradedSyzygyTreeSet(new TreeMap(), strategy, SyzygyPair::degree), hilbertSeries);
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> GBResult<Term, Poly> BuchbergerGB(List<Poly> generators, Comparator<DegreeVector> monomialOrder, Supplier<SyzygySet<Term, Poly>> syzygySetSupplier, HilbertSeries hilbertSeries) {
        return GroebnerBases.BuchbergerGB(generators, monomialOrder, NO_MINIMIZATION, syzygySetSupplier, hilbertSeries);
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> GBResult<Term, Poly> BuchbergerGB(List<Poly> generators, Comparator<DegreeVector> monomialOrder, MinimizationStrategy minimizationStrategy, Supplier<SyzygySet<Term, Poly>> syzygySetSupplier, HilbertSeries hilbertSeries) {
        assert (hilbertSeries == null || GroebnerBases.isHomogeneousIdeal(generators) || MonomialOrder.isGradedOrder(monomialOrder));
        assert (hilbertSeries == null || minimizationStrategy == NO_MINIMIZATION);
        if ((generators = GroebnerBases.prepareGenerators(generators, monomialOrder)).size() == 1) {
            return GBResult.trivial(GroebnerBases.canonicalize(generators));
        }
        AMultivariatePolynomial factory = (AMultivariatePolynomial)generators.get(0);
        Comparator<Object> polyOrder = MonomialOrder.isGradedOrder(monomialOrder) ? (a, b) -> monomialOrder.compare((DegreeVector)a.lt(), (DegreeVector)b.lt()) : new EcartComparator();
        generators.sort(polyOrder);
        SyzygySet sPairs = syzygySetSupplier.get();
        assert (hilbertSeries == null || sPairs instanceof GradedSyzygyTreeSet);
        ArrayList groebner = new ArrayList();
        generators.forEach(g -> GroebnerBases.updateBasis(groebner, sPairs, g));
        AMultivariatePolynomial[] reducersArray = (AMultivariatePolynomial[])groebner.stream().filter(Objects::nonNull).toArray((IntFunction<AMultivariatePolynomial[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, createArray(int ), (I)[Lcc/redberry/rings/poly/multivar/AMultivariatePolynomial;)((AMultivariatePolynomial)factory));
        int hilbertDegree = 0;
        int hilbertDelta = Integer.MAX_VALUE;
        int nHilbertRemoved = 0;
        int sizeAfterMinimization = groebner.size();
        int nProcessedSyzygies = 0;
        int nRedundantSyzygies = 0;
        while (!sPairs.isEmpty()) {
            Collection subset;
            Collection collection = subset = hilbertSeries == null ? sPairs.getAndRemoveNextBunch() : (Collection)((GradedSyzygyTreeSet)sPairs).sPairs.remove(hilbertDegree);
            if (subset != null) {
                for (SyzygyPair pair : subset) {
                    if (hilbertDelta == 0) break;
                    AMultivariatePolynomial[] syzygy = MultivariateDivision.pseudoRemainder(GroebnerBases.syzygy(pair), reducersArray);
                    ++nProcessedSyzygies;
                    if (syzygy.isZero()) {
                        ++nRedundantSyzygies;
                        continue;
                    }
                    if (syzygy.isConstant()) {
                        return new GBResult(Collections.singletonList((AMultivariatePolynomial)factory.createOne()), 2 * nProcessedSyzygies, 2 * nRedundantSyzygies, nHilbertRemoved);
                    }
                    GroebnerBases.updateBasis(groebner, sPairs, syzygy);
                    if (hilbertSeries != null) {
                        --hilbertDelta;
                    }
                    reducersArray = (AMultivariatePolynomial[])groebner.stream().filter(Objects::nonNull).toArray((IntFunction<AMultivariatePolynomial[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, createArray(int ), (I)[Lcc/redberry/rings/poly/multivar/AMultivariatePolynomial;)((AMultivariatePolynomial)factory));
                    if (!minimizationStrategy.doMinimize(sizeAfterMinimization, groebner.size())) continue;
                    GroebnerBases.reduceAndMinimizeGroebnerBases(groebner, sPairs, sizeAfterMinimization);
                    sizeAfterMinimization = groebner.size();
                }
            }
            if (hilbertSeries == null || subset == null && hilbertDegree != 0) continue;
            HilbertSeries currentHPS = GroebnerBases.HilbertSeriesOfLeadingTermsSet(groebner);
            HilbertUpdate update = GroebnerBases.updateWithHPS(hilbertSeries, currentHPS, (GradedSyzygyTreeSet)sPairs);
            if (update.finished) break;
            nHilbertRemoved += update.nRemovedPairs;
            hilbertDegree = update.currentDegree;
            hilbertDelta = update.hilbertDelta;
        }
        groebner.removeAll(Collections.singleton(null));
        GroebnerBases.minimizeGroebnerBases(groebner);
        groebner.sort(polyOrder);
        GroebnerBases.removeRedundant(groebner);
        GroebnerBases.canonicalize(groebner);
        return new GBResult(groebner, 2 * nProcessedSyzygies, 2 * nRedundantSyzygies, nHilbertRemoved);
    }

    private static <Term extends AMonomial<Term>, Poly extends MonomialSetView<Term>> HilbertUpdate updateWithHPS(HilbertSeries hilbertSeries, HilbertSeries currentHPS, GradedSyzygyTreeSet<Term, Poly> sPairs) {
        if (currentHPS.equals(hilbertSeries)) {
            return new HilbertUpdate();
        }
        int currentDegree = 0;
        while (hilbertSeries.initialNumerator.get(currentDegree).equals(currentHPS.initialNumerator.get(currentDegree))) {
            ++currentDegree;
        }
        Rational<Rational<BigInteger>> delta = currentHPS.initialNumerator.get(currentDegree).subtract((BigInteger)((Object)hilbertSeries.initialNumerator.get(currentDegree)));
        assert (delta.isIntegral() && ((BigInteger)((Object)delta.numerator())).signum() > 0);
        int hilbertDelta = ((BigInteger)((Object)delta.numerator())).intValueExact();
        int mDegree = currentDegree;
        int sizeBefore = sPairs.size();
        sPairs.allSets().forEach(set -> set.removeIf(s -> s.degree() < mDegree));
        return new HilbertUpdate(currentDegree, hilbertDelta, sizeBefore - sPairs.size());
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> void reduceAndMinimizeGroebnerBases(List<Poly> generators, SyzygySet<Term, Poly> sPairs, int from) {
        for (int i = from; i < generators.size(); ++i) {
            AMultivariatePolynomial fi = (AMultivariatePolynomial)generators.get(i);
            if (fi == null) continue;
            for (int j = 0; j < i; ++j) {
                int l;
                AMultivariatePolynomial fj = (AMultivariatePolynomial)generators.get(j);
                if (fj == null || !MultivariateDivision.nontrivialQuotientQ(fj, fi)) continue;
                generators.remove(j);
                AMultivariatePolynomial reduced = GroebnerBases.remainder0(fj, generators);
                if (reduced.equals(fj)) continue;
                if (reduced.isZero()) {
                    reduced = null;
                }
                generators.add(j, reduced);
                if (fj.equals(reduced)) continue;
                if (reduced == null) {
                    for (l = 0; l < generators.size(); ++l) {
                        if (l == j || generators.get(l) == null) continue;
                        sPairs.remove(new SyzygyPair(l, j, generators));
                    }
                    continue;
                }
                for (l = 0; l < generators.size(); ++l) {
                    if (l == j || generators.get(l) == null) continue;
                    sPairs.add(new SyzygyPair(l, j, generators));
                }
            }
        }
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly remainder0(Poly dividend, List<Poly> dividers) {
        AMultivariatePolynomial[] dividersArr = (AMultivariatePolynomial[])dividers.stream().filter(Objects::nonNull).toArray((IntFunction<AMultivariatePolynomial[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, createArray(int ), (I)[Lcc/redberry/rings/poly/multivar/AMultivariatePolynomial;)(dividend));
        return (Poly)MultivariateDivision.pseudoRemainder(dividend, dividersArr);
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> GBResult<Term, Poly> HilbertGB(List<Poly> generators, Comparator<DegreeVector> monomialOrder, HilbertSeries hilbertSeries) {
        if (hilbertSeries == null) {
            throw new NullPointerException();
        }
        return GroebnerBases.BuchbergerGB(generators, monomialOrder, hilbertSeries);
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> GBResult<Term, Poly> HilbertConvertBasis(List<Poly> groebnerBasis, Comparator<DegreeVector> desiredOrdering) {
        Comparator<DegreeVector> ordering = ((AMultivariatePolynomial)groebnerBasis.get((int)0)).ordering;
        if (ordering == desiredOrdering) {
            return GBResult.trivial(new ArrayList<Poly>(groebnerBasis));
        }
        if (GroebnerBases.isHomogeneousIdeal(groebnerBasis) || MonomialOrder.isGradedOrder(desiredOrdering) && MonomialOrder.isGradedOrder(ordering)) {
            return GroebnerBases.HilbertGB(groebnerBasis, desiredOrdering, GroebnerBases.HilbertSeriesOfLeadingTermsSet(groebnerBasis));
        }
        if (GroebnerBases.isHomogenizationCompatibleOrder(desiredOrdering)) {
            return GroebnerBases.HilbertGB(groebnerBasis, desiredOrdering);
        }
        throw new RuntimeException("Hilbert conversion is not supported for specified ordering: " + desiredOrdering);
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> GBResult<Term, Poly> HilbertGB(List<Poly> generators, Comparator<DegreeVector> monomialOrder) {
        return GroebnerBases.HilbertGB(generators, monomialOrder, (List<Poly> p, Comparator<DegreeVector> o, HilbertSeries s) -> GBResult.notBuchberger(GroebnerBases.GroebnerBasis(p, o)));
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> GBResult<Term, Poly> HilbertGB(List<Poly> generators, Comparator<DegreeVector> monomialOrder, GroebnerAlgorithm<Term, Poly> baseAlgorithm) {
        if (GroebnerBases.isEasyOrder(monomialOrder)) {
            return baseAlgorithm.GroebnerBasis(generators, monomialOrder, null);
        }
        if (GroebnerBases.isHomogeneousIdeal(generators)) {
            return GroebnerBases.HilbertConvertBasis(GroebnerBases.GroebnerBasisWithOptimizedGradedOrder(generators, baseAlgorithm), monomialOrder);
        }
        GBResult<Term, Poly> r = GroebnerBases.HilbertGB(GroebnerBases.homogenize(generators), monomialOrder, baseAlgorithm);
        List<Poly> l = GroebnerBases.dehomogenize(r);
        GroebnerBases.removeRedundant(l);
        GroebnerBases.canonicalize(l);
        return new GBResult(l, r);
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> List<Poly> GroebnerBasisWithOptimizedGradedOrder(List<Poly> ideal) {
        return GroebnerBases.GroebnerBasisWithOptimizedGradedOrder(ideal, (l, o, h) -> GBResult.notBuchberger(GroebnerBases.GroebnerBasis(l, o)));
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> List<Poly> GroebnerBasisWithOptimizedGradedOrder(List<Poly> ideal, GroebnerAlgorithm<Term, Poly> baseAlgorithm) {
        Comparator<DegreeVector> ord = GroebnerBases.optimalOrder(ideal);
        if (ord == MonomialOrder.GREVLEX) {
            return baseAlgorithm.GroebnerBasis(ideal, MonomialOrder.GREVLEX, null);
        }
        MonomialOrder.GrevLexWithPermutation order = (MonomialOrder.GrevLexWithPermutation)ord;
        return GroebnerBases.GroebnerBasisRegardingGrevLexWithPermutation(ideal, baseAlgorithm, order);
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> List<Poly> GroebnerBasisRegardingGrevLexWithPermutation(List<Poly> ideal, GroebnerAlgorithm<Term, Poly> baseAlgorithm, MonomialOrder.GrevLexWithPermutation order) {
        int[] inversePermutation = MultivariateGCD.inversePermutation(order.permutation);
        return baseAlgorithm.GroebnerBasis(ideal.stream().map(p -> AMultivariatePolynomial.renameVariables(p, order.permutation)).collect(Collectors.toList()), MonomialOrder.GREVLEX, null).stream().map(p -> AMultivariatePolynomial.renameVariables(p, inversePermutation)).map(p -> p.setOrdering(order)).collect(Collectors.toList());
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Comparator<DegreeVector> optimalOrder(List<Poly> ideal) {
        if (ideal.isEmpty()) {
            return MonomialOrder.GREVLEX;
        }
        AMultivariatePolynomial factory = (AMultivariatePolynomial)ideal.get(0);
        int[] degrees = ideal.stream().map(AMultivariatePolynomial::degrees).reduce(new int[factory.nVariables], ArraysUtil::sum);
        if (Arrays.stream(degrees).allMatch(i -> i == degrees[0])) {
            return MonomialOrder.GREVLEX;
        }
        int[] permutation = ArraysUtil.sequence(0, factory.nVariables);
        ArraysUtil.quickSort(degrees, permutation);
        return new MonomialOrder.GrevLexWithPermutation(permutation);
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> GBResult<Term, Poly> F4GB(List<Poly> generators, Comparator<DegreeVector> monomialOrder) {
        return GroebnerBases.F4GB(generators, monomialOrder, null);
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> GBResult<Term, Poly> F4GB(List<Poly> generators, Comparator<DegreeVector> monomialOrder, HilbertSeries hilbertSeries) {
        if (!MonomialOrder.isGradedOrder(monomialOrder)) {
            throw new UnsupportedOperationException("F4 works only with graded orders");
        }
        if (Util.isOverRationals((AMultivariatePolynomial)generators.get(0))) {
            return GroebnerBases.FracGB(generators, monomialOrder, hilbertSeries, GroebnerBases::F4GB);
        }
        return GroebnerBases.F4GB(generators, monomialOrder, () -> new GradedSyzygyTreeSet(new TreeMap(), GroebnerBases.defaultSelectionStrategy(monomialOrder), SyzygyPair::degree), hilbertSeries);
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> GBResult<Term, Poly> F4GB(List<Poly> generators, Comparator<DegreeVector> monomialOrder, Supplier<GradedSyzygyTreeSet<Term, ArrayBasedPoly<Term>>> syzygySetSupplier, HilbertSeries hilbertSeries) {
        assert (hilbertSeries == null || GroebnerBases.isHomogeneousIdeal(generators) || MonomialOrder.isGradedOrder(monomialOrder));
        if ((generators = GroebnerBases.prepareGenerators(generators, monomialOrder)).size() == 1) {
            return GBResult.trivial(GroebnerBases.canonicalize(generators));
        }
        AMultivariatePolynomial factory = (AMultivariatePolynomial)generators.get(0);
        Comparator<Object> polyOrder = MonomialOrder.isGradedOrder(monomialOrder) ? (a, b) -> monomialOrder.compare((DegreeVector)a.lt(), (DegreeVector)b.lt()) : new EcartComparator();
        generators.sort(polyOrder);
        GradedSyzygyTreeSet sPairs = syzygySetSupplier.get();
        ArrayList groebner = new ArrayList();
        ArrayList<List<ArrayBasedPoly<Term>>> f4reductions = new ArrayList<List<ArrayBasedPoly<Term>>>();
        for (AMultivariatePolynomial generator : generators) {
            ArrayBasedPoly g2 = new ArrayBasedPoly(generator);
            GroebnerBases.updateBasis(groebner, sPairs, g2);
            f4reductions.add(new ArrayList(Collections.singletonList(g2)));
        }
        ArrayList reducers = new ArrayList(generators);
        AMultivariatePolynomial[] reducersArray = (AMultivariatePolynomial[])reducers.stream().filter(Objects::nonNull).toArray((IntFunction<AMultivariatePolynomial[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, createArray(int ), (I)[Lcc/redberry/rings/poly/multivar/AMultivariatePolynomial;)((AMultivariatePolynomial)factory));
        int hilbertDegree = 0;
        int hilbertDelta = Integer.MAX_VALUE;
        int nHilbertRemoved = 0;
        int nProcessedPolynomials = 0;
        int nRedundantSyzygies = 0;
        while (!sPairs.isEmpty()) {
            Collection subset;
            if (hilbertSeries != null) {
                subset = sPairs.sPairs.remove(hilbertDegree);
            } else {
                subset = sPairs.getAndRemoveNextBunch();
                assert (!subset.isEmpty());
                while (!sPairs.isEmpty() && subset.size() < 0) {
                    subset.addAll(sPairs.getAndRemoveNextBunch());
                }
            }
            if (subset != null) {
                if (factory.isOverField() && subset.size() <= 16 || !factory.isOverField() && subset.size() <= 6) {
                    for (SyzygyPair sPair : subset) {
                        ++nProcessedPolynomials;
                        if (hilbertDelta != 0) {
                            Object syzygy = GroebnerBases.syzygy(sPair.syzygyGamma, factory.create(sPair.fi), factory.create(sPair.fj));
                            if (((AMultivariatePolynomial)(syzygy = MultivariateDivision.pseudoRemainder(syzygy, reducersArray))).isZero()) {
                                ++nRedundantSyzygies;
                                continue;
                            }
                            if (syzygy.isConstant()) {
                                return new GBResult(Collections.singletonList((AMultivariatePolynomial)factory.createOne()), nProcessedPolynomials, nRedundantSyzygies, nHilbertRemoved);
                            }
                            ArrayBasedPoly _syzygy_ = new ArrayBasedPoly(syzygy);
                            GroebnerBases.updateBasis(groebner, sPairs, _syzygy_);
                            if (hilbertSeries != null) {
                                --hilbertDelta;
                            }
                            f4reductions.add(new ArrayList<Object>(Collections.singletonList(_syzygy_)));
                            reducers.add(syzygy);
                            reducersArray = (AMultivariatePolynomial[])reducers.stream().filter(Objects::nonNull).toArray((IntFunction<AMultivariatePolynomial[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, createArray(int ), (I)[Lcc/redberry/rings/poly/multivar/AMultivariatePolynomial;)((AMultivariatePolynomial)factory));
                            continue;
                        }
                        break;
                    }
                } else {
                    nProcessedPolynomials += subset.size();
                    ArrayList<HPolynomial<Term>> hPolynomials = new ArrayList<HPolynomial<Term>>();
                    TreeSet<DegreeVector> hMonomials = new TreeSet<DegreeVector>(monomialOrder);
                    TreeSet<DegreeVector> hAnnihilated = new TreeSet<DegreeVector>(monomialOrder);
                    for (SyzygyPair syzygy : subset) {
                        DegreeVector fiQuot = syzygy.syzygyGamma.dvDivideExact((DegreeVector)((ArrayBasedPoly)syzygy.fi).lt());
                        DegreeVector fjQuot = syzygy.syzygyGamma.dvDivideExact((DegreeVector)((ArrayBasedPoly)syzygy.fj).lt());
                        ArrayBasedPoly<Term> fiHPoly = GroebnerBases.simplify((ArrayBasedPoly)syzygy.fi, fiQuot, (List)f4reductions.get(syzygy.i));
                        ArrayBasedPoly<Term> fjHPoly = GroebnerBases.simplify((ArrayBasedPoly)syzygy.fj, fjQuot, (List)f4reductions.get(syzygy.j));
                        assert (((DegreeVector)fiHPoly.lt()).dvEquals((DegreeVector)fjHPoly.lt())) : fiHPoly.lt() + " " + fjHPoly.lt();
                        hPolynomials.add(new HPolynomial<Term>(fiHPoly, syzygy.i));
                        hPolynomials.add(new HPolynomial<Term>(fjHPoly, syzygy.j));
                        hMonomials.addAll(fiHPoly.collection());
                        hMonomials.addAll(fjHPoly.collection());
                        hAnnihilated.add((DegreeVector)fiHPoly.lt());
                    }
                    TreeSet<DegreeVector> diff = new TreeSet<DegreeVector>(monomialOrder);
                    diff.addAll(hMonomials);
                    diff.removeAll(hAnnihilated);
                    while (!diff.isEmpty()) {
                        DegreeVector dv = diff.pollLast();
                        hAnnihilated.add(dv);
                        OptionalInt divisorOpt = IntStream.range(0, groebner.size()).filter(i -> groebner.get(i) != null).filter(i -> dv.dvDivisibleBy((DegreeVector)((ArrayBasedPoly)groebner.get(i)).lt())).findAny();
                        if (!divisorOpt.isPresent()) continue;
                        int iIndex = divisorOpt.getAsInt();
                        DegreeVector quot = dv.dvDivideExact((DegreeVector)((ArrayBasedPoly)groebner.get(iIndex)).lt());
                        ArrayBasedPoly<Term> newH = GroebnerBases.simplify((ArrayBasedPoly)groebner.get(iIndex), quot, (List)f4reductions.get(iIndex));
                        hPolynomials.add(new HPolynomial<Term>(newH, iIndex));
                        TreeSet<DegreeVector> newMonomials = new TreeSet<DegreeVector>(monomialOrder);
                        newMonomials.addAll(newH.collection());
                        hMonomials.addAll(newMonomials);
                        newMonomials.removeAll(hAnnihilated);
                        diff.addAll(newMonomials);
                    }
                    DegreeVector[] hMonomialsArray = hMonomials.descendingSet().toArray(new DegreeVector[hMonomials.size()]);
                    hPolynomials.sort((a, b) -> {
                        int c = monomialOrder.compare((DegreeVector)b.hPoly.lt(), (DegreeVector)a.hPoly.lt());
                        if (c != 0) {
                            return c;
                        }
                        return Integer.compare(a.hPoly.size(), b.hPoly.size());
                    });
                    List<ArrayBasedPoly<Term>> nPlus = GroebnerBases.reduceMatrix(factory, groebner, hPolynomials, hMonomialsArray, f4reductions);
                    assert (subset.size() >= nPlus.size());
                    nRedundantSyzygies += subset.size() - nPlus.size();
                    nPlus.forEach(g -> GroebnerBases.updateBasis(groebner, sPairs, g));
                    nPlus.forEach(g -> reducers.add(factory.create(g)));
                    for (int i2 = 0; i2 < groebner.size(); ++i2) {
                        if (groebner.get(i2) != null) continue;
                        reducers.set(i2, null);
                    }
                    reducersArray = (AMultivariatePolynomial[])reducers.stream().filter(Objects::nonNull).toArray((IntFunction<AMultivariatePolynomial[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, createArray(int ), (I)[Lcc/redberry/rings/poly/multivar/AMultivariatePolynomial;)((AMultivariatePolynomial)factory));
                }
            }
            if (hilbertSeries == null || subset == null && hilbertDegree != 0) continue;
            HilbertSeries currentHPS = GroebnerBases.HilbertSeries(groebner.stream().map(MonomialSetView::lt).collect(Collectors.toList()));
            HilbertUpdate update = GroebnerBases.updateWithHPS(hilbertSeries, currentHPS, sPairs);
            if (update.finished) break;
            nHilbertRemoved += update.nRemovedPairs;
            hilbertDegree = update.currentDegree;
            hilbertDelta = update.hilbertDelta;
        }
        groebner.removeAll(Collections.singleton(null));
        List result = groebner.stream().map(factory::create).collect(Collectors.toList());
        GroebnerBases.minimizeGroebnerBases(result);
        result.sort(polyOrder);
        GroebnerBases.removeRedundant(result);
        GroebnerBases.canonicalize(result);
        return new GBResult(result, nProcessedPolynomials, nRedundantSyzygies, nHilbertRemoved);
    }

    static <Term extends AMonomial<Term>> ArrayBasedPoly<Term> simplify(ArrayBasedPoly<Term> generator, DegreeVector factor, List<ArrayBasedPoly<Term>> reductions) {
        DegreeVector desiredLeadTerm = ((DegreeVector)generator.lt()).dvMultiply(factor);
        for (int i = reductions.size() - 1; i >= 0; --i) {
            ArrayBasedPoly<Term> reduction = reductions.get(i);
            Object rLeadTerm = reduction.lt();
            if (((DegreeVector)rLeadTerm).dvEquals(desiredLeadTerm)) {
                return reduction;
            }
            if (!desiredLeadTerm.dvDivisibleBy((DegreeVector)rLeadTerm)) continue;
            DegreeVector quot = desiredLeadTerm.dvDivideExact((DegreeVector)rLeadTerm);
            Object g = reduction.clone();
            ((ArrayBasedPoly)g).multiply(quot);
            reductions.add((ArrayBasedPoly<Term>)g);
            return g;
        }
        throw new RuntimeException();
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> List<ArrayBasedPoly<Term>> reduceMatrix(Poly factory, List<ArrayBasedPoly<Term>> basis, List<HPolynomial<Term>> hPolynomials, DegreeVector[] hMonomials, List<List<ArrayBasedPoly<Term>>> f4reductions) {
        if (hPolynomials.isEmpty()) {
            return new ArrayList<ArrayBasedPoly<Term>>();
        }
        if (factory instanceof MultivariatePolynomialZp64) {
            return GroebnerBases.reduceMatrixZp64((MultivariatePolynomialZp64)factory, basis, hPolynomials, hMonomials, f4reductions);
        }
        return GroebnerBases.reduceMatrixE((MultivariatePolynomial)factory, basis, hPolynomials, hMonomials, f4reductions);
    }

    private static List<ArrayBasedPoly<MonomialZp64>> reduceMatrixZp64(MultivariatePolynomialZp64 factory, List<ArrayBasedPoly<MonomialZp64>> basis, List<HPolynomial<MonomialZp64>> hPolynomials, DegreeVector[] hMonomials, List<List<ArrayBasedPoly<MonomialZp64>>> f4reductions) {
        Object dRow;
        int i2;
        int iRow;
        int iColumn;
        IntegersZp64 ring = factory.ring;
        IMonomialAlgebra mAlgebra = factory.monomialAlgebra;
        Comparator reverseOrder = (a, b) -> factory.ordering.compare(b, a);
        int nRows = hPolynomials.size();
        int nColumns = hMonomials.length;
        int[] columnsLeadTermsFilling = new int[nColumns];
        int iOldColumnPrev = 0;
        for (HPolynomial<MonomialZp64> hPoly : hPolynomials) {
            iOldColumnPrev = iColumn = Arrays.binarySearch(hMonomials, iOldColumnPrev, hMonomials.length, hPoly.hPoly.lt(), reverseOrder);
            assert (iColumn >= 0);
            int n = iColumn;
            columnsLeadTermsFilling[n] = columnsLeadTermsFilling[n] + 1;
        }
        TIntArrayList nonPivotColumns = new TIntArrayList();
        for (iColumn = 0; iColumn < nRows + nonPivotColumns.size() && iColumn < nColumns; ++iColumn) {
            if (columnsLeadTermsFilling[iColumn] != 0) continue;
            nonPivotColumns.add(iColumn);
        }
        int[] nonPivotColumnsArr = nonPivotColumns.toArray();
        int[] columnsRearrangement = ArraysUtil.addAll(ArraysUtil.intSetDifference(ArraysUtil.sequence(0, nColumns), nonPivotColumnsArr), nonPivotColumnsArr);
        int[] columnsBackRearrangement = new int[nColumns];
        for (int i3 = 0; i3 < nColumns; ++i3) {
            columnsBackRearrangement[columnsRearrangement[i3]] = i3;
        }
        int[] columnsFilling = new int[nColumns];
        int[][] mapping = new int[nRows][];
        int[] bRowsFilling = new int[nRows];
        for (iRow = 0; iRow < nRows; ++iRow) {
            ArrayBasedPoly hPoly = hPolynomials.get((int)iRow).hPoly;
            mapping[iRow] = new int[hPoly.size()];
            iOldColumnPrev = 0;
            for (int i4 = 0; i4 < hPoly.size(); ++i4) {
                int iOldColumn;
                MonomialZp64 term = (MonomialZp64)hPoly.get(i4);
                iOldColumnPrev = iOldColumn = Arrays.binarySearch(hMonomials, iOldColumnPrev, hMonomials.length, term, reverseOrder);
                assert (iOldColumn >= 0);
                mapping[iRow][i4] = iColumn = columnsBackRearrangement[iOldColumn];
                int n = iColumn;
                columnsFilling[n] = columnsFilling[n] + 1;
                if (iColumn < nRows) continue;
                int n2 = iRow;
                bRowsFilling[n2] = bRowsFilling[n2] + 1;
            }
        }
        TIntArrayList pivots = new TIntArrayList();
        for (iColumn = 0; iColumn < nRows; ++iColumn) {
            int minFillIn = Integer.MAX_VALUE;
            int pivot = -1;
            for (iRow = iColumn; iRow < nRows; ++iRow) {
                if (mapping[iRow][0] == iColumn && bRowsFilling[iRow] < minFillIn) {
                    minFillIn = bRowsFilling[iRow];
                    pivot = iRow;
                    continue;
                }
                if (pivot != -1 && mapping[iRow][0] != iColumn) break;
            }
            if (pivot == -1) break;
            pivots.add(pivot);
        }
        bRowsFilling = null;
        int nPivotRows = pivots.size();
        for (i2 = 0; i2 < nPivotRows; ++i2) {
            int pivot = pivots.get(i2);
            Collections.swap(hPolynomials, i2, pivot);
            ArraysUtil.swap((Object[])mapping, i2, pivot);
        }
        for (i2 = 0; i2 < nPivotRows; ++i2) {
            hPolynomials.get((int)i2).hPoly.monic();
        }
        int[] bDenseColumns = IntStream.range(nPivotRows, nColumns).filter(i -> 1.0 * (double)columnsFilling[i] / (double)nRows > 0.1).map(i -> i - nPivotRows).toArray();
        SparseRowMatrixZp64 aMatrix = new SparseRowMatrixZp64(ring, nPivotRows, nPivotRows, new int[0]);
        SparseRowMatrixZp64 cMatrix = new SparseRowMatrixZp64(ring, nRows - nPivotRows, nPivotRows, new int[0]);
        SparseRowMatrixZp64 bMatrix = new SparseRowMatrixZp64(ring, nPivotRows, nColumns - nPivotRows, bDenseColumns);
        SparseRowMatrixZp64 dMatrix = new SparseRowMatrixZp64(ring, nRows - nPivotRows, nColumns - nPivotRows, bDenseColumns);
        for (iRow = 0; iRow < nRows; ++iRow) {
            ArrayBasedPoly hPoly = hPolynomials.get((int)iRow).hPoly;
            TIntArrayList acSparseCols = new TIntArrayList();
            TIntArrayList bdSparseCols = new TIntArrayList();
            TLongArrayList acSparseVals = new TLongArrayList();
            TLongArrayList bdSparseVals = new TLongArrayList();
            long[] bdDenseVals = new long[bDenseColumns.length];
            for (int i5 = 0; i5 < hPoly.size(); ++i5) {
                iColumn = mapping[iRow][i5];
                long coefficient = ((MonomialZp64)hPoly.get((int)i5)).coefficient;
                if (iColumn < nPivotRows) {
                    acSparseCols.add(iColumn);
                    acSparseVals.add(coefficient);
                    continue;
                }
                int iDense = Arrays.binarySearch(bDenseColumns, iColumn -= nPivotRows);
                if (iDense >= 0) {
                    bdDenseVals[iDense] = coefficient;
                    continue;
                }
                bdSparseCols.add(iColumn);
                bdSparseVals.add(coefficient);
            }
            int[] bdSparseColumns = bdSparseCols.toArray();
            long[] bdSparseValues = bdSparseVals.toArray();
            ArraysUtil.quickSort(bdSparseColumns, bdSparseValues);
            int[] acSparseColumns = acSparseCols.toArray();
            long[] acSparseValues = acSparseVals.toArray();
            ArraysUtil.quickSort(acSparseColumns, acSparseValues);
            if (iRow < nPivotRows) {
                aMatrix.rows[iRow] = new SparseArrayZp64(ring, nPivotRows, new int[0], acSparseColumns, new long[0], acSparseValues);
                bMatrix.rows[iRow] = new SparseArrayZp64(ring, nColumns - nPivotRows, bDenseColumns, bdSparseColumns, bdDenseVals, bdSparseValues);
                continue;
            }
            cMatrix.rows[iRow - nPivotRows] = new SparseArrayZp64(ring, nPivotRows, new int[0], acSparseColumns, new long[0], acSparseValues);
            dMatrix.rows[iRow - nPivotRows] = new SparseArrayZp64(ring, nColumns - nPivotRows, bDenseColumns, bdSparseColumns, bdDenseVals, bdSparseValues);
        }
        for (iRow = nPivotRows - 2; iRow >= 0; --iRow) {
            SparseArrayZp64 aRow = aMatrix.rows[iRow];
            long[] bRow = bMatrix.rows[iRow].toDense();
            for (int i6 = 0; i6 < aRow.sparsePositions.length; ++i6) {
                iColumn = aRow.sparsePositions[i6];
                if (iColumn == iRow) continue;
                GroebnerBases.subtractSparseFromDense(ring, bRow, bMatrix.rows[iColumn], aRow.sparseValues[i6]);
            }
            bMatrix.rows[iRow] = new SparseArrayZp64(ring, bMatrix.densePositions, bRow);
        }
        for (iRow = 0; iRow < nRows - nPivotRows; ++iRow) {
            SparseArrayZp64 cRow = cMatrix.rows[iRow];
            dRow = dMatrix.rows[iRow].toDense();
            for (int i7 = 0; i7 < cRow.sparsePositions.length; ++i7) {
                iColumn = cRow.sparsePositions[i7];
                GroebnerBases.subtractSparseFromDense(ring, (long[])dRow, bMatrix.rows[iColumn], cRow.sparseValues[i7]);
            }
            dMatrix.rows[iRow] = new SparseArrayZp64(ring, dMatrix.densePositions, (long[])dRow);
        }
        Arrays.sort(dMatrix.rows, Comparator.comparingInt(SparseArrayZp64::firstNonZeroPosition));
        dMatrix.rowReduce();
        int dShift = 0;
        for (iRow = 0; iRow < dMatrix.nRows; ++iRow) {
            dRow = dMatrix.rows[iRow];
            iColumn = iRow + dShift;
            if (iColumn >= dMatrix.nColumns) break;
            if (((SparseArrayZp64)dRow).coefficient(iColumn) == 0L) {
                --iRow;
                ++dShift;
                continue;
            }
            for (int i8 = 0; i8 < bMatrix.nRows; ++i8) {
                if (bMatrix.rows[i8].coefficient(iColumn) == 0L) continue;
                bMatrix.rows[i8].subtract((SparseArrayZp64)dRow, bMatrix.rows[i8].coefficient(iColumn));
            }
        }
        TreeSet hLeadMonomials = hPolynomials.stream().map(p -> (MonomialZp64)p.hPoly.lt()).collect(Collectors.toCollection(() -> new TreeSet(factory.ordering)));
        ArrayList<ArrayBasedPoly> nPolynomials = new ArrayList<ArrayBasedPoly>();
        for (iRow = 0; iRow < nRows; ++iRow) {
            long val;
            int i9;
            ArrayList<MonomialZp64> candidateList = new ArrayList<MonomialZp64>();
            if (iRow < nPivotRows) {
                candidateList.add(new MonomialZp64(hMonomials[columnsRearrangement[iRow]], 1L));
            }
            SparseArrayZp64 row = iRow < nPivotRows ? bMatrix.rows[iRow] : dMatrix.rows[iRow - nPivotRows];
            for (i9 = 0; i9 < row.sparsePositions.length; ++i9) {
                val = row.sparseValues[i9];
                if (val == 0L) continue;
                candidateList.add(new MonomialZp64(hMonomials[columnsRearrangement[nPivotRows + row.sparsePositions[i9]]], val));
            }
            for (i9 = 0; i9 < bDenseColumns.length; ++i9) {
                val = row.denseValues[i9];
                if (val == 0L) continue;
                candidateList.add(new MonomialZp64(hMonomials[columnsRearrangement[nPivotRows + bDenseColumns[i9]]], val));
            }
            candidateList.sort(reverseOrder);
            if (candidateList.isEmpty()) continue;
            ArrayBasedPoly poly = new ArrayBasedPoly(mAlgebra, (AMonomial[])candidateList.toArray((MonomialZp64[])mAlgebra.createArray(candidateList.size())), factory.nVariables);
            if (((MonomialZp64)poly.lt()).coefficient != 1L) {
                long factor = ring.reciprocal(((MonomialZp64)poly.lt()).coefficient);
                for (int i10 = 0; i10 < ((MonomialZp64[])poly.data).length; ++i10) {
                    ((MonomialZp64[])poly.data)[i10] = ((MonomialZp64[])poly.data)[i10].setCoefficient(ring.multiply(factor, ((MonomialZp64[])poly.data)[i10].coefficient));
                }
            }
            assert (((MonomialZp64)poly.lt()).coefficient == 1L);
            nPolynomials.add(poly);
        }
        nPolynomials.sort((a, b) -> reverseOrder.compare(a.lt(), b.lt()));
        ArrayList<ArrayBasedPoly<MonomialZp64>> nPlusPolynomials = new ArrayList<ArrayBasedPoly<MonomialZp64>>();
        for (ArrayBasedPoly candidate : nPolynomials) {
            if (!hLeadMonomials.contains(candidate.lt())) {
                nPlusPolynomials.add(candidate);
                f4reductions.add(new ArrayList<ArrayBasedPoly>(Collections.singletonList(candidate)));
                continue;
            }
            for (int iIndex = 0; iIndex < basis.size(); ++iIndex) {
                ArrayBasedPoly<MonomialZp64> g = basis.get(iIndex);
                if (g == null || !((MonomialZp64)candidate.lt()).dvDivisibleBy((DegreeVector)g.lt())) continue;
                List<ArrayBasedPoly<MonomialZp64>> reductions = f4reductions.get(iIndex);
                boolean reduced = false;
                for (int i11 = 0; i11 < reductions.size(); ++i11) {
                    ArrayBasedPoly<MonomialZp64> red = reductions.get(i11);
                    if (!((MonomialZp64)red.lt()).dvEquals((DegreeVector)candidate.lt())) continue;
                    reductions.set(i11, candidate);
                    reduced = true;
                    break;
                }
                if (reduced) continue;
                reductions.add(candidate);
            }
        }
        return nPlusPolynomials;
    }

    static void subtractSparseFromDense(IntegersZp64 ring, long[] denseArray, SparseArrayZp64 sparseArray, long factor) {
        int i;
        for (i = 0; i < sparseArray.densePositions.length; ++i) {
            denseArray[sparseArray.densePositions[i]] = ring.subtract(denseArray[sparseArray.densePositions[i]], ring.multiply(factor, sparseArray.denseValues[i]));
        }
        for (i = 0; i < sparseArray.sparsePositions.length; ++i) {
            denseArray[sparseArray.sparsePositions[i]] = ring.subtract(denseArray[sparseArray.sparsePositions[i]], ring.multiply(factor, sparseArray.sparseValues[i]));
        }
    }

    private static <E> List<ArrayBasedPoly<Monomial<E>>> reduceMatrixE(MultivariatePolynomial<E> factory, List<ArrayBasedPoly<Monomial<E>>> basis, List<HPolynomial<Monomial<E>>> hPolynomials, DegreeVector[] hMonomials, List<List<ArrayBasedPoly<Monomial<E>>>> f4reductions) {
        Object lcm;
        Object aPivot;
        SparseArray bPivotRow;
        SparseArray aPivotRow;
        int iRow;
        int iColumn;
        Ring ring = factory.ring;
        IMonomialAlgebra mAlgebra = factory.monomialAlgebra;
        Comparator reverseOrder = (a, b) -> factory.ordering.compare(b, a);
        int nRows = hPolynomials.size();
        int nColumns = hMonomials.length;
        hPolynomials.forEach(h -> h.hPoly.canonical());
        int[] columnsLeadTermsFilling = new int[nColumns];
        int iOldColumnPrev = 0;
        for (HPolynomial<Monomial<E>> hPoly : hPolynomials) {
            iOldColumnPrev = iColumn = Arrays.binarySearch(hMonomials, iOldColumnPrev, hMonomials.length, hPoly.hPoly.lt(), reverseOrder);
            assert (iColumn >= 0);
            int n = iColumn;
            columnsLeadTermsFilling[n] = columnsLeadTermsFilling[n] + 1;
        }
        TIntArrayList nonPivotColumns = new TIntArrayList();
        for (iColumn = 0; iColumn < nRows + nonPivotColumns.size() && iColumn < nColumns; ++iColumn) {
            if (columnsLeadTermsFilling[iColumn] != 0) continue;
            nonPivotColumns.add(iColumn);
        }
        int[] nonPivotColumnsArr = nonPivotColumns.toArray();
        int[] columnsRearrangement = ArraysUtil.addAll(ArraysUtil.intSetDifference(ArraysUtil.sequence(0, nColumns), nonPivotColumnsArr), nonPivotColumnsArr);
        int[] columnsBackRearrangement = new int[nColumns];
        for (int i2 = 0; i2 < nColumns; ++i2) {
            columnsBackRearrangement[columnsRearrangement[i2]] = i2;
        }
        int[] columnsFilling = new int[nColumns];
        int[][] mapping = new int[nRows][];
        int[] bRowsFilling = new int[nRows];
        for (iRow = 0; iRow < nRows; ++iRow) {
            ArrayBasedPoly hPoly = hPolynomials.get((int)iRow).hPoly;
            mapping[iRow] = new int[hPoly.size()];
            iOldColumnPrev = 0;
            for (int i3 = 0; i3 < hPoly.size(); ++i3) {
                int iOldColumn;
                Monomial term = (Monomial)hPoly.get(i3);
                iOldColumnPrev = iOldColumn = Arrays.binarySearch(hMonomials, iOldColumnPrev, hMonomials.length, term, reverseOrder);
                assert (iOldColumn >= 0);
                mapping[iRow][i3] = iColumn = columnsBackRearrangement[iOldColumn];
                int n = iColumn;
                columnsFilling[n] = columnsFilling[n] + 1;
                if (iColumn < nRows) continue;
                int n2 = iRow;
                bRowsFilling[n2] = bRowsFilling[n2] + 1;
            }
        }
        TIntArrayList pivots = new TIntArrayList();
        for (iColumn = 0; iColumn < nRows; ++iColumn) {
            int minFillIn = Integer.MAX_VALUE;
            int pivot = -1;
            boolean unitLeadTerm = false;
            for (iRow = iColumn; iRow < nRows; ++iRow) {
                if (mapping[iRow][0] == iColumn) {
                    boolean ult = ring.isUnit(((Monomial)hPolynomials.get((int)iRow).hPoly.lt()).coefficient);
                    if (!unitLeadTerm && ult) {
                        minFillIn = bRowsFilling[iRow];
                        pivot = iRow;
                        unitLeadTerm = true;
                    } else if (unitLeadTerm == ult && bRowsFilling[iRow] < minFillIn) {
                        minFillIn = bRowsFilling[iRow];
                        pivot = iRow;
                    }
                    assert (pivot != -1);
                    continue;
                }
                if (pivot != -1 && mapping[iRow][0] != iColumn) break;
            }
            if (pivot == -1) break;
            pivots.add(pivot);
        }
        bRowsFilling = null;
        int nPivotRows = pivots.size();
        for (int i4 = 0; i4 < nPivotRows; ++i4) {
            int pivot = pivots.get(i4);
            Collections.swap(hPolynomials, i4, pivot);
            ArraysUtil.swap((Object[])mapping, i4, pivot);
        }
        int[] bDenseColumns = IntStream.range(nPivotRows, nColumns).filter(i -> 1.0 * (double)columnsFilling[i] / (double)nRows > 0.1).map(i -> i - nPivotRows).toArray();
        SparseRowMatrix aMatrix = new SparseRowMatrix(ring, nPivotRows, nPivotRows, new int[0]);
        SparseRowMatrix cMatrix = new SparseRowMatrix(ring, nRows - nPivotRows, nPivotRows, aMatrix.densePositions);
        SparseRowMatrix bMatrix = new SparseRowMatrix(ring, nPivotRows, nColumns - nPivotRows, bDenseColumns);
        SparseRowMatrix dMatrix = new SparseRowMatrix(ring, nRows - nPivotRows, nColumns - nPivotRows, bDenseColumns);
        for (iRow = 0; iRow < nRows; ++iRow) {
            ArrayBasedPoly hPoly = hPolynomials.get((int)iRow).hPoly;
            TIntArrayList acSparseCols = new TIntArrayList();
            TIntArrayList bdSparseCols = new TIntArrayList();
            ArrayList acSparseVals = new ArrayList();
            ArrayList bdSparseVals = new ArrayList();
            E[] bdDenseVals = ring.createZeroesArray(bDenseColumns.length);
            for (int i5 = 0; i5 < hPoly.size(); ++i5) {
                iColumn = mapping[iRow][i5];
                Object coefficient = ((Monomial)hPoly.get((int)i5)).coefficient;
                if (iColumn < nPivotRows) {
                    acSparseCols.add(iColumn);
                    acSparseVals.add(coefficient);
                    continue;
                }
                int iDense = Arrays.binarySearch(bDenseColumns, iColumn -= nPivotRows);
                if (iDense >= 0) {
                    bdDenseVals[iDense] = coefficient;
                    continue;
                }
                bdSparseCols.add(iColumn);
                bdSparseVals.add(coefficient);
            }
            int[] bdSparseColumns = bdSparseCols.toArray();
            int[] bdSparseValues = bdSparseVals.toArray(ring.createArray(bdSparseVals.size()));
            ArraysUtil.quickSort(bdSparseColumns, (Object[])bdSparseValues);
            int[] acSparseColumns = acSparseCols.toArray();
            int[] acSparseValues = acSparseVals.toArray(ring.createArray(acSparseVals.size()));
            ArraysUtil.quickSort(acSparseColumns, (Object[])acSparseValues);
            if (iRow < nPivotRows) {
                aMatrix.rows[iRow] = new SparseArray<int>(ring, nPivotRows, aMatrix.densePositions, acSparseColumns, ring.createArray(false), acSparseValues);
                bMatrix.rows[iRow] = new SparseArray<int>(ring, nColumns - nPivotRows, bDenseColumns, bdSparseColumns, bdDenseVals, bdSparseValues);
                continue;
            }
            cMatrix.rows[iRow - nPivotRows] = new SparseArray<int>(ring, nPivotRows, cMatrix.densePositions, acSparseColumns, ring.createArray(false), acSparseValues);
            dMatrix.rows[iRow - nPivotRows] = new SparseArray<int>(ring, nColumns - nPivotRows, bDenseColumns, bdSparseColumns, bdDenseVals, bdSparseValues);
        }
        iRow = nPivotRows - 2;
        while (iRow >= 0) {
            SparseArray aRow = aMatrix.rows[iRow];
            E[] bRow = bMatrix.rows[iRow].toDense();
            for (int i6 = aRow.sparsePositions.length - 1; i6 >= 0; --i6) {
                iColumn = aRow.sparsePositions[i6];
                if (iColumn == iRow) continue;
                assert (iColumn > iRow);
                aPivotRow = aMatrix.rows[iColumn];
                bPivotRow = bMatrix.rows[iColumn];
                Object aNonDiagonal = aRow.sparseValues[i6];
                aPivot = aPivotRow.coefficient(iColumn);
                assert (!ring.isZero(aPivot));
                lcm = ring.lcm(aNonDiagonal, aPivot);
                Object rowFactor = ring.divideExact(lcm, aNonDiagonal);
                Object pivotFactor = ring.divideExact(lcm, aPivot);
                GroebnerBases.subtractSparseFromDense(ring, bRow, rowFactor, bPivotRow, pivotFactor);
                aRow.multiply(rowFactor);
            }
            bMatrix.rows[iRow] = new SparseArray(ring, bMatrix.densePositions, bRow);
            Object aRowDiagonalValue = aRow.coefficient(iRow);
            assert (!ring.isZero(aRowDiagonalValue));
            Object abRowContent = bMatrix.rows[iRow].content(aRowDiagonalValue);
            bMatrix.rows[iRow].divideExact(abRowContent);
            aRow.sparsePositions = new int[]{iRow--};
            aRow.sparseValues = ring.createArray(ring.divideExact(aRowDiagonalValue, abRowContent));
        }
        for (iRow = 0; iRow < nRows - nPivotRows; ++iRow) {
            SparseArray cRow = cMatrix.rows[iRow];
            E[] dRow = dMatrix.rows[iRow].toDense();
            for (int i7 = cRow.sparsePositions.length - 1; i7 >= 0; --i7) {
                iColumn = cRow.sparsePositions[i7];
                aPivotRow = aMatrix.rows[iColumn];
                bPivotRow = bMatrix.rows[iColumn];
                Object cElement = cRow.sparseValues[i7];
                aPivot = aPivotRow.coefficient(iColumn);
                assert (!ring.isZero(aPivot));
                lcm = ring.lcm(cElement, aPivot);
                Object dFactor = ring.divideExact(lcm, cElement);
                Object bFactor = ring.divideExact(lcm, aPivot);
                GroebnerBases.subtractSparseFromDense(ring, dRow, dFactor, bPivotRow, bFactor);
                cRow.multiply(dFactor);
            }
            dMatrix.rows[iRow] = new SparseArray(ring, dMatrix.densePositions, dRow);
            dMatrix.rows[iRow].primitivePart();
        }
        Arrays.sort(dMatrix.rows, Comparator.comparingInt(SparseArray::firstNonZeroPosition));
        dMatrix.rowReduce();
        int dShift = 0;
        for (iRow = 0; iRow < dMatrix.nRows; ++iRow) {
            SparseArray dPivotRow = dMatrix.rows[iRow];
            iColumn = iRow + dShift;
            if (iColumn >= dMatrix.nColumns) break;
            if (ring.isZero(dPivotRow.coefficient(iColumn))) {
                --iRow;
                ++dShift;
                continue;
            }
            for (int i8 = 0; i8 < bMatrix.nRows; ++i8) {
                if (ring.isZero(bMatrix.rows[i8].coefficient(iColumn))) continue;
                SparseArray bRow = bMatrix.rows[i8];
                SparseArray aRow = aMatrix.rows[i8];
                Object dPivot = dPivotRow.coefficient(iColumn);
                Object bElement = bRow.coefficient(iColumn);
                lcm = ring.lcm(bElement, dPivot);
                Object bFactor = ring.divideExact(lcm, bElement);
                Object dFactor = ring.divideExact(lcm, dPivot);
                bRow.multiply(bFactor);
                bRow.subtract(dPivotRow, dFactor);
                aRow.multiply(bFactor);
                Object abContent = bRow.content(aMatrix.rows[i8].coefficient(i8));
                bRow.divideExact(abContent);
                aRow.divideExact(abContent);
                assert (ring.isZero(bRow.coefficient(iColumn)));
            }
        }
        TreeSet hLeadMonomials = hPolynomials.stream().map(p -> (Monomial)p.hPoly.lt()).collect(Collectors.toCollection(() -> new TreeSet(factory.ordering)));
        ArrayList<ArrayBasedPoly> nPolynomials = new ArrayList<ArrayBasedPoly>();
        for (iRow = 0; iRow < nRows; ++iRow) {
            Object val;
            int i9;
            ArrayList candidateList = new ArrayList();
            if (iRow < nPivotRows) {
                Object cf = aMatrix.rows[iRow].coefficient(iRow);
                assert (!ring.isZero(cf));
                candidateList.add(new Monomial(hMonomials[columnsRearrangement[iRow]], cf));
            }
            SparseArray row = iRow < nPivotRows ? bMatrix.rows[iRow] : dMatrix.rows[iRow - nPivotRows];
            for (i9 = 0; i9 < row.sparsePositions.length; ++i9) {
                val = row.sparseValues[i9];
                if (ring.isZero(val)) continue;
                candidateList.add(new Monomial(hMonomials[columnsRearrangement[nPivotRows + row.sparsePositions[i9]]], val));
            }
            for (i9 = 0; i9 < bDenseColumns.length; ++i9) {
                val = row.denseValues[i9];
                if (ring.isZero(val)) continue;
                candidateList.add(new Monomial(hMonomials[columnsRearrangement[nPivotRows + bDenseColumns[i9]]], val));
            }
            candidateList.sort(reverseOrder);
            if (candidateList.isEmpty()) continue;
            ArrayBasedPoly poly = new ArrayBasedPoly(mAlgebra, (AMonomial[])candidateList.toArray((Monomial[])mAlgebra.createArray(candidateList.size())), factory.nVariables);
            poly.canonical();
            nPolynomials.add(poly);
        }
        nPolynomials.sort((a, b) -> reverseOrder.compare(a.lt(), b.lt()));
        ArrayList<ArrayBasedPoly<Monomial<ArrayBasedPoly>>> nPlusPolynomials = new ArrayList<ArrayBasedPoly<Monomial<ArrayBasedPoly>>>();
        for (ArrayBasedPoly candidate : nPolynomials) {
            if (!hLeadMonomials.contains(candidate.lt())) {
                nPlusPolynomials.add(candidate);
                f4reductions.add(new ArrayList<ArrayBasedPoly>(Collections.singletonList(candidate)));
                continue;
            }
            for (int iIndex = 0; iIndex < basis.size(); ++iIndex) {
                ArrayBasedPoly<Monomial<E>> g = basis.get(iIndex);
                if (g == null || !((Monomial)candidate.lt()).dvDivisibleBy((DegreeVector)g.lt())) continue;
                List<ArrayBasedPoly<Monomial<ArrayBasedPoly>>> reductions = f4reductions.get(iIndex);
                boolean reduced = false;
                for (int i10 = 0; i10 < reductions.size(); ++i10) {
                    ArrayBasedPoly<Monomial<E>> red = reductions.get(i10);
                    if (!((Monomial)red.lt()).dvEquals((DegreeVector)candidate.lt())) continue;
                    reductions.set(i10, candidate);
                    reduced = true;
                    break;
                }
                if (reduced) continue;
                reductions.add(candidate);
            }
        }
        return nPlusPolynomials;
    }

    static <E> void subtractSparseFromDense(Ring<E> ring, E[] denseArray, SparseArray<E> sparseArray, E factor) {
        int i;
        for (i = 0; i < sparseArray.densePositions.length; ++i) {
            denseArray[sparseArray.densePositions[i]] = ring.subtract(denseArray[sparseArray.densePositions[i]], ring.multiply(factor, (E)sparseArray.denseValues[i]));
        }
        for (i = 0; i < sparseArray.sparsePositions.length; ++i) {
            denseArray[sparseArray.sparsePositions[i]] = ring.subtract(denseArray[sparseArray.sparsePositions[i]], ring.multiply(factor, (E)sparseArray.sparseValues[i]));
        }
    }

    static <E> void subtractSparseFromDense(Ring<E> ring, E[] denseArray, E denseFactor, SparseArray<E> sparseArray, E sparseFactor) {
        int i;
        if (!ring.isOne(denseFactor)) {
            for (i = 0; i < denseArray.length; ++i) {
                denseArray[i] = ring.multiply(denseArray[i], denseFactor);
            }
        }
        for (i = 0; i < sparseArray.densePositions.length; ++i) {
            int dPosition = sparseArray.densePositions[i];
            denseArray[dPosition] = ring.subtract(denseArray[dPosition], ring.multiply(sparseFactor, (E)sparseArray.denseValues[i]));
        }
        for (i = 0; i < sparseArray.sparsePositions.length; ++i) {
            int sPosition = sparseArray.sparsePositions[i];
            denseArray[sPosition] = ring.subtract(denseArray[sPosition], ring.multiply(sparseFactor, (E)sparseArray.sparseValues[i]));
        }
    }

    private static boolean isSorted(int[] arr) {
        for (int i = 1; i < arr.length; ++i) {
            if (arr[i - 1] < arr[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isMonomialIdeal(List<? extends AMultivariatePolynomial> ideal) {
        return ideal.stream().allMatch(AMultivariatePolynomial::isMonomial);
    }

    public static boolean isHomogeneousIdeal(List<? extends AMultivariatePolynomial> ideal) {
        return ideal.stream().allMatch(AMultivariatePolynomial::isHomogeneous);
    }

    public static List<DegreeVector> leadTermsSet(List<? extends AMultivariatePolynomial> ideal) {
        return ideal.stream().map(AMultivariatePolynomial::lt).collect(Collectors.toList());
    }

    public static HilbertSeries HilbertSeriesOfLeadingTermsSet(List<? extends AMultivariatePolynomial> ideal) {
        if (!GroebnerBases.isHomogeneousIdeal(ideal) && !MonomialOrder.isGradedOrder(ideal.get((int)0).ordering)) {
            throw new IllegalArgumentException("Basis should be homogeneous or use graded (degree compatible) monomial order");
        }
        if (ideal.stream().anyMatch(IPolynomial::isZero)) {
            return new HilbertSeries(UnivariatePolynomial.one(Rings.Q), ideal.get((int)0).nVariables);
        }
        return GroebnerBases.HilbertSeries(GroebnerBases.leadTermsSet(ideal));
    }

    static void reduceMonomialIdeal(List<DegreeVector> basis) {
        block0: for (int i = basis.size() - 1; i >= 1; --i) {
            for (int j = i - 1; j >= 0; --j) {
                DegreeVector pj;
                DegreeVector pi = basis.get(i);
                if (pi.dvDivisibleBy(pj = basis.get(j))) {
                    basis.remove(i);
                    continue block0;
                }
                if (!pj.dvDivisibleBy(pi)) continue;
                basis.remove(j);
                --i;
            }
        }
    }

    public static HilbertSeries HilbertSeries(List<DegreeVector> ideal) {
        ideal = new ArrayList<DegreeVector>(ideal);
        GroebnerBases.reduceMonomialIdeal(ideal);
        UnivariatePolynomial<Rational> initialNumerator = GroebnerBases.HilbertSeriesNumerator(ideal).mapCoefficients(Rings.Q, c -> new Rational<BigInteger>(Rings.Z, (BigInteger)c));
        return new HilbertSeries(initialNumerator, ideal.get(0).nVariables());
    }

    private static UnivariatePolynomial<BigInteger> HilbertSeriesNumerator(List<DegreeVector> ideal) {
        int var;
        UnivariateRing<Integers> uniRing = Rings.UnivariateRing(Rings.Z);
        if (ideal.isEmpty()) {
            return (UnivariatePolynomial)uniRing.getOne();
        }
        if (ideal.size() == 1 && ideal.get(0).isZeroVector()) {
            return (UnivariatePolynomial)uniRing.getZero();
        }
        if (ideal.stream().allMatch(m -> m.totalDegree == 1)) {
            return uniRing.pow(((UnivariatePolynomial)uniRing.getOne()).subtract((UnivariatePolynomial)uniRing.variable(0)), ideal.size());
        }
        DegreeVector pivotMonomial = ideal.stream().filter(m -> m.totalDegree > 1).findAny().get();
        int nVariables = pivotMonomial.exponents.length;
        for (var = 0; var < nVariables && pivotMonomial.exponents[var] == 0; ++var) {
        }
        int variable = var;
        int[] varExponents = new int[nVariables];
        varExponents[variable] = 1;
        DegreeVector varMonomial = new DegreeVector(varExponents, 1);
        List<DegreeVector> sum = ideal.stream().filter(m -> m.exponents[variable] == 0).collect(Collectors.toList());
        sum.add(varMonomial);
        List<DegreeVector> quot = ideal.stream().map(m -> m.exponents[variable] > 0 ? m.dvDivideOrNull(variable, 1) : m).collect(Collectors.toList());
        GroebnerBases.reduceMonomialIdeal(quot);
        return GroebnerBases.HilbertSeriesNumerator(sum).add((UnivariatePolynomial<BigInteger>)GroebnerBases.HilbertSeriesNumerator(quot).shiftRight(1));
    }

    public static GBResult<Monomial<BigInteger>, MultivariatePolynomial<BigInteger>> ModularGB(List<MultivariatePolynomial<BigInteger>> ideal, Comparator<DegreeVector> monomialOrder) {
        return GroebnerBases.ModularGB(ideal, monomialOrder, null, false);
    }

    public static GBResult<Monomial<BigInteger>, MultivariatePolynomial<BigInteger>> ModularGB(List<MultivariatePolynomial<BigInteger>> ideal, Comparator<DegreeVector> monomialOrder, HilbertSeries hilbertSeries) {
        return GroebnerBases.ModularGB(ideal, monomialOrder, hilbertSeries, false);
    }

    public static GBResult<Monomial<BigInteger>, MultivariatePolynomial<BigInteger>> ModularGB(List<MultivariatePolynomial<BigInteger>> ideal, Comparator<DegreeVector> monomialOrder, HilbertSeries hilbertSeries, boolean trySparse) {
        return GroebnerBases.ModularGB(ideal, monomialOrder, GroebnerBases::GroebnerBasisInGF, (p, o, s) -> GroebnerBases.GroebnerBasisInZ(p, o, s, false), BigInteger.ONE.shiftLeft(59), hilbertSeries, trySparse);
    }

    static List<MultivariatePolynomialZp64> mod(List<MultivariatePolynomial<BigInteger>> polys, long modulus) {
        IntegersZp64 ring = Rings.Zp64(modulus);
        IntegersZp gRing = ring.asGenericRing();
        return polys.stream().map(p -> MultivariatePolynomial.asOverZp64(p.setRing(gRing))).collect(Collectors.toList());
    }

    public static GBResult<Monomial<BigInteger>, MultivariatePolynomial<BigInteger>> ModularGB(List<MultivariatePolynomial<BigInteger>> ideal, Comparator<DegreeVector> monomialOrder, GroebnerAlgorithm modularAlgorithm, GroebnerAlgorithm defaultAlgorithm, BigInteger firstPrime, HilbertSeries hilbertSeries, boolean trySparse) {
        assert (GroebnerBases.isHomogeneousIdeal(ideal) || MonomialOrder.isGradedOrder(monomialOrder));
        if ((ideal = GroebnerBases.prepareGenerators(ideal, monomialOrder)).size() == 1) {
            return GBResult.trivial(GroebnerBases.canonicalize(ideal));
        }
        GBResult baseResult = null;
        BigInteger basePrime = null;
        HilbertSeries baseSeries = hilbertSeries;
        List baseBasis = null;
        PrimesIterator0 primes = new PrimesIterator0(firstPrime);
        List previousGBCandidate = null;
        int nModIterations = 0;
        block0: while (baseResult == null || !baseResult.isBuchbergerType() || nModIterations <= 4 || Math.abs(baseResult.nProcessedPolynomials - baseResult.nZeroReductions - baseBasis.size()) >= 9) {
            GBResult modResult;
            List bModBasis;
            GBResult r;
            List<MultivariatePolynomialZp64> modGenerators;
            BigInteger prime = primes.next();
            IntegersZp ring = Rings.Zp(prime);
            if (prime.isLong()) {
                modGenerators = GroebnerBases.mod(ideal, prime.longValueExact());
                r = modularAlgorithm.GroebnerBasis(modGenerators, monomialOrder, null);
                bModBasis = r.stream().map(MultivariatePolynomialZp64::toBigPoly).collect(Collectors.toList());
                modResult = r;
            } else {
                modGenerators = ideal.stream().map(p -> p.setRing(ring)).collect(Collectors.toList());
                r = modularAlgorithm.GroebnerBasis(modGenerators, monomialOrder, null);
                bModBasis = r.list;
                modResult = r;
            }
            bModBasis.sort((a, b) -> monomialOrder.compare((DegreeVector)a.lt(), (DegreeVector)b.lt()));
            HilbertSeries modSeries = GroebnerBases.HilbertSeries(GroebnerBases.leadTermsSet(bModBasis));
            if (baseBasis == null) {
                List<MultivariatePolynomial<BigInteger>> solvedGB;
                int nSparseUnknowns;
                if (trySparse && (nSparseUnknowns = bModBasis.stream().mapToInt(p -> p.size() - 1).sum()) < 32 && modResult.nProcessedPolynomials > 64 && (solvedGB = GroebnerBases.solveGB(ideal, bModBasis.stream().map(AMultivariatePolynomial::getSkeleton).collect(Collectors.toList()), monomialOrder)) != null && GroebnerBases.isGroebnerBasis(ideal, solvedGB, monomialOrder)) {
                    return GBResult.notBuchberger(solvedGB);
                }
                baseBasis = bModBasis;
                basePrime = prime;
                baseSeries = modSeries;
                baseResult = modResult;
                nModIterations = 0;
                continue;
            }
            int c = ModHilbertSeriesComparator.compare(baseSeries, modSeries);
            if (c < 0) continue;
            if (c > 0) {
                baseBasis = bModBasis;
                basePrime = prime;
                baseSeries = modSeries;
                baseResult = modResult;
                nModIterations = 0;
                continue;
            }
            int size = Math.min(baseBasis.size(), bModBasis.size());
            for (int i = 0; i < size; ++i) {
                c = monomialOrder.compare((DegreeVector)((MultivariatePolynomial)baseBasis.get(i)).lt(), (DegreeVector)((MultivariatePolynomial)bModBasis.get(i)).lt());
                if (c > 0) continue block0;
                if (c >= 0) continue;
                baseBasis = bModBasis;
                basePrime = ring.modulus;
                baseSeries = modSeries;
                baseResult = modResult;
                nModIterations = 0;
                continue block0;
            }
            if (baseBasis.size() < bModBasis.size()) {
                baseBasis = bModBasis;
                basePrime = ring.modulus;
                baseSeries = modSeries;
                baseResult = modResult;
                nModIterations = 0;
                continue;
            }
            if (baseBasis.size() > bModBasis.size()) continue;
            ++nModIterations;
            ChineseRemainders.ChineseRemaindersMagic<BigInteger> magic = ChineseRemainders.createMagic(Rings.Z, basePrime, prime);
            for (int iGenerator = 0; iGenerator < baseBasis.size(); ++iGenerator) {
                Object baseGenerator = (MultivariatePolynomial)baseBasis.get(iGenerator);
                PairedIterator iterator = new PairedIterator((MultivariatePolynomial)baseGenerator, (MultivariatePolynomial)bModBasis.get(iGenerator));
                baseGenerator = ((MultivariatePolynomial)baseGenerator).createZero();
                while (iterator.hasNext()) {
                    iterator.advance();
                    Monomial baseTerm = (Monomial)iterator.aTerm;
                    BigInteger crt = ChineseRemainders.ChineseRemainders(Rings.Z, magic, (BigInteger)baseTerm.coefficient, (BigInteger)((Monomial)iterator.bTerm).coefficient);
                    ((AMultivariatePolynomial)baseGenerator).add(baseTerm.setCoefficient(crt));
                }
                baseBasis.set(iGenerator, baseGenerator);
            }
            basePrime = basePrime.multiply(prime);
            ArrayList<MultivariatePolynomial<Rational<MultivariatePolynomial<Rational<BigInteger>>>>> gbCandidateFrac = new ArrayList<MultivariatePolynomial<Rational<MultivariatePolynomial<Rational<BigInteger>>>>>();
            for (MultivariatePolynomial gen : baseBasis) {
                MultivariatePolynomial<Rational<BigInteger>> gbGen = GroebnerBases.reconstructPoly(gen, basePrime);
                if (gbGen == null) continue block0;
                gbCandidateFrac.add(gbGen);
            }
            List gbCandidate = GroebnerBases.toIntegral(gbCandidateFrac);
            if (gbCandidate.equals(previousGBCandidate) && GroebnerBases.isGroebnerBasis(ideal, gbCandidate, monomialOrder)) {
                return GBResult.notBuchberger(GroebnerBases.canonicalize(gbCandidate));
            }
            previousGBCandidate = gbCandidate;
        }
        return defaultAlgorithm.GroebnerBasis(ideal, monomialOrder, hilbertSeries);
    }

    private static MultivariatePolynomial<Rational<BigInteger>> reconstructPoly(MultivariatePolynomial<BigInteger> base, BigInteger prime) {
        MultivariatePolynomial<BigInteger> result = MultivariatePolynomial.zero(base.nVariables, Rings.Q, base.ordering);
        for (Monomial monomial : base) {
            BigInteger[] numDen = RationalReconstruction.reconstructFareyErrorTolerant((BigInteger)monomial.coefficient, prime);
            if (numDen == null) {
                return null;
            }
            result.add(new Monomial<Rational<BigInteger>>(monomial, new Rational<BigInteger>(Rings.Z, numDen[0], numDen[1])));
        }
        return result;
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> List<Poly> solveGB(List<Poly> generators, List<Collection<DegreeVector>> gbSkeleton, Comparator<DegreeVector> monomialOrder) {
        return GroebnerBases.solveGB0(generators, gbSkeleton.stream().map(c -> {
            TreeSet set = new TreeSet(monomialOrder);
            set.addAll(c);
            return set;
        }).collect(Collectors.toList()), monomialOrder);
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> List<Poly> solveGB0(List<Poly> generators, List<SortedSet<DegreeVector>> gbSkeleton, Comparator<DegreeVector> monomialOrder) {
        AMultivariatePolynomial factory = (AMultivariatePolynomial)((AMultivariatePolynomial)generators.get(0)).createZero();
        if (!factory.isOverField()) {
            List gb2 = GroebnerBases.solveGB0(GroebnerBases.toFractions(generators), gbSkeleton, monomialOrder);
            if (gb2 == null) {
                return null;
            }
            return GroebnerBases.canonicalize(GroebnerBases.toIntegral(gb2));
        }
        int nUnknowns = gbSkeleton.stream().mapToInt(p -> p.size() - 1).sum();
        MultivariateRing cfRing = Rings.MultivariateRing(factory.setNVariables(nUnknowns));
        MultivariateRing pRing = Rings.MultivariateRing(factory.nVariables, cfRing, monomialOrder);
        AtomicInteger varCounter = new AtomicInteger(0);
        MultivariatePolynomial[] gbCandidate = (MultivariatePolynomial[])gbSkeleton.stream().map(p -> {
            MultivariatePolynomial head = (MultivariatePolynomial)pRing.create((DegreeVector)p.last());
            MultivariatePolynomial tail = p.headSet((DegreeVector)p.last()).stream().map(t -> ((MultivariatePolynomial)pRing.create((DegreeVector)t)).multiply(cfRing.variable(varCounter.getAndIncrement()))).reduce((MultivariatePolynomial)pRing.getZero(), (a, b) -> (MultivariatePolynomial)a.add(b));
            return (MultivariatePolynomial)head.add(tail);
        }).toArray(MultivariatePolynomial[]::new);
        Object uTerm = factory.monomialAlgebra.getUnitTerm(nUnknowns);
        List initialIdeal = generators.stream().map(p -> (MultivariatePolynomial)((MultivariatePolynomial)pRing.factory()).create((Iterable)p.collection().stream().map(t -> new Monomial((DegreeVector)t, ((AMultivariatePolynomial)cfRing.factory()).create(uTerm.setCoefficientFrom(t)))).collect(Collectors.toList()))).collect(Collectors.toList());
        ArrayList _tmp_gb_ = new ArrayList(initialIdeal);
        SyzygyTreeSet sPairsSet = new SyzygyTreeSet(new TreeSet(GroebnerBases.defaultSelectionStrategy(monomialOrder)));
        Arrays.stream(gbCandidate).forEach(gb -> GroebnerBases.updateBasis(_tmp_gb_, sPairsSet, gb));
        ArrayList source = new ArrayList();
        initialIdeal.forEach(p -> source.add(new EqSupplierPoly(p)));
        sPairsSet.allPairs().forEach(p -> source.add(new EqSupplierSyzygy(initialIdeal, gbCandidate, p)));
        source.sort((a, b) -> monomialOrder.compare(a.signature(), b.signature()));
        ArrayList<Equation<Term, Poly>> nonLinearEquations = new ArrayList<Equation<Term, Poly>>();
        EquationSolver<Term, AMultivariatePolynomial> solver = GroebnerBases.createSolver(factory);
        TIntHashSet solvedVariables = new TIntHashSet();
        for (EqSupplier eqSupplier : source) {
            if (solvedVariables.size() == nUnknowns) {
                return GroebnerBases.gbSolution(factory, gbCandidate);
            }
            MultivariatePolynomial next = eqSupplier.poly();
            LinearSolver.SystemInfo result = GroebnerBases.reduceAndSolve(next, gbCandidate, solver, nonLinearEquations);
            if (result == LinearSolver.SystemInfo.Inconsistent) {
                return null;
            }
            solvedVariables.addAll(solver.solvedVariables);
            if (solver.solvedVariables.size() > 0) {
                solver.simplifyGB(gbCandidate);
            }
            solver.clear();
            if (solvedVariables.size() <= 128 || !(1.0 * (double)solvedVariables.size() / (double)nUnknowns >= 0.1)) continue;
            GroebnerBases.dropSolvedVariables(solvedVariables, initialIdeal, gbCandidate, nonLinearEquations, solver);
            nUnknowns -= solvedVariables.size();
            solvedVariables.clear();
        }
        if (solver.nSolved() == nUnknowns) {
            return GroebnerBases.gbSolution(factory, gbCandidate);
        }
        return null;
    }

    static int[] usedVars(AMultivariatePolynomial equation) {
        int[] degrees = equation.degrees();
        TIntArrayList usedVars = new TIntArrayList();
        for (int i = 0; i < degrees.length; ++i) {
            if (degrees[i] <= 0) continue;
            usedVars.add(i);
        }
        return usedVars.toArray();
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> MultivariatePolynomial<Poly> getFi(int i, List<MultivariatePolynomial<Poly>> initialIdeal, MultivariatePolynomial<Poly>[] gbCandidate) {
        return i < initialIdeal.size() ? initialIdeal.get(i) : gbCandidate[i - initialIdeal.size()];
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> void dropSolvedVariables(TIntHashSet solvedVariables, List<MultivariatePolynomial<Poly>> initialIdeal, MultivariatePolynomial<Poly>[] gbCandidate, List<Equation<Term, Poly>> nonLinearEquations, EquationSolver<Term, Poly> solver) {
        if (solver.nSolved() != 0) {
            throw new IllegalArgumentException();
        }
        int[] solved = solvedVariables.toArray();
        Arrays.sort(solved);
        MultivariateRing oldPRing = (MultivariateRing)initialIdeal.get((int)0).ring;
        MultivariateRing pRing = Rings.MultivariateRing(((AMultivariatePolynomial)oldPRing.factory()).dropVariables(solved));
        initialIdeal.replaceAll(p -> p.mapCoefficients(pRing, cf -> cf.dropVariables(solved)));
        Arrays.asList(gbCandidate).replaceAll(p -> p.mapCoefficients(pRing, cf -> cf.dropVariables(solved)));
        int[] vMapping = new int[oldPRing.nVariables()];
        int c = 0;
        for (int i = 0; i < vMapping.length; ++i) {
            vMapping[i] = Arrays.binarySearch(solved, i) >= 0 ? -1 : c++;
        }
        nonLinearEquations.forEach(eq -> eq.dropVariables(vMapping));
        solver.equations.forEach(eq -> eq.dropVariables(vMapping));
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> List<Poly> gbSolution(Poly factory, MultivariatePolynomial<Poly>[] gbCandidate) {
        ArrayList<Poly> result = new ArrayList<Poly>();
        for (MultivariatePolynomial<Poly> gbElement : gbCandidate) {
            if (!gbElement.stream().allMatch(IPolynomial::isConstant)) {
                return null;
            }
            result.add(factory.create((Iterable)gbElement.collection().stream().map(t -> ((AMonomial)((AMultivariatePolynomial)t.coefficient).lt()).setDegreeVector((DegreeVector)t)).collect(Collectors.toList())));
        }
        return GroebnerBases.canonicalize(result);
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> LinearSolver.SystemInfo reduceAndSolve(MultivariatePolynomial<Poly> toReduce, MultivariatePolynomial<Poly>[] gbCandidate, EquationSolver<Term, Poly> solver, List<Equation<Term, Poly>> nonLinearEquations) {
        MultivariatePolynomial remainder = (MultivariatePolynomial)MultivariateDivision.remainder(toReduce, gbCandidate);
        if (remainder.isZero()) {
            return LinearSolver.SystemInfo.Consistent;
        }
        int nSolved = solver.solvedVariables.size();
        boolean newLinearEqsObtained = false;
        for (AMultivariatePolynomial cf : remainder.coefficients()) {
            if (cf.isConstant()) {
                return LinearSolver.SystemInfo.Inconsistent;
            }
            cf = (AMultivariatePolynomial)solver.simplify(cf).monic();
            Equation eq = new Equation(cf);
            if (eq.isLinear) {
                boolean isNewEq = solver.addEquation(eq);
                if (!isNewEq) continue;
                newLinearEqsObtained = true;
                continue;
            }
            if (nonLinearEquations.contains(eq)) continue;
            nonLinearEquations.add(eq);
        }
        if (!newLinearEqsObtained) {
            return LinearSolver.SystemInfo.Consistent;
        }
        if (solver.solvedVariables.size() > nSolved) {
            GroebnerBases.updateNonLinear(solver, nonLinearEquations);
        }
        LinearSolver.SystemInfo result;
        while ((result = solver.solve()) != LinearSolver.SystemInfo.Inconsistent) {
            if (result == LinearSolver.SystemInfo.UnderDetermined) {
                return LinearSolver.SystemInfo.Consistent;
            }
            GroebnerBases.updateNonLinear(solver, nonLinearEquations);
        }
        return LinearSolver.SystemInfo.Inconsistent;
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> void updateNonLinear(EquationSolver<Term, Poly> solver, List<Equation<Term, Poly>> nonLinearEquations) {
        boolean nlReduced;
        do {
            nlReduced = false;
            for (int i = nonLinearEquations.size() - 1; i >= 0; --i) {
                Equation<Term, Poly> eq = solver.simplify(nonLinearEquations.get(i));
                if (((AMultivariatePolynomial)eq.reducedEquation).isZero()) {
                    nonLinearEquations.remove(i);
                    continue;
                }
                if (GroebnerBases.isLinear(eq.reducedEquation)) {
                    nlReduced = true;
                    solver.addEquation(eq);
                    nonLinearEquations.remove(i);
                    continue;
                }
                nonLinearEquations.set(i, eq);
            }
        } while (nlReduced);
    }

    static boolean isLinear(AMultivariatePolynomial<? extends AMonomial, ?> poly) {
        return poly.collection().stream().allMatch(t -> t.totalDegree <= 1);
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> EquationSolver<Term, Poly> createSolver(Poly factory) {
        if (factory instanceof MultivariatePolynomial) {
            return new EquationSolverE(((MultivariatePolynomial)factory).ring);
        }
        throw new RuntimeException();
    }

    static interface GroebnerAlgorithm<Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> {
        public GBResult<Term, Poly> GroebnerBasis(List<Poly> var1, Comparator<DegreeVector> var2, HilbertSeries var3);
    }

    public static final class HilbertSeries {
        private static final UnivariatePolynomial<Rational<BigInteger>> DENOMINATOR = UnivariatePolynomial.create(1L, -1L).mapCoefficients(Rings.Q, c -> new Rational<BigInteger>(Rings.Z, (BigInteger)c));
        public final UnivariatePolynomial<Rational<BigInteger>> initialNumerator;
        public final int initialDenominatorExponent;
        public final UnivariatePolynomial<Rational<BigInteger>> numerator;
        public final int denominatorExponent;
        private int idealDegree = -1;
        private UnivariatePolynomial<Rational<BigInteger>> integralPart = null;
        private UnivariatePolynomial<Rational<BigInteger>> remainderNumerator = null;
        private UnivariatePolynomial<Rational<BigInteger>> hilbertPolynomialZ = null;
        private UnivariatePolynomial<Rational<BigInteger>> hilbertPolynomial = null;

        private HilbertSeries(UnivariatePolynomial<Rational<BigInteger>> initialNumerator, int initialDenominatorExponent) {
            UnivariatePolynomial<Rational<BigInteger>> div;
            this.initialNumerator = initialNumerator;
            this.initialDenominatorExponent = initialDenominatorExponent;
            UnivariatePolynomial<Rational<BigInteger>> reducedNumerator = initialNumerator;
            int reducedDenominatorDegree = initialDenominatorExponent;
            while (!initialNumerator.isZero() && (div = UnivariateDivision.divideOrNull(reducedNumerator, DENOMINATOR, true)) != null) {
                reducedNumerator = div;
                --reducedDenominatorDegree;
            }
            this.numerator = reducedNumerator;
            this.denominatorExponent = reducedDenominatorDegree;
        }

        public int dimension() {
            return this.denominatorExponent;
        }

        public synchronized int degree() {
            if (this.idealDegree == -1) {
                Rational<BigInteger> degree = this.numerator.evaluate((Rational<BigInteger>)1L);
                assert (degree.isIntegral());
                this.idealDegree = degree.numerator().intValueExact();
            }
            return this.idealDegree;
        }

        public UnivariatePolynomial<Rational<BigInteger>> integralPart() {
            this.computeIntegralAndRemainder();
            return this.integralPart;
        }

        public UnivariatePolynomial<Rational<BigInteger>> remainderNumerator() {
            this.computeIntegralAndRemainder();
            return this.remainderNumerator;
        }

        private synchronized void computeIntegralAndRemainder() {
            if (this.integralPart == null) {
                UnivariatePolynomial<Rational<BigInteger>>[] divRem = UnivariateDivision.divideAndRemainder(this.numerator, UnivariatePolynomialArithmetic.polyPow(DENOMINATOR, this.denominatorExponent, true), true);
                this.integralPart = divRem[0];
                this.remainderNumerator = divRem[1];
            }
        }

        public synchronized UnivariatePolynomial<Rational<BigInteger>> hilbertPolynomialZ() {
            if (this.hilbertPolynomialZ == null) {
                this.hilbertPolynomialZ = UnivariatePolynomial.zero(Rings.Q);
                IUnivariatePolynomial var = UnivariatePolynomial.one(Rings.Q).shiftRight(1);
                for (int i = 0; i <= this.numerator.degree(); ++i) {
                    UnivariatePolynomial<BigInteger> term = UnivariatePolynomial.one(Rings.Q);
                    for (int j = 0; j < this.denominatorExponent - 1; ++j) {
                        term.multiply(((UnivariatePolynomial)((UnivariatePolynomial)var).clone()).add(Rings.Q.valueOf(-i + 1 + j)));
                    }
                    term.multiply((BigInteger)((Object)this.numerator.get(i)));
                    this.hilbertPolynomialZ.add(term);
                }
            }
            return this.hilbertPolynomialZ;
        }

        public synchronized UnivariatePolynomial<Rational<BigInteger>> hilbertPolynomial() {
            if (this.hilbertPolynomial == null) {
                Rational<BigInteger> facCf = new Rational<BigInteger>(Rings.Z, BigIntegerUtil.factorial(this.denominatorExponent - 1));
                this.hilbertPolynomial = ((UnivariatePolynomial)this.hilbertPolynomialZ().clone()).divideExact(facCf);
            }
            return this.hilbertPolynomial;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HilbertSeries that = (HilbertSeries)o;
            if (this.denominatorExponent != that.denominatorExponent) {
                return false;
            }
            return this.numerator.equals(that.numerator);
        }

        public int hashCode() {
            int result = this.numerator.hashCode();
            result = 31 * result + this.denominatorExponent;
            return result;
        }

        public String toString() {
            return String.format("(%s) / (%s)^%s", this.numerator, DENOMINATOR, this.denominatorExponent);
        }
    }

    static final class GBResult<Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>>
    extends ListWrapper<Poly> {
        final int nProcessedPolynomials;
        final int nZeroReductions;
        final int nHilbertRemoved;

        GBResult(List<Poly> list, int nProcessedPolynomials, int nZeroReductions, int nHilbertRemoved) {
            super(list);
            this.nProcessedPolynomials = nProcessedPolynomials;
            this.nZeroReductions = nZeroReductions;
            this.nHilbertRemoved = nHilbertRemoved;
        }

        GBResult(List<Poly> list, GBResult r) {
            super(list);
            this.nProcessedPolynomials = r.nProcessedPolynomials;
            this.nZeroReductions = r.nZeroReductions;
            this.nHilbertRemoved = r.nHilbertRemoved;
        }

        boolean isBuchbergerType() {
            return this.nProcessedPolynomials != -1;
        }

        static <T extends AMonomial<T>, P extends AMultivariatePolynomial<T, P>> GBResult<T, P> notBuchberger(List<P> basis) {
            return new GBResult(basis, -1, -1, -1);
        }

        static <T extends AMonomial<T>, P extends AMultivariatePolynomial<T, P>> GBResult<T, P> trivial(List<P> basis) {
            return new GBResult(basis, 0, 0, 0);
        }
    }

    public static class SyzygyPair<Term extends AMonomial<Term>, Poly extends MonomialSetView<Term>> {
        final int i;
        final int j;
        final Poly fi;
        final Poly fj;
        final DegreeVector syzygyGamma;
        final int sugar;

        SyzygyPair(int i, int j, Poly fi, Poly fj) {
            if (i > j) {
                int s = i;
                i = j;
                j = s;
                Poly fs = fi;
                fi = fj;
                fj = fs;
            }
            assert (i != j && fi != fj);
            assert (GroebnerBases.shareVariablesQ(fi.lt(), fj.lt()));
            this.i = i;
            this.j = j;
            this.fi = fi;
            this.fj = fj;
            this.syzygyGamma = GroebnerBases.lcm(fi.lt(), fj.lt());
            this.sugar = Math.max(fi.degreeSum() - ((AMonomial)fi.lt()).totalDegree, fj.degreeSum() - ((AMonomial)fj.lt()).totalDegree) + this.syzygyGamma.totalDegree;
        }

        SyzygyPair(int i, int j, List<Poly> generators) {
            this(i, j, (MonomialSetView)generators.get(i), (MonomialSetView)generators.get(j));
        }

        final int degree() {
            return this.syzygyGamma.totalDegree;
        }

        final int sugar() {
            return this.sugar;
        }
    }

    static interface SyzygySet<Term extends AMonomial<Term>, Poly extends MonomialSetView<Term>> {
        public void add(SyzygyPair<Term, Poly> var1);

        public void remove(SyzygyPair<Term, Poly> var1);

        public boolean isEmpty();

        default public int size() {
            return this.allSets().stream().mapToInt(TreeSet::size).sum();
        }

        public Collection<SyzygyPair<Term, Poly>> getAndRemoveNextBunch();

        public Collection<TreeSet<SyzygyPair<Term, Poly>>> allSets();

        default public List<SyzygyPair<Term, Poly>> allPairs() {
            return this.allSets().stream().flatMap(Collection::stream).collect(Collectors.toList());
        }
    }

    static final class SyzygyTreeSet<Term extends AMonomial<Term>, Poly extends MonomialSetView<Term>>
    implements SyzygySet<Term, Poly> {
        final TreeSet<SyzygyPair<Term, Poly>> sPairs;

        SyzygyTreeSet(TreeSet<SyzygyPair<Term, Poly>> sPairs) {
            this.sPairs = sPairs;
        }

        @Override
        public void add(SyzygyPair<Term, Poly> sPair) {
            this.sPairs.add(sPair);
        }

        @Override
        public void remove(SyzygyPair<Term, Poly> sPair) {
            this.sPairs.remove(sPair);
        }

        @Override
        public boolean isEmpty() {
            return this.sPairs.isEmpty();
        }

        @Override
        public Collection<SyzygyPair<Term, Poly>> getAndRemoveNextBunch() {
            return Collections.singleton(this.sPairs.pollFirst());
        }

        @Override
        public Collection<TreeSet<SyzygyPair<Term, Poly>>> allSets() {
            return new ArrayList<TreeSet<SyzygyPair<Term, Poly>>>(Collections.singleton(this.sPairs));
        }
    }

    public static interface MinimizationStrategy {
        public boolean doMinimize(int var1, int var2);
    }

    private static final class EcartComparator<Poly extends AMultivariatePolynomial<?, Poly>>
    implements Comparator<Poly> {
        private EcartComparator() {
        }

        @Override
        public int compare(Poly a, Poly b) {
            int c = Integer.compare(((AMultivariatePolynomial)a).ecart(), ((AMultivariatePolynomial)b).ecart());
            if (c != 0) {
                return c;
            }
            return ((AMultivariatePolynomial)a).ordering.compare((DegreeVector)((AMultivariatePolynomial)a).lt(), (DegreeVector)((AMultivariatePolynomial)b).lt());
        }
    }

    static final class GradedSyzygyTreeSet<Term extends AMonomial<Term>, Poly extends MonomialSetView<Term>>
    implements SyzygySet<Term, Poly> {
        final TreeMap<Integer, TreeSet<SyzygyPair<Term, Poly>>> sPairs;
        final Comparator<SyzygyPair> selectionStrategy;
        final ToIntFunction<SyzygyPair<Term, Poly>> weightFunction;

        GradedSyzygyTreeSet(TreeMap<Integer, TreeSet<SyzygyPair<Term, Poly>>> sPairs, Comparator<SyzygyPair> selectionStrategy, ToIntFunction<SyzygyPair<Term, Poly>> weightFunction) {
            this.sPairs = sPairs;
            this.selectionStrategy = selectionStrategy;
            this.weightFunction = weightFunction;
        }

        @Override
        public void add(SyzygyPair<Term, Poly> sPair) {
            this.sPairs.computeIfAbsent(this.weightFunction.applyAsInt(sPair), __ -> new TreeSet<SyzygyPair>(this.selectionStrategy)).add(sPair);
        }

        @Override
        public void remove(SyzygyPair<Term, Poly> sPair) {
            int weight = this.weightFunction.applyAsInt(sPair);
            TreeSet<SyzygyPair<Term, Poly>> set = this.sPairs.get(weight);
            if (set != null) {
                set.remove(sPair);
                if (set.isEmpty()) {
                    this.sPairs.remove(weight);
                }
            }
        }

        @Override
        public boolean isEmpty() {
            return this.sPairs.isEmpty();
        }

        @Override
        public Collection<SyzygyPair<Term, Poly>> getAndRemoveNextBunch() {
            return this.sPairs.pollFirstEntry().getValue();
        }

        @Override
        public Collection<TreeSet<SyzygyPair<Term, Poly>>> allSets() {
            return this.sPairs.values();
        }
    }

    private static final class HilbertUpdate {
        final int currentDegree;
        final int hilbertDelta;
        final int nRemovedPairs;
        final boolean finished;

        HilbertUpdate() {
            this.finished = true;
            this.nRemovedPairs = -1;
            this.currentDegree = -1;
            this.hilbertDelta = -1;
        }

        HilbertUpdate(int currentDegree, int hilbertDelta, int nRemovedPairs) {
            this.currentDegree = currentDegree;
            this.hilbertDelta = hilbertDelta;
            this.nRemovedPairs = nRemovedPairs;
            this.finished = false;
        }
    }

    private static final class ArrayBasedPoly<Term extends AMonomial<Term>>
    implements MonomialSetView<Term> {
        final IMonomialAlgebra<Term> mAlgebra;
        final Term[] data;
        final int[] degrees;

        ArrayBasedPoly(AMultivariatePolynomial<Term, ?> poly) {
            this.mAlgebra = poly.monomialAlgebra;
            this.data = poly.terms.descendingMap().values().toArray(poly.monomialAlgebra.createArray(poly.size()));
            this.degrees = poly.degrees();
        }

        ArrayBasedPoly(IMonomialAlgebra<Term> mAlgebra, Term[] data, int[] degrees) {
            this.mAlgebra = mAlgebra;
            this.data = data;
            this.degrees = degrees;
        }

        ArrayBasedPoly(IMonomialAlgebra<Term> mAlgebra, Term[] data, int nVariables) {
            this.mAlgebra = mAlgebra;
            this.data = data;
            this.degrees = new int[nVariables];
            for (Term db : data) {
                for (int i = 0; i < nVariables; ++i) {
                    if (((AMonomial)db).exponents[i] <= this.degrees[i]) continue;
                    this.degrees[i] = ((AMonomial)db).exponents[i];
                }
            }
        }

        @Override
        public Iterator<Term> ascendingIterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Term> descendingIterator() {
            return Arrays.asList(this.data).iterator();
        }

        @Override
        public Iterator<Term> iterator() {
            return this.descendingIterator();
        }

        @Override
        public int[] degrees() {
            return this.degrees;
        }

        @Override
        public Term first() {
            return this.data[this.data.length - 1];
        }

        @Override
        public Term last() {
            return this.data[0];
        }

        @Override
        public int size() {
            return this.data.length;
        }

        Term get(int i) {
            return this.data[i];
        }

        Term find(Term dv, Comparator<DegreeVector> ordering) {
            int i = Arrays.binarySearch(this.data, dv, (a, b) -> ordering.compare((DegreeVector)b, (DegreeVector)a));
            if (i < 0) {
                return null;
            }
            return this.data[i];
        }

        @Override
        public Collection<Term> collection() {
            return Arrays.asList(this.data);
        }

        public ArrayBasedPoly<Term> clone() {
            return new ArrayBasedPoly(this.mAlgebra, (AMonomial[])this.data.clone(), (int[])this.degrees.clone());
        }

        public String toString() {
            return Arrays.toString(this.data);
        }

        void multiply(Term term) {
            int i;
            for (i = this.data.length - 1; i >= 0; --i) {
                this.data[i] = this.mAlgebra.multiply(this.data[i], term);
            }
            for (i = 0; i < this.degrees.length; ++i) {
                int n = i;
                this.degrees[n] = this.degrees[n] + ((AMonomial)term).exponents[i];
            }
        }

        void multiply(DegreeVector term) {
            int i;
            for (i = this.data.length - 1; i >= 0; --i) {
                this.data[i] = ((AMonomial)this.data[i]).multiply(term);
            }
            for (i = 0; i < this.degrees.length; ++i) {
                int n = i;
                this.degrees[n] = this.degrees[n] + term.exponents[i];
            }
        }

        void divideExact(Term term) {
            int i;
            for (i = this.data.length - 1; i >= 0; --i) {
                this.data[i] = this.mAlgebra.divideExact(this.data[i], term);
            }
            for (i = 0; i < this.degrees.length; ++i) {
                int n = i;
                this.degrees[n] = this.degrees[n] - ((AMonomial)term).exponents[i];
            }
        }

        void monic() {
            Term unit = this.mAlgebra.getUnitTerm(((AMonomial)this.lt()).exponents.length);
            this.multiply(this.mAlgebra.divideExact(unit, ((AMonomial)this.lt()).setDegreeVector((DegreeVector)unit)));
        }

        void primitivePart() {
            if (this.mAlgebra instanceof IMonomialAlgebra.MonomialAlgebra) {
                Ring ring = ((IMonomialAlgebra.MonomialAlgebra)this.mAlgebra).ring;
                Object gcd = ring.gcd(Arrays.stream(this.data).map(t -> ((Monomial)t).coefficient).collect(Collectors.toList()));
                this.divideExact(new Monomial(((AMonomial)this.data[0]).exponents.length, gcd));
            }
        }

        void canonical() {
            if (this.mAlgebra instanceof IMonomialAlgebra.MonomialAlgebra && !((IMonomialAlgebra.MonomialAlgebra)this.mAlgebra).ring.isField()) {
                this.primitivePart();
            } else {
                this.monic();
            }
        }

        ArrayBasedPoly<Term> setLeadCoeffFrom(Term term) {
            if (this.mAlgebra.haveSameCoefficients(this.lt(), term)) {
                return this;
            }
            Object poly = this.clone();
            ((ArrayBasedPoly)poly).multiply(this.mAlgebra.divideExact(((AMonomial)term).toZero(), ((AMonomial)poly.lt()).toZero()));
            return poly;
        }
    }

    static final class HPolynomial<Term extends AMonomial<Term>> {
        final ArrayBasedPoly<Term> hPoly;
        final int indexOfOrigin;

        HPolynomial(ArrayBasedPoly<Term> hPoly, int indexOfOrigin) {
            this.hPoly = hPoly;
            this.indexOfOrigin = indexOfOrigin;
        }
    }

    static final class SparseRowMatrixZp64 {
        final IntegersZp64 ring;
        final int nRows;
        final int nColumns;
        final int[] densePositions;
        final SparseArrayZp64[] rows;

        SparseRowMatrixZp64(IntegersZp64 ring, int nRows, int nColumns, int[] densePositions) {
            this.ring = ring;
            this.nRows = nRows;
            this.nColumns = nColumns;
            this.densePositions = densePositions;
            this.rows = new SparseArrayZp64[nRows];
        }

        SparseRowMatrixZp64(IntegersZp64 ring, int nRows, int nColumns, int[] densePositions, SparseArrayZp64[] rows) {
            this.ring = ring;
            this.nRows = nRows;
            this.nColumns = nColumns;
            this.densePositions = densePositions;
            this.rows = rows;
        }

        SparseRowMatrixZp64 range(int from, int to) {
            return new SparseRowMatrixZp64(this.ring, to - from, this.nColumns, this.densePositions, Arrays.copyOfRange(this.rows, from, to));
        }

        long[][] denseMatrix() {
            long[][] result = new long[this.rows.length][this.nColumns];
            for (int iRow = 0; iRow < this.rows.length; ++iRow) {
                int i;
                SparseArrayZp64 row = this.rows[iRow];
                for (i = 0; i < row.sparsePositions.length; ++i) {
                    result[iRow][row.sparsePositions[i]] = row.sparseValues[i];
                }
                for (i = 0; i < this.densePositions.length; ++i) {
                    result[iRow][this.densePositions[i]] = row.denseValues[i];
                }
            }
            return result;
        }

        int rowReduce() {
            int nZeroRows = 0;
            int to = this.rows.length;
            for (int iCol = 0; iCol < to; ++iCol) {
                int iRow = iCol - nZeroRows;
                int pivotIndex = -1;
                for (int i = iRow; i < this.rows.length; ++i) {
                    if (this.rows[i].coefficient(iCol) == 0L) continue;
                    if (pivotIndex == -1) {
                        pivotIndex = i;
                        continue;
                    }
                    if (this.rows[i].sparsePositions.length >= this.rows[pivotIndex].sparsePositions.length) continue;
                    pivotIndex = i;
                }
                if (pivotIndex == -1) {
                    to = Math.min(this.nColumns, this.rows.length + ++nZeroRows);
                    continue;
                }
                ArraysUtil.swap(this.rows, pivotIndex, iRow);
                SparseArrayZp64 pivot = this.rows[iRow];
                long diagonalValue = pivot.coefficient(iCol);
                pivot.multiply(this.ring.reciprocal(diagonalValue));
                int firstDense = ArraysUtil.binarySearch1(this.densePositions, iCol);
                for (int row = 0; row < this.rows.length; ++row) {
                    long value;
                    if (row == iRow || (value = this.rows[row].coefficient(iCol)) == 0L) continue;
                    this.rows[row].subtract(pivot, value, iCol, firstDense);
                }
            }
            return Math.min(this.nRows, this.nColumns) - nZeroRows;
        }
    }

    static final class SparseArrayZp64 {
        final IntegersZp64 ring;
        final int length;
        final int[] densePositions;
        final long[] denseValues;
        int[] sparsePositions;
        long[] sparseValues;

        SparseArrayZp64(IntegersZp64 ring, int length, int[] densePositions, int[] sparsePositions, long[] denseValues, long[] sparseValues) {
            this.ring = ring;
            this.length = length;
            this.densePositions = densePositions;
            this.sparsePositions = sparsePositions;
            this.denseValues = denseValues;
            this.sparseValues = sparseValues;
            assert (GroebnerBases.isSorted(sparsePositions));
        }

        SparseArrayZp64(IntegersZp64 ring, int[] densePositions, long[] denseArray) {
            this.ring = ring;
            this.densePositions = densePositions;
            this.length = denseArray.length;
            this.denseValues = new long[densePositions.length];
            for (int i = 0; i < densePositions.length; ++i) {
                this.denseValues[i] = denseArray[densePositions[i]];
            }
            TIntArrayList sparsePositions = new TIntArrayList();
            TLongArrayList sparseValues = new TLongArrayList();
            for (int i = 0; i < denseArray.length; ++i) {
                if (denseArray[i] == 0L || Arrays.binarySearch(densePositions, i) >= 0) continue;
                sparsePositions.add(i);
                sparseValues.add(denseArray[i]);
            }
            this.sparsePositions = sparsePositions.toArray();
            this.sparseValues = sparseValues.toArray();
        }

        long[] toDense() {
            int i;
            long[] result = new long[this.length];
            for (i = 0; i < this.densePositions.length; ++i) {
                result[this.densePositions[i]] = this.denseValues[i];
            }
            for (i = 0; i < this.sparsePositions.length; ++i) {
                result[this.sparsePositions[i]] = this.sparseValues[i];
            }
            return result;
        }

        void subtract(SparseArrayZp64 pivot, long factor, int iColumn, int firstDense) {
            if (factor == 0L) {
                return;
            }
            assert (pivot.densePositions == this.densePositions);
            long negFactor = this.ring.negate(factor);
            for (int i = firstDense; i < this.denseValues.length; ++i) {
                this.denseValues[i] = this.ring.subtract(this.denseValues[i], this.ring.multiply(factor, pivot.denseValues[i]));
            }
            int[] pivCols = pivot.sparsePositions;
            long[] pivVals = pivot.sparseValues;
            int firstSparse = ArraysUtil.binarySearch1(this.sparsePositions, iColumn);
            TIntArrayList resCols = new TIntArrayList(this.sparsePositions.length + pivCols.length);
            TLongArrayList resVals = new TLongArrayList(this.sparsePositions.length + pivCols.length);
            resCols.add(this.sparsePositions, 0, firstSparse);
            resVals.add(this.sparseValues, 0, firstSparse);
            int iSel = firstSparse;
            int iPiv = 0;
            while (iSel < this.sparsePositions.length && iPiv < pivCols.length) {
                int selCol = this.sparsePositions[iSel];
                int othCol = pivCols[iPiv];
                if (selCol == othCol) {
                    long subtract = this.ring.subtract(this.sparseValues[iSel], this.ring.multiply(factor, pivVals[iPiv]));
                    if (subtract != 0L) {
                        resCols.add(selCol);
                        resVals.add(subtract);
                    }
                    ++iSel;
                    ++iPiv;
                    continue;
                }
                if (selCol < othCol) {
                    resCols.add(selCol);
                    resVals.add(this.sparseValues[iSel]);
                    ++iSel;
                    continue;
                }
                if (selCol <= othCol) continue;
                resCols.add(othCol);
                resVals.add(this.ring.multiply(negFactor, pivVals[iPiv]));
                ++iPiv;
            }
            if (iSel < this.sparsePositions.length) {
                while (iSel < this.sparsePositions.length) {
                    resCols.add(this.sparsePositions[iSel]);
                    resVals.add(this.sparseValues[iSel]);
                    ++iSel;
                }
            }
            if (iPiv < pivCols.length) {
                while (iPiv < pivCols.length) {
                    resCols.add(pivCols[iPiv]);
                    resVals.add(this.ring.multiply(negFactor, pivVals[iPiv]));
                    ++iPiv;
                }
            }
            this.sparsePositions = resCols.toArray();
            this.sparseValues = resVals.toArray();
        }

        void subtract(SparseArrayZp64 pivot, long factor) {
            this.subtract(pivot, factor, 0, 0);
        }

        void multiply(long factor) {
            int i;
            if (factor == 1L) {
                return;
            }
            for (i = 0; i < this.sparseValues.length; ++i) {
                this.sparseValues[i] = this.ring.multiply(this.sparseValues[i], factor);
            }
            for (i = 0; i < this.denseValues.length; ++i) {
                this.denseValues[i] = this.ring.multiply(this.denseValues[i], factor);
            }
        }

        long coefficient(int iRow) {
            int index = Arrays.binarySearch(this.sparsePositions, iRow);
            if (index >= 0) {
                return this.sparseValues[index];
            }
            index = Arrays.binarySearch(this.densePositions, iRow);
            if (index >= 0) {
                return this.denseValues[index];
            }
            return 0L;
        }

        void multiply(int iRow, long value) {
            int index = Arrays.binarySearch(this.sparsePositions, iRow);
            if (index >= 0) {
                this.sparseValues[index] = this.ring.multiply(this.sparseValues[index], value);
            } else {
                index = Arrays.binarySearch(this.densePositions, iRow);
                if (index >= 0) {
                    this.denseValues[index] = this.ring.multiply(this.denseValues[index], value);
                }
            }
        }

        void subtract(int iRow, long value) {
            if (value == 0L) {
                return;
            }
            int index = Arrays.binarySearch(this.densePositions, iRow);
            if (index >= 0) {
                this.denseValues[index] = this.ring.subtract(this.denseValues[index], value);
            } else {
                index = Arrays.binarySearch(this.sparsePositions, iRow);
                if (index >= 0) {
                    this.sparseValues[index] = this.ring.subtract(this.sparseValues[index], value);
                    if (this.sparseValues[index] == 0L) {
                        this.sparsePositions = ArraysUtil.remove(this.sparsePositions, index);
                        this.sparseValues = ArraysUtil.remove(this.sparseValues, index);
                    }
                } else {
                    this.sparsePositions = ArraysUtil.insert(this.sparsePositions, index ^= 0xFFFFFFFF, iRow);
                    this.sparseValues = ArraysUtil.insert(this.sparseValues, index, this.ring.negate(value));
                }
            }
        }

        int firstNonZeroPosition() {
            int firstSparse = this.sparsePositions.length != 0 ? this.sparsePositions[0] : Integer.MAX_VALUE;
            for (int i = 0; i < this.densePositions.length; ++i) {
                if (this.denseValues[i] == 0L) continue;
                return Math.min(this.densePositions[i], firstSparse);
            }
            return firstSparse;
        }
    }

    static final class SparseRowMatrix<E> {
        final Ring<E> ring;
        final int nRows;
        final int nColumns;
        final int[] densePositions;
        final SparseArray<E>[] rows;

        SparseRowMatrix(Ring<E> ring, int nRows, int nColumns, int[] densePositions) {
            this.ring = ring;
            this.nRows = nRows;
            this.nColumns = nColumns;
            this.densePositions = densePositions;
            this.rows = new SparseArray[nRows];
        }

        SparseRowMatrix(Ring<E> ring, int nRows, int nColumns, int[] densePositions, SparseArray<E>[] rows) {
            this.ring = ring;
            this.nRows = nRows;
            this.nColumns = nColumns;
            this.densePositions = densePositions;
            this.rows = rows;
        }

        SparseRowMatrix<E> range(int from, int to) {
            return new SparseRowMatrix<E>(this.ring, to - from, this.nColumns, this.densePositions, Arrays.copyOfRange(this.rows, from, to));
        }

        E[][] denseMatrix() {
            E[][] result = this.ring.createZeroesArray2d(this.rows.length, this.nColumns);
            for (int iRow = 0; iRow < this.rows.length; ++iRow) {
                int i;
                SparseArray<E> row = this.rows[iRow];
                for (i = 0; i < row.sparsePositions.length; ++i) {
                    result[iRow][row.sparsePositions[i]] = row.sparseValues[i];
                }
                for (i = 0; i < this.densePositions.length; ++i) {
                    result[iRow][this.densePositions[i]] = row.denseValues[i];
                }
            }
            return result;
        }

        int rowReduce() {
            int nZeroRows = 0;
            int to = this.rows.length;
            for (int iCol = 0; iCol < to; ++iCol) {
                int iRow = iCol - nZeroRows;
                int pivotIndex = -1;
                boolean isUnit = false;
                for (int i = iRow; i < this.rows.length; ++i) {
                    if (this.ring.isZero(this.rows[i].coefficient(iCol))) continue;
                    boolean iu = this.ring.isUnit(this.rows[i].coefficient(iRow));
                    if (pivotIndex == -1) {
                        pivotIndex = i;
                        continue;
                    }
                    if (!isUnit && iu) {
                        pivotIndex = i;
                        isUnit = true;
                        continue;
                    }
                    if (isUnit != iu || this.rows[i].sparsePositions.length >= this.rows[pivotIndex].sparsePositions.length) continue;
                    pivotIndex = i;
                }
                if (pivotIndex == -1) {
                    to = Math.min(this.nColumns, this.rows.length + ++nZeroRows);
                    continue;
                }
                ArraysUtil.swap(this.rows, pivotIndex, iRow);
                SparseArray<E> pivot = this.rows[iRow];
                E diagonalValue = pivot.coefficient(iCol);
                if (this.ring.isField()) {
                    pivot.multiply(this.ring.reciprocal(diagonalValue));
                } else {
                    pivot.primitivePart();
                }
                int firstDense = ArraysUtil.binarySearch1(this.densePositions, iCol);
                for (int row = 0; row < this.rows.length; ++row) {
                    E value;
                    if (row == iRow || this.ring.isZero(value = this.rows[row].coefficient(iCol))) continue;
                    if (this.ring.isField()) {
                        this.rows[row].subtract(pivot, value, iCol, firstDense);
                    } else {
                        E lcm = this.ring.lcm(diagonalValue, value);
                        this.rows[row].multiply(this.ring.divideExact(lcm, value));
                        this.rows[row].subtract(pivot, this.ring.divideExact(lcm, diagonalValue), iCol, firstDense);
                        this.rows[row].primitivePart();
                    }
                    assert (this.ring.isZero(this.rows[row].coefficient(iCol)));
                }
            }
            return Math.min(this.nRows, this.nColumns) - nZeroRows;
        }
    }

    static final class SparseArray<E> {
        final Ring<E> ring;
        final int length;
        final int[] densePositions;
        final E[] denseValues;
        int[] sparsePositions;
        E[] sparseValues;

        SparseArray(Ring<E> ring, int length, int[] densePositions, int[] sparsePositions, E[] denseValues, E[] sparseValues) {
            this.ring = ring;
            this.length = length;
            this.densePositions = densePositions;
            this.sparsePositions = sparsePositions;
            this.denseValues = denseValues;
            this.sparseValues = sparseValues;
            assert (GroebnerBases.isSorted(sparsePositions)) : Arrays.toString(sparsePositions);
        }

        SparseArray(Ring<E> ring, int[] densePositions, E[] denseArray) {
            this.ring = ring;
            this.densePositions = densePositions;
            this.length = denseArray.length;
            this.denseValues = ring.createArray(densePositions.length);
            for (int i = 0; i < densePositions.length; ++i) {
                this.denseValues[i] = denseArray[densePositions[i]];
            }
            TIntArrayList sparsePositions = new TIntArrayList();
            ArrayList<E> sparseValues = new ArrayList<E>();
            for (int i = 0; i < denseArray.length; ++i) {
                if (ring.isZero((int)denseArray[i]) || Arrays.binarySearch(densePositions, i) >= 0) continue;
                sparsePositions.add(i);
                sparseValues.add(denseArray[i]);
            }
            this.sparsePositions = sparsePositions.toArray();
            this.sparseValues = sparseValues.toArray(ring.createArray(sparseValues.size()));
            assert (GroebnerBases.isSorted(this.sparsePositions)) : Arrays.toString(this.sparsePositions);
        }

        E[] toDense() {
            int i;
            E[] result = this.ring.createZeroesArray(this.length);
            for (i = 0; i < this.densePositions.length; ++i) {
                result[this.densePositions[i]] = this.denseValues[i];
            }
            for (i = 0; i < this.sparsePositions.length; ++i) {
                result[this.sparsePositions[i]] = this.sparseValues[i];
            }
            return result;
        }

        E normMax() {
            Object el = null;
            for (E v : this.denseValues) {
                v = this.ring.abs(v);
                if (el != null && this.ring.compare(v, el) <= 0) continue;
                el = v;
            }
            for (E v : this.sparseValues) {
                v = this.ring.abs(v);
                if (el != null && this.ring.compare(v, el) <= 0) continue;
                el = v;
            }
            return (E)el;
        }

        void subtract(SparseArray<E> pivot, E factor, int iColumn, int firstDense) {
            if (this.ring.isZero(factor)) {
                return;
            }
            assert (pivot.densePositions == this.densePositions);
            E negFactor = this.ring.negate(factor);
            for (int i = firstDense; i < this.denseValues.length; ++i) {
                this.denseValues[i] = this.ring.subtract(this.denseValues[i], this.ring.multiply(factor, pivot.denseValues[i]));
            }
            int[] pivCols = pivot.sparsePositions;
            E[] pivVals = pivot.sparseValues;
            int firstSparse = ArraysUtil.binarySearch1(this.sparsePositions, iColumn);
            TIntArrayList resCols = new TIntArrayList(this.sparsePositions.length + pivCols.length);
            ArrayList<E> resVals = new ArrayList<E>(this.sparsePositions.length + pivCols.length);
            resCols.add(this.sparsePositions, 0, firstSparse);
            resVals.addAll(Arrays.asList(this.sparseValues).subList(0, firstSparse));
            int iSel = firstSparse;
            int iPiv = 0;
            while (iSel < this.sparsePositions.length && iPiv < pivCols.length) {
                int selCol = this.sparsePositions[iSel];
                int othCol = pivCols[iPiv];
                if (selCol == othCol) {
                    E subtract = this.ring.subtract(this.sparseValues[iSel], this.ring.multiply(factor, pivVals[iPiv]));
                    if (!this.ring.isZero(subtract)) {
                        resCols.add(selCol);
                        resVals.add(subtract);
                    }
                    ++iSel;
                    ++iPiv;
                    continue;
                }
                if (selCol < othCol) {
                    resCols.add(selCol);
                    resVals.add(this.sparseValues[iSel]);
                    ++iSel;
                    continue;
                }
                if (selCol <= othCol) continue;
                resCols.add(othCol);
                resVals.add(this.ring.multiply(negFactor, pivVals[iPiv]));
                ++iPiv;
            }
            if (iSel < this.sparsePositions.length) {
                while (iSel < this.sparsePositions.length) {
                    resCols.add(this.sparsePositions[iSel]);
                    resVals.add(this.sparseValues[iSel]);
                    ++iSel;
                }
            }
            if (iPiv < pivCols.length) {
                while (iPiv < pivCols.length) {
                    resCols.add(pivCols[iPiv]);
                    resVals.add(this.ring.multiply(negFactor, pivVals[iPiv]));
                    ++iPiv;
                }
            }
            this.sparsePositions = resCols.toArray();
            assert (resCols.size() == new TIntArrayList(resCols).size());
            this.sparseValues = resVals.toArray(this.ring.createArray(resVals.size()));
            assert (GroebnerBases.isSorted(this.sparsePositions)) : Arrays.toString(this.sparsePositions);
        }

        void subtract(SparseArray<E> pivot, E factor) {
            this.subtract(pivot, factor, 0, 0);
        }

        void multiply(E factor) {
            int i;
            if (this.ring.isOne(factor)) {
                return;
            }
            for (i = 0; i < this.sparseValues.length; ++i) {
                this.sparseValues[i] = this.ring.multiply(this.sparseValues[i], factor);
            }
            for (i = 0; i < this.denseValues.length; ++i) {
                this.denseValues[i] = this.ring.multiply(this.denseValues[i], factor);
            }
            assert (GroebnerBases.isSorted(this.sparsePositions)) : Arrays.toString(this.sparsePositions);
        }

        void divideExact(E factor) {
            int i;
            if (this.ring.isOne(factor)) {
                return;
            }
            for (i = 0; i < this.sparseValues.length; ++i) {
                this.sparseValues[i] = this.ring.divideExact(this.sparseValues[i], factor);
            }
            for (i = 0; i < this.denseValues.length; ++i) {
                this.denseValues[i] = this.ring.divideExact(this.denseValues[i], factor);
            }
        }

        E content(E el) {
            if (this.ring.isField()) {
                return this.ring.getOne();
            }
            ArrayList<E> els = new ArrayList<E>();
            els.add(el);
            els.addAll(Arrays.asList(this.sparseValues));
            els.addAll(Arrays.asList(this.denseValues));
            E gcd = this.ring.gcd(els);
            if (this.ring.isZero(gcd)) {
                return this.ring.getOne();
            }
            return gcd;
        }

        E content() {
            return this.content(this.ring.getZero());
        }

        void primitivePart() {
            this.divideExact(this.content());
        }

        E coefficient(int iRow) {
            int index = Arrays.binarySearch(this.sparsePositions, iRow);
            if (index >= 0) {
                return this.sparseValues[index];
            }
            index = Arrays.binarySearch(this.densePositions, iRow);
            if (index >= 0) {
                return this.denseValues[index];
            }
            return this.ring.getZero();
        }

        void multiply(int iRow, E value) {
            int index = Arrays.binarySearch(this.sparsePositions, iRow);
            if (index >= 0) {
                this.sparseValues[index] = this.ring.multiply(this.sparseValues[index], value);
            } else {
                index = Arrays.binarySearch(this.densePositions, iRow);
                if (index >= 0) {
                    this.denseValues[index] = this.ring.multiply(this.denseValues[index], value);
                }
            }
        }

        void subtract(int iRow, E value) {
            if (this.ring.isZero(value)) {
                return;
            }
            int index = Arrays.binarySearch(this.densePositions, iRow);
            if (index >= 0) {
                this.denseValues[index] = this.ring.subtract(this.denseValues[index], value);
            } else {
                index = Arrays.binarySearch(this.sparsePositions, iRow);
                if (index >= 0) {
                    this.sparseValues[index] = this.ring.subtract(this.sparseValues[index], value);
                    if (this.ring.isZero(this.sparseValues[index])) {
                        this.sparsePositions = ArraysUtil.remove(this.sparsePositions, index);
                        this.sparseValues = ArraysUtil.remove(this.sparseValues, index);
                    }
                } else {
                    this.sparsePositions = ArraysUtil.insert(this.sparsePositions, index ^= 0xFFFFFFFF, iRow);
                    this.sparseValues = ArraysUtil.insert(this.sparseValues, index, this.ring.negate(value));
                }
            }
            assert (GroebnerBases.isSorted(this.sparsePositions)) : Arrays.toString(this.sparsePositions);
        }

        int firstNonZeroPosition() {
            int firstSparse = this.sparsePositions.length != 0 ? this.sparsePositions[0] : Integer.MAX_VALUE;
            for (int i = 0; i < this.densePositions.length; ++i) {
                if (this.ring.isZero(this.denseValues[i])) continue;
                return Math.min(this.densePositions[i], firstSparse);
            }
            return firstSparse;
        }
    }

    private static final class PrimesIterator0 {
        private BigInteger from;
        private PrimesIterator base;

        PrimesIterator0(BigInteger from) {
            this.from = from;
            this.base = from.isLong() ? new PrimesIterator(from.longValueExact()) : null;
        }

        BigInteger next() {
            if (this.base == null) {
                this.from = this.from.nextProbablePrime();
                return this.from;
            }
            long l = this.base.take();
            if (l == -1L) {
                this.base = null;
                return this.next();
            }
            return BigInteger.valueOf(l);
        }
    }

    private static abstract class EquationSolver<Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> {
        final List<Equation<Term, Poly>> equations = new ArrayList<Equation<Term, Poly>>();
        final TIntArrayList solvedVariables = new TIntArrayList();

        EquationSolver() {
        }

        final int nEquations() {
            return this.equations.size();
        }

        abstract boolean addEquation(Equation<Term, Poly> var1);

        abstract LinearSolver.SystemInfo solve();

        abstract Equation<Term, Poly> simplify(Equation<Term, Poly> var1);

        abstract Poly simplify(Poly var1);

        abstract void clear();

        final MultivariatePolynomial<Poly> simplifyGB(MultivariatePolynomial<Poly> poly) {
            return poly.mapCoefficients(poly.ring, this::simplify);
        }

        final void simplifyGB(MultivariatePolynomial<Poly>[] gbCandidate) {
            for (int i = 0; i < gbCandidate.length; ++i) {
                gbCandidate[i] = this.simplifyGB(gbCandidate[i]);
            }
        }

        final int nSolved() {
            return this.solvedVariables.size();
        }
    }

    static interface EqSupplier<Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> {
        public MultivariatePolynomial<Poly> poly();

        public DegreeVector signature();
    }

    private static class Equation<Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> {
        final int[] usedVars;
        final TIntIntHashMap mapping;
        final Poly reducedEquation;
        final boolean isLinear;

        Equation(Poly equation) {
            int i2;
            int[] degrees = ((AMultivariatePolynomial)equation).degrees();
            TIntArrayList usedVars = new TIntArrayList();
            for (i2 = 0; i2 < degrees.length; ++i2) {
                if (degrees[i2] <= 0) continue;
                usedVars.add(i2);
            }
            this.usedVars = usedVars.toArray();
            assert (((AMultivariatePolynomial)equation).isZero() || this.usedVars.length > 0);
            assert (Arrays.stream(this.usedVars).allMatch(i -> i >= 0));
            assert (GroebnerBases.isSorted(this.usedVars));
            this.reducedEquation = ((AMultivariatePolynomial)equation).dropSelectVariables(this.usedVars);
            this.mapping = new TIntIntHashMap(10, 0.5f, -1, -1);
            for (i2 = 0; i2 < this.usedVars.length; ++i2) {
                this.mapping.put(this.usedVars[i2], i2);
            }
            this.isLinear = GroebnerBases.isLinear(equation);
        }

        Equation(int[] usedVars, TIntIntHashMap mapping, Poly reducedEquation) {
            this.usedVars = usedVars;
            assert (((AMultivariatePolynomial)reducedEquation).isZero() || this.usedVars.length > 0);
            assert (Arrays.stream(this.usedVars).allMatch(i -> i >= 0));
            assert (GroebnerBases.isSorted(this.usedVars));
            this.mapping = mapping;
            this.reducedEquation = reducedEquation;
            this.isLinear = GroebnerBases.isLinear(reducedEquation);
        }

        void dropVariables(int[] vMapping) {
            int i2;
            for (i2 = 0; i2 < this.usedVars.length; ++i2) {
                this.usedVars[i2] = vMapping[this.usedVars[i2]];
            }
            assert (GroebnerBases.isSorted(this.usedVars));
            assert (Arrays.stream(this.usedVars).allMatch(i -> i >= 0));
            this.mapping.clear();
            for (i2 = 0; i2 < this.usedVars.length; ++i2) {
                this.mapping.put(this.usedVars[i2], i2);
            }
        }

        boolean hasVariable(int variable) {
            return Arrays.binarySearch(this.usedVars, variable) >= 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Equation equation1 = (Equation)o;
            return Arrays.equals(this.usedVars, equation1.usedVars) && ((AMultivariatePolynomial)this.reducedEquation).equals(equation1.reducedEquation);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.usedVars);
            result = 31 * result + ((AMultivariatePolynomial)this.reducedEquation).hashCode();
            return result;
        }
    }

    private static final class EquationSolverE<E>
    extends EquationSolver<Monomial<E>, MultivariatePolynomial<E>> {
        private final List<E> solutions = new ArrayList();
        private final Ring<E> ring;

        EquationSolverE(Ring<E> ring) {
            this.ring = ring;
        }

        @Override
        void clear() {
            this.solvedVariables.clear();
            this.solutions.clear();
        }

        @Override
        boolean addEquation(Equation<Monomial<E>, MultivariatePolynomial<E>> equation) {
            equation = this.simplify(equation);
            MultivariatePolynomial eq = (MultivariatePolynomial)equation.reducedEquation;
            eq.monic();
            if (eq.isZero()) {
                return false;
            }
            if (this.equations.contains(equation)) {
                return false;
            }
            if (eq.nVariables == 1) {
                Ring ring = eq.ring;
                int solvedVar = equation.usedVars[0];
                assert (solvedVar >= 0);
                this.solvedVariables.add(solvedVar);
                this.solutions.add(ring.divideExact(ring.negate(eq.cc()), eq.lc()));
                ArrayList<Equation> needUpdate = new ArrayList<Equation>();
                for (int i = this.equations.size() - 1; i >= 0; --i) {
                    Equation oldEq = (Equation)this.equations.get(i);
                    if (!oldEq.hasVariable(solvedVar)) continue;
                    this.equations.remove(i);
                    needUpdate.add(oldEq);
                }
                needUpdate.forEach(this::addEquation);
                return true;
            }
            this.equations.add(equation);
            return true;
        }

        private void selfUpdate() {
            ArrayList<Equation<Monomial<E>, MultivariatePolynomial<E>>> needUpdate = new ArrayList<Equation<Monomial<E>, MultivariatePolynomial<E>>>();
            for (int i = this.equations.size() - 1; i >= 0; --i) {
                Equation<Monomial<E>, MultivariatePolynomial<E>> newEq;
                Equation oldEq = (Equation)this.equations.get(i);
                if (oldEq.equals(newEq = this.simplify(oldEq))) continue;
                this.equations.remove(i);
                needUpdate.add(newEq);
            }
            needUpdate.forEach(this::addEquation);
        }

        @Override
        Equation<Monomial<E>, MultivariatePolynomial<E>> simplify(Equation<Monomial<E>, MultivariatePolynomial<E>> eq) {
            TIntArrayList eliminated = new TIntArrayList();
            TIntHashSet rEliminated = new TIntHashSet();
            MultivariatePolynomial<E> rPoly = (MultivariatePolynomial<E>)eq.reducedEquation;
            for (int i = 0; i < this.solutions.size(); ++i) {
                int var = this.solvedVariables.get(i);
                if (!eq.hasVariable(var)) continue;
                int rVar = eq.mapping.get(var);
                assert (rVar >= 0);
                eliminated.add(var);
                rEliminated.add(rVar);
                rPoly = rPoly.evaluate(rVar, this.solutions.get(i));
            }
            if (eliminated.isEmpty()) {
                return eq;
            }
            eliminated.sort();
            int[] eliminatedArray = eliminated.toArray();
            int[] usedVars = ArraysUtil.intSetDifference(eq.usedVars, eliminatedArray);
            TIntIntHashMap mapping = new TIntIntHashMap();
            for (int i = 0; i < usedVars.length; ++i) {
                mapping.put(usedVars[i], i);
            }
            return new Equation<Monomial<E>, MultivariatePolynomial<E>>(usedVars, mapping, (MultivariatePolynomial)rPoly.dropVariables(rEliminated.toArray()));
        }

        @Override
        MultivariatePolynomial<E> simplify(MultivariatePolynomial<E> poly) {
            int[] degs = poly.degrees();
            TIntArrayList subsVariables = new TIntArrayList();
            ArrayList<E> subsValues = new ArrayList<E>();
            for (int i = 0; i < this.solvedVariables.size(); ++i) {
                if (degs[this.solvedVariables.get(i)] <= 0) continue;
                subsVariables.add(this.solvedVariables.get(i));
                subsValues.add(this.solutions.get(i));
            }
            if (subsVariables.isEmpty()) {
                return poly;
            }
            return poly.evaluate(subsVariables.toArray(), (E[])subsValues.toArray(this.ring.createArray(subsValues.size())));
        }

        @Override
        LinearSolver.SystemInfo solve() {
            this.equations.sort(Comparator.comparingInt(eq -> eq.usedVars.length));
            for (int i = 0; i < this.equations.size(); ++i) {
                Equation baseEq = (Equation)this.equations.get(i);
                TIntHashSet baseVars = new TIntHashSet(baseEq.usedVars);
                ArrayList<Equation<Monomial<Equation>, MultivariatePolynomial<Equation>>> block = new ArrayList<Equation<Monomial<Equation>, MultivariatePolynomial<Equation>>>(Collections.singletonList(baseEq));
                for (int j = 0; j < this.equations.size(); ++j) {
                    if (i == j) continue;
                    Equation jEq = (Equation)this.equations.get(j);
                    if (jEq.usedVars.length > baseVars.size()) break;
                    if (!baseVars.containsAll(jEq.usedVars)) continue;
                    block.add(jEq);
                }
                if (block.size() < baseVars.size()) continue;
                LinearSolver.SystemInfo solve = this.solve(block, baseVars.toArray());
                if (solve == LinearSolver.SystemInfo.Inconsistent) {
                    return solve;
                }
                if (solve == LinearSolver.SystemInfo.UnderDetermined) continue;
                this.equations.removeAll(block);
                this.selfUpdate();
                return LinearSolver.SystemInfo.Consistent;
            }
            return LinearSolver.SystemInfo.UnderDetermined;
        }

        LinearSolver.SystemInfo solve(List<Equation<Monomial<E>, MultivariatePolynomial<E>>> equations, int[] usedVariables) {
            int nUsedVariables = usedVariables.length;
            TIntIntHashMap mapping = new TIntIntHashMap();
            int[] linalgVariables = new int[nUsedVariables];
            int c = 0;
            for (int i : usedVariables) {
                mapping.put(i, c);
                assert (i >= 0);
                linalgVariables[c] = i;
                ++c;
            }
            E[][] lhs = this.ring.createZeroesArray2d(equations.size(), nUsedVariables);
            int[] rhs = this.ring.createArray(equations.size());
            for (int i = 0; i < equations.size(); ++i) {
                Equation<Monomial<E>, MultivariatePolynomial<E>> eq = equations.get(i);
                rhs[i] = (int)this.ring.negate(((MultivariatePolynomial)eq.reducedEquation).cc());
                for (Monomial term : (MultivariatePolynomial)eq.reducedEquation) {
                    if (term.isZeroVector()) continue;
                    lhs[i][mapping.get((int)eq.usedVars[term.firstNonZeroVariable()])] = term.coefficient;
                }
            }
            int[] linalgSolution = this.ring.createArray(nUsedVariables);
            LinearSolver.SystemInfo solve = LinearSolver.solve(this.ring, lhs, rhs, linalgSolution);
            if (solve == LinearSolver.SystemInfo.Consistent) {
                this.solvedVariables.addAll(linalgVariables);
                this.solutions.addAll(Arrays.asList(linalgSolution));
            }
            return solve;
        }
    }

    static final class EqSupplierSyzygy<Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>>
    implements EqSupplier<Term, Poly> {
        final List<MultivariatePolynomial<Poly>> initialIdeal;
        final MultivariatePolynomial<Poly>[] gbCandidate;
        final SyzygyPair<Monomial<Poly>, MultivariatePolynomial<Poly>> sPair;

        EqSupplierSyzygy(List<MultivariatePolynomial<Poly>> initialIdeal, MultivariatePolynomial<Poly>[] gbCandidate, SyzygyPair<Monomial<Poly>, MultivariatePolynomial<Poly>> sPair) {
            this.initialIdeal = initialIdeal;
            this.gbCandidate = gbCandidate;
            this.sPair = sPair;
        }

        @Override
        public MultivariatePolynomial<Poly> poly() {
            return GroebnerBases.syzygy(this.sPair.syzygyGamma, GroebnerBases.getFi(this.sPair.i, this.initialIdeal, this.gbCandidate), GroebnerBases.getFi(this.sPair.j, this.initialIdeal, this.gbCandidate));
        }

        @Override
        public DegreeVector signature() {
            return this.sPair.syzygyGamma;
        }
    }

    static final class EqSupplierPoly<Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>>
    implements EqSupplier<Term, Poly> {
        final MultivariatePolynomial<Poly> poly;

        EqSupplierPoly(MultivariatePolynomial<Poly> poly) {
            this.poly = poly;
        }

        @Override
        public MultivariatePolynomial<Poly> poly() {
            return this.poly;
        }

        @Override
        public DegreeVector signature() {
            return this.poly.lt();
        }
    }

    static final class SparseColumnMatrix<E> {
        final Ring<E> ring;
        final int nRows;
        final int nColumns;
        final int[] densePositions;
        final SparseArray<E>[] columns;

        SparseColumnMatrix(Ring<E> ring, int nRows, int nColumns, int[] densePositions) {
            this.ring = ring;
            this.nRows = nRows;
            this.nColumns = nColumns;
            this.densePositions = densePositions;
            this.columns = new SparseArray[nColumns];
        }

        void multiplyRow(int iRow, E value) {
            if (!this.ring.isOne(value)) {
                for (int i = 0; i < this.nColumns; ++i) {
                    this.columns[i].multiply(iRow, value);
                }
            }
        }

        SparseRowMatrix<E> toRowMatrix(int[] densePositions) {
            int iRow;
            SparseRowMatrix<E> rowMatrix = new SparseRowMatrix<E>(this.ring, this.nRows, this.nColumns, densePositions);
            TIntArrayList[] sparseColumns = new TIntArrayList[this.nRows];
            ArrayList[] sparseValues = new ArrayList[this.nRows];
            E[][] denseValues = this.ring.createArray2d(this.nRows, densePositions.length);
            for (iRow = 0; iRow < this.nRows; ++iRow) {
                sparseColumns[iRow] = new TIntArrayList();
                sparseValues[iRow] = new ArrayList();
            }
            for (int iColumn = 0; iColumn < this.nColumns; ++iColumn) {
                int i;
                SparseArray<E> column = this.columns[iColumn];
                int iDenseColumn = Arrays.binarySearch(densePositions, iColumn);
                if (iDenseColumn >= 0) {
                    for (i = 0; i < column.densePositions.length; ++i) {
                        denseValues[column.densePositions[i]][iDenseColumn] = column.denseValues[i];
                    }
                    for (i = 0; i < column.sparsePositions.length; ++i) {
                        denseValues[column.sparsePositions[i]][iDenseColumn] = column.sparseValues[i];
                    }
                    continue;
                }
                for (i = 0; i < column.densePositions.length; ++i) {
                    sparseColumns[column.densePositions[i]].add(iColumn);
                    sparseValues[column.densePositions[i]].add(column.denseValues[i]);
                }
                for (i = 0; i < column.sparsePositions.length; ++i) {
                    sparseColumns[column.sparsePositions[i]].add(iColumn);
                    sparseValues[column.sparsePositions[i]].add(column.sparseValues[i]);
                }
            }
            for (iRow = 0; iRow < this.nRows; ++iRow) {
                rowMatrix.rows[iRow] = new SparseArray<int>(this.ring, this.nColumns, densePositions, sparseColumns[iRow].toArray(), denseValues[iRow], sparseValues[iRow].toArray(this.ring.createArray(sparseValues[iRow].size())));
            }
            return rowMatrix;
        }
    }

    static final class SparseColumnMatrixZp64 {
        final IntegersZp64 ring;
        final int nRows;
        final int nColumns;
        final int[] densePositions;
        final SparseArrayZp64[] columns;

        SparseColumnMatrixZp64(IntegersZp64 ring, int nRows, int nColumns, int[] densePositions) {
            this.ring = ring;
            this.nRows = nRows;
            this.nColumns = nColumns;
            this.densePositions = densePositions;
            this.columns = new SparseArrayZp64[nColumns];
        }

        void multiplyRow(int iRow, long value) {
            if (value != 1L) {
                for (int i = 0; i < this.nColumns; ++i) {
                    this.columns[i].multiply(iRow, value);
                }
            }
        }

        SparseRowMatrixZp64 toRowMatrix(int[] densePositions) {
            int iRow;
            SparseRowMatrixZp64 rowMatrix = new SparseRowMatrixZp64(this.ring, this.nRows, this.nColumns, densePositions);
            TIntArrayList[] sparseColumns = new TIntArrayList[this.nRows];
            TLongArrayList[] sparseValues = new TLongArrayList[this.nRows];
            long[][] denseValues = new long[this.nRows][densePositions.length];
            for (iRow = 0; iRow < this.nRows; ++iRow) {
                sparseColumns[iRow] = new TIntArrayList();
                sparseValues[iRow] = new TLongArrayList();
            }
            for (int iColumn = 0; iColumn < this.nColumns; ++iColumn) {
                int i;
                SparseArrayZp64 column = this.columns[iColumn];
                int iDenseColumn = Arrays.binarySearch(densePositions, iColumn);
                if (iDenseColumn >= 0) {
                    for (i = 0; i < column.densePositions.length; ++i) {
                        denseValues[column.densePositions[i]][iDenseColumn] = column.denseValues[i];
                    }
                    for (i = 0; i < column.sparsePositions.length; ++i) {
                        denseValues[column.sparsePositions[i]][iDenseColumn] = column.sparseValues[i];
                    }
                    continue;
                }
                for (i = 0; i < column.densePositions.length; ++i) {
                    sparseColumns[column.densePositions[i]].add(iColumn);
                    sparseValues[column.densePositions[i]].add(column.denseValues[i]);
                }
                for (i = 0; i < column.sparsePositions.length; ++i) {
                    sparseColumns[column.sparsePositions[i]].add(iColumn);
                    sparseValues[column.sparsePositions[i]].add(column.sparseValues[i]);
                }
            }
            for (iRow = 0; iRow < this.nRows; ++iRow) {
                rowMatrix.rows[iRow] = new SparseArrayZp64(this.ring, this.nColumns, densePositions, sparseColumns[iRow].toArray(), denseValues[iRow], sparseValues[iRow].toArray());
            }
            return rowMatrix;
        }
    }
}

