/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.multivar;

import cc.redberry.rings.Ring;
import cc.redberry.rings.Rings;
import cc.redberry.rings.io.IStringifier;
import cc.redberry.rings.io.Stringifiable;
import cc.redberry.rings.poly.MultivariateRing;
import cc.redberry.rings.poly.multivar.AMonomial;
import cc.redberry.rings.poly.multivar.AMultivariatePolynomial;
import cc.redberry.rings.poly.multivar.DegreeVector;
import cc.redberry.rings.poly.multivar.GroebnerBases;
import cc.redberry.rings.poly.multivar.GroebnerMethods;
import cc.redberry.rings.poly.multivar.Monomial;
import cc.redberry.rings.poly.multivar.MonomialOrder;
import cc.redberry.rings.poly.multivar.MultivariateDivision;
import cc.redberry.rings.poly.multivar.MultivariatePolynomial;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public final class Ideal<Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>>
implements Stringifiable<Poly>,
Serializable {
    private final List<Poly> originalGenerators;
    public final Comparator<DegreeVector> ordering;
    private final Poly factory;
    private final List<Poly> groebnerBasis;
    private final MultivariateRing<Poly> ring;
    private GroebnerBases.HilbertSeries hilbertSeries = null;

    private Ideal(List<Poly> originalGenerators, List<Poly> groebnerBasis) {
        this.originalGenerators = Collections.unmodifiableList(originalGenerators);
        this.factory = (AMultivariatePolynomial)((AMultivariatePolynomial)groebnerBasis.get(0)).createZero();
        this.groebnerBasis = groebnerBasis;
        this.ordering = ((AMultivariatePolynomial)this.factory).ordering;
        this.ring = Rings.MultivariateRing(this.factory);
    }

    private Ideal(List<Poly> groebnerBasis) {
        this(groebnerBasis, groebnerBasis);
    }

    public Comparator<DegreeVector> getMonomialOrder() {
        return this.ordering;
    }

    public Ideal<Term, Poly> changeOrder(Comparator<DegreeVector> newMonomialOrder) {
        if (this.ordering == newMonomialOrder) {
            return this;
        }
        if (MonomialOrder.isGradedOrder(this.ordering) || !MonomialOrder.isGradedOrder(newMonomialOrder)) {
            return new Ideal<Term, Poly>(this.originalGenerators, GroebnerBases.HilbertConvertBasis(this.groebnerBasis, newMonomialOrder));
        }
        return Ideal.create(this.originalGenerators, newMonomialOrder);
    }

    private static <Poly extends AMultivariatePolynomial<?, Poly>> Poly setOrdering(Poly poly, Comparator<DegreeVector> monomialOrder) {
        return poly.ordering == monomialOrder ? poly : poly.setOrdering(monomialOrder);
    }

    private Poly setOrdering(Poly poly) {
        return Ideal.setOrdering(poly, this.ordering);
    }

    private Poly mod0(Poly poly) {
        return (Poly)MultivariateDivision.pseudoRemainder(this.setOrdering(poly), this.groebnerBasis);
    }

    public Poly normalForm(Poly poly) {
        Comparator<DegreeVector> originalOrder = ((AMultivariatePolynomial)poly).ordering;
        return Ideal.setOrdering(this.mod0(poly), originalOrder);
    }

    public List<Poly> getOriginalGenerators() {
        return this.originalGenerators;
    }

    public List<Poly> getGroebnerBasis() {
        return Collections.unmodifiableList(this.groebnerBasis);
    }

    public int nBasisGenerators() {
        return this.groebnerBasis.size();
    }

    public Poly getBasisGenerator(int i) {
        return (Poly)((AMultivariatePolynomial)this.groebnerBasis.get(i));
    }

    public boolean isTrivial() {
        return this.nBasisGenerators() == 1 && this.getBasisGenerator(0).isConstant() && !((AMultivariatePolynomial)this.getBasisGenerator(0)).isZero();
    }

    public boolean isProper() {
        return !this.isTrivial();
    }

    public boolean isEmpty() {
        return this.nBasisGenerators() == 1 && ((AMultivariatePolynomial)this.getBasisGenerator(0)).isZero();
    }

    public boolean isPrincipal() {
        return this.nBasisGenerators() == 1;
    }

    public boolean isHomogeneous() {
        return GroebnerBases.isHomogeneousIdeal(this.groebnerBasis);
    }

    public boolean isMonomial() {
        return GroebnerBases.isMonomialIdeal(this.groebnerBasis);
    }

    public boolean isMaximal() {
        return (this.factory.isOverZ() || this.factory.isOverField()) && this.dimension() == 0 && this.groebnerBasis.size() == ((AMultivariatePolynomial)this.factory).nVariables && this.groebnerBasis.stream().allMatch(AMultivariatePolynomial::isLinearExactly);
    }

    public Ideal<Term, Poly> ltIdeal() {
        if (this.isMonomial()) {
            return this;
        }
        return new Ideal(this.groebnerBasis.stream().map(AMultivariatePolynomial::ltAsPoly).collect(Collectors.toList()));
    }

    public boolean contains(Poly poly) {
        return ((AMultivariatePolynomial)this.mod0(poly)).isZero();
    }

    public boolean contains(Ideal<Term, Poly> oth) {
        return this.quotient(oth).isTrivial();
    }

    public synchronized GroebnerBases.HilbertSeries hilbertSeries() {
        if (this.hilbertSeries == null) {
            this.hilbertSeries = this.isHomogeneous() || MonomialOrder.isGradedOrder(this.ordering) ? GroebnerBases.HilbertSeriesOfLeadingTermsSet(this.groebnerBasis) : GroebnerBases.HilbertSeriesOfLeadingTermsSet(GroebnerBases.GroebnerBasisWithOptimizedGradedOrder(this.originalGenerators));
        }
        return this.hilbertSeries;
    }

    public int dimension() {
        return this.hilbertSeries().dimension();
    }

    public int degree() {
        return this.hilbertSeries().degree();
    }

    public boolean containsProduct(Ideal<Term, Poly> a, Ideal<Term, Poly> b) {
        if (a.nBasisGenerators() > b.nBasisGenerators()) {
            return this.containsProduct(b, a);
        }
        return this.quotient(a).contains(b);
    }

    public boolean radicalContains(Poly poly) {
        List yGenerators = this.groebnerBasis.stream().map(AMultivariatePolynomial::joinNewVariable).collect(Collectors.toList());
        Object yPoly = ((AMultivariatePolynomial)poly).joinNewVariable();
        yGenerators.add(((AMultivariatePolynomial)yPoly.createOne()).subtract((AMultivariatePolynomial)((AMultivariatePolynomial)((AMultivariatePolynomial)yPoly).createMonomial(((AMultivariatePolynomial)yPoly).nVariables - 1, 1)).multiply(yPoly)));
        return Ideal.create(yGenerators).isTrivial();
    }

    public Ideal<Term, Poly> union(Poly oth) {
        this.factory.assertSameCoefficientRingWith(oth);
        if (((AMultivariatePolynomial)oth).isZero()) {
            return this;
        }
        if (oth.isOne()) {
            return Ideal.trivial(this.factory);
        }
        ArrayList<Poly> l = new ArrayList<Poly>(this.groebnerBasis);
        l.add(oth);
        return Ideal.create(l, this.ordering);
    }

    public Ideal<Term, Poly> union(Ideal<Term, Poly> oth) {
        this.assertSameDomain(oth);
        if (this.isEmpty() || oth.isTrivial()) {
            return oth;
        }
        if (oth.isEmpty() || this.isTrivial()) {
            return this;
        }
        ArrayList<Poly> l = new ArrayList<Poly>();
        l.addAll(this.groebnerBasis);
        l.addAll(oth.groebnerBasis);
        return Ideal.create(l, this.ordering);
    }

    public Ideal<Term, Poly> multiply(Ideal<Term, Poly> oth) {
        this.assertSameDomain(oth);
        if (this.isTrivial() || oth.isEmpty()) {
            return oth;
        }
        if (oth.isTrivial() || this.isEmpty()) {
            return this;
        }
        ArrayList<AMultivariatePolynomial> generators = new ArrayList<AMultivariatePolynomial>();
        for (AMultivariatePolynomial a : this.groebnerBasis) {
            for (AMultivariatePolynomial b : oth.groebnerBasis) {
                generators.add((AMultivariatePolynomial)((AMultivariatePolynomial)a.clone()).multiply(b));
            }
        }
        return Ideal.create(generators, this.ordering);
    }

    public Ideal<Term, Poly> square() {
        return this.multiply((Poly)this);
    }

    public Ideal<Term, Poly> pow(int exponent) {
        if (exponent < 0) {
            throw new IllegalArgumentException();
        }
        if (exponent == 1) {
            return this;
        }
        Ideal<Term, Ideal<Term, Ideal<Term, Poly>>> result = Ideal.trivial(this.factory);
        Ideal<Term, Ideal> k2p = this;
        while (true) {
            if ((exponent & 1) != 0) {
                result = result.multiply((Ideal<Term, Ideal<Term, Poly>>)k2p);
            }
            if ((exponent >>= 1) == 0) {
                return result;
            }
            k2p = k2p.multiply((Ideal)k2p);
        }
    }

    public Ideal<Term, Poly> multiply(Poly oth) {
        this.factory.assertSameCoefficientRingWith(oth);
        if (this.isTrivial()) {
            return Ideal.create(Collections.singletonList(oth), this.ordering);
        }
        if (((AMultivariatePolynomial)oth).isZero()) {
            return Ideal.trivial(oth, this.ordering);
        }
        if (oth.isOne() || this.isEmpty()) {
            return this;
        }
        return new Ideal(GroebnerBases.canonicalize(this.groebnerBasis.stream().map(p -> (AMultivariatePolynomial)((AMultivariatePolynomial)p.clone()).multiply(oth)).collect(Collectors.toList())));
    }

    public Ideal<Term, Poly> intersection(Ideal<Term, Poly> oth) {
        this.assertSameDomain(oth);
        if (this.isTrivial() || oth.isEmpty()) {
            return oth;
        }
        if (oth.isTrivial() || this.isEmpty()) {
            return this;
        }
        if (this.isPrincipal() && oth.isPrincipal()) {
            return Ideal.create(Collections.singletonList((AMultivariatePolynomial)this.ring.lcm(this.getBasisGenerator(0), oth.getBasisGenerator(0))), this.ordering);
        }
        Object t = ((AMultivariatePolynomial)((AMultivariatePolynomial)this.factory).insertVariable(0)).createMonomial(0, 1);
        ArrayList<AMultivariatePolynomial> tGenerators = new ArrayList<AMultivariatePolynomial>();
        for (Object gI : this.groebnerBasis) {
            tGenerators.add((AMultivariatePolynomial)((AMultivariatePolynomial)((AMultivariatePolynomial)gI).insertVariable(0)).multiply(t));
        }
        AMultivariatePolynomial omt = (AMultivariatePolynomial)((AMultivariatePolynomial)((AMultivariatePolynomial)t).clone()).negate().increment();
        for (AMultivariatePolynomial gJ : oth.groebnerBasis) {
            tGenerators.add((AMultivariatePolynomial)((AMultivariatePolynomial)gJ.insertVariable(0)).multiply((AMultivariatePolynomial)omt));
        }
        List result = GroebnerMethods.eliminate(tGenerators, 0).stream().map(p -> p.dropVariable(0)).map(p -> p.setOrdering(this.ordering)).collect(Collectors.toList());
        return Ideal.create(result, this.ordering);
    }

    public Ideal<Term, Poly> quotient(Poly oth) {
        if (((AMultivariatePolynomial)oth).isZero()) {
            return Ideal.trivial(this.factory);
        }
        if (oth.isConstant()) {
            return this;
        }
        return Ideal.create(this.intersection(Ideal.create((AMultivariatePolynomial[])new AMultivariatePolynomial[]{oth})).groebnerBasis.stream().map(p -> this.ring.quotient(p, oth)).collect(Collectors.toList()));
    }

    public Ideal<Term, Poly> quotient(Ideal<Term, Poly> oth) {
        if (oth.isEmpty()) {
            return Ideal.trivial(this.factory);
        }
        if (oth.isTrivial()) {
            return this;
        }
        return oth.groebnerBasis.stream().map(this::quotient).reduce(Ideal.trivial(this.factory), Ideal::intersection);
    }

    Ideal<Term, Poly> insertVariable(int variable) {
        return new Ideal(this.groebnerBasis.stream().map(p -> p.insertVariable(variable)).collect(Collectors.toList()));
    }

    private void assertSameDomain(Ideal<Term, Poly> oth) {
        this.factory.assertSameCoefficientRingWith(oth.factory);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ideal ideal = (Ideal)o;
        return this.ordering.equals(ideal.ordering) && this.groebnerBasis.equals(ideal.groebnerBasis);
    }

    public int hashCode() {
        return this.groebnerBasis.hashCode();
    }

    @Override
    public String toString(IStringifier<Poly> stringifier) {
        return "<" + this.groebnerBasis.stream().map(stringifier::stringify).collect(Collectors.joining(", ")) + ">";
    }

    public String toString() {
        return this.toString(IStringifier.dummy());
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Ideal<Term, Poly> create(List<Poly> generators) {
        return Ideal.create(generators, MonomialOrder.GREVLEX);
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Ideal<Term, Poly> create(Poly ... generators) {
        return Ideal.create(Arrays.asList(generators));
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Ideal<Term, Poly> create(List<Poly> generators, Comparator<DegreeVector> monomialOrder) {
        return new Ideal<Term, Poly>(generators, GroebnerBases.GroebnerBasis(generators, monomialOrder));
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Ideal<Term, Poly> trivial(Poly factory) {
        return Ideal.trivial(factory, MonomialOrder.GREVLEX);
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Ideal<Term, Poly> trivial(Poly factory, Comparator<DegreeVector> monomialOrder) {
        return new Ideal(Collections.singletonList(((AMultivariatePolynomial)factory.createOne()).setOrdering(monomialOrder)));
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Ideal<Term, Poly> empty(Poly factory) {
        return Ideal.empty(factory, MonomialOrder.GREVLEX);
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Ideal<Term, Poly> empty(Poly factory, Comparator<DegreeVector> monomialOrder) {
        return new Ideal(Collections.singletonList(((AMultivariatePolynomial)factory.createZero()).setOrdering(monomialOrder)));
    }

    public static <E> Ideal<Monomial<E>, MultivariatePolynomial<E>> parse(String[] generators, Ring<E> field, String[] variables) {
        return Ideal.parse(generators, field, MonomialOrder.GREVLEX, variables);
    }

    public static <E> Ideal<Monomial<E>, MultivariatePolynomial<E>> parse(String[] generators, Ring<E> field, Comparator<DegreeVector> monomialOrder, String[] variables) {
        return Ideal.create(Arrays.stream(generators).map(p -> MultivariatePolynomial.parse(p, field, monomialOrder, variables)).collect(Collectors.toList()), monomialOrder);
    }
}

