/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.multivar;

import cc.redberry.rings.poly.multivar.AMonomial;
import cc.redberry.rings.poly.multivar.DegreeVector;

public class Monomial<E>
extends AMonomial<Monomial<E>> {
    public final E coefficient;

    public Monomial(DegreeVector degreeVector, E coefficient) {
        super(degreeVector);
        this.coefficient = coefficient;
    }

    public Monomial(int[] exponents, int totalDegree, E coefficient) {
        super(exponents, totalDegree);
        this.coefficient = coefficient;
    }

    public Monomial(int[] exponents, E coefficient) {
        super(exponents);
        this.coefficient = coefficient;
    }

    public Monomial(int nVariables, E coefficient) {
        this(new int[nVariables], 0, coefficient);
    }

    @Override
    public Monomial<E> setCoefficientFrom(Monomial<E> oth) {
        return new Monomial<E>(this, oth.coefficient);
    }

    @Override
    public Monomial<E> setDegreeVector(DegreeVector oth) {
        if (this == oth) {
            return this;
        }
        if (oth == null) {
            return null;
        }
        if (oth.exponents == this.exponents) {
            return this;
        }
        return new Monomial<E>(oth, this.coefficient);
    }

    @Override
    public Monomial<E> setDegreeVector(int[] exponents, int totalDegree) {
        if (this.exponents == exponents) {
            return this;
        }
        return new Monomial<E>(exponents, totalDegree, this.coefficient);
    }

    @Override
    public Monomial<E> forceSetDegreeVector(int[] exponents, int totalDegree) {
        return new Monomial<E>(exponents, totalDegree, this.coefficient);
    }

    public Monomial<E> setCoefficient(E c) {
        return new Monomial<E>(this.exponents, this.totalDegree, c);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Monomial monomial = (Monomial)o;
        return this.coefficient.equals(monomial.coefficient);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.coefficient.hashCode();
        return result;
    }

    @Override
    public String toString() {
        String dvString = super.toString();
        String cfString = this.coefficient.toString();
        if (dvString.isEmpty()) {
            return cfString;
        }
        if (cfString.equals("1")) {
            return dvString;
        }
        return this.coefficient + "*" + dvString;
    }
}

