/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.multivar;

import cc.redberry.rings.Ring;
import cc.redberry.rings.poly.IPolynomial;
import cc.redberry.rings.poly.multivar.AMonomial;
import cc.redberry.rings.poly.multivar.AMultivariatePolynomial;
import cc.redberry.rings.poly.multivar.DegreeVector;
import cc.redberry.rings.poly.multivar.IMonomialAlgebra;
import cc.redberry.rings.poly.multivar.Monomial;
import cc.redberry.rings.poly.multivar.MultivariatePolynomial;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.IntFunction;

public final class MultivariateDivision {
    private MultivariateDivision() {
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly[] divideAndRemainder(Poly dividend, Poly ... dividers) {
        int i;
        AMultivariatePolynomial[] quotients = (AMultivariatePolynomial[])dividend.createArray(dividers.length + 1);
        int constDivider = -1;
        for (i = 0; i < dividers.length; ++i) {
            if (((AMultivariatePolynomial)dividers[i]).isZero()) {
                throw new ArithmeticException("divide by zero");
            }
            if (dividers[i].isConstant()) {
                constDivider = i;
            }
            quotients[i] = (AMultivariatePolynomial)dividend.createZero();
        }
        quotients[i] = (AMultivariatePolynomial)dividend.createZero();
        if (constDivider != -1) {
            if (dividers[constDivider].isOne()) {
                quotients[constDivider] = dividend.clone();
                return quotients;
            }
            AMultivariatePolynomial dd = (AMultivariatePolynomial)dividend.clone().divideByLC(dividers[constDivider]);
            if (dd != null) {
                quotients[constDivider] = dd;
                return quotients;
            }
        }
        IMonomialAlgebra<AMonomial> mAlgebra = dividend.monomialAlgebra;
        AMonomial[] dividersLTs = (AMonomial[])Arrays.stream(dividers).map(AMultivariatePolynomial::lt).toArray((IntFunction<AMonomial[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, createArray(int ), (I)[Lcc/redberry/rings/poly/multivar/AMonomial;)(mAlgebra));
        dividend = dividend.clone();
        AMultivariatePolynomial remainder = quotients[quotients.length - 1];
        while (!dividend.isZero()) {
            AMonomial ltDiv = null;
            Object lt = dividend.lt();
            for (i = 0; i < dividers.length && (ltDiv = mAlgebra.divideOrNull((AMonomial)lt, dividersLTs[i])) == null; ++i) {
            }
            if (ltDiv != null) {
                quotients[i] = quotients[i].add(ltDiv);
                dividend = dividend.subtract((AMonomial)ltDiv, dividers[i]);
                continue;
            }
            remainder = remainder.add(lt);
            dividend = dividend.subtractLt();
        }
        return quotients;
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly remainder(Poly dividend, Poly ... dividers) {
        int i;
        int constDivider = -1;
        for (i = 0; i < dividers.length; ++i) {
            if (((AMultivariatePolynomial)dividers[i]).isZero()) {
                throw new ArithmeticException("divide by zero");
            }
            if (!dividers[i].isConstant()) continue;
            constDivider = i;
        }
        if (constDivider != -1) {
            if (dividers[constDivider].isOne()) {
                return (Poly)((AMultivariatePolynomial)dividend.createZero());
            }
            AMultivariatePolynomial dd = (AMultivariatePolynomial)dividend.clone().divideByLC(dividers[constDivider]);
            if (dd != null) {
                return (Poly)((AMultivariatePolynomial)dividend.createZero());
            }
        }
        IMonomialAlgebra<AMonomial> mAlgebra = dividend.monomialAlgebra;
        AMonomial[] dividersLTs = (AMonomial[])Arrays.stream(dividers).map(AMultivariatePolynomial::lt).toArray((IntFunction<AMonomial[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, createArray(int ), (I)[Lcc/redberry/rings/poly/multivar/AMonomial;)(mAlgebra));
        dividend = dividend.clone();
        AMultivariatePolynomial remainder = (AMultivariatePolynomial)dividend.createZero();
        while (!dividend.isZero()) {
            AMonomial ltDiv = null;
            Object lt = dividend.lt();
            for (i = 0; i < dividersLTs.length && (ltDiv = mAlgebra.divideOrNull((AMonomial)lt, dividersLTs[i])) == null; ++i) {
            }
            if (ltDiv != null) {
                dividend = dividend.subtract(ltDiv, dividers[i]);
                continue;
            }
            remainder = remainder.add(lt);
            dividend = dividend.subtractLt();
        }
        return (Poly)remainder;
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly pseudoRemainder(Poly dividend, Poly ... dividers) {
        if (dividend.isOverField()) {
            return (Poly)MultivariateDivision.remainder(dividend, dividers);
        }
        return (Poly)MultivariateDivision.pseudoRemainder0((MultivariatePolynomial)dividend, (MultivariatePolynomial[])dividers);
    }

    private static <E> MultivariatePolynomial<E> pseudoRemainder0(MultivariatePolynomial<E> dividend, MultivariatePolynomial<E> ... dividers) {
        int i;
        int constDivider = -1;
        for (i = 0; i < dividers.length; ++i) {
            if (dividers[i].isZero()) {
                throw new ArithmeticException("divide by zero");
            }
            if (!dividers[i].isConstant()) continue;
            constDivider = i;
        }
        if (constDivider != -1) {
            return ((MultivariatePolynomial)dividend).createZero();
        }
        Ring ring = ((MultivariatePolynomial)dividend).ring;
        Monomial[] dividersLTs = (Monomial[])Arrays.stream(dividers).map(AMultivariatePolynomial::lt).toArray(Monomial[]::new);
        dividend = ((MultivariatePolynomial)dividend).clone();
        IPolynomial remainder = ((MultivariatePolynomial)dividend).createZero();
        while (!dividend.isZero()) {
            Monomial ltDiv = null;
            Monomial lt = (Monomial)dividend.lt();
            int iPseudoDiv = -1;
            DegreeVector dvPseudoDiv = null;
            for (i = 0; i < dividersLTs.length; ++i) {
                DegreeVector dvDiv = lt.dvDivideOrNull(dividersLTs[i]);
                if (dvDiv == null) continue;
                Object cfDiv = ring.divideOrNull(lt.coefficient, dividersLTs[i].coefficient);
                if (cfDiv != null) {
                    ltDiv = new Monomial(dvDiv, cfDiv);
                    break;
                }
                if (iPseudoDiv != -1 && ring.compare(dividersLTs[i].coefficient, dividersLTs[iPseudoDiv].coefficient) >= 0) continue;
                iPseudoDiv = i;
                dvPseudoDiv = dvDiv;
            }
            if (ltDiv != null) {
                dividend = (MultivariatePolynomial)dividend.subtract(((MultivariatePolynomial)dividend.create(ltDiv)).multiply(dividers[i]));
                continue;
            }
            if (iPseudoDiv == -1) {
                remainder = (MultivariatePolynomial)((AMultivariatePolynomial)remainder).add(lt);
                dividend = (MultivariatePolynomial)dividend.subtractLt();
                continue;
            }
            Object gcd = ring.gcd(lt.coefficient, dividersLTs[iPseudoDiv].coefficient);
            Object factor = ring.divideExact(dividersLTs[iPseudoDiv].coefficient, gcd);
            ((MultivariatePolynomial)dividend).multiply(factor);
            ((MultivariatePolynomial)remainder).multiply(factor);
            dividend = dividend.subtract(new Monomial(dvPseudoDiv, ring.divideExact(lt.coefficient, gcd)), dividers[iPseudoDiv]);
        }
        return ((MultivariatePolynomial)remainder).primitivePartSameSign();
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly[] divideAndRemainder(Poly dividend, Poly divider) {
        AMultivariatePolynomial[] array = (AMultivariatePolynomial[])divider.createArray(1);
        array[0] = divider;
        return MultivariateDivision.divideAndRemainder(dividend, (AMultivariatePolynomial[])array);
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly remainder(Poly dividend, Collection<Poly> dividers) {
        return (Poly)MultivariateDivision.remainder(dividend, dividers.toArray((AMultivariatePolynomial[])dividend.createArray(dividers.size())));
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly remainder(Poly dividend, Poly divider) {
        AMultivariatePolynomial[] array = (AMultivariatePolynomial[])divider.createArray(1);
        array[0] = divider;
        return (Poly)MultivariateDivision.remainder(dividend, array);
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly pseudoRemainder(Poly dividend, Collection<Poly> dividers) {
        return (Poly)MultivariateDivision.pseudoRemainder(dividend, dividers.toArray((AMultivariatePolynomial[])dividend.createArray(dividers.size())));
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly pseudoRemainder(Poly dividend, Poly divider) {
        AMultivariatePolynomial[] array = (AMultivariatePolynomial[])divider.createArray(1);
        array[0] = divider;
        return (Poly)MultivariateDivision.pseudoRemainder(dividend, array);
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly divideExact(Poly dividend, Poly divider) {
        AMultivariatePolynomial[] qd = MultivariateDivision.divideAndRemainder(dividend, divider);
        if (qd == null || !qd[1].isZero()) {
            throw new ArithmeticException("not divisible: " + dividend + " / " + divider);
        }
        return (Poly)qd[0];
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly divideOrNull(Poly dividend, Poly divider) {
        AMultivariatePolynomial[] qd = MultivariateDivision.divideAndRemainder(dividend, divider);
        if (qd == null || !qd[1].isZero()) {
            return null;
        }
        return (Poly)qd[0];
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> boolean dividesQ(Poly dividend, Poly divider) {
        if (divider.isOne()) {
            return true;
        }
        dividend = dividend.clone();
        if (divider.isConstant()) {
            return dividend.divideByLC(divider) != null;
        }
        int[] dividendDegrees = dividend.degrees();
        int[] dividerDegrees = divider.degrees();
        for (int i = 0; i < dividendDegrees.length; ++i) {
            if (dividendDegrees[i] >= dividerDegrees[i]) continue;
            return false;
        }
        IMonomialAlgebra mAlgebra = dividend.monomialAlgebra;
        while (!dividend.isZero()) {
            Object ltDiv = mAlgebra.divideOrNull(dividend.lt(), divider.lt());
            if (ltDiv == null) {
                return false;
            }
            dividend = dividend.subtract(((AMultivariatePolynomial)divider.clone()).multiply(ltDiv));
        }
        return true;
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> boolean nontrivialQuotientQ(Poly dividend, Poly divider) {
        Term lt = divider.lt();
        for (AMonomial term : dividend) {
            if (!term.dvDivisibleBy((DegreeVector)lt)) continue;
            return true;
        }
        return false;
    }
}

