/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.multivar;

import cc.redberry.rings.ChineseRemainders;
import cc.redberry.rings.Integers;
import cc.redberry.rings.IntegersZp;
import cc.redberry.rings.IntegersZp64;
import cc.redberry.rings.Rational;
import cc.redberry.rings.RationalReconstruction;
import cc.redberry.rings.Ring;
import cc.redberry.rings.Rings;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.bigint.BigIntegerUtil;
import cc.redberry.rings.linear.LinearSolver;
import cc.redberry.rings.poly.AlgebraicNumberField;
import cc.redberry.rings.poly.FiniteField;
import cc.redberry.rings.poly.IPolynomial;
import cc.redberry.rings.poly.MachineArithmetic;
import cc.redberry.rings.poly.MultipleFieldExtension;
import cc.redberry.rings.poly.MultivariateRing;
import cc.redberry.rings.poly.SimpleFieldExtension;
import cc.redberry.rings.poly.UnivariateRing;
import cc.redberry.rings.poly.Util;
import cc.redberry.rings.poly.multivar.AMonomial;
import cc.redberry.rings.poly.multivar.AMultivariatePolynomial;
import cc.redberry.rings.poly.multivar.Conversions64bit;
import cc.redberry.rings.poly.multivar.DegreeVector;
import cc.redberry.rings.poly.multivar.HenselLifting;
import cc.redberry.rings.poly.multivar.Monomial;
import cc.redberry.rings.poly.multivar.MonomialSet;
import cc.redberry.rings.poly.multivar.MonomialZp64;
import cc.redberry.rings.poly.multivar.MultivariateDivision;
import cc.redberry.rings.poly.multivar.MultivariateFactorization;
import cc.redberry.rings.poly.multivar.MultivariateInterpolation;
import cc.redberry.rings.poly.multivar.MultivariatePolynomial;
import cc.redberry.rings.poly.multivar.MultivariatePolynomialZp64;
import cc.redberry.rings.poly.multivar.PairedIterator;
import cc.redberry.rings.poly.multivar.PrivateRandom;
import cc.redberry.rings.poly.univar.IUnivariatePolynomial;
import cc.redberry.rings.poly.univar.IrreduciblePolynomials;
import cc.redberry.rings.poly.univar.UnivariateDivision;
import cc.redberry.rings.poly.univar.UnivariateGCD;
import cc.redberry.rings.poly.univar.UnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariatePolynomialZp64;
import cc.redberry.rings.poly.univar.UnivariateResultants;
import cc.redberry.rings.primes.PrimesIterator;
import cc.redberry.rings.primes.SmallPrimes;
import cc.redberry.rings.util.ArraysUtil;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.hash.TIntHashSet;
import gnu.trove.set.hash.TLongHashSet;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.math3.random.RandomGenerator;

public final class MultivariateGCD {
    private static final double SPARSITY_THRESHOLD_NVARS_4 = 0.2;
    private static final double SPARSITY2_THRESHOLD = 0.5;
    private static final int SPARSITY_SIZE_THRESHOLD = 256;
    static int EARLY_ADJUST_SMALL_POLY_SIZE_THRESHOLD = 1024;
    static int EARLY_ADJUST_POLY_DISBALANCE = 10;
    static int EARLY_ADJUST_LARGE_POLY_SIZE_THRESHOLD = EARLY_ADJUST_SMALL_POLY_SIZE_THRESHOLD * EARLY_ADJUST_POLY_DISBALANCE;
    private static final int MAX_OVER_ITERATIONS = 18;
    private static final int LARGE_SIZE_USE_FAST_DIV_TEST = 64000;
    private static final int MAX_SPARSE_INTERPOLATION_FAILS = 64;
    private static final int ALLOWED_OVER_INTERPOLATED_ATTEMPTS = 64;
    static boolean ALWAYS_LINZIP = false;
    static final int MAX_FAILED_SUBSTITUTIONS = 32;
    private static final int N_EVALUATIONS_RECURSIVE_SWITCH = 16;
    private static final int SIZE_OF_POLY_RECURSIVE_SWITCH = 512;
    private static final int SMALL_FIELD_BIT_LENGTH = 13;
    private static final int NUMBER_OF_UNDER_DETERMINED_RETRIES = 8;
    private static final int NUMBER_OF_UNDER_DETERMINED_RETRIES_SMALL_FIELD = 24;
    private static final int SAME_BASE_VARIABLE_ATTEMPTS = 8;
    private static final int ATTEMPTS_WITH_MAX_ZEROS = 2;

    private MultivariateGCD() {
    }

    public static <Poly extends AMultivariatePolynomial> Poly PolynomialGCD(Poly ... arr) {
        return (Poly)MultivariateGCD.PolynomialGCD(arr, MultivariateGCD::PolynomialGCD);
    }

    static <Poly extends AMultivariatePolynomial> Poly PolynomialGCD(Poly poly, Poly[] arr) {
        AMultivariatePolynomial[] all = (AMultivariatePolynomial[])poly.createArray(arr.length + 1);
        all[0] = poly;
        System.arraycopy(arr, 0, all, 1, arr.length);
        return (Poly)MultivariateGCD.PolynomialGCD((AMultivariatePolynomial[])all);
    }

    public static <Poly extends AMultivariatePolynomial> Poly PolynomialGCD(Iterable<Poly> arr) {
        return (Poly)MultivariateGCD.PolynomialGCD(arr, MultivariateGCD::PolynomialGCD);
    }

    private static <Poly extends AMultivariatePolynomial> Poly[] nonZeroElements(Poly[] arr) {
        ArrayList<Poly> res = new ArrayList<Poly>(arr.length);
        for (Poly el : arr) {
            if (((AMultivariatePolynomial)el).isZero()) continue;
            res.add(el);
        }
        if (res.isEmpty()) {
            res.add(arr[0]);
        }
        return res.toArray((AMultivariatePolynomial[])arr[0].createArray(res.size()));
    }

    static <Poly extends AMultivariatePolynomial> Poly PolynomialGCD(Poly[] arr, BiFunction<Poly, Poly, Poly> algorithm) {
        arr = MultivariateGCD.nonZeroElements((AMultivariatePolynomial[])arr);
        assert (arr.length > 0);
        if (arr.length == 1) {
            return (Poly)arr[0];
        }
        if (arr.length == 2) {
            return (Poly)((AMultivariatePolynomial)algorithm.apply(arr[0], arr[1]));
        }
        for (Object object : arr) {
            if (object.isConstant()) {
                return (Poly)MultivariateGCD.contentGCD((AMultivariatePolynomial[])arr);
            }
            if (!((AMultivariatePolynomial)object).isMonomial()) continue;
            Object monomial = ((AMultivariatePolynomial)object).lt();
            for (Object object2 : arr) {
                monomial = ((AMultivariatePolynomial)object2).commonContent(monomial);
            }
            return (Poly)((AMultivariatePolynomial)arr[0]).create(monomial).monicWithLC((AMultivariatePolynomial)MultivariateGCD.contentGCD((AMultivariatePolynomial[])arr));
        }
        Arrays.sort(arr, Comparator.comparingInt(AMultivariatePolynomial::size));
        int minSize = ((AMultivariatePolynomial)arr[0]).size();
        int maxSize = ((AMultivariatePolynomial)arr[arr.length - 1]).size();
        if (maxSize / minSize > 20) {
            int split;
            for (split = 1; split < arr.length && ((AMultivariatePolynomial)arr[split]).size() < maxSize / 3; ++split) {
            }
            if (split > 1) {
                BiFunction<Poly, Poly, Poly> biFunction = MultivariateGCD.PolynomialGCD((AMultivariatePolynomial[])Arrays.copyOf(arr, split), algorithm);
                AMultivariatePolynomial[] rest = (AMultivariatePolynomial[])biFunction.createArray(arr.length - split + 1);
                rest[0] = biFunction;
                System.arraycopy(arr, split, rest, 1, arr.length - split);
                return (Poly)MultivariateGCD.PolynomialGCD(rest, algorithm);
            }
        }
        int iMin = 0;
        int n = ((AMultivariatePolynomial)arr[0]).degreeSum();
        for (int i = 1; i < arr.length; ++i) {
            int n2;
            int t = ((AMultivariatePolynomial)arr[i]).degreeSum();
            if (t >= n2) continue;
            iMin = i;
            n2 = t;
        }
        ArraysUtil.swap(arr, 0, iMin);
        Object base = arr[0];
        Object sum = ((AMultivariatePolynomial)arr[1]).clone();
        ArrayList<Object> polysNotInSum = new ArrayList<Object>();
        ArrayList<Object> polysInSum = new ArrayList<Object>();
        polysInSum.add(arr[1]);
        RandomGenerator randomGenerator = PrivateRandom.getRandom();
        int[] sumDegrees = ((AMultivariatePolynomial)sum).degreesRef();
        int nFails = 0;
        for (int i = 2; i < arr.length; ++i) {
            AMultivariatePolynomial tmp;
            while ((tmp = (AMultivariatePolynomial)((AMultivariatePolynomial)((AMultivariatePolynomial)arr[i]).clone()).multiply((long)randomGenerator.nextInt(2048))).isZero()) {
            }
            boolean bl = !arr[i].ccAsPoly().isZero() || !sum.ccAsPoly().isZero();
            int[] nArray = ArraysUtil.max(sumDegrees, tmp.degreesRef());
            if (!Arrays.equals(nArray, ((AMultivariatePolynomial)(sum = ((AMultivariatePolynomial)sum).add(tmp))).degreesRef()) || bl && sum.ccAsPoly().isZero()) {
                if (nFails == 2) {
                    nFails = 0;
                    polysNotInSum.add(arr[i]);
                } else {
                    ++nFails;
                    --i;
                }
                sum = ((AMultivariatePolynomial)sum).subtract(tmp);
                continue;
            }
            polysInSum.add(arr[i]);
            sumDegrees = nArray;
        }
        assert (polysInSum.size() + polysNotInSum.size() + 1 == arr.length);
        AMultivariatePolynomial gcd = (AMultivariatePolynomial)algorithm.apply(base, sum);
        if (gcd.isConstant()) {
            for (int i = 1; i < arr.length; ++i) {
                gcd = (AMultivariatePolynomial)algorithm.apply(gcd, (AMultivariatePolynomial)arr[i].contentAsPoly());
            }
            ArraysUtil.swap(arr, 0, iMin);
            return (Poly)gcd;
        }
        for (AMultivariatePolynomial aMultivariatePolynomial : polysNotInSum) {
            gcd = (AMultivariatePolynomial)algorithm.apply(gcd, aMultivariatePolynomial);
        }
        ArrayList<AMultivariatePolynomial> remainders = new ArrayList<AMultivariatePolynomial>();
        for (AMultivariatePolynomial aMultivariatePolynomial : polysInSum) {
            if (MultivariateDivision.dividesQ(aMultivariatePolynomial, gcd)) continue;
            remainders.add(aMultivariatePolynomial);
        }
        if (!remainders.isEmpty()) {
            for (AMultivariatePolynomial aMultivariatePolynomial : remainders) {
                gcd = (AMultivariatePolynomial)algorithm.apply(gcd, aMultivariatePolynomial);
            }
        }
        ArraysUtil.swap(arr, 0, iMin);
        return (Poly)gcd;
    }

    private static <Poly extends AMultivariatePolynomial> Poly contentGCD(Poly[] arr) {
        if (arr[0].isOverField() || !(arr[0] instanceof MultivariatePolynomial)) {
            return (Poly)((AMultivariatePolynomial)arr[0].createOne());
        }
        return (Poly)MultivariateGCD.contentGCD0((MultivariatePolynomial[])arr);
    }

    private static <E> MultivariatePolynomial<E> contentGCD0(MultivariatePolynomial<E>[] arr) {
        MultivariatePolynomial factory = arr[0];
        return factory.createConstant(factory.ring.gcd(Arrays.stream(arr).map(MultivariatePolynomial::content).collect(Collectors.toList())));
    }

    static <Poly extends AMultivariatePolynomial> Poly PolynomialGCD(Iterable<Poly> arr, BiFunction<Poly, Poly, Poly> algorithm) {
        Iterator<Poly> iterator = arr.iterator();
        ArrayList<AMultivariatePolynomial> list = new ArrayList<AMultivariatePolynomial>();
        while (iterator.hasNext()) {
            list.add((AMultivariatePolynomial)iterator.next());
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Empty iterable");
        }
        AMultivariatePolynomial[] array = (AMultivariatePolynomial[])((AMultivariatePolynomial)list.get(0)).createArray(list.size());
        return (Poly)MultivariateGCD.PolynomialGCD(list.toArray(array), algorithm);
    }

    public static <Poly extends AMultivariatePolynomial> Poly PolynomialGCD(Poly a, Poly b) {
        a.assertSameCoefficientRingWith(b);
        if (a.isOverFiniteField()) {
            return MultivariateGCD.ensureMonicOverGF(MultivariateGCD.PolynomialGCDinGF(a, b));
        }
        if (a.isOverZ()) {
            return (Poly)MultivariateGCD.PolynomialGCDinZ((MultivariatePolynomial)a, (MultivariatePolynomial)b);
        }
        if (Util.isOverRationals(a)) {
            return (Poly)MultivariateGCD.PolynomialGCDInQ((MultivariatePolynomial)a, (MultivariatePolynomial)b);
        }
        if (Util.isOverSimpleNumberField(a)) {
            return (Poly)MultivariateGCD.PolynomialGCDinNumberField((MultivariatePolynomial)a, (MultivariatePolynomial)b);
        }
        if (Util.isOverRingOfIntegersOfSimpleNumberField(a)) {
            return (Poly)MultivariateGCD.PolynomialGCDinRingOfIntegersOfNumberField((MultivariatePolynomial)a, (MultivariatePolynomial)b);
        }
        if (Util.isOverMultipleFieldExtension(a)) {
            return (Poly)MultivariateGCD.PolynomialGCDinMultipleFieldExtension((MultivariatePolynomial)a, (MultivariatePolynomial)b);
        }
        Poly r = MultivariateGCD.tryNested(a, b);
        if (r != null) {
            return r;
        }
        if (a.isOverField()) {
            return (Poly)MultivariateGCD.ZippelGCD((MultivariatePolynomial)a, (MultivariatePolynomial)b);
        }
        throw new RuntimeException();
    }

    public static <Poly extends AMultivariatePolynomial> Poly PolynomialGCDinGF(Poly a, Poly b) {
        a.assertSameCoefficientRingWith(b);
        if (!a.isOverFiniteField()) {
            throw new IllegalArgumentException();
        }
        if (MultivariateGCD.isDenseGCDProblem(a, b)) {
            return MultivariateGCD.EEZGCD(a, b, true);
        }
        if (a instanceof MultivariatePolynomialZp64) {
            return (Poly)MultivariateGCD.ZippelGCD((MultivariatePolynomialZp64)a, (MultivariatePolynomialZp64)b);
        }
        if (a instanceof MultivariatePolynomial) {
            return (Poly)MultivariateGCD.ZippelGCD((MultivariatePolynomial)a, (MultivariatePolynomial)b);
        }
        throw new RuntimeException();
    }

    public static MultivariatePolynomial<BigInteger> PolynomialGCDinZ(MultivariatePolynomial<BigInteger> a, MultivariatePolynomial<BigInteger> b) {
        a.assertSameCoefficientRingWith(b);
        if (!a.isOverZ()) {
            throw new IllegalArgumentException();
        }
        if (MultivariateGCD.isDenseGCDProblem(a, b)) {
            return MultivariateGCD.ModularGCDInZ(a, b, (u, v) -> MultivariateGCD.EEZGCD(u, v, true), true);
        }
        return MultivariateGCD.ZippelGCDInZ(a, b);
    }

    public static MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> PolynomialGCDinNumberField(MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> a, MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> b) {
        a.assertSameCoefficientRingWith(b);
        if (MultivariateGCD.isDenseGCDProblem(a, b)) {
            return MultivariateGCD.ModularGCDInNumberFieldViaRationalReconstruction(a, b, (u, v) -> MultivariateGCD.EEZGCD(u, v, true));
        }
        return MultivariateGCD.ZippelGCDInNumberFieldViaRationalReconstruction(a, b);
    }

    public static MultivariatePolynomial<UnivariatePolynomial<BigInteger>> PolynomialGCDinRingOfIntegersOfNumberField(MultivariatePolynomial<UnivariatePolynomial<BigInteger>> a, MultivariatePolynomial<UnivariatePolynomial<BigInteger>> b) {
        a.assertSameCoefficientRingWith(b);
        if (!a.lc().isConstant() || !b.lc().isConstant()) {
            throw new IllegalArgumentException("lc must be constant");
        }
        AlgebraicNumberField ring = (AlgebraicNumberField)a.ring;
        AlgebraicNumberField<UnivariatePolynomial<Rational>> field = new AlgebraicNumberField<UnivariatePolynomial<Rational>>(((UnivariatePolynomial)ring.getMinimalPolynomial()).mapCoefficients(Rings.Q, Rings.Q::mkNumerator));
        MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> gcd = MultivariateGCD.PolynomialGCDinNumberField(a.mapCoefficients(field, cf -> cf.mapCoefficients(Rings.Q, Rings.Q::mkNumerator)), b.mapCoefficients(field, cf -> cf.mapCoefficients(Rings.Q, Rings.Q::mkNumerator)));
        return gcd.multiply((UnivariatePolynomial)field.valueOfBigInteger(MultivariateGCD.iDenominator(gcd))).mapCoefficients(ring, cf -> cf.mapCoefficients(Rings.Z, Rational::numeratorExact)).primitivePart();
    }

    private static <Poly extends AMultivariatePolynomial> boolean isDenseGCDProblem(Poly a, Poly b) {
        return a.nVariables >= 4 && a.size() > 256 && b.size() > 256 && a.sparsity2() > 0.5 && b.sparsity2() > 0.5 && (a.nVariables > 4 || a.sparsity() > 0.2 && b.sparsity() > 0.2);
    }

    private static <Poly extends AMultivariatePolynomial> Poly tryNested(Poly a, Poly b) {
        if (MultivariateGCD.isOverUnivariate(a)) {
            return (Poly)MultivariateGCD.PolynomialGCDOverUnivariate((MultivariatePolynomial)a, (MultivariatePolynomial)b);
        }
        if (MultivariateGCD.isOverUnivariateZp64(a)) {
            return (Poly)MultivariateGCD.PolynomialGCDOverUnivariateZp64((MultivariatePolynomial)a, (MultivariatePolynomial)b);
        }
        if (MultivariateGCD.isOverMultivariate(a)) {
            return (Poly)MultivariateGCD.PolynomialGCDOverMultivariate((MultivariatePolynomial)a, (MultivariatePolynomial)b);
        }
        if (MultivariateGCD.isOverMultivariateZp64(a)) {
            return (Poly)MultivariateGCD.PolynomialGCDOverMultivariateZp64((MultivariatePolynomial)a, (MultivariatePolynomial)b);
        }
        return null;
    }

    static <Poly extends AMultivariatePolynomial> boolean isOverPolynomialRing(Poly p) {
        return MultivariateGCD.isOverUnivariate(p) || MultivariateGCD.isOverUnivariateZp64(p) || MultivariateGCD.isOverMultivariate(p) || MultivariateGCD.isOverMultivariateZp64(p);
    }

    static <Poly extends AMultivariatePolynomial> boolean isOverUnivariate(Poly p) {
        return p instanceof MultivariatePolynomial && ((MultivariatePolynomial)p).ring instanceof UnivariateRing && ((MultivariatePolynomial)p).lc() instanceof UnivariatePolynomial;
    }

    private static <E> MultivariatePolynomial<UnivariatePolynomial<E>> PolynomialGCDOverUnivariate(MultivariatePolynomial<UnivariatePolynomial<E>> a, MultivariatePolynomial<UnivariatePolynomial<E>> b) {
        return MultivariateGCD.PolynomialGCD(MultivariatePolynomial.asNormalMultivariate(a, 0), MultivariatePolynomial.asNormalMultivariate(b, 0)).asOverUnivariateEliminate(0);
    }

    static <Poly extends AMultivariatePolynomial> boolean isOverMultivariate(Poly p) {
        return p instanceof MultivariatePolynomial && ((MultivariatePolynomial)p).ring instanceof MultivariateRing && ((MultivariatePolynomial)p).lc() instanceof MultivariatePolynomial;
    }

    private static <E> MultivariatePolynomial<MultivariatePolynomial<E>> PolynomialGCDOverMultivariate(MultivariatePolynomial<MultivariatePolynomial<E>> a, MultivariatePolynomial<MultivariatePolynomial<E>> b) {
        int[] cfVars = ArraysUtil.sequence(a.lc().nVariables);
        int[] mainVars = ArraysUtil.sequence(a.lc().nVariables, a.lc().nVariables + a.nVariables);
        return MultivariateGCD.PolynomialGCD(MultivariatePolynomial.asNormalMultivariate(a, cfVars, mainVars), MultivariatePolynomial.asNormalMultivariate(b, cfVars, mainVars)).asOverMultivariateEliminate(cfVars);
    }

    static <Poly extends AMultivariatePolynomial> boolean isOverUnivariateZp64(Poly p) {
        return p instanceof MultivariatePolynomial && ((MultivariatePolynomial)p).ring instanceof UnivariateRing && ((MultivariatePolynomial)p).lc() instanceof UnivariatePolynomialZp64;
    }

    private static MultivariatePolynomial<UnivariatePolynomialZp64> PolynomialGCDOverUnivariateZp64(MultivariatePolynomial<UnivariatePolynomialZp64> a, MultivariatePolynomial<UnivariatePolynomialZp64> b) {
        return MultivariateGCD.PolynomialGCD(MultivariatePolynomialZp64.asNormalMultivariate(a, 0), MultivariatePolynomialZp64.asNormalMultivariate(b, 0)).asOverUnivariateEliminate(0);
    }

    static <Poly extends AMultivariatePolynomial> boolean isOverMultivariateZp64(Poly p) {
        return p instanceof MultivariatePolynomial && ((MultivariatePolynomial)p).ring instanceof MultivariateRing && ((MultivariatePolynomial)p).lc() instanceof MultivariatePolynomialZp64;
    }

    private static MultivariatePolynomial<MultivariatePolynomialZp64> PolynomialGCDOverMultivariateZp64(MultivariatePolynomial<MultivariatePolynomialZp64> a, MultivariatePolynomial<MultivariatePolynomialZp64> b) {
        int[] cfVars = ArraysUtil.sequence(a.lc().nVariables);
        int[] mainVars = ArraysUtil.sequence(a.lc().nVariables, a.lc().nVariables + a.nVariables);
        return MultivariateGCD.PolynomialGCD(MultivariatePolynomialZp64.asNormalMultivariate(a, cfVars, mainVars), MultivariatePolynomialZp64.asNormalMultivariate(b, cfVars, mainVars)).asOverMultivariateEliminate(cfVars);
    }

    private static <E> MultivariatePolynomial<Rational<E>> PolynomialGCDInQ(MultivariatePolynomial<Rational<E>> a, MultivariatePolynomial<Rational<E>> b) {
        Util.Tuple2<MultivariatePolynomial<E>, E> aRat = Util.toCommonDenominator(a);
        Util.Tuple2<MultivariatePolynomial<E>, E> bRat = Util.toCommonDenominator(b);
        return Util.asOverRationals(a.ring, MultivariateGCD.PolynomialGCD((MultivariatePolynomial)aRat._1, (MultivariatePolynomial)bRat._1));
    }

    private static <Term extends AMonomial<Term>, mPoly extends AMultivariatePolynomial<Term, mPoly>, sPoly extends IUnivariatePolynomial<sPoly>> MultivariatePolynomial<mPoly> PolynomialGCDinMultipleFieldExtension(MultivariatePolynomial<mPoly> a, MultivariatePolynomial<mPoly> b) {
        MultipleFieldExtension ring = (MultipleFieldExtension)a.ring;
        SimpleFieldExtension simpleExtension = ring.getSimpleExtension();
        return MultivariateGCD.PolynomialGCD(a.mapCoefficients(simpleExtension, ring::inverse), b.mapCoefficients(simpleExtension, ring::inverse)).mapCoefficients(ring, ring::image);
    }

    static int[] inversePermutation(int[] permutation) {
        int[] inv = new int[permutation.length];
        for (int i = permutation.length - 1; i >= 0; --i) {
            inv[permutation[i]] = i;
        }
        return inv;
    }

    private static <Poly extends AMultivariatePolynomial> Poly ensureMonicOverGF(Poly g) {
        if (g.isOverFiniteField() && !g.isMonic()) {
            return (Poly)((AMultivariatePolynomial)g.monic());
        }
        return g;
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly trivialGCD(Poly a, Poly b) {
        if (a == b) {
            return (Poly)a.clone();
        }
        if (a.isZero()) {
            return (Poly)b.clone();
        }
        if (b.isZero()) {
            return (Poly)a.clone();
        }
        if (a.isConstant() || b.isConstant()) {
            return (Poly)((AMultivariatePolynomial)a.createOne());
        }
        if (a.size() == 1) {
            return MultivariateGCD.gcdWithMonomial(a.lt(), b);
        }
        if (b.size() == 1) {
            return MultivariateGCD.gcdWithMonomial(b.lt(), a);
        }
        if (a.degree() == 1) {
            return MultivariateGCD.gcdWithLinearPoly(b, a);
        }
        if (b.degree() == 1) {
            return MultivariateGCD.gcdWithLinearPoly(a, b);
        }
        Poly eq = MultivariateGCD.equalsUpToConstant(a, b);
        if (eq != null) {
            return eq;
        }
        return null;
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly equalsUpToConstant(Poly a, Poly b) {
        if (a instanceof MultivariatePolynomial) {
            return (Poly)MultivariateGCD.equalsUpToConstant((MultivariatePolynomial)a, (MultivariatePolynomial)b);
        }
        return (Poly)MultivariateGCD.equalsUpToConstant((MultivariatePolynomialZp64)a, (MultivariatePolynomialZp64)b);
    }

    private static <E> MultivariatePolynomial<E> equalsUpToConstant(MultivariatePolynomial<E> a, MultivariatePolynomial<E> b) {
        if (a == b) {
            return a.clone();
        }
        if (a.size() != b.size()) {
            return null;
        }
        if (!((Monomial)a.lt()).dvEquals((DegreeVector)b.lt())) {
            return null;
        }
        Iterator aIt = a.terms.values().iterator();
        Iterator bIt = b.terms.values().iterator();
        Ring ring = a.ring;
        MonomialSet result = new MonomialSet((Comparator<? super DegreeVector>)((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)a.ordering)));
        Object c = ring.gcd(a.lc(), b.lc());
        if (ring.signum(a.lc()) != ring.signum(c)) {
            c = ring.negate(c);
        }
        Object aCorrection = ring.divideExact(a.lc(), c);
        Object bCorrection = ring.divideExact(b.lc(), c);
        while (aIt.hasNext()) {
            Monomial bTerm;
            Monomial aTerm = (Monomial)aIt.next();
            if (!aTerm.dvEquals(bTerm = (Monomial)bIt.next())) {
                return null;
            }
            c = ring.gcd(aTerm.coefficient, bTerm.coefficient);
            if (ring.signum(aTerm.coefficient) != ring.signum(c)) {
                c = ring.negate(c);
            }
            if (!ring.divideExact(aTerm.coefficient, c).equals(aCorrection) || !ring.divideExact(bTerm.coefficient, c).equals(bCorrection)) {
                return null;
            }
            result.add(aTerm.setCoefficient(c));
        }
        return MultivariateGCD.ensureMonicOverGF((MultivariatePolynomial)a.create(result));
    }

    private static MultivariatePolynomialZp64 equalsUpToConstant(MultivariatePolynomialZp64 a, MultivariatePolynomialZp64 b) {
        if (a == b) {
            return a.clone();
        }
        if (a.size() != b.size()) {
            return null;
        }
        if (!((MonomialZp64)a.lt()).dvEquals((DegreeVector)b.lt())) {
            return null;
        }
        Iterator aIt = a.terms.values().iterator();
        Iterator bIt = b.terms.values().iterator();
        IntegersZp64 ring = a.ring;
        long bCorrection = ring.divide(b.lc(), a.lc());
        while (aIt.hasNext()) {
            MonomialZp64 bTerm;
            MonomialZp64 aTerm = (MonomialZp64)aIt.next();
            if (!aTerm.dvEquals(bTerm = (MonomialZp64)bIt.next())) {
                return null;
            }
            long bc = ring.divide(bTerm.coefficient, aTerm.coefficient);
            if (bc == bCorrection) continue;
            return null;
        }
        return a.clone().monic();
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly gcdWithLinearPoly(Poly poly, Poly linear) {
        if (poly.isOverField()) {
            if (MultivariateDivision.dividesQ(poly, linear)) {
                return (Poly)((AMultivariatePolynomial)linear.clone().monic());
            }
            return (Poly)((AMultivariatePolynomial)linear.createOne());
        }
        return (Poly)MultivariateGCD.linearGCDe((MultivariatePolynomial)poly, (MultivariatePolynomial)linear);
    }

    private static <E> MultivariatePolynomial<E> linearGCDe(MultivariatePolynomial<E> poly, MultivariatePolynomial<E> linear) {
        E lContent = linear.content();
        E pContent = poly.content();
        Object cGCD = poly.ring.gcd(lContent, pContent);
        if (MultivariateDivision.dividesQ(poly, linear = ((MultivariatePolynomial)linear.clone()).divideExact(lContent))) {
            return linear.multiply(cGCD);
        }
        return linear.createConstant(cGCD);
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> GCDInput<Term, Poly> preparedGCDInput(Poly a, Poly b, BiFunction<Poly, Poly, Poly> gcdAlgorithm) {
        int lastGCDVariable;
        GCDInput<Term, Object> earlyGCD;
        Poly trivialGCD = MultivariateGCD.trivialGCD(a, b);
        if (trivialGCD != null) {
            return new GCDInput(trivialGCD);
        }
        BigInteger ringSize = a.coefficientRingCardinality();
        int evaluationStackLimit = ringSize == null ? -1 : (ringSize.isInt() ? ringSize.intValue() : -1);
        a = ((AMultivariatePolynomial)a).clone();
        b = ((AMultivariatePolynomial)b).clone();
        Term monomialGCD = MultivariateGCD.reduceMonomialContent(a, b);
        trivialGCD = MultivariateGCD.trivialGCD(a, b);
        if (trivialGCD != null) {
            return new GCDInput(trivialGCD.multiply(monomialGCD));
        }
        int nVariables = ((AMultivariatePolynomial)a).nVariables;
        int[] aDegrees = ((AMultivariatePolynomial)a).degreesRef();
        int[] bDegrees = ((AMultivariatePolynomial)b).degreesRef();
        int[] degreeBounds = new int[nVariables];
        int nUnused = 0;
        for (int i = 0; i < nVariables; ++i) {
            degreeBounds[i] = Math.min(aDegrees[i], bDegrees[i]);
            if (degreeBounds[i] != 0) continue;
            ++nUnused;
        }
        if (nUnused == nVariables) {
            return new GCDInput(((AMultivariatePolynomial)a).create(monomialGCD));
        }
        boolean adjusted = false;
        int maxSize = Math.max(((AMultivariatePolynomial)a).size(), ((AMultivariatePolynomial)b).size());
        int minSize = Math.min(((AMultivariatePolynomial)a).size(), ((AMultivariatePolynomial)b).size());
        if (1.0 * (double)nUnused / (double)nVariables <= 0.25 && (maxSize < EARLY_ADJUST_SMALL_POLY_SIZE_THRESHOLD || maxSize < EARLY_ADJUST_LARGE_POLY_SIZE_THRESHOLD && maxSize / minSize >= EARLY_ADJUST_POLY_DISBALANCE)) {
            MultivariateGCD.adjustDegreeBounds(a, b, degreeBounds);
            adjusted = true;
            if (Arrays.equals(degreeBounds, ((AMultivariatePolynomial)a).degreesRef()) && MultivariateDivision.dividesQ(b, a)) {
                return new GCDInput(MultivariateGCD.ensureMonicOverGF(((AMultivariatePolynomial)((AMultivariatePolynomial)a).clone()).multiply(monomialGCD)));
            }
            if (Arrays.equals(degreeBounds, ((AMultivariatePolynomial)b).degreesRef()) && MultivariateDivision.dividesQ(a, b)) {
                return new GCDInput(MultivariateGCD.ensureMonicOverGF(((AMultivariatePolynomial)((AMultivariatePolynomial)b).clone()).multiply(monomialGCD)));
            }
        }
        if ((earlyGCD = MultivariateGCD.getRidOfUnusedVariables(a, b, gcdAlgorithm, monomialGCD, degreeBounds)) != null) {
            return earlyGCD;
        }
        if (!adjusted) {
            MultivariateGCD.adjustDegreeBounds(a, b, degreeBounds);
            if (Arrays.equals(degreeBounds, ((AMultivariatePolynomial)a).degreesRef()) && MultivariateDivision.dividesQ(b, a)) {
                return new GCDInput(MultivariateGCD.ensureMonicOverGF(((AMultivariatePolynomial)((AMultivariatePolynomial)a).clone()).multiply(monomialGCD)));
            }
            if (Arrays.equals(degreeBounds, ((AMultivariatePolynomial)b).degreesRef()) && MultivariateDivision.dividesQ(a, b)) {
                return new GCDInput(MultivariateGCD.ensureMonicOverGF(((AMultivariatePolynomial)((AMultivariatePolynomial)b).clone()).multiply(monomialGCD)));
            }
        }
        if ((earlyGCD = MultivariateGCD.getRidOfUnusedVariables(a, b, gcdAlgorithm, monomialGCD, degreeBounds)) != null) {
            return earlyGCD;
        }
        int[] variables = ArraysUtil.sequence(nVariables);
        ArraysUtil.quickSort(ArraysUtil.negate(degreeBounds), variables);
        ArraysUtil.negate(degreeBounds);
        for (lastGCDVariable = 0; lastGCDVariable < degreeBounds.length && degreeBounds[lastGCDVariable] != 0; ++lastGCDVariable) {
        }
        --lastGCDVariable;
        a = AMultivariatePolynomial.renameVariables(a, variables);
        b = AMultivariatePolynomial.renameVariables(b, variables);
        int finiteExtensionDegree = 1;
        int cardinalityBound = 9 * ArraysUtil.max(degreeBounds);
        if (ringSize != null && ringSize.isInt() && ringSize.intValueExact() < cardinalityBound) {
            long ds = ringSize.intValueExact();
            finiteExtensionDegree = 2;
            long tmp = ds;
            while (tmp < (long)cardinalityBound) {
                tmp *= ds;
                ++finiteExtensionDegree;
            }
        }
        return new GCDInput<Term, Object>(a, b, monomialGCD, evaluationStackLimit, degreeBounds, variables, lastGCDVariable, finiteExtensionDegree);
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> GCDInput<Term, Poly> getRidOfUnusedVariables(Poly a, Poly b, BiFunction<Poly, Poly, Poly> gcdAlgorithm, Term monomialGCD, int[] degreeBounds) {
        int nVariables = a.nVariables;
        int nUsedVariables = 0;
        int lastGCDVariable = -1;
        for (int i = 0; i < nVariables; ++i) {
            if (degreeBounds[i] == 0) continue;
            ++nUsedVariables;
            lastGCDVariable = i;
        }
        if (nUsedVariables == 0) {
            return new GCDInput(a.create(monomialGCD));
        }
        if (nUsedVariables == 1) {
            IUnivariatePolynomial uaContent = a.asOverUnivariate(lastGCDVariable).content();
            IUnivariatePolynomial ubContent = b.asOverUnivariate(lastGCDVariable).content();
            IUnivariatePolynomial iUnivar = UnivariateGCD.PolynomialGCD(uaContent, ubContent);
            Object poly = AMultivariatePolynomial.asMultivariate(iUnivar, nVariables, lastGCDVariable, a.ordering);
            return new GCDInput(((AMultivariatePolynomial)poly).multiply(monomialGCD));
        }
        if (nUsedVariables != nVariables) {
            int[] usedVariables = new int[nUsedVariables];
            int counter = 0;
            for (int i = 0; i < nVariables; ++i) {
                if (degreeBounds[i] == 0) continue;
                usedVariables[counter++] = i;
            }
            AMultivariatePolynomial[] aEffective = MultivariateGCD.getRidOfUnusedVariables(a, (int[])degreeBounds);
            AMultivariatePolynomial[] bEffective = MultivariateGCD.getRidOfUnusedVariables(b, (int[])degreeBounds);
            AMultivariatePolynomial[] all = ArraysUtil.addAll(aEffective, bEffective);
            BiFunction<Object, Object, Object> gcd = MultivariateGCD.PolynomialGCD(all, gcdAlgorithm);
            gcd = ((AMultivariatePolynomial)((Object)gcd)).joinNewVariables(nVariables, usedVariables);
            return new GCDInput(((AMultivariatePolynomial)((Object)gcd)).multiply(monomialGCD));
        }
        return null;
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly[] getRidOfUnusedVariables(Poly poly, int[] degreeBounds) {
        TIntArrayList drop = new TIntArrayList();
        TIntArrayList unused = new TIntArrayList();
        for (int i = 0; i < poly.nVariables; ++i) {
            if (poly.degree(i) == 0) {
                drop.add(i);
                continue;
            }
            if (degreeBounds[i] != 0) continue;
            unused.add(i - drop.size());
        }
        Poly reduced = poly.dropVariables(drop.toArray());
        if (unused.isEmpty()) {
            AMultivariatePolynomial[] array = (AMultivariatePolynomial[])reduced.createArray(1);
            array[0] = reduced;
            return array;
        }
        if (unused.size() == 1) {
            return (AMultivariatePolynomial[])Arrays.stream((AMultivariatePolynomial[])((AMultivariatePolynomial)reduced).asUnivariateEliminate(unused.get(0)).getDataReferenceUnsafe()).filter(p -> !p.isZero()).toArray((IntFunction<AMultivariatePolynomial[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, createArray(int ), (I)[Lcc/redberry/rings/poly/multivar/AMultivariatePolynomial;)(reduced));
        }
        int[] usedVariables = ArraysUtil.intSetDifference(ArraysUtil.sequence(0, ((AMultivariatePolynomial)reduced).nVariables), unused.toArray());
        return (AMultivariatePolynomial[])((AMultivariatePolynomial)reduced).asOverMultivariateEliminate(usedVariables).coefficientsArray();
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> void adjustDegreeBounds(Poly a, Poly b, int[] gcdDegreeBounds) {
        if (a instanceof MultivariatePolynomialZp64) {
            MultivariateGCD.adjustDegreeBounds((MultivariatePolynomialZp64)a, (MultivariatePolynomialZp64)b, gcdDegreeBounds);
        } else if (a.isOverZ()) {
            MultivariateGCD.adjustDegreeBoundsZ((MultivariatePolynomial)a, (MultivariatePolynomial)b, gcdDegreeBounds);
        } else if (Util.isOverSimpleNumberField(a)) {
            MultivariateGCD.adjustDegreeBoundsNumberField((MultivariatePolynomial)a, (MultivariatePolynomial)b, gcdDegreeBounds);
        } else if (a.isOverFiniteField()) {
            MultivariateGCD.adjustDegreeBounds((MultivariatePolynomial)a, (MultivariatePolynomial)b, gcdDegreeBounds);
        }
    }

    private static void adjustDegreeBounds(MultivariatePolynomialZp64 a, MultivariatePolynomialZp64 b, int[] gcdDegreeBounds) {
        int nVariables = a.nVariables;
        long[] subs = new long[nVariables];
        RandomGenerator rnd = PrivateRandom.getRandom();
        if (a.coefficientRingCardinality().bitLength() <= 10) {
            int cardinality = a.coefficientRingCardinality().intValue();
            for (int i = 0; i < nVariables; ++i) {
                TLongHashSet seen = new TLongHashSet();
                do {
                    long rval;
                    if (seen.size() == cardinality) {
                        return;
                    }
                    while (seen.contains(rval = a.ring.randomElement(rnd))) {
                    }
                    seen.add(rval);
                    subs[i] = rval;
                } while (a.evaluate(i, subs[i]).isZero() || b.evaluate(i, subs[i]).isZero());
            }
        } else {
            for (int i = 0; i < nVariables; ++i) {
                subs[i] = a.ring.randomNonZeroElement(rnd);
            }
        }
        UnivariatePolynomialZp64[] uaImages = MultivariateGCD.univariateImages(a, subs);
        UnivariatePolynomialZp64[] ubImages = MultivariateGCD.univariateImages(b, subs);
        for (int i = 0; i < nVariables; ++i) {
            UnivariatePolynomialZp64 ua = uaImages[i];
            UnivariatePolynomialZp64 ub = ubImages[i];
            if (ua.degree() != a.degree(i) || ub.degree() != b.degree(i)) continue;
            gcdDegreeBounds[i] = Math.min(gcdDegreeBounds[i], UnivariateGCD.PolynomialGCD(ua, ub).degree());
        }
    }

    static UnivariatePolynomialZp64[] univariateImages(MultivariatePolynomialZp64 poly, long[] subs) {
        long[][] univariate = new long[poly.nVariables][];
        for (int i = 0; i < univariate.length; ++i) {
            univariate[i] = new long[poly.degree(i) + 1];
        }
        long[] tmp = new long[poly.nVariables];
        MultivariatePolynomialZp64.lPrecomputedPowersHolder powers = poly.mkPrecomputedPowers(subs);
        for (MonomialZp64 term : poly) {
            int i;
            Arrays.fill(tmp, term.coefficient);
            for (i = 0; i < poly.nVariables; ++i) {
                int j;
                long val = powers.pow(i, term.exponents[i]);
                for (j = 0; j < i; ++j) {
                    tmp[j] = poly.ring.multiply(tmp[j], val);
                }
                for (j = i + 1; j < poly.nVariables; ++j) {
                    tmp[j] = poly.ring.multiply(tmp[j], val);
                }
            }
            for (i = 0; i < poly.nVariables; ++i) {
                univariate[i][term.exponents[i]] = poly.ring.add(univariate[i][term.exponents[i]], tmp[i]);
            }
        }
        UnivariatePolynomialZp64[] result = new UnivariatePolynomialZp64[poly.nVariables];
        for (int i = 0; i < poly.nVariables; ++i) {
            result[i] = UnivariatePolynomialZp64.createUnsafe(poly.ring, univariate[i]);
        }
        return result;
    }

    static <E> void adjustDegreeBounds(MultivariatePolynomial<E> a, MultivariatePolynomial<E> b, int[] gcdDegreeBounds) {
        int nVariables = a.nVariables;
        int[] subs = a.ring.createArray(nVariables);
        RandomGenerator rnd = PrivateRandom.getRandom();
        if (a.coefficientRingCardinality() != null && a.coefficientRingCardinality().bitLength() <= 10) {
            int cardinality = a.coefficientRingCardinality().intValue();
            for (int i = 0; i < nVariables; ++i) {
                HashSet seen = new HashSet();
                do {
                    Object rval;
                    if (seen.size() == cardinality) {
                        return;
                    }
                    while (seen.contains(rval = MultivariateGCD.randomElement(a.ring, rnd))) {
                    }
                    seen.add(rval);
                    subs[i] = (int)rval;
                } while (a.evaluate(i, subs[i]).isZero() || b.evaluate(i, subs[i]).isZero());
            }
        } else {
            for (int i = 0; i < nVariables; ++i) {
                subs[i] = (int)MultivariateGCD.randomElement(a.ring, rnd);
            }
        }
        UnivariatePolynomial<int>[] uaImages = MultivariateGCD.univariateImages(a, subs);
        UnivariatePolynomial<int>[] ubImages = MultivariateGCD.univariateImages(b, subs);
        for (int i = 0; i < nVariables; ++i) {
            UnivariatePolynomial<int> ua = uaImages[i];
            UnivariatePolynomial<int> ub = ubImages[i];
            if (ua.degree() != a.degree(i) || ub.degree() != b.degree(i)) continue;
            gcdDegreeBounds[i] = Math.min(gcdDegreeBounds[i], UnivariateGCD.PolynomialGCD(ua, ub).degree());
        }
    }

    /*
     * WARNING - void declaration
     */
    static <E> UnivariatePolynomial<E>[] univariateImages(MultivariatePolynomial<E> poly, E[] subs) {
        void var6_9;
        E[][] univariate = poly.ring.createArray2d(poly.nVariables);
        for (int i = 0; i < univariate.length; ++i) {
            univariate[i] = poly.ring.createZeroesArray(poly.degree(i) + 1);
        }
        int[] tmp = poly.ring.createArray(poly.nVariables);
        MultivariatePolynomial.PrecomputedPowersHolder<E> powers = poly.mkPrecomputedPowers(subs);
        for (Monomial monomial : poly) {
            int i;
            Arrays.fill((Object[])tmp, monomial.coefficient);
            for (i = 0; i < poly.nVariables; ++i) {
                int j;
                E val = powers.pow(i, monomial.exponents[i]);
                for (j = 0; j < i; ++j) {
                    tmp[j] = poly.ring.multiply(tmp[j], (int)val);
                }
                for (j = i + 1; j < poly.nVariables; ++j) {
                    tmp[j] = poly.ring.multiply(tmp[j], (int)val);
                }
            }
            for (i = 0; i < poly.nVariables; ++i) {
                univariate[i][monomial.exponents[i]] = poly.ring.add((int)univariate[i][monomial.exponents[i]], tmp[i]);
            }
        }
        UnivariatePolynomial[] result = new UnivariatePolynomial[poly.nVariables];
        boolean bl = false;
        while (var6_9 < poly.nVariables) {
            result[var6_9] = UnivariatePolynomial.createUnsafe(poly.ring, univariate[var6_9]);
            assert (result[var6_9].equals(poly.evaluate(ArraysUtil.remove(ArraysUtil.sequence(0, poly.nVariables), (int)var6_9), ArraysUtil.remove(subs, (int)var6_9)).asUnivariate()));
            ++var6_9;
        }
        return result;
    }

    static void adjustDegreeBoundsZ(MultivariatePolynomial<BigInteger> a, MultivariatePolynomial<BigInteger> b, int[] gcdDegreeBounds) {
        IntegersZp64 zpRing = Rings.Zp64(SmallPrimes.nextPrime(0x100000 + PrivateRandom.getRandom().nextInt(1024)));
        MultivariatePolynomialZp64 aMod = MultivariatePolynomial.asOverZp64(a, zpRing);
        MultivariatePolynomialZp64 bMod = MultivariatePolynomial.asOverZp64(b, zpRing);
        MultivariateGCD.adjustDegreeBounds(aMod, bMod, gcdDegreeBounds);
        if (ArraysUtil.sum(gcdDegreeBounds) == 0) {
            return;
        }
        int nVariables = a.nVariables;
        Object[] subs = new BigInteger[a.nVariables];
        Arrays.fill(subs, BigInteger.ONE);
        UnivariatePolynomial<BigInteger>[] uaImages = MultivariateGCD.univariateImagesZ(a, (BigInteger[])subs);
        UnivariatePolynomial<BigInteger>[] ubImages = MultivariateGCD.univariateImagesZ(b, (BigInteger[])subs);
        for (int i = 0; i < nVariables; ++i) {
            UnivariatePolynomial<BigInteger> ua = uaImages[i];
            UnivariatePolynomial<BigInteger> ub = ubImages[i];
            if (ua.degree() != a.degree(i) || ub.degree() != b.degree(i)) continue;
            gcdDegreeBounds[i] = Math.min(gcdDegreeBounds[i], UnivariateGCD.PolynomialGCD(ua, ub).degree());
        }
    }

    static void adjustDegreeBoundsNumberField(MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> a, MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> b, int[] gcdDegreeBounds) {
        IntegersZp64 zpRing = Rings.Zp64(SmallPrimes.nextPrime(0x100000 + PrivateRandom.getRandom().nextInt(1024)));
        AlgebraicNumberField ring = (AlgebraicNumberField)a.ring;
        FiniteField<UnivariatePolynomialZp64> numberFieldMod = new FiniteField<UnivariatePolynomialZp64>(UnivariatePolynomial.asOverZp64Q((UnivariatePolynomial)ring.getMinimalPolynomial(), zpRing));
        MultivariatePolynomial<UnivariatePolynomialZp64> aMod = a.mapCoefficients(numberFieldMod, cf -> UnivariatePolynomial.asOverZp64Q(cf, zpRing));
        MultivariatePolynomial<UnivariatePolynomialZp64> bMod = b.mapCoefficients(numberFieldMod, cf -> UnivariatePolynomial.asOverZp64Q(cf, zpRing));
        MultivariateGCD.adjustDegreeBounds(aMod, bMod, gcdDegreeBounds);
    }

    /*
     * WARNING - void declaration
     */
    static UnivariatePolynomial<BigInteger>[] univariateImagesZ(MultivariatePolynomial<BigInteger> poly, BigInteger[] subs) {
        void var5_8;
        assert (Arrays.stream(subs).allMatch(BigInteger::isOne));
        BigInteger[][] univariate = new BigInteger[poly.nVariables][];
        for (int i = 0; i < univariate.length; ++i) {
            univariate[i] = new BigInteger[poly.degree(i) + 1];
            Arrays.fill(univariate[i], BigInteger.ZERO);
        }
        Object[] tmp = (BigInteger[])poly.ring.createArray(poly.nVariables);
        for (Monomial monomial : poly) {
            Arrays.fill(tmp, monomial.coefficient);
            for (int i = 0; i < poly.nVariables; ++i) {
                univariate[i][monomial.exponents[i]] = (BigInteger)poly.ring.add(univariate[i][monomial.exponents[i]], tmp[i]);
            }
        }
        UnivariatePolynomial[] result = new UnivariatePolynomial[poly.nVariables];
        boolean bl = false;
        while (var5_8 < poly.nVariables) {
            result[var5_8] = UnivariatePolynomial.createUnsafe(poly.ring, univariate[var5_8]);
            assert (result[var5_8].equals(poly.evaluate(ArraysUtil.remove(ArraysUtil.sequence(0, poly.nVariables), (int)var5_8), (E[])ArraysUtil.remove(subs, (int)var5_8)).asUnivariate()));
            ++var5_8;
        }
        return result;
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly gcdWithMonomial(Term monomial, Poly poly) {
        return poly.create(poly.commonContent(monomial));
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Term reduceMonomialContent(Poly a, Poly b) {
        Term aMonomialContent = a.monomialContent();
        int[] exponentsGCD = ((AMonomial)b.monomialContent()).exponents;
        AMultivariatePolynomial.setMin(((AMonomial)aMonomialContent).exponents, exponentsGCD);
        Object monomialGCD = a.monomialAlgebra.create(exponentsGCD);
        a = a.divideDegreeVectorOrNull((DegreeVector)monomialGCD);
        b = b.divideDegreeVectorOrNull((DegreeVector)monomialGCD);
        assert (a != null && b != null);
        a = a.divideDegreeVectorOrNull((DegreeVector)a.monomialContent());
        b = b.divideDegreeVectorOrNull((DegreeVector)b.monomialContent());
        assert (a != null && b != null);
        return monomialGCD;
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>, uPoly extends IUnivariatePolynomial<uPoly>> MultivariatePolynomial<uPoly> asOverUnivariate(Poly poly, int variable) {
        if (poly instanceof MultivariatePolynomial) {
            return ((MultivariatePolynomial)poly).asOverUnivariateEliminate(variable);
        }
        if (poly instanceof MultivariatePolynomialZp64) {
            return ((MultivariatePolynomialZp64)poly).asOverUnivariateEliminate(variable);
        }
        throw new RuntimeException();
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>, uPoly extends IUnivariatePolynomial<uPoly>> UnivariateContent<Term, Poly, uPoly> univariateContent(Poly poly, int variable) {
        MultivariatePolynomial<uPoly> conv = MultivariateGCD.asOverUnivariate(poly, variable);
        uPoly uContent = UnivariateGCD.PolynomialGCD(conv.coefficients());
        Object mContent = AMultivariatePolynomial.asMultivariate(uContent, poly.nVariables, variable, poly.ordering);
        Poly primitivePart = MultivariateDivision.divideExact(poly, mContent);
        return new UnivariateContent(conv, primitivePart, uContent);
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>, uPoly extends IUnivariatePolynomial<uPoly>> PrimitiveInput<Term, Poly, uPoly> makePrimitive(Poly a, Poly b, int variable) {
        UnivariateContent<Term, Poly, uPoly> aContent = MultivariateGCD.univariateContent(a, variable);
        UnivariateContent<Term, Poly, uPoly> bContent = MultivariateGCD.univariateContent(b, variable);
        a = aContent.primitivePart;
        b = bContent.primitivePart;
        Object contentGCD = UnivariateGCD.PolynomialGCD(aContent.content, bContent.content);
        IUnivariatePolynomial lcGCD = UnivariateGCD.PolynomialGCD((IUnivariatePolynomial)aContent.poly.lc(), (IUnivariatePolynomial)bContent.poly.lc());
        return new PrimitiveInput(a, b, (IUnivariatePolynomial)contentGCD, lcGCD);
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly[] multivariateCoefficients(Poly poly, int variable) {
        return (AMultivariatePolynomial[])Arrays.stream(poly.degrees(variable)).mapToObj(d -> poly.coefficientOf(variable, d)).toArray((IntFunction<AMultivariatePolynomial[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, createArray(int ), (I)[Lcc/redberry/rings/poly/multivar/AMultivariatePolynomial;)(poly));
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly contentGCD(Poly a, Poly b, int variable, BiFunction<Poly, Poly, Poly> algorithm) {
        AMultivariatePolynomial[] aCfs = MultivariateGCD.multivariateCoefficients(a, (int)variable);
        AMultivariatePolynomial[] bCfs = MultivariateGCD.multivariateCoefficients(b, (int)variable);
        AMultivariatePolynomial[] all = (AMultivariatePolynomial[])a.createArray(aCfs.length + bCfs.length);
        System.arraycopy(aCfs, 0, all, 0, aCfs.length);
        System.arraycopy(bCfs, 0, all, aCfs.length, bCfs.length);
        BiFunction<Poly, Poly, Poly> gcd = MultivariateGCD.PolynomialGCD(all, algorithm);
        assert (MultivariateDivision.dividesQ(a, gcd));
        assert (MultivariateDivision.dividesQ(b, gcd));
        return (Poly)gcd;
    }

    static <E> E randomElement(Ring<E> ring, RandomGenerator rnd) {
        if (ring.isFiniteField() && ring.characteristic().bitLength() > 16) {
            return ring.valueOf(rnd.nextLong());
        }
        if (ring == Rings.Q || ring == Rings.Z || ring instanceof AlgebraicNumberField) {
            return ring.valueOf((long)rnd.nextInt(65536));
        }
        return ring.randomElement(rnd);
    }

    public static MultivariatePolynomial<BigInteger> ZippelGCDInZ(MultivariatePolynomial<BigInteger> a, MultivariatePolynomial<BigInteger> b) {
        Util.ensureOverZ(a, b);
        if (a == b) {
            return a.clone();
        }
        if (a.isZero()) {
            return b.clone();
        }
        if (b.isZero()) {
            return a.clone();
        }
        if (a.degree() < b.degree()) {
            return MultivariateGCD.ZippelGCDInZ(b, a);
        }
        BigInteger aContent = a.content();
        BigInteger bContent = b.content();
        BigInteger contentGCD = BigIntegerUtil.gcd(aContent, bContent);
        if (a.isConstant() || b.isConstant()) {
            return a.createConstant(contentGCD);
        }
        a = ((MultivariatePolynomial)a.clone()).divideOrNull(aContent);
        b = ((MultivariatePolynomial)b.clone()).divideOrNull(bContent);
        return MultivariateGCD.ZippelGCDInZ0(a, b).multiply(contentGCD);
    }

    /*
     * Unable to fully structure code
     */
    static MultivariatePolynomial<BigInteger> ZippelGCDInZ0(MultivariatePolynomial<BigInteger> a, MultivariatePolynomial<BigInteger> b) {
        gcdInput = MultivariateGCD.preparedGCDInput(a, b, (BiFunction<MultivariatePolynomial, MultivariatePolynomial, MultivariatePolynomial>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, ZippelGCDInZ(cc.redberry.rings.poly.multivar.MultivariatePolynomial<cc.redberry.rings.bigint.BigInteger> cc.redberry.rings.poly.multivar.MultivariatePolynomial<cc.redberry.rings.bigint.BigInteger> ), (Lcc/redberry/rings/poly/multivar/MultivariatePolynomial;Lcc/redberry/rings/poly/multivar/MultivariatePolynomial;)Lcc/redberry/rings/poly/multivar/MultivariatePolynomial;)());
        if (gcdInput.earlyGCD != null) {
            return (MultivariatePolynomial)gcdInput.earlyGCD;
        }
        a = (MultivariatePolynomial)gcdInput.aReduced;
        b = (MultivariatePolynomial)gcdInput.bReduced;
        pContentGCD = MultivariateGCD.contentGCD(a, b, 0, (BiFunction<MultivariatePolynomial, MultivariatePolynomial, MultivariatePolynomial>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, ZippelGCDInZ(cc.redberry.rings.poly.multivar.MultivariatePolynomial<cc.redberry.rings.bigint.BigInteger> cc.redberry.rings.poly.multivar.MultivariatePolynomial<cc.redberry.rings.bigint.BigInteger> ), (Lcc/redberry/rings/poly/multivar/MultivariatePolynomial;Lcc/redberry/rings/poly/multivar/MultivariatePolynomial;)Lcc/redberry/rings/poly/multivar/MultivariatePolynomial;)());
        if (!pContentGCD.isConstant()) {
            a = MultivariateDivision.divideExact(a, pContentGCD);
            b = MultivariateDivision.divideExact(b, pContentGCD);
            return gcdInput.restoreGCD(MultivariateGCD.ZippelGCDInZ(a, b).multiply(pContentGCD));
        }
        lcGCD = BigIntegerUtil.gcd((BigInteger)a.lc(), (BigInteger)b.lc());
        ccGCD = BigIntegerUtil.gcd((BigInteger)a.cc(), (BigInteger)b.cc());
        startingPrime = Math.max(lcGCD.bitLength(), ccGCD.bitLength()) < 128 ? 0x40000000L : 0x1000000000000000L;
        primesLoop = new PrimesIterator(startingPrime - 4096L);
        random = PrivateRandom.getRandom();
        block0: while (true) {
            basePrime = primesLoop.take();
            bPrime = BigInteger.valueOf(basePrime);
            if (!MultivariateGCD.$assertionsDisabled && basePrime == -1L) {
                throw new AssertionError((Object)"long overflow");
            }
            ring = new IntegersZp(basePrime);
            abMod = a.setRing(ring);
            bbMod = b.setRing(ring);
            if (!abMod.sameSkeletonQ(a) || !bbMod.sameSkeletonQ(b)) continue;
            aMod = MultivariatePolynomial.asOverZp64(abMod);
            bMod = MultivariatePolynomial.asOverZp64(bbMod);
            base = MultivariateGCD.PolynomialGCD(aMod, bMod);
            lLcGCD = lcGCD.mod(bPrime).longValueExact();
            if ((base = base.monic(lLcGCD)).isConstant()) {
                return gcdInput.restoreGCD((MultivariatePolynomial)a.createOne());
            }
            previousBase = null;
            while (!MachineArithmetic.isOverflowMultiply(basePrime, prime = primesLoop.take()) && basePrime * prime <= 0x3FFFFFFFFFFFFFFFL) {
                bPrime = BigInteger.valueOf(prime);
                ring = new IntegersZp(bPrime);
                abMod = a.setRing(ring);
                bbMod = b.setRing(ring);
                if (!abMod.sameSkeletonQ(a) || !bbMod.sameSkeletonQ(b)) continue;
                aMod = MultivariatePolynomial.asOverZp64(abMod);
                modularGCD = MultivariateGCD.interpolateGCD(aMod, bMod = MultivariatePolynomial.asOverZp64(bbMod), base.setRingUnsafe(lDomain = new IntegersZp64(prime)), random);
                if (modularGCD == null || !MultivariateDivision.dividesQ(aMod, modularGCD) || !MultivariateDivision.dividesQ(bMod, modularGCD)) continue block0;
                if (modularGCD.isConstant()) {
                    return gcdInput.restoreGCD((MultivariatePolynomial)a.createOne());
                }
                if (modularGCD.degree(0) < base.degree(0)) {
                    lLcGCD = lcGCD.mod(bPrime).longValueExact();
                    base = modularGCD.monic(lLcGCD);
                    basePrime = prime;
                    previousBase = null;
                    continue;
                }
                if (modularGCD.degree(0) > base.degree(0)) continue;
                newBasePrime = basePrime * prime;
                monicFactor = modularGCD.ring.multiply(MachineArithmetic.modInverse(modularGCD.lc(), prime), lcGCD.mod(bPrime).longValueExact());
                magic = ChineseRemainders.createMagic(basePrime, prime);
                iterator = new PairedIterator<Term1, MultivariatePolynomialZp64, Term2, MultivariatePolynomialZp64>(base, modularGCD);
                while (iterator.hasNext()) {
                    iterator.advance();
                    baseTerm = (MonomialZp64)iterator.aTerm;
                    imageTerm = (MonomialZp64)iterator.bTerm;
                    if (baseTerm.coefficient == 0L) continue;
                    if (imageTerm.coefficient == 0L) {
                        iterator.aIterator.remove();
                        continue;
                    }
                    oth = lDomain.multiply(imageTerm.coefficient, monicFactor);
                    newCoeff = ChineseRemainders.ChineseRemainders(magic, baseTerm.coefficient, oth);
                    base.put(baseTerm.setCoefficient(newCoeff));
                }
                base = base.setRingUnsafe(new IntegersZp64(newBasePrime));
                basePrime = newBasePrime;
                candidate = base.asPolyZSymmetric().primitivePart();
                if (previousBase != null && candidate.equals(previousBase)) {
                    previousBase = candidate;
                    if (!MultivariateDivision.dividesQ(b, candidate) || !MultivariateDivision.dividesQ(a, candidate)) continue;
                    return gcdInput.restoreGCD((MultivariatePolynomial)candidate);
                }
                previousBase = candidate;
            }
            bBase = base.toBigPoly();
            bBasePrime = BigInteger.valueOf(basePrime);
            while (true) {
                prime = primesLoop.take();
                bPrime = BigInteger.valueOf(prime);
                ring = new IntegersZp(bPrime);
                abMod = a.setRing(ring);
                bbMod = b.setRing(ring);
                if (!abMod.sameSkeletonQ(a) || !bbMod.sameSkeletonQ(b)) continue;
                aMod = MultivariatePolynomial.asOverZp64(abMod);
                modularGCD = MultivariateGCD.interpolateGCD(aMod, bMod = MultivariatePolynomial.asOverZp64(bbMod), base.setRingUnsafe(lDomain = new IntegersZp64(prime)), random);
                if (modularGCD != null) ** break;
                continue block0;
                if (!MultivariateGCD.$assertionsDisabled && !MultivariateDivision.dividesQ(aMod, modularGCD)) {
                    throw new AssertionError();
                }
                if (!MultivariateGCD.$assertionsDisabled && !MultivariateDivision.dividesQ(bMod, modularGCD)) {
                    throw new AssertionError();
                }
                if (modularGCD.isConstant()) {
                    return gcdInput.restoreGCD((MultivariatePolynomial)a.createOne());
                }
                if (modularGCD.degree(0) < bBase.degree(0)) {
                    lLcGCD = lcGCD.mod(bPrime).longValueExact();
                    base = modularGCD.monic(lLcGCD);
                    bBase = base.toBigPoly();
                    bBasePrime = bPrime;
                    previousBase = null;
                    continue;
                }
                if (modularGCD.degree(0) > bBase.degree(0)) continue;
                newBasePrime = bBasePrime.multiply(bPrime);
                monicFactor = lDomain.multiply(lDomain.reciprocal(modularGCD.lc()), lcGCD.mod(bPrime).longValueExact());
                iterator = new PairedIterator<Term1, MultivariatePolynomial<BigInteger>, Term2, MultivariatePolynomialZp64>(bBase, modularGCD);
                magic = ChineseRemainders.createMagic(Rings.Z, bBasePrime, bPrime);
                while (iterator.hasNext()) {
                    iterator.advance();
                    baseTerm = (Monomial)iterator.aTerm;
                    imageTerm = (MonomialZp64)iterator.bTerm;
                    if (((BigInteger)baseTerm.coefficient).isZero()) continue;
                    if (imageTerm.coefficient == 0L) {
                        iterator.aIterator.remove();
                        continue;
                    }
                    oth = lDomain.multiply(imageTerm.coefficient, monicFactor);
                    newCoeff = ChineseRemainders.ChineseRemainders(Rings.Z, magic, (BigInteger)baseTerm.coefficient, BigInteger.valueOf(oth));
                    bBase.put(baseTerm.setCoefficient(newCoeff));
                }
                bBase = bBase.setRingUnsafe(new IntegersZp(newBasePrime));
                bBasePrime = newBasePrime;
                candidate = MultivariatePolynomial.asPolyZSymmetric(bBase).primitivePart();
                if (previousBase != null && candidate.equals(previousBase)) {
                    previousBase = candidate;
                    if (!MultivariateGCD.isGCDTriplet(b, a, candidate)) continue;
                    return gcdInput.restoreGCD((MultivariatePolynomial)candidate);
                }
                previousBase = candidate;
            }
            break;
        }
    }

    static MultivariatePolynomialZp64 interpolateGCD(MultivariatePolynomialZp64 a, MultivariatePolynomialZp64 b, MultivariatePolynomialZp64 skeleton, RandomGenerator rnd) {
        a.assertSameCoefficientRingWith(b);
        a.assertSameCoefficientRingWith(skeleton);
        assert (MultivariateGCD.contentGCD(a, b, 0, MultivariateGCD::PolynomialGCD).isConstant());
        lSparseInterpolation interpolation = MultivariateGCD.createInterpolation(-1, a, b, skeleton, 1, rnd);
        if (interpolation == null) {
            return null;
        }
        MultivariatePolynomialZp64 gcd = interpolation.evaluate();
        if (gcd == null) {
            return null;
        }
        return gcd;
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly divideSkeletonExact(Poly dividend, Poly divider) {
        if (divider.isConstant()) {
            return dividend;
        }
        if (divider.isMonomial()) {
            return ((AMultivariatePolynomial)dividend.clone()).divideDegreeVectorOrNull((DegreeVector)divider.lt());
        }
        dividend = ((AMultivariatePolynomial)dividend.clone()).setAllCoefficientsToUnit();
        divider = ((AMultivariatePolynomial)divider.clone()).setAllCoefficientsToUnit();
        AMultivariatePolynomial quotient = (AMultivariatePolynomial)dividend.createZero();
        dividend = dividend.clone();
        while (!dividend.isZero()) {
            Object dlt = dividend.lt();
            Term ltDiv = ((AMonomial)dlt).divideOrNull((DegreeVector)divider.lt());
            if (ltDiv == null) {
                throw new RuntimeException();
            }
            quotient = quotient.add(ltDiv);
            dividend = dividend.subtract(((AMultivariatePolynomial)divider.clone()).multiply(ltDiv));
        }
        return (Poly)quotient;
    }

    public static MultivariatePolynomial<BigInteger> ModularGCDInZ(MultivariatePolynomial<BigInteger> a, MultivariatePolynomial<BigInteger> b, BiFunction<MultivariatePolynomialZp64, MultivariatePolynomialZp64, MultivariatePolynomialZp64> gcdInZp) {
        return MultivariateGCD.ModularGCDInZ(a, b, gcdInZp, false);
    }

    static MultivariatePolynomial<BigInteger> ModularGCDInZ(MultivariatePolynomial<BigInteger> a, MultivariatePolynomial<BigInteger> b, BiFunction<MultivariatePolynomialZp64, MultivariatePolynomialZp64, MultivariatePolynomialZp64> gcdInZp, boolean switchToSparse) {
        Util.ensureOverZ(a, b);
        if (a == b) {
            return a.clone();
        }
        if (a.isZero()) {
            return b.clone();
        }
        if (b.isZero()) {
            return a.clone();
        }
        BigInteger aContent = a.content();
        BigInteger bContent = b.content();
        BigInteger contentGCD = BigIntegerUtil.gcd(aContent, bContent);
        if (a.isConstant() || b.isConstant()) {
            return a.createConstant(contentGCD);
        }
        a = ((MultivariatePolynomial)a.clone()).divideOrNull(aContent);
        b = ((MultivariatePolynomial)b.clone()).divideOrNull(bContent);
        return MultivariateGCD.ModularGCDInZ0(a, b, gcdInZp, switchToSparse).multiply(contentGCD);
    }

    static MultivariatePolynomial<BigInteger> ModularGCDInZ0(MultivariatePolynomial<BigInteger> a, MultivariatePolynomial<BigInteger> b, BiFunction<MultivariatePolynomialZp64, MultivariatePolynomialZp64, MultivariatePolynomialZp64> gcdInZp, boolean switchToSparse) {
        IPolynomial candidate;
        GCDInput gcdInput = MultivariateGCD.preparedGCDInput(a, b, MultivariateGCD::ZippelGCDInZ);
        if (gcdInput.earlyGCD != null) {
            return (MultivariatePolynomial)gcdInput.earlyGCD;
        }
        a = (MultivariatePolynomial)gcdInput.aReduced;
        b = (MultivariatePolynomial)gcdInput.bReduced;
        if (switchToSparse && !MultivariateGCD.isDenseGCDProblem(a, b)) {
            gcdInput.restoreGCD(MultivariateGCD.PolynomialGCD(a, b));
        }
        BigInteger lcGCD = BigIntegerUtil.gcd((BigInteger)a.lc(), (BigInteger)b.lc());
        MultivariatePolynomial<BigInteger> base = null;
        PrimesIterator primesLoop = new PrimesIterator(61440L);
        BigInteger bBasePrime = null;
        while (true) {
            MultivariatePolynomialZp64 bMod;
            BigInteger bPrime = BigInteger.valueOf(primesLoop.take());
            IntegersZp bRing = new IntegersZp(bPrime);
            MultivariatePolynomial<BigInteger> abMod = a.setRing(bRing);
            MultivariatePolynomial<BigInteger> bbMod = b.setRing(bRing);
            if (!abMod.sameSkeletonQ(a) || !bbMod.sameSkeletonQ(b)) continue;
            MultivariatePolynomialZp64 aMod = MultivariatePolynomial.asOverZp64(abMod);
            MultivariatePolynomialZp64 modGCD = gcdInZp.apply(aMod, bMod = MultivariatePolynomial.asOverZp64(bbMod));
            if (modGCD.isConstant()) {
                return gcdInput.restoreGCD((MultivariatePolynomial)a.createOne());
            }
            long lLcGCD = lcGCD.mod(bPrime).longValueExact();
            modGCD = modGCD.monic(lLcGCD);
            if (base == null) {
                base = modGCD.toBigPoly();
                bBasePrime = bPrime;
                continue;
            }
            IntegersZp64 pRing = bRing.asMachineRing();
            BigInteger newBasePrime = bBasePrime.multiply(bPrime);
            long monicFactor = pRing.multiply(pRing.reciprocal(modGCD.lc()), lcGCD.mod(bPrime).longValueExact());
            PairedIterator iterator = new PairedIterator(base, modGCD);
            ChineseRemainders.ChineseRemaindersMagic<BigInteger> magic = ChineseRemainders.createMagic(Rings.Z, bBasePrime, bPrime);
            while (iterator.hasNext()) {
                iterator.advance();
                Monomial baseTerm = (Monomial)iterator.aTerm;
                MonomialZp64 imageTerm = (MonomialZp64)iterator.bTerm;
                if (((BigInteger)baseTerm.coefficient).isZero()) continue;
                if (imageTerm.coefficient == 0L) {
                    iterator.aIterator.remove();
                    continue;
                }
                long oth = pRing.multiply(imageTerm.coefficient, monicFactor);
                BigInteger newCoeff = ChineseRemainders.ChineseRemainders(Rings.Z, magic, (BigInteger)baseTerm.coefficient, BigInteger.valueOf(oth));
                base.put(baseTerm.setCoefficient(newCoeff));
            }
            base = base.setRingUnsafe(new IntegersZp(newBasePrime));
            bBasePrime = newBasePrime;
            candidate = MultivariatePolynomial.asPolyZSymmetric(base).primitivePart();
            if (MultivariateGCD.isGCDTriplet(b, a, candidate)) break;
        }
        return gcdInput.restoreGCD((MultivariatePolynomial)candidate);
    }

    private static <E> MultivariatePolynomial<UnivariatePolynomial<E>> TrivialGCDInExtension(MultivariatePolynomial<UnivariatePolynomial<E>> a, MultivariatePolynomial<UnivariatePolynomial<E>> b) {
        AlgebraicNumberField ring;
        block3: {
            block2: {
                ring = (AlgebraicNumberField)a.ring;
                if (!a.stream().allMatch(ring::isInTheBaseField)) break block2;
                if (b.stream().allMatch(ring::isInTheBaseField)) break block3;
            }
            return null;
        }
        Ring cfRing = ((UnivariatePolynomial)ring.getMinimalPolynomial()).ring;
        MultivariatePolynomial<Object> ar = a.mapCoefficients(cfRing, UnivariatePolynomial::cc);
        MultivariatePolynomial<Object> br = b.mapCoefficients(cfRing, UnivariatePolynomial::cc);
        return MultivariateGCD.PolynomialGCD(ar, br).mapCoefficients(ring, cf -> UnivariatePolynomial.constant(cfRing, cf));
    }

    static BigInteger iContent(MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> a) {
        return (BigInteger)Rings.Z.gcd(a.stream().flatMap(UnivariatePolynomial::stream).map(Rational::numerator).collect(Collectors.toList()));
    }

    static BigInteger iDenominator(MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> a) {
        return (BigInteger)Rings.Z.lcm(a.stream().flatMap(UnivariatePolynomial::stream).map(Rational::denominator).collect(Collectors.toList()));
    }

    static BigInteger iMax(MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> a) {
        return a.stream().flatMap(p -> p.stream().flatMap(cf -> Stream.of((BigInteger)cf.numerator(), (BigInteger)cf.denominator()))).map(Rings.Z::abs).max(Rings.Z).orElse(Rings.Z.getZero());
    }

    static BigInteger iMaxZ(MultivariatePolynomial<UnivariatePolynomial<BigInteger>> a) {
        return a.stream().flatMap(UnivariatePolynomial::stream).map(Rings.Z::abs).max(Rings.Z).orElse(Rings.Z.getZero());
    }

    private static MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> PolynomialGCDInNumberFieldSwitchToRingOfInteger(MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> a, MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> b, BiFunction<MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>>, MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>>, MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>>> algorithmInRing) {
        MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> simpleGCD = MultivariateGCD.TrivialGCDInExtension(a, b);
        if (simpleGCD != null) {
            return simpleGCD;
        }
        AlgebraicNumberField numberField = (AlgebraicNumberField)a.ring;
        UnivariatePolynomial minimalPoly = (UnivariatePolynomial)numberField.getMinimalPolynomial();
        if (minimalPoly.stream().allMatch(Rational::isIntegral)) {
            a = a.clone();
            b = b.clone();
            BigInteger aiCont = MultivariateGCD.iContent(a);
            BigInteger biCont = MultivariateGCD.iContent(b);
            a.multiply(UnivariatePolynomial.constant(Rings.Q, Rings.Q.mkDenominator(aiCont)));
            b.multiply(UnivariatePolynomial.constant(Rings.Q, Rings.Q.mkDenominator(biCont)));
            BigInteger aiDen = MultivariateGCD.iDenominator(a);
            BigInteger biDen = MultivariateGCD.iDenominator(b);
            a.multiply(UnivariatePolynomial.constant(Rings.Q, Rings.Q.mkNumerator(aiDen)));
            b.multiply(UnivariatePolynomial.constant(Rings.Q, Rings.Q.mkNumerator(biDen)));
            return algorithmInRing.apply(a, b);
        }
        BigInteger minPolyLeadCoeff = (BigInteger)Util.commonDenominator(minimalPoly);
        Rational<BigInteger> scale = new Rational<BigInteger>(Rings.Z, Rings.Z.getOne(), minPolyLeadCoeff);
        Rational<BigInteger> scaleReciprocal = scale.reciprocal();
        AlgebraicNumberField<IPolynomial> numberFieldScaled = new AlgebraicNumberField<IPolynomial>(minimalPoly.scale(scale).monic());
        return MultivariateGCD.PolynomialGCDInNumberFieldSwitchToRingOfInteger(a.mapCoefficients(numberFieldScaled, cf -> cf.scale(scale)), b.mapCoefficients(numberFieldScaled, cf -> cf.scale(scale)), algorithmInRing).mapCoefficients(numberField, cf -> cf.scale(scaleReciprocal));
    }

    private static MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> PolynomialGCDAssociateInRingOfIntegerOfNumberField(MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> a, MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> b, BiFunction<MultivariatePolynomial<UnivariatePolynomial<BigInteger>>, MultivariatePolynomial<UnivariatePolynomial<BigInteger>>, MultivariatePolynomial<UnivariatePolynomial<BigInteger>>> algorithmForGcdAssociate) {
        assert (a.stream().allMatch(cf -> cf.stream().allMatch(Rational::isIntegral)));
        assert (b.stream().allMatch(cf -> cf.stream().allMatch(Rational::isIntegral)));
        GCDInput gcdInput = MultivariateGCD.preparedGCDInput(a, b, (l, r) -> MultivariateGCD.PolynomialGCDAssociateInRingOfIntegerOfNumberField(l, r, algorithmForGcdAssociate));
        if (gcdInput.earlyGCD != null) {
            return (MultivariatePolynomial)gcdInput.earlyGCD;
        }
        a = (MultivariatePolynomial)gcdInput.aReduced;
        b = (MultivariatePolynomial)gcdInput.bReduced;
        MultivariatePolynomial pContentGCD = MultivariateGCD.contentGCD(a, b, 0, (l, r) -> MultivariateGCD.PolynomialGCDAssociateInRingOfIntegerOfNumberField(l, r, algorithmForGcdAssociate));
        if (!pContentGCD.isConstant()) {
            a = MultivariateDivision.divideExact(a, pContentGCD);
            b = MultivariateDivision.divideExact(b, pContentGCD);
            return gcdInput.restoreGCD(MultivariateGCD.PolynomialGCDInNumberFieldSwitchToRingOfInteger(a, b, (l, r) -> MultivariateGCD.PolynomialGCDAssociateInRingOfIntegerOfNumberField(l, r, algorithmForGcdAssociate).multiply(pContentGCD)));
        }
        AlgebraicNumberField numberField = (AlgebraicNumberField)a.ring;
        UnivariatePolynomial<BigInteger> minimalPolyZ = ((UnivariatePolynomial)numberField.getMinimalPolynomial()).mapCoefficients(Rings.Z, Rational::numeratorExact);
        AlgebraicNumberField<UnivariatePolynomial<BigInteger>> numberRingZ = new AlgebraicNumberField<UnivariatePolynomial<BigInteger>>(minimalPolyZ);
        return gcdInput.restoreGCD(algorithmForGcdAssociate.apply(a.mapCoefficients(numberRingZ, cf -> cf.mapCoefficients(Rings.Z, Rational::numeratorExact)), b.mapCoefficients(numberRingZ, cf -> cf.mapCoefficients(Rings.Z, Rational::numeratorExact))).mapCoefficients(numberField, cf -> cf.mapCoefficients(Rings.Q, Rings.Q::mkNumerator)));
    }

    public static MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> ZippelGCDInNumberFieldViaRationalReconstruction(MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> a, MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> b) {
        return MultivariateGCD.PolynomialGCDInNumberFieldSwitchToRingOfInteger(a, b, (l, r) -> MultivariateGCD.PolynomialGCDAssociateInRingOfIntegerOfNumberField(l, r, MultivariateGCD::ZippelGCDInNumberFieldViaRationalReconstruction0));
    }

    private static MultivariatePolynomial<UnivariatePolynomial<BigInteger>> ZippelGCDInNumberFieldViaRationalReconstruction0(MultivariatePolynomial<UnivariatePolynomial<BigInteger>> a, MultivariatePolynomial<UnivariatePolynomial<BigInteger>> b) {
        MultivariatePolynomial candidate;
        MultivariatePolynomial<UnivariatePolynomialZp64> baseMod;
        MultivariatePolynomial<UnivariatePolynomialZp64> bMod;
        MultivariatePolynomial<UnivariatePolynomialZp64> aMod;
        FiniteField<UnivariatePolynomialZp64> numberFieldMod;
        UnivariatePolynomialZp64 minimalPolyMod;
        long basePrime;
        long startingPrime = Math.max(MultivariateGCD.iMaxZ(a).bitLength(), MultivariateGCD.iMaxZ(b).bitLength()) < 256 ? 0x40000000L : 0x1000000000000000L;
        AlgebraicNumberField numberField = (AlgebraicNumberField)a.ring;
        UnivariatePolynomial minimalPoly = (UnivariatePolynomial)numberField.getMinimalPolynomial();
        UnivariateRing<Integers> auxRing = Rings.UnivariateRing(Rings.Z);
        PrimesIterator primesLoop = new PrimesIterator(startingPrime - 4096L);
        RandomGenerator random = PrivateRandom.getRandom();
        while (true) {
            basePrime = primesLoop.take();
            assert (basePrime != -1L) : "long overflow";
            IntegersZp64 baseRing = new IntegersZp64(basePrime);
            minimalPolyMod = UnivariatePolynomial.asOverZp64(minimalPoly, baseRing);
            numberFieldMod = new FiniteField<UnivariatePolynomialZp64>(minimalPolyMod);
            aMod = a.mapCoefficients(numberFieldMod, cf -> UnivariatePolynomial.asOverZp64(cf, baseRing));
            bMod = b.mapCoefficients(numberFieldMod, cf -> UnivariatePolynomial.asOverZp64(cf, baseRing));
            if (!aMod.sameSkeletonQ(a) || !bMod.sameSkeletonQ(b)) continue;
            try {
                baseMod = MultivariateGCD.PolynomialGCD(aMod, bMod).monic();
            }
            catch (Throwable t) {
                continue;
            }
            break;
        }
        MultivariatePolynomial<UnivariatePolynomial> base = baseMod.mapCoefficients(auxRing, cf -> cf.asPolyZ(false).toBigPoly());
        if (base.isConstant()) {
            return a.createOne();
        }
        BigInteger crtPrime = Rings.Z.valueOf(basePrime);
        int nPrimes = 0;
        int prevFibonacci = 1;
        int nextFibonacci = 2;
        block5: while (true) {
            MultivariatePolynomial<UnivariatePolynomialZp64> modularGCD;
            long prime = primesLoop.take();
            IntegersZp64 ring = new IntegersZp64(prime);
            minimalPolyMod = UnivariatePolynomial.asOverZp64(minimalPoly, ring);
            numberFieldMod = new FiniteField<UnivariatePolynomialZp64>(minimalPolyMod);
            aMod = a.mapCoefficients(numberFieldMod, cf -> UnivariatePolynomial.asOverZp64(cf, ring));
            bMod = b.mapCoefficients(numberFieldMod, cf -> UnivariatePolynomial.asOverZp64(cf, ring));
            if (!aMod.sameSkeletonQ(a) || !bMod.sameSkeletonQ(b)) continue;
            try {
                modularGCD = MultivariateGCD.interpolateGCD(aMod, bMod, baseMod.mapCoefficients(numberFieldMod, cf -> cf.setModulusUnsafe(prime)), random);
            }
            catch (Throwable t) {
                continue;
            }
            if (modularGCD == null) continue;
            if (modularGCD.isConstant()) {
                return a.createOne();
            }
            modularGCD.monic();
            assert (MultivariateDivision.dividesQ(aMod, modularGCD));
            assert (MultivariateDivision.dividesQ(bMod, modularGCD));
            if (modularGCD.degree(0) < base.degree(0)) {
                baseMod = modularGCD;
                base = baseMod.mapCoefficients(auxRing, cf -> cf.asPolyZ(false).toBigPoly());
                basePrime = prime;
                crtPrime = Rings.Z.valueOf(basePrime);
                continue;
            }
            if (modularGCD.degree(0) > base.degree(0)) continue;
            PairedIterator iterator = new PairedIterator(base, modularGCD);
            ChineseRemainders.ChineseRemaindersMagic<BigInteger> magic = ChineseRemainders.createMagic(Rings.Z, crtPrime, Rings.Z.valueOf(prime));
            while (iterator.hasNext()) {
                iterator.advance();
                Monomial baseTerm = (Monomial)iterator.aTerm;
                Monomial imageTerm = (Monomial)iterator.bTerm;
                if (((UnivariatePolynomial)baseTerm.coefficient).isZero()) continue;
                if (((UnivariatePolynomialZp64)imageTerm.coefficient).isZero()) {
                    iterator.aIterator.remove();
                    continue;
                }
                UnivariatePolynomial baseCf = (UnivariatePolynomial)baseTerm.coefficient;
                UnivariatePolynomialZp64 imageCf = (UnivariatePolynomialZp64)imageTerm.coefficient;
                assert (baseCf.ring == Rings.Z);
                UnivariateGCD.updateCRT(magic, baseCf, imageCf);
            }
            crtPrime = crtPrime.multiply(Rings.Z.valueOf(prime));
            if (++nPrimes != nextFibonacci) continue;
            int nextNextFibonacci = (prevFibonacci + 1) / 2 + nextFibonacci;
            prevFibonacci = nextFibonacci;
            nextFibonacci = nextNextFibonacci;
            BigInteger lcm = Rings.Z.getOne();
            ArrayList<Monomial<UnivariatePolynomial<Rational<BigInteger>>>> candidateTerms = new ArrayList<Monomial<UnivariatePolynomial<Rational<BigInteger>>>>();
            for (Monomial term : base.terms) {
                UnivariatePolynomial<Rational<BigInteger>> rrCf = MultivariateGCD.rationalReconstruction((UnivariatePolynomial)term.coefficient, crtPrime);
                if (rrCf == null) continue block5;
                candidateTerms.add(new Monomial<UnivariatePolynomial<Rational<BigInteger>>>(term, rrCf));
                lcm = Rings.Z.lcm(lcm, (BigInteger)Rings.Z.lcm(rrCf.stream().map(Rational::denominator).collect(Collectors.toList())));
            }
            BigInteger lcm0 = lcm;
            candidate = (MultivariatePolynomial)a.create((Iterable)candidateTerms.stream().map(m -> new Monomial<UnivariatePolynomial<BigInteger>>((DegreeVector)m, ((UnivariatePolynomial)m.coefficient).mapCoefficients(Rings.Z, cf -> cf.multiply(lcm0).numeratorExact()))).collect(Collectors.toList()));
            if (MultivariateDivision.pseudoRemainder(a, candidate).isZero() && MultivariateDivision.pseudoRemainder(b, candidate).isZero()) break;
        }
        return candidate;
    }

    private static UnivariatePolynomial<Rational<BigInteger>> rationalReconstruction(UnivariatePolynomial<BigInteger> base, BigInteger crtPrime) {
        UnivariatePolynomial<BigInteger> candidate = UnivariatePolynomial.zero(Rings.Q);
        for (int j = 0; j <= base.degree(); ++j) {
            BigInteger[] numDen = RationalReconstruction.reconstructFarey(base.get(j), crtPrime);
            if (numDen == null) {
                return null;
            }
            candidate.set(j, (BigInteger)((Object)new Rational<BigInteger>(Rings.Z, numDen[0], numDen[1])));
        }
        return candidate;
    }

    public static MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> ZippelGCDInNumberFieldViaLangemyrMcCallum(MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> a, MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> b) {
        return MultivariateGCD.PolynomialGCDInNumberFieldSwitchToRingOfInteger(a, b, (l, r) -> MultivariateGCD.PolynomialGCDAssociateInRingOfIntegerOfNumberField(l, r, (u, v) -> MultivariateGCD.PolynomialGCDAssociateInNumberFieldViaLangemyrMcCallum(u, v, MultivariateGCD::ZippelGCDAssociateInNumberFieldViaLangemyrMcCallum0)));
    }

    private static MultivariatePolynomial<UnivariatePolynomial<BigInteger>> PolynomialGCDAssociateInNumberFieldViaLangemyrMcCallum(MultivariatePolynomial<UnivariatePolynomial<BigInteger>> a, MultivariatePolynomial<UnivariatePolynomial<BigInteger>> b, BiFunction<MultivariatePolynomial<UnivariatePolynomial<BigInteger>>, MultivariatePolynomial<UnivariatePolynomial<BigInteger>>, MultivariatePolynomial<UnivariatePolynomial<BigInteger>>> baseAlgorithm) {
        AlgebraicNumberField numberField = (AlgebraicNumberField)a.ring;
        MultivariateGCD.integerPrimitivePart(a);
        MultivariateGCD.integerPrimitivePart(b);
        if (!a.lc().isConstant()) {
            a.multiply(numberField.normalizer(a.lc()));
        }
        if (!b.lc().isConstant()) {
            b.multiply(numberField.normalizer(b.lc()));
        }
        MultivariateGCD.integerPrimitivePart(a);
        MultivariateGCD.integerPrimitivePart(b);
        MultivariatePolynomial<UnivariatePolynomial<BigInteger>> simpleGCD = MultivariateGCD.TrivialGCDInExtension(a, b);
        if (simpleGCD != null) {
            return simpleGCD;
        }
        return baseAlgorithm.apply(a, b);
    }

    static void integerPrimitivePart(MultivariatePolynomial<UnivariatePolynomial<BigInteger>> p) {
        BigInteger gcd = (BigInteger)Rings.Z.gcd(p.stream().flatMap(UnivariatePolynomial::stream).sorted().collect(Collectors.toList()));
        p.stream().forEach(cf -> cf.divideExact(gcd));
    }

    private static MultivariatePolynomial<UnivariatePolynomial<BigInteger>> ZippelGCDAssociateInNumberFieldViaLangemyrMcCallum0(MultivariatePolynomial<UnivariatePolynomial<BigInteger>> a, MultivariatePolynomial<UnivariatePolynomial<BigInteger>> b) {
        MultivariatePolynomial<UnivariatePolynomialZp64> baseMod;
        MultivariatePolynomial<UnivariatePolynomialZp64> bMod;
        MultivariatePolynomial<UnivariatePolynomialZp64> aMod;
        FiniteField<UnivariatePolynomialZp64> numberFieldMod;
        UnivariatePolynomialZp64 minimalPolyMod;
        long basePrime;
        assert (a.lc().isConstant());
        assert (b.lc().isConstant());
        long startingPrime = Math.max(MultivariateGCD.iMaxZ(a).bitLength(), MultivariateGCD.iMaxZ(b).bitLength()) < 512 ? 0x40000000L : 0x1000000000000000L;
        AlgebraicNumberField numberField = (AlgebraicNumberField)a.ring;
        UnivariatePolynomial minimalPoly = (UnivariatePolynomial)numberField.getMinimalPolynomial();
        BigInteger lcGCD = Rings.Z.gcd(a.lc().cc(), b.lc().cc());
        BigInteger disc = (BigInteger)UnivariateResultants.Discriminant(minimalPoly);
        BigInteger correctionFactor = disc.pow(1).multiply(lcGCD);
        UnivariateRing<Integers> auxRing = Rings.UnivariateRing(Rings.Z);
        PrimesIterator primesLoop = new PrimesIterator(startingPrime - 4096L);
        RandomGenerator random = PrivateRandom.getRandom();
        while (true) {
            basePrime = primesLoop.take();
            assert (basePrime != -1L) : "long overflow";
            IntegersZp64 baseRing = new IntegersZp64(basePrime);
            minimalPolyMod = UnivariatePolynomial.asOverZp64(minimalPoly, baseRing);
            numberFieldMod = new FiniteField<UnivariatePolynomialZp64>(minimalPolyMod);
            aMod = a.mapCoefficients(numberFieldMod, cf -> UnivariatePolynomial.asOverZp64(cf, baseRing));
            bMod = b.mapCoefficients(numberFieldMod, cf -> UnivariatePolynomial.asOverZp64(cf, baseRing));
            if (!aMod.sameSkeletonQ(a) || !bMod.sameSkeletonQ(b)) continue;
            try {
                baseMod = MultivariateGCD.PolynomialGCD(aMod, bMod).monic();
            }
            catch (Throwable t) {
                continue;
            }
            break;
        }
        baseMod.monic((UnivariatePolynomialZp64)numberFieldMod.valueOf(correctionFactor.mod(basePrime).longValueExact()));
        MultivariatePolynomial<UnivariatePolynomial> base = baseMod.mapCoefficients(auxRing, cf -> cf.asPolyZ(false).toBigPoly());
        if (base.isConstant()) {
            return a.createOne();
        }
        BigInteger crtPrime = Rings.Z.valueOf(basePrime);
        MultivariatePolynomial<UnivariatePolynomial<BigInteger>> prevCandidate = null;
        while (true) {
            MultivariatePolynomial<UnivariatePolynomialZp64> modularGCD;
            long prime = primesLoop.take();
            IntegersZp64 ring = new IntegersZp64(prime);
            minimalPolyMod = UnivariatePolynomial.asOverZp64(minimalPoly, ring);
            numberFieldMod = new FiniteField<UnivariatePolynomialZp64>(minimalPolyMod);
            aMod = a.mapCoefficients(numberFieldMod, cf -> UnivariatePolynomial.asOverZp64(cf, ring));
            bMod = b.mapCoefficients(numberFieldMod, cf -> UnivariatePolynomial.asOverZp64(cf, ring));
            if (!aMod.sameSkeletonQ(a) || !bMod.sameSkeletonQ(b)) continue;
            try {
                modularGCD = MultivariateGCD.interpolateGCD(aMod, bMod, baseMod.mapCoefficients(numberFieldMod, cf -> cf.setModulusUnsafe(prime)), random);
            }
            catch (Throwable t) {
                continue;
            }
            if (modularGCD == null) continue;
            modularGCD.monic((UnivariatePolynomialZp64)numberFieldMod.valueOf(correctionFactor.mod(prime).longValueExact()));
            assert (MultivariateDivision.dividesQ(aMod, modularGCD));
            assert (MultivariateDivision.dividesQ(bMod, modularGCD));
            if (modularGCD.isConstant()) {
                return a.createOne();
            }
            if (modularGCD.degree(0) < base.degree(0)) {
                baseMod = modularGCD;
                prevCandidate = null;
                base = baseMod.mapCoefficients(auxRing, cf -> cf.asPolyZ(false).toBigPoly());
                basePrime = prime;
                crtPrime = Rings.Z.valueOf(basePrime);
                continue;
            }
            if (modularGCD.degree(0) > base.degree(0)) continue;
            ChineseRemainders.ChineseRemaindersMagic<BigInteger> magic = ChineseRemainders.createMagic(Rings.Z, crtPrime, Rings.Z.valueOf(prime));
            PairedIterator iterator = new PairedIterator(base, modularGCD);
            while (iterator.hasNext()) {
                iterator.advance();
                Monomial baseTerm = (Monomial)iterator.aTerm;
                Monomial imageTerm = (Monomial)iterator.bTerm;
                if (((UnivariatePolynomial)baseTerm.coefficient).isZero()) continue;
                if (((UnivariatePolynomialZp64)imageTerm.coefficient).isZero()) {
                    iterator.aIterator.remove();
                    continue;
                }
                UnivariatePolynomial baseCf = (UnivariatePolynomial)baseTerm.coefficient;
                UnivariatePolynomialZp64 imageCf = (UnivariatePolynomialZp64)imageTerm.coefficient;
                assert (baseCf.ring == Rings.Z);
                UnivariateGCD.updateCRT(magic, baseCf, imageCf);
            }
            crtPrime = crtPrime.multiply(Rings.Z.valueOf(prime));
            IntegersZp crtRing = new IntegersZp(crtPrime);
            MultivariatePolynomial<UnivariatePolynomial<BigInteger>> candidate = base.mapCoefficients(numberField, cf -> numberField.valueOf(UnivariatePolynomial.asPolyZSymmetric(cf.setRingUnsafe(crtRing))));
            if (prevCandidate == null) {
                prevCandidate = candidate;
                continue;
            }
            if (prevCandidate.equals(candidate) && MultivariateDivision.pseudoRemainder(a, candidate).isZero() && MultivariateDivision.pseudoRemainder(b, candidate).isZero()) {
                return candidate;
            }
            prevCandidate = candidate;
        }
    }

    public static MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> ModularGCDInNumberFieldViaRationalReconstruction(MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> a, MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> b, BiFunction<MultivariatePolynomial<UnivariatePolynomialZp64>, MultivariatePolynomial<UnivariatePolynomialZp64>, MultivariatePolynomial<UnivariatePolynomialZp64>> modularAlgorithm) {
        return MultivariateGCD.PolynomialGCDInNumberFieldSwitchToRingOfInteger(a, b, (l, r) -> MultivariateGCD.PolynomialGCDAssociateInRingOfIntegerOfNumberField(l, r, (u, v) -> MultivariateGCD.ModularGCDInNumberFieldViaRationalReconstruction0(u, v, modularAlgorithm)));
    }

    private static MultivariatePolynomial<UnivariatePolynomial<BigInteger>> ModularGCDInNumberFieldViaRationalReconstruction0(MultivariatePolynomial<UnivariatePolynomial<BigInteger>> a, MultivariatePolynomial<UnivariatePolynomial<BigInteger>> b, BiFunction<MultivariatePolynomial<UnivariatePolynomialZp64>, MultivariatePolynomial<UnivariatePolynomialZp64>, MultivariatePolynomial<UnivariatePolynomialZp64>> modularAlgorithm) {
        MultivariatePolynomial candidate;
        long startingPrime = Math.max(MultivariateGCD.iMaxZ(a).bitLength(), MultivariateGCD.iMaxZ(b).bitLength()) < 256 ? 0x40000000L : 0x1000000000000000L;
        AlgebraicNumberField numberField = (AlgebraicNumberField)a.ring;
        UnivariatePolynomial minimalPoly = (UnivariatePolynomial)numberField.getMinimalPolynomial();
        UnivariateRing<Integers> auxRing = Rings.UnivariateRing(Rings.Z);
        PrimesIterator primesLoop = new PrimesIterator(startingPrime - 4096L);
        MultivariatePolynomial<UnivariatePolynomial> base = null;
        BigInteger crtPrime = null;
        int nPrimes = 0;
        int prevFibonacci = 1;
        int nextFibonacci = 2;
        block2: while (true) {
            MultivariatePolynomial<UnivariatePolynomialZp64> modularGCD;
            long prime = primesLoop.take();
            IntegersZp64 ring = new IntegersZp64(prime);
            UnivariatePolynomialZp64 minimalPolyMod = UnivariatePolynomial.asOverZp64(minimalPoly, ring);
            FiniteField<UnivariatePolynomialZp64> numberFieldMod = new FiniteField<UnivariatePolynomialZp64>(minimalPolyMod);
            MultivariatePolynomial<UnivariatePolynomialZp64> aMod = a.mapCoefficients(numberFieldMod, cf -> UnivariatePolynomial.asOverZp64(cf, ring));
            MultivariatePolynomial<UnivariatePolynomialZp64> bMod = b.mapCoefficients(numberFieldMod, cf -> UnivariatePolynomial.asOverZp64(cf, ring));
            if (!aMod.sameSkeletonQ(a) || !bMod.sameSkeletonQ(b)) continue;
            try {
                modularGCD = modularAlgorithm.apply(aMod, bMod);
            }
            catch (Throwable t) {
                continue;
            }
            if (modularGCD == null) continue;
            if (modularGCD.isConstant()) {
                return a.createOne();
            }
            modularGCD.monic();
            assert (MultivariateDivision.dividesQ(aMod, modularGCD));
            assert (MultivariateDivision.dividesQ(bMod, modularGCD));
            if (base == null || modularGCD.degree(0) < base.degree(0)) {
                base = modularGCD.mapCoefficients(auxRing, cf -> cf.asPolyZ(false).toBigPoly());
                crtPrime = Rings.Z.valueOf(prime);
                continue;
            }
            if (modularGCD.degree(0) > base.degree(0)) continue;
            PairedIterator iterator = new PairedIterator(base, modularGCD);
            ChineseRemainders.ChineseRemaindersMagic<BigInteger> magic = ChineseRemainders.createMagic(Rings.Z, crtPrime, Rings.Z.valueOf(prime));
            while (iterator.hasNext()) {
                iterator.advance();
                Monomial baseTerm = (Monomial)iterator.aTerm;
                Monomial imageTerm = (Monomial)iterator.bTerm;
                if (((UnivariatePolynomial)baseTerm.coefficient).isZero()) continue;
                if (((UnivariatePolynomialZp64)imageTerm.coefficient).isZero()) {
                    iterator.aIterator.remove();
                    continue;
                }
                UnivariatePolynomial baseCf = (UnivariatePolynomial)baseTerm.coefficient;
                UnivariatePolynomialZp64 imageCf = (UnivariatePolynomialZp64)imageTerm.coefficient;
                assert (baseCf.ring == Rings.Z);
                UnivariateGCD.updateCRT(magic, baseCf, imageCf);
            }
            crtPrime = crtPrime.multiply(Rings.Z.valueOf(prime));
            if (++nPrimes != nextFibonacci) continue;
            int nextNextFibonacci = (prevFibonacci + 1) / 2 + nextFibonacci;
            prevFibonacci = nextFibonacci;
            nextFibonacci = nextNextFibonacci;
            BigInteger lcm = Rings.Z.getOne();
            ArrayList<Monomial<UnivariatePolynomial<Rational<BigInteger>>>> candidateTerms = new ArrayList<Monomial<UnivariatePolynomial<Rational<BigInteger>>>>();
            for (Monomial term : base.terms) {
                UnivariatePolynomial<Rational<BigInteger>> rrCf = MultivariateGCD.rationalReconstruction((UnivariatePolynomial)term.coefficient, crtPrime);
                if (rrCf == null) continue block2;
                candidateTerms.add(new Monomial<UnivariatePolynomial<Rational<BigInteger>>>(term, rrCf));
                lcm = Rings.Z.lcm(lcm, (BigInteger)Rings.Z.lcm(rrCf.stream().map(Rational::denominator).collect(Collectors.toList())));
            }
            BigInteger lcm0 = lcm;
            candidate = (MultivariatePolynomial)a.create((Iterable)candidateTerms.stream().map(m -> new Monomial<UnivariatePolynomial<BigInteger>>((DegreeVector)m, ((UnivariatePolynomial)m.coefficient).mapCoefficients(Rings.Z, cf -> cf.multiply(lcm0).numeratorExact()))).collect(Collectors.toList()));
            if (MultivariateDivision.pseudoRemainder(a, candidate).isZero() && MultivariateDivision.pseudoRemainder(b, candidate).isZero()) break;
        }
        return candidate;
    }

    public static MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> ModularGCDInNumberFieldViaLangemyrMcCallum(MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> a, MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> b, BiFunction<MultivariatePolynomial<UnivariatePolynomialZp64>, MultivariatePolynomial<UnivariatePolynomialZp64>, MultivariatePolynomial<UnivariatePolynomialZp64>> modularAlgorithm) {
        return MultivariateGCD.PolynomialGCDInNumberFieldSwitchToRingOfInteger(a, b, (l, r) -> MultivariateGCD.PolynomialGCDAssociateInRingOfIntegerOfNumberField(l, r, (u, v) -> MultivariateGCD.PolynomialGCDAssociateInNumberFieldViaLangemyrMcCallum(u, v, (s, t) -> MultivariateGCD.ModularGCDAssociateInNumberFieldViaLangemyrMcCallum0(s, t, modularAlgorithm))));
    }

    private static MultivariatePolynomial<UnivariatePolynomial<BigInteger>> ModularGCDAssociateInNumberFieldViaLangemyrMcCallum0(MultivariatePolynomial<UnivariatePolynomial<BigInteger>> a, MultivariatePolynomial<UnivariatePolynomial<BigInteger>> b, BiFunction<MultivariatePolynomial<UnivariatePolynomialZp64>, MultivariatePolynomial<UnivariatePolynomialZp64>, MultivariatePolynomial<UnivariatePolynomialZp64>> modularAlgorithm) {
        assert (a.lc().isConstant());
        assert (b.lc().isConstant());
        long startingPrime = Math.max(MultivariateGCD.iMaxZ(a).bitLength(), MultivariateGCD.iMaxZ(b).bitLength()) < 512 ? 0x40000000L : 0x1000000000000000L;
        AlgebraicNumberField numberField = (AlgebraicNumberField)a.ring;
        UnivariatePolynomial minimalPoly = (UnivariatePolynomial)numberField.getMinimalPolynomial();
        BigInteger lcGCD = Rings.Z.gcd(a.lc().cc(), b.lc().cc());
        BigInteger disc = (BigInteger)UnivariateResultants.Discriminant(minimalPoly);
        BigInteger correctionFactor = disc.pow(1).multiply(lcGCD);
        UnivariateRing<Integers> auxRing = Rings.UnivariateRing(Rings.Z);
        PrimesIterator primesLoop = new PrimesIterator(startingPrime - 4096L);
        MultivariatePolynomial<UnivariatePolynomial> base = null;
        BigInteger crtPrime = null;
        MultivariatePolynomial<UnivariatePolynomial<BigInteger>> prevCandidate = null;
        while (true) {
            IPolynomial modularGCD;
            long prime = primesLoop.take();
            IntegersZp64 ring = new IntegersZp64(prime);
            UnivariatePolynomialZp64 minimalPolyMod = UnivariatePolynomial.asOverZp64(minimalPoly, ring);
            FiniteField<UnivariatePolynomialZp64> numberFieldMod = new FiniteField<UnivariatePolynomialZp64>(minimalPolyMod);
            minimalPolyMod = UnivariatePolynomial.asOverZp64(minimalPoly, ring);
            numberFieldMod = new FiniteField<UnivariatePolynomialZp64>(minimalPolyMod);
            MultivariatePolynomial<UnivariatePolynomialZp64> aMod = a.mapCoefficients(numberFieldMod, cf -> UnivariatePolynomial.asOverZp64(cf, ring));
            MultivariatePolynomial<UnivariatePolynomialZp64> bMod = b.mapCoefficients(numberFieldMod, cf -> UnivariatePolynomial.asOverZp64(cf, ring));
            if (!aMod.sameSkeletonQ(a) || !bMod.sameSkeletonQ(b)) continue;
            try {
                modularGCD = modularAlgorithm.apply(aMod, bMod).monic();
            }
            catch (Throwable t) {
                continue;
            }
            if (modularGCD == null) continue;
            ((MultivariatePolynomial)modularGCD).monic((UnivariatePolynomialZp64)numberFieldMod.valueOf(correctionFactor.mod(prime).longValueExact()));
            assert (MultivariateDivision.dividesQ(aMod, modularGCD));
            assert (MultivariateDivision.dividesQ(bMod, modularGCD));
            if (((MultivariatePolynomial)modularGCD).isConstant()) {
                return a.createOne();
            }
            if (base == null || ((AMultivariatePolynomial)modularGCD).degree(0) < base.degree(0)) {
                prevCandidate = null;
                base = ((MultivariatePolynomial)modularGCD).mapCoefficients(auxRing, cf -> cf.asPolyZ(false).toBigPoly());
                crtPrime = Rings.Z.valueOf(prime);
                continue;
            }
            if (((AMultivariatePolynomial)modularGCD).degree(0) > base.degree(0)) continue;
            ChineseRemainders.ChineseRemaindersMagic<BigInteger> magic = ChineseRemainders.createMagic(Rings.Z, crtPrime, Rings.Z.valueOf(prime));
            PairedIterator iterator = new PairedIterator(base, modularGCD);
            while (iterator.hasNext()) {
                iterator.advance();
                Monomial baseTerm = (Monomial)iterator.aTerm;
                Monomial imageTerm = (Monomial)iterator.bTerm;
                if (((UnivariatePolynomial)baseTerm.coefficient).isZero()) continue;
                if (((UnivariatePolynomialZp64)imageTerm.coefficient).isZero()) {
                    iterator.aIterator.remove();
                    continue;
                }
                UnivariatePolynomial baseCf = (UnivariatePolynomial)baseTerm.coefficient;
                UnivariatePolynomialZp64 imageCf = (UnivariatePolynomialZp64)imageTerm.coefficient;
                assert (baseCf.ring == Rings.Z);
                UnivariateGCD.updateCRT(magic, baseCf, imageCf);
            }
            crtPrime = crtPrime.multiply(Rings.Z.valueOf(prime));
            IntegersZp crtRing = new IntegersZp(crtPrime);
            MultivariatePolynomial<UnivariatePolynomial<BigInteger>> candidate = base.mapCoefficients(numberField, cf -> numberField.valueOf(UnivariatePolynomial.asPolyZSymmetric(cf.setRingUnsafe(crtRing))));
            if (prevCandidate == null) {
                prevCandidate = candidate;
                continue;
            }
            if (prevCandidate.equals(candidate) && MultivariateDivision.pseudoRemainder(a, candidate).isZero() && MultivariateDivision.pseudoRemainder(b, candidate).isZero()) {
                return candidate;
            }
            prevCandidate = candidate;
        }
    }

    public static <E> MultivariatePolynomial<E> KaltofenMonaganSparseModularGCDInGF(MultivariatePolynomial<E> a, MultivariatePolynomial<E> b) {
        return MultivariateGCD.KaltofenMonaganModularGCDInGF(a, b, MultivariateGCD::KaltofenMonaganSparseModularGCDInGF0);
    }

    public static <E> MultivariatePolynomial<E> KaltofenMonaganEEZModularGCDInGF(MultivariatePolynomial<E> a, MultivariatePolynomial<E> b) {
        return MultivariateGCD.KaltofenMonaganModularGCDInGF(a, b, MultivariateGCD::KaltofenMonaganEEZModularGCDInGF0);
    }

    static <E> MultivariatePolynomial<E> KaltofenMonaganModularGCDInGF(MultivariatePolynomial<E> a, MultivariatePolynomial<E> b, KaltofenMonaganAlgorithm algorithm) {
        Util.ensureOverFiniteField(a, b);
        a.assertSameCoefficientRingWith(b);
        if (Conversions64bit.canConvertToZp64(a)) {
            return (MultivariatePolynomial)Conversions64bit.convertFromZp64(MultivariateGCD.KaltofenMonaganModularGCDInGF(Conversions64bit.asOverZp64(a), Conversions64bit.asOverZp64(b), algorithm));
        }
        if (a == b) {
            return a.clone();
        }
        if (a.isZero()) {
            return b.clone();
        }
        if (b.isZero()) {
            return a.clone();
        }
        if (a.degree() < b.degree()) {
            return MultivariateGCD.KaltofenMonaganModularGCDInGF(b, a, algorithm);
        }
        GCDInput<Monomial<E>, MultivariatePolynomial<E>> gcdInput = MultivariateGCD.preparedGCDInput(a, b, (u, v) -> MultivariateGCD.KaltofenMonaganModularGCDInGF(u, v, algorithm));
        if (gcdInput.earlyGCD != null) {
            return (MultivariatePolynomial)gcdInput.earlyGCD;
        }
        return MultivariateGCD.KaltofenMonaganModularGCDInGF(gcdInput, algorithm);
    }

    private static <E> MultivariatePolynomial<E> KaltofenMonaganSparseModularGCDInGF(GCDInput<Monomial<E>, MultivariatePolynomial<E>> gcdInput) {
        return MultivariateGCD.KaltofenMonaganModularGCDInGF(gcdInput, MultivariateGCD::KaltofenMonaganSparseModularGCDInGF0);
    }

    private static <E> MultivariatePolynomial<E> KaltofenMonaganModularGCDInGF(GCDInput<Monomial<E>, MultivariatePolynomial<E>> gcdInput, KaltofenMonaganAlgorithm algorithm) {
        MultivariatePolynomial a = (MultivariatePolynomial)gcdInput.aReduced;
        MultivariatePolynomial b = (MultivariatePolynomial)gcdInput.bReduced;
        MultivariatePolynomial pContentGCD = MultivariateGCD.contentGCD(a, b, 0, (u, v) -> MultivariateGCD.KaltofenMonaganModularGCDInGF(u, v, algorithm));
        if (!pContentGCD.isConstant()) {
            a = MultivariateDivision.divideExact(a, pContentGCD);
            b = MultivariateDivision.divideExact(b, pContentGCD);
            return gcdInput.restoreGCD(MultivariateGCD.KaltofenMonaganModularGCDInGF(a, b, algorithm).multiply(pContentGCD));
        }
        for (int uVariable = a.nVariables - 1; uVariable >= 0; --uVariable) {
            MultivariatePolynomial ugcd;
            IUnivariatePolynomial contentGCD;
            IUnivariatePolynomial bContent;
            IUnivariatePolynomial aContent;
            MultivariatePolynomial<IUnivariatePolynomial<UnivariatePolynomial<UnivariatePolynomial>>> ub;
            MultivariatePolynomial<IUnivariatePolynomial<UnivariatePolynomial<UnivariatePolynomial>>> ua;
            if (a.ring instanceof IntegersZp && a.coefficientRingCardinality().isLong()) {
                ua = MultivariateGCD.asOverUnivariate0(a, uVariable);
                ub = MultivariateGCD.asOverUnivariate0(b, uVariable);
                aContent = (UnivariatePolynomialZp64)ua.content();
                bContent = (UnivariatePolynomialZp64)ub.content();
                contentGCD = (UnivariatePolynomialZp64)((Object)ua.ring.gcd((UnivariatePolynomial)aContent, (UnivariatePolynomial)bContent));
                ugcd = algorithm.apply(ua = ua.divideOrNull(aContent), ub = ub.divideOrNull(bContent), gcdInput.degreeBounds[uVariable], gcdInput.finiteExtensionDegree);
                if (ugcd == null) continue;
                ugcd = ugcd.multiply(contentGCD);
                MultivariatePolynomial<BigInteger> r = gcdInput.restoreGCD(MultivariateGCD.asNormalMultivariate0(ugcd, uVariable));
                return r;
            }
            ua = a.asOverUnivariateEliminate(uVariable);
            ub = b.asOverUnivariateEliminate(uVariable);
            aContent = (UnivariatePolynomial)ua.content();
            bContent = (UnivariatePolynomial)ub.content();
            contentGCD = ua.ring.gcd((UnivariatePolynomial)aContent, (UnivariatePolynomial)bContent);
            ugcd = algorithm.apply(ua = ua.divideOrNull(aContent), ub = ub.divideOrNull(bContent), gcdInput.degreeBounds[uVariable], gcdInput.finiteExtensionDegree);
            if (ugcd == null) continue;
            ugcd = ugcd.multiply(contentGCD);
            return gcdInput.restoreGCD(MultivariatePolynomial.asNormalMultivariate(ugcd, uVariable));
        }
        throw new RuntimeException();
    }

    private static MultivariatePolynomial<UnivariatePolynomialZp64> asOverUnivariate0(MultivariatePolynomial<BigInteger> poly, int variable) {
        IntegersZp64 ring = new IntegersZp64(((IntegersZp)poly.ring).modulus.longValueExact());
        UnivariatePolynomialZp64 factory = UnivariatePolynomialZp64.zero(ring);
        UnivariateRing<UnivariatePolynomialZp64> pDomain = new UnivariateRing<UnivariatePolynomialZp64>(factory);
        MonomialSet newData = new MonomialSet((Comparator<? super DegreeVector>)((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)poly.ordering)));
        for (Monomial monomial : poly) {
            MultivariatePolynomial.add(newData, new Monomial<UnivariatePolynomialZp64>((DegreeVector)monomial.without(variable), factory.createMonomial(((BigInteger)monomial.coefficient).longValueExact(), monomial.exponents[variable])), pDomain);
        }
        return new MultivariatePolynomial<UnivariatePolynomialZp64>(poly.nVariables - 1, pDomain, poly.ordering, newData);
    }

    private static MultivariatePolynomial<BigInteger> asNormalMultivariate0(MultivariatePolynomial<UnivariatePolynomialZp64> poly, int variable) {
        IntegersZp ring = ((UnivariatePolynomialZp64)poly.ring.getZero()).ring.asGenericRing();
        int nVariables = poly.nVariables + 1;
        MultivariatePolynomial<BigInteger> result = MultivariatePolynomial.zero(nVariables, ring, poly.ordering);
        for (Monomial monomial : poly) {
            UnivariatePolynomialZp64 uPoly = (UnivariatePolynomialZp64)monomial.coefficient;
            DegreeVector dv = monomial.dvInsert(variable);
            for (int i = 0; i <= uPoly.degree(); ++i) {
                if (uPoly.isZeroAt(i)) continue;
                result.add(new Monomial<BigInteger>(dv.dvSet(variable, i), BigInteger.valueOf(uPoly.get(i))));
            }
        }
        return result;
    }

    public static MultivariatePolynomialZp64 KaltofenMonaganSparseModularGCDInGF(MultivariatePolynomialZp64 a, MultivariatePolynomialZp64 b) {
        return MultivariateGCD.KaltofenMonaganModularGCDInGF(a, b, MultivariateGCD::KaltofenMonaganSparseModularGCDInGF0);
    }

    public static MultivariatePolynomialZp64 KaltofenMonaganEEZModularGCDInGF(MultivariatePolynomialZp64 a, MultivariatePolynomialZp64 b) {
        return MultivariateGCD.KaltofenMonaganModularGCDInGF(a, b, MultivariateGCD::KaltofenMonaganEEZModularGCDInGF0);
    }

    public static MultivariatePolynomialZp64 KaltofenMonaganModularGCDInGF(MultivariatePolynomialZp64 a, MultivariatePolynomialZp64 b, KaltofenMonaganAlgorithm algorithm) {
        Util.ensureOverFiniteField(a, b);
        if (a == b) {
            return a.clone();
        }
        if (a.isZero()) {
            return b.clone();
        }
        if (b.isZero()) {
            return a.clone();
        }
        if (a.degree() < b.degree()) {
            return MultivariateGCD.KaltofenMonaganModularGCDInGF(b, a, algorithm);
        }
        GCDInput<MonomialZp64, MultivariatePolynomialZp64> gcdInput = MultivariateGCD.preparedGCDInput(a, b, (u, v) -> MultivariateGCD.KaltofenMonaganModularGCDInGF(u, v, algorithm));
        if (gcdInput.earlyGCD != null) {
            return (MultivariatePolynomialZp64)gcdInput.earlyGCD;
        }
        return MultivariateGCD.lKaltofenMonaganModularGCDInGF(gcdInput, algorithm);
    }

    private static MultivariatePolynomialZp64 lKaltofenMonaganSparseModularGCDInGF(GCDInput<MonomialZp64, MultivariatePolynomialZp64> gcdInput) {
        return MultivariateGCD.lKaltofenMonaganModularGCDInGF(gcdInput, MultivariateGCD::KaltofenMonaganSparseModularGCDInGF0);
    }

    private static MultivariatePolynomialZp64 lKaltofenMonaganModularGCDInGF(GCDInput<MonomialZp64, MultivariatePolynomialZp64> gcdInput, KaltofenMonaganAlgorithm<UnivariatePolynomialZp64> algorithm) {
        MultivariatePolynomialZp64 a = (MultivariatePolynomialZp64)gcdInput.aReduced;
        MultivariatePolynomialZp64 b = (MultivariatePolynomialZp64)gcdInput.bReduced;
        MultivariatePolynomialZp64 pContentGCD = MultivariateGCD.contentGCD(a, b, 0, (u, v) -> MultivariateGCD.KaltofenMonaganModularGCDInGF(u, v, algorithm));
        if (!pContentGCD.isConstant()) {
            a = MultivariateDivision.divideExact(a, pContentGCD);
            b = MultivariateDivision.divideExact(b, pContentGCD);
            return gcdInput.restoreGCD(MultivariateGCD.KaltofenMonaganModularGCDInGF(a, b, algorithm).multiply(pContentGCD));
        }
        for (int uVariable = a.nVariables - 1; uVariable >= 0; --uVariable) {
            MultivariatePolynomial<UnivariatePolynomialZp64> ua = a.asOverUnivariateEliminate(uVariable);
            MultivariatePolynomial<UnivariatePolynomialZp64> ub = b.asOverUnivariateEliminate(uVariable);
            UnivariatePolynomialZp64 aContent = ua.content();
            UnivariatePolynomialZp64 bContent = ub.content();
            UnivariatePolynomialZp64 contentGCD = ua.ring.gcd(aContent, bContent);
            MultivariatePolynomial<UnivariatePolynomialZp64> ugcd = algorithm.apply(ua = ua.divideOrNull(aContent), ub = ub.divideOrNull(bContent), gcdInput.degreeBounds[uVariable], gcdInput.finiteExtensionDegree);
            if (ugcd == null) continue;
            ugcd = ugcd.multiply(contentGCD);
            return gcdInput.restoreGCD(MultivariatePolynomialZp64.asNormalMultivariate(ugcd, uVariable));
        }
        throw new RuntimeException("\na: " + a + "\nb: " + b);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    static <uPoly extends IUnivariatePolynomial<uPoly>> MultivariatePolynomial<uPoly> KaltofenMonaganSparseModularGCDInGF0(MultivariatePolynomial<uPoly> a, MultivariatePolynomial<uPoly> b, int uDegreeBound, int finiteExtensionDegree) {
        lcGCD = UnivariateGCD.PolynomialGCD((IUnivariatePolynomial)a.lc(), (IUnivariatePolynomial)b.lc());
        univariateRing = a.ring;
        random = PrivateRandom.getRandom();
        primesLoop = new IrreduciblePolynomialsIterator<IUnivariatePolynomial>((IUnivariatePolynomial)univariateRing.getOne(), finiteExtensionDegree);
        block0: while (true) {
            basePrime = primesLoop.next();
            fField = new FiniteField<IUnivariatePolynomial>(basePrime);
            aMod = a.setRing(fField);
            bMod = b.setRing(fField);
            if (!aMod.sameSkeletonQ(a) || !bMod.sameSkeletonQ(b)) continue;
            base = MultivariateGCD.PolynomialGCD(aMod, bMod);
            lLcGCD = fField.valueOf(lcGCD);
            if (base.isConstant()) {
                return a.createOne();
            }
            base = base.monic(lLcGCD);
            previousBase = null;
            while (true) {
                if (basePrime.degree() >= uDegreeBound + 18) {
                    return null;
                }
                prime = primesLoop.next();
                fField = new FiniteField<IUnivariatePolynomial>(prime);
                aMod = a.setRing(fField);
                bMod = b.setRing(fField);
                if (!aMod.sameSkeletonQ(a) || !bMod.sameSkeletonQ(b)) continue;
                modularGCD /* !! */  = aMod.nVariables == 1 ? MultivariatePolynomial.asMultivariate((UnivariatePolynomial)UnivariateGCD.PolynomialGCD(aMod.asUnivariate(), bMod.asUnivariate()), 1, 0, (Comparator<DegreeVector>)aMod.ordering) : MultivariateGCD.interpolateGCD(aMod, bMod, base.setRingUnsafe(fField), random);
                if (modularGCD /* !! */  != null && MultivariateGCD.isGCDTriplet(aMod, bMod, modularGCD /* !! */ )) ** break;
                continue block0;
                if (modularGCD /* !! */ .isConstant()) {
                    return a.createOne();
                }
                if (modularGCD /* !! */ .degree(0) < base.degree(0)) {
                    lLcGCD = fField.valueOf(lcGCD);
                    base = modularGCD /* !! */ .monic(lLcGCD);
                    basePrime = prime;
                    continue;
                }
                if (modularGCD /* !! */ .degree(0) > base.degree(0)) continue;
                newBasePrime = basePrime.clone().multiply(prime);
                monicFactor = fField.divideExact(fField.valueOf(lcGCD), modularGCD /* !! */ .lc());
                iterator = new PairedIterator<Term1, MultivariatePolynomial<IUnivariatePolynomial>, Term2, MultivariatePolynomial<IUnivariatePolynomial<Object>>>(base, modularGCD /* !! */ );
                magic = ChineseRemainders.createMagic(univariateRing, basePrime, prime);
                while (iterator.hasNext()) {
                    iterator.advance();
                    baseTerm = (Monomial)iterator.aTerm;
                    imageTerm = (Monomial)iterator.bTerm;
                    if (((IUnivariatePolynomial)baseTerm.coefficient).isZero()) continue;
                    if (((IUnivariatePolynomial)imageTerm.coefficient).isZero()) {
                        base.subtract(baseTerm);
                        continue;
                    }
                    oth = fField.multiply((IUnivariatePolynomial)imageTerm.coefficient, monicFactor);
                    newCoeff = ChineseRemainders.ChineseRemainders(univariateRing, magic, (IUnivariatePolynomial)baseTerm.coefficient, oth);
                    base.put(baseTerm.setCoefficient(newCoeff));
                }
                basePrime = newBasePrime;
                base = base.setRingUnsafe(univariateRing);
                candidate = base.clone().primitivePart();
                if (basePrime.degree() >= uDegreeBound || previousBase != null && candidate.equals(previousBase)) {
                    previousBase = candidate;
                    if (!MultivariateGCD.isGCDTriplet(b, a, candidate)) continue;
                    return candidate;
                }
                previousBase = candidate;
            }
            break;
        }
    }

    static <uPoly extends IUnivariatePolynomial<uPoly>> MultivariatePolynomial<uPoly> KaltofenMonaganEEZModularGCDInGF0(MultivariatePolynomial<uPoly> a, MultivariatePolynomial<uPoly> b, int uDegreeBound, int finiteExtensionDegree) {
        IPolynomial candidate;
        IUnivariatePolynomial lcGCD = UnivariateGCD.PolynomialGCD((IUnivariatePolynomial)a.lc(), (IUnivariatePolynomial)b.lc());
        Ring univariateRing = a.ring;
        MultivariatePolynomial<IUnivariatePolynomial> base = null;
        IPolynomial basePrime = null;
        IrreduciblePolynomialsIterator<IUnivariatePolynomial> primesLoop = new IrreduciblePolynomialsIterator<IUnivariatePolynomial>((IUnivariatePolynomial)univariateRing.getOne(), finiteExtensionDegree);
        while (true) {
            if (basePrime != null && basePrime.degree() >= uDegreeBound + 18) {
                return null;
            }
            IUnivariatePolynomial prime = primesLoop.next();
            FiniteField<IUnivariatePolynomial> fField = new FiniteField<IUnivariatePolynomial>(prime);
            MultivariatePolynomial<IUnivariatePolynomial> aMod = a.setRing(fField);
            MultivariatePolynomial<IUnivariatePolynomial> bMod = b.setRing(fField);
            if (!aMod.sameSkeletonQ(a) || !bMod.sameSkeletonQ(b)) continue;
            MultivariatePolynomial<IUnivariatePolynomial> modGCD = MultivariateGCD.PolynomialGCD(aMod, bMod);
            IUnivariatePolynomial lLcGCD = fField.valueOf(lcGCD);
            if (modGCD.isConstant()) {
                return a.createOne();
            }
            modGCD = modGCD.monic(lLcGCD);
            if (base == null) {
                base = modGCD;
                basePrime = prime;
                continue;
            }
            IUnivariatePolynomial newBasePrime = basePrime.clone().multiply(prime);
            IUnivariatePolynomial monicFactor = fField.divideExact(fField.valueOf(lcGCD), modGCD.lc());
            PairedIterator iterator = new PairedIterator(base, modGCD);
            ChineseRemainders.ChineseRemaindersMagic<IUnivariatePolynomial> magic = ChineseRemainders.createMagic(univariateRing, basePrime, prime);
            while (iterator.hasNext()) {
                iterator.advance();
                Monomial baseTerm = (Monomial)iterator.aTerm;
                Monomial imageTerm = (Monomial)iterator.bTerm;
                if (((IUnivariatePolynomial)baseTerm.coefficient).isZero()) continue;
                if (((IUnivariatePolynomial)imageTerm.coefficient).isZero()) {
                    base.subtract(baseTerm);
                    continue;
                }
                IUnivariatePolynomial oth = fField.multiply((IUnivariatePolynomial)imageTerm.coefficient, monicFactor);
                IUnivariatePolynomial newCoeff = ChineseRemainders.ChineseRemainders(univariateRing, magic, (IUnivariatePolynomial)baseTerm.coefficient, oth);
                base.put(baseTerm.setCoefficient(newCoeff));
            }
            basePrime = newBasePrime;
            candidate = ((MultivariatePolynomial)(base = base.setRingUnsafe(univariateRing)).clone()).primitivePart();
            if (MultivariateGCD.isGCDTriplet(b, a, candidate)) break;
        }
        return candidate;
    }

    static <E> MultivariatePolynomial<E> interpolateGCD(MultivariatePolynomial<E> a, MultivariatePolynomial<E> b, MultivariatePolynomial<E> skeleton, RandomGenerator rnd) {
        a.assertSameCoefficientRingWith(b);
        a.assertSameCoefficientRingWith(skeleton);
        SparseInterpolation<E> interpolation = MultivariateGCD.createInterpolation(-1, a, b, skeleton, 1, rnd);
        if (interpolation == null) {
            return null;
        }
        MultivariatePolynomial<E> gcd = interpolation.evaluate();
        if (gcd == null) {
            return null;
        }
        return gcd;
    }

    public static <E> MultivariatePolynomial<E> BrownGCD(MultivariatePolynomial<E> a, MultivariatePolynomial<E> b) {
        Util.ensureOverField(a, b);
        a.assertSameCoefficientRingWith(b);
        if (Conversions64bit.canConvertToZp64(a)) {
            return (MultivariatePolynomial)Conversions64bit.convertFromZp64(MultivariateGCD.BrownGCD(Conversions64bit.asOverZp64(a), Conversions64bit.asOverZp64(b)));
        }
        GCDInput<Monomial<E>, MultivariatePolynomial<E>> gcdInput = MultivariateGCD.preparedGCDInput(a, b, MultivariateGCD::BrownGCD);
        if (gcdInput.earlyGCD != null) {
            return (MultivariatePolynomial)gcdInput.earlyGCD;
        }
        if (gcdInput.finiteExtensionDegree > 1) {
            return MultivariateGCD.KaltofenMonaganSparseModularGCDInGF(gcdInput);
        }
        MultivariatePolynomial<E> result = MultivariateGCD.BrownGCD((MultivariatePolynomial)gcdInput.aReduced, (MultivariatePolynomial)gcdInput.bReduced, PrivateRandom.getRandom(), gcdInput.lastPresentVariable, gcdInput.degreeBounds, gcdInput.evaluationStackLimit);
        if (result == null) {
            return MultivariateGCD.KaltofenMonaganSparseModularGCDInGF(gcdInput);
        }
        return gcdInput.restoreGCD(result);
    }

    private static <E> MultivariatePolynomial<E> BrownGCD(MultivariatePolynomial<E> a, MultivariatePolynomial<E> b, RandomGenerator rnd, int variable, int[] degreeBounds, int evaluationStackLimit) {
        MultivariatePolynomial result;
        MultivariatePolynomial trivialGCD = MultivariateGCD.trivialGCD(a, b);
        if (trivialGCD != null) {
            return trivialGCD;
        }
        MultivariatePolynomial factory = a;
        int nVariables = factory.nVariables;
        if (variable == 0) {
            UnivariatePolynomial gcd = (UnivariatePolynomial)UnivariateGCD.PolynomialGCD(a.asUnivariate(), b.asUnivariate());
            if (gcd.degree() == 0) {
                return factory.createOne();
            }
            return (MultivariatePolynomial)AMultivariatePolynomial.asMultivariate(gcd, nVariables, variable, factory.ordering);
        }
        PrimitiveInput primitiveInput = MultivariateGCD.makePrimitive(a, b, variable);
        a = (MultivariatePolynomial)primitiveInput.aPrimitive;
        b = (MultivariatePolynomial)primitiveInput.bPrimitive;
        UnivariatePolynomial contentGCD = (UnivariatePolynomial)primitiveInput.contentGCD;
        UnivariatePolynomial lcGCD = (UnivariatePolynomial)primitiveInput.lcGCD;
        trivialGCD = MultivariateGCD.trivialGCD(a, b);
        if (trivialGCD != null) {
            MultivariatePolynomial poly = (MultivariatePolynomial)AMultivariatePolynomial.asMultivariate(contentGCD, a.nVariables, variable, a.ordering);
            return trivialGCD.multiply(poly);
        }
        Ring ring = factory.ring;
        int prevVarExponent = degreeBounds[variable - 1];
        MultivariateInterpolation.Interpolation interpolation = null;
        HashSet evaluationStack = new HashSet();
        int[] aDegrees = a.degrees();
        int[] bDegrees = b.degrees();
        block0: while (true) {
            int currExponent;
            if (evaluationStackLimit == evaluationStack.size()) {
                return MultivariateGCD.doDivisionCheck(a, b, contentGCD, interpolation, variable);
            }
            Object randomPoint = MultivariateGCD.randomElement(ring, rnd);
            if (evaluationStack.contains(randomPoint)) continue;
            evaluationStack.add(randomPoint);
            Object lcVal = lcGCD.evaluate(randomPoint);
            if (ring.isZero(lcVal)) continue;
            MultivariatePolynomial aVal = a.evaluate(variable, randomPoint);
            MultivariatePolynomial bVal = b.evaluate(variable, randomPoint);
            int[] aValDegrees = aVal.degrees();
            int[] bValDegrees = bVal.degrees();
            for (int i = variable - 1; i >= 0; --i) {
                if (aDegrees[i] != aValDegrees[i] || bDegrees[i] != bValDegrees[i]) continue block0;
            }
            MultivariatePolynomial cVal = MultivariateGCD.BrownGCD(aVal, bVal, rnd, variable - 1, degreeBounds, evaluationStackLimit);
            if (cVal == null || (currExponent = cVal.degree(variable - 1)) > prevVarExponent) continue;
            cVal = cVal.multiply(ring.multiply(ring.reciprocal(cVal.lc()), lcVal));
            assert (cVal.lc().equals(lcVal));
            if (currExponent < prevVarExponent) {
                interpolation = new MultivariateInterpolation.Interpolation(variable, randomPoint, cVal);
                degreeBounds[variable - 1] = prevVarExponent = currExponent;
                continue;
            }
            if (interpolation == null) {
                interpolation = new MultivariateInterpolation.Interpolation(variable, randomPoint, cVal);
                continue;
            }
            AMultivariatePolynomial previousInterpolation = interpolation.getInterpolatingPolynomial().clone();
            interpolation.update(randomPoint, cVal);
            if ((degreeBounds[variable] <= interpolation.numberOfPoints() || previousInterpolation.equals(interpolation.getInterpolatingPolynomial())) && (result = MultivariateGCD.doDivisionCheck(a, b, contentGCD, interpolation, variable)) != null) break;
        }
        return result;
    }

    private static <E> MultivariatePolynomial<E> doDivisionCheck(MultivariatePolynomial<E> a, MultivariatePolynomial<E> b, UnivariatePolynomial<E> contentGCD, MultivariateInterpolation.Interpolation<E> interpolation, int variable) {
        if (interpolation == null) {
            return null;
        }
        MultivariatePolynomial interpolated = MultivariatePolynomial.asNormalMultivariate(interpolation.getInterpolatingPolynomial().asOverUnivariateEliminate(variable).primitivePart(), variable);
        if (!MultivariateGCD.isGCDTriplet(a, b, interpolated)) {
            return null;
        }
        if (contentGCD == null) {
            return interpolated;
        }
        MultivariatePolynomial poly = (MultivariatePolynomial)AMultivariatePolynomial.asMultivariate(contentGCD, a.nVariables, variable, a.ordering);
        return interpolated.multiply(poly);
    }

    private static <E> boolean isGCDTriplet(MultivariatePolynomial<E> a, MultivariatePolynomial<E> b, MultivariatePolynomial<E> gcd) {
        if (Math.max(a.size(), b.size()) > 64000) {
            Ring<int> ring = a.ring;
            int[] subs = ring.createArray(a.nVariables - 1);
            for (int i = 0; i < subs.length; ++i) {
                subs[i] = (int)ring.randomNonZeroElement(PrivateRandom.getRandom());
            }
            MultivariatePolynomial.PrecomputedPowersHolder<int> powers = a.mkPrecomputedPowers(ArraysUtil.sequence(0, a.nVariables - 1), subs);
            UnivariatePolynomial<int> uniDiv = MultivariateGCD.subsToUnivariate(gcd, powers);
            UnivariatePolynomial<int> ra = UnivariateDivision.remainder(MultivariateGCD.subsToUnivariate(a, powers), uniDiv, false);
            if (ra == null || !ra.isZero()) {
                return false;
            }
            UnivariatePolynomial<int> rb = UnivariateDivision.remainder(MultivariateGCD.subsToUnivariate(b, powers), uniDiv, false);
            if (rb == null || !rb.isZero()) {
                return false;
            }
        }
        return MultivariateDivision.dividesQ(a, gcd) && MultivariateDivision.dividesQ(b, gcd);
    }

    private static <E> UnivariatePolynomial<E> subsToUnivariate(MultivariatePolynomial<E> a, MultivariatePolynomial.PrecomputedPowersHolder<E> powers) {
        E[] aUni = a.ring.createZeroesArray(a.degree(a.nVariables - 1) + 1);
        for (Monomial monomial : a) {
            Object val = monomial.coefficient;
            for (int i = 0; i < a.nVariables - 1; ++i) {
                val = a.ring.multiply(val, powers.pow(i, monomial.exponents[i]));
            }
            aUni[monomial.exponents[a.nVariables - 1]] = a.ring.add(aUni[monomial.exponents[a.nVariables - 1]], val);
        }
        return UnivariatePolynomial.createUnsafe(a.ring, aUni);
    }

    public static <E> MultivariatePolynomial<E> ZippelGCD(MultivariatePolynomial<E> a, MultivariatePolynomial<E> b) {
        Util.ensureOverField(a, b);
        a.assertSameCoefficientRingWith(b);
        if (Conversions64bit.canConvertToZp64(a)) {
            return (MultivariatePolynomial)Conversions64bit.convertFromZp64(MultivariateGCD.ZippelGCD(Conversions64bit.asOverZp64(a), Conversions64bit.asOverZp64(b)));
        }
        GCDInput<Monomial<E>, MultivariatePolynomial<E>> gcdInput = MultivariateGCD.preparedGCDInput(a, b, MultivariateGCD::ZippelGCD);
        if (gcdInput.earlyGCD != null) {
            return (MultivariatePolynomial)gcdInput.earlyGCD;
        }
        if (gcdInput.finiteExtensionDegree > 1) {
            return MultivariateGCD.KaltofenMonaganSparseModularGCDInGF(gcdInput);
        }
        a = (MultivariatePolynomial)gcdInput.aReduced;
        b = (MultivariatePolynomial)gcdInput.bReduced;
        MultivariatePolynomial content = MultivariateGCD.contentGCD(a, b, 0, MultivariateGCD::ZippelGCD);
        MultivariatePolynomial<E> result = MultivariateGCD.ZippelGCD(a = MultivariateDivision.divideExact(a, content), b = MultivariateDivision.divideExact(b, content), PrivateRandom.getRandom(), gcdInput.lastPresentVariable, gcdInput.degreeBounds, gcdInput.evaluationStackLimit);
        if (result == null) {
            return MultivariateGCD.KaltofenMonaganSparseModularGCDInGF(gcdInput);
        }
        result = result.multiply(content);
        return gcdInput.restoreGCD(result);
    }

    private static <E> MultivariatePolynomial<E> ZippelGCD(MultivariatePolynomial<E> a, MultivariatePolynomial<E> b, RandomGenerator rnd, int variable, int[] degreeBounds, int evaluationStackLimit) {
        MultivariatePolynomial result;
        MultivariatePolynomial trivialGCD = MultivariateGCD.trivialGCD(a, b);
        if (trivialGCD != null) {
            return trivialGCD;
        }
        MultivariatePolynomial factory = a;
        int nVariables = factory.nVariables;
        if (variable == 0) {
            UnivariatePolynomial gcd = (UnivariatePolynomial)UnivariateGCD.PolynomialGCD(a.asUnivariate(), b.asUnivariate());
            if (gcd.degree() == 0) {
                return factory.createOne();
            }
            return (MultivariatePolynomial)AMultivariatePolynomial.asMultivariate(gcd, nVariables, variable, factory.ordering);
        }
        PrimitiveInput primitiveInput = MultivariateGCD.makePrimitive(a, b, variable);
        a = (MultivariatePolynomial)primitiveInput.aPrimitive;
        b = (MultivariatePolynomial)primitiveInput.bPrimitive;
        UnivariatePolynomial contentGCD = (UnivariatePolynomial)primitiveInput.contentGCD;
        UnivariatePolynomial lcGCD = (UnivariatePolynomial)primitiveInput.lcGCD;
        trivialGCD = MultivariateGCD.trivialGCD(a, b);
        if (trivialGCD != null) {
            MultivariatePolynomial poly = (MultivariatePolynomial)AMultivariatePolynomial.asMultivariate(contentGCD, a.nVariables, variable, a.ordering);
            return trivialGCD.multiply(poly);
        }
        Ring ring = factory.ring;
        HashSet globalEvaluationStack = new HashSet();
        int[] aDegrees = a.degreesRef();
        int[] bDegrees = b.degreesRef();
        int failedSparseInterpolations = 0;
        int[] tmpDegreeBounds = (int[])degreeBounds.clone();
        block0: while (true) {
            int currExponent;
            if (evaluationStackLimit == globalEvaluationStack.size()) {
                return null;
            }
            Object seedPoint = MultivariateGCD.randomElement(ring, rnd);
            if (globalEvaluationStack.contains(seedPoint)) continue;
            globalEvaluationStack.add(seedPoint);
            Object lcVal = lcGCD.evaluate(seedPoint);
            if (ring.isZero(lcVal)) continue;
            MultivariatePolynomial aVal = a.evaluate(variable, seedPoint);
            MultivariatePolynomial bVal = b.evaluate(variable, seedPoint);
            int[] aValDegrees = aVal.degreesRef();
            int[] bValDegrees = bVal.degreesRef();
            for (int i = variable - 1; i >= 0; --i) {
                if (aDegrees[i] != aValDegrees[i] || bDegrees[i] != bValDegrees[i]) continue block0;
            }
            MultivariatePolynomial cVal = MultivariateGCD.ZippelGCD(aVal, bVal, rnd, variable - 1, tmpDegreeBounds, evaluationStackLimit);
            if (cVal == null || (currExponent = cVal.degree(variable - 1)) > tmpDegreeBounds[variable - 1]) continue;
            if (currExponent < tmpDegreeBounds[variable - 1]) {
                tmpDegreeBounds[variable - 1] = currExponent;
            }
            cVal = cVal.multiply(ring.multiply(ring.reciprocal(cVal.lc()), lcVal));
            assert (cVal.lc().equals(lcVal));
            SparseInterpolation sparseInterpolator = MultivariateGCD.createInterpolation(variable, a, b, cVal, tmpDegreeBounds[variable], rnd);
            if (sparseInterpolator == null) continue;
            MultivariateInterpolation.Interpolation denseInterpolation = new MultivariateInterpolation.Interpolation(variable, seedPoint, cVal);
            HashSet localEvaluationStack = new HashSet(globalEvaluationStack);
            while (true) {
                if (evaluationStackLimit == localEvaluationStack.size()) {
                    return null;
                }
                if (denseInterpolation.numberOfPoints() > tmpDegreeBounds[variable] + 64) {
                    tmpDegreeBounds = (int[])degreeBounds.clone();
                    continue block0;
                }
                Object randomPoint = MultivariateGCD.randomElement(ring, rnd);
                if (localEvaluationStack.contains(randomPoint)) continue;
                localEvaluationStack.add(randomPoint);
                lcVal = lcGCD.evaluate(randomPoint);
                if (ring.isZero(lcVal)) continue;
                cVal = sparseInterpolator.evaluate(randomPoint);
                if (cVal == null) {
                    if (++failedSparseInterpolations == 64) {
                        return null;
                    }
                    tmpDegreeBounds = (int[])degreeBounds.clone();
                    continue block0;
                }
                cVal = cVal.multiply(ring.multiply(ring.reciprocal(cVal.lc()), lcVal));
                assert (cVal.lc().equals(lcVal));
                AMultivariatePolynomial previousInterpolation = denseInterpolation.getInterpolatingPolynomial().clone();
                denseInterpolation.update(randomPoint, cVal);
                if ((tmpDegreeBounds[variable] <= denseInterpolation.numberOfPoints() && denseInterpolation.numberOfPoints() - tmpDegreeBounds[variable] < 3 || previousInterpolation.equals(denseInterpolation.getInterpolatingPolynomial())) && (result = MultivariateGCD.doDivisionCheck(a, b, contentGCD, denseInterpolation, variable)) != null) break block0;
            }
            break;
        }
        return result;
    }

    static <E> SparseInterpolation<E> createInterpolation(int variable, MultivariatePolynomial<E> a, MultivariatePolynomial<E> b, MultivariatePolynomial<E> skeleton, int expectedNumberOfEvaluations, RandomGenerator rnd) {
        MultivariatePolynomial.PrecomputedPowersHolder<int> powers;
        assert (a.nVariables > 1);
        if ((skeleton = (MultivariatePolynomial)skeleton.clone().setAllCoefficientsToUnit()).size() == 1) {
            return new TrivialSparseInterpolation(skeleton);
        }
        boolean monic = ((MultivariatePolynomial)a.coefficientOf(0, a.degree(0))).isConstant() && ((MultivariatePolynomial)b.coefficientOf(0, a.degree(0))).isConstant();
        Set<DegreeVector> globalSkeleton = skeleton.getSkeleton();
        TIntObjectHashMap<MultivariatePolynomial<E>> univarSkeleton = MultivariateGCD.getSkeleton(skeleton);
        int[] sparseUnivarDegrees = univarSkeleton.keys();
        Ring<int> ring = a.ring;
        int lastVariable = variable == -1 ? a.nVariables - 1 : variable;
        int[] evaluationVariables = ArraysUtil.sequence(1, lastVariable + 1);
        int[] evaluationPoint = ring.createArray(evaluationVariables.length);
        int fails = 0;
        block0: while (true) {
            if (fails >= 32) {
                return null;
            }
            for (int i = lastVariable - 1; i >= 0; --i) {
                do {
                    evaluationPoint[i] = (int)MultivariateGCD.randomElement(ring, rnd);
                } while (ring.isZero(evaluationPoint[i]));
            }
            powers = MultivariateGCD.mkPrecomputedPowers(a, b, evaluationVariables, evaluationPoint);
            for (MultivariatePolynomial p : Arrays.asList(a, b, skeleton)) {
                if (p.getSkeleton(0).equals(p.evaluate(powers, evaluationVariables).getSkeleton())) continue;
                ++fails;
                continue block0;
            }
            break;
        }
        int requiredNumberOfEvaluations = -1;
        int monicScalingExponent = -1;
        TIntObjectIterator<MultivariatePolynomial<E>> it = univarSkeleton.iterator();
        while (it.hasNext()) {
            it.advance();
            MultivariatePolynomial<E> v = it.value();
            if (v.size() > requiredNumberOfEvaluations) {
                requiredNumberOfEvaluations = v.size();
            }
            if (v.size() != 1) continue;
            monicScalingExponent = it.key();
        }
        if (!ALWAYS_LINZIP) {
            if (monic) {
                monicScalingExponent = -1;
            }
            if (monic || monicScalingExponent != -1) {
                return new MonicInterpolation<int>(ring, variable, a, b, globalSkeleton, univarSkeleton, sparseUnivarDegrees, evaluationVariables, evaluationPoint, powers, expectedNumberOfEvaluations, rnd, requiredNumberOfEvaluations, monicScalingExponent);
            }
        }
        return new LinZipInterpolation<int>(ring, variable, a, b, globalSkeleton, univarSkeleton, sparseUnivarDegrees, evaluationVariables, evaluationPoint, powers, expectedNumberOfEvaluations, rnd);
    }

    private static <E> MultivariatePolynomial.PrecomputedPowersHolder<E> mkPrecomputedPowers(MultivariatePolynomial<E> a, MultivariatePolynomial<E> b, int[] evaluationVariables, E[] evaluationPoint) {
        int[] degrees = ArraysUtil.max(a.degreesRef(), b.degreesRef());
        MultivariatePolynomial.PrecomputedPowers[] pp = new MultivariatePolynomial.PrecomputedPowers[a.nVariables];
        for (int i = 0; i < evaluationVariables.length; ++i) {
            pp[evaluationVariables[i]] = new MultivariatePolynomial.PrecomputedPowers<E>(Math.min(degrees[evaluationVariables[i]], 1014), evaluationPoint[i], a.ring);
        }
        return new MultivariatePolynomial.PrecomputedPowersHolder(a.ring, pp);
    }

    static <E> TIntObjectHashMap<MultivariatePolynomial<E>> getSkeleton(MultivariatePolynomial<E> poly) {
        TIntObjectHashMap<MultivariatePolynomial<E>> skeleton = new TIntObjectHashMap<MultivariatePolynomial<E>>();
        for (Monomial monomial : poly) {
            Monomial newDV = (Monomial)monomial.setZero(0);
            MultivariatePolynomial<E> coeff = skeleton.get(monomial.exponents[0]);
            if (coeff != null) {
                coeff.add(newDV);
                continue;
            }
            skeleton.put(monomial.exponents[0], MultivariatePolynomial.create(poly.nVariables, poly.ring, (Comparator<DegreeVector>)poly.ordering, newDV));
        }
        return skeleton;
    }

    static <E> ZippelEvaluations<E> createEvaluations(MultivariatePolynomial<E> poly, int[] evaluationVariables, E[] evaluationPoint, MultivariatePolynomial.PrecomputedPowersHolder<E> basePowers, int expectedNumberOfEvaluations) {
        if (expectedNumberOfEvaluations > 16 && poly.size() > 512) {
            return new FastSparseRecursiveEvaluations<E>(poly, evaluationPoint, evaluationVariables[evaluationVariables.length - 1]);
        }
        return new PlainEvaluations<E>(poly, evaluationVariables, evaluationPoint, basePowers);
    }

    private static <E> int nUnderDeterminedLinZip(MultivariatePolynomial<E> factory, LinZipSystem<E>[] subSystems, int nUnknownScalings) {
        int nUnknownsMonomials = 0;
        for (LinZipSystem<E> system : subSystems) {
            nUnknownsMonomials += system.skeleton.length;
        }
        int nUnknownsTotal = nUnknownsMonomials + nUnknownScalings;
        ArrayList<E[]> lhsGlobal = new ArrayList<E[]>();
        int offset = 0;
        Ring ring = factory.ring;
        for (LinZipSystem<E> system : subSystems) {
            for (int j = 0; j < system.matrix.size(); ++j) {
                E[] row = ring.createZeroesArray(nUnknownsTotal);
                Object[] subRow = (Object[])system.matrix.get(j);
                System.arraycopy(subRow, 0, row, offset, subRow.length);
                if (j > 0) {
                    row[nUnknownsMonomials + j - 1] = ((LinZipSystem)system).scalingMatrix.get(j);
                }
                lhsGlobal.add(row);
            }
            offset += system.skeleton.length;
        }
        return LinearSolver.rowEchelonForm(factory.ring, (Object[][])lhsGlobal.toArray((T[])ring.createArray2d(lhsGlobal.size())), null, false, false);
    }

    private static <E> LinearSolver.SystemInfo solveLinZip(MultivariatePolynomial<E> factory, LinZipSystem<E>[] subSystems, int nUnknownScalings, MultivariatePolynomial<E> destination) {
        ArrayList<Monomial> unknowns = new ArrayList<Monomial>();
        for (LinZipSystem<E> system : subSystems) {
            for (Monomial degreeVector : system.skeleton) {
                unknowns.add((Monomial)degreeVector.set(0, system.univarDegree));
            }
        }
        int nUnknownsMonomials = unknowns.size();
        int nUnknownsTotal = nUnknownsMonomials + nUnknownScalings;
        ArrayList<E[]> lhsGlobal = new ArrayList<E[]>();
        ArrayList rhsGlobal = new ArrayList();
        int offset = 0;
        Ring<int> ring = factory.ring;
        for (LinZipSystem<E> system : subSystems) {
            for (int j = 0; j < system.matrix.size(); ++j) {
                E[] row = ring.createZeroesArray(nUnknownsTotal);
                Object[] subRow = (Object[])system.matrix.get(j);
                System.arraycopy(subRow, 0, row, offset, subRow.length);
                if (j > 0) {
                    row[nUnknownsMonomials + j - 1] = ((LinZipSystem)system).scalingMatrix.get(j);
                }
                lhsGlobal.add(row);
                rhsGlobal.add(system.rhs.get(j));
            }
            offset += system.skeleton.length;
        }
        int[] solution = ring.createArray(nUnknownsTotal);
        LinearSolver.SystemInfo info = LinearSolver.solve(ring, lhsGlobal, rhsGlobal, solution);
        if (info == LinearSolver.SystemInfo.Consistent) {
            Monomial[] terms = new Monomial[unknowns.size()];
            for (int i = 0; i < terms.length; ++i) {
                terms[i] = ((Monomial)unknowns.get(i)).setCoefficient(solution[i]);
            }
            destination.add(terms);
        }
        return info;
    }

    private static <E> E evaluateExceptFirst(Ring<E> ring, MultivariatePolynomial.PrecomputedPowersHolder<E> powers, E coefficient, Monomial<E> skeleton, int raiseFactor, int nVars) {
        E tmp = coefficient;
        for (int k = 1; k <= nVars; ++k) {
            tmp = ring.multiply(tmp, powers.pow(k, raiseFactor * skeleton.exponents[k]));
        }
        return tmp;
    }

    private static <E> boolean isVandermonde(E[][] lhs, Ring<E> ring) {
        for (int i = 1; i < lhs.length; ++i) {
            for (int j = 0; j < lhs[0].length; ++j) {
                if (lhs[i][j].equals(ring.pow(lhs[0][j], i + 1))) continue;
                return false;
            }
        }
        return true;
    }

    public static MultivariatePolynomialZp64 BrownGCD(MultivariatePolynomialZp64 a, MultivariatePolynomialZp64 b) {
        GCDInput<MonomialZp64, MultivariatePolynomialZp64> gcdInput = MultivariateGCD.preparedGCDInput(a, b, MultivariateGCD::BrownGCD);
        if (gcdInput.earlyGCD != null) {
            return (MultivariatePolynomialZp64)gcdInput.earlyGCD;
        }
        if (gcdInput.finiteExtensionDegree > 1) {
            return MultivariateGCD.lKaltofenMonaganSparseModularGCDInGF(gcdInput);
        }
        MultivariatePolynomialZp64 result = MultivariateGCD.BrownGCD((MultivariatePolynomialZp64)gcdInput.aReduced, (MultivariatePolynomialZp64)gcdInput.bReduced, PrivateRandom.getRandom(), gcdInput.lastPresentVariable, gcdInput.degreeBounds, gcdInput.evaluationStackLimit);
        if (result == null) {
            return MultivariateGCD.lKaltofenMonaganSparseModularGCDInGF(gcdInput);
        }
        return gcdInput.restoreGCD(result);
    }

    private static MultivariatePolynomialZp64 BrownGCD(MultivariatePolynomialZp64 a, MultivariatePolynomialZp64 b, RandomGenerator rnd, int variable, int[] degreeBounds, int evaluationStackLimit) {
        MultivariatePolynomialZp64 result;
        MultivariatePolynomialZp64 trivialGCD = MultivariateGCD.trivialGCD(a, b);
        if (trivialGCD != null) {
            return trivialGCD;
        }
        MultivariatePolynomialZp64 factory = a;
        int nVariables = factory.nVariables;
        if (variable == 0) {
            UnivariatePolynomialZp64 gcd = UnivariateGCD.PolynomialGCD(a.asUnivariate(), b.asUnivariate());
            if (gcd.degree() == 0) {
                return factory.createOne();
            }
            return (MultivariatePolynomialZp64)AMultivariatePolynomial.asMultivariate(gcd, nVariables, variable, factory.ordering);
        }
        PrimitiveInput primitiveInput = MultivariateGCD.makePrimitive(a, b, variable);
        a = (MultivariatePolynomialZp64)primitiveInput.aPrimitive;
        b = (MultivariatePolynomialZp64)primitiveInput.bPrimitive;
        UnivariatePolynomialZp64 contentGCD = (UnivariatePolynomialZp64)primitiveInput.contentGCD;
        UnivariatePolynomialZp64 lcGCD = (UnivariatePolynomialZp64)primitiveInput.lcGCD;
        trivialGCD = MultivariateGCD.trivialGCD(a, b);
        if (trivialGCD != null) {
            MultivariatePolynomialZp64 poly = (MultivariatePolynomialZp64)AMultivariatePolynomial.asMultivariate(contentGCD, a.nVariables, variable, a.ordering);
            return trivialGCD.multiply(poly);
        }
        IntegersZp64 ring = factory.ring;
        int prevVarExponent = degreeBounds[variable - 1];
        MultivariateInterpolation.InterpolationZp64 interpolation = null;
        TLongHashSet evaluationStack = new TLongHashSet();
        int[] aDegrees = a.degrees();
        int[] bDegrees = b.degrees();
        block0: while (true) {
            int currExponent;
            if (evaluationStackLimit == evaluationStack.size()) {
                return MultivariateGCD.doDivisionCheck(a, b, contentGCD, interpolation, variable);
            }
            long randomPoint = ring.randomElement(rnd);
            if (evaluationStack.contains(randomPoint)) continue;
            evaluationStack.add(randomPoint);
            long lcVal = lcGCD.evaluate(randomPoint);
            if (lcVal == 0L) continue;
            MultivariatePolynomialZp64 aVal = a.evaluate(variable, randomPoint);
            MultivariatePolynomialZp64 bVal = b.evaluate(variable, randomPoint);
            int[] aValDegrees = aVal.degrees();
            int[] bValDegrees = bVal.degrees();
            for (int i = variable - 1; i >= 0; --i) {
                if (aDegrees[i] != aValDegrees[i] || bDegrees[i] != bValDegrees[i]) continue block0;
            }
            MultivariatePolynomialZp64 cVal = MultivariateGCD.BrownGCD(aVal, bVal, rnd, variable - 1, degreeBounds, evaluationStackLimit);
            if (cVal == null || (currExponent = cVal.degree(variable - 1)) > prevVarExponent) continue;
            cVal = cVal.multiply(ring.multiply(ring.reciprocal(cVal.lc()), lcVal));
            assert (cVal.lc() == lcVal);
            if (currExponent < prevVarExponent) {
                interpolation = new MultivariateInterpolation.InterpolationZp64(variable, randomPoint, cVal);
                degreeBounds[variable - 1] = prevVarExponent = currExponent;
                continue;
            }
            if (interpolation == null) {
                interpolation = new MultivariateInterpolation.InterpolationZp64(variable, randomPoint, cVal);
                continue;
            }
            MultivariatePolynomialZp64 previousInterpolation = interpolation.getInterpolatingPolynomial().clone();
            interpolation.update(randomPoint, cVal);
            if ((degreeBounds[variable] <= interpolation.numberOfPoints() || previousInterpolation.equals(interpolation.getInterpolatingPolynomial())) && (result = MultivariateGCD.doDivisionCheck(a, b, contentGCD, interpolation, variable)) != null) break;
        }
        return result;
    }

    private static MultivariatePolynomialZp64 doDivisionCheck(MultivariatePolynomialZp64 a, MultivariatePolynomialZp64 b, UnivariatePolynomialZp64 contentGCD, MultivariateInterpolation.InterpolationZp64 interpolation, int variable) {
        if (interpolation == null) {
            return null;
        }
        MultivariatePolynomialZp64 interpolated = MultivariatePolynomialZp64.asNormalMultivariate((MultivariatePolynomial<UnivariatePolynomialZp64>)interpolation.getInterpolatingPolynomial().asOverUnivariateEliminate(variable).primitivePart(), variable);
        if (!MultivariateGCD.isGCDTriplet(a, b, interpolated)) {
            return null;
        }
        if (contentGCD == null) {
            return interpolated;
        }
        MultivariatePolynomialZp64 poly = (MultivariatePolynomialZp64)AMultivariatePolynomial.asMultivariate(contentGCD, a.nVariables, variable, a.ordering);
        return interpolated.multiply(poly);
    }

    private static boolean isGCDTriplet(MultivariatePolynomialZp64 a, MultivariatePolynomialZp64 b, MultivariatePolynomialZp64 gcd) {
        if (Math.max(a.size(), b.size()) > 64000) {
            IntegersZp64 ring = a.ring;
            long[] subs = new long[a.nVariables - 1];
            for (int i = 0; i < subs.length; ++i) {
                subs[i] = ring.randomNonZeroElement(PrivateRandom.getRandom());
            }
            MultivariatePolynomialZp64.lPrecomputedPowersHolder powers = a.mkPrecomputedPowers(ArraysUtil.sequence(0, a.nVariables - 1), subs);
            UnivariatePolynomialZp64 uniDiv = MultivariateGCD.subsToUnivariate(gcd, powers);
            if (!UnivariateDivision.remainder(MultivariateGCD.subsToUnivariate(a, powers), uniDiv, false).isZero() || !UnivariateDivision.remainder(MultivariateGCD.subsToUnivariate(b, powers), uniDiv, false).isZero()) {
                return false;
            }
        }
        return MultivariateDivision.dividesQ(a, gcd) && MultivariateDivision.dividesQ(b, gcd);
    }

    private static UnivariatePolynomialZp64 subsToUnivariate(MultivariatePolynomialZp64 a, MultivariatePolynomialZp64.lPrecomputedPowersHolder powers) {
        long[] aUni = new long[a.degree(a.nVariables - 1) + 1];
        for (MonomialZp64 t : a) {
            long val = t.coefficient;
            for (int i = 0; i < a.nVariables - 1; ++i) {
                val = a.ring.multiply(val, powers.pow(i, t.exponents[i]));
            }
            aUni[t.exponents[a.nVariables - 1]] = a.ring.add(aUni[t.exponents[a.nVariables - 1]], val);
        }
        return UnivariatePolynomialZp64.createUnsafe(a.ring, aUni);
    }

    public static MultivariatePolynomialZp64 ZippelGCD(MultivariatePolynomialZp64 a, MultivariatePolynomialZp64 b) {
        GCDInput<MonomialZp64, MultivariatePolynomialZp64> gcdInput = MultivariateGCD.preparedGCDInput(a, b, MultivariateGCD::ZippelGCD);
        if (gcdInput.earlyGCD != null) {
            return (MultivariatePolynomialZp64)gcdInput.earlyGCD;
        }
        if (gcdInput.finiteExtensionDegree > 1) {
            return MultivariateGCD.lKaltofenMonaganSparseModularGCDInGF(gcdInput);
        }
        a = (MultivariatePolynomialZp64)gcdInput.aReduced;
        b = (MultivariatePolynomialZp64)gcdInput.bReduced;
        MultivariatePolynomialZp64 content = MultivariateGCD.contentGCD(a, b, 0, MultivariateGCD::ZippelGCD);
        MultivariatePolynomialZp64 result = MultivariateGCD.ZippelGCD(a = MultivariateDivision.divideExact(a, content), b = MultivariateDivision.divideExact(b, content), PrivateRandom.getRandom(), gcdInput.lastPresentVariable, gcdInput.degreeBounds, gcdInput.evaluationStackLimit);
        if (result == null) {
            return MultivariateGCD.lKaltofenMonaganSparseModularGCDInGF(gcdInput);
        }
        return gcdInput.restoreGCD(result.multiply(content));
    }

    private static MultivariatePolynomialZp64 ZippelGCD(MultivariatePolynomialZp64 a, MultivariatePolynomialZp64 b, RandomGenerator rnd, int variable, int[] degreeBounds, int evaluationStackLimit) {
        MultivariatePolynomialZp64 result;
        MultivariatePolynomialZp64 trivialGCD = MultivariateGCD.trivialGCD(a, b);
        if (trivialGCD != null) {
            return trivialGCD;
        }
        MultivariatePolynomialZp64 factory = a;
        int nVariables = factory.nVariables;
        if (variable == 0) {
            UnivariatePolynomialZp64 gcd = UnivariateGCD.PolynomialGCD(a.asUnivariate(), b.asUnivariate());
            if (gcd.degree() == 0) {
                return factory.createOne();
            }
            return (MultivariatePolynomialZp64)AMultivariatePolynomial.asMultivariate(gcd, nVariables, variable, factory.ordering);
        }
        PrimitiveInput primitiveInput = MultivariateGCD.makePrimitive(a, b, variable);
        a = (MultivariatePolynomialZp64)primitiveInput.aPrimitive;
        b = (MultivariatePolynomialZp64)primitiveInput.bPrimitive;
        UnivariatePolynomialZp64 contentGCD = (UnivariatePolynomialZp64)primitiveInput.contentGCD;
        UnivariatePolynomialZp64 lcGCD = (UnivariatePolynomialZp64)primitiveInput.lcGCD;
        trivialGCD = MultivariateGCD.trivialGCD(a, b);
        if (trivialGCD != null) {
            MultivariatePolynomialZp64 poly = (MultivariatePolynomialZp64)AMultivariatePolynomial.asMultivariate(contentGCD, a.nVariables, variable, a.ordering);
            return trivialGCD.multiply(poly);
        }
        IntegersZp64 ring = factory.ring;
        TLongHashSet globalEvaluationStack = new TLongHashSet();
        int[] aDegrees = a.degreesRef();
        int[] bDegrees = b.degreesRef();
        int failedSparseInterpolations = 0;
        int[] tmpDegreeBounds = (int[])degreeBounds.clone();
        block0: while (true) {
            int currExponent;
            if (evaluationStackLimit == globalEvaluationStack.size()) {
                return null;
            }
            long seedPoint = ring.randomElement(rnd);
            if (globalEvaluationStack.contains(seedPoint)) continue;
            globalEvaluationStack.add(seedPoint);
            long lcVal = lcGCD.evaluate(seedPoint);
            if (lcVal == 0L) continue;
            MultivariatePolynomialZp64 aVal = a.evaluate(variable, seedPoint);
            MultivariatePolynomialZp64 bVal = b.evaluate(variable, seedPoint);
            int[] aValDegrees = aVal.degreesRef();
            int[] bValDegrees = bVal.degreesRef();
            for (int i = variable - 1; i >= 0; --i) {
                if (aDegrees[i] != aValDegrees[i] || bDegrees[i] != bValDegrees[i]) continue block0;
            }
            MultivariatePolynomialZp64 cVal = MultivariateGCD.ZippelGCD(aVal, bVal, rnd, variable - 1, tmpDegreeBounds, evaluationStackLimit);
            if (cVal == null || (currExponent = cVal.degree(variable - 1)) > tmpDegreeBounds[variable - 1]) continue;
            if (currExponent < tmpDegreeBounds[variable - 1]) {
                tmpDegreeBounds[variable - 1] = currExponent;
            }
            cVal = cVal.multiply(ring.multiply(ring.reciprocal(cVal.lc()), lcVal));
            assert (cVal.lc() == lcVal);
            lSparseInterpolation sparseInterpolator = MultivariateGCD.createInterpolation(variable, a, b, cVal, tmpDegreeBounds[variable], rnd);
            if (sparseInterpolator == null) continue;
            MultivariateInterpolation.InterpolationZp64 denseInterpolation = new MultivariateInterpolation.InterpolationZp64(variable, seedPoint, cVal);
            TLongHashSet localEvaluationStack = new TLongHashSet(globalEvaluationStack);
            while (true) {
                if (evaluationStackLimit == localEvaluationStack.size()) {
                    return null;
                }
                if (denseInterpolation.numberOfPoints() > tmpDegreeBounds[variable] + 64) {
                    tmpDegreeBounds = (int[])degreeBounds.clone();
                    continue block0;
                }
                long randomPoint = ring.randomElement(rnd);
                if (localEvaluationStack.contains(randomPoint)) continue;
                localEvaluationStack.add(randomPoint);
                lcVal = lcGCD.evaluate(randomPoint);
                if (lcVal == 0L) continue;
                cVal = sparseInterpolator.evaluate(randomPoint);
                if (cVal == null) {
                    if (++failedSparseInterpolations == 64) {
                        return null;
                    }
                    tmpDegreeBounds = (int[])degreeBounds.clone();
                    continue block0;
                }
                cVal = cVal.multiply(ring.multiply(ring.reciprocal(cVal.lc()), lcVal));
                assert (cVal.lc() == lcVal);
                MultivariatePolynomialZp64 previousInterpolation = denseInterpolation.getInterpolatingPolynomial().clone();
                denseInterpolation.update(randomPoint, cVal);
                if ((tmpDegreeBounds[variable] <= denseInterpolation.numberOfPoints() && denseInterpolation.numberOfPoints() - tmpDegreeBounds[variable] < 3 || previousInterpolation.equals(denseInterpolation.getInterpolatingPolynomial())) && (result = MultivariateGCD.doDivisionCheck(a, b, contentGCD, denseInterpolation, variable)) != null) break block0;
            }
            break;
        }
        return result;
    }

    static lSparseInterpolation createInterpolation(int variable, MultivariatePolynomialZp64 a, MultivariatePolynomialZp64 b, MultivariatePolynomialZp64 skeleton, int expectedNumberOfEvaluations, RandomGenerator rnd) {
        MultivariatePolynomialZp64.lPrecomputedPowersHolder powers;
        assert (a.nVariables > 1);
        if ((skeleton = (MultivariatePolynomialZp64)skeleton.clone().setAllCoefficientsToUnit()).size() == 1) {
            return new lTrivialSparseInterpolation(skeleton);
        }
        boolean monic = ((MultivariatePolynomialZp64)a.coefficientOf(0, a.degree(0))).isConstant() && ((MultivariatePolynomialZp64)b.coefficientOf(0, a.degree(0))).isConstant();
        Set<DegreeVector> globalSkeleton = skeleton.getSkeleton();
        TIntObjectHashMap<MultivariatePolynomialZp64> univarSkeleton = MultivariateGCD.getSkeleton(skeleton);
        int[] sparseUnivarDegrees = univarSkeleton.keys();
        IntegersZp64 ring = a.ring;
        int lastVariable = variable == -1 ? a.nVariables - 1 : variable;
        int[] evaluationVariables = ArraysUtil.sequence(1, lastVariable + 1);
        long[] evaluationPoint = new long[evaluationVariables.length];
        int fails = 0;
        block0: while (true) {
            if (fails >= 32) {
                return null;
            }
            for (int i = lastVariable - 1; i >= 0; --i) {
                do {
                    evaluationPoint[i] = ring.randomElement(rnd);
                } while (evaluationPoint[i] == 0L);
            }
            powers = MultivariateGCD.mkPrecomputedPowers(a, b, evaluationVariables, evaluationPoint);
            for (MultivariatePolynomialZp64 p : Arrays.asList(a, b, skeleton)) {
                if (p.getSkeleton(0).equals(p.evaluate(powers, evaluationVariables).getSkeleton())) continue;
                ++fails;
                continue block0;
            }
            break;
        }
        int requiredNumberOfEvaluations = -1;
        int monicScalingExponent = -1;
        TIntObjectIterator<MultivariatePolynomialZp64> it = univarSkeleton.iterator();
        while (it.hasNext()) {
            it.advance();
            MultivariatePolynomialZp64 v = it.value();
            if (v.size() > requiredNumberOfEvaluations) {
                requiredNumberOfEvaluations = v.size();
            }
            if (v.size() != 1) continue;
            monicScalingExponent = it.key();
        }
        if (!ALWAYS_LINZIP) {
            if (monic) {
                monicScalingExponent = -1;
            }
            if (monic || monicScalingExponent != -1) {
                return new lMonicInterpolation(ring, variable, a, b, globalSkeleton, univarSkeleton, sparseUnivarDegrees, evaluationVariables, evaluationPoint, powers, expectedNumberOfEvaluations, rnd, requiredNumberOfEvaluations, monicScalingExponent);
            }
        }
        return new lLinZipInterpolation(ring, variable, a, b, globalSkeleton, univarSkeleton, sparseUnivarDegrees, evaluationVariables, evaluationPoint, powers, expectedNumberOfEvaluations, rnd);
    }

    static MultivariatePolynomialZp64.lPrecomputedPowersHolder mkPrecomputedPowers(MultivariatePolynomialZp64 a, MultivariatePolynomialZp64 b, int[] evaluationVariables, long[] evaluationPoint) {
        int[] degrees = ArraysUtil.max(a.degreesRef(), b.degreesRef());
        MultivariatePolynomialZp64.lPrecomputedPowers[] pp = new MultivariatePolynomialZp64.lPrecomputedPowers[a.nVariables];
        for (int i = 0; i < evaluationVariables.length; ++i) {
            pp[evaluationVariables[i]] = new MultivariatePolynomialZp64.lPrecomputedPowers(Math.min(degrees[evaluationVariables[i]], 1014), evaluationPoint[i], a.ring);
        }
        return new MultivariatePolynomialZp64.lPrecomputedPowersHolder(a.ring, pp);
    }

    static TIntObjectHashMap<MultivariatePolynomialZp64> getSkeleton(MultivariatePolynomialZp64 poly) {
        TIntObjectHashMap<MultivariatePolynomialZp64> skeleton = new TIntObjectHashMap<MultivariatePolynomialZp64>();
        for (MonomialZp64 term : poly) {
            MonomialZp64 newDV = (MonomialZp64)term.setZero(0);
            MultivariatePolynomialZp64 coeff = skeleton.get(term.exponents[0]);
            if (coeff != null) {
                coeff.add(newDV);
                continue;
            }
            skeleton.put(term.exponents[0], MultivariatePolynomialZp64.create(poly.nVariables, poly.ring, (Comparator<DegreeVector>)poly.ordering, newDV));
        }
        return skeleton;
    }

    static ZippelEvaluationsZp64 createEvaluations(MultivariatePolynomialZp64 poly, int[] evaluationVariables, long[] evaluationPoint, MultivariatePolynomialZp64.lPrecomputedPowersHolder basePowers, int expectedNumberOfEvaluations) {
        if (expectedNumberOfEvaluations > 16 && poly.size() > 512) {
            return new FastSparseRecursiveEvaluationsZp64(poly, evaluationPoint, evaluationVariables[evaluationVariables.length - 1]);
        }
        return new PlainEvaluationsZp64(poly, evaluationVariables, evaluationPoint, basePowers);
    }

    private static int nUnderDeterminedLinZip(MultivariatePolynomialZp64 factory, lLinZipSystem[] subSystems, int nUnknownScalings) {
        int nUnknownsMonomials = 0;
        for (lLinZipSystem system : subSystems) {
            nUnknownsMonomials += system.skeleton.length;
        }
        int nUnknownsTotal = nUnknownsMonomials + nUnknownScalings;
        ArrayList<long[]> lhsGlobal = new ArrayList<long[]>();
        int offset = 0;
        for (lLinZipSystem system : subSystems) {
            for (int j = 0; j < system.matrix.size(); ++j) {
                long[] row = new long[nUnknownsTotal];
                long[] subRow = (long[])system.matrix.get(j);
                System.arraycopy(subRow, 0, row, offset, subRow.length);
                if (j > 0) {
                    row[nUnknownsMonomials + j - 1] = system.scalingMatrix.get(j);
                }
                lhsGlobal.add(row);
            }
            offset += system.skeleton.length;
        }
        return LinearSolver.rowEchelonForm(factory.ring, (long[][])lhsGlobal.toArray((T[])new long[lhsGlobal.size()][]), null, false, false);
    }

    private static LinearSolver.SystemInfo solveLinZip(MultivariatePolynomialZp64 factory, lLinZipSystem[] subSystems, int nUnknownScalings, MultivariatePolynomialZp64 destination) {
        ArrayList<MonomialZp64> unknowns = new ArrayList<MonomialZp64>();
        for (lLinZipSystem system : subSystems) {
            for (MonomialZp64 degreeVector : system.skeleton) {
                unknowns.add((MonomialZp64)degreeVector.set(0, system.univarDegree));
            }
        }
        int nUnknownsMonomials = unknowns.size();
        int nUnknownsTotal = nUnknownsMonomials + nUnknownScalings;
        ArrayList<long[]> lhsGlobal = new ArrayList<long[]>();
        TLongArrayList rhsGlobal = new TLongArrayList();
        int offset = 0;
        IntegersZp64 ring = factory.ring;
        for (lLinZipSystem system : subSystems) {
            for (int j = 0; j < system.matrix.size(); ++j) {
                long[] row = new long[nUnknownsTotal];
                long[] subRow = (long[])system.matrix.get(j);
                System.arraycopy(subRow, 0, row, offset, subRow.length);
                if (j > 0) {
                    row[nUnknownsMonomials + j - 1] = system.scalingMatrix.get(j);
                }
                lhsGlobal.add(row);
                rhsGlobal.add(system.rhs.get(j));
            }
            offset += system.skeleton.length;
        }
        long[] solution = new long[nUnknownsTotal];
        LinearSolver.SystemInfo info = LinearSolver.solve(ring, lhsGlobal, rhsGlobal, solution);
        if (info == LinearSolver.SystemInfo.Consistent) {
            MonomialZp64[] terms = new MonomialZp64[unknowns.size()];
            for (int i = 0; i < terms.length; ++i) {
                terms[i] = ((MonomialZp64)unknowns.get(i)).setCoefficient(solution[i]);
            }
            destination.add(terms);
        }
        return info;
    }

    private static long evaluateExceptFirst(IntegersZp64 ring, MultivariatePolynomialZp64.lPrecomputedPowersHolder powers, long coefficient, MonomialZp64 skeleton, int raiseFactor, int nVars) {
        long tmp = coefficient;
        for (int k = 1; k <= nVars; ++k) {
            tmp = ring.multiply(tmp, powers.pow(k, raiseFactor * skeleton.exponents[k]));
        }
        return tmp;
    }

    public static MultivariatePolynomialZp64 EZGCD(MultivariatePolynomialZp64 a, MultivariatePolynomialZp64 b) {
        GCDInput gcdInput = MultivariateGCD.preparedGCDInput(a, b, MultivariateGCD::EZGCD);
        if (gcdInput.earlyGCD != null) {
            return (MultivariatePolynomialZp64)gcdInput.earlyGCD;
        }
        a = (MultivariatePolynomialZp64)gcdInput.aReduced;
        b = (MultivariatePolynomialZp64)gcdInput.bReduced;
        MultivariatePolynomialZp64 content = a.createOne();
        for (int i = 0; i < a.nVariables; ++i) {
            if (a.degree(i) == 0 || b.degree(i) == 0) continue;
            MultivariatePolynomialZp64 tmpContent = MultivariateGCD.contentGCD(a, b, i, MultivariateGCD::EZGCD);
            a = MultivariateDivision.divideExact(a, tmpContent);
            b = MultivariateDivision.divideExact(b, tmpContent);
            content = content.multiply(tmpContent);
        }
        GCDInput gcdInput2 = MultivariateGCD.preparedGCDInput(a, b, MultivariateGCD::EZGCD);
        a = (MultivariatePolynomialZp64)gcdInput2.aReduced;
        b = (MultivariatePolynomialZp64)gcdInput2.bReduced;
        MultivariatePolynomialZp64 result = gcdInput2.earlyGCD != null ? (MultivariatePolynomialZp64)gcdInput2.earlyGCD : gcdInput2.restoreGCD(MultivariateGCD.EZGCD0(a, b, gcdInput2.lastPresentVariable + 1, PrivateRandom.getRandom()));
        result = result.multiply(content);
        return gcdInput.restoreGCD(result);
    }

    private static MultivariatePolynomialZp64 EZGCD0(MultivariatePolynomialZp64 a, MultivariatePolynomialZp64 b, int nUsedVariables, RandomGenerator rnd) {
        MultivariatePolynomialZp64 gcd;
        int ugcdDegree = Integer.MAX_VALUE;
        EZGCDEvaluations evaluations = new EZGCDEvaluations(a, b, nUsedVariables, rnd);
        HenselLifting.lEvaluation evaluation = new HenselLifting.lEvaluation(a.nVariables, ArraysUtil.arrayOf(0L, a.nVariables - 1), a.ring, a.ordering);
        while (true) {
            UnivariatePolynomialZp64 uaCoFactor;
            boolean swapped;
            if (swapped = evaluations.nextEvaluation()) {
                ugcdDegree = Integer.MAX_VALUE;
            }
            a = evaluations.aReduced;
            b = evaluations.bReduced;
            int uaDegree = a.degree(0);
            int ubDegree = b.degree(0);
            UnivariatePolynomialZp64 ua = a.evaluateAtZeroAllExcept(0);
            UnivariatePolynomialZp64 ub = b.evaluateAtZeroAllExcept(0);
            assert (ua.degree() == uaDegree);
            assert (ub.degree() == ubDegree);
            UnivariatePolynomialZp64 ugcd = UnivariateGCD.PolynomialGCD(ua, ub);
            if (ugcd.degree() == 0) {
                return evaluations.reconstruct(a.createOne());
            }
            if (ugcd.degree() > ugcdDegree) continue;
            ugcdDegree = ugcd.degree();
            if (ugcdDegree == uaDegree && MultivariateDivision.dividesQ(b, a)) {
                return evaluations.reconstruct(a);
            }
            if (ugcdDegree == ubDegree && MultivariateDivision.dividesQ(a, b)) {
                return evaluations.reconstruct(b);
            }
            MultivariatePolynomialZp64 base = null;
            UnivariatePolynomialZp64 uCoFactor = null;
            MultivariatePolynomialZp64 coFactorLC = null;
            UnivariatePolynomialZp64 ubCoFactor = UnivariateDivision.quotient(ub, ugcd, true);
            if (UnivariateGCD.PolynomialGCD(ugcd, ubCoFactor).isConstant()) {
                base = b;
                uCoFactor = ubCoFactor;
                coFactorLC = (MultivariatePolynomialZp64)b.lc(0);
            }
            if (base == null && UnivariateGCD.PolynomialGCD(ugcd, uaCoFactor = UnivariateDivision.quotient(ua, ugcd, true)).isConstant()) {
                base = a;
                uCoFactor = uaCoFactor;
                coFactorLC = (MultivariatePolynomialZp64)a.lc(0);
            }
            if (base == null) {
                MultivariatePolynomialZp64 bRepeatedFactor = MultivariateGCD.EZGCD(b, b.derivative(0, 1));
                MultivariatePolynomialZp64 squareFreeGCD = MultivariateGCD.EZGCD(MultivariateDivision.divideExact(b, bRepeatedFactor), a);
                MultivariatePolynomialZp64 aRepeatedFactor = MultivariateDivision.divideExact(a, squareFreeGCD);
                MultivariatePolynomialZp64 gcd2 = squareFreeGCD.clone();
                UnivariatePolynomialZp64 uSquareFreeGCD = squareFreeGCD.evaluateAtZeroAllExcept(0);
                UnivariatePolynomialZp64 uaRepeatedFactor = aRepeatedFactor.evaluateAtZeroAllExcept(0);
                UnivariatePolynomialZp64 ubRepeatedFactor = bRepeatedFactor.evaluateAtZeroAllExcept(0);
                while (true) {
                    if ((ugcd = (UnivariatePolynomialZp64)UnivariateGCD.PolynomialGCD((IUnivariatePolynomial[])new UnivariatePolynomialZp64[]{uSquareFreeGCD, uaRepeatedFactor, ubRepeatedFactor})).degree() == 0) {
                        return evaluations.reconstruct(gcd2);
                    }
                    if (!uSquareFreeGCD.clone().monic().equals(ugcd.clone().monic())) {
                        MultivariatePolynomialZp64 mgcd = MultivariatePolynomialZp64.asMultivariate(ugcd, a.nVariables, 0, (Comparator<DegreeVector>)a.ordering);
                        MultivariatePolynomialZp64 gcdCoFactor = MultivariatePolynomialZp64.asMultivariate(UnivariateDivision.divideExact(uSquareFreeGCD, ugcd, false), a.nVariables, 0, (Comparator<DegreeVector>)a.ordering);
                        MultivariateGCD.liftPairAutomaticLC(squareFreeGCD, mgcd, gcdCoFactor, evaluation);
                        squareFreeGCD = mgcd.clone();
                        uSquareFreeGCD = squareFreeGCD.evaluateAtZeroAllExcept(0);
                    }
                    gcd2 = gcd2.multiply(squareFreeGCD);
                    uaRepeatedFactor = UnivariateDivision.divideExact(uaRepeatedFactor, ugcd, false);
                    ubRepeatedFactor = UnivariateDivision.divideExact(ubRepeatedFactor, ugcd, false);
                }
            }
            gcd = MultivariatePolynomialZp64.asMultivariate(ugcd, a.nVariables, 0, (Comparator<DegreeVector>)a.ordering);
            MultivariatePolynomialZp64 coFactor = MultivariatePolynomialZp64.asMultivariate(uCoFactor, a.nVariables, 0, (Comparator<DegreeVector>)a.ordering);
            MultivariatePolynomialZp64 lcCorrection = MultivariateGCD.EZGCD((MultivariatePolynomialZp64)a.lc(0), (MultivariatePolynomialZp64)b.lc(0));
            assert (MultivariateGCD.ZippelGCD((MultivariatePolynomialZp64)a.lc(0), (MultivariatePolynomialZp64)b.lc(0)).monic(lcCorrection.lc()).equals(lcCorrection)) : "\n" + a.lc(0) + "  \n " + b.lc(0);
            if (lcCorrection.isOne()) {
                assert (gcd.isMonic());
                assert (evaluation.evaluateFrom(base, 1).equals(gcd.clone().multiply(coFactor)));
                MultivariateGCD.liftPair(base, gcd, coFactor, null, (MultivariatePolynomialZp64)base.lc(0), evaluation);
            } else {
                long lcCorrectionMod = lcCorrection.cc();
                assert (lcCorrectionMod != 0L);
                coFactor = coFactor.multiply(gcd.lc());
                gcd = gcd.monic(lcCorrectionMod);
                MultivariateGCD.liftPair(base.clone().multiply(lcCorrection), gcd, coFactor, lcCorrection, coFactorLC, evaluation);
                assert (((MultivariatePolynomialZp64)gcd.lc(0)).equals(lcCorrection));
                gcd = HenselLifting.primitivePart(gcd);
            }
            if (MultivariateGCD.isGCDTriplet(b, a, gcd)) break;
        }
        return evaluations.reconstruct(gcd);
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> void liftPair(Poly base, Poly a, Poly b, Poly aLC, Poly bLC, HenselLifting.IEvaluation<Term, Poly> evaluation) {
        HenselLifting.multivariateLift0(base, (AMultivariatePolynomial[])((AMultivariatePolynomial[])base.createArray(a, b)), (AMultivariatePolynomial[])((AMultivariatePolynomial[])base.createArray(aLC, bLC)), evaluation, (int[])base.degrees());
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> void liftPairAutomaticLC(Poly base, Poly a, Poly b, HenselLifting.IEvaluation<Term, Poly> evaluation) {
        HenselLifting.multivariateLiftAutomaticLC(base, (AMultivariatePolynomial[])((AMultivariatePolynomial[])base.createArray(a, b)), evaluation);
    }

    static ZeroVariables commonPossibleZeroes(MultivariatePolynomialZp64 a, MultivariatePolynomialZp64 b, int nVariables) {
        return MultivariateGCD.commonPossibleZeroes(MultivariateGCD.possibleZeros(a, nVariables), MultivariateGCD.possibleZeros(b, nVariables));
    }

    static ZeroVariables commonPossibleZeroes(ZeroVariables a, ZeroVariables b) {
        if (a.allZeroes) {
            return b;
        }
        if (b.allZeroes) {
            return a;
        }
        ZeroVariables result = new ZeroVariables(a.nVariables);
        for (BitSet az : a.pZeros) {
            for (BitSet bz : b.pZeros) {
                BitSet tmp = (BitSet)az.clone();
                tmp.and(bz);
                result.add(tmp);
            }
        }
        return result;
    }

    static ZeroVariables possibleZeros(MultivariatePolynomialZp64 poly, int nVariables) {
        ZeroVariables result = new ZeroVariables(nVariables);
        if (poly.cc() != 0L) {
            BitSet s = new BitSet(nVariables);
            s.set(0, nVariables);
            result.add(s);
            return result;
        }
        for (MonomialZp64 term : poly) {
            BitSet zeroes = new BitSet(nVariables);
            for (int i = 0; i < nVariables; ++i) {
                if (term.exponents[i] != 0) continue;
                zeroes.set(i);
            }
            result.add(zeroes);
        }
        return result;
    }

    static boolean contains(BitSet major, BitSet minor) {
        if (major.equals(minor)) {
            return true;
        }
        BitSet tmp = (BitSet)major.clone();
        tmp.and(minor);
        return tmp.equals(minor);
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly EEZGCD(Poly a, Poly b) {
        return MultivariateGCD.EEZGCD(a, b, false);
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly EEZGCD(Poly a, Poly b, boolean switchToSparse) {
        a.assertSameCoefficientRingWith(b);
        if (Conversions64bit.canConvertToZp64(a)) {
            return Conversions64bit.convertFromZp64(MultivariateGCD.EEZGCD(Conversions64bit.asOverZp64(a), Conversions64bit.asOverZp64(b)));
        }
        GCDInput<Term, AMultivariatePolynomial> gcdInput = MultivariateGCD.preparedGCDInput(a, b, MultivariateGCD::EEZGCD);
        if (gcdInput.earlyGCD != null) {
            return gcdInput.earlyGCD;
        }
        a = gcdInput.aReduced;
        b = gcdInput.bReduced;
        AMultivariatePolynomial content = (AMultivariatePolynomial)a.createOne();
        for (int i = 0; i < a.nVariables; ++i) {
            if (a.degree(i) == 0 || b.degree(i) == 0) continue;
            AMultivariatePolynomial tmpContent = MultivariateGCD.contentGCD(a, b, i, MultivariateGCD::EEZGCD);
            a = MultivariateDivision.divideExact(a, tmpContent);
            b = MultivariateDivision.divideExact(b, tmpContent);
            content = (AMultivariatePolynomial)content.multiply(tmpContent);
        }
        GCDInput<Term, AMultivariatePolynomial> gcdInput2 = MultivariateGCD.preparedGCDInput(a, b, MultivariateGCD::EEZGCD);
        a = gcdInput2.aReduced;
        b = gcdInput2.bReduced;
        Object result = gcdInput2.earlyGCD != null ? gcdInput2.earlyGCD : (switchToSparse && !MultivariateGCD.isDenseGCDProblem(a, b) ? gcdInput2.restoreGCD(MultivariateGCD.PolynomialGCDinGF(a, b)) : gcdInput2.restoreGCD(MultivariateGCD.EEZGCD0(a, b)));
        result = (AMultivariatePolynomial)((AMultivariatePolynomial)result).multiply((AMultivariatePolynomial)content);
        return (Poly)gcdInput.restoreGCD((AMultivariatePolynomial)result);
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly KaltofenMonaganEEZModularGCDInGF(Poly a, Poly b) {
        if (a instanceof MultivariatePolynomialZp64) {
            return (Poly)MultivariateGCD.KaltofenMonaganEEZModularGCDInGF((MultivariatePolynomialZp64)a, (MultivariatePolynomialZp64)b);
        }
        return (Poly)MultivariateGCD.KaltofenMonaganEEZModularGCDInGF((MultivariatePolynomial)a, (MultivariatePolynomial)b);
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly EEZGCD0(Poly a, Poly b) {
        Poly gcd;
        int ugcdDegree = Integer.MAX_VALUE;
        int uaDegree = a.degree(0);
        int ubDegree = b.degree(0);
        MultivariateFactorization.IEvaluationLoop evaluations = MultivariateFactorization.getEvaluationsGF(a);
        Set<DegreeVector> aSkeleton = a.getSkeleton(0);
        Set<DegreeVector> bSkeleton = b.getSkeleton(0);
        while (true) {
            IUnivariatePolynomial uaCoFactor;
            HenselLifting.IEvaluation evaluation;
            if ((evaluation = evaluations.next()) == null) {
                return MultivariateGCD.KaltofenMonaganEEZModularGCDInGF(a, b);
            }
            Poly mua = evaluation.evaluateFrom(a, 1);
            Poly mub = evaluation.evaluateFrom(b, 1);
            if (!aSkeleton.equals(mua.getSkeleton()) || !bSkeleton.equals(mub.getSkeleton())) continue;
            IUnivariatePolynomial ua = mua.asUnivariate();
            IUnivariatePolynomial ub = mub.asUnivariate();
            assert (ua.degree() == uaDegree);
            assert (ub.degree() == ubDegree);
            IUnivariatePolynomial ugcd = UnivariateGCD.PolynomialGCD(ua, ub);
            if (ugcd.degree() == 0) {
                return (Poly)((AMultivariatePolynomial)a.createOne());
            }
            if (ugcd.degree() > ugcdDegree) continue;
            ugcdDegree = ugcd.degree();
            if (ugcdDegree == uaDegree && MultivariateDivision.dividesQ(b, a)) {
                return a;
            }
            if (ugcdDegree == ubDegree && MultivariateDivision.dividesQ(a, b)) {
                return b;
            }
            AMultivariatePolynomial base = null;
            IUnivariatePolynomial uCoFactor = null;
            Poly coFactorLC = null;
            IUnivariatePolynomial ubCoFactor = UnivariateDivision.quotient(ub, ugcd, true);
            if (UnivariateGCD.PolynomialGCD(ugcd, ubCoFactor).isConstant()) {
                base = b;
                uCoFactor = ubCoFactor;
                coFactorLC = b.lc(0);
            }
            if (base == null && UnivariateGCD.PolynomialGCD(ugcd, uaCoFactor = UnivariateDivision.quotient(ua, ugcd, true)).isConstant()) {
                base = a;
                uCoFactor = uaCoFactor;
                coFactorLC = a.lc(0);
            }
            if (base == null) {
                Poly bRepeatedFactor = MultivariateGCD.EEZGCD(b, b.derivative(0, 1));
                Object squareFreeGCD = MultivariateGCD.EEZGCD(MultivariateDivision.divideExact(b, bRepeatedFactor), a);
                Poly aRepeatedFactor = MultivariateDivision.divideExact(a, squareFreeGCD);
                Object gcd2 = squareFreeGCD.clone();
                IUnivariatePolynomial uSquareFreeGCD = evaluation.evaluateFrom(squareFreeGCD, 1).asUnivariate();
                IUnivariatePolynomial uaRepeatedFactor = evaluation.evaluateFrom(aRepeatedFactor, 1).asUnivariate();
                IUnivariatePolynomial ubRepeatedFactor = evaluation.evaluateFrom(bRepeatedFactor, 1).asUnivariate();
                while (true) {
                    if ((ugcd = UnivariateGCD.PolynomialGCD((IUnivariatePolynomial[])new IUnivariatePolynomial[]{uSquareFreeGCD, uaRepeatedFactor, ubRepeatedFactor})).degree() == 0) {
                        return (Poly)gcd2;
                    }
                    if (!uSquareFreeGCD.clone().monic().equals(ugcd.clone().monic())) {
                        Object mgcd = AMultivariatePolynomial.asMultivariate(ugcd, a.nVariables, 0, a.ordering);
                        Object gcdCoFactor = AMultivariatePolynomial.asMultivariate(UnivariateDivision.divideExact(uSquareFreeGCD, ugcd, false), a.nVariables, 0, a.ordering);
                        MultivariateGCD.liftPairAutomaticLC(squareFreeGCD, mgcd, gcdCoFactor, evaluation);
                        squareFreeGCD = ((AMultivariatePolynomial)mgcd).clone();
                        uSquareFreeGCD = evaluation.evaluateFrom(squareFreeGCD, 1).asUnivariate();
                    }
                    gcd2 = (AMultivariatePolynomial)((AMultivariatePolynomial)gcd2).multiply(squareFreeGCD);
                    uaRepeatedFactor = UnivariateDivision.divideExact(uaRepeatedFactor, ugcd, false);
                    ubRepeatedFactor = UnivariateDivision.divideExact(ubRepeatedFactor, ugcd, false);
                }
            }
            gcd = AMultivariatePolynomial.asMultivariate(ugcd, a.nVariables, 0, a.ordering);
            Object coFactor = AMultivariatePolynomial.asMultivariate(uCoFactor, a.nVariables, 0, a.ordering);
            Poly lcCorrection = MultivariateGCD.EEZGCD(a.lc(0), b.lc(0));
            if (lcCorrection.isOne()) {
                MultivariateGCD.liftPair(base, gcd, coFactor, null, base.lc(0), evaluation);
            } else {
                Poly lcCorrectionMod = evaluation.evaluateFrom(lcCorrection, 1);
                assert (lcCorrectionMod.isConstant());
                coFactor = (AMultivariatePolynomial)coFactor.multiplyByLC(gcd);
                gcd = gcd.monicWithLC(lcCorrectionMod);
                MultivariateGCD.liftPair((AMultivariatePolynomial)((AMultivariatePolynomial)base.clone()).multiply(lcCorrection), gcd, coFactor, lcCorrection, coFactorLC, evaluation);
                assert (((AMultivariatePolynomial)gcd.lc(0)).equals(lcCorrection));
                gcd = HenselLifting.primitivePart(gcd);
            }
            if (MultivariateGCD.isGCDTriplet(b, a, gcd)) break;
        }
        return gcd;
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> boolean isGCDTriplet(Poly a, Poly b, Poly gcd) {
        if (a instanceof MultivariatePolynomial) {
            return MultivariateGCD.isGCDTriplet((MultivariatePolynomial)a, (MultivariatePolynomial)b, (MultivariatePolynomial)gcd);
        }
        return MultivariateGCD.isGCDTriplet((MultivariatePolynomialZp64)a, (MultivariatePolynomialZp64)b, (MultivariatePolynomialZp64)gcd);
    }

    static final class lLinZipSystem
    extends lLinearSystem {
        private final TLongArrayList scalingMatrix = new TLongArrayList();

        public lLinZipSystem(int univarDegree, MultivariatePolynomialZp64 skeleton, MultivariatePolynomialZp64.lPrecomputedPowersHolder powers, int nVars) {
            super(univarDegree, skeleton, powers, nVars);
        }

        public void oneMoreEquation(long rhsVal, boolean newScalingIntroduced) {
            long[] row = new long[this.skeleton.length];
            for (int i = 0; i < this.skeleton.length; ++i) {
                row[i] = MultivariateGCD.evaluateExceptFirst(this.ring, this.powers, 1L, this.skeleton[i], this.matrix.size() + 1, this.nVars);
            }
            this.matrix.add(row);
            if (newScalingIntroduced) {
                this.scalingMatrix.add(this.ring.negate(rhsVal));
                rhsVal = 0L;
            } else {
                this.scalingMatrix.add(0L);
            }
            this.rhs.add(rhsVal);
        }
    }

    private static final class LinZipSystem<E>
    extends LinearSystem<E> {
        private final ArrayList<E> scalingMatrix = new ArrayList();

        public LinZipSystem(int univarDegree, MultivariatePolynomial<E> skeleton, MultivariatePolynomial.PrecomputedPowersHolder<E> powers, int nVars) {
            super(univarDegree, skeleton, powers, nVars);
        }

        public void oneMoreEquation(E rhsVal, boolean newScalingIntroduced) {
            int[] row = this.ring.createArray(this.skeleton.length);
            for (int i = 0; i < this.skeleton.length; ++i) {
                row[i] = (int)MultivariateGCD.evaluateExceptFirst(this.ring, this.powers, this.ring.getOne(), this.skeleton[i], this.matrix.size() + 1, this.nVars);
            }
            this.matrix.add(row);
            if (newScalingIntroduced) {
                this.scalingMatrix.add(this.ring.negate(rhsVal));
                rhsVal = this.ring.getZero();
            } else {
                this.scalingMatrix.add(this.ring.getZero());
            }
            this.rhs.add(rhsVal);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.matrix.size(); ++i) {
                Object[] row = (Object[])this.matrix.get(i);
                for (int j = 0; j < row.length; ++j) {
                    if (j != 0) {
                        sb.append("+");
                    }
                    sb.append(row[j]).append("*c" + j);
                }
                if (i != 0) {
                    sb.append("+").append(this.scalingMatrix.get(i)).append("*m" + (i - 1));
                }
                sb.append("=").append(this.rhs.get(i)).append("\n");
            }
            return sb.toString();
        }
    }

    static final class GCDInput<Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> {
        final Poly aReduced;
        final Poly bReduced;
        final Poly earlyGCD;
        final int[] degreeBounds;
        final int[] mapping;
        final int lastPresentVariable;
        final int evaluationStackLimit;
        final Term monomialGCD;
        final int finiteExtensionDegree;

        GCDInput(Poly earlyGCD) {
            this.earlyGCD = earlyGCD;
            this.bReduced = null;
            this.aReduced = null;
            this.mapping = null;
            this.degreeBounds = null;
            this.evaluationStackLimit = -1;
            this.lastPresentVariable = -1;
            this.monomialGCD = null;
            this.finiteExtensionDegree = -1;
        }

        GCDInput(Poly aReduced, Poly bReduced, Term monomialGCD, int evaluationStackLimit, int[] degreeBounds, int[] mapping, int lastPresentVariable, int finiteExtensionDegree) {
            this.aReduced = aReduced;
            this.bReduced = bReduced;
            this.monomialGCD = monomialGCD;
            this.earlyGCD = null;
            this.evaluationStackLimit = evaluationStackLimit;
            this.degreeBounds = degreeBounds;
            this.mapping = MultivariateGCD.inversePermutation(mapping);
            this.lastPresentVariable = lastPresentVariable;
            this.finiteExtensionDegree = finiteExtensionDegree;
        }

        Poly restoreGCD(Poly result) {
            return ((AMultivariatePolynomial)AMultivariatePolynomial.renameVariables(result, this.mapping)).multiply(this.monomialGCD);
        }
    }

    private static final class UnivariateContent<Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>, uPoly extends IUnivariatePolynomial<uPoly>> {
        final MultivariatePolynomial<uPoly> poly;
        final Poly primitivePart;
        final uPoly content;

        public UnivariateContent(MultivariatePolynomial<uPoly> poly, Poly primitivePart, uPoly content) {
            this.poly = poly;
            this.primitivePart = primitivePart;
            this.content = content;
        }
    }

    private static final class PrimitiveInput<Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>, uPoly extends IUnivariatePolynomial<uPoly>> {
        final Poly aPrimitive;
        final Poly bPrimitive;
        final uPoly contentGCD;
        final uPoly lcGCD;

        PrimitiveInput(Poly aPrimitive, Poly bPrimitive, uPoly contentGCD, uPoly lcGCD) {
            this.aPrimitive = aPrimitive;
            this.bPrimitive = bPrimitive;
            this.contentGCD = contentGCD;
            this.lcGCD = lcGCD;
        }
    }

    static interface lSparseInterpolation {
        public MultivariatePolynomialZp64 evaluate();

        public MultivariatePolynomialZp64 evaluate(long var1);
    }

    private static interface KaltofenMonaganAlgorithm<uPoly extends IUnivariatePolynomial<uPoly>> {
        public MultivariatePolynomial<uPoly> apply(MultivariatePolynomial<uPoly> var1, MultivariatePolynomial<uPoly> var2, int var3, int var4);
    }

    private static final class IrreduciblePolynomialsIterator<uPoly extends IUnivariatePolynomial<uPoly>> {
        final uPoly factory;
        int degree;

        IrreduciblePolynomialsIterator(uPoly factory, int degree) {
            this.factory = factory;
            this.degree = degree;
        }

        uPoly next() {
            return IrreduciblePolynomials.randomIrreduciblePolynomial(this.factory, this.degree++, PrivateRandom.getRandom());
        }
    }

    static interface SparseInterpolation<E> {
        public MultivariatePolynomial<E> evaluate();

        public MultivariatePolynomial<E> evaluate(E var1);
    }

    static final class TrivialSparseInterpolation<E>
    implements SparseInterpolation<E> {
        final MultivariatePolynomial<E> val;

        TrivialSparseInterpolation(MultivariatePolynomial<E> val) {
            this.val = val;
        }

        @Override
        public MultivariatePolynomial<E> evaluate() {
            return this.val;
        }

        @Override
        public MultivariatePolynomial<E> evaluate(E newPoint) {
            return this.val;
        }
    }

    static final class MonicInterpolation<E>
    extends ASparseInterpolation<E> {
        final int requiredNumberOfEvaluations;
        final int monicScalingExponent;

        MonicInterpolation(Ring<E> ring, int variable, MultivariatePolynomial<E> a, MultivariatePolynomial<E> b, Set<DegreeVector> globalSkeleton, TIntObjectHashMap<MultivariatePolynomial<E>> univarSkeleton, int[] sparseUnivarDegrees, int[] evaluationVariables, E[] evaluationPoint, MultivariatePolynomial.PrecomputedPowersHolder<E> powers, int expectedNumberOfEvaluations, RandomGenerator rnd, int requiredNumberOfEvaluations, int monicScalingExponent) {
            super(ring, variable, a, b, globalSkeleton, univarSkeleton, sparseUnivarDegrees, evaluationVariables, evaluationPoint, powers, expectedNumberOfEvaluations, rnd);
            this.requiredNumberOfEvaluations = requiredNumberOfEvaluations;
            this.monicScalingExponent = monicScalingExponent;
        }

        @Override
        public MultivariatePolynomial<E> evaluate0(E newPoint) {
            int i;
            VandermondeSystem[] systems = new VandermondeSystem[this.sparseUnivarDegrees.length];
            for (i = 0; i < this.sparseUnivarDegrees.length; ++i) {
                systems[i] = new VandermondeSystem(this.sparseUnivarDegrees[i], (MultivariatePolynomial)this.univarSkeleton.get(this.sparseUnivarDegrees[i]), this.powers, this.variable == -1 ? this.a.nVariables - 1 : this.variable - 1);
            }
            for (i = 0; i < this.requiredNumberOfEvaluations; ++i) {
                int raiseFactor = i + 1;
                E lastVarValue = newPoint;
                if (this.variable == -1) {
                    lastVarValue = this.ring.pow(lastVarValue, raiseFactor);
                }
                UnivariatePolynomial<E> aUnivar = this.aEvals.evaluate(raiseFactor, lastVarValue);
                UnivariatePolynomial<E> bUnivar = this.bEvals.evaluate(raiseFactor, lastVarValue);
                UnivariatePolynomial<Object> gcdUnivar = UnivariateGCD.PolynomialGCD(aUnivar, bUnivar);
                if (this.a.degree(0) != aUnivar.degree() || this.b.degree(0) != bUnivar.degree()) {
                    return null;
                }
                assert (gcdUnivar.isMonic());
                if (!this.univarSkeleton.keySet().containsAll(gcdUnivar.exponents())) {
                    return null;
                }
                if (this.monicScalingExponent != -1) {
                    if (gcdUnivar.degree() < this.monicScalingExponent || this.ring.isZero(gcdUnivar.get(this.monicScalingExponent))) {
                        return null;
                    }
                    Object normalization = MultivariateGCD.evaluateExceptFirst(this.ring, this.powers, this.ring.getOne(), (Monomial)((MultivariatePolynomial)this.univarSkeleton.get(this.monicScalingExponent)).lt(), i + 1, this.variable == -1 ? this.a.nVariables - 1 : this.variable - 1);
                    normalization = this.ring.multiply(this.ring.reciprocal(gcdUnivar.get(this.monicScalingExponent)), normalization);
                    gcdUnivar = gcdUnivar.multiply(normalization);
                }
                boolean allDone = true;
                for (VandermondeSystem system : systems) {
                    if (system.nEquations() >= system.nUnknownVariables()) continue;
                    Object rhs = gcdUnivar.degree() < system.univarDegree ? this.ring.getZero() : gcdUnivar.get(system.univarDegree);
                    system.oneMoreEquation(rhs);
                    if (system.nEquations() >= system.nUnknownVariables()) continue;
                    allDone = false;
                }
                if (allDone) break;
            }
            for (VandermondeSystem system : systems) {
                LinearSolver.SystemInfo info = system.solve();
                if (info == LinearSolver.SystemInfo.Consistent) continue;
                return null;
            }
            IPolynomial gcdVal = this.a.createZero();
            for (VandermondeSystem system : systems) {
                assert (this.monicScalingExponent == -1 || system.univarDegree != this.monicScalingExponent || this.ring.isOne(system.solution[0]));
                for (int i2 = 0; i2 < system.skeleton.length; ++i2) {
                    Monomial degreeVector = (Monomial)system.skeleton[i2].set(0, system.univarDegree);
                    Object value = system.solution[i2];
                    ((AMultivariatePolynomial)gcdVal).add(degreeVector.setCoefficient(value));
                }
            }
            return gcdVal;
        }
    }

    static final class LinZipInterpolation<E>
    extends ASparseInterpolation<E> {
        LinZipInterpolation(Ring<E> ring, int variable, MultivariatePolynomial<E> a, MultivariatePolynomial<E> b, Set<DegreeVector> globalSkeleton, TIntObjectHashMap<MultivariatePolynomial<E>> univarSkeleton, int[] sparseUnivarDegrees, int[] evaluationVariables, E[] evaluationPoint, MultivariatePolynomial.PrecomputedPowersHolder<E> powers, int expectedNumberOfEvaluations, RandomGenerator rnd) {
            super(ring, variable, a, b, globalSkeleton, univarSkeleton, sparseUnivarDegrees, evaluationVariables, evaluationPoint, powers, expectedNumberOfEvaluations, rnd);
        }

        @Override
        public MultivariatePolynomial<E> evaluate0(E newPoint) {
            LinZipSystem[] systems = new LinZipSystem[this.sparseUnivarDegrees.length];
            for (int i = 0; i < this.sparseUnivarDegrees.length; ++i) {
                systems[i] = new LinZipSystem(this.sparseUnivarDegrees[i], (MultivariatePolynomial)this.univarSkeleton.get(this.sparseUnivarDegrees[i]), this.powers, this.variable == -1 ? this.a.nVariables - 1 : this.variable - 1);
            }
            int nUnknowns = this.globalSkeleton.size();
            int nUnknownScalings = -1;
            int raiseFactor = 0;
            int nUnderDeterminedRetries = this.ring.characteristic().bitLength() <= 13 ? 24 : 8;
            int previousFreeVars = -1;
            int underDeterminedTries = 0;
            boolean lastChanceUsed = false;
            int iTry = 0;
            while (true) {
                if (iTry == nUnderDeterminedRetries) {
                    if (lastChanceUsed) break;
                    lastChanceUsed = true;
                    nUnderDeterminedRetries += MultivariateGCD.nUnderDeterminedLinZip(this.a, systems, nUnknownScalings);
                }
                while (true) {
                    ++nUnknownScalings;
                    ++raiseFactor;
                    E lastVarValue = newPoint;
                    if (this.variable == -1) {
                        lastVarValue = this.ring.pow(lastVarValue, raiseFactor);
                    }
                    UnivariatePolynomial<E> aUnivar = this.aEvals.evaluate(raiseFactor, lastVarValue);
                    UnivariatePolynomial<E> bUnivar = this.bEvals.evaluate(raiseFactor, lastVarValue);
                    UnivariatePolynomial<E> gcdUnivar = UnivariateGCD.PolynomialGCD(aUnivar, bUnivar);
                    if (this.a.degree(0) != aUnivar.degree() || this.b.degree(0) != bUnivar.degree()) {
                        return null;
                    }
                    assert (gcdUnivar.isMonic());
                    if (!this.univarSkeleton.keySet().containsAll(gcdUnivar.exponents())) {
                        return null;
                    }
                    int totalEquations = 0;
                    for (LinZipSystem system : systems) {
                        Object rhs = gcdUnivar.degree() < system.univarDegree ? this.ring.getZero() : gcdUnivar.get(system.univarDegree);
                        system.oneMoreEquation(rhs, nUnknownScalings != 0);
                        totalEquations += system.nEquations();
                    }
                    if (nUnknowns + nUnknownScalings <= totalEquations) break;
                    if (underDeterminedTries > nUnderDeterminedRetries) {
                        return null;
                    }
                    int freeVars = nUnknowns + nUnknownScalings - totalEquations;
                    underDeterminedTries = freeVars >= previousFreeVars ? ++underDeterminedTries : 0;
                    previousFreeVars = freeVars;
                }
                IPolynomial result = this.a.createZero();
                LinearSolver.SystemInfo info = MultivariateGCD.solveLinZip(this.a, systems, nUnknownScalings, (MultivariatePolynomial)result);
                if (info != LinearSolver.SystemInfo.UnderDetermined) {
                    if (info == LinearSolver.SystemInfo.Consistent) {
                        return result;
                    }
                    if (info == LinearSolver.SystemInfo.Inconsistent) {
                        return null;
                    }
                }
                ++iTry;
            }
            return null;
        }
    }

    private static final class FastSparseRecursiveEvaluations<E>
    implements ZippelEvaluations<E> {
        private final MultivariatePolynomial<E> poly;
        private final E[] evaluationPoint;
        private final int variable;
        private final TIntObjectHashMap<MultivariatePolynomial<MultivariatePolynomial<E>>> bivariateCache = new TIntObjectHashMap();

        FastSparseRecursiveEvaluations(MultivariatePolynomial<E> poly, E[] evaluationPoint, int variable) {
            this.poly = poly;
            this.variable = variable;
            this.evaluationPoint = evaluationPoint;
        }

        MultivariatePolynomial<MultivariatePolynomial<E>> getSparseRecursiveForm(int raiseFactor) {
            MultivariatePolynomial recForm = this.bivariateCache.get(raiseFactor);
            if (recForm == null) {
                MultivariatePolynomial<int> bivariate;
                if (this.variable == 1) {
                    bivariate = this.poly;
                } else {
                    int[] values = this.poly.ring.createArray(this.variable - 1);
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = (int)this.poly.ring.pow(this.evaluationPoint[i], raiseFactor);
                    }
                    bivariate = this.poly.evaluate(ArraysUtil.sequence(1, this.variable), (E[])values);
                }
                if (bivariate.nVariables > 2) {
                    bivariate = (MultivariatePolynomial<int>)bivariate.dropSelectVariables(0, this.variable);
                }
                bivariate = AMultivariatePolynomial.swapVariables(bivariate, 0, 1);
                recForm = (MultivariatePolynomial)bivariate.toSparseRecursiveForm();
                this.bivariateCache.put(raiseFactor, recForm);
            }
            return recForm;
        }

        @Override
        public UnivariatePolynomial<E> evaluate(int raiseFactor, E value) {
            MultivariatePolynomial<MultivariatePolynomial<E>> recForm = this.getSparseRecursiveForm(raiseFactor);
            E[] data = this.poly.ring.createZeroesArray(recForm.degree() + 1);
            int cacheSize = 128;
            MultivariatePolynomial.PrecomputedPowersHolder ph = new MultivariatePolynomial.PrecomputedPowersHolder(this.poly.ring, new MultivariatePolynomial.PrecomputedPowers[]{new MultivariatePolynomial.PrecomputedPowers<E>(cacheSize, value, this.poly.ring)});
            for (Monomial monomial : recForm) {
                data[monomial.totalDegree] = MultivariatePolynomial.evaluateSparseRecursiveForm((AMultivariatePolynomial)monomial.coefficient, ph, 0);
            }
            return UnivariatePolynomial.create(this.poly.ring, data);
        }
    }

    private static final class PlainEvaluations<E>
    implements ZippelEvaluations<E> {
        private final MultivariatePolynomial<E> poly;
        private final int[] evaluationVariables;
        private final E[] evaluationPoint;
        private final MultivariatePolynomial.PrecomputedPowersHolder<E> basePowers;
        private final TIntObjectHashMap<MultivariatePolynomial.PrecomputedPowersHolder<E>> powersCache = new TIntObjectHashMap();

        PlainEvaluations(MultivariatePolynomial<E> poly, int[] evaluationVariables, E[] evaluationPoint, MultivariatePolynomial.PrecomputedPowersHolder<E> basePowers) {
            this.poly = poly;
            this.evaluationVariables = evaluationVariables;
            this.evaluationPoint = evaluationPoint;
            this.basePowers = basePowers.clone();
            this.powersCache.put(1, this.basePowers);
        }

        @Override
        public UnivariatePolynomial<E> evaluate(int raiseFactor, E value) {
            this.basePowers.set(this.evaluationVariables[this.evaluationVariables.length - 1], value);
            Object powers = this.powersCache.get(raiseFactor);
            Ring ring = this.poly.ring;
            if (powers == null) {
                powers = this.basePowers.clone();
                for (int i = 0; i < this.evaluationVariables.length - 1; ++i) {
                    ((MultivariatePolynomial.PrecomputedPowersHolder)powers).set(this.evaluationVariables[i], ring.pow(this.evaluationPoint[i], raiseFactor));
                }
                this.powersCache.put(raiseFactor, (MultivariatePolynomial.PrecomputedPowersHolder<E>)powers);
            }
            ((MultivariatePolynomial.PrecomputedPowersHolder)powers).set(this.evaluationVariables[this.evaluationVariables.length - 1], value);
            E[] result = ring.createZeroesArray(this.poly.degree(0) + 1);
            for (Monomial monomial : this.poly) {
                Object ucf = monomial.coefficient;
                for (int variable : this.evaluationVariables) {
                    ucf = ring.multiply(ucf, ((MultivariatePolynomial.PrecomputedPowersHolder)powers).pow(variable, monomial.exponents[variable]));
                }
                int uDeg = monomial.exponents[0];
                result[uDeg] = ring.add(result[uDeg], ucf);
            }
            return UnivariatePolynomial.create(ring, result);
        }
    }

    static final class lTrivialSparseInterpolation
    implements lSparseInterpolation {
        final MultivariatePolynomialZp64 val;

        lTrivialSparseInterpolation(MultivariatePolynomialZp64 val) {
            this.val = val;
        }

        @Override
        public MultivariatePolynomialZp64 evaluate() {
            return this.val;
        }

        @Override
        public MultivariatePolynomialZp64 evaluate(long newPoint) {
            return this.val;
        }
    }

    static final class lMonicInterpolation
    extends lASparseInterpolation {
        final int requiredNumberOfEvaluations;
        final int monicScalingExponent;

        lMonicInterpolation(IntegersZp64 ring, int variable, MultivariatePolynomialZp64 a, MultivariatePolynomialZp64 b, Set<DegreeVector> globalSkeleton, TIntObjectHashMap<MultivariatePolynomialZp64> univarSkeleton, int[] sparseUnivarDegrees, int[] evaluationVariables, long[] evaluationPoint, MultivariatePolynomialZp64.lPrecomputedPowersHolder powers, int expectedNumberOfEvaluations, RandomGenerator rnd, int requiredNumberOfEvaluations, int monicScalingExponent) {
            super(ring, variable, a, b, globalSkeleton, univarSkeleton, sparseUnivarDegrees, evaluationVariables, evaluationPoint, powers, expectedNumberOfEvaluations, rnd);
            this.requiredNumberOfEvaluations = requiredNumberOfEvaluations;
            this.monicScalingExponent = monicScalingExponent;
        }

        @Override
        public MultivariatePolynomialZp64 evaluate0(long newPoint) {
            int i;
            lVandermondeSystem[] systems = new lVandermondeSystem[this.sparseUnivarDegrees.length];
            for (i = 0; i < this.sparseUnivarDegrees.length; ++i) {
                systems[i] = new lVandermondeSystem(this.sparseUnivarDegrees[i], (MultivariatePolynomialZp64)this.univarSkeleton.get(this.sparseUnivarDegrees[i]), this.powers, this.variable == -1 ? this.a.nVariables - 1 : this.variable - 1);
            }
            for (i = 0; i < this.requiredNumberOfEvaluations; ++i) {
                int raiseFactor = i + 1;
                long lastVarValue = newPoint;
                if (this.variable == -1) {
                    lastVarValue = this.ring.powMod(lastVarValue, raiseFactor);
                }
                UnivariatePolynomialZp64 aUnivar = this.aEvals.evaluate(raiseFactor, lastVarValue);
                UnivariatePolynomialZp64 bUnivar = this.bEvals.evaluate(raiseFactor, lastVarValue);
                UnivariatePolynomialZp64 gcdUnivar = UnivariateGCD.PolynomialGCD(aUnivar, bUnivar);
                if (this.a.degree(0) != aUnivar.degree() || this.b.degree(0) != bUnivar.degree()) {
                    return null;
                }
                assert (gcdUnivar.isMonic());
                if (!this.univarSkeleton.keySet().containsAll(gcdUnivar.exponents())) {
                    return null;
                }
                if (this.monicScalingExponent != -1) {
                    if (gcdUnivar.degree() < this.monicScalingExponent || gcdUnivar.get(this.monicScalingExponent) == 0L) {
                        return null;
                    }
                    long normalization = MultivariateGCD.evaluateExceptFirst(this.ring, this.powers, 1L, (MonomialZp64)((MultivariatePolynomialZp64)this.univarSkeleton.get(this.monicScalingExponent)).lt(), i + 1, this.variable == -1 ? this.a.nVariables - 1 : this.variable - 1);
                    normalization = this.ring.multiply(this.ring.reciprocal(gcdUnivar.get(this.monicScalingExponent)), normalization);
                    gcdUnivar = (UnivariatePolynomialZp64)gcdUnivar.multiply(normalization);
                }
                boolean allDone = true;
                for (lVandermondeSystem system : systems) {
                    if (system.nEquations() >= system.nUnknownVariables()) continue;
                    long rhs = gcdUnivar.degree() < system.univarDegree ? 0L : gcdUnivar.get(system.univarDegree);
                    system.oneMoreEquation(rhs);
                    if (system.nEquations() >= system.nUnknownVariables()) continue;
                    allDone = false;
                }
                if (allDone) break;
            }
            for (lVandermondeSystem system : systems) {
                LinearSolver.SystemInfo info = system.solve();
                if (info == LinearSolver.SystemInfo.Consistent) continue;
                return null;
            }
            MultivariatePolynomialZp64 gcdVal = this.a.createZero();
            for (lVandermondeSystem system : systems) {
                assert (this.monicScalingExponent == -1 || system.univarDegree != this.monicScalingExponent || system.solution[0] == 1L);
                for (int i2 = 0; i2 < system.skeleton.length; ++i2) {
                    MonomialZp64 degreeVector = (MonomialZp64)system.skeleton[i2].set(0, system.univarDegree);
                    long value = system.solution[i2];
                    gcdVal.add(degreeVector.setCoefficient(value));
                }
            }
            return gcdVal;
        }
    }

    static final class lLinZipInterpolation
    extends lASparseInterpolation {
        lLinZipInterpolation(IntegersZp64 ring, int variable, MultivariatePolynomialZp64 a, MultivariatePolynomialZp64 b, Set<DegreeVector> globalSkeleton, TIntObjectHashMap<MultivariatePolynomialZp64> univarSkeleton, int[] sparseUnivarDegrees, int[] evaluationVariables, long[] evaluationPoint, MultivariatePolynomialZp64.lPrecomputedPowersHolder powers, int expectedNumberOfEvaluations, RandomGenerator rnd) {
            super(ring, variable, a, b, globalSkeleton, univarSkeleton, sparseUnivarDegrees, evaluationVariables, evaluationPoint, powers, expectedNumberOfEvaluations, rnd);
        }

        @Override
        public MultivariatePolynomialZp64 evaluate0(long newPoint) {
            lLinZipSystem[] systems = new lLinZipSystem[this.sparseUnivarDegrees.length];
            for (int i = 0; i < this.sparseUnivarDegrees.length; ++i) {
                systems[i] = new lLinZipSystem(this.sparseUnivarDegrees[i], (MultivariatePolynomialZp64)this.univarSkeleton.get(this.sparseUnivarDegrees[i]), this.powers, this.variable == -1 ? this.a.nVariables - 1 : this.variable - 1);
            }
            int nUnknowns = this.globalSkeleton.size();
            int nUnknownScalings = -1;
            int raiseFactor = 0;
            int nUnderDeterminedRetries = this.ring.modulus <= 8192L ? 24 : 8;
            int previousFreeVars = -1;
            int underDeterminedTries = 0;
            boolean lastChanceUsed = false;
            int iTry = 0;
            while (true) {
                if (iTry == nUnderDeterminedRetries) {
                    if (lastChanceUsed) break;
                    lastChanceUsed = true;
                    nUnderDeterminedRetries += MultivariateGCD.nUnderDeterminedLinZip(this.a, systems, nUnknownScalings);
                }
                while (true) {
                    ++nUnknownScalings;
                    ++raiseFactor;
                    long lastVarValue = newPoint;
                    if (this.variable == -1) {
                        lastVarValue = this.ring.powMod(lastVarValue, raiseFactor);
                    }
                    UnivariatePolynomialZp64 aUnivar = this.aEvals.evaluate(raiseFactor, lastVarValue);
                    UnivariatePolynomialZp64 bUnivar = this.bEvals.evaluate(raiseFactor, lastVarValue);
                    UnivariatePolynomialZp64 gcdUnivar = UnivariateGCD.PolynomialGCD(aUnivar, bUnivar);
                    if (this.a.degree(0) != aUnivar.degree() || this.b.degree(0) != bUnivar.degree()) {
                        return null;
                    }
                    assert (gcdUnivar.isMonic());
                    if (!this.univarSkeleton.keySet().containsAll(gcdUnivar.exponents())) {
                        return null;
                    }
                    int totalEquations = 0;
                    for (lLinZipSystem system : systems) {
                        long rhs = gcdUnivar.degree() < system.univarDegree ? 0L : gcdUnivar.get(system.univarDegree);
                        system.oneMoreEquation(rhs, nUnknownScalings != 0);
                        totalEquations += system.nEquations();
                    }
                    if (nUnknowns + nUnknownScalings <= totalEquations) break;
                    if (underDeterminedTries > nUnderDeterminedRetries) {
                        return null;
                    }
                    int freeVars = nUnknowns + nUnknownScalings - totalEquations;
                    underDeterminedTries = freeVars >= previousFreeVars ? ++underDeterminedTries : 0;
                    previousFreeVars = freeVars;
                }
                MultivariatePolynomialZp64 result = this.a.createZero();
                LinearSolver.SystemInfo info = MultivariateGCD.solveLinZip(this.a, systems, nUnknownScalings, result);
                if (info != LinearSolver.SystemInfo.UnderDetermined) {
                    if (info == LinearSolver.SystemInfo.Consistent) {
                        return result;
                    }
                    if (info == LinearSolver.SystemInfo.Inconsistent) {
                        return null;
                    }
                }
                ++iTry;
            }
            return null;
        }
    }

    static final class FastSparseRecursiveEvaluationsZp64
    implements ZippelEvaluationsZp64 {
        private final MultivariatePolynomialZp64 poly;
        private final long[] evaluationPoint;
        private final int variable;
        private final TIntObjectHashMap<MultivariatePolynomial<MultivariatePolynomialZp64>> bivariateCache = new TIntObjectHashMap();

        FastSparseRecursiveEvaluationsZp64(MultivariatePolynomialZp64 poly, long[] evaluationPoint, int variable) {
            this.poly = poly;
            this.variable = variable;
            this.evaluationPoint = evaluationPoint;
        }

        MultivariatePolynomial<MultivariatePolynomialZp64> getSparseRecursiveForm(int raiseFactor) {
            MultivariatePolynomial recForm = this.bivariateCache.get(raiseFactor);
            if (recForm == null) {
                MultivariatePolynomialZp64 bivariate;
                if (this.variable == 1) {
                    bivariate = this.poly;
                } else {
                    long[] values = new long[this.variable - 1];
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = this.poly.ring.powMod(this.evaluationPoint[i], raiseFactor);
                    }
                    bivariate = this.poly.evaluate(ArraysUtil.sequence(1, this.variable), values);
                }
                if (bivariate.nVariables > 2) {
                    bivariate = (MultivariatePolynomialZp64)bivariate.dropSelectVariables(0, this.variable);
                }
                bivariate = AMultivariatePolynomial.swapVariables(bivariate, 0, 1);
                recForm = (MultivariatePolynomial)bivariate.toSparseRecursiveForm();
                this.bivariateCache.put(raiseFactor, recForm);
            }
            return recForm;
        }

        @Override
        public UnivariatePolynomialZp64 evaluate(int raiseFactor, long value) {
            MultivariatePolynomial<MultivariatePolynomialZp64> recForm = this.getSparseRecursiveForm(raiseFactor);
            long[] data = new long[recForm.degree() + 1];
            int cacheSize = 128;
            MultivariatePolynomialZp64.lPrecomputedPowersHolder ph = new MultivariatePolynomialZp64.lPrecomputedPowersHolder(this.poly.ring, new MultivariatePolynomialZp64.lPrecomputedPowers[]{new MultivariatePolynomialZp64.lPrecomputedPowers(cacheSize, value, this.poly.ring)});
            for (Monomial monomial : recForm) {
                data[monomial.totalDegree] = MultivariatePolynomialZp64.evaluateSparseRecursiveForm((AMultivariatePolynomial)monomial.coefficient, ph, 0);
            }
            return UnivariatePolynomialZp64.create(this.poly.ring, data);
        }
    }

    static final class PlainEvaluationsZp64
    implements ZippelEvaluationsZp64 {
        private final MultivariatePolynomialZp64 poly;
        private final int[] evaluationVariables;
        private final long[] evaluationPoint;
        private final MultivariatePolynomialZp64.lPrecomputedPowersHolder basePowers;
        private final TIntObjectHashMap<MultivariatePolynomialZp64.lPrecomputedPowersHolder> powersCache = new TIntObjectHashMap();

        PlainEvaluationsZp64(MultivariatePolynomialZp64 poly, int[] evaluationVariables, long[] evaluationPoint, MultivariatePolynomialZp64.lPrecomputedPowersHolder basePowers) {
            this.poly = poly;
            this.evaluationVariables = evaluationVariables;
            this.evaluationPoint = evaluationPoint;
            this.basePowers = basePowers.clone();
            this.powersCache.put(1, this.basePowers);
        }

        @Override
        public UnivariatePolynomialZp64 evaluate(int raiseFactor, long value) {
            this.basePowers.set(this.evaluationVariables[this.evaluationVariables.length - 1], value);
            MultivariatePolynomialZp64.lPrecomputedPowersHolder powers = this.powersCache.get(raiseFactor);
            IntegersZp64 ring = this.poly.ring;
            if (powers == null) {
                powers = this.basePowers.clone();
                for (int i = 0; i < this.evaluationVariables.length - 1; ++i) {
                    powers.set(this.evaluationVariables[i], ring.powMod(this.evaluationPoint[i], raiseFactor));
                }
                this.powersCache.put(raiseFactor, powers);
            }
            powers.set(this.evaluationVariables[this.evaluationVariables.length - 1], value);
            long[] result = new long[this.poly.degree(0) + 1];
            for (MonomialZp64 el : this.poly) {
                long ucf = el.coefficient;
                for (int variable : this.evaluationVariables) {
                    ucf = ring.multiply(ucf, powers.pow(variable, el.exponents[variable]));
                }
                int uDeg = el.exponents[0];
                result[uDeg] = ring.add(result[uDeg], ucf);
            }
            return UnivariatePolynomialZp64.create(ring, result);
        }
    }

    static final class EZGCDEvaluations {
        final MultivariatePolynomialZp64 a;
        final MultivariatePolynomialZp64 b;
        final RandomGenerator rnd;
        final int nVariables;
        final TIntArrayList perfectVariables = new TIntArrayList();
        MultivariatePolynomialZp64 aReduced;
        MultivariatePolynomialZp64 bReduced;
        int currentPerfectVariable = -1;
        int nextPerfectVariable = 0;
        int baseVariable = -1;
        int[] zeroVariables;
        int[] shiftingVariables;
        long[] shifts;
        int nAttemptsWithZeros = 0;
        final TIntHashSet usedBaseVariables = new TIntHashSet();
        int nAttemptsWithSameBaseVariable = 0;

        EZGCDEvaluations(MultivariatePolynomialZp64 a, MultivariatePolynomialZp64 b, int nVariables, RandomGenerator rnd) {
            this.a = a;
            this.b = b;
            this.rnd = rnd;
            this.nVariables = nVariables;
            for (int var = 0; var < nVariables; ++var) {
                UnivariatePolynomialZp64 ua;
                UnivariatePolynomialZp64 ub = b.evaluateAtZeroAllExcept(var);
                if (ub.degree() == 0 || ub.cc() == 0L || ub.degree() != b.degree(var) || (ua = a.evaluateAtZeroAllExcept(var)).degree() == 0 || ua.cc() == 0L || ua.degree() != a.degree(var)) continue;
                this.perfectVariables.add(var);
            }
        }

        boolean nextEvaluation() {
            if (this.nextPerfectVariable < this.perfectVariables.size()) {
                this.currentPerfectVariable = this.perfectVariables.get(this.nextPerfectVariable);
                ++this.nextPerfectVariable;
                this.aReduced = AMultivariatePolynomial.swapVariables(this.a, 0, this.currentPerfectVariable);
                this.bReduced = AMultivariatePolynomial.swapVariables(this.b, 0, this.currentPerfectVariable);
                return true;
            }
            boolean changedMainVariable = false;
            this.currentPerfectVariable = -1;
            int previousBaseVariable = this.baseVariable;
            if (this.baseVariable == -1 || this.nAttemptsWithSameBaseVariable > 8) {
                if (this.usedBaseVariables.size() == this.nVariables) {
                    this.usedBaseVariables.clear();
                }
                this.nAttemptsWithZeros = 0;
                this.nAttemptsWithSameBaseVariable = 0;
                ZeroVariables maxZeros = null;
                for (int var = 0; var < this.nVariables; ++var) {
                    if (this.usedBaseVariables.contains(var) || this.a.degree(var) == 0 || this.b.degree(var) == 0) continue;
                    ZeroVariables pZeros = MultivariateGCD.possibleZeros((MultivariatePolynomialZp64)this.b.coefficientOf(var, 0), this.nVariables);
                    if (maxZeros != null && pZeros.maxPossibleZeros < maxZeros.maxPossibleZeros) continue;
                    pZeros = MultivariateGCD.commonPossibleZeroes(pZeros, MultivariateGCD.possibleZeros((MultivariatePolynomialZp64)this.b.coefficientOf(var, this.b.degree(var)), this.nVariables));
                    if (maxZeros != null && pZeros.maxPossibleZeros < maxZeros.maxPossibleZeros) continue;
                    pZeros = MultivariateGCD.commonPossibleZeroes(pZeros, MultivariateGCD.possibleZeros((MultivariatePolynomialZp64)this.a.coefficientOf(var, 0), this.nVariables));
                    if (maxZeros != null && pZeros.maxPossibleZeros < maxZeros.maxPossibleZeros) continue;
                    pZeros = MultivariateGCD.commonPossibleZeroes(pZeros, MultivariateGCD.possibleZeros((MultivariatePolynomialZp64)this.a.coefficientOf(var, this.a.degree(var)), this.nVariables));
                    if (maxZeros != null && pZeros.maxPossibleZeros < maxZeros.maxPossibleZeros) continue;
                    maxZeros = pZeros;
                    this.baseVariable = var;
                }
                if (maxZeros == null) {
                    this.usedBaseVariables.clear();
                    return this.nextEvaluation();
                }
                this.usedBaseVariables.add(this.baseVariable);
                BitSet zeroSubstitutions = maxZeros.maxZeros();
                zeroSubstitutions.set(this.baseVariable, zeroSubstitutions.get(0));
                zeroSubstitutions.clear(0);
                this.zeroVariables = new int[zeroSubstitutions.cardinality()];
                this.shiftingVariables = new int[this.nVariables - zeroSubstitutions.cardinality() - 1];
                int iCounter = 0;
                int jCounter = 0;
                for (int j = 0; j < this.nVariables; ++j) {
                    if (zeroSubstitutions.get(j)) {
                        this.zeroVariables[iCounter++] = j;
                        continue;
                    }
                    if (j == 0) continue;
                    this.shiftingVariables[jCounter++] = j;
                }
                if (this.shiftingVariables.length == 0) {
                    this.shiftingVariables = new int[]{this.zeroVariables[this.zeroVariables.length - 1]};
                    this.zeroVariables = Arrays.copyOf(this.zeroVariables, this.zeroVariables.length - 1);
                }
                this.shifts = new long[this.shiftingVariables.length];
                changedMainVariable = previousBaseVariable != this.baseVariable;
            }
            this.aReduced = AMultivariatePolynomial.swapVariables(this.a, 0, this.baseVariable);
            this.bReduced = AMultivariatePolynomial.swapVariables(this.b, 0, this.baseVariable);
            if (this.nAttemptsWithZeros > 2 && this.zeroVariables.length != 0) {
                this.shiftingVariables = Arrays.copyOf(this.shiftingVariables, this.shiftingVariables.length + 1);
                this.shiftingVariables[this.shiftingVariables.length - 1] = this.zeroVariables[this.zeroVariables.length - 1];
                this.zeroVariables = Arrays.copyOf(this.zeroVariables, this.zeroVariables.length - 1);
                this.shifts = new long[this.shiftingVariables.length];
                this.nAttemptsWithZeros = 0;
            }
            ++this.nAttemptsWithSameBaseVariable;
            ++this.nAttemptsWithZeros;
            int ubDegree = this.bReduced.degree(0);
            int uaDegree = this.aReduced.degree(0);
            int nFails = 0;
            while (true) {
                UnivariatePolynomialZp64 ua;
                if (nFails > 8) {
                    this.nAttemptsWithSameBaseVariable = 9;
                    return this.nextEvaluation();
                }
                for (int i = 0; i < this.shiftingVariables.length; ++i) {
                    this.shifts[i] = this.a.ring.randomElement(this.rnd);
                }
                UnivariatePolynomialZp64 ub = ((MultivariatePolynomialZp64)this.bReduced.evaluateAtZero(this.zeroVariables)).evaluate(this.shiftingVariables, this.shifts).asUnivariate();
                if (!ub.isZeroAt(0) && !ub.isZeroAt(ubDegree) && !(ua = ((MultivariatePolynomialZp64)this.aReduced.evaluateAtZero(this.zeroVariables)).evaluate(this.shiftingVariables, this.shifts).asUnivariate()).isZeroAt(0) && !ua.isZeroAt(uaDegree)) break;
                ++nFails;
            }
            this.aReduced = this.aReduced.shift(this.shiftingVariables, this.shifts);
            this.bReduced = this.bReduced.shift(this.shiftingVariables, this.shifts);
            return changedMainVariable;
        }

        MultivariatePolynomialZp64 convert(MultivariatePolynomialZp64 poly) {
            if (this.currentPerfectVariable != -1) {
                return this.currentPerfectVariable == 0 ? poly.clone() : MultivariatePolynomialZp64.swapVariables(poly, 0, this.currentPerfectVariable);
            }
            return AMultivariatePolynomial.swapVariables(poly, 0, this.baseVariable).shift(this.shiftingVariables, this.shifts);
        }

        MultivariatePolynomialZp64 reconstruct(MultivariatePolynomialZp64 poly) {
            if (this.currentPerfectVariable != -1) {
                return this.currentPerfectVariable == 0 ? poly : MultivariatePolynomialZp64.swapVariables(poly, 0, this.currentPerfectVariable);
            }
            poly = poly.shift(this.shiftingVariables, ArraysUtil.negate((long[])this.shifts.clone()));
            poly = MultivariatePolynomialZp64.swapVariables(poly, 0, this.baseVariable);
            return poly;
        }
    }

    static final class ZeroVariables {
        final List<BitSet> pZeros = new ArrayList<BitSet>();
        final int nVariables;
        int iMaxPossibleZeros = -1;
        int maxPossibleZeros = -1;
        boolean allZeroes = false;

        public ZeroVariables(int nVariables) {
            this.nVariables = nVariables;
        }

        void add(BitSet zeros) {
            if (this.allZeroes) {
                return;
            }
            int nZeros = zeros.cardinality();
            if (this.nVariables == nZeros) {
                this.maxPossibleZeros = zeros.length();
                this.iMaxPossibleZeros = 0;
                this.allZeroes = true;
                this.pZeros.clear();
                this.pZeros.add(zeros);
                return;
            }
            Iterator<BitSet> it = this.pZeros.iterator();
            while (it.hasNext()) {
                BitSet e = it.next();
                if (MultivariateGCD.contains(e, zeros)) {
                    return;
                }
                if (!MultivariateGCD.contains(zeros, e)) continue;
                it.remove();
            }
            this.pZeros.add(zeros);
            if (nZeros > this.maxPossibleZeros) {
                this.maxPossibleZeros = nZeros;
                this.iMaxPossibleZeros = this.pZeros.size() - 1;
            }
        }

        BitSet maxZeros() {
            return this.pZeros.isEmpty() ? new BitSet(this.nVariables) : this.pZeros.get(this.iMaxPossibleZeros);
        }

        public String toString() {
            return this.pZeros.toString();
        }
    }

    static final class lVandermondeSystem
    extends lLinearSystem {
        long[] solution = null;

        public lVandermondeSystem(int univarDegree, MultivariatePolynomialZp64 skeleton, MultivariatePolynomialZp64.lPrecomputedPowersHolder powers, int nVars) {
            super(univarDegree, skeleton, powers, nVars);
        }

        LinearSolver.SystemInfo solve() {
            if (this.solution == null) {
                this.solution = new long[this.nUnknownVariables()];
            }
            if (this.nUnknownVariables() <= 8) {
                return LinearSolver.solve(this.ring, (long[][])this.matrix.toArray((T[])new long[this.matrix.size()][]), this.rhs.toArray(), this.solution);
            }
            long[] vandermondeRow = (long[])this.matrix.get(0);
            LinearSolver.SystemInfo info = LinearSolver.solveVandermondeT(this.ring, vandermondeRow, this.rhs.toArray(), this.solution);
            if (info == LinearSolver.SystemInfo.Consistent) {
                for (int i = 0; i < this.solution.length; ++i) {
                    this.solution[i] = this.ring.divide(this.solution[i], vandermondeRow[i]);
                }
            }
            return info;
        }

        public lVandermondeSystem oneMoreEquation(long rhsVal) {
            long[] row = new long[this.skeleton.length];
            for (int i = 0; i < this.skeleton.length; ++i) {
                row[i] = MultivariateGCD.evaluateExceptFirst(this.ring, this.powers, 1L, this.skeleton[i], this.matrix.size() + 1, this.nVars);
            }
            this.matrix.add(row);
            this.rhs.add(rhsVal);
            return this;
        }
    }

    static abstract class lLinearSystem {
        final int univarDegree;
        final IntegersZp64 ring;
        final MonomialZp64[] skeleton;
        final ArrayList<long[]> matrix;
        final TLongArrayList rhs = new TLongArrayList();
        final MultivariatePolynomialZp64.lPrecomputedPowersHolder powers;
        final int nVars;

        lLinearSystem(int univarDegree, MultivariatePolynomialZp64 skeleton, MultivariatePolynomialZp64.lPrecomputedPowersHolder powers, int nVars) {
            this.univarDegree = univarDegree;
            this.ring = skeleton.ring;
            this.skeleton = skeleton.getSkeleton().toArray(new MonomialZp64[skeleton.size()]);
            this.powers = powers;
            this.nVars = nVars;
            this.matrix = new ArrayList();
        }

        final int nUnknownVariables() {
            return this.skeleton.length;
        }

        final int nEquations() {
            return this.matrix.size();
        }

        public String toString() {
            return "{" + this.matrix.stream().map(Arrays::toString).collect(Collectors.joining(",")) + "} = " + this.rhs;
        }
    }

    static interface ZippelEvaluationsZp64 {
        public UnivariatePolynomialZp64 evaluate(int var1, long var2);
    }

    static abstract class lASparseInterpolation
    implements lSparseInterpolation {
        final IntegersZp64 ring;
        final int variable;
        final MultivariatePolynomialZp64 a;
        final MultivariatePolynomialZp64 b;
        final Set<DegreeVector> globalSkeleton;
        final TIntObjectHashMap<MultivariatePolynomialZp64> univarSkeleton;
        final int[] sparseUnivarDegrees;
        final int[] evaluationVariables;
        final long[] evaluationPoint;
        final MultivariatePolynomialZp64.lPrecomputedPowersHolder powers;
        final ZippelEvaluationsZp64 aEvals;
        final ZippelEvaluationsZp64 bEvals;
        final RandomGenerator rnd;

        lASparseInterpolation(IntegersZp64 ring, int variable, MultivariatePolynomialZp64 a, MultivariatePolynomialZp64 b, Set<DegreeVector> globalSkeleton, TIntObjectHashMap<MultivariatePolynomialZp64> univarSkeleton, int[] sparseUnivarDegrees, int[] evaluationVariables, long[] evaluationPoint, MultivariatePolynomialZp64.lPrecomputedPowersHolder powers, int expectedNumberOfEvaluations, RandomGenerator rnd) {
            this.ring = ring;
            this.variable = variable;
            this.a = a;
            this.b = b;
            this.globalSkeleton = globalSkeleton;
            this.univarSkeleton = univarSkeleton;
            this.sparseUnivarDegrees = sparseUnivarDegrees;
            this.evaluationPoint = evaluationPoint;
            this.aEvals = MultivariateGCD.createEvaluations(a, evaluationVariables, evaluationPoint, powers, expectedNumberOfEvaluations);
            this.bEvals = MultivariateGCD.createEvaluations(b, evaluationVariables, evaluationPoint, powers, expectedNumberOfEvaluations);
            this.evaluationVariables = evaluationVariables;
            this.powers = powers;
            this.rnd = rnd;
        }

        @Override
        public final MultivariatePolynomialZp64 evaluate() {
            return this.evaluate(this.evaluationPoint[this.evaluationPoint.length - 1]);
        }

        @Override
        public final MultivariatePolynomialZp64 evaluate(long newPoint) {
            if (this.globalSkeleton.size() == 1) {
                return (MultivariatePolynomialZp64)this.a.create(((MonomialZp64)this.globalSkeleton.iterator().next()).setCoefficient(1L));
            }
            this.evaluationPoint[this.evaluationPoint.length - 1] = newPoint;
            this.powers.set(this.evaluationVariables[this.evaluationVariables.length - 1], newPoint);
            return this.evaluate0(newPoint);
        }

        abstract MultivariatePolynomialZp64 evaluate0(long var1);
    }

    static final class VandermondeSystem<E>
    extends LinearSystem<E> {
        E[] solution = null;

        public VandermondeSystem(int univarDegree, MultivariatePolynomial<E> skeleton, MultivariatePolynomial.PrecomputedPowersHolder<E> powers, int nVars) {
            super(univarDegree, skeleton, powers, nVars);
        }

        LinearSolver.SystemInfo solve() {
            if (this.solution == null) {
                this.solution = this.ring.createArray(this.nUnknownVariables());
            }
            if (this.nUnknownVariables() <= 8) {
                return LinearSolver.solve(this.ring, (Object[][])this.matrix.toArray((T[])this.ring.createArray2d(this.matrix.size())), this.rhs.toArray(this.ring.createArray(this.rhs.size())), this.solution);
            }
            Object[] vandermondeRow = (Object[])this.matrix.get(0);
            LinearSolver.SystemInfo info = LinearSolver.solveVandermondeT(this.ring, vandermondeRow, this.rhs.toArray(this.ring.createArray(this.rhs.size())), this.solution);
            if (info == LinearSolver.SystemInfo.Consistent) {
                for (int i = 0; i < this.solution.length; ++i) {
                    this.solution[i] = this.ring.divideExact(this.solution[i], vandermondeRow[i]);
                }
            }
            return info;
        }

        public VandermondeSystem<E> oneMoreEquation(E rhsVal) {
            int[] row = this.ring.createArray(this.skeleton.length);
            for (int i = 0; i < this.skeleton.length; ++i) {
                row[i] = (int)MultivariateGCD.evaluateExceptFirst(this.ring, this.powers, this.ring.getOne(), this.skeleton[i], this.matrix.size() + 1, this.nVars);
            }
            this.matrix.add(row);
            this.rhs.add(rhsVal);
            return this;
        }
    }

    private static abstract class LinearSystem<E> {
        final int univarDegree;
        final Ring<E> ring;
        final Monomial<E>[] skeleton;
        final ArrayList<E[]> matrix;
        final ArrayList<E> rhs = new ArrayList();
        final MultivariatePolynomial.PrecomputedPowersHolder<E> powers;
        final int nVars;

        LinearSystem(int univarDegree, MultivariatePolynomial<E> skeleton, MultivariatePolynomial.PrecomputedPowersHolder<E> powers, int nVars) {
            this.univarDegree = univarDegree;
            this.ring = skeleton.ring;
            this.skeleton = skeleton.getSkeleton().toArray(new Monomial[skeleton.size()]);
            this.powers = powers;
            this.nVars = nVars;
            this.matrix = new ArrayList();
        }

        final int nUnknownVariables() {
            return this.skeleton.length;
        }

        final int nEquations() {
            return this.matrix.size();
        }

        public String toString() {
            return "{" + this.matrix.stream().map(Arrays::toString).collect(Collectors.joining(",")) + "} = " + this.rhs;
        }
    }

    static interface ZippelEvaluations<E> {
        public UnivariatePolynomial<E> evaluate(int var1, E var2);
    }

    static abstract class ASparseInterpolation<E>
    implements SparseInterpolation<E> {
        final Ring<E> ring;
        final int variable;
        final MultivariatePolynomial<E> a;
        final MultivariatePolynomial<E> b;
        final Set<DegreeVector> globalSkeleton;
        final TIntObjectHashMap<MultivariatePolynomial<E>> univarSkeleton;
        final int[] sparseUnivarDegrees;
        final int[] evaluationVariables;
        final E[] evaluationPoint;
        final MultivariatePolynomial.PrecomputedPowersHolder<E> powers;
        final ZippelEvaluations<E> aEvals;
        final ZippelEvaluations<E> bEvals;
        final RandomGenerator rnd;

        ASparseInterpolation(Ring<E> ring, int variable, MultivariatePolynomial<E> a, MultivariatePolynomial<E> b, Set<DegreeVector> globalSkeleton, TIntObjectHashMap<MultivariatePolynomial<E>> univarSkeleton, int[] sparseUnivarDegrees, int[] evaluationVariables, E[] evaluationPoint, MultivariatePolynomial.PrecomputedPowersHolder<E> powers, int expectedNumberOfEvaluations, RandomGenerator rnd) {
            this.ring = ring;
            this.variable = variable;
            this.a = a;
            this.b = b;
            this.globalSkeleton = globalSkeleton;
            this.univarSkeleton = univarSkeleton;
            this.sparseUnivarDegrees = sparseUnivarDegrees;
            this.evaluationVariables = evaluationVariables;
            this.evaluationPoint = evaluationPoint;
            this.aEvals = MultivariateGCD.createEvaluations(a, evaluationVariables, evaluationPoint, powers, expectedNumberOfEvaluations);
            this.bEvals = MultivariateGCD.createEvaluations(b, evaluationVariables, evaluationPoint, powers, expectedNumberOfEvaluations);
            this.powers = powers;
            this.rnd = rnd;
        }

        @Override
        public final MultivariatePolynomial<E> evaluate() {
            return this.evaluate(this.evaluationPoint[this.evaluationPoint.length - 1]);
        }

        @Override
        public final MultivariatePolynomial<E> evaluate(E newPoint) {
            if (this.globalSkeleton.size() == 1) {
                return (MultivariatePolynomial)this.a.create(((Monomial)this.globalSkeleton.iterator().next()).setCoefficient(this.ring.getOne()));
            }
            this.evaluationPoint[this.evaluationPoint.length - 1] = newPoint;
            this.powers.set(this.evaluationVariables[this.evaluationVariables.length - 1], newPoint);
            return this.evaluate0(newPoint);
        }

        abstract MultivariatePolynomial<E> evaluate0(E var1);
    }
}

