/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.multivar;

import cc.redberry.rings.ChineseRemainders;
import cc.redberry.rings.Integers;
import cc.redberry.rings.IntegersZp;
import cc.redberry.rings.IntegersZp64;
import cc.redberry.rings.Rational;
import cc.redberry.rings.Ring;
import cc.redberry.rings.Rings;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.linear.LinearSolver;
import cc.redberry.rings.poly.AlgebraicNumberField;
import cc.redberry.rings.poly.FiniteField;
import cc.redberry.rings.poly.IPolynomial;
import cc.redberry.rings.poly.MachineArithmetic;
import cc.redberry.rings.poly.MultipleFieldExtension;
import cc.redberry.rings.poly.MultivariateRing;
import cc.redberry.rings.poly.PolynomialMethods;
import cc.redberry.rings.poly.SimpleFieldExtension;
import cc.redberry.rings.poly.UnivariateRing;
import cc.redberry.rings.poly.Util;
import cc.redberry.rings.poly.multivar.AMonomial;
import cc.redberry.rings.poly.multivar.AMultivariatePolynomial;
import cc.redberry.rings.poly.multivar.Conversions64bit;
import cc.redberry.rings.poly.multivar.DegreeVector;
import cc.redberry.rings.poly.multivar.Monomial;
import cc.redberry.rings.poly.multivar.MonomialZp64;
import cc.redberry.rings.poly.multivar.MultivariateDivision;
import cc.redberry.rings.poly.multivar.MultivariateGCD;
import cc.redberry.rings.poly.multivar.MultivariateInterpolation;
import cc.redberry.rings.poly.multivar.MultivariatePolynomial;
import cc.redberry.rings.poly.multivar.MultivariatePolynomialZp64;
import cc.redberry.rings.poly.multivar.PairedIterator;
import cc.redberry.rings.poly.multivar.PrivateRandom;
import cc.redberry.rings.poly.univar.IUnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariateGCD;
import cc.redberry.rings.poly.univar.UnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariatePolynomialZp64;
import cc.redberry.rings.poly.univar.UnivariateResultants;
import cc.redberry.rings.primes.PrimesIterator;
import cc.redberry.rings.util.ArraysUtil;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.hash.TLongHashSet;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import java.util.stream.Stream;
import org.apache.commons.math3.random.RandomGenerator;

public final class MultivariateResultants {
    private static final int N_UNCHANGED_INTERPOLATIONS = 5;

    private MultivariateResultants() {
    }

    public static <Poly extends AMultivariatePolynomial> Poly Discriminant(Poly a, int variable) {
        Poly disc = MultivariateDivision.divideExact(MultivariateResultants.Resultant(a, a.derivative(variable), variable), a.lc(variable));
        return (Poly)(a.degree(variable) * (a.degree(variable) - 1) / 2 % 2 == 1 ? disc.negate() : disc);
    }

    public static <Poly extends AMultivariatePolynomial> Poly Resultant(Poly a, Poly b, int variable) {
        a.assertSameCoefficientRingWith(b);
        if (a.isOverFiniteField()) {
            return MultivariateResultants.ResultantInGF(a, b, variable);
        }
        if (a.isOverZ()) {
            return (Poly)MultivariateResultants.ResultantInZ((MultivariatePolynomial)a, (MultivariatePolynomial)b, variable);
        }
        if (Util.isOverRationals(a)) {
            return (Poly)MultivariateResultants.ResultantInQ((MultivariatePolynomial)a, (MultivariatePolynomial)b, variable);
        }
        if (Util.isOverSimpleNumberField(a)) {
            return (Poly)MultivariateResultants.ModularResultantInNumberField((MultivariatePolynomial)a, (MultivariatePolynomial)b, variable);
        }
        if (Util.isOverRingOfIntegersOfSimpleNumberField(a)) {
            return (Poly)MultivariateResultants.ModularResultantInRingOfIntegersOfNumberField((MultivariatePolynomial)a, (MultivariatePolynomial)b, variable);
        }
        if (Util.isOverMultipleFieldExtension(a)) {
            return (Poly)MultivariateResultants.ResultantInMultipleFieldExtension((MultivariatePolynomial)a, (MultivariatePolynomial)b, variable);
        }
        if (a.isOverField()) {
            return (Poly)MultivariateResultants.ZippelResultant((MultivariatePolynomial)a, (MultivariatePolynomial)b, variable);
        }
        return MultivariateResultants.tryNested(a, b, variable);
    }

    private static <Poly extends AMultivariatePolynomial> Poly tryNested(Poly a, Poly b, int variable) {
        if (MultivariateGCD.isOverUnivariate(a)) {
            return (Poly)MultivariateResultants.ResultantOverUnivariate((MultivariatePolynomial)a, (MultivariatePolynomial)b, variable);
        }
        if (MultivariateGCD.isOverUnivariateZp64(a)) {
            return (Poly)MultivariateResultants.ResultantOverUnivariateZp64((MultivariatePolynomial)a, (MultivariatePolynomial)b, variable);
        }
        if (MultivariateGCD.isOverMultivariate(a)) {
            return (Poly)MultivariateResultants.ResultantOverMultivariate((MultivariatePolynomial)a, (MultivariatePolynomial)b, variable);
        }
        if (MultivariateGCD.isOverMultivariateZp64(a)) {
            return (Poly)MultivariateResultants.ResultantOverMultivariateZp64((MultivariatePolynomial)a, (MultivariatePolynomial)b, variable);
        }
        return MultivariateResultants.ClassicalResultant(a, b, variable);
    }

    private static <E> MultivariatePolynomial<UnivariatePolynomial<E>> ResultantOverUnivariate(MultivariatePolynomial<UnivariatePolynomial<E>> a, MultivariatePolynomial<UnivariatePolynomial<E>> b, int variable) {
        return MultivariateResultants.Resultant(MultivariatePolynomial.asNormalMultivariate(a, 0), MultivariatePolynomial.asNormalMultivariate(b, 0), 1 + variable).asOverUnivariateEliminate(0);
    }

    private static <E> MultivariatePolynomial<MultivariatePolynomial<E>> ResultantOverMultivariate(MultivariatePolynomial<MultivariatePolynomial<E>> a, MultivariatePolynomial<MultivariatePolynomial<E>> b, int variable) {
        int[] cfVars = ArraysUtil.sequence(a.lc().nVariables);
        int[] mainVars = ArraysUtil.sequence(a.lc().nVariables, a.lc().nVariables + a.nVariables);
        return MultivariateResultants.Resultant(MultivariatePolynomial.asNormalMultivariate(a, cfVars, mainVars), MultivariatePolynomial.asNormalMultivariate(b, cfVars, mainVars), cfVars.length + variable).asOverMultivariateEliminate(cfVars);
    }

    private static MultivariatePolynomial<UnivariatePolynomialZp64> ResultantOverUnivariateZp64(MultivariatePolynomial<UnivariatePolynomialZp64> a, MultivariatePolynomial<UnivariatePolynomialZp64> b, int variable) {
        return MultivariateResultants.Resultant(MultivariatePolynomialZp64.asNormalMultivariate(a, 0), MultivariatePolynomialZp64.asNormalMultivariate(b, 0), 1 + variable).asOverUnivariateEliminate(0);
    }

    private static MultivariatePolynomial<MultivariatePolynomialZp64> ResultantOverMultivariateZp64(MultivariatePolynomial<MultivariatePolynomialZp64> a, MultivariatePolynomial<MultivariatePolynomialZp64> b, int variable) {
        int[] cfVars = ArraysUtil.sequence(a.lc().nVariables);
        int[] mainVars = ArraysUtil.sequence(a.lc().nVariables, a.lc().nVariables + a.nVariables);
        return MultivariateResultants.Resultant(MultivariatePolynomialZp64.asNormalMultivariate(a, cfVars, mainVars), MultivariatePolynomialZp64.asNormalMultivariate(b, cfVars, mainVars), cfVars.length + variable).asOverMultivariateEliminate(cfVars);
    }

    static <E> MultivariatePolynomial<Rational<E>> ResultantInQ(MultivariatePolynomial<Rational<E>> a, MultivariatePolynomial<Rational<E>> b, int variable) {
        Util.Tuple2<MultivariatePolynomial<E>, E> aRat = Util.toCommonDenominator(a);
        Util.Tuple2<MultivariatePolynomial<E>, E> bRat = Util.toCommonDenominator(b);
        Ring<Object> ring = ((MultivariatePolynomial)aRat._1).ring;
        Object correction = ring.multiply(ring.pow(aRat._2, b.degree(variable)), ring.pow(bRat._2, a.degree(variable)));
        return Util.asOverRationals(a.ring, MultivariateResultants.Resultant((MultivariatePolynomial)aRat._1, (MultivariatePolynomial)bRat._1, variable)).divideExact(new Rational(ring, correction));
    }

    private static <Term extends AMonomial<Term>, mPoly extends AMultivariatePolynomial<Term, mPoly>, sPoly extends IUnivariatePolynomial<sPoly>> MultivariatePolynomial<mPoly> ResultantInMultipleFieldExtension(MultivariatePolynomial<mPoly> a, MultivariatePolynomial<mPoly> b, int variable) {
        MultipleFieldExtension ring = (MultipleFieldExtension)a.ring;
        SimpleFieldExtension simpleExtension = ring.getSimpleExtension();
        return MultivariateResultants.Resultant(a.mapCoefficients(simpleExtension, ring::inverse), b.mapCoefficients(simpleExtension, ring::inverse), variable).mapCoefficients(ring, ring::image);
    }

    public static <Poly extends AMultivariatePolynomial> Poly ResultantInGF(Poly a, Poly b, int variable) {
        return MultivariateResultants.ZippelResultant(a, b, variable);
    }

    public static MultivariatePolynomial<BigInteger> ResultantInZ(MultivariatePolynomial<BigInteger> a, MultivariatePolynomial<BigInteger> b, int variable) {
        return MultivariateResultants.ModularResultantInZ(a, b, variable);
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly ClassicalResultant(Poly a, Poly b, int variable) {
        if (Conversions64bit.canConvertToZp64(a)) {
            return Conversions64bit.convertFromZp64(MultivariateResultants.ClassicalResultant(Conversions64bit.asOverZp64(a), Conversions64bit.asOverZp64(b), variable));
        }
        return ((AMultivariatePolynomial)UnivariateResultants.Resultant(a.asUnivariateEliminate(variable), b.asUnivariateEliminate(variable))).insertVariable(variable);
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> ResultantInput<Term, Poly> preparedResultantInput(Poly a, Poly b, int variable) {
        int lastResVariable;
        Object trivialResultant = MultivariateResultants.trivialResultant(a, b, variable);
        if (trivialResultant != null) {
            return new ResultantInput(trivialResultant);
        }
        BigInteger ringSize = a.coefficientRingCardinality();
        int evaluationStackLimit = ringSize == null ? -1 : (ringSize.isInt() ? ringSize.intValue() : -1);
        a = ((AMultivariatePolynomial)a).clone();
        b = ((AMultivariatePolynomial)b).clone();
        Object aContent = ((AMultivariatePolynomial)a).monomialContent();
        Object bContent = ((AMultivariatePolynomial)b).monomialContent();
        a = ((AMultivariatePolynomial)a).divideOrNull(aContent);
        b = ((AMultivariatePolynomial)b).divideOrNull(bContent);
        if (((AMonomial)aContent).exponents[variable] != 0 && ((AMonomial)bContent).exponents[variable] != 0) {
            return new ResultantInput((AMultivariatePolynomial)a.createZero());
        }
        AMultivariatePolynomial monomialResultant = (AMultivariatePolynomial)((AMultivariatePolynomial)((AMultivariatePolynomial)MultivariateResultants.resultantWithMonomial(aContent, ((AMultivariatePolynomial)b).create(bContent), variable)).multiply(MultivariateResultants.resultantWithMonomial(aContent, b, variable))).multiply(MultivariateResultants.resultantWithMonomial(a, bContent, variable));
        trivialResultant = MultivariateResultants.trivialResultant(a, b, variable);
        if (trivialResultant != null) {
            return new ResultantInput((AMultivariatePolynomial)trivialResultant.multiply((AMultivariatePolynomial)monomialResultant));
        }
        int nVariables = ((AMultivariatePolynomial)a).nVariables;
        int[] aDegrees = ((AMultivariatePolynomial)a).degreesRef();
        int[] bDegrees = ((AMultivariatePolynomial)b).degreesRef();
        int[] degreeBounds = new int[nVariables];
        degreeBounds[variable] = Integer.MAX_VALUE;
        int nUnused = 0;
        for (int i = 0; i < nVariables; ++i) {
            if (i == variable) continue;
            degreeBounds[i] = MachineArithmetic.safeToInt(MachineArithmetic.safeAdd(MachineArithmetic.safeMultiply(aDegrees[i], bDegrees[variable]), MachineArithmetic.safeMultiply(bDegrees[i], aDegrees[variable])));
            if (degreeBounds[i] != 0) continue;
            ++nUnused;
        }
        if (nUnused == nVariables - 1) {
            Object t = MultivariateResultants.trivialResultant(a, b, variable);
            assert (t != null);
            return new ResultantInput((AMultivariatePolynomial)((AMultivariatePolynomial)t).multiply(monomialResultant));
        }
        MultivariateResultants.adjustDegreeBounds(a, b, variable, degreeBounds);
        int[] variables = ArraysUtil.sequence(nVariables);
        ArraysUtil.quickSort(ArraysUtil.negate(degreeBounds), variables);
        ArraysUtil.negate(degreeBounds);
        degreeBounds = Arrays.copyOfRange(degreeBounds, 1, degreeBounds.length);
        for (lastResVariable = 0; lastResVariable < degreeBounds.length && degreeBounds[lastResVariable] != 0; ++lastResVariable) {
        }
        --lastResVariable;
        a = AMultivariatePolynomial.renameVariables(a, variables);
        b = AMultivariatePolynomial.renameVariables(b, variables);
        int finiteExtensionDegree = 1;
        int cardinalityBound = MachineArithmetic.safeToInt(MachineArithmetic.safeMultiply(9L, ArraysUtil.max(degreeBounds)));
        if (ringSize != null && ringSize.isInt() && ringSize.intValueExact() < cardinalityBound) {
            long ds = ringSize.intValueExact();
            finiteExtensionDegree = 2;
            long tmp = ds;
            while (tmp < (long)cardinalityBound) {
                tmp *= ds;
                ++finiteExtensionDegree;
            }
        }
        return new ResultantInput((AMultivariatePolynomial)a, (AMultivariatePolynomial)b, monomialResultant, evaluationStackLimit, degreeBounds, variables, lastResVariable, finiteExtensionDegree);
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> void adjustDegreeBounds(Poly a, Poly b, int variable, int[] degreeBounds) {
        if (!a.isOverFiniteField()) {
            return;
        }
        if (a.coefficientRingCharacteristic().bitLength() < 16) {
            return;
        }
        if (a instanceof MultivariatePolynomialZp64) {
            MultivariateResultants.adjustDegreeBounds((MultivariatePolynomialZp64)a, (MultivariatePolynomialZp64)b, variable, degreeBounds);
        } else {
            MultivariateResultants.adjustDegreeBounds((MultivariatePolynomial)a, (MultivariatePolynomial)b, variable, degreeBounds);
        }
    }

    private static void adjustDegreeBounds(MultivariatePolynomialZp64 a, MultivariatePolynomialZp64 b, int variable, int[] degreeBounds) {
        int i;
        int nVariables = a.nVariables;
        long[] subs = new long[nVariables];
        RandomGenerator rnd = PrivateRandom.getRandom();
        for (i = 0; i < nVariables; ++i) {
            if (i == variable) continue;
            subs[i] = a.ring.randomNonZeroElement(rnd);
        }
        for (i = 0; i < nVariables; ++i) {
            if (i == variable) continue;
            int[] vars = ArraysUtil.remove(ArraysUtil.sequence(0, a.nVariables), new int[]{i, variable});
            long[] vals = ArraysUtil.remove(subs, new int[]{i, variable});
            MultivariatePolynomialZp64 mua = a.evaluate(vars, vals);
            MultivariatePolynomialZp64 mub = b.evaluate(vars, vals);
            if (!mua.getSkeleton().equals(a.getSkeleton(variable, i))) continue;
            if (!mub.getSkeleton().equals(b.getSkeleton(variable, i))) continue;
            IUnivariatePolynomial ua = mua.asOverUnivariateEliminate(i).asUnivariate();
            IUnivariatePolynomial ub = mub.asOverUnivariateEliminate(i).asUnivariate();
            degreeBounds[i] = Math.min(degreeBounds[i], ((UnivariatePolynomialZp64)UnivariateResultants.Resultant(ua, ub)).degree());
        }
    }

    private static <E> void adjustDegreeBounds(MultivariatePolynomial<E> a, MultivariatePolynomial<E> b, int variable, int[] degreeBounds) {
        int i;
        int nVariables = a.nVariables;
        int[] subs = a.ring.createArray(nVariables);
        RandomGenerator rnd = PrivateRandom.getRandom();
        for (i = 0; i < nVariables; ++i) {
            if (i == variable) continue;
            subs[i] = (int)a.ring.randomNonZeroElement(rnd);
        }
        for (i = 0; i < nVariables; ++i) {
            if (i == variable) continue;
            int[] vars = ArraysUtil.remove(ArraysUtil.sequence(0, a.nVariables), new int[]{i, variable});
            int[] vals = ArraysUtil.remove(subs, new int[]{i, variable});
            MultivariatePolynomial<int> mua = a.evaluate(vars, (E[])vals);
            MultivariatePolynomial<int> mub = b.evaluate(vars, (E[])vals);
            if (!mua.getSkeleton().equals(a.getSkeleton(variable, i))) continue;
            if (!mub.getSkeleton().equals(b.getSkeleton(variable, i))) continue;
            IUnivariatePolynomial ua = mua.asOverUnivariateEliminate(i).asUnivariate();
            IUnivariatePolynomial ub = mub.asOverUnivariateEliminate(i).asUnivariate();
            degreeBounds[i] = Math.min(degreeBounds[i], ((UnivariatePolynomial)UnivariateResultants.Resultant(ua, ub)).degree());
        }
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly trivialResultant(Poly a, Poly b, int variable) {
        if (a == b || a.isZero() || b.isZero() || a.equals(b)) {
            return (Poly)((AMultivariatePolynomial)a.createZero());
        }
        if (a.degree(variable) == 0) {
            return PolynomialMethods.polyPow(a, b.degree(variable));
        }
        if (b.degree(variable) == 0) {
            return PolynomialMethods.polyPow(b, a.degree(variable));
        }
        if (a.size() == 1) {
            return (Poly)MultivariateResultants.resultantWithMonomial(a.lt(), b, variable);
        }
        if (b.size() == 1) {
            return MultivariateResultants.resultantWithMonomial(a, b.lt(), variable);
        }
        if (a.univariateVariable() == variable && b.univariateVariable() == variable) {
            return AMultivariatePolynomial.asMultivariate(UnivariateResultants.ResultantAsPoly(a.asUnivariate(), b.asUnivariate()), a.nVariables, variable, a.ordering);
        }
        return null;
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly resultantWithMonomial(Term monomial, Poly poly, int variable) {
        int varExponent = monomial.exponents[variable];
        AMultivariatePolynomial cFactor = (AMultivariatePolynomial)PolynomialMethods.polyPow(poly.create(monomial.set(variable, 0)), poly.degree(variable));
        AMultivariatePolynomial xFactor = (AMultivariatePolynomial)PolynomialMethods.polyPow(poly.evaluateAtZero(variable), varExponent);
        return (Poly)((AMultivariatePolynomial)cFactor.multiply(xFactor));
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly resultantWithMonomial(Poly poly, Term monomial, int variable) {
        Term r = MultivariateResultants.resultantWithMonomial(monomial, poly, variable);
        if (poly.degree(variable) % 2 == 1 && monomial.exponents[variable] % 2 == 1) {
            ((AMultivariatePolynomial)((Object)r)).negate();
        }
        return (Poly)r;
    }

    static MultivariatePolynomialZp64 bivariateResultantZp64(UnivariatePolynomial<MultivariatePolynomialZp64> a, UnivariatePolynomial<MultivariatePolynomialZp64> b) {
        MultivariatePolynomialZp64 factory = a.lc();
        IntegersZp64 ring = factory.ring;
        UnivariateRing<UnivariatePolynomialZp64> uRing = Rings.UnivariateRingZp64(ring);
        UnivariatePolynomial<UnivariatePolynomialZp64> aUni = a.mapCoefficients(uRing, MultivariatePolynomialZp64::asUnivariate);
        UnivariatePolynomial<UnivariatePolynomialZp64> bUni = b.mapCoefficients(uRing, MultivariatePolynomialZp64::asUnivariate);
        return (MultivariatePolynomialZp64)UnivariateResultants.Resultant(aUni, bUni).asMultivariate(factory.ordering).setNVariables(factory.nVariables);
    }

    static <E> MultivariatePolynomial<E> bivariateResultantE(UnivariatePolynomial<MultivariatePolynomial<E>> a, UnivariatePolynomial<MultivariatePolynomial<E>> b) {
        MultivariatePolynomial<E> factory = a.lc();
        Ring ring = factory.ring;
        UnivariateRing uRing = Rings.UnivariateRing(ring);
        UnivariatePolynomial<UnivariatePolynomial> aUni = a.mapCoefficients(uRing, MultivariatePolynomial::asUnivariate);
        UnivariatePolynomial<UnivariatePolynomial> bUni = b.mapCoefficients(uRing, MultivariatePolynomial::asUnivariate);
        return (MultivariatePolynomial)UnivariateResultants.Resultant(aUni, bUni).asMultivariate(factory.ordering).setNVariables(factory.nVariables);
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly bivariateResultant(UnivariatePolynomial<Poly> a, UnivariatePolynomial<Poly> b) {
        if (a.lc() instanceof MultivariatePolynomialZp64) {
            return (Poly)MultivariateResultants.bivariateResultantZp64(a, b);
        }
        return (Poly)MultivariateResultants.bivariateResultantE(a, b);
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly ResultantInSmallCharacteristic(Poly a, Poly b, int variable) {
        return MultivariateResultants.ClassicalResultant(a, b, variable);
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly ResultantInSmallCharacteristic(UnivariatePolynomial<Poly> a, UnivariatePolynomial<Poly> b) {
        return (Poly)((AMultivariatePolynomial)UnivariateResultants.Resultant(a, b));
    }

    public static MultivariatePolynomial<BigInteger> ModularResultantInZ(MultivariatePolynomial<BigInteger> a, MultivariatePolynomial<BigInteger> b, int variable) {
        ResultantInput resInput = MultivariateResultants.preparedResultantInput(a, b, variable);
        if (resInput.earlyResultant != null) {
            return (MultivariatePolynomial)resInput.earlyResultant;
        }
        return resInput.restoreResultant(MultivariateResultants.ModularResultantInZ0((MultivariatePolynomial)resInput.aReduced0, (MultivariatePolynomial)resInput.bReduced0));
    }

    private static BigInteger centralMultinomialCoefficient(int n, int d) {
        int q = n / d;
        int r = n % d;
        return ((BigInteger)Rings.Z.factorial(n)).divideExact(((BigInteger)Rings.Z.factorial(q)).pow(d - r)).divideExact(((BigInteger)Rings.Z.factorial(q + 1)).pow(r));
    }

    /*
     * Unable to fully structure code
     */
    static MultivariatePolynomial<BigInteger> ModularResultantInZ0(MultivariatePolynomial<BigInteger> a, MultivariatePolynomial<BigInteger> b) {
        aMax = a.maxAbsCoefficient();
        bMax = b.maxAbsCoefficient();
        bound2 = Rings.Z.getOne().multiply(aMax.pow(b.degree())).multiply(MultivariateResultants.centralMultinomialCoefficient(a.size(), b.degree())).multiply(bMax.pow(a.degree())).multiply(MultivariateResultants.centralMultinomialCoefficient(b.size(), a.degree())).multiply((BigInteger)Rings.Z.factorial(a.degree() + b.degree())).shiftLeft(1);
        startingPrime = Math.max(aMax.bitLength(), bMax.bitLength()) < 128 ? 0x40000000L : 0x1000000000000000L;
        primesLoop = new PrimesIterator(startingPrime - 4096L);
        random = PrivateRandom.getRandom();
        block0: while (true) {
            basePrime = primesLoop.take();
            if (!MultivariateResultants.$assertionsDisabled && basePrime == -1L) {
                throw new AssertionError((Object)"long overflow");
            }
            ring = Rings.Zp64(basePrime);
            aMod = a.mapCoefficientsZp64(ring, (ToLongFunction<BigInteger>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)J, lambda$ModularResultantInZ0$0(long cc.redberry.rings.bigint.BigInteger ), (Lcc/redberry/rings/bigint/BigInteger;)J)((long)basePrime));
            bMod = b.mapCoefficientsZp64(ring, (ToLongFunction<BigInteger>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)J, lambda$ModularResultantInZ0$1(long cc.redberry.rings.bigint.BigInteger ), (Lcc/redberry/rings/bigint/BigInteger;)J)((long)basePrime));
            if (!aMod.sameSkeletonQ(a) || !bMod.sameSkeletonQ(b)) continue;
            skeleton = base = (MultivariatePolynomialZp64)MultivariateResultants.ResultantInGF(aMod, bMod, 0).dropVariable(0);
            bBase = base.toBigPoly();
            previousBase = null;
            nUnchangedInterpolations = 0;
            bBasePrime = Rings.Z.valueOf(basePrime);
            while (true) {
                prime = primesLoop.take();
                bPrime = Rings.Z.valueOf(prime);
                ring = Rings.Zp64(prime);
                aMod = a.mapCoefficientsZp64(ring, (ToLongFunction<BigInteger>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)J, lambda$ModularResultantInZ0$2(long cc.redberry.rings.bigint.BigInteger ), (Lcc/redberry/rings/bigint/BigInteger;)J)((long)prime));
                bMod = b.mapCoefficientsZp64(ring, (ToLongFunction<BigInteger>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)J, lambda$ModularResultantInZ0$3(long cc.redberry.rings.bigint.BigInteger ), (Lcc/redberry/rings/bigint/BigInteger;)J)((long)prime));
                if (!aMod.sameSkeletonQ(a) || !bMod.sameSkeletonQ(b)) continue;
                modularResultant = MultivariateResultants.interpolateResultant(aMod, bMod, skeleton, random);
                if (modularResultant != null) ** break;
                continue block0;
                if (!modularResultant.sameSkeletonQ(bBase)) {
                    skeleton = base = modularResultant;
                    bBase = modularResultant.toBigPoly();
                    bBasePrime = bPrime;
                    previousBase = null;
                    nUnchangedInterpolations = 0;
                    continue;
                }
                newBasePrime = bBasePrime.multiply(bPrime);
                iterator = new PairedIterator<Term1, MultivariatePolynomial<BigInteger>, Term2, MultivariatePolynomialZp64>(bBase, modularResultant);
                magic = ChineseRemainders.createMagic(Rings.Z, bBasePrime, bPrime);
                while (iterator.hasNext()) {
                    iterator.advance();
                    baseTerm = (Monomial)iterator.aTerm;
                    imageTerm = (MonomialZp64)iterator.bTerm;
                    if (((BigInteger)baseTerm.coefficient).isZero()) continue;
                    if (imageTerm.coefficient == 0L) {
                        iterator.aIterator.remove();
                        continue;
                    }
                    oth = imageTerm.coefficient;
                    newCoeff = ChineseRemainders.ChineseRemainders(Rings.Z, magic, (BigInteger)baseTerm.coefficient, BigInteger.valueOf(oth));
                    bBase.put(baseTerm.setCoefficient(newCoeff));
                }
                bBase = bBase.setRingUnsafe(new IntegersZp(newBasePrime));
                bBasePrime = newBasePrime;
                candidate = MultivariatePolynomial.asPolyZSymmetric(bBase);
                nUnchangedInterpolations = previousBase != null && candidate.equals(previousBase) ? ++nUnchangedInterpolations : 0;
                if (nUnchangedInterpolations >= 5 || bBasePrime.compareTo(bound2) > 0) {
                    return candidate;
                }
                previousBase = candidate;
            }
            break;
        }
    }

    static MultivariatePolynomialZp64 interpolateResultant(MultivariatePolynomialZp64 a, MultivariatePolynomialZp64 b, MultivariatePolynomialZp64 skeleton, RandomGenerator rnd) {
        a.assertSameCoefficientRingWith(b);
        skeleton = skeleton.setRingUnsafe(a.ring);
        if (a.nVariables == 2) {
            return (MultivariatePolynomialZp64)MultivariateResultants.bivariateResultant(a.asUnivariateEliminate(0), b.asUnivariateEliminate(0));
        }
        SparseInterpolationZp64 interpolation = MultivariateResultants.createInterpolation(-1, a.asUnivariateEliminate(0), b.asUnivariateEliminate(0), skeleton, 1, rnd);
        if (interpolation == null) {
            return null;
        }
        MultivariatePolynomialZp64 res = interpolation.evaluate();
        if (res == null) {
            return null;
        }
        return res;
    }

    private static <E> MultivariatePolynomial<UnivariatePolynomial<E>> TrivialResultantInExtension(MultivariatePolynomial<UnivariatePolynomial<E>> a, MultivariatePolynomial<UnivariatePolynomial<E>> b, int variable) {
        AlgebraicNumberField ring;
        block3: {
            block2: {
                ring = (AlgebraicNumberField)a.ring;
                if (!a.stream().allMatch(ring::isInTheBaseField)) break block2;
                if (b.stream().allMatch(ring::isInTheBaseField)) break block3;
            }
            return null;
        }
        Ring cfRing = ((UnivariatePolynomial)ring.getMinimalPolynomial()).ring;
        MultivariatePolynomial<Object> ar = a.mapCoefficients(cfRing, UnivariatePolynomial::cc);
        MultivariatePolynomial<Object> br = b.mapCoefficients(cfRing, UnivariatePolynomial::cc);
        return MultivariateResultants.Resultant(ar, br, variable).mapCoefficients(ring, cf -> UnivariatePolynomial.constant(cfRing, cf));
    }

    public static MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> ModularResultantInNumberField(MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> a, MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> b, int variable) {
        MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> res = MultivariateResultants.TrivialResultantInExtension(a, b, variable);
        if (res != null) {
            return res;
        }
        AlgebraicNumberField numberField = (AlgebraicNumberField)a.ring;
        UnivariatePolynomial minimalPoly = (UnivariatePolynomial)numberField.getMinimalPolynomial();
        assert (numberField.isField());
        a = a.clone();
        b = b.clone();
        if (minimalPoly.stream().allMatch(Rational::isIntegral)) {
            UnivariatePolynomial<BigInteger> minimalPolyZ = minimalPoly.mapCoefficients(Rings.Z, Rational::numerator);
            AlgebraicNumberField<UnivariatePolynomial<BigInteger>> numberFieldZ = new AlgebraicNumberField<UnivariatePolynomial<BigInteger>>(minimalPolyZ);
            BigInteger aDen = MultivariateResultants.removeDenominators(a);
            BigInteger bDen = MultivariateResultants.removeDenominators(b);
            BigInteger den = aDen.pow(b.degree(variable)).multiply(bDen.pow(a.degree(variable)));
            assert (a.stream().allMatch(p -> p.stream().allMatch(Rational::isIntegral)));
            assert (b.stream().allMatch(p -> p.stream().allMatch(Rational::isIntegral)));
            return MultivariateResultants.ModularResultantInRingOfIntegersOfNumberField(a.mapCoefficients(numberFieldZ, cf -> cf.mapCoefficients(Rings.Z, Rational::numerator)), b.mapCoefficients(numberFieldZ, cf -> cf.mapCoefficients(Rings.Z, Rational::numerator)), variable).mapCoefficients(numberField, cf -> cf.mapCoefficients(Rings.Q, r -> Rings.Q.mk((BigInteger)r, den)));
        }
        BigInteger minPolyLeadCoeff = (BigInteger)Util.commonDenominator(minimalPoly);
        Rational<BigInteger> scale = new Rational<BigInteger>(Rings.Z, Rings.Z.getOne(), minPolyLeadCoeff);
        Rational<BigInteger> scaleReciprocal = scale.reciprocal();
        AlgebraicNumberField<IPolynomial> scaledNumberField = new AlgebraicNumberField<IPolynomial>(minimalPoly.scale(scale).monic());
        return MultivariateResultants.ModularResultantInNumberField(a.mapCoefficients(scaledNumberField, cf -> cf.scale(scale)), b.mapCoefficients(scaledNumberField, cf -> cf.scale(scale)), variable).mapCoefficients(numberField, cf -> cf.scale(scaleReciprocal));
    }

    static BigInteger removeDenominators(MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> a) {
        BigInteger denominator = (BigInteger)Rings.Z.lcm(() -> a.stream().map(Util::commonDenominator).iterator());
        a.multiply((UnivariatePolynomial)a.ring.valueOfBigInteger(denominator));
        return denominator;
    }

    public static MultivariatePolynomial<UnivariatePolynomial<BigInteger>> ModularResultantInRingOfIntegersOfNumberField(MultivariatePolynomial<UnivariatePolynomial<BigInteger>> a, MultivariatePolynomial<UnivariatePolynomial<BigInteger>> b, int variable) {
        ResultantInput resInput = MultivariateResultants.preparedResultantInput(a, b, variable);
        if (resInput.earlyResultant != null) {
            return (MultivariatePolynomial)resInput.earlyResultant;
        }
        return resInput.restoreResultant(MultivariateResultants.ModularResultantInRingOfIntegersOfNumberField0((MultivariatePolynomial)resInput.aReduced0, (MultivariatePolynomial)resInput.bReduced0));
    }

    private static MultivariatePolynomial<UnivariatePolynomial<BigInteger>> ModularResultantInRingOfIntegersOfNumberField0(MultivariatePolynomial<UnivariatePolynomial<BigInteger>> a, MultivariatePolynomial<UnivariatePolynomial<BigInteger>> b) {
        MultivariatePolynomial<UnivariatePolynomialZp64> base;
        MultivariatePolynomial<UnivariatePolynomialZp64> bMod;
        MultivariatePolynomial<UnivariatePolynomialZp64> aMod;
        FiniteField<UnivariatePolynomialZp64> numberFieldMod;
        UnivariatePolynomialZp64 minimalPolyMod;
        long basePrime;
        MultivariatePolynomial<UnivariatePolynomial<BigInteger>> r = MultivariateResultants.TrivialResultantInExtension(a, b, 0);
        if (r != null) {
            return r;
        }
        AlgebraicNumberField numberField = (AlgebraicNumberField)a.ring;
        UnivariatePolynomial minimalPoly = (UnivariatePolynomial)numberField.getMinimalPolynomial();
        BigInteger aMax = a.stream().map(UnivariatePolynomial::maxAbsCoefficient).max(Rings.Z).orElse(BigInteger.ONE);
        BigInteger bMax = b.stream().map(UnivariatePolynomial::maxAbsCoefficient).max(Rings.Z).orElse(BigInteger.ONE);
        BigInteger mMax = (BigInteger)minimalPoly.maxAbsCoefficient();
        long startingPrime = Math.max(aMax.bitLength(), bMax.bitLength()) < 128 ? 0x40000000L : 0x1000000000000000L;
        UnivariateRing<Integers> auxRing = Rings.UnivariateRing(Rings.Z);
        PrimesIterator primesLoop = new PrimesIterator(startingPrime - 4096L);
        RandomGenerator random = PrivateRandom.getRandom();
        while (true) {
            basePrime = primesLoop.take();
            assert (basePrime != -1L) : "long overflow";
            IntegersZp64 baseRing = Rings.Zp64(basePrime);
            minimalPolyMod = UnivariatePolynomial.asOverZp64(minimalPoly, baseRing);
            numberFieldMod = new FiniteField<UnivariatePolynomialZp64>(minimalPolyMod);
            aMod = a.mapCoefficients(numberFieldMod, c -> UnivariatePolynomial.asOverZp64(c, baseRing));
            bMod = b.mapCoefficients(numberFieldMod, c -> UnivariatePolynomial.asOverZp64(c, baseRing));
            if (!aMod.sameSkeletonQ(a) || !bMod.sameSkeletonQ(b)) continue;
            try {
                base = (MultivariatePolynomial<UnivariatePolynomialZp64>)MultivariateResultants.ResultantInGF(aMod, bMod, 0).dropVariable(0);
            }
            catch (Throwable t) {
                continue;
            }
            break;
        }
        MultivariatePolynomial<UnivariatePolynomial> bBase = base.mapCoefficients(auxRing, cf -> cf.asPolyZ(false).toBigPoly());
        MultivariatePolynomial<UnivariatePolynomial<BigInteger>> previousBase = null;
        int nUnchangedInterpolations = 0;
        BigInteger bBasePrime = Rings.Z.valueOf(basePrime);
        while (true) {
            MultivariatePolynomial<UnivariatePolynomialZp64> modularResultant;
            long prime = primesLoop.take();
            BigInteger bPrime = Rings.Z.valueOf(prime);
            IntegersZp64 ring = Rings.Zp64(prime);
            minimalPolyMod = UnivariatePolynomial.asOverZp64(minimalPoly, ring);
            numberFieldMod = new FiniteField<UnivariatePolynomialZp64>(minimalPolyMod);
            aMod = a.mapCoefficients(numberFieldMod, c -> UnivariatePolynomial.asOverZp64(c, ring));
            bMod = b.mapCoefficients(numberFieldMod, c -> UnivariatePolynomial.asOverZp64(c, ring));
            if (!aMod.sameSkeletonQ(a) || !bMod.sameSkeletonQ(b)) continue;
            try {
                modularResultant = MultivariateResultants.interpolateResultant(aMod, bMod, base.mapCoefficients(numberFieldMod, cf -> cf.setModulusUnsafe(ring)), random);
            }
            catch (Throwable t) {
                continue;
            }
            if (modularResultant == null) continue;
            if (!modularResultant.sameSkeletonQ(bBase)) {
                base = modularResultant;
                bBase = modularResultant.mapCoefficients(auxRing, cf -> cf.asPolyZ(false).toBigPoly());
                bBasePrime = bPrime;
                previousBase = null;
                nUnchangedInterpolations = 0;
                continue;
            }
            BigInteger newBasePrime = bBasePrime.multiply(bPrime);
            PairedIterator iterator = new PairedIterator(bBase, modularResultant);
            ChineseRemainders.ChineseRemaindersMagic<BigInteger> magic = ChineseRemainders.createMagic(Rings.Z, bBasePrime, bPrime);
            while (iterator.hasNext()) {
                iterator.advance();
                Monomial baseTerm = (Monomial)iterator.aTerm;
                Monomial imageTerm = (Monomial)iterator.bTerm;
                if (((UnivariatePolynomial)baseTerm.coefficient).isZero()) continue;
                if (((UnivariatePolynomialZp64)imageTerm.coefficient).isZero()) {
                    iterator.aIterator.remove();
                    continue;
                }
                UnivariateGCD.updateCRT(magic, (UnivariatePolynomial)baseTerm.coefficient, (UnivariatePolynomialZp64)imageTerm.coefficient);
            }
            bBasePrime = newBasePrime;
            IntegersZp crtRing = Rings.Zp(bBasePrime);
            MultivariatePolynomial<UnivariatePolynomial<BigInteger>> candidate = bBase.mapCoefficients(numberField, cf -> UnivariatePolynomial.asPolyZSymmetric(cf.setRingUnsafe(crtRing)));
            nUnchangedInterpolations = previousBase != null && candidate.equals(previousBase) ? ++nUnchangedInterpolations : 0;
            if (nUnchangedInterpolations >= 5) {
                return candidate;
            }
            previousBase = candidate;
        }
    }

    static MultivariatePolynomial<UnivariatePolynomialZp64> interpolateResultant(MultivariatePolynomial<UnivariatePolynomialZp64> a, MultivariatePolynomial<UnivariatePolynomialZp64> b, MultivariatePolynomial<UnivariatePolynomialZp64> skeleton, RandomGenerator rnd) {
        a.assertSameCoefficientRingWith(b);
        if (a.nVariables == 2) {
            return (MultivariatePolynomial)MultivariateResultants.bivariateResultant(a.asUnivariateEliminate(0), b.asUnivariateEliminate(0));
        }
        skeleton = skeleton.setRingUnsafe(a.ring);
        SparseInterpolationE<UnivariatePolynomialZp64> interpolation = MultivariateResultants.createInterpolation(-1, a.asUnivariateEliminate(0), b.asUnivariateEliminate(0), skeleton, 1, rnd);
        if (interpolation == null) {
            return null;
        }
        MultivariatePolynomial<UnivariatePolynomialZp64> res = interpolation.evaluate();
        if (res == null) {
            return null;
        }
        return res;
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly BrownResultant(Poly a, Poly b, int variable) {
        if (a instanceof MultivariatePolynomialZp64) {
            return (Poly)MultivariateResultants.BrownResultant((MultivariatePolynomialZp64)a, (MultivariatePolynomialZp64)b, variable);
        }
        return (Poly)MultivariateResultants.BrownResultant((MultivariatePolynomial)a, (MultivariatePolynomial)b, variable);
    }

    public static MultivariatePolynomialZp64 BrownResultant(MultivariatePolynomialZp64 a, MultivariatePolynomialZp64 b, int variable) {
        ResultantInput resInput = MultivariateResultants.preparedResultantInput(a, b, variable);
        if (resInput.earlyResultant != null) {
            return (MultivariatePolynomialZp64)resInput.earlyResultant;
        }
        if (resInput.finiteExtensionDegree > 1) {
            return resInput.restoreResultant((MultivariatePolynomialZp64)MultivariateResultants.ResultantInSmallCharacteristic(resInput.aReduced, resInput.bReduced));
        }
        MultivariatePolynomialZp64 result = MultivariateResultants.BrownResultantZp64(resInput.aReduced, resInput.bReduced, resInput.degreeBounds, resInput.lastPresentVariable);
        if (result == null) {
            return resInput.restoreResultant((MultivariatePolynomialZp64)MultivariateResultants.ResultantInSmallCharacteristic(resInput.aReduced, resInput.bReduced));
        }
        return resInput.restoreResultant(result);
    }

    static MultivariatePolynomialZp64 BrownResultantZp64(UnivariatePolynomial<MultivariatePolynomialZp64> a, UnivariatePolynomial<MultivariatePolynomialZp64> b, int[] degreeBounds, int variable) {
        if (variable == 0) {
            return MultivariateResultants.bivariateResultantZp64(a, b);
        }
        MultivariateRing mRing = (MultivariateRing)a.ring;
        MultivariatePolynomialZp64 factory = (MultivariatePolynomialZp64)mRing.factory();
        IntegersZp64 ring = factory.ring;
        MultivariateInterpolation.InterpolationZp64 interpolation = null;
        TLongHashSet evaluationStack = new TLongHashSet();
        RandomGenerator rnd = PrivateRandom.getRandom();
        while (true) {
            long v;
            if ((long)evaluationStack.size() == ring.modulus) {
                return null;
            }
            while (evaluationStack.contains(v = ring.randomElement(rnd))) {
            }
            long randomPoint = v;
            evaluationStack.add(randomPoint);
            MultivariateRing imageRing = mRing.dropVariable();
            UnivariatePolynomial<MultivariatePolynomialZp64> aMod = a.mapCoefficients(imageRing, cf -> cf.eliminate(variable, randomPoint));
            UnivariatePolynomial<MultivariatePolynomialZp64> bMod = b.mapCoefficients(imageRing, cf -> cf.eliminate(variable, randomPoint));
            if (aMod.degree() != a.degree() || bMod.degree() != b.degree()) continue;
            MultivariatePolynomialZp64 modResultant = (MultivariatePolynomialZp64)MultivariateResultants.BrownResultantZp64(aMod, bMod, degreeBounds, variable - 1).insertVariable(variable);
            if (interpolation == null) {
                interpolation = new MultivariateInterpolation.InterpolationZp64(variable, randomPoint, modResultant);
                continue;
            }
            interpolation.update(randomPoint, modResultant);
            if (interpolation.numberOfPoints() > degreeBounds[variable]) break;
        }
        return interpolation.getInterpolatingPolynomial();
    }

    public static <E> MultivariatePolynomial<E> BrownResultant(MultivariatePolynomial<E> a, MultivariatePolynomial<E> b, int variable) {
        if (Conversions64bit.canConvertToZp64(a)) {
            return (MultivariatePolynomial)Conversions64bit.convertFromZp64(MultivariateResultants.BrownResultant(Conversions64bit.asOverZp64(a), Conversions64bit.asOverZp64(b), variable));
        }
        ResultantInput resInput = MultivariateResultants.preparedResultantInput(a, b, variable);
        if (resInput.earlyResultant != null) {
            return (MultivariatePolynomial)resInput.earlyResultant;
        }
        if (resInput.finiteExtensionDegree > 1) {
            return resInput.restoreResultant((MultivariatePolynomial)MultivariateResultants.ResultantInSmallCharacteristic(resInput.aReduced, resInput.bReduced));
        }
        MultivariatePolynomial<E> result = MultivariateResultants.BrownResultantE(resInput.aReduced, resInput.bReduced, resInput.degreeBounds, resInput.lastPresentVariable);
        if (result == null) {
            return resInput.restoreResultant((MultivariatePolynomial)MultivariateResultants.ResultantInSmallCharacteristic(resInput.aReduced, resInput.bReduced));
        }
        return resInput.restoreResultant(result);
    }

    static <E> MultivariatePolynomial<E> BrownResultantE(UnivariatePolynomial<MultivariatePolynomial<E>> a, UnivariatePolynomial<MultivariatePolynomial<E>> b, int[] degreeBounds, int variable) {
        if (variable == 0) {
            return MultivariateResultants.bivariateResultantE(a, b);
        }
        MultivariateRing mRing = (MultivariateRing)a.ring;
        MultivariatePolynomial factory = (MultivariatePolynomial)mRing.factory();
        Ring ring = factory.ring;
        MultivariateInterpolation.Interpolation interpolation = null;
        HashSet evaluationStack = new HashSet();
        RandomGenerator rnd = PrivateRandom.getRandom();
        while (true) {
            Object v;
            if (ring.cardinality().isInt() && evaluationStack.size() == ring.cardinality().intValue()) {
                return null;
            }
            while (evaluationStack.contains(v = MultivariateGCD.randomElement(ring, rnd))) {
            }
            Object randomPoint = v;
            evaluationStack.add(randomPoint);
            MultivariateRing imageRing = mRing.dropVariable();
            UnivariatePolynomial<MultivariatePolynomial<E>> aMod = a.mapCoefficients(imageRing, cf -> cf.eliminate(variable, randomPoint));
            UnivariatePolynomial<MultivariatePolynomial<E>> bMod = b.mapCoefficients(imageRing, cf -> cf.eliminate(variable, randomPoint));
            if (aMod.degree() != a.degree() || bMod.degree() != b.degree()) continue;
            MultivariatePolynomial modResultant = (MultivariatePolynomial)MultivariateResultants.BrownResultantE(aMod, bMod, degreeBounds, variable - 1).insertVariable(variable);
            if (interpolation == null) {
                interpolation = new MultivariateInterpolation.Interpolation(variable, randomPoint, modResultant);
                continue;
            }
            interpolation.update(randomPoint, modResultant);
            if (interpolation.numberOfPoints() > degreeBounds[variable]) break;
        }
        return interpolation.getInterpolatingPolynomial();
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly ZippelResultant(Poly a, Poly b, int variable) {
        if (a instanceof MultivariatePolynomialZp64) {
            return (Poly)MultivariateResultants.ZippelResultant((MultivariatePolynomialZp64)a, (MultivariatePolynomialZp64)b, variable);
        }
        return (Poly)MultivariateResultants.ZippelResultant((MultivariatePolynomial)a, (MultivariatePolynomial)b, variable);
    }

    public static MultivariatePolynomialZp64 ZippelResultant(MultivariatePolynomialZp64 a, MultivariatePolynomialZp64 b, int variable) {
        ResultantInput resInput = MultivariateResultants.preparedResultantInput(a, b, variable);
        if (resInput.earlyResultant != null) {
            return (MultivariatePolynomialZp64)resInput.earlyResultant;
        }
        if (resInput.finiteExtensionDegree > 1) {
            return resInput.restoreResultant((MultivariatePolynomialZp64)MultivariateResultants.ResultantInSmallCharacteristic(resInput.aReduced, resInput.bReduced));
        }
        MultivariatePolynomialZp64 result = MultivariateResultants.ZippelResultantZp64(resInput.aReduced, resInput.bReduced, resInput.degreeBounds, resInput.lastPresentVariable);
        if (result == null) {
            return resInput.restoreResultant((MultivariatePolynomialZp64)MultivariateResultants.ResultantInSmallCharacteristic(resInput.aReduced, resInput.bReduced));
        }
        return resInput.restoreResultant(result);
    }

    /*
     * Unable to fully structure code
     */
    static MultivariatePolynomialZp64 ZippelResultantZp64(UnivariatePolynomial<MultivariatePolynomialZp64> a, UnivariatePolynomial<MultivariatePolynomialZp64> b, int[] degreeBounds, int variable) {
        if (variable == 0) {
            return MultivariateResultants.bivariateResultantZp64(a, b);
        }
        mRing = (MultivariateRing)a.ring;
        factory = (MultivariatePolynomialZp64)mRing.factory();
        ring = factory.ring;
        globalEvaluationStack = new TLongHashSet();
        rnd = PrivateRandom.getRandom();
        block0: while (true) {
            if ((long)globalEvaluationStack.size() == ring.modulus) {
                return null;
            }
            while (globalEvaluationStack.contains(v = ring.randomElement(rnd))) {
            }
            seedRandomPoint = v;
            globalEvaluationStack.add(seedRandomPoint);
            imageRing = mRing.dropVariable();
            aMod = a.mapCoefficients(imageRing, (Function<MultivariatePolynomialZp64, MultivariatePolynomialZp64>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$ZippelResultantZp64$27(int long cc.redberry.rings.poly.multivar.MultivariatePolynomialZp64 ), (Lcc/redberry/rings/poly/multivar/MultivariatePolynomialZp64;)Lcc/redberry/rings/poly/multivar/MultivariatePolynomialZp64;)((int)variable, (long)seedRandomPoint));
            bMod = b.mapCoefficients(imageRing, (Function<MultivariatePolynomialZp64, MultivariatePolynomialZp64>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$ZippelResultantZp64$28(int long cc.redberry.rings.poly.multivar.MultivariatePolynomialZp64 ), (Lcc/redberry/rings/poly/multivar/MultivariatePolynomialZp64;)Lcc/redberry/rings/poly/multivar/MultivariatePolynomialZp64;)((int)variable, (long)seedRandomPoint));
            if (aMod.degree() != a.degree() || bMod.degree() != b.degree()) continue;
            for (i = 0; i <= a.degree(); ++i) {
                iniSkeleton = ((MultivariatePolynomialZp64)a.get(i).dropVariable(variable)).getSkeleton();
                if (!iniSkeleton.equals(modSkeleton = aMod.get(i).getSkeleton())) continue block0;
            }
            for (i = 0; i <= b.degree(); ++i) {
                iniSkeleton = ((MultivariatePolynomialZp64)b.get(i).dropVariable(variable)).getSkeleton();
                if (!iniSkeleton.equals(modSkeleton = bMod.get(i).getSkeleton())) continue block0;
            }
            baseResultant = (MultivariatePolynomialZp64)MultivariateResultants.ZippelResultantZp64(aMod, bMod, degreeBounds, variable - 1).insertVariable(variable);
            denseInterpolation = new MultivariateInterpolation.InterpolationZp64(variable, seedRandomPoint, baseResultant);
            sparseInterpolation = MultivariateResultants.createInterpolation(variable, a, b, baseResultant, degreeBounds[variable], rnd);
            localEvaluationStack = new TLongHashSet(globalEvaluationStack);
            while (true) {
                if ((long)localEvaluationStack.size() != ring.modulus) ** break;
                continue block0;
                while (localEvaluationStack.contains(v = ring.randomElement(rnd))) {
                }
                randomPoint = v;
                localEvaluationStack.add(randomPoint);
                modResultant = sparseInterpolation.evaluate(randomPoint);
                if (modResultant == null) continue;
                denseInterpolation.update(randomPoint, modResultant);
                if (denseInterpolation.numberOfPoints() > degreeBounds[variable]) break block0;
            }
            break;
        }
        return denseInterpolation.getInterpolatingPolynomial();
    }

    public static <E> MultivariatePolynomial<E> ZippelResultant(MultivariatePolynomial<E> a, MultivariatePolynomial<E> b, int variable) {
        if (Conversions64bit.canConvertToZp64(a)) {
            return (MultivariatePolynomial)Conversions64bit.convertFromZp64(MultivariateResultants.ZippelResultant(Conversions64bit.asOverZp64(a), Conversions64bit.asOverZp64(b), variable));
        }
        ResultantInput resInput = MultivariateResultants.preparedResultantInput(a, b, variable);
        if (resInput.earlyResultant != null) {
            return (MultivariatePolynomial)resInput.earlyResultant;
        }
        if (resInput.finiteExtensionDegree > 1) {
            return resInput.restoreResultant((MultivariatePolynomial)MultivariateResultants.ResultantInSmallCharacteristic(resInput.aReduced, resInput.bReduced));
        }
        MultivariatePolynomial<E> result = MultivariateResultants.ZippelResultantE(resInput.aReduced, resInput.bReduced, resInput.degreeBounds, resInput.lastPresentVariable);
        if (result == null) {
            return resInput.restoreResultant((MultivariatePolynomial)MultivariateResultants.ResultantInSmallCharacteristic(resInput.aReduced, resInput.bReduced));
        }
        return resInput.restoreResultant(result);
    }

    /*
     * Unable to fully structure code
     */
    static <E> MultivariatePolynomial<E> ZippelResultantE(UnivariatePolynomial<MultivariatePolynomial<E>> a, UnivariatePolynomial<MultivariatePolynomial<E>> b, int[] degreeBounds, int variable) {
        if (variable == 0) {
            return MultivariateResultants.bivariateResultantE(a, b);
        }
        mRing = (MultivariateRing)a.ring;
        factory = (MultivariatePolynomial)mRing.factory();
        ring = factory.ring;
        globalEvaluationStack = new HashSet<E>();
        rnd = PrivateRandom.getRandom();
        block0: while (true) {
            if (ring.cardinality().isInt() && globalEvaluationStack.size() == ring.cardinality().intValueExact()) {
                return null;
            }
            while (globalEvaluationStack.contains(v = MultivariateGCD.randomElement(ring, rnd))) {
            }
            seedRandomPoint = v;
            globalEvaluationStack.add(seedRandomPoint);
            imageRing = mRing.dropVariable();
            aMod = a.mapCoefficients(imageRing, (Function<MultivariatePolynomial, MultivariatePolynomial>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$ZippelResultantE$29(int java.lang.Object cc.redberry.rings.poly.multivar.MultivariatePolynomial ), (Lcc/redberry/rings/poly/multivar/MultivariatePolynomial;)Lcc/redberry/rings/poly/multivar/MultivariatePolynomial;)((int)variable, seedRandomPoint));
            bMod = b.mapCoefficients(imageRing, (Function<MultivariatePolynomial, MultivariatePolynomial>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$ZippelResultantE$30(int java.lang.Object cc.redberry.rings.poly.multivar.MultivariatePolynomial ), (Lcc/redberry/rings/poly/multivar/MultivariatePolynomial;)Lcc/redberry/rings/poly/multivar/MultivariatePolynomial;)((int)variable, seedRandomPoint));
            if (aMod.degree() != a.degree() || bMod.degree() != b.degree()) continue;
            for (i = 0; i <= a.degree(); ++i) {
                iniSkeleton = ((MultivariatePolynomial)a.get(i).dropVariable(variable)).getSkeleton();
                if (!iniSkeleton.equals(modSkeleton = aMod.get(i).getSkeleton())) continue block0;
            }
            for (i = 0; i <= b.degree(); ++i) {
                iniSkeleton = ((MultivariatePolynomial)b.get(i).dropVariable(variable)).getSkeleton();
                if (!iniSkeleton.equals(modSkeleton = bMod.get(i).getSkeleton())) continue block0;
            }
            baseResultant = (MultivariatePolynomial)MultivariateResultants.ZippelResultantE(aMod, bMod, degreeBounds, variable - 1).insertVariable(variable);
            denseInterpolation = new MultivariateInterpolation.Interpolation<E>(variable, seedRandomPoint, baseResultant);
            sparseInterpolation = MultivariateResultants.createInterpolation(variable, a, b, baseResultant, degreeBounds[variable], rnd);
            localEvaluationStack = new HashSet<E>(globalEvaluationStack);
            while (true) {
                if (!ring.cardinality().isInt() || localEvaluationStack.size() != ring.cardinality().intValueExact()) ** break;
                continue block0;
                while (localEvaluationStack.contains(v = MultivariateGCD.randomElement(ring, rnd))) {
                }
                randomPoint = v;
                localEvaluationStack.add(randomPoint);
                modResultant = sparseInterpolation.evaluate(randomPoint);
                if (modResultant == null) continue;
                denseInterpolation.update(randomPoint, modResultant);
                if (denseInterpolation.numberOfPoints() > degreeBounds[variable]) break block0;
            }
            break;
        }
        return denseInterpolation.getInterpolatingPolynomial();
    }

    static SparseInterpolationZp64 createInterpolation(int variable, UnivariatePolynomial<MultivariatePolynomialZp64> a, UnivariatePolynomial<MultivariatePolynomialZp64> b, MultivariatePolynomialZp64 skeleton, int expectedNumberOfEvaluations, RandomGenerator rnd) {
        MultivariatePolynomialZp64.lPrecomputedPowersHolder powers;
        MultivariatePolynomialZp64 factory = a.lc();
        assert (factory.nVariables > 1);
        skeleton = (MultivariatePolynomialZp64)skeleton.clone().setAllCoefficientsToUnit();
        Set<DegreeVector> globalSkeleton = skeleton.getSkeleton();
        TIntObjectHashMap<MultivariatePolynomialZp64> univarSkeleton = MultivariateGCD.getSkeleton(skeleton);
        int[] sparseUnivarDegrees = univarSkeleton.keys();
        IntegersZp64 ring = factory.ring;
        int lastVariable = variable == -1 ? factory.nVariables - 1 : variable;
        int[] evaluationVariables = ArraysUtil.sequence(1, lastVariable + 1);
        long[] evaluationPoint = new long[evaluationVariables.length];
        int fails = 0;
        block0: while (true) {
            if (fails >= 32) {
                return null;
            }
            for (int i = lastVariable - 1; i >= 0; --i) {
                do {
                    evaluationPoint[i] = ring.randomElement(rnd);
                } while (evaluationPoint[i] == 0L);
            }
            powers = MultivariateResultants.mkPrecomputedPowers(a, b, evaluationVariables, evaluationPoint);
            Iterator it = Stream.concat(Stream.concat(a.stream(), b.stream()), Stream.of(skeleton)).iterator();
            while (it.hasNext()) {
                MultivariatePolynomialZp64 p = (MultivariatePolynomialZp64)it.next();
                if (p.getSkeleton(0).equals(p.evaluate(powers, evaluationVariables).getSkeleton())) continue;
                ++fails;
                continue block0;
            }
            break;
        }
        int requiredNumberOfEvaluations = -1;
        TIntObjectIterator<MultivariatePolynomialZp64> it = univarSkeleton.iterator();
        while (it.hasNext()) {
            it.advance();
            MultivariatePolynomialZp64 v = it.value();
            if (v.size() <= requiredNumberOfEvaluations) continue;
            requiredNumberOfEvaluations = v.size();
        }
        return new SparseInterpolationZp64(ring, variable, a, b, globalSkeleton, univarSkeleton, sparseUnivarDegrees, evaluationVariables, evaluationPoint, powers, expectedNumberOfEvaluations, requiredNumberOfEvaluations, rnd);
    }

    static MultivariatePolynomialZp64.lPrecomputedPowersHolder mkPrecomputedPowers(UnivariatePolynomial<MultivariatePolynomialZp64> a, UnivariatePolynomial<MultivariatePolynomialZp64> b, int[] evaluationVariables, long[] evaluationPoint) {
        int i;
        MultivariatePolynomialZp64 factory = a.lc();
        int[] degrees = null;
        for (i = 0; i <= a.degree(); ++i) {
            degrees = degrees == null ? a.get(i).degreesRef() : ArraysUtil.max(degrees, a.get(i).degreesRef());
        }
        assert (degrees != null);
        for (i = 0; i <= b.degree(); ++i) {
            degrees = ArraysUtil.max(degrees, b.get(i).degreesRef());
        }
        MultivariatePolynomialZp64.lPrecomputedPowers[] pp = new MultivariatePolynomialZp64.lPrecomputedPowers[factory.nVariables];
        for (int i2 = 0; i2 < evaluationVariables.length; ++i2) {
            pp[evaluationVariables[i2]] = new MultivariatePolynomialZp64.lPrecomputedPowers(Math.min(degrees[evaluationVariables[i2]], 1014), evaluationPoint[i2], factory.ring);
        }
        return new MultivariatePolynomialZp64.lPrecomputedPowersHolder(factory.ring, pp);
    }

    static <E> SparseInterpolationE<E> createInterpolation(int variable, UnivariatePolynomial<MultivariatePolynomial<E>> a, UnivariatePolynomial<MultivariatePolynomial<E>> b, MultivariatePolynomial<E> skeleton, int expectedNumberOfEvaluations, RandomGenerator rnd) {
        MultivariatePolynomial.PrecomputedPowersHolder<int> powers;
        MultivariatePolynomial<E> factory = a.lc();
        assert (factory.nVariables > 1);
        skeleton = (MultivariatePolynomial)skeleton.clone().setAllCoefficientsToUnit();
        Set<DegreeVector> globalSkeleton = skeleton.getSkeleton();
        TIntObjectHashMap univarSkeleton = MultivariateGCD.getSkeleton(skeleton);
        int[] sparseUnivarDegrees = univarSkeleton.keys();
        Ring<int> ring = factory.ring;
        int lastVariable = variable == -1 ? factory.nVariables - 1 : variable;
        int[] evaluationVariables = ArraysUtil.sequence(1, lastVariable + 1);
        int[] evaluationPoint = ring.createArray(evaluationVariables.length);
        int fails = 0;
        block0: while (true) {
            if (fails >= 32) {
                return null;
            }
            for (int i = lastVariable - 1; i >= 0; --i) {
                do {
                    evaluationPoint[i] = (int)MultivariateGCD.randomElement(ring, rnd);
                } while (ring.isZero(evaluationPoint[i]));
            }
            powers = MultivariateResultants.mkPrecomputedPowers(a, b, evaluationVariables, evaluationPoint);
            Iterator it = Stream.concat(Stream.concat(a.stream(), b.stream()), Stream.of(skeleton)).iterator();
            while (it.hasNext()) {
                MultivariatePolynomial p = (MultivariatePolynomial)it.next();
                if (p.getSkeleton(0).equals(p.evaluate(powers, evaluationVariables).getSkeleton())) continue;
                ++fails;
                continue block0;
            }
            break;
        }
        int requiredNumberOfEvaluations = -1;
        TIntObjectIterator it = univarSkeleton.iterator();
        while (it.hasNext()) {
            it.advance();
            MultivariatePolynomial v = it.value();
            if (v.size() <= requiredNumberOfEvaluations) continue;
            requiredNumberOfEvaluations = v.size();
        }
        return new SparseInterpolationE<int>(ring, variable, a, b, globalSkeleton, univarSkeleton, sparseUnivarDegrees, evaluationVariables, evaluationPoint, powers, expectedNumberOfEvaluations, requiredNumberOfEvaluations, rnd);
    }

    static <E> MultivariatePolynomial.PrecomputedPowersHolder<E> mkPrecomputedPowers(UnivariatePolynomial<MultivariatePolynomial<E>> a, UnivariatePolynomial<MultivariatePolynomial<E>> b, int[] evaluationVariables, E[] evaluationPoint) {
        int i;
        MultivariatePolynomial<E> factory = a.lc();
        int[] degrees = null;
        for (i = 0; i <= a.degree(); ++i) {
            degrees = degrees == null ? a.get(i).degreesRef() : ArraysUtil.max(degrees, a.get(i).degreesRef());
        }
        assert (degrees != null);
        for (i = 0; i <= b.degree(); ++i) {
            degrees = ArraysUtil.max(degrees, b.get(i).degreesRef());
        }
        MultivariatePolynomial.PrecomputedPowers[] pp = new MultivariatePolynomial.PrecomputedPowers[factory.nVariables];
        for (int i2 = 0; i2 < evaluationVariables.length; ++i2) {
            pp[evaluationVariables[i2]] = new MultivariatePolynomial.PrecomputedPowers<E>(Math.min(degrees[evaluationVariables[i2]], 1014), evaluationPoint[i2], factory.ring);
        }
        return new MultivariatePolynomial.PrecomputedPowersHolder(factory.ring, pp);
    }

    private static /* synthetic */ MultivariatePolynomial lambda$ZippelResultantE$30(int variable, Object seedRandomPoint, MultivariatePolynomial cf) {
        return cf.eliminate(variable, seedRandomPoint);
    }

    private static /* synthetic */ MultivariatePolynomial lambda$ZippelResultantE$29(int variable, Object seedRandomPoint, MultivariatePolynomial cf) {
        return cf.eliminate(variable, seedRandomPoint);
    }

    private static /* synthetic */ MultivariatePolynomialZp64 lambda$ZippelResultantZp64$28(int variable, long seedRandomPoint, MultivariatePolynomialZp64 cf) {
        return cf.eliminate(variable, seedRandomPoint);
    }

    private static /* synthetic */ MultivariatePolynomialZp64 lambda$ZippelResultantZp64$27(int variable, long seedRandomPoint, MultivariatePolynomialZp64 cf) {
        return cf.eliminate(variable, seedRandomPoint);
    }

    private static /* synthetic */ long lambda$ModularResultantInZ0$3(long prime, BigInteger c) {
        return c.mod(prime).longValue();
    }

    private static /* synthetic */ long lambda$ModularResultantInZ0$2(long prime, BigInteger c) {
        return c.mod(prime).longValue();
    }

    private static /* synthetic */ long lambda$ModularResultantInZ0$1(long basePrime, BigInteger c) {
        return c.mod(basePrime).longValue();
    }

    private static /* synthetic */ long lambda$ModularResultantInZ0$0(long basePrime, BigInteger c) {
        return c.mod(basePrime).longValue();
    }

    static final class ResultantInput<Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> {
        final Poly aReduced0;
        final Poly bReduced0;
        final UnivariatePolynomial<Poly> aReduced;
        final UnivariatePolynomial<Poly> bReduced;
        final Poly earlyResultant;
        final int[] degreeBounds;
        final int[] mapping;
        final int lastPresentVariable;
        final int evaluationStackLimit;
        final Poly monomialResultant;
        final int finiteExtensionDegree;

        ResultantInput(Poly earlyResultant) {
            this.earlyResultant = earlyResultant;
            this.bReduced0 = null;
            this.aReduced0 = null;
            this.bReduced = null;
            this.aReduced = null;
            this.mapping = null;
            this.degreeBounds = null;
            this.evaluationStackLimit = -1;
            this.lastPresentVariable = -1;
            this.monomialResultant = null;
            this.finiteExtensionDegree = -1;
        }

        ResultantInput(Poly aReduced0, Poly bReduced0, Poly monomialResultant, int evaluationStackLimit, int[] degreeBounds, int[] mapping, int lastPresentVariable, int finiteExtensionDegree) {
            this.aReduced0 = aReduced0;
            this.bReduced0 = bReduced0;
            this.aReduced = ((AMultivariatePolynomial)aReduced0).asUnivariateEliminate(0);
            this.bReduced = ((AMultivariatePolynomial)bReduced0).asUnivariateEliminate(0);
            this.monomialResultant = monomialResultant;
            this.earlyResultant = null;
            this.evaluationStackLimit = evaluationStackLimit;
            this.degreeBounds = degreeBounds;
            this.mapping = MultivariateGCD.inversePermutation(mapping);
            this.lastPresentVariable = lastPresentVariable;
            this.finiteExtensionDegree = finiteExtensionDegree;
        }

        Poly restoreResultant(Poly result) {
            return (Poly)((AMultivariatePolynomial)((AMultivariatePolynomial)AMultivariatePolynomial.renameVariables(((AMultivariatePolynomial)result).insertVariable(0), this.mapping)).multiply(this.monomialResultant));
        }
    }

    static final class SparseInterpolationZp64 {
        final IntegersZp64 ring;
        final int variable;
        final UnivariatePolynomial<MultivariatePolynomialZp64> a;
        final UnivariatePolynomial<MultivariatePolynomialZp64> b;
        final Set<DegreeVector> globalSkeleton;
        final TIntObjectHashMap<MultivariatePolynomialZp64> univarSkeleton;
        final int[] sparseUnivarDegrees;
        final int[] evaluationVariables;
        final long[] evaluationPoint;
        final MultivariatePolynomialZp64.lPrecomputedPowersHolder powers;
        final MultivariateGCD.ZippelEvaluationsZp64[] aEvals;
        final MultivariateGCD.ZippelEvaluationsZp64[] bEvals;
        final int requiredNumberOfEvaluations;
        final RandomGenerator rnd;
        final MultivariatePolynomialZp64 factory;

        SparseInterpolationZp64(IntegersZp64 ring, int variable, UnivariatePolynomial<MultivariatePolynomialZp64> a, UnivariatePolynomial<MultivariatePolynomialZp64> b, Set<DegreeVector> globalSkeleton, TIntObjectHashMap<MultivariatePolynomialZp64> univarSkeleton, int[] sparseUnivarDegrees, int[] evaluationVariables, long[] evaluationPoint, MultivariatePolynomialZp64.lPrecomputedPowersHolder powers, int expectedNumberOfEvaluations, int requiredNumberOfEvaluations, RandomGenerator rnd) {
            int i;
            this.ring = ring;
            this.variable = variable;
            this.a = a;
            this.b = b;
            this.globalSkeleton = globalSkeleton;
            this.univarSkeleton = univarSkeleton;
            this.sparseUnivarDegrees = sparseUnivarDegrees;
            this.evaluationPoint = evaluationPoint;
            this.aEvals = new MultivariateGCD.ZippelEvaluationsZp64[a.degree() + 1];
            this.bEvals = new MultivariateGCD.ZippelEvaluationsZp64[b.degree() + 1];
            for (i = 0; i < this.aEvals.length; ++i) {
                this.aEvals[i] = MultivariateGCD.createEvaluations(a.get(i), evaluationVariables, evaluationPoint, powers, expectedNumberOfEvaluations);
            }
            for (i = 0; i < this.bEvals.length; ++i) {
                this.bEvals[i] = MultivariateGCD.createEvaluations(b.get(i), evaluationVariables, evaluationPoint, powers, expectedNumberOfEvaluations);
            }
            this.evaluationVariables = evaluationVariables;
            this.powers = powers;
            this.requiredNumberOfEvaluations = requiredNumberOfEvaluations;
            this.rnd = rnd;
            this.factory = a.lc();
        }

        public final MultivariatePolynomialZp64 evaluate() {
            return this.evaluate(this.evaluationPoint[this.evaluationPoint.length - 1]);
        }

        public final MultivariatePolynomialZp64 evaluate(long newPoint) {
            this.evaluationPoint[this.evaluationPoint.length - 1] = newPoint;
            this.powers.set(this.evaluationVariables[this.evaluationVariables.length - 1], newPoint);
            return this.evaluate0(newPoint);
        }

        private MultivariatePolynomialZp64 evaluate0(long newPoint) {
            int i;
            MultivariateGCD.lVandermondeSystem[] systems = new MultivariateGCD.lVandermondeSystem[this.sparseUnivarDegrees.length];
            for (i = 0; i < this.sparseUnivarDegrees.length; ++i) {
                systems[i] = new MultivariateGCD.lVandermondeSystem(this.sparseUnivarDegrees[i], this.univarSkeleton.get(this.sparseUnivarDegrees[i]), this.powers, this.variable == -1 ? this.factory.nVariables - 1 : this.variable - 1);
            }
            for (i = 0; i < this.requiredNumberOfEvaluations; ++i) {
                int j;
                int raiseFactor = i + 1;
                long lastVarValue = newPoint;
                if (this.variable == -1) {
                    lastVarValue = this.ring.powMod(lastVarValue, raiseFactor);
                }
                UnivariatePolynomial<UnivariatePolynomialZp64> aBivar = UnivariatePolynomial.zero(Rings.UnivariateRingZp64(this.ring));
                UnivariatePolynomial<UnivariatePolynomialZp64> bBivar = UnivariatePolynomial.zero(Rings.UnivariateRingZp64(this.ring));
                for (j = 0; j < this.aEvals.length; ++j) {
                    aBivar.set(j, this.aEvals[j].evaluate(raiseFactor, lastVarValue));
                    if (aBivar.get(j).degree() == this.a.get(j).degree(0)) continue;
                    return null;
                }
                for (j = 0; j < this.bEvals.length; ++j) {
                    bBivar.set(j, this.bEvals[j].evaluate(raiseFactor, lastVarValue));
                    if (bBivar.get(j).degree() == this.b.get(j).degree(0)) continue;
                    return null;
                }
                UnivariatePolynomialZp64 resUnivar = UnivariateResultants.Resultant(aBivar, bBivar);
                if (!this.univarSkeleton.keySet().containsAll(resUnivar.exponents())) {
                    return null;
                }
                boolean allDone = true;
                for (MultivariateGCD.lVandermondeSystem system : systems) {
                    if (system.nEquations() >= system.nUnknownVariables()) continue;
                    long rhs = resUnivar.degree() < system.univarDegree ? 0L : resUnivar.get(system.univarDegree);
                    system.oneMoreEquation(rhs);
                    if (system.nEquations() >= system.nUnknownVariables()) continue;
                    allDone = false;
                }
                if (allDone) break;
            }
            for (MultivariateGCD.lVandermondeSystem system : systems) {
                LinearSolver.SystemInfo info = system.solve();
                if (info == LinearSolver.SystemInfo.Consistent) continue;
                return null;
            }
            MultivariatePolynomialZp64 resVal = this.factory.createZero();
            for (MultivariateGCD.lVandermondeSystem system : systems) {
                for (int i2 = 0; i2 < system.skeleton.length; ++i2) {
                    MonomialZp64 degreeVector = (MonomialZp64)system.skeleton[i2].set(0, system.univarDegree);
                    long value = system.solution[i2];
                    resVal.add(degreeVector.setCoefficient(value));
                }
            }
            return resVal;
        }
    }

    static final class SparseInterpolationE<E> {
        final Ring<E> ring;
        final int variable;
        final UnivariatePolynomial<MultivariatePolynomial<E>> a;
        final UnivariatePolynomial<MultivariatePolynomial<E>> b;
        final Set<DegreeVector> globalSkeleton;
        final TIntObjectHashMap<MultivariatePolynomial<E>> univarSkeleton;
        final int[] sparseUnivarDegrees;
        final int[] evaluationVariables;
        final E[] evaluationPoint;
        final MultivariatePolynomial.PrecomputedPowersHolder<E> powers;
        final MultivariateGCD.ZippelEvaluations<E>[] aEvals;
        final MultivariateGCD.ZippelEvaluations<E>[] bEvals;
        final int requiredNumberOfEvaluations;
        final RandomGenerator rnd;
        final MultivariatePolynomial<E> factory;

        SparseInterpolationE(Ring<E> ring, int variable, UnivariatePolynomial<MultivariatePolynomial<E>> a, UnivariatePolynomial<MultivariatePolynomial<E>> b, Set<DegreeVector> globalSkeleton, TIntObjectHashMap<MultivariatePolynomial<E>> univarSkeleton, int[] sparseUnivarDegrees, int[] evaluationVariables, E[] evaluationPoint, MultivariatePolynomial.PrecomputedPowersHolder<E> powers, int expectedNumberOfEvaluations, int requiredNumberOfEvaluations, RandomGenerator rnd) {
            int i;
            this.ring = ring;
            this.variable = variable;
            this.a = a;
            this.b = b;
            this.globalSkeleton = globalSkeleton;
            this.univarSkeleton = univarSkeleton;
            this.sparseUnivarDegrees = sparseUnivarDegrees;
            this.evaluationPoint = evaluationPoint;
            this.aEvals = new MultivariateGCD.ZippelEvaluations[a.degree() + 1];
            this.bEvals = new MultivariateGCD.ZippelEvaluations[b.degree() + 1];
            for (i = 0; i < this.aEvals.length; ++i) {
                this.aEvals[i] = MultivariateGCD.createEvaluations(a.get(i), evaluationVariables, evaluationPoint, powers, expectedNumberOfEvaluations);
            }
            for (i = 0; i < this.bEvals.length; ++i) {
                this.bEvals[i] = MultivariateGCD.createEvaluations(b.get(i), evaluationVariables, evaluationPoint, powers, expectedNumberOfEvaluations);
            }
            this.evaluationVariables = evaluationVariables;
            this.powers = powers;
            this.requiredNumberOfEvaluations = requiredNumberOfEvaluations;
            this.rnd = rnd;
            this.factory = a.lc();
        }

        public final MultivariatePolynomial<E> evaluate() {
            return this.evaluate(this.evaluationPoint[this.evaluationPoint.length - 1]);
        }

        public final MultivariatePolynomial<E> evaluate(E newPoint) {
            this.evaluationPoint[this.evaluationPoint.length - 1] = newPoint;
            this.powers.set(this.evaluationVariables[this.evaluationVariables.length - 1], newPoint);
            return this.evaluate0(newPoint);
        }

        private MultivariatePolynomial<E> evaluate0(E newPoint) {
            int i;
            MultivariateGCD.VandermondeSystem[] systems = new MultivariateGCD.VandermondeSystem[this.sparseUnivarDegrees.length];
            for (i = 0; i < this.sparseUnivarDegrees.length; ++i) {
                systems[i] = new MultivariateGCD.VandermondeSystem<E>(this.sparseUnivarDegrees[i], this.univarSkeleton.get(this.sparseUnivarDegrees[i]), this.powers, this.variable == -1 ? this.factory.nVariables - 1 : this.variable - 1);
            }
            for (i = 0; i < this.requiredNumberOfEvaluations; ++i) {
                int j;
                int raiseFactor = i + 1;
                E lastVarValue = newPoint;
                if (this.variable == -1) {
                    lastVarValue = this.ring.pow(lastVarValue, raiseFactor);
                }
                UnivariatePolynomial<Ring<UnivariatePolynomial<E>>> aBivar = UnivariatePolynomial.zero(Rings.UnivariateRing(this.ring));
                UnivariatePolynomial<Ring<UnivariatePolynomial<E>>> bBivar = UnivariatePolynomial.zero(Rings.UnivariateRing(this.ring));
                for (j = 0; j < this.aEvals.length; ++j) {
                    aBivar.set(j, (Ring<UnivariatePolynomial<E>>)((Object)this.aEvals[j].evaluate(raiseFactor, lastVarValue)));
                    if (((UnivariatePolynomial)((Object)aBivar.get(j))).degree() == this.a.get(j).degree(0)) continue;
                    return null;
                }
                for (j = 0; j < this.bEvals.length; ++j) {
                    bBivar.set(j, (Ring<UnivariatePolynomial<E>>)((Object)this.bEvals[j].evaluate(raiseFactor, lastVarValue)));
                    if (((UnivariatePolynomial)((Object)bBivar.get(j))).degree() == this.b.get(j).degree(0)) continue;
                    return null;
                }
                UnivariatePolynomial resUnivar = (UnivariatePolynomial)((Object)UnivariateResultants.Resultant(aBivar, bBivar));
                if (!this.univarSkeleton.keySet().containsAll(resUnivar.exponents())) {
                    return null;
                }
                boolean allDone = true;
                for (MultivariateGCD.VandermondeSystem system : systems) {
                    if (system.nEquations() >= system.nUnknownVariables()) continue;
                    E rhs = resUnivar.degree() < system.univarDegree ? this.ring.getZero() : resUnivar.get(system.univarDegree);
                    system.oneMoreEquation(rhs);
                    if (system.nEquations() >= system.nUnknownVariables()) continue;
                    allDone = false;
                }
                if (allDone) break;
            }
            for (MultivariateGCD.VandermondeSystem system : systems) {
                LinearSolver.SystemInfo info = system.solve();
                if (info == LinearSolver.SystemInfo.Consistent) continue;
                return null;
            }
            IPolynomial resVal = this.factory.createZero();
            for (MultivariateGCD.VandermondeSystem system : systems) {
                for (int i2 = 0; i2 < system.skeleton.length; ++i2) {
                    Monomial degreeVector = (Monomial)system.skeleton[i2].set(0, system.univarDegree);
                    Object value = system.solution[i2];
                    ((AMultivariatePolynomial)resVal).add(degreeVector.setCoefficient(value));
                }
            }
            return resVal;
        }
    }
}

