/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.multivar;

import cc.redberry.rings.Ring;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.poly.IPolynomial;
import cc.redberry.rings.poly.MachineArithmetic;
import cc.redberry.rings.poly.PolynomialFactorDecomposition;
import cc.redberry.rings.poly.Util;
import cc.redberry.rings.poly.multivar.AMonomial;
import cc.redberry.rings.poly.multivar.AMultivariatePolynomial;
import cc.redberry.rings.poly.multivar.Conversions64bit;
import cc.redberry.rings.poly.multivar.DegreeVector;
import cc.redberry.rings.poly.multivar.IMonomialAlgebra;
import cc.redberry.rings.poly.multivar.Monomial;
import cc.redberry.rings.poly.multivar.MonomialSet;
import cc.redberry.rings.poly.multivar.MonomialZp64;
import cc.redberry.rings.poly.multivar.MultivariateDivision;
import cc.redberry.rings.poly.multivar.MultivariateFactorization;
import cc.redberry.rings.poly.multivar.MultivariateGCD;
import cc.redberry.rings.poly.multivar.MultivariatePolynomial;
import cc.redberry.rings.poly.multivar.MultivariatePolynomialZp64;
import cc.redberry.rings.poly.univar.IUnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariateSquareFreeFactorization;
import java.util.Arrays;
import java.util.Comparator;

public final class MultivariateSquareFreeFactorization {
    private MultivariateSquareFreeFactorization() {
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> PolynomialFactorDecomposition<Poly> SquareFreeFactorization(Poly poly) {
        if (poly.isOverFiniteField()) {
            return MultivariateSquareFreeFactorization.SquareFreeFactorizationBernardin(poly);
        }
        if (MultivariateGCD.isOverPolynomialRing(poly)) {
            return MultivariateFactorization.tryNested(poly, MultivariateSquareFreeFactorization::SquareFreeFactorization);
        }
        if (poly.coefficientRingCharacteristic().isZero()) {
            return MultivariateSquareFreeFactorization.SquareFreeFactorizationYunZeroCharacteristics(poly);
        }
        return MultivariateSquareFreeFactorization.SquareFreeFactorizationBernardin(poly);
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> boolean isSquareFree(Poly poly) {
        return MultivariateGCD.PolynomialGCD(poly, poly.derivative()).isConstant();
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly SquareFreePart(Poly poly) {
        return (Poly)MultivariateSquareFreeFactorization.SquareFreeFactorization(poly).factors.stream().filter(x -> !x.isMonomial()).reduce((AMultivariatePolynomial)poly.createOne(), IPolynomial::multiply);
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> void addMonomial(PolynomialFactorDecomposition<Poly> decomposition, Poly poly) {
        assert (((AMultivariatePolynomial)poly).isMonomial());
        decomposition.addUnit((AMultivariatePolynomial)poly.lcAsPoly());
        poly = (AMultivariatePolynomial)poly.monic();
        Object term = ((AMultivariatePolynomial)poly).lt();
        IMonomialAlgebra mAlgebra = ((AMultivariatePolynomial)poly).monomialAlgebra;
        for (int i = 0; i < ((AMultivariatePolynomial)poly).nVariables; ++i) {
            if (((AMonomial)term).exponents[i] <= 0) continue;
            decomposition.addFactor((AMultivariatePolynomial)((AMultivariatePolynomial)poly).create(((AMonomial)mAlgebra.getUnitTerm(((AMultivariatePolynomial)poly).nVariables)).set(i, 1)), ((AMonomial)term).exponents[i]);
        }
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> PolynomialFactorDecomposition<Poly> factorUnivariate(Poly poly) {
        int var = poly.univariateVariable();
        return UnivariateSquareFreeFactorization.SquareFreeFactorization(poly.asUnivariate()).mapTo(p -> AMultivariatePolynomial.asMultivariate((IUnivariatePolynomial)p, poly.nVariables, var, poly.ordering));
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly[] reduceContent(Poly poly) {
        Term monomialContent = ((AMultivariatePolynomial)poly).monomialContent();
        poly = ((AMultivariatePolynomial)poly).divideOrNull(monomialContent);
        IPolynomial constantContent = (AMultivariatePolynomial)poly.contentAsPoly();
        if (poly.signumOfLC() < 0) {
            constantContent = constantContent.negate();
        }
        poly = poly.divideByLC((AMultivariatePolynomial)constantContent);
        return (AMultivariatePolynomial[])poly.createArray(constantContent, ((AMultivariatePolynomial)poly).create(monomialContent));
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> PolynomialFactorDecomposition<Poly> SquareFreeFactorizationYunZeroCharacteristics(Poly poly) {
        if (!poly.coefficientRingCharacteristic().isZero()) {
            throw new IllegalArgumentException("Characteristics 0 expected");
        }
        if (poly.isEffectiveUnivariate()) {
            return MultivariateSquareFreeFactorization.factorUnivariate(poly);
        }
        Poly original = poly;
        poly = poly.clone();
        AMultivariatePolynomial[] content = MultivariateSquareFreeFactorization.reduceContent(poly);
        PolynomialFactorDecomposition<AMultivariatePolynomial> decomposition = PolynomialFactorDecomposition.unit(content[0]);
        MultivariateSquareFreeFactorization.addMonomial(decomposition, content[1]);
        MultivariateSquareFreeFactorization.SquareFreeFactorizationYun0(poly, decomposition);
        if (Util.isOverSimpleNumberField(poly)) {
            decomposition.setLcFrom(original);
        }
        return decomposition;
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> void SquareFreeFactorizationYun0(Poly poly, PolynomialFactorDecomposition<Poly> factorization) {
        int i;
        AMultivariatePolynomial[] derivative = poly.derivative();
        AMultivariatePolynomial[] gcd = MultivariateGCD.PolynomialGCD(poly, derivative);
        if (gcd.isConstant()) {
            factorization.addFactor((AMultivariatePolynomial[])poly, 1);
            return;
        }
        AMultivariatePolynomial[] quot = MultivariateDivision.divideExact(poly, gcd);
        AMultivariatePolynomial[] dQuot = (AMultivariatePolynomial[])poly.createArray(derivative.length);
        for (i = 0; i < derivative.length; ++i) {
            dQuot[i] = MultivariateDivision.divideExact(derivative[i], gcd);
        }
        i = 0;
        while (!quot.isConstant()) {
            ++i;
            AMultivariatePolynomial[] qd = quot.derivative();
            for (int j = 0; j < derivative.length; ++j) {
                dQuot[j] = dQuot[j].subtract(qd[j]);
            }
            AMultivariatePolynomial[] factor = MultivariateGCD.PolynomialGCD(quot, dQuot);
            quot = MultivariateDivision.divideExact(quot, factor);
            for (int j = 0; j < derivative.length; ++j) {
                dQuot[j] = MultivariateDivision.divideExact(dQuot[j], factor);
            }
            if (factor.isOne()) continue;
            factorization.addFactor(factor, i);
        }
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> PolynomialFactorDecomposition<Poly> SquareFreeFactorizationMusserZeroCharacteristics(Poly poly) {
        if (!poly.coefficientRingCharacteristic().isZero()) {
            throw new IllegalArgumentException("Characteristics 0 expected");
        }
        if (poly.isEffectiveUnivariate()) {
            return MultivariateSquareFreeFactorization.factorUnivariate(poly);
        }
        poly = poly.clone();
        AMultivariatePolynomial[] content = MultivariateSquareFreeFactorization.reduceContent(poly);
        PolynomialFactorDecomposition<AMultivariatePolynomial> decomposition = PolynomialFactorDecomposition.unit(content[0]);
        MultivariateSquareFreeFactorization.addMonomial(decomposition, content[1]);
        MultivariateSquareFreeFactorization.SquareFreeFactorizationMusserZeroCharacteristics0(poly, decomposition);
        return decomposition;
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> void SquareFreeFactorizationMusserZeroCharacteristics0(Poly poly, PolynomialFactorDecomposition<Poly> factorization) {
        AMultivariatePolynomial[] derivative = poly.derivative();
        AMultivariatePolynomial[] gcd = MultivariateGCD.PolynomialGCD(poly, derivative);
        if (gcd.isConstant()) {
            factorization.addFactor((AMultivariatePolynomial[])poly, 1);
            return;
        }
        AMultivariatePolynomial[] quot = MultivariateDivision.divideExact(poly, gcd);
        int i = 0;
        while (true) {
            ++i;
            AMultivariatePolynomial[] nextQuot = MultivariateGCD.PolynomialGCD(gcd, quot);
            gcd = MultivariateDivision.divideExact(gcd, nextQuot);
            AMultivariatePolynomial[] factor = MultivariateDivision.divideExact(quot, nextQuot);
            if (!factor.isConstant()) {
                factorization.addFactor(factor, i);
            }
            if (nextQuot.isConstant()) break;
            quot = nextQuot;
        }
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> PolynomialFactorDecomposition<Poly> SquareFreeFactorizationBernardin(Poly poly) {
        if (poly.coefficientRingCharacteristic().isZero()) {
            throw new IllegalArgumentException("Positive characteristic expected");
        }
        if (Conversions64bit.canConvertToZp64(poly)) {
            return MultivariateSquareFreeFactorization.SquareFreeFactorizationBernardin(Conversions64bit.asOverZp64(poly)).mapTo(Conversions64bit::convertFromZp64);
        }
        if (((AMultivariatePolynomial)poly).isEffectiveUnivariate()) {
            return MultivariateSquareFreeFactorization.factorUnivariate(poly);
        }
        poly = ((AMultivariatePolynomial)poly).clone();
        AMultivariatePolynomial[] content = MultivariateSquareFreeFactorization.reduceContent(poly);
        AMultivariatePolynomial lc = (AMultivariatePolynomial)poly.lcAsPoly();
        PolynomialFactorDecomposition<Object> fct = MultivariateSquareFreeFactorization.SquareFreeFactorizationBernardin0(poly);
        MultivariateSquareFreeFactorization.addMonomial(fct, content[1]);
        return fct.addFactor((Object)content[0], 1).addFactor((Object)lc, 1);
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> PolynomialFactorDecomposition<Poly> SquareFreeFactorizationBernardin0(Poly poly) {
        poly.monic();
        if (poly.isConstant()) {
            return PolynomialFactorDecomposition.unit(poly);
        }
        if (poly.degree() <= 1) {
            return PolynomialFactorDecomposition.of(poly);
        }
        AMultivariatePolynomial[] derivative = poly.derivative();
        if (!Arrays.stream(derivative).allMatch(IPolynomial::isZero)) {
            AMultivariatePolynomial[] gcd = MultivariateGCD.PolynomialGCD(poly, derivative);
            if (gcd.isConstant()) {
                return PolynomialFactorDecomposition.of(poly);
            }
            AMultivariatePolynomial[] quot = MultivariateDivision.divideExact(poly, gcd);
            PolynomialFactorDecomposition<AMultivariatePolynomial> result = PolynomialFactorDecomposition.unit((AMultivariatePolynomial)poly.createOne());
            int i = 0;
            while (true) {
                ++i;
                AMultivariatePolynomial[] nextQuot = MultivariateGCD.PolynomialGCD(gcd, quot);
                AMultivariatePolynomial[] factor = MultivariateDivision.divideExact(quot, nextQuot);
                if (!factor.isConstant()) {
                    result.addFactor((AMultivariatePolynomial)factor.monic(), i);
                }
                gcd = MultivariateDivision.divideExact(gcd, nextQuot);
                if (nextQuot.isConstant()) break;
                quot = nextQuot;
            }
            if (!gcd.isConstant()) {
                gcd = MultivariateSquareFreeFactorization.pRoot(gcd);
                PolynomialFactorDecomposition<AMultivariatePolynomial[]> gcdFactorization = MultivariateSquareFreeFactorization.SquareFreeFactorizationBernardin0(gcd);
                gcdFactorization.raiseExponents(poly.coefficientRingCharacteristic().intValueExact());
                result.addAll(gcdFactorization);
                return result;
            }
            return result;
        }
        Poly pRoot = MultivariateSquareFreeFactorization.pRoot(poly);
        PolynomialFactorDecomposition<AMultivariatePolynomial> fd = MultivariateSquareFreeFactorization.SquareFreeFactorizationBernardin0(pRoot);
        fd.raiseExponents(poly.coefficientRingCharacteristic().intValueExact());
        return fd.setUnit((AMultivariatePolynomial)poly.createOne());
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly pRoot(Poly poly) {
        if (poly instanceof MultivariatePolynomial) {
            return (Poly)MultivariateSquareFreeFactorization.pRoot((MultivariatePolynomial)poly);
        }
        if (poly instanceof MultivariatePolynomialZp64) {
            return (Poly)MultivariateSquareFreeFactorization.pRoot((MultivariatePolynomialZp64)poly);
        }
        throw new RuntimeException();
    }

    private static <E> MultivariatePolynomial<E> pRoot(MultivariatePolynomial<E> poly) {
        Ring ring = poly.ring;
        BigInteger inverseFactor = ring.cardinality().divide(ring.characteristic());
        int modulus = poly.coefficientRingCharacteristic().intValueExact();
        MonomialSet pRoot = new MonomialSet((Comparator<? super DegreeVector>)((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)poly.ordering)));
        for (Monomial monomial : poly) {
            int[] exponents = (int[])monomial.exponents.clone();
            for (int i = 0; i < exponents.length; ++i) {
                assert (exponents[i] % modulus == 0);
                exponents[i] = exponents[i] / modulus;
            }
            poly.add(pRoot, new Monomial(exponents, ring.pow(monomial.coefficient, inverseFactor)));
        }
        return (MultivariatePolynomial)poly.create(pRoot);
    }

    private static MultivariatePolynomialZp64 pRoot(MultivariatePolynomialZp64 poly) {
        assert (!poly.ring.isPerfectPower());
        int modulus = MachineArithmetic.safeToInt(poly.ring.modulus);
        MonomialSet<MonomialZp64> pRoot = new MonomialSet<MonomialZp64>((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)poly.ordering));
        for (MonomialZp64 term : poly) {
            int[] exponents = (int[])term.exponents.clone();
            for (int i = 0; i < exponents.length; ++i) {
                assert (exponents[i] % modulus == 0);
                exponents[i] = exponents[i] / modulus;
            }
            poly.add(pRoot, (MonomialZp64)term.setDegreeVector(exponents));
        }
        return (MultivariatePolynomialZp64)poly.create(pRoot);
    }
}

