/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.multivar;

import cc.redberry.rings.poly.multivar.AMonomial;
import cc.redberry.rings.poly.multivar.AMultivariatePolynomial;
import cc.redberry.rings.poly.multivar.DegreeVector;
import java.util.Comparator;
import java.util.Iterator;

public final class PairedIterator<Term1 extends AMonomial<Term1>, Poly1 extends AMultivariatePolynomial<Term1, Poly1>, Term2 extends AMonomial<Term2>, Poly2 extends AMultivariatePolynomial<Term2, Poly2>> {
    final Term1 zeroTerm1;
    final Term2 zeroTerm2;
    final Comparator<DegreeVector> ordering;
    final Iterator<Term1> aIterator;
    final Iterator<Term2> bIterator;
    public Term1 aTerm = null;
    public Term2 bTerm = null;
    private Term1 aTermCached = null;
    private Term2 bTermCached = null;

    public PairedIterator(Poly1 a, Poly2 b) {
        this.zeroTerm1 = ((AMultivariatePolynomial)a).monomialAlgebra.getZeroTerm(((AMultivariatePolynomial)a).nVariables);
        this.zeroTerm2 = ((AMultivariatePolynomial)b).monomialAlgebra.getZeroTerm(((AMultivariatePolynomial)b).nVariables);
        this.ordering = ((AMultivariatePolynomial)a).ordering;
        this.aIterator = ((AMultivariatePolynomial)a).iterator();
        this.bIterator = ((AMultivariatePolynomial)b).iterator();
    }

    public boolean hasNext() {
        return this.aIterator.hasNext() || this.bIterator.hasNext() || this.aTermCached != null || this.bTermCached != null;
    }

    public void advance() {
        if (this.aTermCached != null) {
            this.aTerm = this.aTermCached;
            this.aTermCached = null;
        } else {
            Object object = this.aTerm = this.aIterator.hasNext() ? (AMonomial)this.aIterator.next() : this.zeroTerm1;
        }
        if (this.bTermCached != null) {
            this.bTerm = this.bTermCached;
            this.bTermCached = null;
        } else {
            this.bTerm = this.bIterator.hasNext() ? (AMonomial)this.bIterator.next() : this.zeroTerm2;
        }
        int c = this.ordering.compare((DegreeVector)this.aTerm, (DegreeVector)this.bTerm);
        if (c < 0 && this.aTerm != this.zeroTerm1) {
            this.bTermCached = this.bTerm;
            this.bTerm = this.zeroTerm2;
        } else if (c > 0 && this.bTerm != this.zeroTerm2) {
            this.aTermCached = this.aTerm;
            this.aTerm = this.zeroTerm1;
        }
    }
}

