/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.univar;

import cc.redberry.rings.poly.IPolynomial;
import cc.redberry.rings.poly.univar.IUnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariateDivision;
import cc.redberry.rings.poly.univar.UnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariatePolynomialArithmetic;
import cc.redberry.rings.poly.univar.UnivariatePolynomialZp64;
import java.util.ArrayList;

public final class ModularComposition {
    private ModularComposition() {
    }

    public static <T extends IUnivariatePolynomial<T>> ArrayList<T> xPowers(T polyModulus, UnivariateDivision.InverseModMonomial<T> invMod) {
        return ModularComposition.polyPowers(UnivariatePolynomialArithmetic.createMonomialMod(polyModulus.coefficientRingCardinality(), polyModulus, invMod), polyModulus, invMod, polyModulus.degree());
    }

    public static <T extends IUnivariatePolynomial<T>> ArrayList<T> polyPowers(T poly, T polyModulus, UnivariateDivision.InverseModMonomial<T> invMod, int nIterations) {
        ArrayList exponents = new ArrayList();
        ModularComposition.polyPowers(UnivariatePolynomialArithmetic.polyMod(poly, polyModulus, invMod, true), polyModulus, invMod, nIterations, exponents);
        return exponents;
    }

    private static <T extends IUnivariatePolynomial<T>> void polyPowers(T polyReduced, T polyModulus, UnivariateDivision.InverseModMonomial<T> invMod, int nIterations, ArrayList<T> exponents) {
        exponents.add((IUnivariatePolynomial)polyReduced.createOne());
        IPolynomial base = polyReduced.clone();
        exponents.add(base);
        IPolynomial prev = base;
        for (int i = 0; i < nIterations; ++i) {
            prev = UnivariatePolynomialArithmetic.polyMod((IUnivariatePolynomial)prev.clone().multiply(base), polyModulus, invMod, false);
            exponents.add(prev);
        }
    }

    public static UnivariatePolynomialZp64 powModulusMod(UnivariatePolynomialZp64 poly, UnivariatePolynomialZp64 polyModulus, UnivariateDivision.InverseModMonomial<UnivariatePolynomialZp64> invMod, ArrayList<UnivariatePolynomialZp64> xPowers) {
        poly = UnivariatePolynomialArithmetic.polyMod(poly, polyModulus, invMod, true);
        return ModularComposition.powModulusMod0(poly, polyModulus, invMod, xPowers);
    }

    private static UnivariatePolynomialZp64 powModulusMod0(UnivariatePolynomialZp64 poly, UnivariatePolynomialZp64 polyModulus, UnivariateDivision.InverseModMonomial<UnivariatePolynomialZp64> invMod, ArrayList<UnivariatePolynomialZp64> xPowers) {
        UnivariatePolynomialZp64 res = (UnivariatePolynomialZp64)poly.createZero();
        for (int i = poly.degree; i >= 0; --i) {
            if (poly.data[i] == 0L) continue;
            res.addMul(xPowers.get(i), poly.data[i]);
        }
        return UnivariatePolynomialArithmetic.polyMod(res, polyModulus, invMod, false);
    }

    public static <E> UnivariatePolynomial<E> powModulusMod(UnivariatePolynomial<E> poly, UnivariatePolynomial<E> polyModulus, UnivariateDivision.InverseModMonomial<UnivariatePolynomial<E>> invMod, ArrayList<UnivariatePolynomial<E>> xPowers) {
        poly = UnivariatePolynomialArithmetic.polyMod(poly, polyModulus, invMod, true);
        return ModularComposition.powModulusMod0(poly, polyModulus, invMod, xPowers);
    }

    private static <E> UnivariatePolynomial<E> powModulusMod0(UnivariatePolynomial<E> poly, UnivariatePolynomial<E> polyModulus, UnivariateDivision.InverseModMonomial<UnivariatePolynomial<E>> invMod, ArrayList<UnivariatePolynomial<E>> xPowers) {
        IPolynomial res = poly.createZero();
        for (int i = poly.degree; i >= 0; --i) {
            if (poly.ring.isZero(poly.data[i])) continue;
            ((UnivariatePolynomial)res).addMul(xPowers.get(i), poly.data[i]);
        }
        return UnivariatePolynomialArithmetic.polyMod(res, polyModulus, invMod, false);
    }

    public static <T extends IUnivariatePolynomial<T>> T powModulusMod(T poly, T polyModulus, UnivariateDivision.InverseModMonomial<T> invMod, ArrayList<T> xPowers) {
        if (poly instanceof UnivariatePolynomialZp64) {
            return (T)ModularComposition.powModulusMod((UnivariatePolynomialZp64)poly, (UnivariatePolynomialZp64)polyModulus, invMod, xPowers);
        }
        if (poly instanceof UnivariatePolynomial) {
            return (T)ModularComposition.powModulusMod((UnivariatePolynomial)poly, (UnivariatePolynomial)polyModulus, invMod, xPowers);
        }
        throw new RuntimeException();
    }

    private static <T extends IUnivariatePolynomial<T>> T powModulusMod0(T poly, T polyModulus, UnivariateDivision.InverseModMonomial<T> invMod, ArrayList<T> xPowers) {
        if (poly instanceof UnivariatePolynomialZp64) {
            return (T)ModularComposition.powModulusMod0((UnivariatePolynomialZp64)poly, (UnivariatePolynomialZp64)polyModulus, invMod, xPowers);
        }
        if (poly instanceof UnivariatePolynomial) {
            return (T)ModularComposition.powModulusMod0((UnivariatePolynomial)poly, (UnivariatePolynomial)polyModulus, invMod, xPowers);
        }
        throw new RuntimeException();
    }

    public static <T extends IUnivariatePolynomial<T>> T compositionBrentKung(T poly, ArrayList<T> pointPowers, T polyModulus, UnivariateDivision.InverseModMonomial<T> invMod, int tBrentKung) {
        if (poly.isConstant()) {
            return poly;
        }
        ArrayList<T> gj = new ArrayList<T>();
        int degree = poly.degree();
        int i = 0;
        while (i <= degree) {
            int to = i + tBrentKung;
            if (to > degree + 1) {
                to = degree + 1;
            }
            T g = poly.getRange(i, to);
            gj.add(ModularComposition.powModulusMod0(g, polyModulus, invMod, pointPowers));
            i = to;
        }
        IUnivariatePolynomial pt = (IUnivariatePolynomial)pointPowers.get(tBrentKung);
        IUnivariatePolynomial res = (IUnivariatePolynomial)poly.createZero();
        for (int i2 = gj.size() - 1; i2 >= 0; --i2) {
            res = UnivariatePolynomialArithmetic.polyMod(res.multiply(pt).add((IUnivariatePolynomial)gj.get(i2)), polyModulus, invMod, false);
        }
        return (T)res;
    }

    public static <T extends IUnivariatePolynomial<T>> T compositionBrentKung(T poly, T point, T polyModulus, UnivariateDivision.InverseModMonomial<T> invMod) {
        if (poly.isConstant()) {
            return poly;
        }
        int t = ModularComposition.safeToInt(Math.sqrt(poly.degree()));
        ArrayList<T> hPowers = ModularComposition.polyPowers(point, polyModulus, invMod, t);
        return ModularComposition.compositionBrentKung(poly, hPowers, polyModulus, invMod, t);
    }

    private static int safeToInt(double dbl) {
        if (dbl > 2.147483647E9 || dbl < -2.147483648E9) {
            throw new ArithmeticException("int overflow");
        }
        return (int)dbl;
    }

    public static UnivariatePolynomialZp64 compositionHorner(UnivariatePolynomialZp64 poly, UnivariatePolynomialZp64 point, UnivariatePolynomialZp64 polyModulus, UnivariateDivision.InverseModMonomial<UnivariatePolynomialZp64> invMod) {
        if (poly.isConstant()) {
            return poly;
        }
        UnivariatePolynomialZp64 res = (UnivariatePolynomialZp64)poly.createZero();
        for (int i = poly.degree; i >= 0; --i) {
            res = UnivariatePolynomialArithmetic.polyMod((UnivariatePolynomialZp64)res.multiply(point).addMonomial(poly.data[i], 0), polyModulus, invMod, false);
        }
        return res;
    }

    public static <T extends IUnivariatePolynomial<T>> T composition(T poly, T point, T polyModulus, UnivariateDivision.InverseModMonomial<T> invMod) {
        return ModularComposition.compositionBrentKung(poly, point, polyModulus, invMod);
    }

    public static <T extends IUnivariatePolynomial<T>> T composition(T poly, T point, T polyModulus) {
        return ModularComposition.compositionBrentKung(poly, point, polyModulus, UnivariateDivision.fastDivisionPreConditioning(point));
    }
}

