/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.univar;

import cc.redberry.rings.Ring;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.poly.IPolynomial;
import cc.redberry.rings.poly.MachineArithmetic;
import cc.redberry.rings.poly.PolynomialFactorDecomposition;
import cc.redberry.rings.poly.multivar.MultivariateSquareFreeFactorization;
import cc.redberry.rings.poly.univar.Conversions64bit;
import cc.redberry.rings.poly.univar.IUnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariateDivision;
import cc.redberry.rings.poly.univar.UnivariateFactorization;
import cc.redberry.rings.poly.univar.UnivariateGCD;
import cc.redberry.rings.poly.univar.UnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariatePolynomialZp64;
import java.util.Arrays;

public final class UnivariateSquareFreeFactorization {
    private UnivariateSquareFreeFactorization() {
    }

    public static <T extends IUnivariatePolynomial<T>> boolean isSquareFree(T poly) {
        return UnivariateGCD.PolynomialGCD(poly, poly.derivative()).isConstant();
    }

    public static <T extends IUnivariatePolynomial<T>> PolynomialFactorDecomposition<T> SquareFreeFactorization(T poly) {
        if (poly.isOverFiniteField()) {
            return UnivariateSquareFreeFactorization.SquareFreeFactorizationMusser(poly);
        }
        if (UnivariateFactorization.isOverMultivariate(poly)) {
            return UnivariateFactorization.FactorOverMultivariate((UnivariatePolynomial)poly, MultivariateSquareFreeFactorization::SquareFreeFactorization);
        }
        if (UnivariateFactorization.isOverUnivariate(poly)) {
            return UnivariateFactorization.FactorOverUnivariate((UnivariatePolynomial)poly, MultivariateSquareFreeFactorization::SquareFreeFactorization);
        }
        if (poly.coefficientRingCharacteristic().isZero()) {
            return UnivariateSquareFreeFactorization.SquareFreeFactorizationYunZeroCharacteristics(poly);
        }
        return UnivariateSquareFreeFactorization.SquareFreeFactorizationMusser(poly);
    }

    public static <T extends IUnivariatePolynomial<T>> T SquareFreePart(T poly) {
        return (T)UnivariateSquareFreeFactorization.SquareFreeFactorization(poly).factors.stream().filter(x -> !x.isMonomial()).reduce((IUnivariatePolynomial)poly.createOne(), IPolynomial::multiply);
    }

    public static <Poly extends IUnivariatePolynomial<Poly>> PolynomialFactorDecomposition<Poly> SquareFreeFactorizationYunZeroCharacteristics(Poly poly) {
        int exponent;
        if (!poly.coefficientRingCharacteristic().isZero()) {
            throw new IllegalArgumentException("Characteristics 0 expected");
        }
        if (poly.isConstant()) {
            return PolynomialFactorDecomposition.of(poly);
        }
        for (exponent = 0; exponent <= poly.degree() && poly.isZeroAt(exponent); ++exponent) {
        }
        if (exponent == 0) {
            return UnivariateSquareFreeFactorization.SquareFreeFactorizationYun0(poly);
        }
        Poly expFree = poly.getRange(exponent, poly.degree() + 1);
        PolynomialFactorDecomposition<Poly> fd = UnivariateSquareFreeFactorization.SquareFreeFactorizationYun0(expFree);
        fd.addFactor(poly.createMonomial(1), exponent);
        return fd;
    }

    static <Poly extends IUnivariatePolynomial<Poly>> PolynomialFactorDecomposition<Poly> SquareFreeFactorizationYun0(Poly poly) {
        if (poly.isConstant()) {
            return PolynomialFactorDecomposition.of(poly);
        }
        IUnivariatePolynomial content = (IUnivariatePolynomial)poly.contentAsPoly();
        if (poly.signumOfLC() < 0) {
            content = (IUnivariatePolynomial)content.negate();
        }
        if ((poly = poly.clone().divideByLC(content)).degree() <= 1) {
            return PolynomialFactorDecomposition.of(content, poly);
        }
        PolynomialFactorDecomposition<IUnivariatePolynomial> factorization = PolynomialFactorDecomposition.of(content);
        UnivariateSquareFreeFactorization.SquareFreeFactorizationYun0(poly, factorization);
        return factorization;
    }

    private static <Poly extends IUnivariatePolynomial<Poly>> void SquareFreeFactorizationYun0(Poly poly, PolynomialFactorDecomposition<Poly> factorization) {
        Poly derivative = poly.derivative();
        Poly gcd = UnivariateGCD.PolynomialGCD(poly, derivative);
        if (gcd.isConstant()) {
            factorization.addFactor(poly, 1);
            return;
        }
        IUnivariatePolynomial quot = UnivariateDivision.divideAndRemainder(poly, gcd, (boolean)false)[0];
        IUnivariatePolynomial dQuot = UnivariateDivision.divideAndRemainder(derivative, gcd, (boolean)false)[0];
        int i = 0;
        while (!quot.isConstant()) {
            ++i;
            dQuot = (IUnivariatePolynomial)dQuot.subtract(quot.derivative());
            IUnivariatePolynomial factor = UnivariateGCD.PolynomialGCD(quot, dQuot);
            quot = UnivariateDivision.divideAndRemainder((IUnivariatePolynomial)quot, (IUnivariatePolynomial)factor, (boolean)false)[0];
            dQuot = UnivariateDivision.divideAndRemainder((IUnivariatePolynomial)dQuot, (IUnivariatePolynomial)factor, (boolean)false)[0];
            if (factor.isOne()) continue;
            factorization.addFactor(factor, i);
        }
    }

    public static <Poly extends IUnivariatePolynomial<Poly>> PolynomialFactorDecomposition<Poly> SquareFreeFactorizationMusserZeroCharacteristics(Poly poly) {
        if (!poly.coefficientRingCharacteristic().isZero()) {
            throw new IllegalArgumentException("Characteristics 0 expected");
        }
        if (poly.isConstant()) {
            return PolynomialFactorDecomposition.of(poly);
        }
        IUnivariatePolynomial content = (IUnivariatePolynomial)poly.contentAsPoly();
        if (poly.signumOfLC() < 0) {
            content = (IUnivariatePolynomial)content.negate();
        }
        if ((poly = poly.clone().divideByLC(content)).degree() <= 1) {
            return PolynomialFactorDecomposition.of(content, poly);
        }
        PolynomialFactorDecomposition<IUnivariatePolynomial> factorization = PolynomialFactorDecomposition.of(content);
        UnivariateSquareFreeFactorization.SquareFreeFactorizationMusserZeroCharacteristics0(poly, factorization);
        return factorization;
    }

    private static <Poly extends IUnivariatePolynomial<Poly>> void SquareFreeFactorizationMusserZeroCharacteristics0(Poly poly, PolynomialFactorDecomposition<Poly> factorization) {
        Poly derivative = poly.derivative();
        Object gcd = UnivariateGCD.PolynomialGCD(poly, derivative);
        if (gcd.isConstant()) {
            factorization.addFactor(poly, 1);
            return;
        }
        IUnivariatePolynomial quot = UnivariateDivision.divideAndRemainder(poly, gcd, (boolean)false)[0];
        int i = 0;
        while (true) {
            ++i;
            IUnivariatePolynomial nextQuot = UnivariateGCD.PolynomialGCD(gcd, quot);
            gcd = UnivariateDivision.divideAndRemainder(gcd, (IUnivariatePolynomial)nextQuot, (boolean)false)[0];
            IUnivariatePolynomial factor = UnivariateDivision.divideAndRemainder((IUnivariatePolynomial)quot, (IUnivariatePolynomial)nextQuot, (boolean)false)[0];
            if (!factor.isConstant()) {
                factorization.addFactor(factor, i);
            }
            if (nextQuot.isConstant()) break;
            quot = nextQuot;
        }
    }

    public static <Poly extends IUnivariatePolynomial<Poly>> PolynomialFactorDecomposition<Poly> SquareFreeFactorizationMusser(Poly poly) {
        PolynomialFactorDecomposition<Object> factorization;
        int exponent;
        if (Conversions64bit.canConvertToZp64(poly)) {
            return UnivariateSquareFreeFactorization.SquareFreeFactorizationMusser(Conversions64bit.asOverZp64(poly)).mapTo(Conversions64bit::convert);
        }
        poly = poly.clone();
        IUnivariatePolynomial lc = (IUnivariatePolynomial)poly.lcAsPoly();
        if ((poly = (IUnivariatePolynomial)poly.monic()).isConstant()) {
            return PolynomialFactorDecomposition.of(lc);
        }
        if (poly.degree() <= 1) {
            return PolynomialFactorDecomposition.of(lc, poly);
        }
        for (exponent = 0; exponent <= poly.degree() && poly.isZeroAt(exponent); ++exponent) {
        }
        if (exponent == 0) {
            factorization = UnivariateSquareFreeFactorization.SquareFreeFactorizationMusser0(poly);
        } else {
            Object expFree = poly.getRange(exponent, poly.degree() + 1);
            factorization = UnivariateSquareFreeFactorization.SquareFreeFactorizationMusser0(expFree);
            factorization.addFactor(poly.createMonomial(1), exponent);
        }
        return factorization.setUnit((Object)lc);
    }

    private static <Poly extends IUnivariatePolynomial<Poly>> PolynomialFactorDecomposition<Poly> SquareFreeFactorizationMusser0(Poly poly) {
        poly.monic();
        if (poly.isConstant()) {
            return PolynomialFactorDecomposition.of(poly);
        }
        if (poly.degree() <= 1) {
            return PolynomialFactorDecomposition.of(poly);
        }
        Poly derivative = poly.derivative();
        if (!derivative.isZero()) {
            Object gcd = UnivariateGCD.PolynomialGCD(poly, derivative);
            if (gcd.isConstant()) {
                return PolynomialFactorDecomposition.of(poly);
            }
            IUnivariatePolynomial quot = UnivariateDivision.divideAndRemainder(poly, gcd, (boolean)false)[0];
            PolynomialFactorDecomposition<IUnivariatePolynomial> result = PolynomialFactorDecomposition.of((IUnivariatePolynomial)poly.createOne());
            int i = 0;
            while (true) {
                ++i;
                IUnivariatePolynomial nextQuot = UnivariateGCD.PolynomialGCD(gcd, quot);
                IUnivariatePolynomial factor = UnivariateDivision.divideAndRemainder((IUnivariatePolynomial)quot, (IUnivariatePolynomial)nextQuot, (boolean)false)[0];
                if (!factor.isConstant()) {
                    result.addFactor((IUnivariatePolynomial)factor.monic(), i);
                }
                gcd = UnivariateDivision.divideAndRemainder(gcd, (IUnivariatePolynomial)nextQuot, (boolean)false)[0];
                if (nextQuot.isConstant()) break;
                quot = nextQuot;
            }
            if (!gcd.isConstant()) {
                gcd = UnivariateSquareFreeFactorization.pRoot(gcd);
                PolynomialFactorDecomposition<Object> gcdFactorization = UnivariateSquareFreeFactorization.SquareFreeFactorizationMusser0(gcd);
                gcdFactorization.raiseExponents(poly.coefficientRingCharacteristic().intValueExact());
                result.addAll(gcdFactorization);
                return result;
            }
            return result;
        }
        Poly pRoot = UnivariateSquareFreeFactorization.pRoot(poly);
        PolynomialFactorDecomposition<IUnivariatePolynomial> fd = UnivariateSquareFreeFactorization.SquareFreeFactorizationMusser0(pRoot);
        fd.raiseExponents(poly.coefficientRingCharacteristic().intValueExact());
        return fd.setUnit((IUnivariatePolynomial)poly.createOne());
    }

    private static <Poly extends IUnivariatePolynomial<Poly>> Poly pRoot(Poly poly) {
        if (poly instanceof UnivariatePolynomialZp64) {
            return (Poly)UnivariateSquareFreeFactorization.pRoot((UnivariatePolynomialZp64)poly);
        }
        if (poly instanceof UnivariatePolynomial) {
            return (Poly)UnivariateSquareFreeFactorization.pRoot((UnivariatePolynomial)poly);
        }
        throw new RuntimeException(poly.getClass().toString());
    }

    private static UnivariatePolynomialZp64 pRoot(UnivariatePolynomialZp64 poly) {
        if (poly.ring.modulus > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too big modulus: " + poly.ring.modulus);
        }
        int modulus = MachineArithmetic.safeToInt(poly.ring.modulus);
        assert (poly.degree % modulus == 0);
        assert (!poly.ring.isPerfectPower());
        long[] rootData = new long[poly.degree / modulus + 1];
        Arrays.fill(rootData, 0L);
        for (int i = poly.degree; i >= 0; --i) {
            if (poly.data[i] == 0L) continue;
            assert (i % modulus == 0);
            rootData[i / modulus] = poly.data[i];
        }
        return poly.createFromArray(rootData);
    }

    private static <E> UnivariatePolynomial<E> pRoot(UnivariatePolynomial<E> poly) {
        if (!poly.coefficientRingCharacteristic().isInt()) {
            throw new IllegalArgumentException("Infinite or too large ring: " + poly.ring);
        }
        Ring ring = poly.ring;
        BigInteger inverseFactor = ring.cardinality().divide(ring.characteristic());
        int modulus = poly.coefficientRingCharacteristic().intValueExact();
        assert (poly.degree % modulus == 0);
        E[] rootData = poly.ring.createZeroesArray(poly.degree / modulus + 1);
        for (int i = poly.degree; i >= 0; --i) {
            if (poly.ring.isZero(poly.data[i])) continue;
            assert (i % modulus == 0);
            rootData[i / modulus] = ring.pow(poly.data[i], inverseFactor);
        }
        return poly.createFromArray(rootData);
    }
}

