/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.util;

import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.util.IntComparator;
import cc.redberry.rings.util.IntTimSort;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.math3.random.RandomGenerator;

public final class ArraysUtil {
    public static final Comparator<Object> HASH_COMPARATOR = (o1, o2) -> Integer.compare(o1.hashCode(), o2.hashCode());
    public static final Comparator<int[]> COMPARATOR = (a, b) -> {
        if (((int[])a).length != ((int[])b).length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < ((int[])a).length; ++i) {
            int c = Integer.compare(a[i], b[i]);
            if (c == 0) continue;
            return c;
        }
        return 0;
    };
    public static final Comparator<long[]> COMPARATOR_LONG = (a, b) -> {
        if (((long[])a).length != ((long[])b).length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < ((long[])a).length; ++i) {
            int c = Long.compare(a[i], b[i]);
            if (c == 0) continue;
            return c;
        }
        return 0;
    };
    public static final Comparator<Comparable[]> COMPARATOR_GENERIC = (a, b) -> {
        if (((Comparable[])a).length != ((Comparable[])b).length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < ((Comparable[])a).length; ++i) {
            int c = a[i].compareTo(b[i]);
            if (c == 0) continue;
            return c;
        }
        return 0;
    };

    private ArraysUtil() {
    }

    public static int[] flatten(int[][] array) {
        int len = 0;
        for (int[] e : array) {
            len += e.length;
        }
        int[] result = new int[len];
        int pointer = 0;
        for (int[] e : array) {
            System.arraycopy(e, 0, result, pointer, e.length);
            pointer += e.length;
        }
        return result;
    }

    public static int[] arrayOf(int val, int len) {
        int[] r = new int[len];
        Arrays.fill(r, val);
        return r;
    }

    public static long[] arrayOf(long val, int len) {
        long[] r = new long[len];
        Arrays.fill(r, val);
        return r;
    }

    public static char[] arrayOf(char val, int len) {
        char[] r = new char[len];
        Arrays.fill(r, val);
        return r;
    }

    public static <T> T[] arrayOf(T val, int len) {
        Object[] r = (Object[])Array.newInstance(val.getClass(), len);
        Arrays.fill(r, val);
        return r;
    }

    public static int[] negate(int[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = -arr[i];
        }
        return arr;
    }

    public static long[] negate(long[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = -arr[i];
        }
        return arr;
    }

    public static BigInteger[] negate(BigInteger[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = arr[i].negate();
        }
        return arr;
    }

    public static String toString(long[] a, int from, int to) {
        if (a == null) {
            return "null";
        }
        int iMax = to - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = from;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static <T> String toString(T[] a, int from, int to) {
        if (a == null) {
            return "null";
        }
        int iMax = to - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = from;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static <T> String toString(T[] a, int from, int to, Function<T, String> stringer) {
        if (a == null) {
            return "null";
        }
        int iMax = to - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = from;
        while (true) {
            b.append(stringer.apply(a[i]));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static void shuffle(int[] array, RandomGenerator rnd) {
        for (int i = 0; i < 2 * array.length; ++i) {
            ArraysUtil.swap(array, rnd.nextInt(array.length), rnd.nextInt(array.length));
        }
    }

    public static int[] getSortedDistinct(int[] values) {
        if (values.length == 0) {
            return values;
        }
        Arrays.sort(values);
        int shift = 0;
        int i = 0;
        while (i + shift + 1 < values.length) {
            if (values[i + shift] == values[i + shift + 1]) {
                ++shift;
                continue;
            }
            values[i] = values[i + shift];
            ++i;
        }
        values[i] = values[i + shift];
        return Arrays.copyOf(values, i + 1);
    }

    public static BigInteger[] getSortedDistinct(BigInteger[] values) {
        if (values.length == 0) {
            return values;
        }
        Arrays.sort(values);
        int shift = 0;
        int i = 0;
        while (i + shift + 1 < values.length) {
            if (values[i + shift].equals(values[i + shift + 1])) {
                ++shift;
                continue;
            }
            values[i] = values[i + shift];
            ++i;
        }
        values[i] = values[i + shift];
        return Arrays.copyOf(values, i + 1);
    }

    public static long[] getSortedDistinct(long[] values) {
        if (values.length == 0) {
            return values;
        }
        Arrays.sort(values);
        int shift = 0;
        int i = 0;
        while (i + shift + 1 < values.length) {
            if (values[i + shift] == values[i + shift + 1]) {
                ++shift;
                continue;
            }
            values[i] = values[i + shift];
            ++i;
        }
        values[i] = values[i + shift];
        return Arrays.copyOf(values, i + 1);
    }

    public static int[] intSetDifference(int[] main, int[] delete) {
        int bPointer = 0;
        int aPointer = 0;
        int counter = 0;
        while (aPointer < delete.length && bPointer < main.length) {
            if (delete[aPointer] == main[bPointer]) {
                ++aPointer;
                ++bPointer;
                continue;
            }
            if (delete[aPointer] < main[bPointer]) {
                ++aPointer;
                continue;
            }
            if (delete[aPointer] <= main[bPointer]) continue;
            ++counter;
            ++bPointer;
        }
        int[] result = new int[counter += main.length - bPointer];
        counter = 0;
        aPointer = 0;
        bPointer = 0;
        while (aPointer < delete.length && bPointer < main.length) {
            if (delete[aPointer] == main[bPointer]) {
                ++aPointer;
                ++bPointer;
                continue;
            }
            if (delete[aPointer] < main[bPointer]) {
                ++aPointer;
                continue;
            }
            if (delete[aPointer] <= main[bPointer]) continue;
            result[counter++] = main[bPointer++];
        }
        System.arraycopy(main, bPointer, result, counter, main.length - bPointer);
        return result;
    }

    public static int[] intSetUnion(int[] a, int[] b) {
        int bPointer = 0;
        int aPointer = 0;
        int counter = 0;
        while (aPointer < a.length && bPointer < b.length) {
            if (a[aPointer] == b[bPointer]) {
                ++aPointer;
                ++bPointer;
                ++counter;
                continue;
            }
            if (a[aPointer] < b[bPointer]) {
                ++aPointer;
                ++counter;
                continue;
            }
            if (a[aPointer] <= b[bPointer]) continue;
            ++counter;
            ++bPointer;
        }
        int[] result = new int[counter += a.length - aPointer + (b.length - bPointer)];
        counter = 0;
        aPointer = 0;
        bPointer = 0;
        while (aPointer < a.length && bPointer < b.length) {
            if (a[aPointer] == b[bPointer]) {
                result[counter++] = b[bPointer];
                ++aPointer;
                ++bPointer;
                continue;
            }
            if (a[aPointer] < b[bPointer]) {
                result[counter++] = a[aPointer++];
                continue;
            }
            if (a[aPointer] <= b[bPointer]) continue;
            result[counter++] = b[bPointer++];
        }
        if (aPointer == a.length) {
            System.arraycopy(b, bPointer, result, counter, b.length - bPointer);
        } else {
            System.arraycopy(a, aPointer, result, counter, a.length - aPointer);
        }
        return result;
    }

    public static int[] insert(int[] array, int position, int value) {
        int[] newArray = new int[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, position);
        System.arraycopy(array, position, newArray, position + 1, array.length - position);
        newArray[position] = value;
        return newArray;
    }

    public static int[] insert(int[] array, int position, int value, int length) {
        if (length == 0) {
            return (int[])array.clone();
        }
        int[] newArray = new int[array.length + length];
        System.arraycopy(array, 0, newArray, 0, position);
        System.arraycopy(array, position, newArray, position + length, array.length - position);
        Arrays.fill(newArray, position, position + length, value);
        return newArray;
    }

    public static long[] insert(long[] array, int position, long value) {
        long[] newArray = new long[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, position);
        System.arraycopy(array, position, newArray, position + 1, array.length - position);
        newArray[position] = value;
        return newArray;
    }

    public static <T> T[] insert(T[] array, int position, T value) {
        Object[] newArray = (Object[])Array.newInstance(value.getClass(), array.length + 1);
        System.arraycopy(array, 0, newArray, 0, position);
        System.arraycopy(array, position, newArray, position + 1, array.length - position);
        newArray[position] = value;
        return newArray;
    }

    public static void reverse(int[] array, int from, int to) {
        for (int i = 0; i < (to - from) / 2; ++i) {
            ArraysUtil.swap(array, from + i, to - 1 - i);
        }
    }

    public static void reverse(long[] array, int from, int to) {
        for (int i = 0; i < (to - from) / 2; ++i) {
            ArraysUtil.swap(array, from + i, to - 1 - i);
        }
    }

    public static <T> void reverse(T[] array, int from, int to) {
        for (int i = 0; i < (to - from) / 2; ++i) {
            ArraysUtil.swap(array, from + i, to - 1 - i);
        }
    }

    public static <T> void reverse(T[] array) {
        ArraysUtil.reverse(array, 0, array.length);
    }

    public static void reverse(int[] array) {
        ArraysUtil.reverse(array, 0, array.length);
    }

    public static void reverse(long[] array) {
        ArraysUtil.reverse(array, 0, array.length);
    }

    public static int[] short2int(short[] a) {
        int[] r = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            r[i] = a[i];
        }
        return r;
    }

    public static short[] int2short(int[] a) {
        short[] r = new short[a.length];
        for (int i = 0; i < a.length; ++i) {
            r[i] = (short)a[i];
        }
        return r;
    }

    public static int[] byte2int(byte[] a) {
        int[] r = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            r[i] = a[i];
        }
        return r;
    }

    public static short[] byte2short(byte[] a) {
        short[] r = new short[a.length];
        for (int i = 0; i < a.length; ++i) {
            r[i] = a[i];
        }
        return r;
    }

    public static byte[] int2byte(int[] a) {
        byte[] r = new byte[a.length];
        for (int i = 0; i < a.length; ++i) {
            r[i] = (byte)a[i];
        }
        return r;
    }

    public static int max(int[] array) {
        int a = Integer.MIN_VALUE;
        for (int i : array) {
            a = Math.max(a, i);
        }
        return a;
    }

    public static long max(long[] array) {
        long a = Long.MIN_VALUE;
        for (long i : array) {
            a = Math.max(a, i);
        }
        return a;
    }

    public static int max(int[] array, int from, int to) {
        int a = Integer.MIN_VALUE;
        for (int i = from; i < to; ++i) {
            a = Math.max(a, array[i]);
        }
        return a;
    }

    public static int[] max(int[] a, int[] b) {
        int[] r = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            r[i] = Math.max(a[i], b[i]);
        }
        return r;
    }

    public static int min(int[] array) {
        int a = Integer.MAX_VALUE;
        for (int i : array) {
            a = Math.min(a, i);
        }
        return a;
    }

    public static long min(long[] array) {
        long a = Long.MAX_VALUE;
        for (long i : array) {
            a = Math.min(a, i);
        }
        return a;
    }

    public static int min(int[] array, int from, int to) {
        int a = Integer.MAX_VALUE;
        for (int i = from; i < to; ++i) {
            a = Math.min(a, array[i]);
        }
        return a;
    }

    public static int[] min(int[] a, int[] b) {
        int[] r = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            r[i] = Math.min(a[i], b[i]);
        }
        return r;
    }

    public static int firstIndexOf(int element, int[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int firstIndexOf(Object element, Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (!element.equals(array[i])) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfMax(int[] array) {
        int index = 0;
        int max = array[index];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] <= max) continue;
            max = array[i];
            index = i;
        }
        return index;
    }

    public static int[] sequence(int size) {
        return ArraysUtil.sequence(0, size);
    }

    public static int[] sequence(int from, int to) {
        int[] ret = new int[to - from];
        for (int i = ret.length - 1; i >= 0; --i) {
            ret[i] = from + i;
        }
        return ret;
    }

    public static int[][] deepClone(int[][] input) {
        int[][] res = new int[input.length][];
        for (int i = res.length - 1; i >= 0; --i) {
            res[i] = (int[])input[i].clone();
        }
        return res;
    }

    public static Object[][] deepClone(Object[][] input) {
        Object[][] res = new Object[input.length][];
        for (int i = res.length - 1; i >= 0; --i) {
            res[i] = (Object[])input[i].clone();
        }
        return res;
    }

    public static int sum(int[] array) {
        return ArraysUtil.sum(array, 0, array.length);
    }

    public static int[] sum(int[] a, int[] b) {
        int[] c = new int[a.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = a[i] + b[i];
        }
        return c;
    }

    public static int[] multiply(int[] a, int[] b) {
        int[] c = new int[a.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = a[i] * b[i];
        }
        return c;
    }

    public static int[] subtract(int[] a, int[] b) {
        int[] c = new int[a.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = a[i] - b[i];
        }
        return c;
    }

    public static int sum(int[] array, int from) {
        return ArraysUtil.sum(array, from, array.length);
    }

    public static int sum(int[] array, int from, int to) {
        int s = 0;
        for (int i = from; i < to; ++i) {
            s += array[i];
        }
        return s;
    }

    public static int multiply(int[] array, int from, int to) {
        int s = 1;
        for (int i = from; i < to; ++i) {
            s *= array[i];
        }
        return s;
    }

    public static double multiplyToDouble(int[] array, int from, int to) {
        double s = 1.0;
        for (int i = from; i < to; ++i) {
            s *= (double)array[i];
        }
        return s;
    }

    public static double multiplyToDouble(int[] array) {
        return ArraysUtil.multiplyToDouble(array, 0, array.length);
    }

    public static double sumToDouble(int[] array, int from, int to) {
        double s = 0.0;
        for (int i = from; i < to; ++i) {
            s += (double)array[i];
        }
        return s;
    }

    public static double sumToDouble(int[] array) {
        return ArraysUtil.sumToDouble(array, 0, array.length);
    }

    public static int or(long[] array) {
        return ArraysUtil.or(array, 0, array.length);
    }

    public static int or(long[] array, int from) {
        return ArraysUtil.or(array, from, array.length);
    }

    public static int or(long[] array, int from, int to) {
        int s = 0;
        for (int i = from; i < to; ++i) {
            s = (int)((long)s | array[i]);
        }
        return s;
    }

    public static <T> int[] bijection(T[] from, T[] to, Comparator<? super T> comparator) {
        if (from.length != to.length) {
            return null;
        }
        int length = from.length;
        int[] bijection = new int[length];
        Arrays.fill(bijection, -1);
        int i = 0;
        while (i < length) {
            block4: {
                for (int j = 0; j < length; ++j) {
                    if (bijection[j] != -1 || comparator.compare(from[i], to[j]) != 0) {
                        continue;
                    }
                    break block4;
                }
                return null;
            }
            bijection[j] = i++;
        }
        return bijection;
    }

    public static <T extends Comparable<? super T>> int[] bijection(T[] from, T[] to) {
        if (from.length != to.length) {
            return null;
        }
        int length = from.length;
        int[] bijection = new int[length];
        Arrays.fill(bijection, -1);
        int i = 0;
        while (i < length) {
            block4: {
                for (int j = 0; j < length; ++j) {
                    if (bijection[j] != -1 || from[i].compareTo(to[j]) != 0) {
                        continue;
                    }
                    break block4;
                }
                return null;
            }
            bijection[j] = i++;
        }
        return bijection;
    }

    public static int[] addAll(int[] array1, int ... array2) {
        int[] r = new int[array1.length + array2.length];
        System.arraycopy(array1, 0, r, 0, array1.length);
        System.arraycopy(array2, 0, r, array1.length, array2.length);
        return r;
    }

    public static long[] addAll(long[] array1, long ... array2) {
        long[] r = new long[array1.length + array2.length];
        System.arraycopy(array1, 0, r, 0, array1.length);
        System.arraycopy(array2, 0, r, array1.length, array2.length);
        return r;
    }

    public static int[] addAll(int[] ... arrays) {
        int i;
        if (arrays.length == 0) {
            return new int[0];
        }
        int length = 0;
        for (i = 0; i < arrays.length; ++i) {
            length += arrays[i].length;
        }
        if (length == 0) {
            return new int[0];
        }
        int[] r = new int[length];
        int pointer = 0;
        for (i = 0; i < arrays.length; ++i) {
            System.arraycopy(arrays[i], 0, r, pointer, arrays[i].length);
            pointer += arrays[i].length;
        }
        return r;
    }

    public static int[] remove(int[] array, int i) {
        if (i >= array.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (array.length == 1) {
            assert (i == 0);
            return new int[0];
        }
        if (array.length == 2) {
            return new int[]{array[1 ^ i]};
        }
        int[] newArray = new int[array.length - 1];
        System.arraycopy(array, 0, newArray, 0, i);
        if (i != array.length - 1) {
            System.arraycopy(array, i + 1, newArray, i, array.length - i - 1);
        }
        return newArray;
    }

    public static long[] remove(long[] array, int i) {
        if (i >= array.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (array.length == 1) {
            assert (i == 0);
            return new long[0];
        }
        if (array.length == 2) {
            return new long[]{array[1 ^ i]};
        }
        long[] newArray = new long[array.length - 1];
        System.arraycopy(array, 0, newArray, 0, i);
        if (i != array.length - 1) {
            System.arraycopy(array, i + 1, newArray, i, array.length - i - 1);
        }
        return newArray;
    }

    public static <T> T[] remove(T[] array, int i) {
        Object[] r = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length - 1);
        System.arraycopy(array, 0, r, 0, i);
        if (i < array.length - 1) {
            System.arraycopy(array, i + 1, r, i, array.length - i - 1);
        }
        return r;
    }

    @SafeVarargs
    public static <T> T[] addAll(T[] array1, T ... array2) {
        if (array1 == null) {
            return (Object[])array2.clone();
        }
        if (array2 == null) {
            return (Object[])array1.clone();
        }
        Class<?> type1 = array1.getClass().getComponentType();
        Object[] joinedArray = (Object[])Array.newInstance(type1, array1.length + array2.length);
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        try {
            System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        }
        catch (ArrayStoreException ase) {
            Class<?> type2 = array2.getClass().getComponentType();
            if (!type1.isAssignableFrom(type2)) {
                throw new IllegalArgumentException("Cannot store " + type2.getName() + " in an array of " + type1.getName(), ase);
            }
            throw ase;
        }
        return joinedArray;
    }

    public static <T> T[] remove(T[] array, int[] positions) {
        int pointer;
        if (array == null) {
            throw new NullPointerException();
        }
        int[] p = ArraysUtil.getSortedDistinct(positions);
        if (p.length == 0) {
            return array;
        }
        int size = p.length;
        int s = array.length;
        for (pointer = 0; pointer < size; ++pointer) {
            if (p[pointer] < s) continue;
            throw new ArrayIndexOutOfBoundsException();
        }
        Class<?> type = array.getClass().getComponentType();
        Object[] r = (Object[])Array.newInstance(type, array.length - p.length);
        pointer = 0;
        int i = -1;
        for (int j = 0; j < s; ++j) {
            if (pointer < size - 1 && j > p[pointer]) {
                ++pointer;
            }
            if (j == p[pointer]) continue;
            r[++i] = array[j];
        }
        return r;
    }

    public static int[] remove(int[] array, int[] positions) {
        int pointer;
        if (array == null) {
            throw new NullPointerException();
        }
        int[] p = ArraysUtil.getSortedDistinct((int[])positions.clone());
        if (p.length == 0) {
            return array;
        }
        int size = p.length;
        int s = array.length;
        for (pointer = 0; pointer < size; ++pointer) {
            if (p[pointer] < s) continue;
            throw new ArrayIndexOutOfBoundsException();
        }
        int[] r = new int[array.length - p.length];
        pointer = 0;
        int i = -1;
        for (int j = 0; j < s; ++j) {
            if (pointer < size - 1 && j > p[pointer]) {
                ++pointer;
            }
            if (j == p[pointer]) continue;
            r[++i] = array[j];
        }
        return r;
    }

    public static long[] remove(long[] array, int[] positions) {
        int pointer;
        if (array == null) {
            throw new NullPointerException();
        }
        int[] p = ArraysUtil.getSortedDistinct((int[])positions.clone());
        if (p.length == 0) {
            return array;
        }
        int size = p.length;
        int s = array.length;
        for (pointer = 0; pointer < size; ++pointer) {
            if (p[pointer] < s) continue;
            throw new ArrayIndexOutOfBoundsException();
        }
        long[] r = new long[array.length - p.length];
        pointer = 0;
        int i = -1;
        for (int j = 0; j < s; ++j) {
            if (pointer < size - 1 && j > p[pointer]) {
                ++pointer;
            }
            if (j == p[pointer]) continue;
            r[++i] = array[j];
        }
        return r;
    }

    public static <T> T[] select(T[] array, int[] positions) {
        if (array == null) {
            throw new NullPointerException();
        }
        int[] p = ArraysUtil.getSortedDistinct(positions);
        Class<?> type = array.getClass().getComponentType();
        Object[] r = (Object[])Array.newInstance(type, p.length);
        int i = -1;
        for (int j : p) {
            r[++i] = array[j];
        }
        return r;
    }

    public static int[] select(int[] array, int[] positions) {
        if (array == null) {
            throw new NullPointerException();
        }
        int[] p = ArraysUtil.getSortedDistinct(positions);
        int[] r = new int[p.length];
        int i = -1;
        for (int j : p) {
            r[++i] = array[j];
        }
        return r;
    }

    public static int[] toArray(Set<Integer> set) {
        int i = -1;
        int[] a = new int[set.size()];
        for (Integer ii : set) {
            a[++i] = ii;
        }
        return a;
    }

    public static int binarySearch1(int[] a, int key) {
        return ArraysUtil.binarySearch1(a, 0, a.length, key);
    }

    public static int binarySearch1(int[] a, int fromIndex, int toIndex, int key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            while (mid > 0 && a[mid - 1] == a[mid]) {
                --mid;
            }
            return mid;
        }
        if (low >= a.length) {
            return low;
        }
        while (low > 0 && a[low - 1] == a[low]) {
            --low;
        }
        return low;
    }

    public static <T> int commutativeHashCode(T[] data) {
        return ArraysUtil.commutativeHashCode(data, 0, data.length);
    }

    public static <T> int commutativeHashCode(T[] data, int from, int to) {
        int r = 17;
        for (int i = from; i < to; ++i) {
            int h = data[i].hashCode();
            r *= h + 29 ^ h;
        }
        return r;
    }

    public static int commutativeHashCode(int[] data) {
        return ArraysUtil.commutativeHashCode(data, 0, data.length);
    }

    public static int commutativeHashCode(int[] data, int from, int to) {
        int r = 17;
        for (int i = from; i < to; ++i) {
            r *= data[i] + 29 ^ data[i];
        }
        return r;
    }

    public static void insertionSort(int[] target, int[] coSort) {
        ArraysUtil.insertionSort(target, 0, target.length, coSort);
    }

    public static void insertionSort(int[] target, int fromIndex, int toIndex, int[] coSort) {
        ArraysUtil.rangeCheck(target.length, fromIndex, toIndex);
        ArraysUtil.rangeCheck(coSort.length, fromIndex, toIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            int key = target[i];
            int keyC = coSort[i];
            for (int j = i; j > fromIndex && target[j - 1] > key; --j) {
                target[j] = target[j - 1];
                coSort[j] = coSort[j - 1];
            }
            target[j] = key;
            coSort[j] = keyC;
        }
    }

    public static void insertionSort(int[] target, long[] coSort) {
        ArraysUtil.insertionSort(target, 0, target.length, coSort);
    }

    public static void insertionSort(int[] target, int fromIndex, int toIndex, long[] coSort) {
        ArraysUtil.rangeCheck(target.length, fromIndex, toIndex);
        ArraysUtil.rangeCheck(coSort.length, fromIndex, toIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            int key = target[i];
            long keyC = coSort[i];
            for (int j = i; j > fromIndex && target[j - 1] > key; --j) {
                target[j] = target[j - 1];
                coSort[j] = coSort[j - 1];
            }
            target[j] = key;
            coSort[j] = keyC;
        }
    }

    public static <T extends Comparable<T>> void insertionSort(T[] target, Object[] coSort) {
        ArraysUtil.insertionSort(target, (int)0, (int)target.length, (Object[])coSort);
    }

    public static <T extends Comparable<T>> void insertionSort(T[] target, int fromIndex, int toIndex, Object[] coSort) {
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            T key = target[i];
            Object keyC = coSort[i];
            for (int j = i; j > fromIndex && target[j - 1].compareTo(key) > 0; --j) {
                target[j] = target[j - 1];
                coSort[j] = coSort[j - 1];
            }
            target[j] = key;
            coSort[j] = keyC;
        }
    }

    public static <T extends Comparable<T>> void insertionSort(T[] target, int[] coSort) {
        ArraysUtil.insertionSort(target, (int)0, (int)target.length, (int[])coSort);
    }

    public static <T extends Comparable<T>> void insertionSort(T[] target, int fromIndex, int toIndex, int[] coSort) {
        ArraysUtil.insertionSort(target, fromIndex, toIndex, coSort, Comparable::compareTo);
    }

    public static <T> void insertionSort(T[] target, int[] coSort, Comparator<T> comparator) {
        ArraysUtil.insertionSort(target, 0, target.length, coSort, comparator);
    }

    public static <T> void insertionSort(T[] target, int fromIndex, int toIndex, int[] coSort, Comparator<T> comparator) {
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            T key = target[i];
            int keyC = coSort[i];
            for (int j = i; j > fromIndex && comparator.compare(target[j - 1], key) > 0; --j) {
                target[j] = target[j - 1];
                coSort[j] = coSort[j - 1];
            }
            target[j] = key;
            coSort[j] = keyC;
        }
    }

    public static void timSort(int[] target, int[] coSort) {
        IntTimSort.sort(target, coSort);
    }

    public static void stableSort(int[] target, int[] cosort) {
        if (target.length > 100) {
            ArraysUtil.timSort(target, cosort);
        } else {
            ArraysUtil.insertionSort(target, cosort);
        }
    }

    public static int[] quickSortP(int[] target) {
        int[] permutation = new int[target.length];
        for (int i = 1; i < target.length; ++i) {
            permutation[i] = i;
        }
        ArraysUtil.quickSort(target, 0, target.length, permutation);
        return permutation;
    }

    public static void quickSort(int[] target, int[] coSort) {
        ArraysUtil.quickSort(target, 0, target.length, coSort);
    }

    public static void quickSort(int[] target, int fromIndex, int toIndex, int[] coSort) {
        ArraysUtil.rangeCheck(target.length, fromIndex, toIndex);
        ArraysUtil.rangeCheck(coSort.length, fromIndex, toIndex);
        ArraysUtil.quickSort1(target, fromIndex, toIndex - fromIndex, coSort);
    }

    public static void quickSort1(int[] target, int fromIndex, int length, int[] coSort) {
        if (target == coSort) {
            throw new IllegalArgumentException("Target reference == coSort reference.");
        }
        ArraysUtil.quickSort2(target, fromIndex, length, coSort);
    }

    private static void quickSort2(int[] target, int fromIndex, int length, int[] coSort) {
        int c;
        int a;
        if (length < 7) {
            for (int i = fromIndex; i < length + fromIndex; ++i) {
                for (int j = i; j > fromIndex && target[j - 1] > target[j]; --j) {
                    ArraysUtil.swap(target, j, j - 1, coSort);
                }
            }
            return;
        }
        int m = fromIndex + (length >> 1);
        if (length > 7) {
            int l = fromIndex;
            int n = fromIndex + length - 1;
            if (length > 40) {
                int s = length / 8;
                l = ArraysUtil.med3(target, l, l + s, l + 2 * s);
                m = ArraysUtil.med3(target, m - s, m, m + s);
                n = ArraysUtil.med3(target, n - 2 * s, n - s, n);
            }
            m = ArraysUtil.med3(target, l, m, n);
        }
        int v = target[m];
        int b = a = fromIndex;
        int d = c = fromIndex + length - 1;
        while (true) {
            if (b <= c && target[b] <= v) {
                if (target[b] == v) {
                    ArraysUtil.swap(target, a++, b, coSort);
                }
                ++b;
                continue;
            }
            while (c >= b && target[c] >= v) {
                if (target[c] == v) {
                    ArraysUtil.swap(target, c, d--, coSort);
                }
                --c;
            }
            if (b > c) break;
            ArraysUtil.swap(target, b++, c--, coSort);
        }
        int n = fromIndex + length;
        int s = Math.min(a - fromIndex, b - a);
        ArraysUtil.vecswap(target, fromIndex, b - s, s, coSort);
        s = Math.min(d - c, n - d - 1);
        ArraysUtil.vecswap(target, b, n - s, s, coSort);
        s = b - a;
        if (s > 1) {
            ArraysUtil.quickSort2(target, fromIndex, s, coSort);
        }
        if ((s = d - c) > 1) {
            ArraysUtil.quickSort2(target, n - s, s, coSort);
        }
    }

    private static void swap(int[] x, int a, int b, int[] coSort) {
        ArraysUtil.swap(x, a, b);
        ArraysUtil.swap(coSort, a, b);
    }

    public static void swap(int[] x, int a, int b) {
        int t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecswap(int[] x, int a, int b, int n, int[] coSort) {
        int i = 0;
        while (i < n) {
            ArraysUtil.swap(x, a, b, coSort);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(int[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    public static void quickSort(long[] target, long[] coSort) {
        ArraysUtil.quickSort1(target, 0, target.length, coSort);
    }

    public static void quickSort(long[] target, int fromIndex, int toIndex, long[] coSort) {
        ArraysUtil.rangeCheck(target.length, fromIndex, toIndex);
        ArraysUtil.rangeCheck(coSort.length, fromIndex, toIndex);
        ArraysUtil.quickSort1(target, fromIndex, toIndex - fromIndex, coSort);
    }

    public static void quickSort1(long[] target, int fromIndex, int length, long[] coSort) {
        int c;
        int a;
        if (length < 7) {
            for (int i = fromIndex; i < length + fromIndex; ++i) {
                for (int j = i; j > fromIndex && target[j - 1] > target[j]; --j) {
                    ArraysUtil.swap(target, j, j - 1, coSort);
                }
            }
            return;
        }
        int m = fromIndex + (length >> 1);
        if (length > 7) {
            int l = fromIndex;
            int n = fromIndex + length - 1;
            if (length > 40) {
                int s = length / 8;
                l = ArraysUtil.med3(target, l, l + s, l + 2 * s);
                m = ArraysUtil.med3(target, m - s, m, m + s);
                n = ArraysUtil.med3(target, n - 2 * s, n - s, n);
            }
            m = ArraysUtil.med3(target, l, m, n);
        }
        long v = target[m];
        int b = a = fromIndex;
        int d = c = fromIndex + length - 1;
        while (true) {
            if (b <= c && target[b] <= v) {
                if (target[b] == v) {
                    ArraysUtil.swap(target, a++, b, coSort);
                }
                ++b;
                continue;
            }
            while (c >= b && target[c] >= v) {
                if (target[c] == v) {
                    ArraysUtil.swap(target, c, d--, coSort);
                }
                --c;
            }
            if (b > c) break;
            ArraysUtil.swap(target, b++, c--, coSort);
        }
        int n = fromIndex + length;
        int s = Math.min(a - fromIndex, b - a);
        ArraysUtil.vecswap(target, fromIndex, b - s, s, coSort);
        s = Math.min(d - c, n - d - 1);
        ArraysUtil.vecswap(target, b, n - s, s, coSort);
        s = b - a;
        if (s > 1) {
            ArraysUtil.quickSort1(target, fromIndex, s, coSort);
        }
        if ((s = d - c) > 1) {
            ArraysUtil.quickSort1(target, n - s, s, coSort);
        }
    }

    private static void swap(long[] x, int a, int b, long[] coSort) {
        ArraysUtil.swap(x, a, b);
        ArraysUtil.swap(coSort, a, b);
    }

    private static void vecswap(long[] x, int a, int b, int n, long[] coSort) {
        int i = 0;
        while (i < n) {
            ArraysUtil.swap(x, a, b, coSort);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(long[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    public static void quickSort(int[] target, long[] coSort) {
        ArraysUtil.quickSort1(target, 0, target.length, coSort);
    }

    public static void quickSort(int[] target, int fromIndex, int toIndex, long[] coSort) {
        ArraysUtil.rangeCheck(target.length, fromIndex, toIndex);
        ArraysUtil.rangeCheck(coSort.length, fromIndex, toIndex);
        ArraysUtil.quickSort1(target, fromIndex, toIndex - fromIndex, coSort);
    }

    public static void quickSort1(int[] target, int fromIndex, int length, long[] coSort) {
        int c;
        int a;
        if (length < 7) {
            for (int i = fromIndex; i < length + fromIndex; ++i) {
                for (int j = i; j > fromIndex && target[j - 1] > target[j]; --j) {
                    ArraysUtil.swap(target, j, j - 1, coSort);
                }
            }
            return;
        }
        int m = fromIndex + (length >> 1);
        if (length > 7) {
            int l = fromIndex;
            int n = fromIndex + length - 1;
            if (length > 40) {
                int s = length / 8;
                l = ArraysUtil.med3(target, l, l + s, l + 2 * s);
                m = ArraysUtil.med3(target, m - s, m, m + s);
                n = ArraysUtil.med3(target, n - 2 * s, n - s, n);
            }
            m = ArraysUtil.med3(target, l, m, n);
        }
        int v = target[m];
        int b = a = fromIndex;
        int d = c = fromIndex + length - 1;
        while (true) {
            if (b <= c && target[b] <= v) {
                if (target[b] == v) {
                    ArraysUtil.swap(target, a++, b, coSort);
                }
                ++b;
                continue;
            }
            while (c >= b && target[c] >= v) {
                if (target[c] == v) {
                    ArraysUtil.swap(target, c, d--, coSort);
                }
                --c;
            }
            if (b > c) break;
            ArraysUtil.swap(target, b++, c--, coSort);
        }
        int n = fromIndex + length;
        int s = Math.min(a - fromIndex, b - a);
        ArraysUtil.vecswap(target, fromIndex, b - s, s, coSort);
        s = Math.min(d - c, n - d - 1);
        ArraysUtil.vecswap(target, b, n - s, s, coSort);
        s = b - a;
        if (s > 1) {
            ArraysUtil.quickSort1(target, fromIndex, s, coSort);
        }
        if ((s = d - c) > 1) {
            ArraysUtil.quickSort1(target, n - s, s, coSort);
        }
    }

    private static void swap(int[] x, int a, int b, long[] coSort) {
        ArraysUtil.swap(x, a, b);
        ArraysUtil.swap(coSort, a, b);
    }

    public static void swap(long[] x, int a, int b) {
        long t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecswap(int[] x, int a, int b, int n, long[] coSort) {
        int i = 0;
        while (i < n) {
            ArraysUtil.swap(x, a, b, coSort);
            ++i;
            ++a;
            ++b;
        }
    }

    public static <T extends Comparable<T>> void quickSort(T[] target, Object[] coSort) {
        ArraysUtil.quickSort(target, (int)0, (int)target.length, (Object[])coSort);
    }

    public static <T extends Comparable<T>> void quickSort(T[] target, int fromIndex, int toIndex, Object[] coSort) {
        if (target == coSort) {
            throw new IllegalArgumentException();
        }
        ArraysUtil.rangeCheck(target.length, fromIndex, toIndex);
        ArraysUtil.rangeCheck(coSort.length, fromIndex, toIndex);
        ArraysUtil.quickSort1(target, (int)fromIndex, (int)(toIndex - fromIndex), (Object[])coSort);
    }

    public static <T extends Comparable<T>> void quickSort1(T[] target, int fromIndex, int length, Object[] coSort) {
        int c;
        int a;
        if (length < 7) {
            for (int i = fromIndex; i < length + fromIndex; ++i) {
                for (int j = i; j > fromIndex && target[j - 1].compareTo(target[j]) > 0; --j) {
                    ArraysUtil.swap((Object[])target, j, j - 1, coSort);
                }
            }
            return;
        }
        int m = fromIndex + (length >> 1);
        if (length > 7) {
            int l = fromIndex;
            int n = fromIndex + length - 1;
            if (length > 40) {
                int s = length / 8;
                l = ArraysUtil.med3(target, (int)l, (int)(l + s), (int)(l + 2 * s));
                m = ArraysUtil.med3(target, (int)(m - s), (int)m, (int)(m + s));
                n = ArraysUtil.med3(target, (int)(n - 2 * s), (int)(n - s), (int)n);
            }
            m = ArraysUtil.med3(target, (int)l, (int)m, (int)n);
        }
        T v = target[m];
        int b = a = fromIndex;
        int d = c = fromIndex + length - 1;
        while (true) {
            if (b <= c && target[b].compareTo(v) <= 0) {
                if (target[b] == v) {
                    ArraysUtil.swap((Object[])target, a++, b, coSort);
                }
                ++b;
                continue;
            }
            while (c >= b && target[c].compareTo(v) >= 0) {
                if (target[c] == v) {
                    ArraysUtil.swap((Object[])target, c, d--, coSort);
                }
                --c;
            }
            if (b > c) break;
            ArraysUtil.swap((Object[])target, b++, c--, coSort);
        }
        int n = fromIndex + length;
        int s = Math.min(a - fromIndex, b - a);
        ArraysUtil.vecswap((Object[])target, fromIndex, b - s, s, coSort);
        s = Math.min(d - c, n - d - 1);
        ArraysUtil.vecswap((Object[])target, b, n - s, s, coSort);
        s = b - a;
        if (s > 1) {
            ArraysUtil.quickSort1(target, (int)fromIndex, (int)s, (Object[])coSort);
        }
        if ((s = d - c) > 1) {
            ArraysUtil.quickSort1(target, (int)(n - s), (int)s, (Object[])coSort);
        }
    }

    private static void swap(Object[] x, int a, int b, Object[] coSort) {
        ArraysUtil.swap(x, a, b);
        ArraysUtil.swap(coSort, a, b);
    }

    private static void vecswap(Object[] x, int a, int b, int n, Object[] coSort) {
        int i = 0;
        while (i < n) {
            ArraysUtil.swap(x, a, b, coSort);
            ++i;
            ++a;
            ++b;
        }
    }

    public static <T extends Comparable<T>> void quickSort(T[] target, int[] coSort) {
        ArraysUtil.quickSort(target, (int)0, (int)target.length, (int[])coSort);
    }

    public static <T extends Comparable<T>> void quickSort(T[] target, int fromIndex, int toIndex, int[] coSort) {
        ArraysUtil.rangeCheck(target.length, fromIndex, toIndex);
        ArraysUtil.rangeCheck(coSort.length, fromIndex, toIndex);
        ArraysUtil.quickSort1(target, (int)fromIndex, (int)(toIndex - fromIndex), (int[])coSort);
    }

    public static <T extends Comparable<T>> void quickSort1(T[] target, int fromIndex, int length, int[] coSort) {
        int c;
        int a;
        if (length < 7) {
            for (int i = fromIndex; i < length + fromIndex; ++i) {
                for (int j = i; j > fromIndex && target[j - 1].compareTo(target[j]) > 0; --j) {
                    ArraysUtil.swap((Object[])target, j, j - 1, coSort);
                }
            }
            return;
        }
        int m = fromIndex + (length >> 1);
        if (length > 7) {
            int l = fromIndex;
            int n = fromIndex + length - 1;
            if (length > 40) {
                int s = length / 8;
                l = ArraysUtil.med3(target, (int)l, (int)(l + s), (int)(l + 2 * s));
                m = ArraysUtil.med3(target, (int)(m - s), (int)m, (int)(m + s));
                n = ArraysUtil.med3(target, (int)(n - 2 * s), (int)(n - s), (int)n);
            }
            m = ArraysUtil.med3(target, (int)l, (int)m, (int)n);
        }
        T v = target[m];
        int b = a = fromIndex;
        int d = c = fromIndex + length - 1;
        while (true) {
            if (b <= c && target[b].compareTo(v) <= 0) {
                if (target[b] == v) {
                    ArraysUtil.swap((Object[])target, a++, b, coSort);
                }
                ++b;
                continue;
            }
            while (c >= b && target[c].compareTo(v) >= 0) {
                if (target[c] == v) {
                    ArraysUtil.swap((Object[])target, c, d--, coSort);
                }
                --c;
            }
            if (b > c) break;
            ArraysUtil.swap((Object[])target, b++, c--, coSort);
        }
        int n = fromIndex + length;
        int s = Math.min(a - fromIndex, b - a);
        ArraysUtil.vecswap((Object[])target, fromIndex, b - s, s, coSort);
        s = Math.min(d - c, n - d - 1);
        ArraysUtil.vecswap((Object[])target, b, n - s, s, coSort);
        s = b - a;
        if (s > 1) {
            ArraysUtil.quickSort1(target, (int)fromIndex, (int)s, (int[])coSort);
        }
        if ((s = d - c) > 1) {
            ArraysUtil.quickSort1(target, (int)(n - s), (int)s, (int[])coSort);
        }
    }

    private static void swap(Object[] x, int a, int b, int[] coSort) {
        ArraysUtil.swap(x, a, b);
        ArraysUtil.swap(coSort, a, b);
    }

    private static void vecswap(Object[] x, int a, int b, int n, int[] coSort) {
        int i = 0;
        while (i < n) {
            ArraysUtil.swap(x, a, b, coSort);
            ++i;
            ++a;
            ++b;
        }
    }

    public static void swap(Object[] x, int a, int b) {
        Object t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static <T extends Comparable<T>> int med3(T[] x, int a, int b, int c) {
        return x[a].compareTo(x[b]) < 0 ? (x[b].compareTo(x[c]) < 0 ? b : (x[a].compareTo(x[c]) < 0 ? c : a)) : (x[b].compareTo(x[c]) > 0 ? b : (x[a].compareTo(x[c]) > 0 ? c : a));
    }

    public static void quickSort(int[] target, Object[] coSort) {
        ArraysUtil.quickSort1(target, 0, target.length, coSort);
    }

    public static void quickSort(int[] target, int fromIndex, int toIndex, Object[] coSort) {
        ArraysUtil.rangeCheck(target.length, fromIndex, toIndex);
        ArraysUtil.rangeCheck(coSort.length, fromIndex, toIndex);
        ArraysUtil.quickSort1(target, fromIndex, toIndex - fromIndex, coSort);
    }

    public static void quickSort1(int[] target, int fromIndex, int length, Object[] coSort) {
        int c;
        int a;
        if (length < 7) {
            for (int i = fromIndex; i < length + fromIndex; ++i) {
                for (int j = i; j > fromIndex && target[j - 1] > target[j]; --j) {
                    ArraysUtil.swap(target, j, j - 1, coSort);
                }
            }
            return;
        }
        int m = fromIndex + (length >> 1);
        if (length > 7) {
            int l = fromIndex;
            int n = fromIndex + length - 1;
            if (length > 40) {
                int s = length / 8;
                l = ArraysUtil.med3(target, l, l + s, l + 2 * s);
                m = ArraysUtil.med3(target, m - s, m, m + s);
                n = ArraysUtil.med3(target, n - 2 * s, n - s, n);
            }
            m = ArraysUtil.med3(target, l, m, n);
        }
        int v = target[m];
        int b = a = fromIndex;
        int d = c = fromIndex + length - 1;
        while (true) {
            if (b <= c && target[b] <= v) {
                if (target[b] == v) {
                    ArraysUtil.swap(target, a++, b, coSort);
                }
                ++b;
                continue;
            }
            while (c >= b && target[c] >= v) {
                if (target[c] == v) {
                    ArraysUtil.swap(target, c, d--, coSort);
                }
                --c;
            }
            if (b > c) break;
            ArraysUtil.swap(target, b++, c--, coSort);
        }
        int n = fromIndex + length;
        int s = Math.min(a - fromIndex, b - a);
        ArraysUtil.vecswap(target, fromIndex, b - s, s, coSort);
        s = Math.min(d - c, n - d - 1);
        ArraysUtil.vecswap(target, b, n - s, s, coSort);
        s = b - a;
        if (s > 1) {
            ArraysUtil.quickSort1(target, fromIndex, s, coSort);
        }
        if ((s = d - c) > 1) {
            ArraysUtil.quickSort1(target, n - s, s, coSort);
        }
    }

    private static void swap(int[] x, int a, int b, Object[] coSort) {
        ArraysUtil.swap(x, a, b);
        ArraysUtil.swap(coSort, a, b);
    }

    private static void vecswap(int[] x, int a, int b, int n, Object[] coSort) {
        int i = 0;
        while (i < n) {
            ArraysUtil.swap(x, a, b, coSort);
            ++i;
            ++a;
            ++b;
        }
    }

    public static int[] quickSortP(short[] target) {
        int[] permutation = new int[target.length];
        for (int i = 1; i < target.length; ++i) {
            permutation[i] = i;
        }
        ArraysUtil.quickSort(target, 0, target.length, permutation);
        return permutation;
    }

    public static void quickSort(short[] target, int fromIndex, int toIndex, int[] coSort) {
        ArraysUtil.rangeCheck(target.length, fromIndex, toIndex);
        ArraysUtil.rangeCheck(coSort.length, fromIndex, toIndex);
        ArraysUtil.quickSort1(target, fromIndex, toIndex - fromIndex, coSort);
    }

    public static void quickSort1(short[] target, int fromIndex, int length, int[] coSort) {
        ArraysUtil.quickSort2(target, fromIndex, length, coSort);
    }

    private static void quickSort2(short[] target, int fromIndex, int length, int[] coSort) {
        int c;
        int a;
        if (length < 7) {
            for (int i = fromIndex; i < length + fromIndex; ++i) {
                for (int j = i; j > fromIndex && target[j - 1] > target[j]; --j) {
                    ArraysUtil.swap(target, j, j - 1, coSort);
                }
            }
            return;
        }
        int m = fromIndex + (length >> 1);
        if (length > 7) {
            int l = fromIndex;
            int n = fromIndex + length - 1;
            if (length > 40) {
                int s = length / 8;
                l = ArraysUtil.med3(target, l, l + s, l + 2 * s);
                m = ArraysUtil.med3(target, m - s, m, m + s);
                n = ArraysUtil.med3(target, n - 2 * s, n - s, n);
            }
            m = ArraysUtil.med3(target, l, m, n);
        }
        short v = target[m];
        int b = a = fromIndex;
        int d = c = fromIndex + length - 1;
        while (true) {
            if (b <= c && target[b] <= v) {
                if (target[b] == v) {
                    ArraysUtil.swap(target, a++, b, coSort);
                }
                ++b;
                continue;
            }
            while (c >= b && target[c] >= v) {
                if (target[c] == v) {
                    ArraysUtil.swap(target, c, d--, coSort);
                }
                --c;
            }
            if (b > c) break;
            ArraysUtil.swap(target, b++, c--, coSort);
        }
        int n = fromIndex + length;
        int s = Math.min(a - fromIndex, b - a);
        ArraysUtil.vecswap(target, fromIndex, b - s, s, coSort);
        s = Math.min(d - c, n - d - 1);
        ArraysUtil.vecswap(target, b, n - s, s, coSort);
        s = b - a;
        if (s > 1) {
            ArraysUtil.quickSort2(target, fromIndex, s, coSort);
        }
        if ((s = d - c) > 1) {
            ArraysUtil.quickSort2(target, n - s, s, coSort);
        }
    }

    public static void quickSort(short[] target, int[] coSort) {
        ArraysUtil.quickSort(target, 0, target.length, coSort);
    }

    private static void swap(short[] x, int a, int b, int[] coSort) {
        ArraysUtil.swap(x, a, b);
        ArraysUtil.swap(coSort, a, b);
    }

    private static void swap(short[] x, int a, int b) {
        short t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecswap(short[] x, int a, int b, int n, int[] coSort) {
        int i = 0;
        while (i < n) {
            ArraysUtil.swap(x, a, b, coSort);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(short[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    public static void quickSort(int[] target, IntComparator comparator) {
        ArraysUtil.quickSort1(target, 0, target.length, comparator);
    }

    public static void quickSort(int[] target, int fromIndex, int toIndex, IntComparator comparator) {
        ArraysUtil.rangeCheck(target.length, fromIndex, toIndex);
        ArraysUtil.quickSort1(target, fromIndex, toIndex - fromIndex, comparator);
    }

    public static void quickSort1(int[] target, int fromIndex, int length, IntComparator comparator) {
        int c;
        int a;
        if (length < 7) {
            for (int i = fromIndex; i < length + fromIndex; ++i) {
                for (int j = i; j > fromIndex && comparator.compare(target[j - 1], target[j]) > 0; --j) {
                    ArraysUtil.swap(target, j, j - 1);
                }
            }
            return;
        }
        int m = fromIndex + (length >> 1);
        if (length > 7) {
            int l = fromIndex;
            int n = fromIndex + length - 1;
            if (length > 40) {
                int s = length / 8;
                l = ArraysUtil.med3(target, l, l + s, l + 2 * s, comparator);
                m = ArraysUtil.med3(target, m - s, m, m + s, comparator);
                n = ArraysUtil.med3(target, n - 2 * s, n - s, n, comparator);
            }
            m = ArraysUtil.med3(target, l, m, n, comparator);
        }
        int v = target[m];
        int b = a = fromIndex;
        int d = c = fromIndex + length - 1;
        while (true) {
            if (b <= c && comparator.compare(target[b], v) <= 0) {
                if (comparator.compare(target[b], v) == 0) {
                    ArraysUtil.swap(target, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && comparator.compare(target[c], v) >= 0) {
                if (comparator.compare(target[c], v) == 0) {
                    ArraysUtil.swap(target, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ArraysUtil.swap(target, b++, c--);
        }
        int n = fromIndex + length;
        int s = Math.min(a - fromIndex, b - a);
        ArraysUtil.vecswap(target, fromIndex, b - s, s);
        s = Math.min(d - c, n - d - 1);
        ArraysUtil.vecswap(target, b, n - s, s);
        s = b - a;
        if (s > 1) {
            ArraysUtil.quickSort1(target, fromIndex, s, comparator);
        }
        if ((s = d - c) > 1) {
            ArraysUtil.quickSort1(target, n - s, s, comparator);
        }
    }

    public static void quickSort(int[] target, int[] cosort, IntComparator comparator) {
        ArraysUtil.quickSort1(target, 0, target.length, cosort, comparator);
    }

    public static void quickSort(int[] target, int fromIndex, int toIndex, int[] cosort, IntComparator comparator) {
        ArraysUtil.rangeCheck(target.length, fromIndex, toIndex);
        if (target == cosort) {
            throw new IllegalArgumentException("Same array references.");
        }
        ArraysUtil.quickSort1(target, fromIndex, toIndex - fromIndex, cosort, comparator);
    }

    private static void quickSort1(int[] target, int fromIndex, int length, int[] cosort, IntComparator comparator) {
        int c;
        int a;
        if (length < 7) {
            for (int i = fromIndex; i < length + fromIndex; ++i) {
                for (int j = i; j > fromIndex && comparator.compare(target[j - 1], target[j]) > 0; --j) {
                    ArraysUtil.swap(target, j, j - 1, cosort);
                }
            }
            return;
        }
        int m = fromIndex + (length >> 1);
        if (length > 7) {
            int l = fromIndex;
            int n = fromIndex + length - 1;
            if (length > 40) {
                int s = length / 8;
                l = ArraysUtil.med3(target, l, l + s, l + 2 * s, comparator);
                m = ArraysUtil.med3(target, m - s, m, m + s, comparator);
                n = ArraysUtil.med3(target, n - 2 * s, n - s, n, comparator);
            }
            m = ArraysUtil.med3(target, l, m, n, comparator);
        }
        int v = target[m];
        int b = a = fromIndex;
        int d = c = fromIndex + length - 1;
        while (true) {
            if (b <= c && comparator.compare(target[b], v) <= 0) {
                if (comparator.compare(target[b], v) == 0) {
                    ArraysUtil.swap(target, a++, b, cosort);
                }
                ++b;
                continue;
            }
            while (c >= b && comparator.compare(target[c], v) >= 0) {
                if (comparator.compare(target[c], v) == 0) {
                    ArraysUtil.swap(target, c, d--, cosort);
                }
                --c;
            }
            if (b > c) break;
            ArraysUtil.swap(target, b++, c--, cosort);
        }
        int n = fromIndex + length;
        int s = Math.min(a - fromIndex, b - a);
        ArraysUtil.vecswap(target, fromIndex, b - s, s, cosort);
        s = Math.min(d - c, n - d - 1);
        ArraysUtil.vecswap(target, b, n - s, s, cosort);
        s = b - a;
        if (s > 1) {
            ArraysUtil.quickSort1(target, fromIndex, s, cosort, comparator);
        }
        if ((s = d - c) > 1) {
            ArraysUtil.quickSort1(target, n - s, s, cosort, comparator);
        }
    }

    private static int med3(int[] x, int a, int b, int c, IntComparator comparator) {
        return comparator.compare(x[a], x[b]) < 0 ? (comparator.compare(x[b], x[c]) < 0 ? b : (comparator.compare(x[a], x[c]) < 0 ? c : a)) : (comparator.compare(x[b], x[c]) > 0 ? b : (comparator.compare(x[a], x[c]) > 0 ? c : a));
    }

    private static void vecswap(int[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            ArraysUtil.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static void rangeCheck(int arrayLen, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > arrayLen) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
    }
}

