/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.util;

import cc.redberry.rings.bigint.BigInteger;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.apache.commons.math3.random.RandomGenerator;

public final class RandomUtil {
    private RandomUtil() {
    }

    public static int[] randomIntArray(int length, int min, int max, RandomGenerator rnd) {
        int[] data = new int[length];
        for (int i = 0; i < length; ++i) {
            data[i] = min + rnd.nextInt(max - min);
        }
        return data;
    }

    public static int[] randomSharpIntArray(int length, int total, RandomGenerator rnd) {
        int[] data = new int[length];
        for (int i = 0; i < length && total > 0; total -= data[i], ++i) {
            data[i] = rnd.nextInt(total);
        }
        return data;
    }

    public static long[] randomLongArray(int length, long min, long max, RandomGenerator rnd) {
        RandomDataGenerator rndd = new RandomDataGenerator(rnd);
        long[] data = new long[length];
        for (int i = 0; i < length; ++i) {
            data[i] = rndd.nextLong(min, max - 1L);
        }
        return data;
    }

    public static BigInteger[] randomBigIntegerArray(int length, BigInteger min, BigInteger max, RandomGenerator rnd) {
        RandomDataGenerator rndd = new RandomDataGenerator(rnd);
        BigInteger[] data = new BigInteger[length];
        BigInteger delta = max.subtract(min);
        for (int i = 0; i < length; ++i) {
            data[i] = min.add(RandomUtil.randomInt(delta, rnd));
        }
        return data;
    }

    public static BigInteger randomInt(BigInteger bound, RandomGenerator rnd) {
        BigInteger r;
        while ((r = new BigInteger(bound.bitLength(), rnd)).compareTo(bound) >= 0) {
        }
        return r;
    }
}

