/*
 * Decompiled with CFR 0.152.
 */
package com.github.tueda.donuts;

import cc.redberry.rings.Rational;
import cc.redberry.rings.Rationals;
import cc.redberry.rings.Ring;
import cc.redberry.rings.Rings;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.io.Coder;
import cc.redberry.rings.poly.MultivariateRing;
import cc.redberry.rings.poly.multivar.Monomial;
import cc.redberry.rings.poly.multivar.MultivariatePolynomial;
import com.github.tueda.donuts.Multivariate;
import com.github.tueda.donuts.Polynomial;
import com.github.tueda.donuts.SubstitutionUtils;
import com.github.tueda.donuts.Variable;
import com.github.tueda.donuts.VariableSet;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.stream.Stream;

public final class RationalFunction
implements Serializable,
Multivariate {
    private static final long serialVersionUID = 1L;
    private static final int MAX_VARIABLES = 300;
    private static final List<MultivariateRing<MultivariatePolynomial<BigInteger>>> RAW_RINGS = new ArrayList<MultivariateRing<MultivariatePolynomial<BigInteger>>>();
    private static final List<Rationals<MultivariatePolynomial<BigInteger>>> RAW_FIELDS = new ArrayList<Rationals<MultivariatePolynomial<BigInteger>>>();
    static final Rational<MultivariatePolynomial<BigInteger>> RAW_ZERO;
    public static final RationalFunction ZERO;
    public static final RationalFunction ONE;
    private final VariableSet variables;
    private final Rational<MultivariatePolynomial<BigInteger>> raw;

    public RationalFunction() {
        this.variables = VariableSet.EMPTY;
        this.raw = RAW_ZERO;
    }

    public RationalFunction(long value) {
        this.variables = VariableSet.EMPTY;
        this.raw = new Rational<MultivariatePolynomial>(RationalFunction.getRings(0), (MultivariatePolynomial)Polynomial.RAW_ZERO.createConstant(value));
    }

    public RationalFunction(BigInteger value) {
        this.variables = VariableSet.EMPTY;
        this.raw = new Rational<MultivariatePolynomial<BigInteger>>(RationalFunction.getRings(0), Polynomial.RAW_ZERO.createConstant(value));
    }

    public RationalFunction(Polynomial poly) {
        this.variables = poly.getVariables();
        this.raw = new Rational<MultivariatePolynomial<BigInteger>>(RationalFunction.getRings(this.variables.size()), poly.getRawPolynomialWithoutCopy());
    }

    public RationalFunction(long numerator, long denominator) {
        this.variables = VariableSet.EMPTY;
        this.raw = new Rational<MultivariatePolynomial>(RationalFunction.getRings(0), (MultivariatePolynomial)Polynomial.RAW_ZERO.createConstant(numerator), (MultivariatePolynomial)Polynomial.RAW_ZERO.createConstant(denominator));
    }

    public RationalFunction(BigInteger numerator, BigInteger denominator) {
        this.variables = VariableSet.EMPTY;
        this.raw = new Rational<MultivariatePolynomial<BigInteger>>(RationalFunction.getRings(0), Polynomial.RAW_ZERO.createConstant(numerator), Polynomial.RAW_ZERO.createConstant(denominator));
    }

    public RationalFunction(Polynomial numerator, Polynomial denominator) {
        VariableSet numeratorVariables = numerator.getVariables();
        VariableSet denominatorVariables = denominator.getVariables();
        if (numeratorVariables.equals(denominatorVariables)) {
            this.variables = numeratorVariables;
            this.raw = new Rational<MultivariatePolynomial<BigInteger>>(RationalFunction.getRings(this.variables.size()), numerator.getRawPolynomialWithoutCopy(), denominator.getRawPolynomialWithoutCopy());
        } else {
            this.variables = numeratorVariables.union(denominatorVariables);
            this.raw = new Rational<MultivariatePolynomial<BigInteger>>(RationalFunction.getRings(this.variables.size()), numerator.translate(this.variables).getRawPolynomialWithoutCopy(), denominator.translate(this.variables).getRawPolynomialWithoutCopy());
        }
    }

    public RationalFunction(String string) {
        String[] names = Variable.guessVariableNames(string);
        this.variables = VariableSet.createFromRaw(names);
        try {
            this.raw = RationalFunction.getCoder(this.variables).parse(string);
        }
        catch (RuntimeException e) {
            if (this.isParserError(e)) {
                String s = string.length() <= 32 ? string : string.substring(0, 32) + "...";
                throw new IllegalArgumentException(String.format("Failed to parse \"%s\"", s), e);
            }
            throw e;
        }
    }

    private boolean isParserError(Throwable e) {
        StackTraceElement el = e.getStackTrace()[0];
        String s = el.getClassName() + "." + el.getMethodName();
        return s.startsWith("cc.redberry.rings.bigint.BigInteger.pow") || s.startsWith("cc.redberry.rings.io.Coder.mkOperand") || s.startsWith("cc.redberry.rings.io.Coder.parse") || s.startsWith("cc.redberry.rings.io.Coder.popEvaluate") || s.startsWith("cc.redberry.rings.io.Tokenizer.checkChar") || s.startsWith("cc.redberry.rings.io.Tokenizer.nextToken") || s.startsWith("java.util.ArrayDeque.removeFirst");
    }

    private static void checkNumberOfVariables(int nvars) {
        if (nvars > 300) {
            throw new ArithmeticException(String.format("sorry, too many variables %s > %s", nvars, 300));
        }
    }

    static MultivariateRing<MultivariatePolynomial<BigInteger>> getRings(int nvars) {
        RationalFunction.checkNumberOfVariables(nvars);
        return RAW_RINGS.get(nvars);
    }

    private static Rationals<MultivariatePolynomial<BigInteger>> getFields(int nvars) {
        RationalFunction.checkNumberOfVariables(nvars);
        return RAW_FIELDS.get(nvars);
    }

    private static Coder<Rational<MultivariatePolynomial<BigInteger>>, ?, ?> getCoder(VariableSet variables) {
        return Coder.mkRationalsCoder(RationalFunction.getFields(variables.size()), Coder.mkMultivariateCoder(RationalFunction.getRings(variables.size()), variables.getRawTable()));
    }

    private RationalFunction(VariableSet newVariables, Rational<MultivariatePolynomial<BigInteger>> rawRat) {
        assert (newVariables.size() == ((MultivariateRing)rawRat.ring).nVariables());
        RationalFunction.checkNumberOfVariables(newVariables.size());
        this.variables = newVariables;
        this.raw = rawRat;
    }

    private RationalFunction(VariableSet newVariables, MultivariatePolynomial<BigInteger> rawNum, MultivariatePolynomial<BigInteger> rawDen) {
        int nVariables = newVariables.size();
        assert (nVariables == rawNum.nVariables);
        assert (nVariables == rawDen.nVariables);
        if (rawDen.isZero()) {
            throw new ArithmeticException("division by zero");
        }
        this.variables = newVariables;
        this.raw = new Rational<MultivariatePolynomial<BigInteger>>(RationalFunction.getRings(nVariables), rawNum, rawDen);
    }

    static RationalFunction createFromRaw(VariableSet newVariables, Rational<MultivariatePolynomial<BigInteger>> rawRat) {
        return new RationalFunction(newVariables, rawRat);
    }

    public static RationalFunction of(String string) {
        return new RationalFunction(string);
    }

    public static RationalFunction[] of(String ... strings) {
        return (RationalFunction[])Stream.of(strings).map(RationalFunction::new).toArray(RationalFunction[]::new);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy(this);
    }

    private Object readResolve() throws ObjectStreamException {
        throw new InvalidObjectException("Proxy required.");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RationalFunction)) {
            return false;
        }
        RationalFunction aRat = (RationalFunction)other;
        if (this.variables.equals(aRat.variables)) {
            return this.raw.equals(aRat.raw);
        }
        VariableSet newVariables = this.variables.union(aRat.variables);
        return this.translate((VariableSet)newVariables).raw.equals(aRat.translate((VariableSet)newVariables).raw);
    }

    public int hashCode() {
        RationalFunction rat = this.translate(this.getMinimalVariables());
        return Objects.hash(rat.variables, rat.raw);
    }

    public String toString() {
        return RationalFunction.getCoder(this.variables).stringify(this.raw);
    }

    @Override
    public VariableSet getVariables() {
        return this.variables;
    }

    @Override
    public VariableSet getMinimalVariables() {
        return this.getNumerator().getMinimalVariables().union(this.getDenominator().getMinimalVariables());
    }

    public Rational<MultivariatePolynomial<BigInteger>> getRawRational() {
        return new Rational<MultivariatePolynomial<BigInteger>>(this.raw.ring, (MultivariatePolynomial)this.raw.numerator().copy(), (MultivariatePolynomial)this.raw.denominator().copy());
    }

    Rational<MultivariatePolynomial<BigInteger>> getRawRationalWithoutCopy() {
        return this.raw;
    }

    public boolean isZero() {
        return this.raw.isZero();
    }

    public boolean isOne() {
        return this.raw.isOne();
    }

    public boolean isMinusOne() {
        return this.raw.isIntegral() && this.getNumerator().isMinusOne();
    }

    public boolean isConstant() {
        return this.raw.numerator().isConstant() && this.raw.denominator().isConstant();
    }

    public boolean isInteger() {
        return this.raw.isIntegral() && this.raw.numerator().isConstant();
    }

    public boolean isVariable() {
        return this.raw.isIntegral() && this.getNumerator().isVariable();
    }

    public boolean isPolynomial() {
        return this.raw.isIntegral();
    }

    public Polynomial getNumerator() {
        return Polynomial.createFromRaw(this.variables, this.raw.numerator());
    }

    public Polynomial getDenominator() {
        return Polynomial.createFromRaw(this.variables, this.raw.denominator());
    }

    public RationalFunction translate(VariableSet newVariables) {
        if (this.variables == newVariables) {
            return this;
        }
        if (this.variables.equals(newVariables)) {
            return new RationalFunction(newVariables, this.raw);
        }
        return new RationalFunction(newVariables, new Rational<MultivariatePolynomial<BigInteger>>(RationalFunction.getRings(newVariables.size()), this.getNumerator().translate(newVariables).getRawPolynomialWithoutCopy(), this.getDenominator().translate(newVariables).getRawPolynomialWithoutCopy()));
    }

    public RationalFunction negate() {
        if (this.isZero()) {
            return this;
        }
        return new RationalFunction(this.variables, this.raw.negate());
    }

    public RationalFunction reciprocal() {
        return new RationalFunction(this.variables, this.raw.reciprocal());
    }

    private RationalFunction performBinaryOperation(RationalFunction other, BinaryOperator<Rational<MultivariatePolynomial<BigInteger>>> operator) {
        if (this.variables.equals(other.variables)) {
            return new RationalFunction(this.variables, (Rational)operator.apply(this.raw, other.raw));
        }
        VariableSet newVariables = this.variables.union(other.variables);
        return new RationalFunction(newVariables, (Rational)operator.apply(this.translate((VariableSet)newVariables).raw, other.translate((VariableSet)newVariables).raw));
    }

    public RationalFunction add(RationalFunction other) {
        return this.performBinaryOperation(other, Rational::add);
    }

    public RationalFunction subtract(RationalFunction other) {
        return this.performBinaryOperation(other, Rational::subtract);
    }

    public RationalFunction multiply(RationalFunction other) {
        return this.performBinaryOperation(other, Rational::multiply);
    }

    public RationalFunction divide(RationalFunction divisor) {
        return this.performBinaryOperation(divisor, Rational::divide);
    }

    public RationalFunction pow(int exponent) {
        return new RationalFunction(this.variables, this.raw.pow(exponent));
    }

    public RationalFunction pow(BigInteger exponent) {
        return new RationalFunction(this.variables, this.raw.pow(exponent));
    }

    public RationalFunction substitute(Polynomial lhs, RationalFunction rhs) {
        SubstitutionUtils.checkLhs(lhs);
        if (!this.getMinimalVariables().intersects(lhs.getMinimalVariables())) {
            return this;
        }
        VariableSet newVariables = this.variables.union(lhs.getVariables()).union(rhs.getVariables());
        Rational<MultivariatePolynomial<BigInteger>> rawRat = this.translate((VariableSet)newVariables).raw;
        Monomial rawLhs = (Monomial)lhs.translate(newVariables).getRawPolynomialWithoutCopy().first();
        Rational<MultivariatePolynomial<BigInteger>> rawRhs = rhs.translate((VariableSet)newVariables).raw;
        Rational<MultivariatePolynomial<BigInteger>> rawNum = SubstitutionUtils.substitute(rawRat.numerator(), (Monomial<BigInteger>)rawLhs, rawRhs);
        Rational<MultivariatePolynomial<BigInteger>> rawDen = SubstitutionUtils.substitute(rawRat.denominator(), (Monomial<BigInteger>)rawLhs, rawRhs);
        return new RationalFunction(newVariables, rawNum.divide((MultivariatePolynomial<BigInteger>)((Object)rawDen)));
    }

    public RationalFunction evaluate(Variable variable, int value) {
        int i = this.variables.indexOf(variable);
        if (i < 0) {
            return this;
        }
        BigInteger newValue = BigInteger.valueOf(value);
        return new RationalFunction(this.variables, this.raw.numerator().evaluate(i, newValue), this.raw.denominator().evaluate(i, newValue));
    }

    public RationalFunction evaluate(Variable variable, BigInteger value) {
        int i = this.variables.indexOf(variable);
        if (i < 0) {
            return this;
        }
        return new RationalFunction(this.variables, this.raw.numerator().evaluate(i, value), this.raw.denominator().evaluate(i, value));
    }

    public RationalFunction evaluate(Variable[] variables, int[] values) {
        Object[] result = this.variables.findIndicesForVariablesAndValues(variables, values);
        int[] indices = (int[])result[0];
        if (indices.length == 0) {
            return this;
        }
        BigInteger[] newValues = (BigInteger[])result[1];
        return new RationalFunction(this.variables, this.raw.numerator().evaluate(indices, (E[])newValues), this.raw.denominator().evaluate(indices, (E[])newValues));
    }

    public RationalFunction evaluate(Variable[] variables, BigInteger[] values) {
        Object[] result = this.variables.findIndicesForVariablesAndValues(variables, values);
        int[] indices = (int[])result[0];
        if (indices.length == 0) {
            return this;
        }
        BigInteger[] newValues = (BigInteger[])result[1];
        return new RationalFunction(this.variables, this.raw.numerator().evaluate(indices, (E[])newValues), this.raw.denominator().evaluate(indices, (E[])newValues));
    }

    public RationalFunction evaluateAtZero(Variable variable) {
        int i = this.variables.indexOf(variable);
        if (i < 0) {
            return this;
        }
        return new RationalFunction(this.variables, (MultivariatePolynomial)this.raw.numerator().evaluateAtZero(i), (MultivariatePolynomial)this.raw.denominator().evaluateAtZero(i));
    }

    public RationalFunction evaluateAtZero(VariableSet variables) {
        int[] indices = this.variables.findIndicesForVariableSet(variables);
        if (indices.length == 0) {
            return this;
        }
        return new RationalFunction(this.variables, (MultivariatePolynomial)this.raw.numerator().evaluateAtZero(indices), (MultivariatePolynomial)this.raw.denominator().evaluateAtZero(indices));
    }

    public RationalFunction evaluateAtOne(Variable variable) {
        int i = this.variables.indexOf(variable);
        if (i < 0) {
            return this;
        }
        return new RationalFunction(this.variables, this.raw.numerator().evaluate(i, BigInteger.ONE), this.raw.denominator().evaluate(i, BigInteger.ONE));
    }

    public RationalFunction evaluateAtOne(VariableSet variables) {
        int[] indices = this.variables.findIndicesForVariableSet(variables);
        if (indices.length == 0) {
            return this;
        }
        Object[] values = new BigInteger[indices.length];
        Arrays.fill(values, BigInteger.ONE);
        return new RationalFunction(this.variables, this.raw.numerator().evaluate(indices, (E[])((BigInteger[])values)), this.raw.denominator().evaluate(indices, (E[])((BigInteger[])values)));
    }

    public RationalFunction shift(Variable variable, int shift) {
        int i = this.variables.indexOf(variable);
        if (i < 0) {
            return this;
        }
        BigInteger newShift = BigInteger.valueOf(shift);
        return new RationalFunction(this.variables, this.raw.numerator().shift(i, newShift), this.raw.denominator().shift(i, newShift));
    }

    public RationalFunction shift(Variable variable, BigInteger shift) {
        int i = this.variables.indexOf(variable);
        if (i < 0) {
            return this;
        }
        return new RationalFunction(this.variables, this.raw.numerator().shift(i, shift), this.raw.denominator().shift(i, shift));
    }

    public RationalFunction shift(Variable[] variables, int[] shifts) {
        Object[] result = this.variables.findIndicesForVariablesAndValues(variables, shifts, "shifts");
        int[] indices = (int[])result[0];
        if (indices.length == 0) {
            return this;
        }
        BigInteger[] newShifts = (BigInteger[])result[1];
        return new RationalFunction(this.variables, this.raw.numerator().shift(indices, (BigInteger[])newShifts), this.raw.denominator().shift(indices, (BigInteger[])newShifts));
    }

    public RationalFunction shift(Variable[] variables, BigInteger[] shifts) {
        Object[] result = this.variables.findIndicesForVariablesAndValues(variables, shifts, "shifts");
        int[] indices = (int[])result[0];
        if (indices.length == 0) {
            return this;
        }
        BigInteger[] newShifts = (BigInteger[])result[1];
        return new RationalFunction(this.variables, this.raw.numerator().shift(indices, (BigInteger[])newShifts), this.raw.denominator().shift(indices, (BigInteger[])newShifts));
    }

    public RationalFunction derivative(Variable variable) {
        return this.derivative(variable, 1);
    }

    public RationalFunction derivative(Variable variable, int order) {
        if (order < 0) {
            throw new IllegalArgumentException(String.format("Negative order given: %s", order));
        }
        if (order == 0) {
            return this;
        }
        int i = this.variables.indexOf(variable);
        if (i < 0) {
            return ZERO;
        }
        Rational<MultivariatePolynomial<BigInteger>> r = this.raw;
        for (int j = 0; j < order; ++j) {
            if ((r = RationalFunction.derivativeImpl(r, i)) != null) continue;
            return ZERO;
        }
        return new RationalFunction(this.variables, r);
    }

    private static Rational<MultivariatePolynomial<BigInteger>> derivativeImpl(Rational<MultivariatePolynomial<BigInteger>> r, int variable) {
        MultivariatePolynomial<BigInteger> p = r.numerator();
        MultivariatePolynomial<BigInteger> q = r.denominator();
        MultivariatePolynomial p1 = (MultivariatePolynomial)p.derivative(variable);
        MultivariatePolynomial q1 = (MultivariatePolynomial)q.derivative(variable);
        if (p1.isZero()) {
            if (q1.isZero()) {
                return null;
            }
            return new Rational<MultivariatePolynomial<BigInteger>>(r.ring, (MultivariatePolynomial)q1.multiply(p).negate(), ((MultivariatePolynomial)q.copy()).multiply(q));
        }
        if (q1.isZero()) {
            return new Rational<MultivariatePolynomial<BigInteger>>(r.ring, p1, q);
        }
        Rational<MultivariatePolynomial<BigInteger>> term1 = new Rational<MultivariatePolynomial<BigInteger>>(r.ring, p1, q);
        Rational<MultivariatePolynomial<BigInteger>> term2 = new Rational<MultivariatePolynomial<BigInteger>>(r.ring, (MultivariatePolynomial)q1.multiply(p).negate(), ((MultivariatePolynomial)q.copy()).multiply(q));
        return term1.add((MultivariatePolynomial<BigInteger>)((Object)term2));
    }

    static {
        for (int i = 0; i <= 300; ++i) {
            RAW_RINGS.add(Rings.MultivariateRing(i, Rings.Z));
            RAW_FIELDS.add(Rings.Frac((Ring)RAW_RINGS.get(i)));
        }
        RAW_ZERO = new Rational<MultivariatePolynomial<BigInteger>>((Ring)RAW_RINGS.get(0), Polynomial.RAW_ZERO);
        ZERO = new RationalFunction();
        ONE = new RationalFunction(1L);
    }

    private static final class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final VariableSet variables;
        private final MultivariatePolynomial<BigInteger> numerator;
        private final MultivariatePolynomial<BigInteger> denominator;

        public SerializationProxy(RationalFunction rat) {
            this.variables = rat.variables;
            this.numerator = (MultivariatePolynomial)rat.raw.numerator();
            this.denominator = (MultivariatePolynomial)rat.raw.denominator();
        }

        private Object readResolve() throws ObjectStreamException {
            return new RationalFunction(Polynomial.createFromRaw(this.variables, this.numerator.setRingUnsafe(Rings.Z)), Polynomial.createFromRaw(this.variables, this.denominator.setRingUnsafe(Rings.Z)));
        }
    }
}

