/*
 * Decompiled with CFR 0.152.
 */
package com.github.tueda.donuts;

import cc.redberry.rings.Rational;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.io.Stringifiable;
import cc.redberry.rings.poly.IPolynomial;
import cc.redberry.rings.poly.MultivariateRing;
import cc.redberry.rings.poly.PolynomialMethods;
import cc.redberry.rings.poly.multivar.AMultivariatePolynomial;
import cc.redberry.rings.poly.multivar.DegreeVector;
import cc.redberry.rings.poly.multivar.Monomial;
import cc.redberry.rings.poly.multivar.MultivariatePolynomial;
import com.github.tueda.donuts.Polynomial;
import com.github.tueda.donuts.RationalFunction;
import com.github.tueda.donuts.util.IndexToObjectMap;
import lombok.Generated;

public final class SubstitutionUtils {
    public static void checkLhs(Polynomial lhs) {
        if (!lhs.isMonomial() || lhs.isConstant() || !lhs.isMonic()) {
            throw new IllegalArgumentException("illegal lhs for substitution");
        }
    }

    public static MultivariatePolynomial<BigInteger> substitute(MultivariatePolynomial<BigInteger> poly, Monomial<BigInteger> lhs, MultivariatePolynomial<BigInteger> rhs) {
        IPolynomial result = poly.createZero();
        PolynomialPowers powers = new PolynomialPowers(rhs);
        for (Monomial monomial : poly) {
            int n = 0;
            DegreeVector dv = monomial;
            while (dv.dvDivisibleBy(lhs)) {
                dv = dv.dvDivideExact(lhs);
                ++n;
            }
            if (n == 0) {
                ((AMultivariatePolynomial)result).add(monomial);
                continue;
            }
            ((AMultivariatePolynomial)result).add(powers.pow(n).multiply(new Monomial<BigInteger>(dv, (BigInteger)monomial.coefficient)));
        }
        return result;
    }

    public static Rational<MultivariatePolynomial<BigInteger>> substitute(MultivariatePolynomial<BigInteger> poly, Monomial<BigInteger> lhs, Rational<MultivariatePolynomial<BigInteger>> rhs) {
        MultivariateRing<MultivariatePolynomial<BigInteger>> ring = RationalFunction.getRings(poly.nVariables);
        Rational<Stringifiable<MultivariatePolynomial<Object>>> result = Rational.zero(ring);
        IPolynomial spectators = poly.createZero();
        RationalPowers powers = new RationalPowers(rhs);
        for (Monomial monomial : poly) {
            int n = 0;
            DegreeVector dv = monomial;
            while (dv.dvDivisibleBy(lhs)) {
                dv = dv.dvDivideExact(lhs);
                ++n;
            }
            if (n == 0) {
                ((AMultivariatePolynomial)spectators).add(monomial);
                continue;
            }
            result = result.add((MultivariatePolynomial<BigInteger>)((Object)powers.pow(n).multiply(((MultivariatePolynomial)poly.createOne()).multiply(new Monomial<BigInteger>(dv, (BigInteger)monomial.coefficient)))));
        }
        if (((AMultivariatePolynomial)spectators).isZero()) {
            return result;
        }
        return result.add((MultivariatePolynomial<BigInteger>)spectators);
    }

    @Generated
    private SubstitutionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class PolynomialPowers {
        private final MultivariatePolynomial<BigInteger> base;
        private final IndexToObjectMap<MultivariatePolynomial<BigInteger>> cache;

        public PolynomialPowers(MultivariatePolynomial<BigInteger> base) {
            this.base = base;
            this.cache = new IndexToObjectMap();
        }

        public MultivariatePolynomial<BigInteger> pow(int exponent) {
            MultivariatePolynomial<BigInteger> result = this.cache.get(exponent);
            if (result == null) {
                result = PolynomialMethods.polyPow(this.base, exponent, true);
                this.cache.put(exponent, result);
            }
            return (MultivariatePolynomial)result.copy();
        }
    }

    private static class RationalPowers {
        private final Rational<MultivariatePolynomial<BigInteger>> base;
        private final IndexToObjectMap<Rational<MultivariatePolynomial<BigInteger>>> cache;

        public RationalPowers(Rational<MultivariatePolynomial<BigInteger>> base) {
            this.base = base;
            this.cache = new IndexToObjectMap();
        }

        public Rational<MultivariatePolynomial<BigInteger>> pow(int exponent) {
            Rational<MultivariatePolynomial<BigInteger>> result = this.cache.get(exponent);
            if (result == null) {
                result = this.base.pow(exponent);
                this.cache.put(exponent, result);
            }
            return result;
        }
    }
}

