/*
 * Decompiled with CFR 0.152.
 */
package com.github.tueda.donuts;

import cc.redberry.rings.bigint.BigInteger;
import com.github.tueda.donuts.Multivariate;
import com.github.tueda.donuts.Variable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class VariableSet
extends AbstractSet<Variable>
implements Serializable,
Multivariate {
    private static final long serialVersionUID = 1L;
    static final VariableSet EMPTY = new VariableSet();
    private final String[] table;

    public VariableSet() {
        this.table = new String[0];
    }

    public VariableSet(Variable variable) {
        this.table = new String[]{variable.getName()};
    }

    public VariableSet(Variable ... variables) {
        Stream<String> stream = Stream.of(variables).map((? super T x) -> x.toString());
        this.table = (String[])stream.sorted(Variable.NAME_COMPARATOR).distinct().toArray(String[]::new);
    }

    public VariableSet(Iterable<Variable> variables) {
        Stream<String> stream = StreamSupport.stream(variables.spliterator(), false).map((? super T x) -> x.toString());
        this.table = (String[])stream.sorted(Variable.NAME_COMPARATOR).distinct().toArray(String[]::new);
    }

    public VariableSet(Stream<Variable> variables) {
        Stream<String> stream = variables.map((? super T x) -> x.toString());
        this.table = (String[])stream.sorted(Variable.NAME_COMPARATOR).distinct().toArray(String[]::new);
    }

    private VariableSet(String ... rawTable) {
        this.table = rawTable;
    }

    private static VariableSet createFromVariableNames(Stream<String> stream) {
        return new VariableSet((String[])stream.sorted(Variable.NAME_COMPARATOR).distinct().toArray(String[]::new));
    }

    static VariableSet createFromRaw(String ... rawTable) {
        return new VariableSet(rawTable);
    }

    public static VariableSet of(String name) {
        return new VariableSet(new Variable(name));
    }

    public static VariableSet of(String ... names) {
        return new VariableSet(Stream.of(names).map(Variable::new));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VariableSet)) {
            return false;
        }
        VariableSet aVariableSet = (VariableSet)other;
        return Arrays.equals(this.table, aVariableSet.table);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.table);
    }

    @Override
    public String toString() {
        return "{" + Stream.of(this.table).collect(Collectors.joining(", ")) + "}";
    }

    @Override
    public int size() {
        return this.table.length;
    }

    @Override
    public Iterator<Variable> iterator() {
        return Stream.of(this.table).map((? super T x) -> Variable.createWithoutCheck(x)).iterator();
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof Variable)) {
            return false;
        }
        Variable x = (Variable)o;
        return Arrays.binarySearch(this.table, x.getName(), Variable.NAME_COMPARATOR) >= 0;
    }

    @Override
    public VariableSet getVariables() {
        return this;
    }

    public boolean intersects(VariableSet other) {
        return !Collections.disjoint(this, other);
    }

    public VariableSet intersection(VariableSet other) {
        if (this.equals(other)) {
            return this;
        }
        if (this.isEmpty()) {
            return this;
        }
        if (other.isEmpty()) {
            return other;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Variable x : other) {
            if (!this.contains(x)) continue;
            list.add(x.getName());
        }
        VariableSet newVariables = new VariableSet(list.toArray(new String[0]));
        if (this.equals(newVariables)) {
            return this;
        }
        if (other.equals(newVariables)) {
            return other;
        }
        return newVariables;
    }

    public VariableSet union(VariableSet other) {
        if (this.equals(other)) {
            return this;
        }
        if (this.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return this;
        }
        VariableSet newVariables = VariableSet.createFromVariableNames(Stream.concat(Stream.of(this.table), Stream.of(other.table)));
        if (this.equals(newVariables)) {
            return this;
        }
        if (other.equals(newVariables)) {
            return other;
        }
        return newVariables;
    }

    public static VariableSet unionOf(Multivariate ... objects) {
        return VariableSet.unionOf(Stream.of(objects));
    }

    public static VariableSet unionOf(Iterable<Multivariate> objects) {
        return VariableSet.unionOf(StreamSupport.stream(objects.spliterator(), false));
    }

    public static VariableSet unionOf(Stream<Multivariate> objects) {
        Optional<VariableSet> result = objects.map((? super T obj) -> obj.getVariables()).reduce((n1, n2) -> n1.union((VariableSet)n2));
        if (result.isPresent()) {
            return result.get();
        }
        return EMPTY;
    }

    @SuppressFBWarnings(justification="Returning null indicates no mapping exists", value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    public int[] map(VariableSet other) {
        int[] mapping = new int[this.table.length];
        int j = 0;
        for (int i = 0; i < mapping.length; ++i) {
            if ((j = Arrays.binarySearch(other.table, j, other.table.length, this.table[i], Variable.NAME_COMPARATOR)) < 0) {
                return null;
            }
            mapping[i] = j++;
        }
        return mapping;
    }

    public int[] map(VariableSet other, int defaultIndex) {
        int[] mapping = new int[this.table.length];
        int j = 0;
        for (int i = 0; i < mapping.length; ++i) {
            int k = Arrays.binarySearch(other.table, j, other.table.length, this.table[i], Variable.NAME_COMPARATOR);
            if (k < 0) {
                mapping[i] = defaultIndex;
                continue;
            }
            mapping[i] = k;
            j = k + 1;
        }
        return mapping;
    }

    String[] getRawTable() {
        return this.table;
    }

    String getRawName(int index) {
        return this.table[index];
    }

    int indexOf(String rawVariable) {
        return Arrays.binarySearch(this.table, rawVariable, Variable.NAME_COMPARATOR);
    }

    int indexOf(String rawVariable, int fromIndex) {
        return Arrays.binarySearch(this.table, fromIndex, this.table.length, rawVariable, Variable.NAME_COMPARATOR);
    }

    int indexOf(Variable variable) {
        return this.indexOf(variable.getName());
    }

    int[] findIndicesForVariableSet(VariableSet variables) {
        int[] indices = new int[variables.size()];
        int n = 0;
        int i = 0;
        for (String x : variables.getRawTable()) {
            int j = this.indexOf(x, i);
            if (j < 0) continue;
            indices[n++] = j;
            i = j + 1;
            if (i >= this.size()) break;
        }
        return Arrays.copyOfRange(indices, 0, n);
    }

    Object[] findIndicesForVariablesAndValues(Variable[] variables, int[] values) {
        return this.findIndicesForVariablesAndValues(variables, values, "values");
    }

    Object[] findIndicesForVariablesAndValues(Variable[] variables, int[] values, String valuesName) {
        if (variables.length != values.length) {
            throw new IllegalArgumentException("sizes of variables and " + valuesName + " unmatch");
        }
        int len = variables.length;
        int[] indices = new int[len];
        BigInteger[] newValues = new BigInteger[len];
        int n = 0;
        for (int i = 0; i < len; ++i) {
            int j = this.indexOf(variables[i]);
            if (j < 0) continue;
            indices[n] = j;
            newValues[n++] = BigInteger.valueOf(values[i]);
        }
        Object[] result = new Object[]{Arrays.copyOfRange(indices, 0, n), Arrays.copyOfRange(newValues, 0, n)};
        return result;
    }

    Object[] findIndicesForVariablesAndValues(Variable[] variables, BigInteger[] values) {
        return this.findIndicesForVariablesAndValues(variables, values, "values");
    }

    Object[] findIndicesForVariablesAndValues(Variable[] variables, BigInteger[] values, String valuesName) {
        if (variables.length != values.length) {
            throw new IllegalArgumentException("sizes of variables and " + valuesName + " unmatch");
        }
        int len = variables.length;
        int[] indices = new int[len];
        BigInteger[] newValues = new BigInteger[len];
        int n = 0;
        for (int i = 0; i < len; ++i) {
            int j = this.indexOf(variables[i]);
            if (j < 0) continue;
            indices[n] = j;
            newValues[n++] = values[i];
        }
        Object[] result = new Object[]{Arrays.copyOfRange(indices, 0, n), Arrays.copyOfRange(newValues, 0, n)};
        return result;
    }
}

