/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AuthMethodConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/auth_method#accessor_selector AuthMethod#accessor_selector}
    */
    readonly accessorSelector?: string;
    /**
    * Allowed URI for auth redirection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/auth_method#allowed_redirect_uris AuthMethod#allowed_redirect_uris}
    */
    readonly allowedRedirectUris?: string[];
    /**
    * The optional audience claims required
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/auth_method#auds AuthMethod#auds}
    */
    readonly auds?: string[];
    /**
    * Mapping of a claim to a variable value for the access selector
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/auth_method#claim_mappings AuthMethod#claim_mappings}
    */
    readonly claimMappings?: {
        [key: string]: string;
    };
    /**
    * Client ID of OIDC provider
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/auth_method#client_id AuthMethod#client_id}
    */
    readonly clientId: string;
    /**
    * Client Secret of OIDC provider
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/auth_method#client_secret AuthMethod#client_secret}
    */
    readonly clientSecret: string;
    /**
    * Description of auth method
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/auth_method#description AuthMethod#description}
    */
    readonly description?: string;
    /**
    * Optional CA certificate chain to validate the discovery URL. Multiple CA certificates can be specified to support easier rotation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/auth_method#discovery_ca_pem AuthMethod#discovery_ca_pem}
    */
    readonly discoveryCaPem?: string[];
    /**
    * Discovery URL for OIDC provider
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/auth_method#discovery_url AuthMethod#discovery_url}
    */
    readonly discoveryUrl: string;
    /**
    * The display name of the Auth Method
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/auth_method#display_name AuthMethod#display_name}
    */
    readonly displayName?: string;
    /**
    * Same as claim_mappings but for list values
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/auth_method#list_claim_mappings AuthMethod#list_claim_mappings}
    */
    readonly listClaimMappings?: {
        [key: string]: string;
    };
    /**
    * The name of the Auth Method
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/auth_method#name AuthMethod#name}
    */
    readonly name: string;
    /**
    * The optional claims scope requested.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/auth_method#scopes AuthMethod#scopes}
    */
    readonly scopes?: string[];
    /**
    * The signing algorithms supported by the OIDC connect server. If this isn't specified, this will default to RS256 since that should be supported according to the RFC. The string values here should be valid OIDC signing algorithms
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/auth_method#signing_algs AuthMethod#signing_algs}
    */
    readonly signingAlgs?: string[];
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/auth_method waypoint_auth_method}
*/
export declare class AuthMethod extends cdktf.TerraformResource {
    static readonly tfResourceType = "waypoint_auth_method";
    /**
    * Generates CDKTF code for importing a AuthMethod resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AuthMethod to import
    * @param importFromId The id of the existing AuthMethod that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/auth_method#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AuthMethod to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/auth_method waypoint_auth_method} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AuthMethodConfig
    */
    constructor(scope: Construct, id: string, config: AuthMethodConfig);
    private _accessorSelector?;
    get accessorSelector(): string;
    set accessorSelector(value: string);
    resetAccessorSelector(): void;
    get accessorSelectorInput(): string | undefined;
    private _allowedRedirectUris?;
    get allowedRedirectUris(): string[];
    set allowedRedirectUris(value: string[]);
    resetAllowedRedirectUris(): void;
    get allowedRedirectUrisInput(): string[] | undefined;
    private _auds?;
    get auds(): string[];
    set auds(value: string[]);
    resetAuds(): void;
    get audsInput(): string[] | undefined;
    private _claimMappings?;
    get claimMappings(): {
        [key: string]: string;
    };
    set claimMappings(value: {
        [key: string]: string;
    });
    resetClaimMappings(): void;
    get claimMappingsInput(): {
        [key: string]: string;
    } | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    get clientSecretInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _discoveryCaPem?;
    get discoveryCaPem(): string[];
    set discoveryCaPem(value: string[]);
    resetDiscoveryCaPem(): void;
    get discoveryCaPemInput(): string[] | undefined;
    private _discoveryUrl?;
    get discoveryUrl(): string;
    set discoveryUrl(value: string);
    get discoveryUrlInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _listClaimMappings?;
    get listClaimMappings(): {
        [key: string]: string;
    };
    set listClaimMappings(value: {
        [key: string]: string;
    });
    resetListClaimMappings(): void;
    get listClaimMappingsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _scopes?;
    get scopes(): string[];
    set scopes(value: string[]);
    resetScopes(): void;
    get scopesInput(): string[] | undefined;
    private _signingAlgs?;
    get signingAlgs(): string[];
    set signingAlgs(value: string[]);
    resetSigningAlgs(): void;
    get signingAlgsInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
