/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ConfigSourceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Config Source Project
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/config_source#application ConfigSource#application}
    */
    readonly application?: string;
    /**
    * Configuration for the dynamic source type
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/config_source#config ConfigSource#config}
    */
    readonly config?: {
        [key: string]: string;
    };
    /**
    * Config Source Project
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/config_source#project ConfigSource#project}
    */
    readonly project?: string;
    /**
    * Config Source Scope
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/config_source#scope ConfigSource#scope}
    */
    readonly scope: string;
    /**
    * Config Source type
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/config_source#type ConfigSource#type}
    */
    readonly type: string;
    /**
    * Config Source Workspace
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/config_source#workspace ConfigSource#workspace}
    */
    readonly workspace?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/config_source waypoint_config_source}
*/
export declare class ConfigSource extends cdktf.TerraformResource {
    static readonly tfResourceType = "waypoint_config_source";
    /**
    * Generates CDKTF code for importing a ConfigSource resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ConfigSource to import
    * @param importFromId The id of the existing ConfigSource that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/config_source#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ConfigSource to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/config_source waypoint_config_source} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ConfigSourceConfig
    */
    constructor(scope: Construct, id: string, config: ConfigSourceConfig);
    private _application?;
    get application(): string;
    set application(value: string);
    resetApplication(): void;
    get applicationInput(): string | undefined;
    private _config?;
    get config(): {
        [key: string]: string;
    };
    set config(value: {
        [key: string]: string;
    });
    resetConfig(): void;
    get configInput(): {
        [key: string]: string;
    } | undefined;
    get id(): number;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    get scopeInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _workspace?;
    get workspace(): string;
    set workspace(value: string);
    resetWorkspace(): void;
    get workspaceInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
