/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataWaypointAppConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the Waypoint application.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/data-sources/app#app_name DataWaypointApp#app_name}
    */
    readonly appName: string;
    /**
    * The name of the Waypoint project.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/data-sources/app#project_name DataWaypointApp#project_name}
    */
    readonly projectName: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/data-sources/app waypoint_app}
*/
export declare class DataWaypointApp extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "waypoint_app";
    /**
    * Generates CDKTF code for importing a DataWaypointApp resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataWaypointApp to import
    * @param importFromId The id of the existing DataWaypointApp that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/data-sources/app#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataWaypointApp to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/data-sources/app waypoint_app} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataWaypointAppConfig
    */
    constructor(scope: Construct, id: string, config: DataWaypointAppConfig);
    private _appName?;
    get appName(): string;
    set appName(value: string);
    get appNameInput(): string | undefined;
    get fileChangeSignal(): string;
    private _projectName?;
    get projectName(): string;
    set projectName(value: string);
    get projectNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
