/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataWaypointAuthMethodConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the Auth Method
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/data-sources/auth_method#name DataWaypointAuthMethod#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/data-sources/auth_method waypoint_auth_method}
*/
export declare class DataWaypointAuthMethod extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "waypoint_auth_method";
    /**
    * Generates CDKTF code for importing a DataWaypointAuthMethod resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataWaypointAuthMethod to import
    * @param importFromId The id of the existing DataWaypointAuthMethod that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/data-sources/auth_method#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataWaypointAuthMethod to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/data-sources/auth_method waypoint_auth_method} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataWaypointAuthMethodConfig
    */
    constructor(scope: Construct, id: string, config: DataWaypointAuthMethodConfig);
    get accessorSelector(): string;
    get allowedRedirectUris(): string[];
    get auds(): string[];
    private _claimMappings;
    get claimMappings(): cdktf.StringMap;
    get clientId(): string;
    get description(): string;
    get discoveryCaPem(): string[];
    get discoveryUrl(): string;
    get displayName(): string;
    private _listClaimMappings;
    get listClaimMappings(): cdktf.StringMap;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get scopes(): string[];
    get signingAlgs(): string[];
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
