/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataWaypointProjectConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the Waypoint project
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/data-sources/project#project_name DataWaypointProject#project_name}
    */
    readonly projectName: string;
}
export interface DataWaypointProjectDataSourceGit {
}
export declare function dataWaypointProjectDataSourceGitToTerraform(struct?: DataWaypointProjectDataSourceGit): any;
export declare function dataWaypointProjectDataSourceGitToHclTerraform(struct?: DataWaypointProjectDataSourceGit): any;
export declare class DataWaypointProjectDataSourceGitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataWaypointProjectDataSourceGit | undefined;
    set internalValue(value: DataWaypointProjectDataSourceGit | undefined);
    get fileChangeSignal(): string;
    get gitPath(): string;
    get gitPollIntervalSeconds(): number;
    get gitRef(): string;
    get gitUrl(): string;
    get ignoreChangesOutsidePath(): cdktf.IResolvable;
}
export interface DataWaypointProjectGitAuthBasic {
    /**
    * Git password
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/data-sources/project#password DataWaypointProject#password}
    */
    readonly password: string;
    /**
    * Git username
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/data-sources/project#username DataWaypointProject#username}
    */
    readonly username: string;
}
export declare function dataWaypointProjectGitAuthBasicToTerraform(struct?: DataWaypointProjectGitAuthBasic): any;
export declare function dataWaypointProjectGitAuthBasicToHclTerraform(struct?: DataWaypointProjectGitAuthBasic): any;
export declare class DataWaypointProjectGitAuthBasicOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataWaypointProjectGitAuthBasic | undefined;
    set internalValue(value: DataWaypointProjectGitAuthBasic | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface DataWaypointProjectGitAuthSsh {
    /**
    * Private key to authenticate to Git
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/data-sources/project#ssh_private_key DataWaypointProject#ssh_private_key}
    */
    readonly sshPrivateKey: string;
}
export declare function dataWaypointProjectGitAuthSshToTerraform(struct?: DataWaypointProjectGitAuthSsh): any;
export declare function dataWaypointProjectGitAuthSshToHclTerraform(struct?: DataWaypointProjectGitAuthSsh): any;
export declare class DataWaypointProjectGitAuthSshOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataWaypointProjectGitAuthSsh | undefined;
    set internalValue(value: DataWaypointProjectGitAuthSsh | undefined);
    get gitUser(): string;
    get passphrase(): string;
    private _sshPrivateKey?;
    get sshPrivateKey(): string;
    set sshPrivateKey(value: string);
    get sshPrivateKeyInput(): string | undefined;
}
export interface DataWaypointProjectProjectVariables {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/data-sources/project#name DataWaypointProject#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/data-sources/project#value DataWaypointProject#value}
    */
    readonly value: string;
}
export declare function dataWaypointProjectProjectVariablesToTerraform(struct?: DataWaypointProjectProjectVariables): any;
export declare function dataWaypointProjectProjectVariablesToHclTerraform(struct?: DataWaypointProjectProjectVariables): any;
export declare class DataWaypointProjectProjectVariablesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataWaypointProjectProjectVariables | undefined;
    set internalValue(value: DataWaypointProjectProjectVariables | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get sensitive(): cdktf.IResolvable;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class DataWaypointProjectProjectVariablesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataWaypointProjectProjectVariables[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataWaypointProjectProjectVariablesOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/data-sources/project waypoint_project}
*/
export declare class DataWaypointProject extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "waypoint_project";
    /**
    * Generates CDKTF code for importing a DataWaypointProject resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataWaypointProject to import
    * @param importFromId The id of the existing DataWaypointProject that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/data-sources/project#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataWaypointProject to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/data-sources/project waypoint_project} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataWaypointProjectConfig
    */
    constructor(scope: Construct, id: string, config: DataWaypointProjectConfig);
    get appStatusPollSeconds(): number;
    get applications(): string[];
    private _dataSourceGit;
    get dataSourceGit(): DataWaypointProjectDataSourceGitOutputReference;
    private _gitAuthBasic;
    get gitAuthBasic(): DataWaypointProjectGitAuthBasicOutputReference;
    private _gitAuthSsh;
    get gitAuthSsh(): DataWaypointProjectGitAuthSshOutputReference;
    private _projectName?;
    get projectName(): string;
    set projectName(value: string);
    get projectNameInput(): string | undefined;
    private _projectVariables;
    get projectVariables(): DataWaypointProjectProjectVariablesList;
    get remoteRunnersEnabled(): cdktf.IResolvable;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
