/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataWaypointRunnerProfileConfig extends cdktf.TerraformMetaArguments {
    /**
    * The id of the Runner profile
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/data-sources/runner_profile#id DataWaypointRunnerProfile#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/data-sources/runner_profile waypoint_runner_profile}
*/
export declare class DataWaypointRunnerProfile extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "waypoint_runner_profile";
    /**
    * Generates CDKTF code for importing a DataWaypointRunnerProfile resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataWaypointRunnerProfile to import
    * @param importFromId The id of the existing DataWaypointRunnerProfile that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/data-sources/runner_profile#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataWaypointRunnerProfile to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/data-sources/runner_profile waypoint_runner_profile} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataWaypointRunnerProfileConfig
    */
    constructor(scope: Construct, id: string, config: DataWaypointRunnerProfileConfig);
    get default(): cdktf.IResolvable;
    private _environmentVariables;
    get environmentVariables(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    get ociUrl(): string;
    get pluginConfig(): string;
    get pluginConfigFormat(): string;
    get pluginType(): string;
    get profileName(): string;
    get targetRunnerId(): string;
    private _targetRunnerLabels;
    get targetRunnerLabels(): cdktf.StringMap;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
