/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProjectConfig extends cdktf.TerraformMetaArguments {
    /**
    * Application status poll interval in seconds
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/project#app_status_poll_seconds Project#app_status_poll_seconds}
    */
    readonly appStatusPollSeconds?: number;
    /**
    * Configuration of Git repository where waypoint.hcl file is stored
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/project#data_source_git Project#data_source_git}
    */
    readonly dataSourceGit: ProjectDataSourceGit;
    /**
    * Basic authentication details for Git consisting of `username` and `password`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/project#git_auth_basic Project#git_auth_basic}
    */
    readonly gitAuthBasic?: ProjectGitAuthBasic;
    /**
    * SSH authentication details for Git
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/project#git_auth_ssh Project#git_auth_ssh}
    */
    readonly gitAuthSsh?: ProjectGitAuthSsh;
    /**
    * The name of the Waypoint project
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/project#project_name Project#project_name}
    */
    readonly projectName: string;
    /**
    * List of variables in Key/value pairs associated with the Waypoint Project
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/project#project_variables Project#project_variables}
    */
    readonly projectVariables?: ProjectProjectVariables[] | cdktf.IResolvable;
    /**
    * Enable remote runners for project
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/project#remote_runners_enabled Project#remote_runners_enabled}
    */
    readonly remoteRunnersEnabled?: boolean | cdktf.IResolvable;
}
export interface ProjectDataSourceGit {
    /**
    * Indicates signal to be sent to any applications when their config files change.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/project#file_change_signal Project#file_change_signal}
    */
    readonly fileChangeSignal?: string;
    /**
    * Path in git repository when waypoint.hcl file is stored in a sub-directory
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/project#git_path Project#git_path}
    */
    readonly gitPath?: string;
    /**
    * Interval at which Waypoint should poll git repository for changes
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/project#git_poll_interval_seconds Project#git_poll_interval_seconds}
    */
    readonly gitPollIntervalSeconds?: number;
    /**
    * Git repository ref containing waypoint.hcl file
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/project#git_ref Project#git_ref}
    */
    readonly gitRef?: string;
    /**
    * Url of git repository storing the waypoint.hcl file
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/project#git_url Project#git_url}
    */
    readonly gitUrl?: string;
    /**
    * Whether Waypoint ignores changes outside path storing waypoint.hcl file
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/project#ignore_changes_outside_path Project#ignore_changes_outside_path}
    */
    readonly ignoreChangesOutsidePath?: boolean | cdktf.IResolvable;
}
export declare function projectDataSourceGitToTerraform(struct?: ProjectDataSourceGit | cdktf.IResolvable): any;
export declare function projectDataSourceGitToHclTerraform(struct?: ProjectDataSourceGit | cdktf.IResolvable): any;
export declare class ProjectDataSourceGitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ProjectDataSourceGit | cdktf.IResolvable | undefined;
    set internalValue(value: ProjectDataSourceGit | cdktf.IResolvable | undefined);
    private _fileChangeSignal?;
    get fileChangeSignal(): string;
    set fileChangeSignal(value: string);
    resetFileChangeSignal(): void;
    get fileChangeSignalInput(): string | undefined;
    private _gitPath?;
    get gitPath(): string;
    set gitPath(value: string);
    resetGitPath(): void;
    get gitPathInput(): string | undefined;
    private _gitPollIntervalSeconds?;
    get gitPollIntervalSeconds(): number;
    set gitPollIntervalSeconds(value: number);
    resetGitPollIntervalSeconds(): void;
    get gitPollIntervalSecondsInput(): number | undefined;
    private _gitRef?;
    get gitRef(): string;
    set gitRef(value: string);
    resetGitRef(): void;
    get gitRefInput(): string | undefined;
    private _gitUrl?;
    get gitUrl(): string;
    set gitUrl(value: string);
    resetGitUrl(): void;
    get gitUrlInput(): string | undefined;
    private _ignoreChangesOutsidePath?;
    get ignoreChangesOutsidePath(): boolean | cdktf.IResolvable;
    set ignoreChangesOutsidePath(value: boolean | cdktf.IResolvable);
    resetIgnoreChangesOutsidePath(): void;
    get ignoreChangesOutsidePathInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ProjectGitAuthBasic {
    /**
    * Git password
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/project#password Project#password}
    */
    readonly password: string;
    /**
    * Git username
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/project#username Project#username}
    */
    readonly username: string;
}
export declare function projectGitAuthBasicToTerraform(struct?: ProjectGitAuthBasic | cdktf.IResolvable): any;
export declare function projectGitAuthBasicToHclTerraform(struct?: ProjectGitAuthBasic | cdktf.IResolvable): any;
export declare class ProjectGitAuthBasicOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ProjectGitAuthBasic | cdktf.IResolvable | undefined;
    set internalValue(value: ProjectGitAuthBasic | cdktf.IResolvable | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface ProjectGitAuthSsh {
    /**
    * Git user associated with private key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/project#git_user Project#git_user}
    */
    readonly gitUser?: string;
    /**
    * Passphrase to use with private key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/project#passphrase Project#passphrase}
    */
    readonly passphrase?: string;
    /**
    * Private key to authenticate to Git
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/project#ssh_private_key Project#ssh_private_key}
    */
    readonly sshPrivateKey: string;
}
export declare function projectGitAuthSshToTerraform(struct?: ProjectGitAuthSsh | cdktf.IResolvable): any;
export declare function projectGitAuthSshToHclTerraform(struct?: ProjectGitAuthSsh | cdktf.IResolvable): any;
export declare class ProjectGitAuthSshOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ProjectGitAuthSsh | cdktf.IResolvable | undefined;
    set internalValue(value: ProjectGitAuthSsh | cdktf.IResolvable | undefined);
    private _gitUser?;
    get gitUser(): string;
    set gitUser(value: string);
    resetGitUser(): void;
    get gitUserInput(): string | undefined;
    private _passphrase?;
    get passphrase(): string;
    set passphrase(value: string);
    resetPassphrase(): void;
    get passphraseInput(): string | undefined;
    private _sshPrivateKey?;
    get sshPrivateKey(): string;
    set sshPrivateKey(value: string);
    get sshPrivateKeyInput(): string | undefined;
}
export interface ProjectProjectVariables {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/project#name Project#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/project#sensitive Project#sensitive}
    */
    readonly sensitive?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/project#value Project#value}
    */
    readonly value: string;
}
export declare function projectProjectVariablesToTerraform(struct?: ProjectProjectVariables | cdktf.IResolvable): any;
export declare function projectProjectVariablesToHclTerraform(struct?: ProjectProjectVariables | cdktf.IResolvable): any;
export declare class ProjectProjectVariablesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProjectProjectVariables | cdktf.IResolvable | undefined;
    set internalValue(value: ProjectProjectVariables | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _sensitive?;
    get sensitive(): boolean | cdktf.IResolvable;
    set sensitive(value: boolean | cdktf.IResolvable);
    resetSensitive(): void;
    get sensitiveInput(): boolean | cdktf.IResolvable | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class ProjectProjectVariablesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ProjectProjectVariables[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProjectProjectVariablesOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/project waypoint_project}
*/
export declare class Project extends cdktf.TerraformResource {
    static readonly tfResourceType = "waypoint_project";
    /**
    * Generates CDKTF code for importing a Project resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Project to import
    * @param importFromId The id of the existing Project that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/project#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Project to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/project waypoint_project} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProjectConfig
    */
    constructor(scope: Construct, id: string, config: ProjectConfig);
    private _appStatusPollSeconds?;
    get appStatusPollSeconds(): number;
    set appStatusPollSeconds(value: number);
    resetAppStatusPollSeconds(): void;
    get appStatusPollSecondsInput(): number | undefined;
    private _dataSourceGit;
    get dataSourceGit(): ProjectDataSourceGitOutputReference;
    putDataSourceGit(value: ProjectDataSourceGit): void;
    get dataSourceGitInput(): ProjectDataSourceGit | cdktf.IResolvable | undefined;
    private _gitAuthBasic;
    get gitAuthBasic(): ProjectGitAuthBasicOutputReference;
    putGitAuthBasic(value: ProjectGitAuthBasic): void;
    resetGitAuthBasic(): void;
    get gitAuthBasicInput(): ProjectGitAuthBasic | cdktf.IResolvable | undefined;
    private _gitAuthSsh;
    get gitAuthSsh(): ProjectGitAuthSshOutputReference;
    putGitAuthSsh(value: ProjectGitAuthSsh): void;
    resetGitAuthSsh(): void;
    get gitAuthSshInput(): ProjectGitAuthSsh | cdktf.IResolvable | undefined;
    get id(): string;
    private _projectName?;
    get projectName(): string;
    set projectName(value: string);
    get projectNameInput(): string | undefined;
    private _projectVariables;
    get projectVariables(): ProjectProjectVariablesList;
    putProjectVariables(value: ProjectProjectVariables[] | cdktf.IResolvable): void;
    resetProjectVariables(): void;
    get projectVariablesInput(): cdktf.IResolvable | ProjectProjectVariables[] | undefined;
    private _remoteRunnersEnabled?;
    get remoteRunnersEnabled(): boolean | cdktf.IResolvable;
    set remoteRunnersEnabled(value: boolean | cdktf.IResolvable);
    resetRemoteRunnersEnabled(): void;
    get remoteRunnersEnabledInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
