/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RunnerProfileConfig extends cdktf.TerraformMetaArguments {
    /**
    * Indicates if this runner profile is the default for any new projects. The default is false
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/runner_profile#default RunnerProfile#default}
    */
    readonly default?: boolean | cdktf.IResolvable;
    /**
    * Any environment variables that should be exposed to the on demand runner.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/runner_profile#environment_variables RunnerProfile#environment_variables}
    */
    readonly environmentVariables?: {
        [key: string]: string;
    };
    /**
    * The name of the runner profile
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/runner_profile#name RunnerProfile#name}
    */
    readonly name: string;
    /**
    * oci_url is the OCI image that will be used to boot the on demand runner.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/runner_profile#oci_url RunnerProfile#oci_url}
    */
    readonly ociUrl?: string;
    /**
    * Plugin config is the configuration for the plugin that is created. It is usually HCL and is decoded like the other plugins, and is plugin specific.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/runner_profile#plugin_config RunnerProfile#plugin_config}
    */
    readonly pluginConfig?: string;
    /**
    * Config format specifies the format of plugin_config. Valid values are HCL or JSON. The default is HCL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/runner_profile#plugin_config_format RunnerProfile#plugin_config_format}
    */
    readonly pluginConfigFormat?: string;
    /**
    * Plugin type for runner i.e docker / kubernetes / aws-ecs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/runner_profile#plugin_type RunnerProfile#plugin_type}
    */
    readonly pluginType: string;
    /**
    * The ID of the target runner for this profile.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/runner_profile#target_runner_id RunnerProfile#target_runner_id}
    */
    readonly targetRunnerId?: string;
    /**
    * A map of labels on target runners
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/runner_profile#target_runner_labels RunnerProfile#target_runner_labels}
    */
    readonly targetRunnerLabels?: {
        [key: string]: string;
    };
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/runner_profile waypoint_runner_profile}
*/
export declare class RunnerProfile extends cdktf.TerraformResource {
    static readonly tfResourceType = "waypoint_runner_profile";
    /**
    * Generates CDKTF code for importing a RunnerProfile resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the RunnerProfile to import
    * @param importFromId The id of the existing RunnerProfile that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/runner_profile#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the RunnerProfile to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/waypoint/0.1.0/docs/resources/runner_profile waypoint_runner_profile} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RunnerProfileConfig
    */
    constructor(scope: Construct, id: string, config: RunnerProfileConfig);
    private _default?;
    get default(): boolean | cdktf.IResolvable;
    set default(value: boolean | cdktf.IResolvable);
    resetDefault(): void;
    get defaultInput(): boolean | cdktf.IResolvable | undefined;
    private _environmentVariables?;
    get environmentVariables(): {
        [key: string]: string;
    };
    set environmentVariables(value: {
        [key: string]: string;
    });
    resetEnvironmentVariables(): void;
    get environmentVariablesInput(): {
        [key: string]: string;
    } | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _ociUrl?;
    get ociUrl(): string;
    set ociUrl(value: string);
    resetOciUrl(): void;
    get ociUrlInput(): string | undefined;
    private _pluginConfig?;
    get pluginConfig(): string;
    set pluginConfig(value: string);
    resetPluginConfig(): void;
    get pluginConfigInput(): string | undefined;
    private _pluginConfigFormat?;
    get pluginConfigFormat(): string;
    set pluginConfigFormat(value: string);
    resetPluginConfigFormat(): void;
    get pluginConfigFormatInput(): string | undefined;
    private _pluginType?;
    get pluginType(): string;
    set pluginType(value: string);
    get pluginTypeInput(): string | undefined;
    private _targetRunnerId?;
    get targetRunnerId(): string;
    set targetRunnerId(value: string);
    resetTargetRunnerId(): void;
    get targetRunnerIdInput(): string | undefined;
    private _targetRunnerLabels?;
    get targetRunnerLabels(): {
        [key: string]: string;
    };
    set targetRunnerLabels(value: {
        [key: string]: string;
    });
    resetTargetRunnerLabels(): void;
    get targetRunnerLabelsInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
