"""Stream type classes for tap-exactonline."""
import logging

from singer_sdk import typing as th  # JSON Schema typing helpers
from tap_exactonline.client import ExactOnlineStream


class ContactsStream(ExactOnlineStream):
    name = "contacts"
    path = "crm/Contacts"
    primary_keys = ["HID"]
    replication_key = "Modified"
    schema = th.PropertiesList(
        th.Property("Account", th.UUIDType),
        th.Property("AccountIsCustomer", th.BooleanType),
        th.Property("AccountIsSupplier", th.BooleanType),
        th.Property("AccountMainContact", th.UUIDType),
        th.Property("AccountName", th.StringType),
        th.Property("AddressLine2", th.StringType),
        th.Property("AddressStreet", th.StringType),
        th.Property("AddressStreetNumber", th.StringType),
        th.Property("AddressStreetNumberSuffix", th.StringType),
        th.Property("AllowMailing", th.IntegerType),
        th.Property("BirthDate", th.DateTimeType),
        th.Property("BirthName", th.StringType),
        th.Property("BirthNamePrefix", th.StringType),
        th.Property("BirthPlace", th.StringType),
        th.Property("BusinessEmail", th.StringType),
        th.Property("BusinessFax", th.StringType),
        th.Property("BusinessMobile", th.StringType),
        th.Property("BusinessPhone", th.StringType),
        th.Property("BusinessPhoneExtension", th.StringType),
        th.Property("City", th.StringType),
        th.Property("Code", th.StringType),
        th.Property("Country", th.StringType),
        th.Property("Created", th.DateTimeType),
        th.Property("Creator", th.UUIDType),
        th.Property("CreatorFullName", th.StringType),
        th.Property("CustomField", th.StringType),
        th.Property("Division", th.IntegerType),
        th.Property("Email", th.StringType),
        th.Property("EndDate", th.DateTimeType),
        th.Property("FirstName", th.StringType),
        th.Property("FullName", th.StringType),
        th.Property("Gender", th.StringType),
        th.Property("HID", th.IntegerType),
        th.Property("IdentificationDate", th.DateTimeType),
        th.Property("IdentificationDocument", th.UUIDType),
        th.Property("IdentificationUser", th.UUIDType),
        th.Property("Initials", th.StringType),
        th.Property("IsAnonymised", th.IntegerType),
        th.Property("IsMailingExcluded", th.BooleanType),
        th.Property("IsMainContact", th.BooleanType),
        th.Property("JobTitleDescription", th.StringType),
        th.Property("Language", th.StringType),
        th.Property("LastName", th.StringType),
        th.Property("LeadPurpose", th.UUIDType),
        th.Property("LeadSource", th.UUIDType),
        th.Property("MarketingNotes", th.StringType),
        th.Property("MiddleName", th.StringType),
        th.Property("Mobile", th.StringType),
        th.Property("Modified", th.DateTimeType),
        th.Property("Modifier", th.UUIDType),
        th.Property("ModifierFullName", th.StringType),
        th.Property("Nationality", th.StringType),
        th.Property("Notes", th.StringType),
        th.Property("PartnerName", th.StringType),
        th.Property("PartnerNamePrefix", th.StringType),
        th.Property("Person", th.UUIDType),
        th.Property("Phone", th.StringType),
        th.Property("PhoneExtension", th.StringType),
        th.Property("Picture", th.StringType),
        th.Property("PictureName", th.StringType),
        th.Property("PictureThumbnailUrl", th.StringType),
        th.Property("PictureUrl", th.StringType),
        th.Property("Postcode", th.StringType),
        th.Property("SocialSecurityNumber", th.StringType),
        th.Property("StartDate", th.DateTimeType),
        th.Property("State", th.StringType),
        th.Property("Title", th.StringType),
    ).to_dict()


class InvoiceStream(ExactOnlineStream):
    name = "invoices"
    path = "bulk/SalesInvoice/SalesInvoices"
    primary_keys = ["InvoiceID"]
    replication_key = "Created"
    schema = th.PropertiesList(
        th.Property("InvoiceID", th.UUIDType),
        th.Property("AmountDC", th.NumberType),
        th.Property("AmountDiscount", th.NumberType),
        th.Property("AmountDiscountExclVat", th.NumberType),
        th.Property("AmountFC", th.NumberType),
        th.Property("AmountFCExclVat", th.NumberType),
        th.Property("Created", th.DateTimeType),
        th.Property("Creator", th.UUIDType),
        th.Property("CreatorFullName", th.StringType),
        th.Property("Currency", th.StringType),
        th.Property("DeliverTo", th.UUIDType),
        th.Property("DeliverToAddress", th.UUIDType),
        th.Property("DeliverToContactPerson", th.UUIDType),
        th.Property("DeliverToContactPersonFullName", th.StringType),
        th.Property("DeliverToName", th.StringType),
        th.Property("Description", th.StringType),
        th.Property("Discount", th.NumberType),
        th.Property("DiscountType", th.IntegerType),
        th.Property("Division", th.IntegerType),
        th.Property("Document", th.UUIDType),
        th.Property("DocumentNumber", th.IntegerType),
        th.Property("DocumentSubject", th.StringType),
        th.Property("DueDate", th.DateTimeType),
        th.Property("ExtraDutyAmountFC", th.NumberType),
        th.Property("GAccountAmountFC", th.NumberType),
        th.Property("IncotermAddress", th.StringType),
        th.Property("IncotermCode", th.StringType),
        th.Property("IncotermVersion", th.IntegerType),
        th.Property("InvoiceDate", th.DateTimeType),
        th.Property("InvoiceNumber", th.IntegerType),
        th.Property("InvoiceTo", th.UUIDType),
        th.Property("InvoiceToContactPerson", th.UUIDType),
        th.Property("InvoiceToContactPersonFullName", th.StringType),
        th.Property("InvoiceToName", th.StringType),
        th.Property("IsExtraDuty", th.StringType),
        th.Property("Journal", th.StringType),
        th.Property("JournalDescription", th.StringType),
        th.Property("Modified", th.DateTimeType),
        th.Property("Modifier", th.UUIDType),
        th.Property("ModifierFullName", th.StringType),
        th.Property("OrderDate", th.DateTimeType),
        th.Property("OrderedBy", th.UUIDType),
        th.Property("OrderedByContactPerson", th.UUIDType),
        th.Property("OrderedByContactPersonFullName", th.StringType),
        th.Property("OrderedByName", th.StringType),
        th.Property("OrderNumber", th.IntegerType),
        th.Property("PaymentCondition", th.StringType),
        th.Property("PaymentConditionDescription", th.StringType),
        th.Property("PaymentReference", th.StringType),
        th.Property("Remarks", th.StringType),
        th.Property("SalesChannel", th.UUIDType),
        th.Property("SalesChannelCode", th.StringType),
        th.Property("SalesChannelDescription", th.StringType),
        th.Property("SalesInvoiceLines", th.StringType),
        th.Property("Salesperson", th.UUIDType),
        th.Property("SalespersonFullName", th.StringType),
        th.Property("SelectionCode", th.UUIDType),
        th.Property("SelectionCodeCode", th.StringType),
        th.Property("SelectionCodeDescription", th.StringType),
        th.Property("ShippingMethod", th.UUIDType),
        th.Property("ShippingMethodCode", th.StringType),
        th.Property("ShippingMethodDescription", th.StringType),
        th.Property("StarterSalesInvoiceStatus", th.IntegerType),
        th.Property("StarterSalesInvoiceStatusDescription", th.StringType),
        th.Property("Status", th.IntegerType),
        th.Property("StatusDescription", th.StringType),
        th.Property("TaxSchedule", th.UUIDType),
        th.Property("TaxScheduleCode", th.StringType),
        th.Property("TaxScheduleDescription", th.StringType),
        th.Property("Type", th.IntegerType),
        th.Property("TypeDescription", th.StringType),
        th.Property("VATAmountDC", th.NumberType),
        th.Property("VATAmountFC", th.NumberType),
        th.Property("Warehouse", th.UUIDType),
        th.Property("WithholdingTaxAmountFC", th.NumberType),
        th.Property("WithholdingTaxBaseAmount", th.NumberType),
        th.Property("WithholdingTaxPercentage", th.NumberType),
        th.Property("YourRef", th.StringType),
    ).to_dict()


class InvoiceLineStream(ExactOnlineStream):
    name = "invoice_lines"
    path = "bulk/SalesInvoice/SalesInvoiceLines"
    primary_keys = ["ID"]
    schema = th.PropertiesList(
        th.Property("ID", th.UUIDType),
        th.Property("AmountDC", th.NumberType),
        th.Property("AmountFC", th.NumberType),
        th.Property("CostCenter", th.StringType),
        th.Property("CostCenterDescription", th.StringType),
        th.Property("CostUnit", th.StringType),
        th.Property("CostUnitDescription", th.StringType),
        th.Property("CustomerItemCode", th.StringType),
        th.Property("DeliveryDate", th.DateTimeType),
        th.Property("Description", th.StringType),
        th.Property("Discount", th.NumberType),
        th.Property("Division", th.IntegerType),
        th.Property("Employee", th.UUIDType),
        th.Property("EmployeeFullName", th.StringType),
        th.Property("EndTime", th.DateTimeType),
        th.Property("ExtraDutyAmountFC", th.NumberType),
        th.Property("ExtraDutyPercentage", th.NumberType),
        th.Property("GLAccount", th.UUIDType),
        th.Property("GLAccountDescription", th.StringType),
        th.Property("InvoiceID", th.UUIDType),
        th.Property("Item", th.UUIDType),
        th.Property("ItemCode", th.StringType),
        th.Property("ItemDescription", th.StringType),
        th.Property("LineNumber", th.IntegerType),
        th.Property("NetPrice", th.NumberType),
        th.Property("Notes", th.StringType),
        th.Property("Pricelist", th.UUIDType),
        th.Property("PricelistDescription", th.StringType),
        th.Property("Project", th.UUIDType),
        th.Property("ProjectDescription", th.StringType),
        th.Property("ProjectWBS", th.UUIDType),
        th.Property("ProjectWBSDescription", th.StringType),
        th.Property("Quantity", th.NumberType),
        th.Property("SalesOrder", th.UUIDType),
        th.Property("SalesOrderLine", th.UUIDType),
        th.Property("SalesOrderLineNumber", th.IntegerType),
        th.Property("SalesOrderNumber", th.IntegerType),
        th.Property("StartTime", th.DateTimeType),
        th.Property("Subscription", th.UUIDType),
        th.Property("SubscriptionDescription", th.StringType),
        th.Property("TaxSchedule", th.UUIDType),
        th.Property("TaxScheduleCode", th.StringType),
        th.Property("TaxScheduleDescription", th.StringType),
        th.Property("UnitCode", th.StringType),
        th.Property("UnitDescription", th.StringType),
        th.Property("UnitPrice", th.NumberType),
        th.Property("VATAmountDC", th.NumberType),
        th.Property("VATAmountFC", th.NumberType),
        th.Property("VATCode", th.StringType),
        th.Property("VATCodeDescription", th.StringType),
        th.Property("VATPercentage", th.NumberType),
    ).to_dict()


class PaymentsStream(ExactOnlineStream):
    name = "payments"
    path = "bulk/Cashflow/Payments"
    primary_keys = ["EntryID"]
    schema = th.PropertiesList(
        th.Property("Account", th.UUIDType),
        th.Property("AccountBankAccountID", th.UUIDType),
        th.Property("AccountBankAccountNumber", th.StringType),
        th.Property("AccountCode", th.StringType),
        th.Property("AccountContact", th.UUIDType),
        th.Property("AccountContactName", th.StringType),
        th.Property("AccountName", th.StringType),
        th.Property("AmountDC", th.NumberType),
        th.Property("AmountDiscountDC", th.NumberType),
        th.Property("AmountDiscountFC", th.NumberType),
        th.Property("AmountFC", th.NumberType),
        th.Property("BankAccountID", th.UUIDType),
        th.Property("BankAccountNumber", th.StringType),
        th.Property("CashflowTransactionBatchCode", th.StringType),
        th.Property("Created", th.DateTimeType),
        th.Property("Creator", th.UUIDType),
        th.Property("CreatorFullName", th.StringType),
        th.Property("Currency", th.StringType),
        th.Property("Description", th.StringType),
        th.Property("DiscountDueDate", th.DateTimeType),
        th.Property("Division", th.IntegerType),
        th.Property("Document", th.UUIDType),
        th.Property("DocumentNumber", th.IntegerType),
        th.Property("DocumentSubject", th.StringType),
        th.Property("DueDate", th.DateTimeType),
        th.Property("EndDate", th.DateTimeType),
        th.Property("EndPeriod", th.IntegerType),
        th.Property("EndYear", th.IntegerType),
        th.Property("EntryDate", th.DateTimeType),
        th.Property("EntryID", th.UUIDType),
        th.Property("EntryNumber", th.IntegerType),
        th.Property("GLAccount", th.UUIDType),
        th.Property("GLAccountCode", th.StringType),
        th.Property("GLAccountDescription", th.StringType),
        th.Property("InvoiceDate", th.DateTimeType),
        th.Property("InvoiceNumber", th.IntegerType),
        th.Property("IsBatchBooking", th.IntegerType),
        th.Property("Journal", th.StringType),
        th.Property("JournalDescription", th.StringType),
        th.Property("Modified", th.DateTimeType),
        th.Property("Modifier", th.UUIDType),
        th.Property("ModifierFullName", th.StringType),
        th.Property("PaymentBatchNumber", th.IntegerType),
        th.Property("PaymentCondition", th.StringType),
        th.Property("PaymentConditionDescription", th.StringType),
        th.Property("PaymentDays", th.IntegerType),
        th.Property("PaymentDaysDiscount", th.IntegerType),
        th.Property("PaymentDiscountPercentage", th.NumberType),
        th.Property("PaymentMethod", th.StringType),
        th.Property("PaymentReference", th.StringType),
        th.Property("PaymentSelected", th.DateTimeType),
        th.Property("PaymentSelector", th.UUIDType),
        th.Property("PaymentSelectorFullName", th.StringType),
        th.Property("RateFC", th.NumberType),
        th.Property("Source", th.IntegerType),
        th.Property("Status", th.IntegerType),
        th.Property("TransactionAmountDC", th.NumberType),
        th.Property("TransactionAmountFC", th.NumberType),
        th.Property("TransactionDueDate", th.DateTimeType),
        th.Property("TransactionEntryID", th.UUIDType),
        th.Property("TransactionID", th.UUIDType),
        th.Property("TransactionIsReversal", th.BooleanType),
        th.Property("TransactionReportingPeriod", th.IntegerType),
        th.Property("TransactionReportingYear", th.IntegerType),
        th.Property("TransactionStatus", th.IntegerType),
        th.Property("TransactionType", th.IntegerType),
        th.Property("YourRef", th.StringType),
    ).to_dict()


class ReceivablesStream(ExactOnlineStream):
    name = "receivables"
    path = "bulk/Cashflow/Receivables"
    primary_keys = ["EntryID"]
    schema = th.PropertiesList(
        th.Property("Account", th.UUIDType),
        th.Property("AccountBankAccountID", th.UUIDType),
        th.Property("AccountBankAccountNumber", th.StringType),
        th.Property("AccountCode", th.StringType),
        th.Property("AccountContact", th.UUIDType),
        th.Property("AccountContactName", th.StringType),
        th.Property("AccountCountry", th.StringType),
        th.Property("AccountName", th.StringType),
        th.Property("AmountDC", th.NumberType),
        th.Property("AmountDiscountDC", th.NumberType),
        th.Property("AmountDiscountFC", th.NumberType),
        th.Property("AmountFC", th.NumberType),
        th.Property("BankAccountID", th.UUIDType),
        th.Property("BankAccountNumber", th.StringType),
        th.Property("CashflowTransactionBatchCode", th.StringType),
        th.Property("Created", th.DateTimeType),
        th.Property("Creator", th.UUIDType),
        th.Property("CreatorFullName", th.StringType),
        th.Property("Currency", th.StringType),
        th.Property("Description", th.StringType),
        th.Property("DirectDebitMandate", th.UUIDType),
        th.Property("DirectDebitMandateDescription", th.StringType),
        th.Property("DirectDebitMandatePaymentType", th.IntegerType),
        th.Property("DirectDebitMandateReference", th.StringType),
        th.Property("DirectDebitMandateType", th.IntegerType),
        th.Property("DiscountDueDate", th.DateTimeType),
        th.Property("Division", th.IntegerType),
        th.Property("Document", th.UUIDType),
        th.Property("DocumentNumber", th.IntegerType),
        th.Property("DocumentSubject", th.StringType),
        th.Property("DueDate", th.DateTimeType),
        th.Property("EndDate", th.DateTimeType),
        th.Property("EndPeriod", th.IntegerType),
        th.Property("EndToEndID", th.StringType),
        th.Property("EndYear", th.IntegerType),
        th.Property("EntryDate", th.DateTimeType),
        th.Property("EntryID", th.UUIDType),
        th.Property("EntryNumber", th.IntegerType),
        th.Property("GLAccount", th.UUIDType),
        th.Property("GLAccountCode", th.StringType),
        th.Property("GLAccountDescription", th.StringType),
        th.Property("InvoiceDate", th.DateTimeType),
        th.Property("InvoiceNumber", th.IntegerType),
        th.Property("IsBatchBooking", th.IntegerType),
        th.Property("IsFullyPaid", th.BooleanType),
        th.Property("Journal", th.StringType),
        th.Property("JournalDescription", th.StringType),
        th.Property("LastPaymentDate", th.DateTimeType),
        th.Property("Modified", th.DateTimeType),
        th.Property("Modifier", th.UUIDType),
        th.Property("ModifierFullName", th.StringType),
        th.Property("OrderNumber", th.IntegerType),
        th.Property("PaymentCondition", th.StringType),
        th.Property("PaymentConditionDescription", th.StringType),
        th.Property("PaymentDays", th.IntegerType),
        th.Property("PaymentDaysDiscount", th.IntegerType),
        th.Property("PaymentDiscountPercentage", th.NumberType),
        th.Property("PaymentInformationID", th.StringType),
        th.Property("PaymentMethod", th.StringType),
        th.Property("PaymentReference", th.StringType),
        th.Property("RateFC", th.NumberType),
        th.Property("ReceivableBatchNumber", th.IntegerType),
        th.Property("ReceivableSelected", th.DateTimeType),
        th.Property("ReceivableSelector", th.UUIDType),
        th.Property("ReceivableSelectorFullName", th.StringType),
        th.Property("Source", th.IntegerType),
        th.Property("Status", th.IntegerType),
        th.Property("TransactionAmountDC", th.NumberType),
        th.Property("TransactionAmountFC", th.NumberType),
        th.Property("TransactionDueDate", th.DateTimeType),
        th.Property("TransactionEntryID", th.UUIDType),
        th.Property("TransactionID", th.UUIDType),
        th.Property("TransactionIsReversal", th.BooleanType),
        th.Property("TransactionReportingPeriod", th.IntegerType),
        th.Property("TransactionReportingYear", th.IntegerType),
        th.Property("TransactionStatus", th.IntegerType),
        th.Property("TransactionType", th.IntegerType),
        th.Property("YourRef", th.StringType),
    ).to_dict()


class AccountsStream(ExactOnlineStream):
    name = "accounts"
    path = "bulk/CRM/Accounts"
    primary_keys = ["ID"]
    replication_key = "Modified"
    schema = th.PropertiesList(
        th.Property("ID", th.UUIDType),
        th.Property("Accountant", th.UUIDType),
        th.Property("AccountManager", th.UUIDType),
        th.Property("AccountManagerFullName", th.StringType),
        th.Property("AccountManagerHID", th.IntegerType),
        th.Property("ActivitySector", th.UUIDType),
        th.Property("ActivitySubSector", th.UUIDType),
        th.Property("AddressLine1", th.StringType),
        th.Property("AddressLine2", th.StringType),
        th.Property("AddressLine3", th.StringType),
        th.Property("BankAccounts", th.StringType),
        th.Property("Blocked", th.BooleanType),
        th.Property("BRIN", th.UUIDType),
        th.Property("BSN", th.StringType),
        th.Property("BusinessType", th.UUIDType),
        th.Property("CanDropShip", th.BooleanType),
        th.Property("ChamberOfCommerce", th.StringType),
        th.Property("City", th.StringType),
        th.Property("Classification", th.StringType),
        th.Property("Classification1", th.UUIDType),
        th.Property("Classification2", th.UUIDType),
        th.Property("Classification3", th.UUIDType),
        th.Property("Classification4", th.UUIDType),
        th.Property("Classification5", th.UUIDType),
        th.Property("Classification6", th.UUIDType),
        th.Property("Classification7", th.UUIDType),
        th.Property("Classification8", th.UUIDType),
        th.Property("ClassificationDescription", th.StringType),
        th.Property("Code", th.StringType),
        th.Property("CodeAtSupplier", th.StringType),
        th.Property("CompanySize", th.UUIDType),
        th.Property("ConsolidationScenario", th.IntegerType),
        th.Property("ControlledDate", th.DateTimeType),
        th.Property("Costcenter", th.StringType),
        th.Property("CostcenterDescription", th.StringType),
        th.Property("CostPaid", th.IntegerType),
        th.Property("Country", th.StringType),
        th.Property("CountryName", th.StringType),
        th.Property("Created", th.DateTimeType),
        th.Property("Creator", th.UUIDType),
        th.Property("CreatorFullName", th.StringType),
        th.Property("CreditLinePurchase", th.NumberType),
        th.Property("CreditLineSales", th.NumberType),
        th.Property("Currency", th.StringType),
        th.Property("CustomerSince", th.DateTimeType),
        th.Property("CustomField", th.StringType),
        th.Property("DatevCreditorCode", th.StringType),
        th.Property("DatevDebtorCode", th.StringType),
        th.Property("DiscountPurchase", th.NumberType),
        th.Property("DiscountSales", th.NumberType),
        th.Property("Division", th.IntegerType),
        th.Property("Document", th.UUIDType),
        th.Property("DunsNumber", th.StringType),
        th.Property("Email", th.StringType),
        th.Property("EndDate", th.DateTimeType),
        th.Property("EORINumber", th.StringType),
        th.Property("EstablishedDate", th.DateTimeType),
        th.Property("Fax", th.StringType),
        th.Property("GLAccountPurchase", th.UUIDType),
        th.Property("GLAccountSales", th.UUIDType),
        th.Property("GLAP", th.UUIDType),
        th.Property("GLAR", th.UUIDType),
        th.Property("GlnNumber", th.StringType),
        th.Property("HasWithholdingTaxSales", th.BooleanType),
        th.Property("IgnoreDatevWarningMessage", th.BooleanType),
        th.Property("IncotermAddressPurchase", th.StringType),
        th.Property("IncotermAddressSales", th.StringType),
        th.Property("IncotermCodePurchase", th.StringType),
        th.Property("IncotermCodeSales", th.StringType),
        th.Property("IncotermVersionPurchase", th.IntegerType),
        th.Property("IncotermVersionSales", th.IntegerType),
        th.Property("IntraStatArea", th.StringType),
        th.Property("IntraStatDeliveryTerm", th.StringType),
        th.Property("IntraStatSystem", th.StringType),
        th.Property("IntraStatTransactionA", th.StringType),
        th.Property("IntraStatTransactionB", th.StringType),
        th.Property("IntraStatTransportMethod", th.StringType),
        th.Property("InvoiceAccount", th.UUIDType),
        th.Property("InvoiceAccountCode", th.StringType),
        th.Property("InvoiceAccountName", th.StringType),
        th.Property("InvoiceAttachmentType", th.IntegerType),
        th.Property("InvoicingMethod", th.IntegerType),
        th.Property("IsAccountant", th.IntegerType),
        th.Property("IsAgency", th.IntegerType),
        th.Property("IsAnonymised", th.IntegerType),
        th.Property("IsBank", th.BooleanType),
        th.Property("IsCompetitor", th.IntegerType),
        th.Property("IsExtraDuty", th.BooleanType),
        th.Property("IsMailing", th.IntegerType),
        th.Property("IsMember", th.BooleanType),
        th.Property("IsPilot", th.BooleanType),
        th.Property("IsPurchase", th.BooleanType),
        th.Property("IsReseller", th.BooleanType),
        th.Property("IsSales", th.BooleanType),
        th.Property("IsSupplier", th.BooleanType),
        th.Property("Language", th.StringType),
        th.Property("LanguageDescription", th.StringType),
        th.Property("Latitude", th.NumberType),
        th.Property("LeadPurpose", th.UUIDType),
        th.Property("LeadSource", th.UUIDType),
        th.Property("Logo", th.StringType),
        th.Property("LogoFileName", th.StringType),
        th.Property("LogoThumbnailUrl", th.StringType),
        th.Property("LogoUrl", th.StringType),
        th.Property("Longitude", th.NumberType),
        th.Property("MainContact", th.UUIDType),
        th.Property("Modified", th.DateTimeType),
        th.Property("Modifier", th.UUIDType),
        th.Property("ModifierFullName", th.StringType),
        th.Property("Name", th.StringType),
        th.Property("OINNumber", th.StringType),
        th.Property("Parent", th.UUIDType),
        th.Property("PayAsYouEarn", th.StringType),
        th.Property("PaymentConditionPurchase", th.StringType),
        th.Property("PaymentConditionPurchaseDescription", th.StringType),
        th.Property("PaymentConditionSales", th.StringType),
        th.Property("PaymentConditionSalesDescription", th.StringType),
        th.Property("Phone", th.StringType),
        th.Property("PhoneExtension", th.StringType),
        th.Property("Postcode", th.StringType),
        th.Property("PriceList", th.UUIDType),
        th.Property("PurchaseCurrency", th.StringType),
        th.Property("PurchaseCurrencyDescription", th.StringType),
        th.Property("PurchaseLeadDays", th.IntegerType),
        th.Property("PurchaseVATCode", th.StringType),
        th.Property("PurchaseVATCodeDescription", th.StringType),
        th.Property("RecepientOfCommissions", th.BooleanType),
        th.Property("Remarks", th.StringType),
        th.Property("Reseller", th.UUIDType),
        th.Property("ResellerCode", th.StringType),
        th.Property("ResellerName", th.StringType),
        th.Property("RSIN", th.StringType),
        th.Property("SalesCurrency", th.StringType),
        th.Property("SalesCurrencyDescription", th.StringType),
        th.Property("SalesTaxSchedule", th.UUIDType),
        th.Property("SalesTaxScheduleCode", th.StringType),
        th.Property("SalesTaxScheduleDescription", th.StringType),
        th.Property("SalesVATCode", th.StringType),
        th.Property("SalesVATCodeDescription", th.StringType),
        th.Property("SearchCode", th.StringType),
        th.Property("SecurityLevel", th.IntegerType),
        th.Property("SeparateInvPerSubscription", th.IntegerType),
        th.Property("ShippingLeadDays", th.IntegerType),
        th.Property("ShippingMethod", th.UUIDType),
        th.Property("ShowRemarkForSales", th.BooleanType),
        th.Property("StartDate", th.DateTimeType),
        th.Property("State", th.StringType),
        th.Property("StateName", th.StringType),
        th.Property("Status", th.StringType),
        th.Property("StatusSince", th.DateTimeType),
        th.Property("TradeName", th.StringType),
        th.Property("Type", th.StringType),
        th.Property("UniqueTaxpayerReference", th.StringType),
        th.Property("VATLiability", th.StringType),
        th.Property("VATNumber", th.StringType),
        th.Property("Website", th.StringType),
    ).to_dict()


class AddressesStream(ExactOnlineStream):
    name = "addresses"
    path = "bulk/CRM/Addresses"
    primary_keys = ["ID"]
    schema = th.PropertiesList(
        th.Property("ID", th.UUIDType),
        th.Property("Account", th.UUIDType),
        th.Property("AccountIsSupplier", th.BooleanType),
        th.Property("AccountName", th.StringType),
        th.Property("AddressLine1", th.StringType),
        th.Property("AddressLine2", th.StringType),
        th.Property("AddressLine3", th.StringType),
        th.Property("City", th.StringType),
        th.Property("Contact", th.UUIDType),
        th.Property("ContactName", th.StringType),
        th.Property("Country", th.StringType),
        th.Property("CountryName", th.StringType),
        th.Property("Created", th.DateTimeType),
        th.Property("Creator", th.UUIDType),
        th.Property("CreatorFullName", th.StringType),
        th.Property("Division", th.IntegerType),
        th.Property("Fax", th.StringType),
        th.Property("FreeBoolField_01", th.BooleanType),
        th.Property("FreeBoolField_02", th.BooleanType),
        th.Property("FreeBoolField_03", th.BooleanType),
        th.Property("FreeBoolField_04", th.BooleanType),
        th.Property("FreeBoolField_05", th.BooleanType),
        th.Property("FreeDateField_01", th.DateTimeType),
        th.Property("FreeDateField_02", th.DateTimeType),
        th.Property("FreeDateField_03", th.DateTimeType),
        th.Property("FreeDateField_04", th.DateTimeType),
        th.Property("FreeDateField_05", th.DateTimeType),
        th.Property("FreeNumberField_01", th.NumberType),
        th.Property("FreeNumberField_02", th.NumberType),
        th.Property("FreeNumberField_03", th.NumberType),
        th.Property("FreeNumberField_04", th.NumberType),
        th.Property("FreeNumberField_05", th.NumberType),
        th.Property("FreeTextField_01", th.StringType),
        th.Property("FreeTextField_02", th.StringType),
        th.Property("FreeTextField_03", th.StringType),
        th.Property("FreeTextField_04", th.StringType),
        th.Property("FreeTextField_05", th.StringType),
        th.Property("Mailbox", th.StringType),
        th.Property("Main", th.BooleanType),
        th.Property("Modified", th.DateTimeType),
        th.Property("Modifier", th.UUIDType),
        th.Property("ModifierFullName", th.StringType),
        th.Property("NicNumber", th.StringType),
        th.Property("Notes", th.StringType),
        th.Property("Phone", th.StringType),
        th.Property("PhoneExtension", th.StringType),
        th.Property("Postcode", th.StringType),
        th.Property("State", th.StringType),
        th.Property("StateDescription", th.StringType),
        th.Property("Type", th.IntegerType),
        th.Property("Warehouse", th.UUIDType),
        th.Property("WarehouseCode", th.StringType),
        th.Property("WarehouseDescription", th.StringType),
    ).to_dict()


class DocumentsStream(ExactOnlineStream):
    name = "documents"
    path = "bulk/Documents/Documents"
    primary_keys = ["ID"]
    replication_key = "Created"
    schema = th.PropertiesList(
        th.Property("ID", th.UUIDType),
        th.Property("Account", th.UUIDType),
        th.Property("AccountCode", th.StringType),
        th.Property("AccountName", th.StringType),
        th.Property("AmountFC", th.NumberType),
        th.Property("Body", th.StringType),
        th.Property("Category", th.UUIDType),
        th.Property("CategoryDescription", th.StringType),
        th.Property("Contact", th.UUIDType),
        th.Property("ContactFullName", th.StringType),
        th.Property("Created", th.DateTimeType),
        th.Property("Creator", th.UUIDType),
        th.Property("CreatorFullName", th.StringType),
        th.Property("Currency", th.StringType),
        th.Property("Division", th.IntegerType),
        th.Property("DocumentDate", th.DateTimeType),
        th.Property("DocumentFolder", th.UUIDType),
        th.Property("DocumentFolderCode", th.StringType),
        th.Property("DocumentFolderDescription", th.StringType),
        th.Property("DocumentViewUrl", th.StringType),
        th.Property("ExpiryDate", th.DateTimeType),
        th.Property("FinancialTransactionEntryID", th.UUIDType),
        th.Property("HasEmptyBody", th.BooleanType),
        th.Property("HID", th.IntegerType),
        th.Property("InheritShare", th.BooleanType),
        th.Property("Language", th.StringType),
        th.Property("Modified", th.DateTimeType),
        th.Property("Modifier", th.UUIDType),
        th.Property("ModifierFullName", th.StringType),
        th.Property("Opportunity", th.UUIDType),
        th.Property("Project", th.UUIDType),
        th.Property("ProjectCode", th.StringType),
        th.Property("ProjectDescription", th.StringType),
        th.Property("ProposedEntryStatus", th.IntegerType),
        th.Property("SalesInvoiceNumber", th.IntegerType),
        th.Property("SalesOrderNumber", th.IntegerType),
        th.Property("SendMethod", th.IntegerType),
        th.Property("ShopOrderNumber", th.IntegerType),
        th.Property("Subject", th.StringType),
        th.Property("Type", th.IntegerType),
        th.Property("TypeDescription", th.StringType),
    ).to_dict()


class DocumentAttachementsStream(ExactOnlineStream):
    name = "document_attachements"
    path = "bulk/Documents/DocumentAttachments"
    primary_keys = ["ID"]
    schema = th.PropertiesList(
        th.Property("ID", th.UUIDType),
        th.Property("Attachment", th.StringType),
        th.Property("Document", th.UUIDType),
        th.Property("FileName", th.StringType),
        th.Property("FileSize", th.NumberType),
        th.Property("Url", th.StringType),
    ).to_dict()


class GLAccountsStream(ExactOnlineStream):
    name = "gl_accounts"
    path = "bulk/Financial/GLAccounts"
    primary_keys = ["ID"]
    replication_key = "Modified"
    schema = th.PropertiesList(
        th.Property("ID", th.UUIDType),
        th.Property("AssimilatedVATBox", th.IntegerType),
        th.Property("BalanceSide", th.StringType),
        th.Property("BalanceType", th.StringType),
        th.Property("BelcotaxType", th.IntegerType),
        th.Property("Code", th.StringType),
        th.Property("Compress", th.BooleanType),
        th.Property("Costcenter", th.StringType),
        th.Property("CostcenterDescription", th.StringType),
        th.Property("Costunit", th.StringType),
        th.Property("CostunitDescription", th.StringType),
        th.Property("Created", th.DateTimeType),
        th.Property("Creator", th.UUIDType),
        th.Property("CreatorFullName", th.StringType),
        th.Property("DeductibilityPercentages", th.StringType),
        th.Property("Description", th.StringType),
        th.Property("Division", th.IntegerType),
        th.Property("ExcludeVATListing", th.IntegerType),
        th.Property("ExpenseNonDeductiblePercentage", th.NumberType),
        th.Property("IsBlocked", th.BooleanType),
        th.Property("Matching", th.BooleanType),
        th.Property("Modified", th.DateTimeType),
        th.Property("Modifier", th.UUIDType),
        th.Property("ModifierFullName", th.StringType),
        th.Property("PrivateGLAccount", th.UUIDType),
        th.Property("PrivatePercentage", th.NumberType),
        th.Property("ReportingCode", th.StringType),
        th.Property("RevalueCurrency", th.BooleanType),
        th.Property("SearchCode", th.StringType),
        th.Property("Type", th.IntegerType),
        th.Property("TypeDescription", th.StringType),
        th.Property("UseCostcenter", th.IntegerType),
        th.Property("UseCostunit", th.IntegerType),
        th.Property("VATCode", th.StringType),
        th.Property("VATDescription", th.StringType),
        th.Property("VATGLAccountType", th.StringType),
        th.Property("VATNonDeductibleGLAccount", th.UUIDType),
        th.Property("VATNonDeductiblePercentage", th.NumberType),
        th.Property("VATSystem", th.StringType),
        th.Property("YearEndCostGLAccount", th.UUIDType),
        th.Property("YearEndReflectionGLAccount", th.UUIDType),
    ).to_dict()


class GLClassificationsStream(ExactOnlineStream):
    name = "gl_classifications"
    path = "bulk/Financial/GLClassifications"
    primary_keys = ["ID"]
    schema = th.PropertiesList(
        th.Property("ID", th.UUIDType),
        th.Property("Abstract", th.BooleanType),
        th.Property("Balance", th.StringType),
        th.Property("Code", th.StringType),
        th.Property("Created", th.DateTimeType),
        th.Property("Creator", th.UUIDType),
        th.Property("CreatorFullName", th.StringType),
        th.Property("Description", th.StringType),
        th.Property("Division", th.IntegerType),
        th.Property("IsTupleSubElement", th.BooleanType),
        th.Property("Modified", th.DateTimeType),
        th.Property("Modifier", th.UUIDType),
        th.Property("ModifierFullName", th.StringType),
        th.Property("Name", th.StringType),
        th.Property("Nillable", th.BooleanType),
        th.Property("Parent", th.UUIDType),
        th.Property("PeriodType", th.StringType),
        th.Property("SubstitutionGroup", th.StringType),
        th.Property("TaxonomyNamespace", th.UUIDType),
        th.Property("TaxonomyNamespaceDescription", th.StringType),
        th.Property("Type", th.UUIDType),
    ).to_dict()


class TransactionLinesStream(ExactOnlineStream):
    name = "transaction_lines"
    path = "bulk/Financial/TransactionLines"
    primary_keys = ["ID"]
    replication_key = "Modified"
    schema = th.PropertiesList(
        th.Property("ID", th.UUIDType),
        th.Property("Account", th.UUIDType),
        th.Property("AccountCode", th.StringType),
        th.Property("AccountName", th.StringType),
        th.Property("AmountDC", th.NumberType),
        th.Property("AmountFC", th.NumberType),
        th.Property("AmountVATBaseFC", th.NumberType),
        th.Property("AmountVATFC", th.NumberType),
        th.Property("Asset", th.UUIDType),
        th.Property("AssetCode", th.StringType),
        th.Property("AssetDescription", th.StringType),
        th.Property("CostCenter", th.StringType),
        th.Property("CostCenterDescription", th.StringType),
        th.Property("CostUnit", th.StringType),
        th.Property("CostUnitDescription", th.StringType),
        th.Property("Created", th.DateTimeType),
        th.Property("Creator", th.UUIDType),
        th.Property("CreatorFullName", th.StringType),
        th.Property("Currency", th.StringType),
        th.Property("Date", th.DateTimeType),
        th.Property("Description", th.StringType),
        th.Property("Division", th.IntegerType),
        th.Property("Document", th.UUIDType),
        th.Property("DocumentNumber", th.IntegerType),
        th.Property("DocumentSubject", th.StringType),
        th.Property("DueDate", th.DateTimeType),
        th.Property("EntryID", th.UUIDType),
        th.Property("EntryNumber", th.IntegerType),
        th.Property("ExchangeRate", th.NumberType),
        th.Property("ExternalLinkDescription", th.StringType),
        th.Property("ExternalLinkReference", th.StringType),
        th.Property("ExtraDutyAmountFC", th.NumberType),
        th.Property("ExtraDutyPercentage", th.NumberType),
        th.Property("FinancialPeriod", th.IntegerType),
        th.Property("FinancialYear", th.IntegerType),
        th.Property("GLAccount", th.UUIDType),
        th.Property("GLAccountCode", th.StringType),
        th.Property("GLAccountDescription", th.StringType),
        th.Property("InvoiceNumber", th.IntegerType),
        th.Property("Item", th.UUIDType),
        th.Property("ItemCode", th.StringType),
        th.Property("ItemDescription", th.StringType),
        th.Property("JournalCode", th.StringType),
        th.Property("JournalDescription", th.StringType),
        th.Property("LineNumber", th.IntegerType),
        th.Property("LineType", th.IntegerType),
        th.Property("Modified", th.DateTimeType),
        th.Property("Modifier", th.UUIDType),
        th.Property("ModifierFullName", th.StringType),
        th.Property("Notes", th.StringType),
        th.Property("OffsetID", th.UUIDType),
        th.Property("OrderNumber", th.IntegerType),
        th.Property("PaymentDiscountAmount", th.NumberType),
        th.Property("PaymentReference", th.StringType),
        th.Property("Project", th.UUIDType),
        th.Property("ProjectCode", th.StringType),
        th.Property("ProjectDescription", th.StringType),
        th.Property("Quantity", th.NumberType),
        th.Property("SerialNumber", th.StringType),
        th.Property("ShopOrder", th.UUIDType),
        th.Property("Status", th.IntegerType),
        th.Property("Subscription", th.UUIDType),
        th.Property("SubscriptionDescription", th.StringType),
        th.Property("TrackingNumber", th.StringType),
        th.Property("TrackingNumberDescription", th.StringType),
        th.Property("Type", th.IntegerType),
        th.Property("VATCode", th.StringType),
        th.Property("VATCodeDescription", th.StringType),
        th.Property("VATPercentage", th.NumberType),
        th.Property("VATType", th.StringType),
        th.Property("YourRef", th.StringType),
    ).to_dict()
