"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sift.metadata.v1.metadata_pb2
import typing

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Asset(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ASSET_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    CREATED_DATE_FIELD_NUMBER: builtins.int
    CREATED_BY_USER_ID_FIELD_NUMBER: builtins.int
    MODIFIED_DATE_FIELD_NUMBER: builtins.int
    MODIFIED_BY_USER_ID_FIELD_NUMBER: builtins.int
    TAGS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    ARCHIVED_DATE_FIELD_NUMBER: builtins.int
    asset_id: builtins.str
    name: builtins.str
    organization_id: builtins.str
    created_by_user_id: builtins.str
    modified_by_user_id: builtins.str
    @property
    def created_date(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def modified_date(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def tags(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The names of the tags associated with this asset."""

    @property
    def metadata(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[sift.metadata.v1.metadata_pb2.MetadataValue]:
        """The metadata values associated with this asset."""

    @property
    def archived_date(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The date the asset was archived."""

    def __init__(
        self,
        *,
        asset_id: builtins.str = ...,
        name: builtins.str = ...,
        organization_id: builtins.str = ...,
        created_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        created_by_user_id: builtins.str = ...,
        modified_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_by_user_id: builtins.str = ...,
        tags: collections.abc.Iterable[builtins.str] | None = ...,
        metadata: collections.abc.Iterable[sift.metadata.v1.metadata_pb2.MetadataValue] | None = ...,
        archived_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["archived_date", b"archived_date", "created_date", b"created_date", "modified_date", b"modified_date"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["archived_date", b"archived_date", "asset_id", b"asset_id", "created_by_user_id", b"created_by_user_id", "created_date", b"created_date", "metadata", b"metadata", "modified_by_user_id", b"modified_by_user_id", "modified_date", b"modified_date", "name", b"name", "organization_id", b"organization_id", "tags", b"tags"]) -> None: ...

global___Asset = Asset

@typing.final
class ListAssetsRequest(google.protobuf.message.Message):
    """The request for a call to `AssetService_ListAssets`."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of assets to return.
    The service may return fewer than this value.
    If unspecified, at most 50 assets will be returned.
    The maximum value is 1000; values above 1000 will be coerced to 1000.
    """
    page_token: builtins.str
    """A page token, received from a previous `ListAssets` call.
    Provide this to retrieve the subsequent page.
    When paginating, all other parameters provided to `ListAssets` must match
    the call that provided the page token.
    """
    filter: builtins.str
    """A [Common Expression Language (CEL)](https://github.com/google/cel-spec) filter string.
    Available fields to filter by are `asset_id`, `created_by_user_id`, `modified_by_user_id`,
    `created_date`, `modified_date`, `name`, `tag_id`, `tag_name`, and `metadata`. Metadata can be used in filters by using `metadata.{metadata_key_name}` as the field name.
    For further information about how to use CELs, please refer to [this guide](https://github.com/google/cel-spec/blob/master/doc/langdef.md#standard-definitions).
    For more information about the fields used for filtering, please refer to [this definition](/docs/api/grpc/protocol-buffers/assets#asset). Optional.
    """
    order_by: builtins.str
    """How to order the retrieved assets. Formatted as a comma-separated string i.e. "FIELD_NAME[ desc],...".
    Available fields to order_by are `name`, `created_date` and `modified_date`.
    If left empty, items are ordered by `created_date` in descending order (newest-first).
    For more information about the format of this field, read [this](https://google.aip.dev/132#ordering)
    Example: "created_date desc,modified_date"
    """
    def __init__(
        self,
        *,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
        order_by: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListAssetsRequest = ListAssetsRequest

@typing.final
class ListAssetsResponse(google.protobuf.message.Message):
    """The result of a call to `AssetService_ListAssets`."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ASSETS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    @property
    def assets(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Asset]: ...
    def __init__(
        self,
        *,
        assets: collections.abc.Iterable[global___Asset] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["assets", b"assets", "next_page_token", b"next_page_token"]) -> None: ...

global___ListAssetsResponse = ListAssetsResponse

@typing.final
class DeleteAssetRequest(google.protobuf.message.Message):
    """The request for a call to `AssetService_DeleteAsset` to archive a single existing asset by its asset_id."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ASSET_ID_FIELD_NUMBER: builtins.int
    ARCHIVE_RUNS_FIELD_NUMBER: builtins.int
    asset_id: builtins.str
    """The id of the asset to be archived. Required."""
    archive_runs: builtins.bool
    """If true, will archive all runs associated with the asset."""
    def __init__(
        self,
        *,
        asset_id: builtins.str = ...,
        archive_runs: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["archive_runs", b"archive_runs", "asset_id", b"asset_id"]) -> None: ...

global___DeleteAssetRequest = DeleteAssetRequest

@typing.final
class DeleteAssetResponse(google.protobuf.message.Message):
    """The response of a call to `AssetService_DeleteAsset`."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteAssetResponse = DeleteAssetResponse

@typing.final
class GetAssetRequest(google.protobuf.message.Message):
    """The request for a call to `AssetService_GetAsset` to retrieve a single existing asset by its asset_id."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ASSET_ID_FIELD_NUMBER: builtins.int
    asset_id: builtins.str
    """The id of the asset to be retrieved. Required."""
    def __init__(
        self,
        *,
        asset_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["asset_id", b"asset_id"]) -> None: ...

global___GetAssetRequest = GetAssetRequest

@typing.final
class GetAssetResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ASSET_FIELD_NUMBER: builtins.int
    @property
    def asset(self) -> global___Asset: ...
    def __init__(
        self,
        *,
        asset: global___Asset | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["asset", b"asset"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["asset", b"asset"]) -> None: ...

global___GetAssetResponse = GetAssetResponse

@typing.final
class UpdateAssetRequest(google.protobuf.message.Message):
    """The request for a call to `AssetService_UpdateAsset` to update a single existing asset."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ASSET_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    @property
    def asset(self) -> global___Asset:
        """The asset to update. The asset's `asset_id` field is used to identify asset run to update
        and is required.
        """

    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """The list of fields to be updated. The fields available to be updated are `tags`, `metadata`, and `archived_date`."""

    def __init__(
        self,
        *,
        asset: global___Asset | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["asset", b"asset", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["asset", b"asset", "update_mask", b"update_mask"]) -> None: ...

global___UpdateAssetRequest = UpdateAssetRequest

@typing.final
class UpdateAssetResponse(google.protobuf.message.Message):
    """The response of a call to `AssetService_UpdateAsset`."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ASSET_FIELD_NUMBER: builtins.int
    @property
    def asset(self) -> global___Asset: ...
    def __init__(
        self,
        *,
        asset: global___Asset | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["asset", b"asset"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["asset", b"asset"]) -> None: ...

global___UpdateAssetResponse = UpdateAssetResponse
