"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import google.protobuf.descriptor
import google.protobuf.message
import typing

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class ResourceRef(google.protobuf.message.Message):
    """ResourceRef is meant to be embedded as a field in other resources. It's used by one resource to point to another resource.
    In a request, use the `find_by` field to select a resource to point to.
    In a response, the fields marked `google.api.field_behavior = OUTPUT_ONLY` will be populated by the backend.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    CLIENT_KEY_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    FIND_BY_FIELD_NUMBER: builtins.int
    id: builtins.str
    """The global unique id of the resource, e.g. the asset_id, run_id, or report_id."""
    client_key: builtins.str
    """If a resource has a client_key associated with it, it will be included."""
    name: builtins.str
    """The name of the resource."""
    @property
    def find_by(self) -> global___FindResourceBy:
        """Use this field to 'construct' a ResourceRef.
        You can give just the name, id, or client_key and the backend will find the resource you're referring to.
        """

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        client_key: builtins.str | None = ...,
        name: builtins.str = ...,
        find_by: global___FindResourceBy | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_client_key", b"_client_key", "client_key", b"client_key", "find_by", b"find_by"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_client_key", b"_client_key", "client_key", b"client_key", "find_by", b"find_by", "id", b"id", "name", b"name"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_client_key", b"_client_key"]) -> typing.Literal["client_key"] | None: ...

global___ResourceRef = ResourceRef

@typing.final
class FindResourceBy(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    CLIENT_KEY_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Find by the resource's global id, e.g. asset_id, run_id, report_id."""
    client_key: builtins.str
    """Find by the resource's client_key, if available."""
    name: builtins.str
    """Find by the resource's name. If multiple resources are found with the same name, an error will be returned."""
    organization_id: builtins.str
    """When finding by `client_key` or `name`, the `organization_id` should also be specified.
    Only required if the user belongs to more than one organization.
    """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        client_key: builtins.str = ...,
        name: builtins.str = ...,
        organization_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["client_key", b"client_key", "id", b"id", "identifier", b"identifier", "name", b"name"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["client_key", b"client_key", "id", b"id", "identifier", b"identifier", "name", b"name", "organization_id", b"organization_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["identifier", b"identifier"]) -> typing.Literal["id", "client_key", "name"] | None: ...

global___FindResourceBy = FindResourceBy
