"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
INTERNAL NOTES FOR MAINTAINERS:
This protobuf package serves proxying layer for underlying services which still depend on
protobufs from the `azimuth.rules.v1` package. Any updates to this file need to be ported
in copy-paste fashion to `azimuth.rules.v1`.

Also, be sure to update the following Go package to convert between the new and legacy types.:
- azimuth.services.repo.rule.v1.pbmapper
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sift.annotations.v1.annotations_pb2
import sift.common.type.v1.resource_identifier_pb2
import sift.common.type.v1.user_defined_functions_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _SearchOrder:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _SearchOrderEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_SearchOrder.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    SEARCH_ORDER_UNSPECIFIED: _SearchOrder.ValueType  # 0
    SEARCH_ORDER_ASC: _SearchOrder.ValueType  # 1
    SEARCH_ORDER_DESC: _SearchOrder.ValueType  # 2

class SearchOrder(_SearchOrder, metaclass=_SearchOrderEnumTypeWrapper): ...

SEARCH_ORDER_UNSPECIFIED: SearchOrder.ValueType  # 0
SEARCH_ORDER_ASC: SearchOrder.ValueType  # 1
SEARCH_ORDER_DESC: SearchOrder.ValueType  # 2
global___SearchOrder = SearchOrder

class _ActionKind:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ActionKindEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ActionKind.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ACTION_KIND_UNSPECIFIED: _ActionKind.ValueType  # 0
    NOTIFICATION: _ActionKind.ValueType  # 1
    ANNOTATION: _ActionKind.ValueType  # 2
    WEBHOOK: _ActionKind.ValueType  # 3

class ActionKind(_ActionKind, metaclass=_ActionKindEnumTypeWrapper): ...

ACTION_KIND_UNSPECIFIED: ActionKind.ValueType  # 0
NOTIFICATION: ActionKind.ValueType  # 1
ANNOTATION: ActionKind.ValueType  # 2
WEBHOOK: ActionKind.ValueType  # 3
global___ActionKind = ActionKind

class _ConditionComparator:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ConditionComparatorEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ConditionComparator.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    CONDITION_COMPARATOR_UNSPECIFIED: _ConditionComparator.ValueType  # 0
    LESS_THAN: _ConditionComparator.ValueType  # 1
    LESS_THAN_OR_EQUAL: _ConditionComparator.ValueType  # 2
    GREATER_THAN: _ConditionComparator.ValueType  # 3
    GREATER_THAN_OR_EQUAL: _ConditionComparator.ValueType  # 4
    EQUAL: _ConditionComparator.ValueType  # 5
    NOT_EQUAL: _ConditionComparator.ValueType  # 6

class ConditionComparator(_ConditionComparator, metaclass=_ConditionComparatorEnumTypeWrapper): ...

CONDITION_COMPARATOR_UNSPECIFIED: ConditionComparator.ValueType  # 0
LESS_THAN: ConditionComparator.ValueType  # 1
LESS_THAN_OR_EQUAL: ConditionComparator.ValueType  # 2
GREATER_THAN: ConditionComparator.ValueType  # 3
GREATER_THAN_OR_EQUAL: ConditionComparator.ValueType  # 4
EQUAL: ConditionComparator.ValueType  # 5
NOT_EQUAL: ConditionComparator.ValueType  # 6
global___ConditionComparator = ConditionComparator

@typing.final
class Rule(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULE_ID_FIELD_NUMBER: builtins.int
    ASSET_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    IS_ENABLED_FIELD_NUMBER: builtins.int
    CREATED_DATE_FIELD_NUMBER: builtins.int
    MODIFIED_DATE_FIELD_NUMBER: builtins.int
    CREATED_BY_USER_ID_FIELD_NUMBER: builtins.int
    MODIFIED_BY_USER_ID_FIELD_NUMBER: builtins.int
    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    CONDITIONS_FIELD_NUMBER: builtins.int
    RULE_VERSION_FIELD_NUMBER: builtins.int
    CLIENT_KEY_FIELD_NUMBER: builtins.int
    ASSET_CONFIGURATION_FIELD_NUMBER: builtins.int
    CONTEXTUAL_CHANNELS_FIELD_NUMBER: builtins.int
    DELETED_DATE_FIELD_NUMBER: builtins.int
    IS_EXTERNAL_FIELD_NUMBER: builtins.int
    rule_id: builtins.str
    asset_id: builtins.str
    name: builtins.str
    description: builtins.str
    is_enabled: builtins.bool
    created_by_user_id: builtins.str
    modified_by_user_id: builtins.str
    organization_id: builtins.str
    client_key: builtins.str
    """client_key is a client provided identifier for the rule. It is immutable after rule creation."""
    is_external: builtins.bool
    @property
    def created_date(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def modified_date(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def conditions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RuleCondition]: ...
    @property
    def rule_version(self) -> global___RuleVersion: ...
    @property
    def asset_configuration(self) -> global___RuleAssetConfiguration: ...
    @property
    def contextual_channels(self) -> global___ContextualChannels: ...
    @property
    def deleted_date(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        rule_id: builtins.str = ...,
        asset_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        is_enabled: builtins.bool = ...,
        created_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        created_by_user_id: builtins.str = ...,
        modified_by_user_id: builtins.str = ...,
        organization_id: builtins.str = ...,
        conditions: collections.abc.Iterable[global___RuleCondition] | None = ...,
        rule_version: global___RuleVersion | None = ...,
        client_key: builtins.str = ...,
        asset_configuration: global___RuleAssetConfiguration | None = ...,
        contextual_channels: global___ContextualChannels | None = ...,
        deleted_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        is_external: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["asset_configuration", b"asset_configuration", "contextual_channels", b"contextual_channels", "created_date", b"created_date", "deleted_date", b"deleted_date", "modified_date", b"modified_date", "rule_version", b"rule_version"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["asset_configuration", b"asset_configuration", "asset_id", b"asset_id", "client_key", b"client_key", "conditions", b"conditions", "contextual_channels", b"contextual_channels", "created_by_user_id", b"created_by_user_id", "created_date", b"created_date", "deleted_date", b"deleted_date", "description", b"description", "is_enabled", b"is_enabled", "is_external", b"is_external", "modified_by_user_id", b"modified_by_user_id", "modified_date", b"modified_date", "name", b"name", "organization_id", b"organization_id", "rule_id", b"rule_id", "rule_version", b"rule_version"]) -> None: ...

global___Rule = Rule

@typing.final
class RuleCondition(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULE_CONDITION_ID_FIELD_NUMBER: builtins.int
    RULE_ID_FIELD_NUMBER: builtins.int
    EXPRESSION_FIELD_NUMBER: builtins.int
    CREATED_DATE_FIELD_NUMBER: builtins.int
    MODIFIED_DATE_FIELD_NUMBER: builtins.int
    CREATED_BY_USER_ID_FIELD_NUMBER: builtins.int
    MODIFIED_BY_USER_ID_FIELD_NUMBER: builtins.int
    ACTIONS_FIELD_NUMBER: builtins.int
    RULE_CONDITION_VERSION_ID_FIELD_NUMBER: builtins.int
    rule_condition_id: builtins.str
    rule_id: builtins.str
    created_by_user_id: builtins.str
    modified_by_user_id: builtins.str
    rule_condition_version_id: builtins.str
    @property
    def expression(self) -> global___RuleConditionExpression: ...
    @property
    def created_date(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def modified_date(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def actions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RuleAction]: ...
    def __init__(
        self,
        *,
        rule_condition_id: builtins.str = ...,
        rule_id: builtins.str = ...,
        expression: global___RuleConditionExpression | None = ...,
        created_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        created_by_user_id: builtins.str = ...,
        modified_by_user_id: builtins.str = ...,
        actions: collections.abc.Iterable[global___RuleAction] | None = ...,
        rule_condition_version_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_date", b"created_date", "expression", b"expression", "modified_date", b"modified_date"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["actions", b"actions", "created_by_user_id", b"created_by_user_id", "created_date", b"created_date", "expression", b"expression", "modified_by_user_id", b"modified_by_user_id", "modified_date", b"modified_date", "rule_condition_id", b"rule_condition_id", "rule_condition_version_id", b"rule_condition_version_id", "rule_id", b"rule_id"]) -> None: ...

global___RuleCondition = RuleCondition

@typing.final
class RuleAction(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULE_ACTION_ID_FIELD_NUMBER: builtins.int
    RULE_CONDITION_ID_FIELD_NUMBER: builtins.int
    ACTION_TYPE_FIELD_NUMBER: builtins.int
    CONFIGURATION_FIELD_NUMBER: builtins.int
    CREATED_DATE_FIELD_NUMBER: builtins.int
    MODIFIED_DATE_FIELD_NUMBER: builtins.int
    CREATED_BY_USER_ID_FIELD_NUMBER: builtins.int
    MODIFIED_BY_USER_ID_FIELD_NUMBER: builtins.int
    RULE_ACTION_VERSION_ID_FIELD_NUMBER: builtins.int
    rule_action_id: builtins.str
    rule_condition_id: builtins.str
    action_type: global___ActionKind.ValueType
    created_by_user_id: builtins.str
    modified_by_user_id: builtins.str
    rule_action_version_id: builtins.str
    @property
    def configuration(self) -> global___RuleActionConfiguration: ...
    @property
    def created_date(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def modified_date(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        rule_action_id: builtins.str = ...,
        rule_condition_id: builtins.str = ...,
        action_type: global___ActionKind.ValueType = ...,
        configuration: global___RuleActionConfiguration | None = ...,
        created_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        created_by_user_id: builtins.str = ...,
        modified_by_user_id: builtins.str = ...,
        rule_action_version_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["configuration", b"configuration", "created_date", b"created_date", "modified_date", b"modified_date"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["action_type", b"action_type", "configuration", b"configuration", "created_by_user_id", b"created_by_user_id", "created_date", b"created_date", "modified_by_user_id", b"modified_by_user_id", "modified_date", b"modified_date", "rule_action_id", b"rule_action_id", "rule_action_version_id", b"rule_action_version_id", "rule_condition_id", b"rule_condition_id"]) -> None: ...

global___RuleAction = RuleAction

@typing.final
class RuleAssetConfiguration(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ASSET_IDS_FIELD_NUMBER: builtins.int
    TAG_IDS_FIELD_NUMBER: builtins.int
    @property
    def asset_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def tag_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        asset_ids: collections.abc.Iterable[builtins.str] | None = ...,
        tag_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["asset_ids", b"asset_ids", "tag_ids", b"tag_ids"]) -> None: ...

global___RuleAssetConfiguration = RuleAssetConfiguration

@typing.final
class ContextualChannels(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNELS_FIELD_NUMBER: builtins.int
    @property
    def channels(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ChannelReference]: ...
    def __init__(
        self,
        *,
        channels: collections.abc.Iterable[global___ChannelReference] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channels", b"channels"]) -> None: ...

global___ContextualChannels = ContextualChannels

@typing.final
class AssetExpressionValidationResult(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ASSET_ID_FIELD_NUMBER: builtins.int
    ASSET_NAME_FIELD_NUMBER: builtins.int
    ASSET_TAG_ID_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    asset_id: builtins.str
    asset_name: builtins.str
    asset_tag_id: builtins.str
    """asset_tag_id is the tag_id that caused this asset to be included in the rule"""
    error: builtins.str
    def __init__(
        self,
        *,
        asset_id: builtins.str = ...,
        asset_name: builtins.str = ...,
        asset_tag_id: builtins.str = ...,
        error: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_error", b"_error", "error", b"error"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_error", b"_error", "asset_id", b"asset_id", "asset_name", b"asset_name", "asset_tag_id", b"asset_tag_id", "error", b"error"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_error", b"_error"]) -> typing.Literal["error"] | None: ...

global___AssetExpressionValidationResult = AssetExpressionValidationResult

@typing.final
class SearchRulesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LIMIT_FIELD_NUMBER: builtins.int
    OFFSET_FIELD_NUMBER: builtins.int
    ORDER_FIELD_NUMBER: builtins.int
    NAME_MATCHES_FIELD_NUMBER: builtins.int
    CASE_SENSITIVE_FIELD_NUMBER: builtins.int
    REGEXP_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    RULE_IDS_FIELD_NUMBER: builtins.int
    ASSET_IDS_FIELD_NUMBER: builtins.int
    INCLUDE_DELETED_FIELD_NUMBER: builtins.int
    ASSET_TAGS_FIELD_NUMBER: builtins.int
    limit: builtins.int
    """Max number of rules to return (returns all if omitted)."""
    offset: builtins.int
    """Only applies if limit provided."""
    order: global___SearchOrder.ValueType
    """Order to sort results by (defaults to ascending)."""
    name_matches: builtins.str
    case_sensitive: builtins.bool
    regexp: builtins.bool
    order_by: builtins.str
    include_deleted: builtins.bool
    @property
    def rule_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """If provided, only returns rules with the given ids"""

    @property
    def asset_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """If provided, only returns rules that apply to the given asset ids"""

    @property
    def asset_tags(self) -> sift.common.type.v1.resource_identifier_pb2.NamedResources:
        """If provided, returns rules with assets that have the given tags"""

    def __init__(
        self,
        *,
        limit: builtins.int | None = ...,
        offset: builtins.int = ...,
        order: global___SearchOrder.ValueType | None = ...,
        name_matches: builtins.str = ...,
        case_sensitive: builtins.bool = ...,
        regexp: builtins.bool = ...,
        order_by: builtins.str | None = ...,
        rule_ids: collections.abc.Iterable[builtins.str] | None = ...,
        asset_ids: collections.abc.Iterable[builtins.str] | None = ...,
        include_deleted: builtins.bool = ...,
        asset_tags: sift.common.type.v1.resource_identifier_pb2.NamedResources | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_limit", b"_limit", "_order", b"_order", "_order_by", b"_order_by", "asset_tags", b"asset_tags", "limit", b"limit", "order", b"order", "order_by", b"order_by"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_limit", b"_limit", "_order", b"_order", "_order_by", b"_order_by", "asset_ids", b"asset_ids", "asset_tags", b"asset_tags", "case_sensitive", b"case_sensitive", "include_deleted", b"include_deleted", "limit", b"limit", "name_matches", b"name_matches", "offset", b"offset", "order", b"order", "order_by", b"order_by", "regexp", b"regexp", "rule_ids", b"rule_ids"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_limit", b"_limit"]) -> typing.Literal["limit"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_order", b"_order"]) -> typing.Literal["order"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_order_by", b"_order_by"]) -> typing.Literal["order_by"] | None: ...

global___SearchRulesRequest = SearchRulesRequest

@typing.final
class SearchRulesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COUNT_FIELD_NUMBER: builtins.int
    RULES_FIELD_NUMBER: builtins.int
    count: builtins.int
    @property
    def rules(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Rule]:
        """Conditions are not included in the search response. The latest version of the rule is returned."""

    def __init__(
        self,
        *,
        count: builtins.int = ...,
        rules: collections.abc.Iterable[global___Rule] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["count", b"count", "rules", b"rules"]) -> None: ...

global___SearchRulesResponse = SearchRulesResponse

@typing.final
class GetRuleRequest(google.protobuf.message.Message):
    """GetRuleRequest is used to retrieve a rule by rule_id or client_key. If both are provided, only rule_id will be used."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULE_ID_FIELD_NUMBER: builtins.int
    CLIENT_KEY_FIELD_NUMBER: builtins.int
    rule_id: builtins.str
    client_key: builtins.str
    def __init__(
        self,
        *,
        rule_id: builtins.str = ...,
        client_key: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["client_key", b"client_key", "rule_id", b"rule_id"]) -> None: ...

global___GetRuleRequest = GetRuleRequest

@typing.final
class GetRuleResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULE_FIELD_NUMBER: builtins.int
    @property
    def rule(self) -> global___Rule: ...
    def __init__(
        self,
        *,
        rule: global___Rule | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["rule", b"rule"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["rule", b"rule"]) -> None: ...

global___GetRuleResponse = GetRuleResponse

@typing.final
class BatchGetRulesRequest(google.protobuf.message.Message):
    """BatchGetRulesRequest is used to retrieve rules by rule_ids or client_keys. If both are provided, both will be used to retrieve rules."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULE_IDS_FIELD_NUMBER: builtins.int
    CLIENT_KEYS_FIELD_NUMBER: builtins.int
    @property
    def rule_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def client_keys(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        rule_ids: collections.abc.Iterable[builtins.str] | None = ...,
        client_keys: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["client_keys", b"client_keys", "rule_ids", b"rule_ids"]) -> None: ...

global___BatchGetRulesRequest = BatchGetRulesRequest

@typing.final
class BatchGetRulesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULES_FIELD_NUMBER: builtins.int
    @property
    def rules(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Rule]: ...
    def __init__(
        self,
        *,
        rules: collections.abc.Iterable[global___Rule] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["rules", b"rules"]) -> None: ...

global___BatchGetRulesResponse = BatchGetRulesResponse

@typing.final
class CreateRuleRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UPDATE_FIELD_NUMBER: builtins.int
    @property
    def update(self) -> global___UpdateRuleRequest: ...
    def __init__(
        self,
        *,
        update: global___UpdateRuleRequest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["update", b"update"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["update", b"update"]) -> None: ...

global___CreateRuleRequest = CreateRuleRequest

@typing.final
class CreateRuleResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULE_ID_FIELD_NUMBER: builtins.int
    rule_id: builtins.str
    def __init__(
        self,
        *,
        rule_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["rule_id", b"rule_id"]) -> None: ...

global___CreateRuleResponse = CreateRuleResponse

@typing.final
class UpdateRuleRequest(google.protobuf.message.Message):
    """UpdateRuleRequest is used to create or update a rule. If the rule_id or client_key is provided, the rule will be updated. If not, a new rule will be created."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULE_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    ASSET_ID_FIELD_NUMBER: builtins.int
    IS_ENABLED_FIELD_NUMBER: builtins.int
    CONDITIONS_FIELD_NUMBER: builtins.int
    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    VERSION_NOTES_FIELD_NUMBER: builtins.int
    CLIENT_KEY_FIELD_NUMBER: builtins.int
    ASSET_CONFIGURATION_FIELD_NUMBER: builtins.int
    CONTEXTUAL_CHANNELS_FIELD_NUMBER: builtins.int
    IS_EXTERNAL_FIELD_NUMBER: builtins.int
    rule_id: builtins.str
    name: builtins.str
    description: builtins.str
    asset_id: builtins.str
    """Deprecated - use asset_configuration instead."""
    is_enabled: builtins.bool
    organization_id: builtins.str
    version_notes: builtins.str
    client_key: builtins.str
    """client_key is a client provided identifier for the rule. It is immutable after being set"""
    is_external: builtins.bool
    @property
    def conditions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___UpdateConditionRequest]: ...
    @property
    def asset_configuration(self) -> global___RuleAssetConfiguration: ...
    @property
    def contextual_channels(self) -> global___ContextualChannels: ...
    def __init__(
        self,
        *,
        rule_id: builtins.str | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        asset_id: builtins.str = ...,
        is_enabled: builtins.bool = ...,
        conditions: collections.abc.Iterable[global___UpdateConditionRequest] | None = ...,
        organization_id: builtins.str = ...,
        version_notes: builtins.str = ...,
        client_key: builtins.str | None = ...,
        asset_configuration: global___RuleAssetConfiguration | None = ...,
        contextual_channels: global___ContextualChannels | None = ...,
        is_external: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_client_key", b"_client_key", "_rule_id", b"_rule_id", "asset_configuration", b"asset_configuration", "client_key", b"client_key", "contextual_channels", b"contextual_channels", "rule_id", b"rule_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_client_key", b"_client_key", "_rule_id", b"_rule_id", "asset_configuration", b"asset_configuration", "asset_id", b"asset_id", "client_key", b"client_key", "conditions", b"conditions", "contextual_channels", b"contextual_channels", "description", b"description", "is_enabled", b"is_enabled", "is_external", b"is_external", "name", b"name", "organization_id", b"organization_id", "rule_id", b"rule_id", "version_notes", b"version_notes"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_client_key", b"_client_key"]) -> typing.Literal["client_key"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_rule_id", b"_rule_id"]) -> typing.Literal["rule_id"] | None: ...

global___UpdateRuleRequest = UpdateRuleRequest

@typing.final
class UpdateConditionRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULE_CONDITION_ID_FIELD_NUMBER: builtins.int
    EXPRESSION_FIELD_NUMBER: builtins.int
    ACTIONS_FIELD_NUMBER: builtins.int
    rule_condition_id: builtins.str
    @property
    def expression(self) -> global___RuleConditionExpression: ...
    @property
    def actions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___UpdateActionRequest]: ...
    def __init__(
        self,
        *,
        rule_condition_id: builtins.str | None = ...,
        expression: global___RuleConditionExpression | None = ...,
        actions: collections.abc.Iterable[global___UpdateActionRequest] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_rule_condition_id", b"_rule_condition_id", "expression", b"expression", "rule_condition_id", b"rule_condition_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_rule_condition_id", b"_rule_condition_id", "actions", b"actions", "expression", b"expression", "rule_condition_id", b"rule_condition_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_rule_condition_id", b"_rule_condition_id"]) -> typing.Literal["rule_condition_id"] | None: ...

global___UpdateConditionRequest = UpdateConditionRequest

@typing.final
class UpdateActionRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULE_ACTION_ID_FIELD_NUMBER: builtins.int
    ACTION_TYPE_FIELD_NUMBER: builtins.int
    CONFIGURATION_FIELD_NUMBER: builtins.int
    rule_action_id: builtins.str
    action_type: global___ActionKind.ValueType
    @property
    def configuration(self) -> global___RuleActionConfiguration: ...
    def __init__(
        self,
        *,
        rule_action_id: builtins.str | None = ...,
        action_type: global___ActionKind.ValueType = ...,
        configuration: global___RuleActionConfiguration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_rule_action_id", b"_rule_action_id", "configuration", b"configuration", "rule_action_id", b"rule_action_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_rule_action_id", b"_rule_action_id", "action_type", b"action_type", "configuration", b"configuration", "rule_action_id", b"rule_action_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_rule_action_id", b"_rule_action_id"]) -> typing.Literal["rule_action_id"] | None: ...

global___UpdateActionRequest = UpdateActionRequest

@typing.final
class UpdateRuleResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULE_ID_FIELD_NUMBER: builtins.int
    rule_id: builtins.str
    def __init__(
        self,
        *,
        rule_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["rule_id", b"rule_id"]) -> None: ...

global___UpdateRuleResponse = UpdateRuleResponse

@typing.final
class ValidationResult(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULE_ID_FIELD_NUMBER: builtins.int
    CLIENT_KEY_FIELD_NUMBER: builtins.int
    ASSET_EXPRESSION_VALIDATION_RESULTS_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    rule_id: builtins.str
    client_key: builtins.str
    error: builtins.str
    """If the rule is invalid and unable to be saved, this will contain the error message. Expression errors will be returned in
    the asset_expression_validation_results.
    """
    @property
    def asset_expression_validation_results(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AssetExpressionValidationResult]:
        """If the expression is invalid for an asset, one or more AssetExpressionValidationResult will be returned. This may block
        saving if the override_expression_validation flag is not set.
        """

    def __init__(
        self,
        *,
        rule_id: builtins.str = ...,
        client_key: builtins.str = ...,
        asset_expression_validation_results: collections.abc.Iterable[global___AssetExpressionValidationResult] | None = ...,
        error: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_error", b"_error", "error", b"error"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_error", b"_error", "asset_expression_validation_results", b"asset_expression_validation_results", "client_key", b"client_key", "error", b"error", "rule_id", b"rule_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_error", b"_error"]) -> typing.Literal["error"] | None: ...

global___ValidationResult = ValidationResult

@typing.final
class BatchUpdateRulesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULES_FIELD_NUMBER: builtins.int
    VALIDATE_ONLY_FIELD_NUMBER: builtins.int
    OVERRIDE_EXPRESSION_VALIDATION_FIELD_NUMBER: builtins.int
    validate_only: builtins.bool
    """If validate_only is true, the request will only validate the request and not save the rules."""
    override_expression_validation: builtins.bool
    """If override_expression_validation is true, the request will save the rules even if the expressions are invalid. This
    can be useful for multi-asset rules where an invalid expression for one asset should not prevent the rule from being saved.
    """
    @property
    def rules(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___UpdateRuleRequest]:
        """rules are limited 1000 rules at a time"""

    def __init__(
        self,
        *,
        rules: collections.abc.Iterable[global___UpdateRuleRequest] | None = ...,
        validate_only: builtins.bool = ...,
        override_expression_validation: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["override_expression_validation", b"override_expression_validation", "rules", b"rules", "validate_only", b"validate_only"]) -> None: ...

global___BatchUpdateRulesRequest = BatchUpdateRulesRequest

@typing.final
class BatchUpdateRulesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class RuleIdentifiers(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        RULE_ID_FIELD_NUMBER: builtins.int
        NAME_FIELD_NUMBER: builtins.int
        CLIENT_KEY_FIELD_NUMBER: builtins.int
        rule_id: builtins.str
        name: builtins.str
        client_key: builtins.str
        def __init__(
            self,
            *,
            rule_id: builtins.str = ...,
            name: builtins.str = ...,
            client_key: builtins.str | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["_client_key", b"_client_key", "client_key", b"client_key"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["_client_key", b"_client_key", "client_key", b"client_key", "name", b"name", "rule_id", b"rule_id"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["_client_key", b"_client_key"]) -> typing.Literal["client_key"] | None: ...

    SUCCESS_FIELD_NUMBER: builtins.int
    RULES_CREATED_COUNT_FIELD_NUMBER: builtins.int
    RULES_UPDATED_COUNT_FIELD_NUMBER: builtins.int
    VALIDATE_ONLY_FIELD_NUMBER: builtins.int
    VALIDATION_RESULTS_FIELD_NUMBER: builtins.int
    CREATED_RULE_IDENTIFIERS_FIELD_NUMBER: builtins.int
    success: builtins.bool
    rules_created_count: builtins.int
    """The total number of rules created in the request. If validate_only is true, this will indicate how many rules would have been created."""
    rules_updated_count: builtins.int
    """The total number of rules updated in the request. If validate_only is true, this will indicate how many rules would have been updated."""
    validate_only: builtins.bool
    """This will be true if the request only validated the request and did not save the rules."""
    @property
    def validation_results(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ValidationResult]:
        """One ValidationResult per rule in the request will be returned"""

    @property
    def created_rule_identifiers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BatchUpdateRulesResponse.RuleIdentifiers]:
        """The created rule id, name, version, and client key."""

    def __init__(
        self,
        *,
        success: builtins.bool = ...,
        rules_created_count: builtins.int = ...,
        rules_updated_count: builtins.int = ...,
        validate_only: builtins.bool = ...,
        validation_results: collections.abc.Iterable[global___ValidationResult] | None = ...,
        created_rule_identifiers: collections.abc.Iterable[global___BatchUpdateRulesResponse.RuleIdentifiers] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["created_rule_identifiers", b"created_rule_identifiers", "rules_created_count", b"rules_created_count", "rules_updated_count", b"rules_updated_count", "success", b"success", "validate_only", b"validate_only", "validation_results", b"validation_results"]) -> None: ...

global___BatchUpdateRulesResponse = BatchUpdateRulesResponse

@typing.final
class DeleteRuleRequest(google.protobuf.message.Message):
    """DeleteRuleRequest is used to delete a rule by rule_id or client_key. If both are provided, only rule_id will be used."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULE_ID_FIELD_NUMBER: builtins.int
    CLIENT_KEY_FIELD_NUMBER: builtins.int
    rule_id: builtins.str
    client_key: builtins.str
    def __init__(
        self,
        *,
        rule_id: builtins.str = ...,
        client_key: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["client_key", b"client_key", "rule_id", b"rule_id"]) -> None: ...

global___DeleteRuleRequest = DeleteRuleRequest

@typing.final
class DeleteRuleResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteRuleResponse = DeleteRuleResponse

@typing.final
class BatchDeleteRulesRequest(google.protobuf.message.Message):
    """BatchDeleteRulesRequest is used to delete a rule by rule_id or client_key. For each rule if both are provided, only rule_id will be used."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULE_IDS_FIELD_NUMBER: builtins.int
    CLIENT_KEYS_FIELD_NUMBER: builtins.int
    @property
    def rule_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def client_keys(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        rule_ids: collections.abc.Iterable[builtins.str] | None = ...,
        client_keys: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["client_keys", b"client_keys", "rule_ids", b"rule_ids"]) -> None: ...

global___BatchDeleteRulesRequest = BatchDeleteRulesRequest

@typing.final
class BatchDeleteRulesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___BatchDeleteRulesResponse = BatchDeleteRulesResponse

@typing.final
class UndeleteRuleRequest(google.protobuf.message.Message):
    """UndeleteRuleRequest is used to undelete a rule by rule_id or client_key. If both are provided, only rule_id will be used."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULE_ID_FIELD_NUMBER: builtins.int
    CLIENT_KEY_FIELD_NUMBER: builtins.int
    rule_id: builtins.str
    client_key: builtins.str
    def __init__(
        self,
        *,
        rule_id: builtins.str = ...,
        client_key: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["client_key", b"client_key", "rule_id", b"rule_id"]) -> None: ...

global___UndeleteRuleRequest = UndeleteRuleRequest

@typing.final
class UndeleteRuleResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___UndeleteRuleResponse = UndeleteRuleResponse

@typing.final
class BatchUndeleteRulesRequest(google.protobuf.message.Message):
    """BatchUndeleteRulesRequest is used to delete a rule by rule_id or client_key. For each rule if both are provided, only rule_id will be used."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULE_IDS_FIELD_NUMBER: builtins.int
    CLIENT_KEYS_FIELD_NUMBER: builtins.int
    @property
    def rule_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def client_keys(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        rule_ids: collections.abc.Iterable[builtins.str] | None = ...,
        client_keys: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["client_keys", b"client_keys", "rule_ids", b"rule_ids"]) -> None: ...

global___BatchUndeleteRulesRequest = BatchUndeleteRulesRequest

@typing.final
class BatchUndeleteRulesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___BatchUndeleteRulesResponse = BatchUndeleteRulesResponse

@typing.final
class ViewHumanFriendlyRulesRequest(google.protobuf.message.Message):
    """Deprecated - use ViewJsonRulesRequest."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ASSET_ID_FIELD_NUMBER: builtins.int
    asset_id: builtins.str
    def __init__(
        self,
        *,
        asset_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["asset_id", b"asset_id"]) -> None: ...

global___ViewHumanFriendlyRulesRequest = ViewHumanFriendlyRulesRequest

@typing.final
class ViewHumanFriendlyRulesResponse(google.protobuf.message.Message):
    """Deprecated - use ViewJsonRulesResponse."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULES_JSON_FIELD_NUMBER: builtins.int
    rules_json: builtins.str
    def __init__(
        self,
        *,
        rules_json: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["rules_json", b"rules_json"]) -> None: ...

global___ViewHumanFriendlyRulesResponse = ViewHumanFriendlyRulesResponse

@typing.final
class UpdateHumanFriendlyRulesRequest(google.protobuf.message.Message):
    """Deprecated - use UpdateJsonRulesRequest."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ASSET_ID_FIELD_NUMBER: builtins.int
    RULES_JSON_FIELD_NUMBER: builtins.int
    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    asset_id: builtins.str
    rules_json: builtins.str
    organization_id: builtins.str
    def __init__(
        self,
        *,
        asset_id: builtins.str = ...,
        rules_json: builtins.str = ...,
        organization_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["asset_id", b"asset_id", "organization_id", b"organization_id", "rules_json", b"rules_json"]) -> None: ...

global___UpdateHumanFriendlyRulesRequest = UpdateHumanFriendlyRulesRequest

@typing.final
class UpdateHumanFriendlyRulesResponse(google.protobuf.message.Message):
    """Deprecated - use UpdateJsonRulesResponse."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUCCESS_FIELD_NUMBER: builtins.int
    RULES_COUNT_FIELD_NUMBER: builtins.int
    MESSAGES_FIELD_NUMBER: builtins.int
    success: builtins.bool
    rules_count: builtins.int
    messages: builtins.str
    def __init__(
        self,
        *,
        success: builtins.bool = ...,
        rules_count: builtins.int = ...,
        messages: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["messages", b"messages", "rules_count", b"rules_count", "success", b"success"]) -> None: ...

global___UpdateHumanFriendlyRulesResponse = UpdateHumanFriendlyRulesResponse

@typing.final
class ViewJsonRulesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ASSET_ID_FIELD_NUMBER: builtins.int
    asset_id: builtins.str
    def __init__(
        self,
        *,
        asset_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["asset_id", b"asset_id"]) -> None: ...

global___ViewJsonRulesRequest = ViewJsonRulesRequest

@typing.final
class ViewJsonRulesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULES_JSON_FIELD_NUMBER: builtins.int
    rules_json: builtins.str
    def __init__(
        self,
        *,
        rules_json: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["rules_json", b"rules_json"]) -> None: ...

global___ViewJsonRulesResponse = ViewJsonRulesResponse

@typing.final
class JsonRulesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ASSET_ID_FIELD_NUMBER: builtins.int
    RULES_JSON_FIELD_NUMBER: builtins.int
    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    asset_id: builtins.str
    rules_json: builtins.str
    organization_id: builtins.str
    def __init__(
        self,
        *,
        asset_id: builtins.str = ...,
        rules_json: builtins.str = ...,
        organization_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["asset_id", b"asset_id", "organization_id", b"organization_id", "rules_json", b"rules_json"]) -> None: ...

global___JsonRulesRequest = JsonRulesRequest

@typing.final
class JsonRulesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUCCESS_FIELD_NUMBER: builtins.int
    TOTAL_RULES_COUNT_FIELD_NUMBER: builtins.int
    RULES_CREATED_COUNT_FIELD_NUMBER: builtins.int
    RULES_UPDATED_COUNT_FIELD_NUMBER: builtins.int
    RULES_DELETED_COUNT_FIELD_NUMBER: builtins.int
    ERROR_MESSAGES_FIELD_NUMBER: builtins.int
    success: builtins.bool
    total_rules_count: builtins.int
    rules_created_count: builtins.int
    rules_updated_count: builtins.int
    rules_deleted_count: builtins.int
    error_messages: builtins.str
    def __init__(
        self,
        *,
        success: builtins.bool = ...,
        total_rules_count: builtins.int = ...,
        rules_created_count: builtins.int = ...,
        rules_updated_count: builtins.int = ...,
        rules_deleted_count: builtins.int = ...,
        error_messages: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_error_messages", b"_error_messages", "error_messages", b"error_messages"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_error_messages", b"_error_messages", "error_messages", b"error_messages", "rules_created_count", b"rules_created_count", "rules_deleted_count", b"rules_deleted_count", "rules_updated_count", b"rules_updated_count", "success", b"success", "total_rules_count", b"total_rules_count"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_error_messages", b"_error_messages"]) -> typing.Literal["error_messages"] | None: ...

global___JsonRulesResponse = JsonRulesResponse

@typing.final
class ValidateJsonRulesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REQUEST_FIELD_NUMBER: builtins.int
    @property
    def request(self) -> global___JsonRulesRequest: ...
    def __init__(
        self,
        *,
        request: global___JsonRulesRequest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["request", b"request"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["request", b"request"]) -> None: ...

global___ValidateJsonRulesRequest = ValidateJsonRulesRequest

@typing.final
class ValidateJsonRulesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESPONSE_FIELD_NUMBER: builtins.int
    @property
    def response(self) -> global___JsonRulesResponse: ...
    def __init__(
        self,
        *,
        response: global___JsonRulesResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["response", b"response"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["response", b"response"]) -> None: ...

global___ValidateJsonRulesResponse = ValidateJsonRulesResponse

@typing.final
class UpdateJsonRulesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REQUEST_FIELD_NUMBER: builtins.int
    @property
    def request(self) -> global___JsonRulesRequest: ...
    def __init__(
        self,
        *,
        request: global___JsonRulesRequest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["request", b"request"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["request", b"request"]) -> None: ...

global___UpdateJsonRulesRequest = UpdateJsonRulesRequest

@typing.final
class UpdateJsonRulesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESPONSE_FIELD_NUMBER: builtins.int
    @property
    def response(self) -> global___JsonRulesResponse: ...
    def __init__(
        self,
        *,
        response: global___JsonRulesResponse | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["response", b"response"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["response", b"response"]) -> None: ...

global___UpdateJsonRulesResponse = UpdateJsonRulesResponse

@typing.final
class ListRulesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of Rules to return.
    The service may return fewer than this value.
    If unspecified, at most 50 Rules will be returned.
    The maximum value is 1000; values above 1000 will be coerced to 1000.
    """
    page_token: builtins.str
    """A page token, received from a previous `ListRules` call.
    Provide this to retrieve the subsequent page.
    When paginating, all other parameters provided to `ListRules` must match
    the call that provided the page token.
    """
    filter: builtins.str
    """A [Common Expression Language (CEL)](https://github.com/google/cel-spec) filter string.
    Available fields to filter by are `rule_id`, `client_key`, `name`, and `description`.
    For further information about how to use CELs, please refer to [this guide](https://github.com/google/cel-spec/blob/master/doc/langdef.md#standard-definitions).
    Optional.
    """
    order_by: builtins.str
    """How to order the retrieved Rules. Formatted as a comma-separated string i.e. "FIELD_NAME[ desc],...".
    Available fields to order_by are `created_date` and `modified_date`.
    If left empty, items are ordered by `created_date` in ascending order (oldest-first).
    """
    def __init__(
        self,
        *,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
        order_by: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListRulesRequest = ListRulesRequest

@typing.final
class ListRulesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    @property
    def rules(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Rule]: ...
    def __init__(
        self,
        *,
        rules: collections.abc.Iterable[global___Rule] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "rules", b"rules"]) -> None: ...

global___ListRulesResponse = ListRulesResponse

@typing.final
class ListRuleVersionsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULE_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    rule_id: builtins.str
    page_size: builtins.int
    """The maximum number of Rule Versions to return.
    The service may return fewer than this value.
    If unspecified, at most 50 Rule Versions will be returned.
    The maximum value is 1000; values above 1000 will be coerced to 1000.
    """
    page_token: builtins.str
    """A page token, received from a previous `ListRuleVersions` call.
    Provide this to retrieve the subsequent page.
    When paginating, all other parameters provided to `ListRuleVersions` must match
    the call that provided the page token.
    """
    filter: builtins.str
    """A [Common Expression Language (CEL)](https://github.com/google/cel-spec) filter string.
    Available fields to filter by are `rule_version_id`, `user_notes`,  and `change_message`.
    For further information about how to use CELs, please refer to [this guide](https://github.com/google/cel-spec/blob/master/doc/langdef.md#standard-definitions). Optional.
    """
    def __init__(
        self,
        *,
        rule_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "rule_id", b"rule_id"]) -> None: ...

global___ListRuleVersionsRequest = ListRuleVersionsRequest

@typing.final
class RuleVersion(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULE_ID_FIELD_NUMBER: builtins.int
    RULE_VERSION_ID_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    CREATED_DATE_FIELD_NUMBER: builtins.int
    CREATED_BY_USER_ID_FIELD_NUMBER: builtins.int
    VERSION_NOTES_FIELD_NUMBER: builtins.int
    GENERATED_CHANGE_MESSAGE_FIELD_NUMBER: builtins.int
    DELETED_DATE_FIELD_NUMBER: builtins.int
    rule_id: builtins.str
    rule_version_id: builtins.str
    version: builtins.str
    created_by_user_id: builtins.str
    version_notes: builtins.str
    generated_change_message: builtins.str
    @property
    def created_date(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def deleted_date(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        rule_id: builtins.str = ...,
        rule_version_id: builtins.str = ...,
        version: builtins.str = ...,
        created_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        created_by_user_id: builtins.str = ...,
        version_notes: builtins.str = ...,
        generated_change_message: builtins.str = ...,
        deleted_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_date", b"created_date", "deleted_date", b"deleted_date"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["created_by_user_id", b"created_by_user_id", "created_date", b"created_date", "deleted_date", b"deleted_date", "generated_change_message", b"generated_change_message", "rule_id", b"rule_id", "rule_version_id", b"rule_version_id", "version", b"version", "version_notes", b"version_notes"]) -> None: ...

global___RuleVersion = RuleVersion

@typing.final
class ListRuleVersionsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULE_VERSIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    @property
    def rule_versions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RuleVersion]: ...
    def __init__(
        self,
        *,
        rule_versions: collections.abc.Iterable[global___RuleVersion] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "rule_versions", b"rule_versions"]) -> None: ...

global___ListRuleVersionsResponse = ListRuleVersionsResponse

@typing.final
class GetRuleVersionRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULE_VERSION_ID_FIELD_NUMBER: builtins.int
    rule_version_id: builtins.str
    def __init__(
        self,
        *,
        rule_version_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["rule_version_id", b"rule_version_id"]) -> None: ...

global___GetRuleVersionRequest = GetRuleVersionRequest

@typing.final
class GetRuleVersionResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULE_FIELD_NUMBER: builtins.int
    @property
    def rule(self) -> global___Rule: ...
    def __init__(
        self,
        *,
        rule: global___Rule | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["rule", b"rule"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["rule", b"rule"]) -> None: ...

global___GetRuleVersionResponse = GetRuleVersionResponse

@typing.final
class BatchGetRuleVersionsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULE_VERSION_IDS_FIELD_NUMBER: builtins.int
    @property
    def rule_version_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        rule_version_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["rule_version_ids", b"rule_version_ids"]) -> None: ...

global___BatchGetRuleVersionsRequest = BatchGetRuleVersionsRequest

@typing.final
class BatchGetRuleVersionsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULES_FIELD_NUMBER: builtins.int
    @property
    def rules(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Rule]: ...
    def __init__(
        self,
        *,
        rules: collections.abc.Iterable[global___Rule] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["rules", b"rules"]) -> None: ...

global___BatchGetRuleVersionsResponse = BatchGetRuleVersionsResponse

@typing.final
class RuleConditionExpression(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SINGLE_CHANNEL_COMPARISON_FIELD_NUMBER: builtins.int
    CALCULATED_CHANNEL_FIELD_NUMBER: builtins.int
    PYTHON_CODE_FIELD_NUMBER: builtins.int
    @property
    def single_channel_comparison(self) -> global___SingleChannelComparisonExpression: ...
    @property
    def calculated_channel(self) -> global___CalculatedChannelConfig: ...
    @property
    def python_code(self) -> global___PythonCode:
        """Experimental - not currently enabled"""

    def __init__(
        self,
        *,
        single_channel_comparison: global___SingleChannelComparisonExpression | None = ...,
        calculated_channel: global___CalculatedChannelConfig | None = ...,
        python_code: global___PythonCode | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["calculated_channel", b"calculated_channel", "expression", b"expression", "python_code", b"python_code", "single_channel_comparison", b"single_channel_comparison"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["calculated_channel", b"calculated_channel", "expression", b"expression", "python_code", b"python_code", "single_channel_comparison", b"single_channel_comparison"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["expression", b"expression"]) -> typing.Literal["single_channel_comparison", "calculated_channel", "python_code"] | None: ...

global___RuleConditionExpression = RuleConditionExpression

@typing.final
class SingleChannelComparisonExpression(google.protobuf.message.Message):
    """Deprecated - use CalculatedChannelConfig."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_COMPONENT_FIELD_NUMBER: builtins.int
    CHANNEL_NAME_FIELD_NUMBER: builtins.int
    COMPARATOR_FIELD_NUMBER: builtins.int
    DOUBLE_FIELD_NUMBER: builtins.int
    STRING_FIELD_NUMBER: builtins.int
    LAST_VALUE_FIELD_NUMBER: builtins.int
    channel_component: builtins.str
    """Deprecated - use channel_name instead. If provided, channel_component will be joined with the name as `channel_component.channel_name`"""
    channel_name: builtins.str
    comparator: global___ConditionComparator.ValueType
    double: builtins.float
    string: builtins.str
    @property
    def last_value(self) -> global___LastValueThreshold: ...
    def __init__(
        self,
        *,
        channel_component: builtins.str = ...,
        channel_name: builtins.str = ...,
        comparator: global___ConditionComparator.ValueType = ...,
        double: builtins.float = ...,
        string: builtins.str = ...,
        last_value: global___LastValueThreshold | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["double", b"double", "last_value", b"last_value", "string", b"string", "threshold", b"threshold"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["channel_component", b"channel_component", "channel_name", b"channel_name", "comparator", b"comparator", "double", b"double", "last_value", b"last_value", "string", b"string", "threshold", b"threshold"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["threshold", b"threshold"]) -> typing.Literal["double", "string", "last_value"] | None: ...

global___SingleChannelComparisonExpression = SingleChannelComparisonExpression

@typing.final
class LastValueThreshold(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___LastValueThreshold = LastValueThreshold

@typing.final
class CalculatedChannelConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class ChannelReferencesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___ChannelReference: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___ChannelReference | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    CHANNEL_REFERENCES_FIELD_NUMBER: builtins.int
    EXPRESSION_FIELD_NUMBER: builtins.int
    FUNCTION_DEPENDENCIES_FIELD_NUMBER: builtins.int
    expression: builtins.str
    @property
    def channel_references(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___ChannelReference]: ...
    @property
    def function_dependencies(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[sift.common.type.v1.user_defined_functions_pb2.FunctionDependency]:
        """This will be ignored in requests and will be generated automatically."""

    def __init__(
        self,
        *,
        channel_references: collections.abc.Mapping[builtins.str, global___ChannelReference] | None = ...,
        expression: builtins.str = ...,
        function_dependencies: collections.abc.Iterable[sift.common.type.v1.user_defined_functions_pb2.FunctionDependency] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_references", b"channel_references", "expression", b"expression", "function_dependencies", b"function_dependencies"]) -> None: ...

global___CalculatedChannelConfig = CalculatedChannelConfig

@typing.final
class ChannelReference(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    COMPONENT_FIELD_NUMBER: builtins.int
    name: builtins.str
    component: builtins.str
    """Deprecated - use name instead. If provided, name will be joined with the component as `component.name`"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        component: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["component", b"component", "name", b"name"]) -> None: ...

global___ChannelReference = ChannelReference

@typing.final
class PythonChannelReference(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REFERENCE_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    reference: builtins.str
    name: builtins.str
    def __init__(
        self,
        *,
        reference: builtins.str = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["name", b"name", "reference", b"reference"]) -> None: ...

global___PythonChannelReference = PythonChannelReference

@typing.final
class PythonCode(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_REFERENCES_FIELD_NUMBER: builtins.int
    CODE_FIELD_NUMBER: builtins.int
    DEPENDENCIES_FIELD_NUMBER: builtins.int
    code: builtins.str
    dependencies: builtins.str
    @property
    def channel_references(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PythonChannelReference]: ...
    def __init__(
        self,
        *,
        channel_references: collections.abc.Iterable[global___PythonChannelReference] | None = ...,
        code: builtins.str = ...,
        dependencies: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["channel_references", b"channel_references", "code", b"code", "dependencies", b"dependencies"]) -> None: ...

global___PythonCode = PythonCode

@typing.final
class RuleActionConfiguration(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NOTIFICATION_FIELD_NUMBER: builtins.int
    ANNOTATION_FIELD_NUMBER: builtins.int
    @property
    def notification(self) -> global___NotificationActionConfiguration: ...
    @property
    def annotation(self) -> global___AnnotationActionConfiguration: ...
    def __init__(
        self,
        *,
        notification: global___NotificationActionConfiguration | None = ...,
        annotation: global___AnnotationActionConfiguration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["annotation", b"annotation", "configuration", b"configuration", "notification", b"notification"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["annotation", b"annotation", "configuration", b"configuration", "notification", b"notification"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["configuration", b"configuration"]) -> typing.Literal["notification", "annotation"] | None: ...

global___RuleActionConfiguration = RuleActionConfiguration

@typing.final
class NotificationActionConfiguration(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RECIPIENT_USER_IDS_FIELD_NUMBER: builtins.int
    @property
    def recipient_user_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        recipient_user_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["recipient_user_ids", b"recipient_user_ids"]) -> None: ...

global___NotificationActionConfiguration = NotificationActionConfiguration

@typing.final
class AnnotationActionConfiguration(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TAG_IDS_FIELD_NUMBER: builtins.int
    ANNOTATION_TYPE_FIELD_NUMBER: builtins.int
    ASSIGNED_TO_USER_ID_FIELD_NUMBER: builtins.int
    annotation_type: sift.annotations.v1.annotations_pb2.AnnotationType.ValueType
    assigned_to_user_id: builtins.str
    @property
    def tag_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        tag_ids: collections.abc.Iterable[builtins.str] | None = ...,
        annotation_type: sift.annotations.v1.annotations_pb2.AnnotationType.ValueType = ...,
        assigned_to_user_id: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_assigned_to_user_id", b"_assigned_to_user_id", "assigned_to_user_id", b"assigned_to_user_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_assigned_to_user_id", b"_assigned_to_user_id", "annotation_type", b"annotation_type", "assigned_to_user_id", b"assigned_to_user_id", "tag_ids", b"tag_ids"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_assigned_to_user_id", b"_assigned_to_user_id"]) -> typing.Literal["assigned_to_user_id"] | None: ...

global___AnnotationActionConfiguration = AnnotationActionConfiguration

@typing.final
class EvaluateRulesRequest(google.protobuf.message.Message):
    """Deprecated - use RuleEvaluationService instead."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULE_IDS_FIELD_NUMBER: builtins.int
    ANNOTATION_OPTIONS_FIELD_NUMBER: builtins.int
    RUN_ID_FIELD_NUMBER: builtins.int
    TIME_RANGE_FIELD_NUMBER: builtins.int
    DRY_RUN_FIELD_NUMBER: builtins.int
    run_id: builtins.str
    dry_run: builtins.bool
    @property
    def rule_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def annotation_options(self) -> global___EvaluatedAnnotationOptions: ...
    @property
    def time_range(self) -> global___TimeRangeQuery: ...
    def __init__(
        self,
        *,
        rule_ids: collections.abc.Iterable[builtins.str] | None = ...,
        annotation_options: global___EvaluatedAnnotationOptions | None = ...,
        run_id: builtins.str = ...,
        time_range: global___TimeRangeQuery | None = ...,
        dry_run: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["annotation_options", b"annotation_options", "run_id", b"run_id", "time", b"time", "time_range", b"time_range"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["annotation_options", b"annotation_options", "dry_run", b"dry_run", "rule_ids", b"rule_ids", "run_id", b"run_id", "time", b"time", "time_range", b"time_range"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["time", b"time"]) -> typing.Literal["run_id", "time_range"] | None: ...

global___EvaluateRulesRequest = EvaluateRulesRequest

@typing.final
class EvaluatedAnnotationOptions(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TAG_IDS_FIELD_NUMBER: builtins.int
    @property
    def tag_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        tag_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["tag_ids", b"tag_ids"]) -> None: ...

global___EvaluatedAnnotationOptions = EvaluatedAnnotationOptions

@typing.final
class TimeRangeQuery(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    START_TIME_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def end_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        end_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["end_time", b"end_time", "start_time", b"start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["end_time", b"end_time", "start_time", b"start_time"]) -> None: ...

global___TimeRangeQuery = TimeRangeQuery

@typing.final
class EvaluateRulesResponse(google.protobuf.message.Message):
    """Deprecated - use RuleEvaluationService instead."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CREATED_ANNOTATION_COUNT_FIELD_NUMBER: builtins.int
    DRY_RUN_ANNOTATIONS_FIELD_NUMBER: builtins.int
    JOB_ID_FIELD_NUMBER: builtins.int
    REPORT_ID_FIELD_NUMBER: builtins.int
    created_annotation_count: builtins.int
    job_id: builtins.str
    """job_id and report_id will be set if the job has an extended run time and is being processed asynchronously."""
    report_id: builtins.str
    @property
    def dry_run_annotations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DryRunAnnotation]:
        """If dry_run is true, this will be populated with the annotations that would be created"""

    def __init__(
        self,
        *,
        created_annotation_count: builtins.int = ...,
        dry_run_annotations: collections.abc.Iterable[global___DryRunAnnotation] | None = ...,
        job_id: builtins.str | None = ...,
        report_id: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_job_id", b"_job_id", "_report_id", b"_report_id", "job_id", b"job_id", "report_id", b"report_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_job_id", b"_job_id", "_report_id", b"_report_id", "created_annotation_count", b"created_annotation_count", "dry_run_annotations", b"dry_run_annotations", "job_id", b"job_id", "report_id", b"report_id"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_job_id", b"_job_id"]) -> typing.Literal["job_id"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_report_id", b"_report_id"]) -> typing.Literal["report_id"] | None: ...

global___EvaluateRulesResponse = EvaluateRulesResponse

@typing.final
class DryRunAnnotation(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONDITION_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    CONDITION_VERSION_ID_FIELD_NUMBER: builtins.int
    condition_id: builtins.str
    name: builtins.str
    condition_version_id: builtins.str
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def end_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        condition_id: builtins.str = ...,
        name: builtins.str = ...,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        end_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        condition_version_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["end_time", b"end_time", "start_time", b"start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["condition_id", b"condition_id", "condition_version_id", b"condition_version_id", "end_time", b"end_time", "name", b"name", "start_time", b"start_time"]) -> None: ...

global___DryRunAnnotation = DryRunAnnotation
