# DO NOT MODIFY -- This file is generated by type_spec
# flake8: noqa: F821
# ruff: noqa: E402
# fmt: off
# isort: skip_file
# ruff: noqa: PLR0904
from __future__ import annotations
import typing  # noqa: F401
import datetime  # noqa: F401
from decimal import Decimal  # noqa: F401
from pkgs.serialization import OpaqueKey
import uncountable.types.api.recipes.associate_recipe_as_input as associate_recipe_as_input_t
import uncountable.types.api.recipes.associate_recipe_as_lot as associate_recipe_as_lot_t
from . import base as base_t
import uncountable.types.api.chemical.convert_chemical_formats as convert_chemical_formats_t
import uncountable.types.api.entity.create_entities as create_entities_t
import uncountable.types.api.entity.create_entity as create_entity_t
import uncountable.types.api.inputs.create_inputs as create_inputs_t
import uncountable.types.api.recipes.create_recipe as create_recipe_t
import uncountable.types.api.recipe_links.create_recipe_link as create_recipe_link_t
import uncountable.types.api.recipes.create_recipes as create_recipes_t
from . import entity as entity_t
import uncountable.types.api.batch.execute_batch as execute_batch_t
from . import field_values as field_values_t
import uncountable.types.api.recipes.get_curve as get_curve_t
import uncountable.types.api.entity.get_entities_data as get_entities_data_t
import uncountable.types.api.inputs.get_input_data as get_input_data_t
import uncountable.types.api.input_groups.get_input_group_names as get_input_group_names_t
import uncountable.types.api.inputs.get_input_names as get_input_names_t
import uncountable.types.api.inputs.get_inputs_data as get_inputs_data_t
import uncountable.types.api.outputs.get_output_data as get_output_data_t
import uncountable.types.api.outputs.get_output_names as get_output_names_t
import uncountable.types.api.project.get_projects as get_projects_t
import uncountable.types.api.project.get_projects_data as get_projects_data_t
import uncountable.types.api.recipes.get_recipe_calculations as get_recipe_calculations_t
import uncountable.types.api.recipes.get_recipe_links as get_recipe_links_t
import uncountable.types.api.recipe_metadata.get_recipe_metadata_data as get_recipe_metadata_data_t
import uncountable.types.api.recipes.get_recipe_names as get_recipe_names_t
import uncountable.types.api.recipes.get_recipe_output_metadata as get_recipe_output_metadata_t
import uncountable.types.api.recipes.get_recipes_data as get_recipes_data_t
from . import identifier as identifier_t
import uncountable.types.api.entity.list_entities as list_entities_t
from . import recipe_identifiers as recipe_identifiers_t
from . import recipe_links as recipe_links_t
from . import recipe_metadata as recipe_metadata_t
import uncountable.types.api.entity.resolve_entity_ids as resolve_entity_ids_t
import uncountable.types.api.outputs.resolve_output_conditions as resolve_output_conditions_t
import uncountable.types.api.inputs.set_input_attribute_values as set_input_attribute_values_t
import uncountable.types.api.recipes.set_recipe_inputs as set_recipe_inputs_t
import uncountable.types.api.recipes.set_recipe_metadata as set_recipe_metadata_t
import uncountable.types.api.recipes.set_recipe_outputs as set_recipe_outputs_t
import uncountable.types.api.entity.set_values as set_values_t
from abc import ABC, abstractmethod
from dataclasses import dataclass

DT = typing.TypeVar("DT")


@dataclass(kw_only=True)
class APIRequest:
    method: str
    endpoint: str
    args: typing.Any


class ClientMethods(ABC):

    @abstractmethod
    def do_request(self, *, api_request: APIRequest, return_type: type[DT]) -> DT:
        ...


    def associate_recipe_as_input(
        self,
        *,
        recipe_key: identifier_t.IdentifierKey,
    ) -> associate_recipe_as_input_t.Data:
        """Create or return the input association for a recipe

        :param recipe_key: Identifier for the recipe
        """
        args = associate_recipe_as_input_t.Arguments(
            recipe_key=recipe_key,
        )
        api_request = APIRequest(
            method=associate_recipe_as_input_t.ENDPOINT_METHOD,
            endpoint=associate_recipe_as_input_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=associate_recipe_as_input_t.Data)


    def associate_recipe_as_lot(
        self,
        *,
        recipe_key: identifier_t.IdentifierKey,
        ingredient_key: identifier_t.IdentifierKey,
    ) -> associate_recipe_as_lot_t.Data:
        """Create a new lot association for the provided recipe with the provided ingredient

        :param recipe_key: Identifier for the recipe
        :param ingredient_key: Identifier for the ingredient
        """
        args = associate_recipe_as_lot_t.Arguments(
            recipe_key=recipe_key,
            ingredient_key=ingredient_key,
        )
        api_request = APIRequest(
            method=associate_recipe_as_lot_t.ENDPOINT_METHOD,
            endpoint=associate_recipe_as_lot_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=associate_recipe_as_lot_t.Data)


    def convert_chemical_formats(
        self,
        *,
        source_chemical_structures: list[convert_chemical_formats_t.ChemicalStructureFile],
    ) -> convert_chemical_formats_t.Data:
        """Converts chemical formats, into the format used by Uncountable and usable in other APIs for eg. set_input_attribute_values

        """
        args = convert_chemical_formats_t.Arguments(
            source_chemical_structures=source_chemical_structures,
        )
        api_request = APIRequest(
            method=convert_chemical_formats_t.ENDPOINT_METHOD,
            endpoint=convert_chemical_formats_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=convert_chemical_formats_t.Data)


    def create_entities(
        self,
        *,
        definition_id: base_t.ObjectId,
        entity_type: typing.Union[typing.Literal[entity_t.EntityType.LAB_REQUEST], typing.Literal[entity_t.EntityType.APPROVAL], typing.Literal[entity_t.EntityType.CUSTOM_ENTITY], typing.Literal[entity_t.EntityType.TASK], typing.Literal[entity_t.EntityType.PROJECT], typing.Literal[entity_t.EntityType.EQUIPMENT], typing.Literal[entity_t.EntityType.INV_LOCAL_LOCATIONS]],
        entities_to_create: list[create_entities_t.EntityToCreate],
    ) -> create_entities_t.Data:
        """Creates new Uncountable entities

        :param definition_id: Definition id for the entities to create
        :param entity_type: The type of the entities to create
        :param entities_to_create: A list of the entities to create
        """
        args = create_entities_t.Arguments(
            definition_id=definition_id,
            entity_type=entity_type,
            entities_to_create=entities_to_create,
        )
        api_request = APIRequest(
            method=create_entities_t.ENDPOINT_METHOD,
            endpoint=create_entities_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=create_entities_t.Data)


    def create_entity(
        self,
        *,
        definition_id: base_t.ObjectId,
        entity_type: typing.Union[typing.Literal[entity_t.EntityType.LAB_REQUEST], typing.Literal[entity_t.EntityType.APPROVAL], typing.Literal[entity_t.EntityType.CUSTOM_ENTITY], typing.Literal[entity_t.EntityType.TASK], typing.Literal[entity_t.EntityType.PROJECT], typing.Literal[entity_t.EntityType.EQUIPMENT], typing.Literal[entity_t.EntityType.INV_LOCAL_LOCATIONS]],
        field_values: typing.Optional[typing.Optional[list[field_values_t.FieldRefNameValue]]] = None,
    ) -> create_entity_t.Data:
        """Creates a new Uncountable entity

        :param definition_id: Definition id of the entity to create
        :param entity_type: The type of the entities requested
        """
        args = create_entity_t.Arguments(
            definition_id=definition_id,
            entity_type=entity_type,
            field_values=field_values,
        )
        api_request = APIRequest(
            method=create_entity_t.ENDPOINT_METHOD,
            endpoint=create_entity_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=create_entity_t.Data)


    def external_create_inputs(
        self,
        *,
        inputs_to_create: list[create_inputs_t.InputToCreate],
    ) -> create_inputs_t.Data:
        """Creates new inputs

        :param inputs_to_create: A list of inputs to create
        """
        args = create_inputs_t.Arguments(
            inputs_to_create=inputs_to_create,
        )
        api_request = APIRequest(
            method=create_inputs_t.ENDPOINT_METHOD,
            endpoint=create_inputs_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=create_inputs_t.Data)


    def create_recipe(
        self,
        *,
        material_family_id: base_t.ObjectId,
        workflow_id: base_t.ObjectId,
        identifiers: recipe_identifiers_t.RecipeIdentifiers,
        name: typing.Optional[str] = None,
        workflow_variant_id: typing.Optional[typing.Optional[base_t.ObjectId]] = None,
        recipe_metadata: typing.Optional[list[recipe_metadata_t.MetadataValue]] = None,
    ) -> create_recipe_t.Data:
        """Returns the id of the recipe being created.

        :param name: The name for the recipe
        :param material_family_id: The material family for the recipe
        :param workflow_id: The identifier of the workflow to create the recipe with
        :param workflow_variant_id: The identifier of the workflow variant to create the recipe with
        :param recipe_metadata: Metadata values to populate the recipe with
        :param identifiers: A recipe won't be created if it matches the identifier.  An identifier must be unique in the schema
        """
        args = create_recipe_t.Arguments(
            name=name,
            material_family_id=material_family_id,
            workflow_id=workflow_id,
            workflow_variant_id=workflow_variant_id,
            recipe_metadata=recipe_metadata,
            identifiers=identifiers,
        )
        api_request = APIRequest(
            method=create_recipe_t.ENDPOINT_METHOD,
            endpoint=create_recipe_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=create_recipe_t.Data)


    def create_recipe_link(
        self,
        *,
        recipe_from_key: identifier_t.IdentifierKey,
        recipe_to_key: identifier_t.IdentifierKey,
        link_type: typing.Union[typing.Literal[recipe_links_t.RecipeLinkType.CHILD], typing.Literal[recipe_links_t.RecipeLinkType.CONTROL], typing.Literal[recipe_links_t.RecipeLinkType.USER_LINK]],
        name: str,
    ) -> create_recipe_link_t.Data:
        """Create a link between two recipes.  Skip if the link already exists

        :param recipe_from_key: Identifier for the recipe the link comes from
        :param recipe_to_key: Identifier for the recipe the link goes to
        :param link_type: The type of link being created
        :param name: The name used for the link
        """
        args = create_recipe_link_t.Arguments(
            recipe_from_key=recipe_from_key,
            recipe_to_key=recipe_to_key,
            link_type=link_type,
            name=name,
        )
        api_request = APIRequest(
            method=create_recipe_link_t.ENDPOINT_METHOD,
            endpoint=create_recipe_link_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=create_recipe_link_t.Data)


    def create_recipes(
        self,
        *,
        material_family_id: base_t.ObjectId,
        recipe_definitions: list[create_recipes_t.CreateRecipeDefinition],
        project_id: typing.Optional[base_t.ObjectId] = None,
    ) -> create_recipes_t.Data:
        """Sets inputs values for an experiment. Values set can be numeric, text or categorical types in the Uncountable system

        :param material_family_id: The identifier of the material family to create the recipes in
        :param project_id: The identifier of the project to create the recipes in
        """
        args = create_recipes_t.Arguments(
            material_family_id=material_family_id,
            project_id=project_id,
            recipe_definitions=recipe_definitions,
        )
        api_request = APIRequest(
            method=create_recipes_t.ENDPOINT_METHOD,
            endpoint=create_recipes_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=create_recipes_t.Data)


    def execute_batch(
        self,
        *,
        requests: list[execute_batch_t.BatchRequest],
    ) -> execute_batch_t.Data:
        """Run multiple API calls via one request

        """
        args = execute_batch_t.Arguments(
            requests=requests,
        )
        api_request = APIRequest(
            method=execute_batch_t.ENDPOINT_METHOD,
            endpoint=execute_batch_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=execute_batch_t.Data)


    def get_curve(
        self,
        *,
        recipe_output_id: base_t.ObjectId,
    ) -> get_curve_t.Data:
        """Returns an array of values for the specified curve id.

        :param recipe_output_id: The recipe output ID to fetch the curve for. This must be a curve recipe output. Recipe Outputs can be found from external_get_recipes_data
        """
        args = get_curve_t.Arguments(
            recipe_output_id=recipe_output_id,
        )
        api_request = APIRequest(
            method=get_curve_t.ENDPOINT_METHOD,
            endpoint=get_curve_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_curve_t.Data)


    def get_entities_data(
        self,
        *,
        entity_ids: list[base_t.ObjectId],
        entity_type: entity_t.EntityType,
    ) -> get_entities_data_t.Data:
        """Gets the details for a passed entity

        :param entity_ids: Ids of the entity to retrieve
        :param entity_type: The type of the entities requested, e.g. lab_request or approval
        """
        args = get_entities_data_t.Arguments(
            entity_ids=entity_ids,
            entity_type=entity_type,
        )
        api_request = APIRequest(
            method=get_entities_data_t.ENDPOINT_METHOD,
            endpoint=get_entities_data_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_entities_data_t.Data)


    def get_input_data(
        self,
        *,
        material_family_id: base_t.ObjectId,
        input_ids: typing.Optional[list[base_t.ObjectId]],
        is_parameter: typing.Optional[bool],
        offset: typing.Optional[typing.Optional[int]] = None,
        limit: typing.Optional[typing.Optional[int]] = None,
    ) -> get_input_data_t.Data:
        """Gets the attribute, categorization and other metadata associated with a set of inputs. An input is either an ingredient or process parameter, with metadata and calculations assigned separately

        :param material_family_id: The material family ID to get the input values from.
        :param input_ids: The input IDs to get the data from. If this is not filled in, all inputs from a material family will be returned (in paginated form).
        :param offset: Used for pagination, where the number of results returned exceeds the limit. Results are always ordered by the input ID
        :param is_parameter: Whether to get parameters or ingredients. By default both are returned. When set to true, only parameters are returned, and when set to false, only ingredients are returned
        :param limit: The maximum number of results to return. By default this is set to 1,000 and it cannot be set higher than 1,000
        """
        args = get_input_data_t.Arguments(
            material_family_id=material_family_id,
            input_ids=input_ids,
            offset=offset,
            is_parameter=is_parameter,
            limit=limit,
        )
        api_request = APIRequest(
            method=get_input_data_t.ENDPOINT_METHOD,
            endpoint=get_input_data_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_input_data_t.Data)


    def get_input_group_names(
        self,
        *,
        material_family_id: base_t.ObjectId,
    ) -> get_input_group_names_t.Data:
        """Gets the name of all input groups in a material family that either the user created, or are shared to all users.

        :param material_family_id: Required: The Material Family ID to get the input groups from.
        """
        args = get_input_group_names_t.Arguments(
            material_family_id=material_family_id,
        )
        api_request = APIRequest(
            method=get_input_group_names_t.ENDPOINT_METHOD,
            endpoint=get_input_group_names_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_input_group_names_t.Data)


    def get_input_names(
        self,
        *,
        material_family_id: base_t.ObjectId,
        is_parameter: typing.Optional[bool],
        offset: typing.Optional[typing.Optional[int]] = None,
        limit: typing.Optional[typing.Optional[int]] = None,
    ) -> get_input_names_t.Data:
        """Gets the name of all inputs for a material family. An input is either an ingredient or process parameter, with metadata and calculations assigned separately

        :param material_family_id: The material family ID to get the input values from
        :param offset: Used for pagination, where the number of results returned exceeds the limit. Results are always ordered by the input ID
        :param is_parameter: Whether to get parameters or ingredients. By default both are returned. When set to true, only parameters are returned, and when set to false, only ingredients are returned
        :param limit: The maximum number of results to return. By default this is set to 20,000 and it cannot be set higher than 20,000
        """
        args = get_input_names_t.Arguments(
            material_family_id=material_family_id,
            offset=offset,
            is_parameter=is_parameter,
            limit=limit,
        )
        api_request = APIRequest(
            method=get_input_names_t.ENDPOINT_METHOD,
            endpoint=get_input_names_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_input_names_t.Data)


    def get_inputs_data(
        self,
        *,
        input_ids: list[base_t.ObjectId],
    ) -> get_inputs_data_t.Data:
        """Gets the details for passed input ids

        :param input_ids: Ids of the inputs to retrieve
        """
        args = get_inputs_data_t.Arguments(
            input_ids=input_ids,
        )
        api_request = APIRequest(
            method=get_inputs_data_t.ENDPOINT_METHOD,
            endpoint=get_inputs_data_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_inputs_data_t.Data)


    def get_output_data(
        self,
        *,
        material_family_id: base_t.ObjectId,
        output_ids: typing.Optional[list[base_t.ObjectId]] = None,
        offset: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
    ) -> get_output_data_t.Data:
        """Gets the attribute, categorization and other metadata associated with a set of outputs

        :param material_family_id: The material family ID to get the output values from.
        :param output_ids: The output IDs to get the data from. If this is not filled in, all outputs from a material family will be returned (in paginated form).
        :param offset: Used for pagination, where the number of results returned exceeds the limit. Results are always ordered by the output ID
        :param limit: The maximum number of results to return. By default this is set to 1,000 and it cannot be set higher than 1,000
        """
        args = get_output_data_t.Arguments(
            material_family_id=material_family_id,
            output_ids=output_ids,
            offset=offset,
            limit=limit,
        )
        api_request = APIRequest(
            method=get_output_data_t.ENDPOINT_METHOD,
            endpoint=get_output_data_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_output_data_t.Data)


    def get_output_names(
        self,
        *,
        material_family_id: base_t.ObjectId,
        offset: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
    ) -> get_output_names_t.Data:
        """Gets the name of all outputs for a material family. An output represents a measurement value of any time (numeric, text, curve, etc). This includes calculations based off of other outputs, such as a calculated change over time

        :param material_family_id: The material family ID to get the output values from
        :param offset: Used for pagination, where the number of results returned exceeds the limit. Results are always ordered by the output ID
        :param limit: The maximum number of results to return. By default this is set to 20,000 and it cannot be set higher than 20,000
        """
        args = get_output_names_t.Arguments(
            material_family_id=material_family_id,
            offset=offset,
            limit=limit,
        )
        api_request = APIRequest(
            method=get_output_names_t.ENDPOINT_METHOD,
            endpoint=get_output_names_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_output_names_t.Data)


    def get_projects(
        self,
        *,
        all_material_families: bool,
        material_family_id: typing.Optional[base_t.ObjectId],
    ) -> get_projects_t.Data:
        """Gets either all projects created in the platform, or the projects associated with a material family ID. Projects are where experiments are placed in Uncountable, similar to folders in a directory structure

        :param all_material_families: Whether to get projects from all material families. Material families are high level groupings of data, usually separated by functional area
        :param material_family_id: The specific material family ID to get projects from. Only fill this in if all_material_families is set to false
        """
        args = get_projects_t.Arguments(
            all_material_families=all_material_families,
            material_family_id=material_family_id,
        )
        api_request = APIRequest(
            method=get_projects_t.ENDPOINT_METHOD,
            endpoint=get_projects_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_projects_t.Data)


    def get_projects_data(
        self,
        *,
        project_ids: list[base_t.ObjectId],
        offset: typing.Optional[typing.Optional[int]] = None,
        limit: typing.Optional[typing.Optional[int]] = None,
    ) -> get_projects_data_t.Data:
        """Gets either all data associated with a set of projects created in the platform.  Because Uncountables recipe structure is complex, various data values are exploded out to increase efficiency in parsing, and this page is paginated to prevent too large of return values

        :param project_ids: The projects to get the data from
        :param offset: Used for pagination. All pagination is done in order of Project ID
        :param limit: The number of data points to return. If not filled in, it will be set to 100, and cannot be set higher than 100
        """
        args = get_projects_data_t.Arguments(
            project_ids=project_ids,
            offset=offset,
            limit=limit,
        )
        api_request = APIRequest(
            method=get_projects_data_t.ENDPOINT_METHOD,
            endpoint=get_projects_data_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_projects_data_t.Data)


    def get_recipe_calculations(
        self,
        *,
        recipe_ids: list[base_t.ObjectId],
        calculation_ids: typing.Optional[list[base_t.ObjectId]] = None,
    ) -> get_recipe_calculations_t.Data:
        """Gets the calculations for the passed recipes

        :param recipe_ids: Ids of the Recipes to retrieve calculations for
        :param calculation_ids: Optionally a list of ids of calculations to retrieve
        """
        args = get_recipe_calculations_t.Arguments(
            recipe_ids=recipe_ids,
            calculation_ids=calculation_ids,
        )
        api_request = APIRequest(
            method=get_recipe_calculations_t.ENDPOINT_METHOD,
            endpoint=get_recipe_calculations_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_recipe_calculations_t.Data)


    def get_recipe_links(
        self,
        *,
        recipe_ids: list[base_t.ObjectId],
        depth: int = 1,
        link_types: typing.Optional[list[recipe_links_t.RecipeLinkType]],
    ) -> get_recipe_links_t.Data:
        """Gets the links for the passed recipes

        :param recipe_ids: Ids of the Recipes to retrieve links for
        :param depth: How many layers deep to look for links
        :param link_types: Optional filter to only desired link types
        """
        args = get_recipe_links_t.Arguments(
            recipe_ids=recipe_ids,
            depth=depth,
            link_types=link_types,
        )
        api_request = APIRequest(
            method=get_recipe_links_t.ENDPOINT_METHOD,
            endpoint=get_recipe_links_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_recipe_links_t.Data)


    def get_recipe_metadata_data(
        self,
        *,
        material_family_id: base_t.ObjectId,
        recipe_metadata_ids: typing.Optional[list[base_t.ObjectId]],
        offset: typing.Optional[typing.Optional[int]] = None,
        limit: typing.Optional[typing.Optional[int]] = None,
    ) -> get_recipe_metadata_data_t.Data:
        """Gets the recipe metadata. Recipe metadata is data associated with experiments that is not an input, output or calculation, such as a sample ID.

        :param material_family_id: The material family ID to get the recipe metadata values from.
        :param recipe_metadata_ids: The recipe metadata IDs to get the data from. If this is not filled in, all metadata from a material family will be returned (in paginated form).
        :param offset: Used for pagination, where the number of results returned exceeds the limit. Results are always ordered by the metadata ID
        :param limit: The maximum number of results to return. By default this is set to 1,000 and it cannot be set higher than 1,000
        """
        args = get_recipe_metadata_data_t.Arguments(
            material_family_id=material_family_id,
            recipe_metadata_ids=recipe_metadata_ids,
            offset=offset,
            limit=limit,
        )
        api_request = APIRequest(
            method=get_recipe_metadata_data_t.ENDPOINT_METHOD,
            endpoint=get_recipe_metadata_data_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_recipe_metadata_data_t.Data)


    def get_recipe_names(
        self,
        *,
        project_id: base_t.ObjectId,
    ) -> get_recipe_names_t.Data:
        """Gets the name of all recipes (or experiments, used as synonyms by Uncountable) for a project. The call external_get_projects can be used to find projects

        :param project_id: Required: The project ID to get the recipes/experiments from.
        """
        args = get_recipe_names_t.Arguments(
            project_id=project_id,
        )
        api_request = APIRequest(
            method=get_recipe_names_t.ENDPOINT_METHOD,
            endpoint=get_recipe_names_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_recipe_names_t.Data)


    def get_recipe_output_metadata(
        self,
        *,
        recipe_output_ids: list[base_t.ObjectId],
    ) -> get_recipe_output_metadata_t.Data:
        """Gets the metadata values for the passed recipe outputs

        :param recipe_output_ids: Ids of the Recipe Outputs to retrieve metadata for
        """
        args = get_recipe_output_metadata_t.Arguments(
            recipe_output_ids=recipe_output_ids,
        )
        api_request = APIRequest(
            method=get_recipe_output_metadata_t.ENDPOINT_METHOD,
            endpoint=get_recipe_output_metadata_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_recipe_output_metadata_t.Data)


    def get_recipes_data(
        self,
        *,
        recipe_ids: typing.Optional[typing.Optional[list[base_t.ObjectId]]] = None,
        project_id: typing.Optional[typing.Optional[base_t.ObjectId]] = None,
        offset: typing.Optional[typing.Optional[int]] = None,
        limit: typing.Optional[typing.Optional[int]] = None,
    ) -> get_recipes_data_t.Data:
        """Gets all data associated with a set of recipes / experiments. Because Uncountables recipe structure is complex, various data values are exploded out to increase efficiency in parsing, and this page is paginated to prevent too large of return values

        :param recipe_ids: The recipes to get the data from. Either these or project_id must be filled in
        :param project_id: The projects to get the data from. Either these or recipe_ids must be filled in
        :param offset: Used for pagination. All pagination is done in order of Recipe ID
        :param limit: The number of data points to return. If not filled in, it will be set to 100, and cannot be set higher than 100
        """
        args = get_recipes_data_t.Arguments(
            recipe_ids=recipe_ids,
            project_id=project_id,
            offset=offset,
            limit=limit,
        )
        api_request = APIRequest(
            method=get_recipes_data_t.ENDPOINT_METHOD,
            endpoint=get_recipes_data_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_recipes_data_t.Data)


    def list_entities(
        self,
        *,
        entity_type: entity_t.EntityType,
        config_reference: str,
        attributes: typing.Optional[dict[OpaqueKey, base_t.JsonValue]] = None,
        offset: typing.Optional[typing.Optional[int]] = None,
        limit: typing.Optional[typing.Optional[int]] = None,
    ) -> list_entities_t.Data:
        """Uses a structured loading configuration to list entities in the system

        :param entity_type: The type of the entities requested, e.g. lab_request, recipe
        :param config_reference: The configuration reference name for the listing config
        :param attributes: Attributes to pass to the configuration for parameterizing filters
        :param offset: Used for pagination. Pagination is done based on the sorting of the config
        :param limit: The number of data points to return. If not filled in, it will be set to 100, and cannot be set higher than 100
        """
        args = list_entities_t.Arguments(
            entity_type=entity_type,
            config_reference=config_reference,
            attributes=attributes,
            offset=offset,
            limit=limit,
        )
        api_request = APIRequest(
            method=list_entities_t.ENDPOINT_METHOD,
            endpoint=list_entities_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=list_entities_t.Data)


    def resolve_entity_ids(
        self,
        *,
        entity_ids: list[typing.Union[str, base_t.ObjectId]],
        entity_type: entity_t.EntityType,
    ) -> resolve_entity_ids_t.Data:
        """Gets the names for passed in ids

        :param entity_ids: Ids of the entity to retrieve
        :param entity_type: The type of the entities requested
        """
        args = resolve_entity_ids_t.Arguments(
            entity_ids=entity_ids,
            entity_type=entity_type,
        )
        api_request = APIRequest(
            method=resolve_entity_ids_t.ENDPOINT_METHOD,
            endpoint=resolve_entity_ids_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=resolve_entity_ids_t.Data)


    def resolve_output_conditions(
        self,
        *,
        requested_conditions: list[resolve_output_conditions_t.ConditionRequest],
    ) -> resolve_output_conditions_t.Data:
        """For the provided set of condition parameter id and values, returns the existing or newly created output condition id for that value and id pair.

        """
        args = resolve_output_conditions_t.Arguments(
            requested_conditions=requested_conditions,
        )
        api_request = APIRequest(
            method=resolve_output_conditions_t.ENDPOINT_METHOD,
            endpoint=resolve_output_conditions_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=resolve_output_conditions_t.Data)


    def set_input_attribute_values(
        self,
        *,
        attribute_values: list[set_input_attribute_values_t.InputAttributeValue],
    ) -> set_input_attribute_values_t.Data:
        """Sets attribute values for an input

        :param attribute_values: The attributes of the input to set
        """
        args = set_input_attribute_values_t.Arguments(
            attribute_values=attribute_values,
        )
        api_request = APIRequest(
            method=set_input_attribute_values_t.ENDPOINT_METHOD,
            endpoint=set_input_attribute_values_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=set_input_attribute_values_t.Data)


    def set_recipe_inputs(
        self,
        *,
        input_data: list[set_recipe_inputs_t.RecipeInputValue],
    ) -> set_recipe_inputs_t.Data:
        """Sets inputs values for an experiment. Values set can be numeric, text or categorical types in the Uncountable system

        :param input_data: The inputs to set. Must be at most 100 entries long
        """
        args = set_recipe_inputs_t.Arguments(
            input_data=input_data,
        )
        api_request = APIRequest(
            method=set_recipe_inputs_t.ENDPOINT_METHOD,
            endpoint=set_recipe_inputs_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=set_recipe_inputs_t.Data)


    def set_recipe_metadata(
        self,
        *,
        recipe_key: identifier_t.IdentifierKey,
        recipe_metadata: list[recipe_metadata_t.MetadataValue],
    ) -> set_recipe_metadata_t.Data:
        """Set metadata values on a recipe

        :param recipe_key: Identifier for the recipe
        :param recipe_metadata: Metadata values to populate the recipe with
        """
        args = set_recipe_metadata_t.Arguments(
            recipe_key=recipe_key,
            recipe_metadata=recipe_metadata,
        )
        api_request = APIRequest(
            method=set_recipe_metadata_t.ENDPOINT_METHOD,
            endpoint=set_recipe_metadata_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=set_recipe_metadata_t.Data)


    def set_recipe_outputs(
        self,
        *,
        output_data: list[set_recipe_outputs_t.RecipeOutputValue],
    ) -> set_recipe_outputs_t.Data:
        """Sets output values for an experiment. Values set can be numeric, text or categorical types in the Uncountable system

        :param output_data: The outputs to set. Must be at most 100 entries long
        """
        args = set_recipe_outputs_t.Arguments(
            output_data=output_data,
        )
        api_request = APIRequest(
            method=set_recipe_outputs_t.ENDPOINT_METHOD,
            endpoint=set_recipe_outputs_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=set_recipe_outputs_t.Data)


    def set_values(
        self,
        *,
        entity: entity_t.Entity,
        values: list[field_values_t.ArgumentValueRefName],
    ) -> set_values_t.Data:
        """Sets field values for an entity

        """
        args = set_values_t.Arguments(
            entity=entity,
            values=values,
        )
        api_request = APIRequest(
            method=set_values_t.ENDPOINT_METHOD,
            endpoint=set_values_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=set_values_t.Data)
