import logging

# Configure basic logging for the library
logging.basicConfig(level=logging.INFO, format='%(asctime)s - %(name)s - %(levelname)s - %(message)s')

from .main import get_video_stream_url, get_video_info, get_available_qualities
from .providers.base import StreamQuality
from .exceptions import VideoFetcherError, VideoNotFoundError, ProviderAuthenticationError, StreamUnavailableError, UnsupportedQualityError, InvalidURLError
from .config import Config
