from dataclasses import dataclass
from typing import Dict, Optional

@dataclass
class Config:
    instagram_session_dir: str = "."
    timeout: int = 30  # Timeout for network requests in seconds
    proxies: Optional[Dict[str, str]] = None # {'http': 'http://user:pass@host:port', 'https': 'https://user:pass@host:port'}
    retries: int = 3   # Number of retries for failed network requests
    backoff_factor: float = 0.5 # Factor for exponential backoff between retries
