class VideoFetcherError(Exception):
    """Base exception for all errors in the VideoFetcher library."""
    pass

class VideoNotFoundError(VideoFetcherError):
    """Raised when a video cannot be found."""
    pass

class ProviderAuthenticationError(VideoFetcherError):
    """Raised when there's an authentication issue with a video provider."""
    pass

class StreamUnavailableError(VideoFetcherError):
    """Raised when a requested stream quality is not available."""
    pass

class UnsupportedQualityError(VideoFetcherError):
    """Raised when an unsupported quality is requested for a stream."""
    pass

class InvalidURLError(VideoFetcherError):
    """Raised when the provided URL is invalid or cannot be parsed."""
    pass
