from .provider_factory import VideoProviderFactory
from .providers.base import StreamQuality
from tubefetcherlib.config import Config
from typing import Dict, Any, List, Optional

def get_video_stream_url(video_url: str, quality: StreamQuality = StreamQuality.HIGHEST, instagram_username: str = None, instagram_password: str = None, config: Optional[Config] = None) -> str:
    if config is None:
        config = Config() # Use default config if not provided
    provider = VideoProviderFactory.get_provider(video_url, instagram_username=instagram_username, instagram_password=instagram_password, config=config)
    return provider.get_stream_url(video_url, quality)

def get_video_info(video_url: str, instagram_username: str = None, instagram_password: str = None, config: Optional[Config] = None) -> Dict[str, Any]:
    if config is None:
        config = Config() # Use default config if not provided
    provider = VideoProviderFactory.get_provider(video_url, instagram_username=instagram_username, instagram_password=instagram_password, config=config)
    return provider.get_video_info(video_url)

def get_available_qualities(video_url: str, instagram_username: str = None, instagram_password: str = None, config: Optional[Config] = None) -> List[StreamQuality]:
    if config is None:
        config = Config() # Use default config if not provided
    provider = VideoProviderFactory.get_provider(video_url, instagram_username=instagram_username, instagram_password=instagram_password, config=config)
    return provider.get_available_qualities(video_url)