import re
from .providers.youtube import YouTubeProvider
from .providers.instagram import InstagramProvider
from .providers.base import VideoProvider
from .config import Config
from tubefetcherlib.exceptions import InvalidURLError

def _is_youtube_url(url: str) -> bool:
    youtube_regex = r"^(https?://)?(www\.)?(youtube\.com|youtu\.be)/.+" # Simplified regex
    return re.match(youtube_regex, url) is not None

def _is_instagram_url(url: str) -> bool:
    instagram_regex = r"^(https?://)?(www\.)?(instagram\.com)/(p|reel|tv)/.+" # Simplified regex
    return re.match(instagram_regex, url) is not None

class VideoProviderFactory:
    @staticmethod
    def get_provider(url: str, instagram_username: str = None, instagram_password: str = None, config: Config = Config()) -> VideoProvider:
        if _is_youtube_url(url):
            return YouTubeProvider(config=config)
        elif _is_instagram_url(url):
            return InstagramProvider(username=instagram_username, password=instagram_password, config=config)
        else:
            raise InvalidURLError("Unsupported or invalid video URL for any known provider.")
