from abc import ABC, abstractmethod
from typing import Dict, Any, List
from enum import Enum

class StreamQuality(Enum):
    HIGHEST = "highest"
    LOWEST = "lowest"
    P1080 = "1080p"
    P720 = "720p"
    P480 = "480p"
    P360 = "360p"
    P240 = "240p"
    P144 = "144p"

class VideoProvider(ABC):
    @abstractmethod
    def get_stream_url(self, video_url: str, quality: StreamQuality = StreamQuality.HIGHEST) -> str:
        pass

    @abstractmethod
    def get_video_info(self, video_url: str) -> Dict[str, Any]:
        pass

    @abstractmethod
    def get_available_qualities(self, video_url: str) -> List[StreamQuality]:
        pass