import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AzurermProviderConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#auxiliary_tenant_ids AzurermProvider#auxiliary_tenant_ids}.
     *
     * @stability stable
     */
    readonly auxiliaryTenantIds?: string[];
    /**
     * The password associated with the Client Certificate. For use when authenticating as a Service Principal using a Client Certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#client_certificate_password AzurermProvider#client_certificate_password}
     *
     * @stability stable
     */
    readonly clientCertificatePassword?: string;
    /**
     * The path to the Client Certificate associated with the Service Principal for use when authenticating as a Service Principal using a Client Certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#client_certificate_path AzurermProvider#client_certificate_path}
     *
     * @stability stable
     */
    readonly clientCertificatePath?: string;
    /**
     * The Client ID which should be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#client_id AzurermProvider#client_id}
     *
     * @stability stable
     */
    readonly clientId?: string;
    /**
     * The Client Secret which should be used. For use When authenticating as a Service Principal using a Client Secret.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#client_secret AzurermProvider#client_secret}
     *
     * @stability stable
     */
    readonly clientSecret?: string;
    /**
     * This will disable the x-ms-correlation-request-id header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#disable_correlation_request_id AzurermProvider#disable_correlation_request_id}
     *
     * @stability stable
     */
    readonly disableCorrelationRequestId?: boolean | cdktf.IResolvable;
    /**
     * This will disable the Terraform Partner ID which is used if a custom `partner_id` isn't specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#disable_terraform_partner_id AzurermProvider#disable_terraform_partner_id}
     *
     * @stability stable
     */
    readonly disableTerraformPartnerId?: boolean | cdktf.IResolvable;
    /**
     * The Cloud Environment which should be used. Possible values are public, usgovernment, german, and china. Defaults to public.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#environment AzurermProvider#environment}
     *
     * @stability stable
     */
    readonly environment?: string;
    /**
     * The Hostname which should be used for the Azure Metadata Service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#metadata_host AzurermProvider#metadata_host}
     *
     * @stability stable
     */
    readonly metadataHost?: string;
    /**
     * Deprecated - replaced by `metadata_host`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#metadata_url AzurermProvider#metadata_url}
     *
     * @stability stable
     */
    readonly metadataUrl?: string;
    /**
     * The path to a custom endpoint for Managed Service Identity - in most circumstances this should be detected automatically.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#msi_endpoint AzurermProvider#msi_endpoint}
     *
     * @stability stable
     */
    readonly msiEndpoint?: string;
    /**
     * A GUID/UUID that is registered with Microsoft to facilitate partner resource usage attribution.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#partner_id AzurermProvider#partner_id}
     *
     * @stability stable
     */
    readonly partnerId?: string;
    /**
     * [DEPRECATED] This will cause the AzureRM Provider to skip verifying the credentials being used are valid.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#skip_credentials_validation AzurermProvider#skip_credentials_validation}
     *
     * @stability stable
     */
    readonly skipCredentialsValidation?: boolean | cdktf.IResolvable;
    /**
     * Should the AzureRM Provider skip registering all of the Resource Providers that it supports, if they're not already registered?
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#skip_provider_registration AzurermProvider#skip_provider_registration}
     *
     * @stability stable
     */
    readonly skipProviderRegistration?: boolean | cdktf.IResolvable;
    /**
     * Should the AzureRM Provider use AzureAD to access the Storage Data Plane API's?
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#storage_use_azuread AzurermProvider#storage_use_azuread}
     *
     * @stability stable
     */
    readonly storageUseAzuread?: boolean | cdktf.IResolvable;
    /**
     * The Subscription ID which should be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#subscription_id AzurermProvider#subscription_id}
     *
     * @stability stable
     */
    readonly subscriptionId?: string;
    /**
     * The Tenant ID which should be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#tenant_id AzurermProvider#tenant_id}
     *
     * @stability stable
     */
    readonly tenantId?: string;
    /**
     * Allowed Managed Service Identity be used for Authentication.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#use_msi AzurermProvider#use_msi}
     *
     * @stability stable
     */
    readonly useMsi?: boolean | cdktf.IResolvable;
    /**
     * Alias name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#alias AzurermProvider#alias}
     *
     * @stability stable
     */
    readonly alias?: string;
    /**
     * features block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#features AzurermProvider#features}
     *
     * @stability stable
     */
    readonly features: AzurermProviderFeatures;
}
/**
 * @stability stable
 */
export interface AzurermProviderFeaturesApiManagement {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#purge_soft_delete_on_destroy AzurermProvider#purge_soft_delete_on_destroy}.
     *
     * @stability stable
     */
    readonly purgeSoftDeleteOnDestroy?: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesApiManagementToTerraform(struct?: AzurermProviderFeaturesApiManagement): any;
/**
 * @stability stable
 */
export interface AzurermProviderFeaturesCognitiveAccount {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#purge_soft_delete_on_destroy AzurermProvider#purge_soft_delete_on_destroy}.
     *
     * @stability stable
     */
    readonly purgeSoftDeleteOnDestroy?: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesCognitiveAccountToTerraform(struct?: AzurermProviderFeaturesCognitiveAccount): any;
/**
 * @stability stable
 */
export interface AzurermProviderFeaturesKeyVault {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#purge_soft_delete_on_destroy AzurermProvider#purge_soft_delete_on_destroy}.
     *
     * @stability stable
     */
    readonly purgeSoftDeleteOnDestroy?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#recover_soft_deleted_key_vaults AzurermProvider#recover_soft_deleted_key_vaults}.
     *
     * @stability stable
     */
    readonly recoverSoftDeletedKeyVaults?: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesKeyVaultToTerraform(struct?: AzurermProviderFeaturesKeyVault): any;
/**
 * @stability stable
 */
export interface AzurermProviderFeaturesLogAnalyticsWorkspace {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#permanently_delete_on_destroy AzurermProvider#permanently_delete_on_destroy}.
     *
     * @stability stable
     */
    readonly permanentlyDeleteOnDestroy: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesLogAnalyticsWorkspaceToTerraform(struct?: AzurermProviderFeaturesLogAnalyticsWorkspace): any;
/**
 * @stability stable
 */
export interface AzurermProviderFeaturesNetwork {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#relaxed_locking AzurermProvider#relaxed_locking}.
     *
     * @stability stable
     */
    readonly relaxedLocking: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesNetworkToTerraform(struct?: AzurermProviderFeaturesNetwork): any;
/**
 * @stability stable
 */
export interface AzurermProviderFeaturesResourceGroup {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#prevent_deletion_if_contains_resources AzurermProvider#prevent_deletion_if_contains_resources}.
     *
     * @stability stable
     */
    readonly preventDeletionIfContainsResources?: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesResourceGroupToTerraform(struct?: AzurermProviderFeaturesResourceGroup): any;
/**
 * @stability stable
 */
export interface AzurermProviderFeaturesTemplateDeployment {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#delete_nested_items_during_deletion AzurermProvider#delete_nested_items_during_deletion}.
     *
     * @stability stable
     */
    readonly deleteNestedItemsDuringDeletion: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesTemplateDeploymentToTerraform(struct?: AzurermProviderFeaturesTemplateDeployment): any;
/**
 * @stability stable
 */
export interface AzurermProviderFeaturesVirtualMachine {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#delete_os_disk_on_deletion AzurermProvider#delete_os_disk_on_deletion}.
     *
     * @stability stable
     */
    readonly deleteOsDiskOnDeletion?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#graceful_shutdown AzurermProvider#graceful_shutdown}.
     *
     * @stability stable
     */
    readonly gracefulShutdown?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#skip_shutdown_and_force_delete AzurermProvider#skip_shutdown_and_force_delete}.
     *
     * @stability stable
     */
    readonly skipShutdownAndForceDelete?: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesVirtualMachineToTerraform(struct?: AzurermProviderFeaturesVirtualMachine): any;
/**
 * @stability stable
 */
export interface AzurermProviderFeaturesVirtualMachineScaleSet {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#force_delete AzurermProvider#force_delete}.
     *
     * @stability stable
     */
    readonly forceDelete?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#roll_instances_when_required AzurermProvider#roll_instances_when_required}.
     *
     * @stability stable
     */
    readonly rollInstancesWhenRequired: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#scale_to_zero_before_deletion AzurermProvider#scale_to_zero_before_deletion}.
     *
     * @stability stable
     */
    readonly scaleToZeroBeforeDeletion?: boolean | cdktf.IResolvable;
}
export declare function azurermProviderFeaturesVirtualMachineScaleSetToTerraform(struct?: AzurermProviderFeaturesVirtualMachineScaleSet): any;
/**
 * @stability stable
 */
export interface AzurermProviderFeatures {
    /**
     * api_management block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#api_management AzurermProvider#api_management}
     *
     * @stability stable
     */
    readonly apiManagement?: AzurermProviderFeaturesApiManagement;
    /**
     * cognitive_account block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#cognitive_account AzurermProvider#cognitive_account}
     *
     * @stability stable
     */
    readonly cognitiveAccount?: AzurermProviderFeaturesCognitiveAccount;
    /**
     * key_vault block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#key_vault AzurermProvider#key_vault}
     *
     * @stability stable
     */
    readonly keyVault?: AzurermProviderFeaturesKeyVault;
    /**
     * log_analytics_workspace block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#log_analytics_workspace AzurermProvider#log_analytics_workspace}
     *
     * @stability stable
     */
    readonly logAnalyticsWorkspace?: AzurermProviderFeaturesLogAnalyticsWorkspace;
    /**
     * network block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#network AzurermProvider#network}
     *
     * @stability stable
     */
    readonly network?: AzurermProviderFeaturesNetwork;
    /**
     * resource_group block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#resource_group AzurermProvider#resource_group}
     *
     * @stability stable
     */
    readonly resourceGroup?: AzurermProviderFeaturesResourceGroup;
    /**
     * template_deployment block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#template_deployment AzurermProvider#template_deployment}
     *
     * @stability stable
     */
    readonly templateDeployment?: AzurermProviderFeaturesTemplateDeployment;
    /**
     * virtual_machine block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#virtual_machine AzurermProvider#virtual_machine}
     *
     * @stability stable
     */
    readonly virtualMachine?: AzurermProviderFeaturesVirtualMachine;
    /**
     * virtual_machine_scale_set block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm#virtual_machine_scale_set AzurermProvider#virtual_machine_scale_set}
     *
     * @stability stable
     */
    readonly virtualMachineScaleSet?: AzurermProviderFeaturesVirtualMachineScaleSet;
}
export declare function azurermProviderFeaturesToTerraform(struct?: AzurermProviderFeatures): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm azurerm}.
 *
 * @stability stable
 */
export declare class AzurermProvider extends cdktf.TerraformProvider {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm azurerm} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AzurermProviderConfig);
    private _auxiliaryTenantIds?;
    /**
     * @stability stable
     */
    get auxiliaryTenantIds(): string[] | undefined;
    /**
     * @stability stable
     */
    set auxiliaryTenantIds(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetAuxiliaryTenantIds(): void;
    /**
     * @stability stable
     */
    get auxiliaryTenantIdsInput(): string[] | undefined;
    private _clientCertificatePassword?;
    /**
     * @stability stable
     */
    get clientCertificatePassword(): string | undefined;
    /**
     * @stability stable
     */
    set clientCertificatePassword(value: string | undefined);
    /**
     * @stability stable
     */
    resetClientCertificatePassword(): void;
    /**
     * @stability stable
     */
    get clientCertificatePasswordInput(): string | undefined;
    private _clientCertificatePath?;
    /**
     * @stability stable
     */
    get clientCertificatePath(): string | undefined;
    /**
     * @stability stable
     */
    set clientCertificatePath(value: string | undefined);
    /**
     * @stability stable
     */
    resetClientCertificatePath(): void;
    /**
     * @stability stable
     */
    get clientCertificatePathInput(): string | undefined;
    private _clientId?;
    /**
     * @stability stable
     */
    get clientId(): string | undefined;
    /**
     * @stability stable
     */
    set clientId(value: string | undefined);
    /**
     * @stability stable
     */
    resetClientId(): void;
    /**
     * @stability stable
     */
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    /**
     * @stability stable
     */
    get clientSecret(): string | undefined;
    /**
     * @stability stable
     */
    set clientSecret(value: string | undefined);
    /**
     * @stability stable
     */
    resetClientSecret(): void;
    /**
     * @stability stable
     */
    get clientSecretInput(): string | undefined;
    private _disableCorrelationRequestId?;
    /**
     * @stability stable
     */
    get disableCorrelationRequestId(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set disableCorrelationRequestId(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetDisableCorrelationRequestId(): void;
    /**
     * @stability stable
     */
    get disableCorrelationRequestIdInput(): boolean | cdktf.IResolvable | undefined;
    private _disableTerraformPartnerId?;
    /**
     * @stability stable
     */
    get disableTerraformPartnerId(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set disableTerraformPartnerId(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetDisableTerraformPartnerId(): void;
    /**
     * @stability stable
     */
    get disableTerraformPartnerIdInput(): boolean | cdktf.IResolvable | undefined;
    private _environment?;
    /**
     * @stability stable
     */
    get environment(): string | undefined;
    /**
     * @stability stable
     */
    set environment(value: string | undefined);
    /**
     * @stability stable
     */
    resetEnvironment(): void;
    /**
     * @stability stable
     */
    get environmentInput(): string | undefined;
    private _metadataHost?;
    /**
     * @stability stable
     */
    get metadataHost(): string | undefined;
    /**
     * @stability stable
     */
    set metadataHost(value: string | undefined);
    /**
     * @stability stable
     */
    resetMetadataHost(): void;
    /**
     * @stability stable
     */
    get metadataHostInput(): string | undefined;
    private _metadataUrl?;
    /**
     * @stability stable
     */
    get metadataUrl(): string | undefined;
    /**
     * @stability stable
     */
    set metadataUrl(value: string | undefined);
    /**
     * @stability stable
     */
    resetMetadataUrl(): void;
    /**
     * @stability stable
     */
    get metadataUrlInput(): string | undefined;
    private _msiEndpoint?;
    /**
     * @stability stable
     */
    get msiEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set msiEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetMsiEndpoint(): void;
    /**
     * @stability stable
     */
    get msiEndpointInput(): string | undefined;
    private _partnerId?;
    /**
     * @stability stable
     */
    get partnerId(): string | undefined;
    /**
     * @stability stable
     */
    set partnerId(value: string | undefined);
    /**
     * @stability stable
     */
    resetPartnerId(): void;
    /**
     * @stability stable
     */
    get partnerIdInput(): string | undefined;
    private _skipCredentialsValidation?;
    /**
     * @stability stable
     */
    get skipCredentialsValidation(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set skipCredentialsValidation(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetSkipCredentialsValidation(): void;
    /**
     * @stability stable
     */
    get skipCredentialsValidationInput(): boolean | cdktf.IResolvable | undefined;
    private _skipProviderRegistration?;
    /**
     * @stability stable
     */
    get skipProviderRegistration(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set skipProviderRegistration(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetSkipProviderRegistration(): void;
    /**
     * @stability stable
     */
    get skipProviderRegistrationInput(): boolean | cdktf.IResolvable | undefined;
    private _storageUseAzuread?;
    /**
     * @stability stable
     */
    get storageUseAzuread(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set storageUseAzuread(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetStorageUseAzuread(): void;
    /**
     * @stability stable
     */
    get storageUseAzureadInput(): boolean | cdktf.IResolvable | undefined;
    private _subscriptionId?;
    /**
     * @stability stable
     */
    get subscriptionId(): string | undefined;
    /**
     * @stability stable
     */
    set subscriptionId(value: string | undefined);
    /**
     * @stability stable
     */
    resetSubscriptionId(): void;
    /**
     * @stability stable
     */
    get subscriptionIdInput(): string | undefined;
    private _tenantId?;
    /**
     * @stability stable
     */
    get tenantId(): string | undefined;
    /**
     * @stability stable
     */
    set tenantId(value: string | undefined);
    /**
     * @stability stable
     */
    resetTenantId(): void;
    /**
     * @stability stable
     */
    get tenantIdInput(): string | undefined;
    private _useMsi?;
    /**
     * @stability stable
     */
    get useMsi(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set useMsi(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetUseMsi(): void;
    /**
     * @stability stable
     */
    get useMsiInput(): boolean | cdktf.IResolvable | undefined;
    private _alias?;
    /**
     * @stability stable
     */
    get alias(): string | undefined;
    /**
     * @stability stable
     */
    set alias(value: string | undefined);
    /**
     * @stability stable
     */
    resetAlias(): void;
    /**
     * @stability stable
     */
    get aliasInput(): string | undefined;
    private _features?;
    /**
     * @stability stable
     */
    get features(): AzurermProviderFeatures | undefined;
    /**
     * @stability stable
     */
    set features(value: AzurermProviderFeatures | undefined);
    /**
     * @stability stable
     */
    get featuresInput(): AzurermProviderFeatures | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
