import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface KubernetesClusterNodePoolConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#availability_zones KubernetesClusterNodePool#availability_zones}.
     *
     * @stability stable
     */
    readonly availabilityZones?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#enable_auto_scaling KubernetesClusterNodePool#enable_auto_scaling}.
     *
     * @stability stable
     */
    readonly enableAutoScaling?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#enable_host_encryption KubernetesClusterNodePool#enable_host_encryption}.
     *
     * @stability stable
     */
    readonly enableHostEncryption?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#enable_node_public_ip KubernetesClusterNodePool#enable_node_public_ip}.
     *
     * @stability stable
     */
    readonly enableNodePublicIp?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#eviction_policy KubernetesClusterNodePool#eviction_policy}.
     *
     * @stability stable
     */
    readonly evictionPolicy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#fips_enabled KubernetesClusterNodePool#fips_enabled}.
     *
     * @stability stable
     */
    readonly fipsEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#kubelet_disk_type KubernetesClusterNodePool#kubelet_disk_type}.
     *
     * @stability stable
     */
    readonly kubeletDiskType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#kubernetes_cluster_id KubernetesClusterNodePool#kubernetes_cluster_id}.
     *
     * @stability stable
     */
    readonly kubernetesClusterId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#max_count KubernetesClusterNodePool#max_count}.
     *
     * @stability stable
     */
    readonly maxCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#max_pods KubernetesClusterNodePool#max_pods}.
     *
     * @stability stable
     */
    readonly maxPods?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#min_count KubernetesClusterNodePool#min_count}.
     *
     * @stability stable
     */
    readonly minCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#mode KubernetesClusterNodePool#mode}.
     *
     * @stability stable
     */
    readonly mode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#name KubernetesClusterNodePool#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#node_count KubernetesClusterNodePool#node_count}.
     *
     * @stability stable
     */
    readonly nodeCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#node_labels KubernetesClusterNodePool#node_labels}.
     *
     * @stability stable
     */
    readonly nodeLabels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#node_public_ip_prefix_id KubernetesClusterNodePool#node_public_ip_prefix_id}.
     *
     * @stability stable
     */
    readonly nodePublicIpPrefixId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#node_taints KubernetesClusterNodePool#node_taints}.
     *
     * @stability stable
     */
    readonly nodeTaints?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#orchestrator_version KubernetesClusterNodePool#orchestrator_version}.
     *
     * @stability stable
     */
    readonly orchestratorVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#os_disk_size_gb KubernetesClusterNodePool#os_disk_size_gb}.
     *
     * @stability stable
     */
    readonly osDiskSizeGb?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#os_disk_type KubernetesClusterNodePool#os_disk_type}.
     *
     * @stability stable
     */
    readonly osDiskType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#os_sku KubernetesClusterNodePool#os_sku}.
     *
     * @stability stable
     */
    readonly osSku?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#os_type KubernetesClusterNodePool#os_type}.
     *
     * @stability stable
     */
    readonly osType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#pod_subnet_id KubernetesClusterNodePool#pod_subnet_id}.
     *
     * @stability stable
     */
    readonly podSubnetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#priority KubernetesClusterNodePool#priority}.
     *
     * @stability stable
     */
    readonly priority?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#proximity_placement_group_id KubernetesClusterNodePool#proximity_placement_group_id}.
     *
     * @stability stable
     */
    readonly proximityPlacementGroupId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#spot_max_price KubernetesClusterNodePool#spot_max_price}.
     *
     * @stability stable
     */
    readonly spotMaxPrice?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#tags KubernetesClusterNodePool#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#ultra_ssd_enabled KubernetesClusterNodePool#ultra_ssd_enabled}.
     *
     * @stability stable
     */
    readonly ultraSsdEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#vm_size KubernetesClusterNodePool#vm_size}.
     *
     * @stability stable
     */
    readonly vmSize: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#vnet_subnet_id KubernetesClusterNodePool#vnet_subnet_id}.
     *
     * @stability stable
     */
    readonly vnetSubnetId?: string;
    /**
     * kubelet_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#kubelet_config KubernetesClusterNodePool#kubelet_config}
     *
     * @stability stable
     */
    readonly kubeletConfig?: KubernetesClusterNodePoolKubeletConfig;
    /**
     * linux_os_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#linux_os_config KubernetesClusterNodePool#linux_os_config}
     *
     * @stability stable
     */
    readonly linuxOsConfig?: KubernetesClusterNodePoolLinuxOsConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#timeouts KubernetesClusterNodePool#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: KubernetesClusterNodePoolTimeouts;
    /**
     * upgrade_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#upgrade_settings KubernetesClusterNodePool#upgrade_settings}
     *
     * @stability stable
     */
    readonly upgradeSettings?: KubernetesClusterNodePoolUpgradeSettings;
}
/**
 * @stability stable
 */
export interface KubernetesClusterNodePoolKubeletConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#allowed_unsafe_sysctls KubernetesClusterNodePool#allowed_unsafe_sysctls}.
     *
     * @stability stable
     */
    readonly allowedUnsafeSysctls?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#container_log_max_line KubernetesClusterNodePool#container_log_max_line}.
     *
     * @stability stable
     */
    readonly containerLogMaxLine?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#container_log_max_size_mb KubernetesClusterNodePool#container_log_max_size_mb}.
     *
     * @stability stable
     */
    readonly containerLogMaxSizeMb?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#cpu_cfs_quota_enabled KubernetesClusterNodePool#cpu_cfs_quota_enabled}.
     *
     * @stability stable
     */
    readonly cpuCfsQuotaEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#cpu_cfs_quota_period KubernetesClusterNodePool#cpu_cfs_quota_period}.
     *
     * @stability stable
     */
    readonly cpuCfsQuotaPeriod?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#cpu_manager_policy KubernetesClusterNodePool#cpu_manager_policy}.
     *
     * @stability stable
     */
    readonly cpuManagerPolicy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#image_gc_high_threshold KubernetesClusterNodePool#image_gc_high_threshold}.
     *
     * @stability stable
     */
    readonly imageGcHighThreshold?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#image_gc_low_threshold KubernetesClusterNodePool#image_gc_low_threshold}.
     *
     * @stability stable
     */
    readonly imageGcLowThreshold?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#pod_max_pid KubernetesClusterNodePool#pod_max_pid}.
     *
     * @stability stable
     */
    readonly podMaxPid?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#topology_manager_policy KubernetesClusterNodePool#topology_manager_policy}.
     *
     * @stability stable
     */
    readonly topologyManagerPolicy?: string;
}
export declare function kubernetesClusterNodePoolKubeletConfigToTerraform(struct?: KubernetesClusterNodePoolKubeletConfigOutputReference | KubernetesClusterNodePoolKubeletConfig): any;
/**
 * @stability stable
 */
export declare class KubernetesClusterNodePoolKubeletConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KubernetesClusterNodePoolKubeletConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KubernetesClusterNodePoolKubeletConfig | undefined);
    private _allowedUnsafeSysctls?;
    /**
     * @stability stable
     */
    get allowedUnsafeSysctls(): string[];
    /**
     * @stability stable
     */
    set allowedUnsafeSysctls(value: string[]);
    /**
     * @stability stable
     */
    resetAllowedUnsafeSysctls(): void;
    /**
     * @stability stable
     */
    get allowedUnsafeSysctlsInput(): string[] | undefined;
    private _containerLogMaxLine?;
    /**
     * @stability stable
     */
    get containerLogMaxLine(): number;
    /**
     * @stability stable
     */
    set containerLogMaxLine(value: number);
    /**
     * @stability stable
     */
    resetContainerLogMaxLine(): void;
    /**
     * @stability stable
     */
    get containerLogMaxLineInput(): number | undefined;
    private _containerLogMaxSizeMb?;
    /**
     * @stability stable
     */
    get containerLogMaxSizeMb(): number;
    /**
     * @stability stable
     */
    set containerLogMaxSizeMb(value: number);
    /**
     * @stability stable
     */
    resetContainerLogMaxSizeMb(): void;
    /**
     * @stability stable
     */
    get containerLogMaxSizeMbInput(): number | undefined;
    private _cpuCfsQuotaEnabled?;
    /**
     * @stability stable
     */
    get cpuCfsQuotaEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set cpuCfsQuotaEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCpuCfsQuotaEnabled(): void;
    /**
     * @stability stable
     */
    get cpuCfsQuotaEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _cpuCfsQuotaPeriod?;
    /**
     * @stability stable
     */
    get cpuCfsQuotaPeriod(): string;
    /**
     * @stability stable
     */
    set cpuCfsQuotaPeriod(value: string);
    /**
     * @stability stable
     */
    resetCpuCfsQuotaPeriod(): void;
    /**
     * @stability stable
     */
    get cpuCfsQuotaPeriodInput(): string | undefined;
    private _cpuManagerPolicy?;
    /**
     * @stability stable
     */
    get cpuManagerPolicy(): string;
    /**
     * @stability stable
     */
    set cpuManagerPolicy(value: string);
    /**
     * @stability stable
     */
    resetCpuManagerPolicy(): void;
    /**
     * @stability stable
     */
    get cpuManagerPolicyInput(): string | undefined;
    private _imageGcHighThreshold?;
    /**
     * @stability stable
     */
    get imageGcHighThreshold(): number;
    /**
     * @stability stable
     */
    set imageGcHighThreshold(value: number);
    /**
     * @stability stable
     */
    resetImageGcHighThreshold(): void;
    /**
     * @stability stable
     */
    get imageGcHighThresholdInput(): number | undefined;
    private _imageGcLowThreshold?;
    /**
     * @stability stable
     */
    get imageGcLowThreshold(): number;
    /**
     * @stability stable
     */
    set imageGcLowThreshold(value: number);
    /**
     * @stability stable
     */
    resetImageGcLowThreshold(): void;
    /**
     * @stability stable
     */
    get imageGcLowThresholdInput(): number | undefined;
    private _podMaxPid?;
    /**
     * @stability stable
     */
    get podMaxPid(): number;
    /**
     * @stability stable
     */
    set podMaxPid(value: number);
    /**
     * @stability stable
     */
    resetPodMaxPid(): void;
    /**
     * @stability stable
     */
    get podMaxPidInput(): number | undefined;
    private _topologyManagerPolicy?;
    /**
     * @stability stable
     */
    get topologyManagerPolicy(): string;
    /**
     * @stability stable
     */
    set topologyManagerPolicy(value: string);
    /**
     * @stability stable
     */
    resetTopologyManagerPolicy(): void;
    /**
     * @stability stable
     */
    get topologyManagerPolicyInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface KubernetesClusterNodePoolLinuxOsConfigSysctlConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#fs_aio_max_nr KubernetesClusterNodePool#fs_aio_max_nr}.
     *
     * @stability stable
     */
    readonly fsAioMaxNr?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#fs_file_max KubernetesClusterNodePool#fs_file_max}.
     *
     * @stability stable
     */
    readonly fsFileMax?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#fs_inotify_max_user_watches KubernetesClusterNodePool#fs_inotify_max_user_watches}.
     *
     * @stability stable
     */
    readonly fsInotifyMaxUserWatches?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#fs_nr_open KubernetesClusterNodePool#fs_nr_open}.
     *
     * @stability stable
     */
    readonly fsNrOpen?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#kernel_threads_max KubernetesClusterNodePool#kernel_threads_max}.
     *
     * @stability stable
     */
    readonly kernelThreadsMax?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#net_core_netdev_max_backlog KubernetesClusterNodePool#net_core_netdev_max_backlog}.
     *
     * @stability stable
     */
    readonly netCoreNetdevMaxBacklog?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#net_core_optmem_max KubernetesClusterNodePool#net_core_optmem_max}.
     *
     * @stability stable
     */
    readonly netCoreOptmemMax?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#net_core_rmem_default KubernetesClusterNodePool#net_core_rmem_default}.
     *
     * @stability stable
     */
    readonly netCoreRmemDefault?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#net_core_rmem_max KubernetesClusterNodePool#net_core_rmem_max}.
     *
     * @stability stable
     */
    readonly netCoreRmemMax?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#net_core_somaxconn KubernetesClusterNodePool#net_core_somaxconn}.
     *
     * @stability stable
     */
    readonly netCoreSomaxconn?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#net_core_wmem_default KubernetesClusterNodePool#net_core_wmem_default}.
     *
     * @stability stable
     */
    readonly netCoreWmemDefault?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#net_core_wmem_max KubernetesClusterNodePool#net_core_wmem_max}.
     *
     * @stability stable
     */
    readonly netCoreWmemMax?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#net_ipv4_ip_local_port_range_max KubernetesClusterNodePool#net_ipv4_ip_local_port_range_max}.
     *
     * @stability stable
     */
    readonly netIpv4IpLocalPortRangeMax?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#net_ipv4_ip_local_port_range_min KubernetesClusterNodePool#net_ipv4_ip_local_port_range_min}.
     *
     * @stability stable
     */
    readonly netIpv4IpLocalPortRangeMin?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#net_ipv4_neigh_default_gc_thresh1 KubernetesClusterNodePool#net_ipv4_neigh_default_gc_thresh1}.
     *
     * @stability stable
     */
    readonly netIpv4NeighDefaultGcThresh1?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#net_ipv4_neigh_default_gc_thresh2 KubernetesClusterNodePool#net_ipv4_neigh_default_gc_thresh2}.
     *
     * @stability stable
     */
    readonly netIpv4NeighDefaultGcThresh2?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#net_ipv4_neigh_default_gc_thresh3 KubernetesClusterNodePool#net_ipv4_neigh_default_gc_thresh3}.
     *
     * @stability stable
     */
    readonly netIpv4NeighDefaultGcThresh3?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#net_ipv4_tcp_fin_timeout KubernetesClusterNodePool#net_ipv4_tcp_fin_timeout}.
     *
     * @stability stable
     */
    readonly netIpv4TcpFinTimeout?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#net_ipv4_tcp_keepalive_intvl KubernetesClusterNodePool#net_ipv4_tcp_keepalive_intvl}.
     *
     * @stability stable
     */
    readonly netIpv4TcpKeepaliveIntvl?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#net_ipv4_tcp_keepalive_probes KubernetesClusterNodePool#net_ipv4_tcp_keepalive_probes}.
     *
     * @stability stable
     */
    readonly netIpv4TcpKeepaliveProbes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#net_ipv4_tcp_keepalive_time KubernetesClusterNodePool#net_ipv4_tcp_keepalive_time}.
     *
     * @stability stable
     */
    readonly netIpv4TcpKeepaliveTime?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#net_ipv4_tcp_max_syn_backlog KubernetesClusterNodePool#net_ipv4_tcp_max_syn_backlog}.
     *
     * @stability stable
     */
    readonly netIpv4TcpMaxSynBacklog?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#net_ipv4_tcp_max_tw_buckets KubernetesClusterNodePool#net_ipv4_tcp_max_tw_buckets}.
     *
     * @stability stable
     */
    readonly netIpv4TcpMaxTwBuckets?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#net_ipv4_tcp_tw_reuse KubernetesClusterNodePool#net_ipv4_tcp_tw_reuse}.
     *
     * @stability stable
     */
    readonly netIpv4TcpTwReuse?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#net_netfilter_nf_conntrack_buckets KubernetesClusterNodePool#net_netfilter_nf_conntrack_buckets}.
     *
     * @stability stable
     */
    readonly netNetfilterNfConntrackBuckets?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#net_netfilter_nf_conntrack_max KubernetesClusterNodePool#net_netfilter_nf_conntrack_max}.
     *
     * @stability stable
     */
    readonly netNetfilterNfConntrackMax?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#vm_max_map_count KubernetesClusterNodePool#vm_max_map_count}.
     *
     * @stability stable
     */
    readonly vmMaxMapCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#vm_swappiness KubernetesClusterNodePool#vm_swappiness}.
     *
     * @stability stable
     */
    readonly vmSwappiness?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#vm_vfs_cache_pressure KubernetesClusterNodePool#vm_vfs_cache_pressure}.
     *
     * @stability stable
     */
    readonly vmVfsCachePressure?: number;
}
export declare function kubernetesClusterNodePoolLinuxOsConfigSysctlConfigToTerraform(struct?: KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference | KubernetesClusterNodePoolLinuxOsConfigSysctlConfig): any;
/**
 * @stability stable
 */
export declare class KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KubernetesClusterNodePoolLinuxOsConfigSysctlConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KubernetesClusterNodePoolLinuxOsConfigSysctlConfig | undefined);
    private _fsAioMaxNr?;
    /**
     * @stability stable
     */
    get fsAioMaxNr(): number;
    /**
     * @stability stable
     */
    set fsAioMaxNr(value: number);
    /**
     * @stability stable
     */
    resetFsAioMaxNr(): void;
    /**
     * @stability stable
     */
    get fsAioMaxNrInput(): number | undefined;
    private _fsFileMax?;
    /**
     * @stability stable
     */
    get fsFileMax(): number;
    /**
     * @stability stable
     */
    set fsFileMax(value: number);
    /**
     * @stability stable
     */
    resetFsFileMax(): void;
    /**
     * @stability stable
     */
    get fsFileMaxInput(): number | undefined;
    private _fsInotifyMaxUserWatches?;
    /**
     * @stability stable
     */
    get fsInotifyMaxUserWatches(): number;
    /**
     * @stability stable
     */
    set fsInotifyMaxUserWatches(value: number);
    /**
     * @stability stable
     */
    resetFsInotifyMaxUserWatches(): void;
    /**
     * @stability stable
     */
    get fsInotifyMaxUserWatchesInput(): number | undefined;
    private _fsNrOpen?;
    /**
     * @stability stable
     */
    get fsNrOpen(): number;
    /**
     * @stability stable
     */
    set fsNrOpen(value: number);
    /**
     * @stability stable
     */
    resetFsNrOpen(): void;
    /**
     * @stability stable
     */
    get fsNrOpenInput(): number | undefined;
    private _kernelThreadsMax?;
    /**
     * @stability stable
     */
    get kernelThreadsMax(): number;
    /**
     * @stability stable
     */
    set kernelThreadsMax(value: number);
    /**
     * @stability stable
     */
    resetKernelThreadsMax(): void;
    /**
     * @stability stable
     */
    get kernelThreadsMaxInput(): number | undefined;
    private _netCoreNetdevMaxBacklog?;
    /**
     * @stability stable
     */
    get netCoreNetdevMaxBacklog(): number;
    /**
     * @stability stable
     */
    set netCoreNetdevMaxBacklog(value: number);
    /**
     * @stability stable
     */
    resetNetCoreNetdevMaxBacklog(): void;
    /**
     * @stability stable
     */
    get netCoreNetdevMaxBacklogInput(): number | undefined;
    private _netCoreOptmemMax?;
    /**
     * @stability stable
     */
    get netCoreOptmemMax(): number;
    /**
     * @stability stable
     */
    set netCoreOptmemMax(value: number);
    /**
     * @stability stable
     */
    resetNetCoreOptmemMax(): void;
    /**
     * @stability stable
     */
    get netCoreOptmemMaxInput(): number | undefined;
    private _netCoreRmemDefault?;
    /**
     * @stability stable
     */
    get netCoreRmemDefault(): number;
    /**
     * @stability stable
     */
    set netCoreRmemDefault(value: number);
    /**
     * @stability stable
     */
    resetNetCoreRmemDefault(): void;
    /**
     * @stability stable
     */
    get netCoreRmemDefaultInput(): number | undefined;
    private _netCoreRmemMax?;
    /**
     * @stability stable
     */
    get netCoreRmemMax(): number;
    /**
     * @stability stable
     */
    set netCoreRmemMax(value: number);
    /**
     * @stability stable
     */
    resetNetCoreRmemMax(): void;
    /**
     * @stability stable
     */
    get netCoreRmemMaxInput(): number | undefined;
    private _netCoreSomaxconn?;
    /**
     * @stability stable
     */
    get netCoreSomaxconn(): number;
    /**
     * @stability stable
     */
    set netCoreSomaxconn(value: number);
    /**
     * @stability stable
     */
    resetNetCoreSomaxconn(): void;
    /**
     * @stability stable
     */
    get netCoreSomaxconnInput(): number | undefined;
    private _netCoreWmemDefault?;
    /**
     * @stability stable
     */
    get netCoreWmemDefault(): number;
    /**
     * @stability stable
     */
    set netCoreWmemDefault(value: number);
    /**
     * @stability stable
     */
    resetNetCoreWmemDefault(): void;
    /**
     * @stability stable
     */
    get netCoreWmemDefaultInput(): number | undefined;
    private _netCoreWmemMax?;
    /**
     * @stability stable
     */
    get netCoreWmemMax(): number;
    /**
     * @stability stable
     */
    set netCoreWmemMax(value: number);
    /**
     * @stability stable
     */
    resetNetCoreWmemMax(): void;
    /**
     * @stability stable
     */
    get netCoreWmemMaxInput(): number | undefined;
    private _netIpv4IpLocalPortRangeMax?;
    /**
     * @stability stable
     */
    get netIpv4IpLocalPortRangeMax(): number;
    /**
     * @stability stable
     */
    set netIpv4IpLocalPortRangeMax(value: number);
    /**
     * @stability stable
     */
    resetNetIpv4IpLocalPortRangeMax(): void;
    /**
     * @stability stable
     */
    get netIpv4IpLocalPortRangeMaxInput(): number | undefined;
    private _netIpv4IpLocalPortRangeMin?;
    /**
     * @stability stable
     */
    get netIpv4IpLocalPortRangeMin(): number;
    /**
     * @stability stable
     */
    set netIpv4IpLocalPortRangeMin(value: number);
    /**
     * @stability stable
     */
    resetNetIpv4IpLocalPortRangeMin(): void;
    /**
     * @stability stable
     */
    get netIpv4IpLocalPortRangeMinInput(): number | undefined;
    private _netIpv4NeighDefaultGcThresh1?;
    /**
     * @stability stable
     */
    get netIpv4NeighDefaultGcThresh1(): number;
    /**
     * @stability stable
     */
    set netIpv4NeighDefaultGcThresh1(value: number);
    /**
     * @stability stable
     */
    resetNetIpv4NeighDefaultGcThresh1(): void;
    /**
     * @stability stable
     */
    get netIpv4NeighDefaultGcThresh1Input(): number | undefined;
    private _netIpv4NeighDefaultGcThresh2?;
    /**
     * @stability stable
     */
    get netIpv4NeighDefaultGcThresh2(): number;
    /**
     * @stability stable
     */
    set netIpv4NeighDefaultGcThresh2(value: number);
    /**
     * @stability stable
     */
    resetNetIpv4NeighDefaultGcThresh2(): void;
    /**
     * @stability stable
     */
    get netIpv4NeighDefaultGcThresh2Input(): number | undefined;
    private _netIpv4NeighDefaultGcThresh3?;
    /**
     * @stability stable
     */
    get netIpv4NeighDefaultGcThresh3(): number;
    /**
     * @stability stable
     */
    set netIpv4NeighDefaultGcThresh3(value: number);
    /**
     * @stability stable
     */
    resetNetIpv4NeighDefaultGcThresh3(): void;
    /**
     * @stability stable
     */
    get netIpv4NeighDefaultGcThresh3Input(): number | undefined;
    private _netIpv4TcpFinTimeout?;
    /**
     * @stability stable
     */
    get netIpv4TcpFinTimeout(): number;
    /**
     * @stability stable
     */
    set netIpv4TcpFinTimeout(value: number);
    /**
     * @stability stable
     */
    resetNetIpv4TcpFinTimeout(): void;
    /**
     * @stability stable
     */
    get netIpv4TcpFinTimeoutInput(): number | undefined;
    private _netIpv4TcpKeepaliveIntvl?;
    /**
     * @stability stable
     */
    get netIpv4TcpKeepaliveIntvl(): number;
    /**
     * @stability stable
     */
    set netIpv4TcpKeepaliveIntvl(value: number);
    /**
     * @stability stable
     */
    resetNetIpv4TcpKeepaliveIntvl(): void;
    /**
     * @stability stable
     */
    get netIpv4TcpKeepaliveIntvlInput(): number | undefined;
    private _netIpv4TcpKeepaliveProbes?;
    /**
     * @stability stable
     */
    get netIpv4TcpKeepaliveProbes(): number;
    /**
     * @stability stable
     */
    set netIpv4TcpKeepaliveProbes(value: number);
    /**
     * @stability stable
     */
    resetNetIpv4TcpKeepaliveProbes(): void;
    /**
     * @stability stable
     */
    get netIpv4TcpKeepaliveProbesInput(): number | undefined;
    private _netIpv4TcpKeepaliveTime?;
    /**
     * @stability stable
     */
    get netIpv4TcpKeepaliveTime(): number;
    /**
     * @stability stable
     */
    set netIpv4TcpKeepaliveTime(value: number);
    /**
     * @stability stable
     */
    resetNetIpv4TcpKeepaliveTime(): void;
    /**
     * @stability stable
     */
    get netIpv4TcpKeepaliveTimeInput(): number | undefined;
    private _netIpv4TcpMaxSynBacklog?;
    /**
     * @stability stable
     */
    get netIpv4TcpMaxSynBacklog(): number;
    /**
     * @stability stable
     */
    set netIpv4TcpMaxSynBacklog(value: number);
    /**
     * @stability stable
     */
    resetNetIpv4TcpMaxSynBacklog(): void;
    /**
     * @stability stable
     */
    get netIpv4TcpMaxSynBacklogInput(): number | undefined;
    private _netIpv4TcpMaxTwBuckets?;
    /**
     * @stability stable
     */
    get netIpv4TcpMaxTwBuckets(): number;
    /**
     * @stability stable
     */
    set netIpv4TcpMaxTwBuckets(value: number);
    /**
     * @stability stable
     */
    resetNetIpv4TcpMaxTwBuckets(): void;
    /**
     * @stability stable
     */
    get netIpv4TcpMaxTwBucketsInput(): number | undefined;
    private _netIpv4TcpTwReuse?;
    /**
     * @stability stable
     */
    get netIpv4TcpTwReuse(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set netIpv4TcpTwReuse(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNetIpv4TcpTwReuse(): void;
    /**
     * @stability stable
     */
    get netIpv4TcpTwReuseInput(): boolean | cdktf.IResolvable | undefined;
    private _netNetfilterNfConntrackBuckets?;
    /**
     * @stability stable
     */
    get netNetfilterNfConntrackBuckets(): number;
    /**
     * @stability stable
     */
    set netNetfilterNfConntrackBuckets(value: number);
    /**
     * @stability stable
     */
    resetNetNetfilterNfConntrackBuckets(): void;
    /**
     * @stability stable
     */
    get netNetfilterNfConntrackBucketsInput(): number | undefined;
    private _netNetfilterNfConntrackMax?;
    /**
     * @stability stable
     */
    get netNetfilterNfConntrackMax(): number;
    /**
     * @stability stable
     */
    set netNetfilterNfConntrackMax(value: number);
    /**
     * @stability stable
     */
    resetNetNetfilterNfConntrackMax(): void;
    /**
     * @stability stable
     */
    get netNetfilterNfConntrackMaxInput(): number | undefined;
    private _vmMaxMapCount?;
    /**
     * @stability stable
     */
    get vmMaxMapCount(): number;
    /**
     * @stability stable
     */
    set vmMaxMapCount(value: number);
    /**
     * @stability stable
     */
    resetVmMaxMapCount(): void;
    /**
     * @stability stable
     */
    get vmMaxMapCountInput(): number | undefined;
    private _vmSwappiness?;
    /**
     * @stability stable
     */
    get vmSwappiness(): number;
    /**
     * @stability stable
     */
    set vmSwappiness(value: number);
    /**
     * @stability stable
     */
    resetVmSwappiness(): void;
    /**
     * @stability stable
     */
    get vmSwappinessInput(): number | undefined;
    private _vmVfsCachePressure?;
    /**
     * @stability stable
     */
    get vmVfsCachePressure(): number;
    /**
     * @stability stable
     */
    set vmVfsCachePressure(value: number);
    /**
     * @stability stable
     */
    resetVmVfsCachePressure(): void;
    /**
     * @stability stable
     */
    get vmVfsCachePressureInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface KubernetesClusterNodePoolLinuxOsConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#swap_file_size_mb KubernetesClusterNodePool#swap_file_size_mb}.
     *
     * @stability stable
     */
    readonly swapFileSizeMb?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#transparent_huge_page_defrag KubernetesClusterNodePool#transparent_huge_page_defrag}.
     *
     * @stability stable
     */
    readonly transparentHugePageDefrag?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#transparent_huge_page_enabled KubernetesClusterNodePool#transparent_huge_page_enabled}.
     *
     * @stability stable
     */
    readonly transparentHugePageEnabled?: string;
    /**
     * sysctl_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#sysctl_config KubernetesClusterNodePool#sysctl_config}
     *
     * @stability stable
     */
    readonly sysctlConfig?: KubernetesClusterNodePoolLinuxOsConfigSysctlConfig;
}
export declare function kubernetesClusterNodePoolLinuxOsConfigToTerraform(struct?: KubernetesClusterNodePoolLinuxOsConfigOutputReference | KubernetesClusterNodePoolLinuxOsConfig): any;
/**
 * @stability stable
 */
export declare class KubernetesClusterNodePoolLinuxOsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KubernetesClusterNodePoolLinuxOsConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KubernetesClusterNodePoolLinuxOsConfig | undefined);
    private _swapFileSizeMb?;
    /**
     * @stability stable
     */
    get swapFileSizeMb(): number;
    /**
     * @stability stable
     */
    set swapFileSizeMb(value: number);
    /**
     * @stability stable
     */
    resetSwapFileSizeMb(): void;
    /**
     * @stability stable
     */
    get swapFileSizeMbInput(): number | undefined;
    private _transparentHugePageDefrag?;
    /**
     * @stability stable
     */
    get transparentHugePageDefrag(): string;
    /**
     * @stability stable
     */
    set transparentHugePageDefrag(value: string);
    /**
     * @stability stable
     */
    resetTransparentHugePageDefrag(): void;
    /**
     * @stability stable
     */
    get transparentHugePageDefragInput(): string | undefined;
    private _transparentHugePageEnabled?;
    /**
     * @stability stable
     */
    get transparentHugePageEnabled(): string;
    /**
     * @stability stable
     */
    set transparentHugePageEnabled(value: string);
    /**
     * @stability stable
     */
    resetTransparentHugePageEnabled(): void;
    /**
     * @stability stable
     */
    get transparentHugePageEnabledInput(): string | undefined;
    private _sysctlConfig;
    /**
     * @stability stable
     */
    get sysctlConfig(): KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference;
    /**
     * @stability stable
     */
    putSysctlConfig(value: KubernetesClusterNodePoolLinuxOsConfigSysctlConfig): void;
    /**
     * @stability stable
     */
    resetSysctlConfig(): void;
    /**
     * @stability stable
     */
    get sysctlConfigInput(): KubernetesClusterNodePoolLinuxOsConfigSysctlConfig | undefined;
}
/**
 * @stability stable
 */
export interface KubernetesClusterNodePoolTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#create KubernetesClusterNodePool#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#delete KubernetesClusterNodePool#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#read KubernetesClusterNodePool#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#update KubernetesClusterNodePool#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function kubernetesClusterNodePoolTimeoutsToTerraform(struct?: KubernetesClusterNodePoolTimeoutsOutputReference | KubernetesClusterNodePoolTimeouts): any;
/**
 * @stability stable
 */
export declare class KubernetesClusterNodePoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KubernetesClusterNodePoolTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KubernetesClusterNodePoolTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface KubernetesClusterNodePoolUpgradeSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html#max_surge KubernetesClusterNodePool#max_surge}.
     *
     * @stability stable
     */
    readonly maxSurge: string;
}
export declare function kubernetesClusterNodePoolUpgradeSettingsToTerraform(struct?: KubernetesClusterNodePoolUpgradeSettingsOutputReference | KubernetesClusterNodePoolUpgradeSettings): any;
/**
 * @stability stable
 */
export declare class KubernetesClusterNodePoolUpgradeSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KubernetesClusterNodePoolUpgradeSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KubernetesClusterNodePoolUpgradeSettings | undefined);
    private _maxSurge?;
    /**
     * @stability stable
     */
    get maxSurge(): string;
    /**
     * @stability stable
     */
    set maxSurge(value: string);
    /**
     * @stability stable
     */
    get maxSurgeInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html azurerm_kubernetes_cluster_node_pool}.
 *
 * @stability stable
 */
export declare class KubernetesClusterNodePool extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html azurerm_kubernetes_cluster_node_pool} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: KubernetesClusterNodePoolConfig);
    private _availabilityZones?;
    /**
     * @stability stable
     */
    get availabilityZones(): string[];
    /**
     * @stability stable
     */
    set availabilityZones(value: string[]);
    /**
     * @stability stable
     */
    resetAvailabilityZones(): void;
    /**
     * @stability stable
     */
    get availabilityZonesInput(): string[] | undefined;
    private _enableAutoScaling?;
    /**
     * @stability stable
     */
    get enableAutoScaling(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableAutoScaling(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableAutoScaling(): void;
    /**
     * @stability stable
     */
    get enableAutoScalingInput(): boolean | cdktf.IResolvable | undefined;
    private _enableHostEncryption?;
    /**
     * @stability stable
     */
    get enableHostEncryption(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableHostEncryption(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableHostEncryption(): void;
    /**
     * @stability stable
     */
    get enableHostEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _enableNodePublicIp?;
    /**
     * @stability stable
     */
    get enableNodePublicIp(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableNodePublicIp(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableNodePublicIp(): void;
    /**
     * @stability stable
     */
    get enableNodePublicIpInput(): boolean | cdktf.IResolvable | undefined;
    private _evictionPolicy?;
    /**
     * @stability stable
     */
    get evictionPolicy(): string;
    /**
     * @stability stable
     */
    set evictionPolicy(value: string);
    /**
     * @stability stable
     */
    resetEvictionPolicy(): void;
    /**
     * @stability stable
     */
    get evictionPolicyInput(): string | undefined;
    private _fipsEnabled?;
    /**
     * @stability stable
     */
    get fipsEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set fipsEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetFipsEnabled(): void;
    /**
     * @stability stable
     */
    get fipsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _kubeletDiskType?;
    /**
     * @stability stable
     */
    get kubeletDiskType(): string;
    /**
     * @stability stable
     */
    set kubeletDiskType(value: string);
    /**
     * @stability stable
     */
    resetKubeletDiskType(): void;
    /**
     * @stability stable
     */
    get kubeletDiskTypeInput(): string | undefined;
    private _kubernetesClusterId?;
    /**
     * @stability stable
     */
    get kubernetesClusterId(): string;
    /**
     * @stability stable
     */
    set kubernetesClusterId(value: string);
    /**
     * @stability stable
     */
    get kubernetesClusterIdInput(): string | undefined;
    private _maxCount?;
    /**
     * @stability stable
     */
    get maxCount(): number;
    /**
     * @stability stable
     */
    set maxCount(value: number);
    /**
     * @stability stable
     */
    resetMaxCount(): void;
    /**
     * @stability stable
     */
    get maxCountInput(): number | undefined;
    private _maxPods?;
    /**
     * @stability stable
     */
    get maxPods(): number;
    /**
     * @stability stable
     */
    set maxPods(value: number);
    /**
     * @stability stable
     */
    resetMaxPods(): void;
    /**
     * @stability stable
     */
    get maxPodsInput(): number | undefined;
    private _minCount?;
    /**
     * @stability stable
     */
    get minCount(): number;
    /**
     * @stability stable
     */
    set minCount(value: number);
    /**
     * @stability stable
     */
    resetMinCount(): void;
    /**
     * @stability stable
     */
    get minCountInput(): number | undefined;
    private _mode?;
    /**
     * @stability stable
     */
    get mode(): string;
    /**
     * @stability stable
     */
    set mode(value: string);
    /**
     * @stability stable
     */
    resetMode(): void;
    /**
     * @stability stable
     */
    get modeInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _nodeCount?;
    /**
     * @stability stable
     */
    get nodeCount(): number;
    /**
     * @stability stable
     */
    set nodeCount(value: number);
    /**
     * @stability stable
     */
    resetNodeCount(): void;
    /**
     * @stability stable
     */
    get nodeCountInput(): number | undefined;
    private _nodeLabels?;
    /**
     * @stability stable
     */
    get nodeLabels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set nodeLabels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNodeLabels(): void;
    /**
     * @stability stable
     */
    get nodeLabelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _nodePublicIpPrefixId?;
    /**
     * @stability stable
     */
    get nodePublicIpPrefixId(): string;
    /**
     * @stability stable
     */
    set nodePublicIpPrefixId(value: string);
    /**
     * @stability stable
     */
    resetNodePublicIpPrefixId(): void;
    /**
     * @stability stable
     */
    get nodePublicIpPrefixIdInput(): string | undefined;
    private _nodeTaints?;
    /**
     * @stability stable
     */
    get nodeTaints(): string[];
    /**
     * @stability stable
     */
    set nodeTaints(value: string[]);
    /**
     * @stability stable
     */
    resetNodeTaints(): void;
    /**
     * @stability stable
     */
    get nodeTaintsInput(): string[] | undefined;
    private _orchestratorVersion?;
    /**
     * @stability stable
     */
    get orchestratorVersion(): string;
    /**
     * @stability stable
     */
    set orchestratorVersion(value: string);
    /**
     * @stability stable
     */
    resetOrchestratorVersion(): void;
    /**
     * @stability stable
     */
    get orchestratorVersionInput(): string | undefined;
    private _osDiskSizeGb?;
    /**
     * @stability stable
     */
    get osDiskSizeGb(): number;
    /**
     * @stability stable
     */
    set osDiskSizeGb(value: number);
    /**
     * @stability stable
     */
    resetOsDiskSizeGb(): void;
    /**
     * @stability stable
     */
    get osDiskSizeGbInput(): number | undefined;
    private _osDiskType?;
    /**
     * @stability stable
     */
    get osDiskType(): string;
    /**
     * @stability stable
     */
    set osDiskType(value: string);
    /**
     * @stability stable
     */
    resetOsDiskType(): void;
    /**
     * @stability stable
     */
    get osDiskTypeInput(): string | undefined;
    private _osSku?;
    /**
     * @stability stable
     */
    get osSku(): string;
    /**
     * @stability stable
     */
    set osSku(value: string);
    /**
     * @stability stable
     */
    resetOsSku(): void;
    /**
     * @stability stable
     */
    get osSkuInput(): string | undefined;
    private _osType?;
    /**
     * @stability stable
     */
    get osType(): string;
    /**
     * @stability stable
     */
    set osType(value: string);
    /**
     * @stability stable
     */
    resetOsType(): void;
    /**
     * @stability stable
     */
    get osTypeInput(): string | undefined;
    private _podSubnetId?;
    /**
     * @stability stable
     */
    get podSubnetId(): string;
    /**
     * @stability stable
     */
    set podSubnetId(value: string);
    /**
     * @stability stable
     */
    resetPodSubnetId(): void;
    /**
     * @stability stable
     */
    get podSubnetIdInput(): string | undefined;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): string;
    /**
     * @stability stable
     */
    set priority(value: string);
    /**
     * @stability stable
     */
    resetPriority(): void;
    /**
     * @stability stable
     */
    get priorityInput(): string | undefined;
    private _proximityPlacementGroupId?;
    /**
     * @stability stable
     */
    get proximityPlacementGroupId(): string;
    /**
     * @stability stable
     */
    set proximityPlacementGroupId(value: string);
    /**
     * @stability stable
     */
    resetProximityPlacementGroupId(): void;
    /**
     * @stability stable
     */
    get proximityPlacementGroupIdInput(): string | undefined;
    private _spotMaxPrice?;
    /**
     * @stability stable
     */
    get spotMaxPrice(): number;
    /**
     * @stability stable
     */
    set spotMaxPrice(value: number);
    /**
     * @stability stable
     */
    resetSpotMaxPrice(): void;
    /**
     * @stability stable
     */
    get spotMaxPriceInput(): number | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _ultraSsdEnabled?;
    /**
     * @stability stable
     */
    get ultraSsdEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set ultraSsdEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetUltraSsdEnabled(): void;
    /**
     * @stability stable
     */
    get ultraSsdEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _vmSize?;
    /**
     * @stability stable
     */
    get vmSize(): string;
    /**
     * @stability stable
     */
    set vmSize(value: string);
    /**
     * @stability stable
     */
    get vmSizeInput(): string | undefined;
    private _vnetSubnetId?;
    /**
     * @stability stable
     */
    get vnetSubnetId(): string;
    /**
     * @stability stable
     */
    set vnetSubnetId(value: string);
    /**
     * @stability stable
     */
    resetVnetSubnetId(): void;
    /**
     * @stability stable
     */
    get vnetSubnetIdInput(): string | undefined;
    private _kubeletConfig;
    /**
     * @stability stable
     */
    get kubeletConfig(): KubernetesClusterNodePoolKubeletConfigOutputReference;
    /**
     * @stability stable
     */
    putKubeletConfig(value: KubernetesClusterNodePoolKubeletConfig): void;
    /**
     * @stability stable
     */
    resetKubeletConfig(): void;
    /**
     * @stability stable
     */
    get kubeletConfigInput(): KubernetesClusterNodePoolKubeletConfig | undefined;
    private _linuxOsConfig;
    /**
     * @stability stable
     */
    get linuxOsConfig(): KubernetesClusterNodePoolLinuxOsConfigOutputReference;
    /**
     * @stability stable
     */
    putLinuxOsConfig(value: KubernetesClusterNodePoolLinuxOsConfig): void;
    /**
     * @stability stable
     */
    resetLinuxOsConfig(): void;
    /**
     * @stability stable
     */
    get linuxOsConfigInput(): KubernetesClusterNodePoolLinuxOsConfig | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): KubernetesClusterNodePoolTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: KubernetesClusterNodePoolTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): KubernetesClusterNodePoolTimeouts | undefined;
    private _upgradeSettings;
    /**
     * @stability stable
     */
    get upgradeSettings(): KubernetesClusterNodePoolUpgradeSettingsOutputReference;
    /**
     * @stability stable
     */
    putUpgradeSettings(value: KubernetesClusterNodePoolUpgradeSettings): void;
    /**
     * @stability stable
     */
    resetUpgradeSettings(): void;
    /**
     * @stability stable
     */
    get upgradeSettingsInput(): KubernetesClusterNodePoolUpgradeSettings | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
