import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MonitorActivityLogAlertConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert.html#description MonitorActivityLogAlert#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert.html#enabled MonitorActivityLogAlert#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert.html#name MonitorActivityLogAlert#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert.html#resource_group_name MonitorActivityLogAlert#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert.html#scopes MonitorActivityLogAlert#scopes}.
     *
     * @stability stable
     */
    readonly scopes: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert.html#tags MonitorActivityLogAlert#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert.html#action MonitorActivityLogAlert#action}
     *
     * @stability stable
     */
    readonly action?: MonitorActivityLogAlertAction[];
    /**
     * criteria block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert.html#criteria MonitorActivityLogAlert#criteria}
     *
     * @stability stable
     */
    readonly criteria: MonitorActivityLogAlertCriteria;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert.html#timeouts MonitorActivityLogAlert#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MonitorActivityLogAlertTimeouts;
}
/**
 * @stability stable
 */
export interface MonitorActivityLogAlertAction {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert.html#action_group_id MonitorActivityLogAlert#action_group_id}.
     *
     * @stability stable
     */
    readonly actionGroupId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert.html#webhook_properties MonitorActivityLogAlert#webhook_properties}.
     *
     * @stability stable
     */
    readonly webhookProperties?: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
export declare function monitorActivityLogAlertActionToTerraform(struct?: MonitorActivityLogAlertAction): any;
/**
 * @stability stable
 */
export interface MonitorActivityLogAlertCriteriaServiceHealth {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert.html#events MonitorActivityLogAlert#events}.
     *
     * @stability stable
     */
    readonly events?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert.html#locations MonitorActivityLogAlert#locations}.
     *
     * @stability stable
     */
    readonly locations?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert.html#services MonitorActivityLogAlert#services}.
     *
     * @stability stable
     */
    readonly services?: string[];
}
export declare function monitorActivityLogAlertCriteriaServiceHealthToTerraform(struct?: MonitorActivityLogAlertCriteriaServiceHealth): any;
/**
 * @stability stable
 */
export interface MonitorActivityLogAlertCriteria {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert.html#caller MonitorActivityLogAlert#caller}.
     *
     * @stability stable
     */
    readonly caller?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert.html#category MonitorActivityLogAlert#category}.
     *
     * @stability stable
     */
    readonly category: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert.html#level MonitorActivityLogAlert#level}.
     *
     * @stability stable
     */
    readonly level?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert.html#operation_name MonitorActivityLogAlert#operation_name}.
     *
     * @stability stable
     */
    readonly operationName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert.html#recommendation_category MonitorActivityLogAlert#recommendation_category}.
     *
     * @stability stable
     */
    readonly recommendationCategory?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert.html#recommendation_impact MonitorActivityLogAlert#recommendation_impact}.
     *
     * @stability stable
     */
    readonly recommendationImpact?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert.html#recommendation_type MonitorActivityLogAlert#recommendation_type}.
     *
     * @stability stable
     */
    readonly recommendationType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert.html#resource_group MonitorActivityLogAlert#resource_group}.
     *
     * @stability stable
     */
    readonly resourceGroup?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert.html#resource_id MonitorActivityLogAlert#resource_id}.
     *
     * @stability stable
     */
    readonly resourceId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert.html#resource_provider MonitorActivityLogAlert#resource_provider}.
     *
     * @stability stable
     */
    readonly resourceProvider?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert.html#resource_type MonitorActivityLogAlert#resource_type}.
     *
     * @stability stable
     */
    readonly resourceType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert.html#status MonitorActivityLogAlert#status}.
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert.html#sub_status MonitorActivityLogAlert#sub_status}.
     *
     * @stability stable
     */
    readonly subStatus?: string;
    /**
     * service_health block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert.html#service_health MonitorActivityLogAlert#service_health}
     *
     * @stability stable
     */
    readonly serviceHealth?: MonitorActivityLogAlertCriteriaServiceHealth[];
}
export declare function monitorActivityLogAlertCriteriaToTerraform(struct?: MonitorActivityLogAlertCriteriaOutputReference | MonitorActivityLogAlertCriteria): any;
/**
 * @stability stable
 */
export declare class MonitorActivityLogAlertCriteriaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorActivityLogAlertCriteria | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorActivityLogAlertCriteria | undefined);
    private _caller?;
    /**
     * @stability stable
     */
    get caller(): string;
    /**
     * @stability stable
     */
    set caller(value: string);
    /**
     * @stability stable
     */
    resetCaller(): void;
    /**
     * @stability stable
     */
    get callerInput(): string | undefined;
    private _category?;
    /**
     * @stability stable
     */
    get category(): string;
    /**
     * @stability stable
     */
    set category(value: string);
    /**
     * @stability stable
     */
    get categoryInput(): string | undefined;
    private _level?;
    /**
     * @stability stable
     */
    get level(): string;
    /**
     * @stability stable
     */
    set level(value: string);
    /**
     * @stability stable
     */
    resetLevel(): void;
    /**
     * @stability stable
     */
    get levelInput(): string | undefined;
    private _operationName?;
    /**
     * @stability stable
     */
    get operationName(): string;
    /**
     * @stability stable
     */
    set operationName(value: string);
    /**
     * @stability stable
     */
    resetOperationName(): void;
    /**
     * @stability stable
     */
    get operationNameInput(): string | undefined;
    private _recommendationCategory?;
    /**
     * @stability stable
     */
    get recommendationCategory(): string;
    /**
     * @stability stable
     */
    set recommendationCategory(value: string);
    /**
     * @stability stable
     */
    resetRecommendationCategory(): void;
    /**
     * @stability stable
     */
    get recommendationCategoryInput(): string | undefined;
    private _recommendationImpact?;
    /**
     * @stability stable
     */
    get recommendationImpact(): string;
    /**
     * @stability stable
     */
    set recommendationImpact(value: string);
    /**
     * @stability stable
     */
    resetRecommendationImpact(): void;
    /**
     * @stability stable
     */
    get recommendationImpactInput(): string | undefined;
    private _recommendationType?;
    /**
     * @stability stable
     */
    get recommendationType(): string;
    /**
     * @stability stable
     */
    set recommendationType(value: string);
    /**
     * @stability stable
     */
    resetRecommendationType(): void;
    /**
     * @stability stable
     */
    get recommendationTypeInput(): string | undefined;
    private _resourceGroup?;
    /**
     * @stability stable
     */
    get resourceGroup(): string;
    /**
     * @stability stable
     */
    set resourceGroup(value: string);
    /**
     * @stability stable
     */
    resetResourceGroup(): void;
    /**
     * @stability stable
     */
    get resourceGroupInput(): string | undefined;
    private _resourceId?;
    /**
     * @stability stable
     */
    get resourceId(): string;
    /**
     * @stability stable
     */
    set resourceId(value: string);
    /**
     * @stability stable
     */
    resetResourceId(): void;
    /**
     * @stability stable
     */
    get resourceIdInput(): string | undefined;
    private _resourceProvider?;
    /**
     * @stability stable
     */
    get resourceProvider(): string;
    /**
     * @stability stable
     */
    set resourceProvider(value: string);
    /**
     * @stability stable
     */
    resetResourceProvider(): void;
    /**
     * @stability stable
     */
    get resourceProviderInput(): string | undefined;
    private _resourceType?;
    /**
     * @stability stable
     */
    get resourceType(): string;
    /**
     * @stability stable
     */
    set resourceType(value: string);
    /**
     * @stability stable
     */
    resetResourceType(): void;
    /**
     * @stability stable
     */
    get resourceTypeInput(): string | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _subStatus?;
    /**
     * @stability stable
     */
    get subStatus(): string;
    /**
     * @stability stable
     */
    set subStatus(value: string);
    /**
     * @stability stable
     */
    resetSubStatus(): void;
    /**
     * @stability stable
     */
    get subStatusInput(): string | undefined;
    private _serviceHealth?;
    /**
     * @stability stable
     */
    get serviceHealth(): MonitorActivityLogAlertCriteriaServiceHealth[];
    /**
     * @stability stable
     */
    set serviceHealth(value: MonitorActivityLogAlertCriteriaServiceHealth[]);
    /**
     * @stability stable
     */
    resetServiceHealth(): void;
    /**
     * @stability stable
     */
    get serviceHealthInput(): MonitorActivityLogAlertCriteriaServiceHealth[] | undefined;
}
/**
 * @stability stable
 */
export interface MonitorActivityLogAlertTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert.html#create MonitorActivityLogAlert#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert.html#delete MonitorActivityLogAlert#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert.html#read MonitorActivityLogAlert#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert.html#update MonitorActivityLogAlert#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function monitorActivityLogAlertTimeoutsToTerraform(struct?: MonitorActivityLogAlertTimeoutsOutputReference | MonitorActivityLogAlertTimeouts): any;
/**
 * @stability stable
 */
export declare class MonitorActivityLogAlertTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorActivityLogAlertTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorActivityLogAlertTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert.html azurerm_monitor_activity_log_alert}.
 *
 * @stability stable
 */
export declare class MonitorActivityLogAlert extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_activity_log_alert.html azurerm_monitor_activity_log_alert} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MonitorActivityLogAlertConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _scopes?;
    /**
     * @stability stable
     */
    get scopes(): string[];
    /**
     * @stability stable
     */
    set scopes(value: string[]);
    /**
     * @stability stable
     */
    get scopesInput(): string[] | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _action?;
    /**
     * @stability stable
     */
    get action(): MonitorActivityLogAlertAction[];
    /**
     * @stability stable
     */
    set action(value: MonitorActivityLogAlertAction[]);
    /**
     * @stability stable
     */
    resetAction(): void;
    /**
     * @stability stable
     */
    get actionInput(): MonitorActivityLogAlertAction[] | undefined;
    private _criteria;
    /**
     * @stability stable
     */
    get criteria(): MonitorActivityLogAlertCriteriaOutputReference;
    /**
     * @stability stable
     */
    putCriteria(value: MonitorActivityLogAlertCriteria): void;
    /**
     * @stability stable
     */
    get criteriaInput(): MonitorActivityLogAlertCriteria | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MonitorActivityLogAlertTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MonitorActivityLogAlertTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MonitorActivityLogAlertTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
