import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface StorageDataLakeGen2PathConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path.html#filesystem_name StorageDataLakeGen2Path#filesystem_name}.
     *
     * @stability stable
     */
    readonly filesystemName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path.html#group StorageDataLakeGen2Path#group}.
     *
     * @stability stable
     */
    readonly group?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path.html#owner StorageDataLakeGen2Path#owner}.
     *
     * @stability stable
     */
    readonly owner?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path.html#path StorageDataLakeGen2Path#path}.
     *
     * @stability stable
     */
    readonly path: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path.html#resource StorageDataLakeGen2Path#resource}.
     *
     * @stability stable
     */
    readonly resource: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path.html#storage_account_id StorageDataLakeGen2Path#storage_account_id}.
     *
     * @stability stable
     */
    readonly storageAccountId: string;
    /**
     * ace block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path.html#ace StorageDataLakeGen2Path#ace}
     *
     * @stability stable
     */
    readonly ace?: StorageDataLakeGen2PathAce[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path.html#timeouts StorageDataLakeGen2Path#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: StorageDataLakeGen2PathTimeouts;
}
/**
 * @stability stable
 */
export interface StorageDataLakeGen2PathAce {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path.html#id StorageDataLakeGen2Path#id}.
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path.html#permissions StorageDataLakeGen2Path#permissions}.
     *
     * @stability stable
     */
    readonly permissions: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path.html#scope StorageDataLakeGen2Path#scope}.
     *
     * @stability stable
     */
    readonly scope?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path.html#type StorageDataLakeGen2Path#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function storageDataLakeGen2PathAceToTerraform(struct?: StorageDataLakeGen2PathAce): any;
/**
 * @stability stable
 */
export interface StorageDataLakeGen2PathTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path.html#create StorageDataLakeGen2Path#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path.html#delete StorageDataLakeGen2Path#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path.html#read StorageDataLakeGen2Path#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path.html#update StorageDataLakeGen2Path#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function storageDataLakeGen2PathTimeoutsToTerraform(struct?: StorageDataLakeGen2PathTimeoutsOutputReference | StorageDataLakeGen2PathTimeouts): any;
/**
 * @stability stable
 */
export declare class StorageDataLakeGen2PathTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageDataLakeGen2PathTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageDataLakeGen2PathTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path.html azurerm_storage_data_lake_gen2_path}.
 *
 * @stability stable
 */
export declare class StorageDataLakeGen2Path extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/storage_data_lake_gen2_path.html azurerm_storage_data_lake_gen2_path} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: StorageDataLakeGen2PathConfig);
    private _filesystemName?;
    /**
     * @stability stable
     */
    get filesystemName(): string;
    /**
     * @stability stable
     */
    set filesystemName(value: string);
    /**
     * @stability stable
     */
    get filesystemNameInput(): string | undefined;
    private _group?;
    /**
     * @stability stable
     */
    get group(): string;
    /**
     * @stability stable
     */
    set group(value: string);
    /**
     * @stability stable
     */
    resetGroup(): void;
    /**
     * @stability stable
     */
    get groupInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _owner?;
    /**
     * @stability stable
     */
    get owner(): string;
    /**
     * @stability stable
     */
    set owner(value: string);
    /**
     * @stability stable
     */
    resetOwner(): void;
    /**
     * @stability stable
     */
    get ownerInput(): string | undefined;
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
    private _resource?;
    /**
     * @stability stable
     */
    get resource(): string;
    /**
     * @stability stable
     */
    set resource(value: string);
    /**
     * @stability stable
     */
    get resourceInput(): string | undefined;
    private _storageAccountId?;
    /**
     * @stability stable
     */
    get storageAccountId(): string;
    /**
     * @stability stable
     */
    set storageAccountId(value: string);
    /**
     * @stability stable
     */
    get storageAccountIdInput(): string | undefined;
    private _ace?;
    /**
     * @stability stable
     */
    get ace(): StorageDataLakeGen2PathAce[];
    /**
     * @stability stable
     */
    set ace(value: StorageDataLakeGen2PathAce[]);
    /**
     * @stability stable
     */
    resetAce(): void;
    /**
     * @stability stable
     */
    get aceInput(): StorageDataLakeGen2PathAce[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): StorageDataLakeGen2PathTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: StorageDataLakeGen2PathTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): StorageDataLakeGen2PathTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
