import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface StorageSyncCloudEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_sync_cloud_endpoint.html#file_share_name StorageSyncCloudEndpoint#file_share_name}.
     *
     * @stability stable
     */
    readonly fileShareName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_sync_cloud_endpoint.html#name StorageSyncCloudEndpoint#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_sync_cloud_endpoint.html#storage_account_id StorageSyncCloudEndpoint#storage_account_id}.
     *
     * @stability stable
     */
    readonly storageAccountId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_sync_cloud_endpoint.html#storage_account_tenant_id StorageSyncCloudEndpoint#storage_account_tenant_id}.
     *
     * @stability stable
     */
    readonly storageAccountTenantId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_sync_cloud_endpoint.html#storage_sync_group_id StorageSyncCloudEndpoint#storage_sync_group_id}.
     *
     * @stability stable
     */
    readonly storageSyncGroupId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_sync_cloud_endpoint.html#timeouts StorageSyncCloudEndpoint#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: StorageSyncCloudEndpointTimeouts;
}
/**
 * @stability stable
 */
export interface StorageSyncCloudEndpointTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_sync_cloud_endpoint.html#create StorageSyncCloudEndpoint#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_sync_cloud_endpoint.html#delete StorageSyncCloudEndpoint#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_sync_cloud_endpoint.html#read StorageSyncCloudEndpoint#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function storageSyncCloudEndpointTimeoutsToTerraform(struct?: StorageSyncCloudEndpointTimeoutsOutputReference | StorageSyncCloudEndpointTimeouts): any;
/**
 * @stability stable
 */
export declare class StorageSyncCloudEndpointTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageSyncCloudEndpointTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageSyncCloudEndpointTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/storage_sync_cloud_endpoint.html azurerm_storage_sync_cloud_endpoint}.
 *
 * @stability stable
 */
export declare class StorageSyncCloudEndpoint extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/storage_sync_cloud_endpoint.html azurerm_storage_sync_cloud_endpoint} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: StorageSyncCloudEndpointConfig);
    private _fileShareName?;
    /**
     * @stability stable
     */
    get fileShareName(): string;
    /**
     * @stability stable
     */
    set fileShareName(value: string);
    /**
     * @stability stable
     */
    get fileShareNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _storageAccountId?;
    /**
     * @stability stable
     */
    get storageAccountId(): string;
    /**
     * @stability stable
     */
    set storageAccountId(value: string);
    /**
     * @stability stable
     */
    get storageAccountIdInput(): string | undefined;
    private _storageAccountTenantId?;
    /**
     * @stability stable
     */
    get storageAccountTenantId(): string;
    /**
     * @stability stable
     */
    set storageAccountTenantId(value: string);
    /**
     * @stability stable
     */
    resetStorageAccountTenantId(): void;
    /**
     * @stability stable
     */
    get storageAccountTenantIdInput(): string | undefined;
    private _storageSyncGroupId?;
    /**
     * @stability stable
     */
    get storageSyncGroupId(): string;
    /**
     * @stability stable
     */
    set storageSyncGroupId(value: string);
    /**
     * @stability stable
     */
    get storageSyncGroupIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): StorageSyncCloudEndpointTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: StorageSyncCloudEndpointTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): StorageSyncCloudEndpointTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
