import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VirtualHubConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection.html#hub_to_vitual_network_traffic_allowed VirtualHubConnection#hub_to_vitual_network_traffic_allowed}.
     *
     * @stability stable
     */
    readonly hubToVitualNetworkTrafficAllowed?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection.html#internet_security_enabled VirtualHubConnection#internet_security_enabled}.
     *
     * @stability stable
     */
    readonly internetSecurityEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection.html#name VirtualHubConnection#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection.html#remote_virtual_network_id VirtualHubConnection#remote_virtual_network_id}.
     *
     * @stability stable
     */
    readonly remoteVirtualNetworkId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection.html#virtual_hub_id VirtualHubConnection#virtual_hub_id}.
     *
     * @stability stable
     */
    readonly virtualHubId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection.html#vitual_network_to_hub_gateways_traffic_allowed VirtualHubConnection#vitual_network_to_hub_gateways_traffic_allowed}.
     *
     * @stability stable
     */
    readonly vitualNetworkToHubGatewaysTrafficAllowed?: boolean | cdktf.IResolvable;
    /**
     * routing block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection.html#routing VirtualHubConnection#routing}
     *
     * @stability stable
     */
    readonly routing?: VirtualHubConnectionRouting;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection.html#timeouts VirtualHubConnection#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VirtualHubConnectionTimeouts;
}
/**
 * @stability stable
 */
export interface VirtualHubConnectionRoutingPropagatedRouteTable {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection.html#labels VirtualHubConnection#labels}.
     *
     * @stability stable
     */
    readonly labels?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection.html#route_table_ids VirtualHubConnection#route_table_ids}.
     *
     * @stability stable
     */
    readonly routeTableIds?: string[];
}
export declare function virtualHubConnectionRoutingPropagatedRouteTableToTerraform(struct?: VirtualHubConnectionRoutingPropagatedRouteTableOutputReference | VirtualHubConnectionRoutingPropagatedRouteTable): any;
/**
 * @stability stable
 */
export declare class VirtualHubConnectionRoutingPropagatedRouteTableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualHubConnectionRoutingPropagatedRouteTable | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualHubConnectionRoutingPropagatedRouteTable | undefined);
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): string[];
    /**
     * @stability stable
     */
    set labels(value: string[]);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): string[] | undefined;
    private _routeTableIds?;
    /**
     * @stability stable
     */
    get routeTableIds(): string[];
    /**
     * @stability stable
     */
    set routeTableIds(value: string[]);
    /**
     * @stability stable
     */
    resetRouteTableIds(): void;
    /**
     * @stability stable
     */
    get routeTableIdsInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface VirtualHubConnectionRoutingStaticVnetRoute {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection.html#address_prefixes VirtualHubConnection#address_prefixes}.
     *
     * @stability stable
     */
    readonly addressPrefixes?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection.html#name VirtualHubConnection#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection.html#next_hop_ip_address VirtualHubConnection#next_hop_ip_address}.
     *
     * @stability stable
     */
    readonly nextHopIpAddress?: string;
}
export declare function virtualHubConnectionRoutingStaticVnetRouteToTerraform(struct?: VirtualHubConnectionRoutingStaticVnetRoute): any;
/**
 * @stability stable
 */
export interface VirtualHubConnectionRouting {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection.html#associated_route_table_id VirtualHubConnection#associated_route_table_id}.
     *
     * @stability stable
     */
    readonly associatedRouteTableId?: string;
    /**
     * propagated_route_table block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection.html#propagated_route_table VirtualHubConnection#propagated_route_table}
     *
     * @stability stable
     */
    readonly propagatedRouteTable?: VirtualHubConnectionRoutingPropagatedRouteTable;
    /**
     * static_vnet_route block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection.html#static_vnet_route VirtualHubConnection#static_vnet_route}
     *
     * @stability stable
     */
    readonly staticVnetRoute?: VirtualHubConnectionRoutingStaticVnetRoute[];
}
export declare function virtualHubConnectionRoutingToTerraform(struct?: VirtualHubConnectionRoutingOutputReference | VirtualHubConnectionRouting): any;
/**
 * @stability stable
 */
export declare class VirtualHubConnectionRoutingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualHubConnectionRouting | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualHubConnectionRouting | undefined);
    private _associatedRouteTableId?;
    /**
     * @stability stable
     */
    get associatedRouteTableId(): string;
    /**
     * @stability stable
     */
    set associatedRouteTableId(value: string);
    /**
     * @stability stable
     */
    resetAssociatedRouteTableId(): void;
    /**
     * @stability stable
     */
    get associatedRouteTableIdInput(): string | undefined;
    private _propagatedRouteTable;
    /**
     * @stability stable
     */
    get propagatedRouteTable(): VirtualHubConnectionRoutingPropagatedRouteTableOutputReference;
    /**
     * @stability stable
     */
    putPropagatedRouteTable(value: VirtualHubConnectionRoutingPropagatedRouteTable): void;
    /**
     * @stability stable
     */
    resetPropagatedRouteTable(): void;
    /**
     * @stability stable
     */
    get propagatedRouteTableInput(): VirtualHubConnectionRoutingPropagatedRouteTable | undefined;
    private _staticVnetRoute?;
    /**
     * @stability stable
     */
    get staticVnetRoute(): VirtualHubConnectionRoutingStaticVnetRoute[];
    /**
     * @stability stable
     */
    set staticVnetRoute(value: VirtualHubConnectionRoutingStaticVnetRoute[]);
    /**
     * @stability stable
     */
    resetStaticVnetRoute(): void;
    /**
     * @stability stable
     */
    get staticVnetRouteInput(): VirtualHubConnectionRoutingStaticVnetRoute[] | undefined;
}
/**
 * @stability stable
 */
export interface VirtualHubConnectionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection.html#create VirtualHubConnection#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection.html#delete VirtualHubConnection#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection.html#read VirtualHubConnection#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection.html#update VirtualHubConnection#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function virtualHubConnectionTimeoutsToTerraform(struct?: VirtualHubConnectionTimeoutsOutputReference | VirtualHubConnectionTimeouts): any;
/**
 * @stability stable
 */
export declare class VirtualHubConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualHubConnectionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualHubConnectionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection.html azurerm_virtual_hub_connection}.
 *
 * @stability stable
 */
export declare class VirtualHubConnection extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub_connection.html azurerm_virtual_hub_connection} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VirtualHubConnectionConfig);
    private _hubToVitualNetworkTrafficAllowed?;
    /**
     * @stability stable
     */
    get hubToVitualNetworkTrafficAllowed(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set hubToVitualNetworkTrafficAllowed(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHubToVitualNetworkTrafficAllowed(): void;
    /**
     * @stability stable
     */
    get hubToVitualNetworkTrafficAllowedInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _internetSecurityEnabled?;
    /**
     * @stability stable
     */
    get internetSecurityEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set internetSecurityEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetInternetSecurityEnabled(): void;
    /**
     * @stability stable
     */
    get internetSecurityEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _remoteVirtualNetworkId?;
    /**
     * @stability stable
     */
    get remoteVirtualNetworkId(): string;
    /**
     * @stability stable
     */
    set remoteVirtualNetworkId(value: string);
    /**
     * @stability stable
     */
    get remoteVirtualNetworkIdInput(): string | undefined;
    private _virtualHubId?;
    /**
     * @stability stable
     */
    get virtualHubId(): string;
    /**
     * @stability stable
     */
    set virtualHubId(value: string);
    /**
     * @stability stable
     */
    get virtualHubIdInput(): string | undefined;
    private _vitualNetworkToHubGatewaysTrafficAllowed?;
    /**
     * @stability stable
     */
    get vitualNetworkToHubGatewaysTrafficAllowed(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set vitualNetworkToHubGatewaysTrafficAllowed(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetVitualNetworkToHubGatewaysTrafficAllowed(): void;
    /**
     * @stability stable
     */
    get vitualNetworkToHubGatewaysTrafficAllowedInput(): boolean | cdktf.IResolvable | undefined;
    private _routing;
    /**
     * @stability stable
     */
    get routing(): VirtualHubConnectionRoutingOutputReference;
    /**
     * @stability stable
     */
    putRouting(value: VirtualHubConnectionRouting): void;
    /**
     * @stability stable
     */
    resetRouting(): void;
    /**
     * @stability stable
     */
    get routingInput(): VirtualHubConnectionRouting | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): VirtualHubConnectionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: VirtualHubConnectionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VirtualHubConnectionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
