import base64
import os
from typing import Optional, Union
from ..models.models import ExtendedMessage


class Messaging:
    def __init__(self, client):
        self.client = client

    def group_message(
        self,
        group_id: int,
        content: Union[str, bytes],
        is_image: bool = False
    ):
        if is_image:
            if isinstance(content, str):
                if content.startswith('http://') or content.startswith('https://'):
                    data = content.encode('utf-8')
                    mime_type = 'text/image_link'
                elif os.path.exists(content):
                    with open(content, 'rb') as f:
                        data = f.read()
                    mime_type = 'image/jpeg'
                else:
                    data = content.encode('utf-8')
                    mime_type = 'text/image_link'
            else:
                data = content
                mime_type = 'image/jpeg'
        else:
            if isinstance(content, str):
                data = content.encode('utf-8')
            else:
                data = content
            mime_type = 'text/plain'

        self.client.write_packet(
            self.client.packet.group_message(group_id, data, mime_type)
        )

    def private_message(
        self,
        user_id: int,
        content: Union[str, bytes],
        is_image: bool = False
    ):
        if is_image:
            if isinstance(content, str):
                if content.startswith('http://') or content.startswith('https://'):
                    data = content.encode('utf-8')
                    mime_type = 'text/image_link'
                elif os.path.exists(content):
                    with open(content, 'rb') as f:
                        data = f.read()
                    mime_type = 'image/jpeg'
                else:
                    data = content.encode('utf-8')
                    mime_type = 'text/image_link'
            else:
                data = content
                mime_type = 'image/jpeg'
        else:
            if isinstance(content, str):
                data = content.encode('utf-8')
            else:
                data = content
            mime_type = 'text/plain'

        self.client.write_packet(
            self.client.packet.private_message(user_id, data, mime_type)
        )

    def reply(
        self,
        message: ExtendedMessage,
        content: Union[str, bytes],
        is_image: bool = False
    ):
        if message.is_group and message.group:
            self.group_message(message.group.id, content, is_image)
        else:
            self.private_message(message.originator, content, is_image)
