from typing import Callable, Optional, Any


class Delegates:
    def __init__(self):
        self._login_success: Optional[Callable] = None
        self._login_failed: Optional[Callable] = None
        self._connected: Optional[Callable] = None
        self._disconnected: Optional[Callable] = None
        self._log: Optional[Callable] = None
        self._group_message: Optional[Callable] = None
        self._private_message: Optional[Callable] = None
        self._admin_action: Optional[Callable] = None
        self._user_update: Optional[Callable] = None

    @property
    def LoginSuccess(self):
        return self._login_success

    @LoginSuccess.setter
    def LoginSuccess(self, callback: Callable):
        self._login_success = callback

    @property
    def LoginFailed(self):
        return self._login_failed

    @LoginFailed.setter
    def LoginFailed(self, callback: Callable):
        self._login_failed = callback

    @property
    def Connected(self):
        return self._connected

    @Connected.setter
    def Connected(self, callback: Callable):
        self._connected = callback

    @property
    def Disconnected(self):
        return self._disconnected

    @Disconnected.setter
    def Disconnected(self, callback: Callable):
        self._disconnected = callback

    @property
    def Log(self):
        return self._log

    @Log.setter
    def Log(self, callback: Callable):
        self._log = callback

    @property
    def GroupMessage(self):
        return self._group_message

    @GroupMessage.setter
    def GroupMessage(self, callback: Callable):
        self._group_message = callback

    @property
    def PrivateMessage(self):
        return self._private_message

    @PrivateMessage.setter
    def PrivateMessage(self, callback: Callable):
        self._private_message = callback

    @property
    def AdminAction(self):
        return self._admin_action

    @AdminAction.setter
    def AdminAction(self, callback: Callable):
        self._admin_action = callback

    @property
    def UserUpdate(self):
        return self._user_update

    @UserUpdate.setter
    def UserUpdate(self, callback: Callable):
        self._user_update = callback

    def trigger(self, event: str, *args, **kwargs):
        events = {
            'ls': self._login_success,
            'lf': self._login_failed,
            'cn': self._connected,
            'dc': self._disconnected,
            'log': self._log,
            'gm': self._group_message,
            'pm': self._private_message,
            'aa': self._admin_action,
            'gu': self._user_update,
        }

        callback = events.get(event)
        if callback:
            callback(*args, **kwargs)
