from enum import IntEnum


class LookingFor(IntEnum):
    NOTHING = 0
    FRIENDSHIP = 1
    DATING = 2
    FRIENDSHIP_DATING = 3
    RELATIONSHIP = 4
    DATING_RELATIONSHIP = 6
    FRIENDSHIP_DATING_RELATIONSHIP = 7
    NETWORKING = 8
    RELATIONSHIP_NETWORKING = 12
    DATING_RELATIONSHIP_NETWORKING = 14
    FRIENDSHIP_DATING_RELATIONSHIP_NETWORKING = 15


class RelationshipStatus(IntEnum):
    NOT_SPECIFIED = 0
    SINGLE = 1
    IN_A_RELATIONSHIP = 2
    ENGAGED = 3
    MARRIED = 4
    ITS_COMPLICATED = 5
    IN_AN_OPEN_RELATIONSHIP = 6


class Gender(IntEnum):
    UNSPECIFIED = 0
    MALE = 1
    FEMALE = 2


class NewsType(IntEnum):
    WOLF = 0
    ACCOUNT = 1
    FAVORITE = 2


class OnlineState(IntEnum):
    ONLINE = 1
    AWAY = 2
    INVISIBLE = 3
    BUSY = 5


class Privilege(IntEnum):
    PREMIUM_ACCOUNT_HOLDER = 1 << 20
    VOLUNTEER = 1 << 9
    STAFF = 1 << 12
    AGENT = 1 << 28
    VIP = 1 << 21
    BOT = 1 << 26
    PEST = 1 << 18
    ELITE_CLUB_ONE = 1 << 6
    ELITE_CLUB_TWO = 1 << 17
    ELITE_CLUB_THREE = 1 << 22
    SELECT_CLUB_ONE = 1 << 4
    SELECT_CLUB_TWO = 1 << 10
    SHADOW_BANNED = 1 << 30


class DeviceType(IntEnum):
    UNKNOWN = 0
    BOT = 1
    PC = 2
    GENERIC_MOBILE = 3
    MAC = 4
    IPHONE = 5
    IPAD = 6
    ANDROID = 7
    WEB = 8
    WINDOWS_PHONE_7 = 9


class Language(IntEnum):
    ENGLISH = 1
    DUTCH = 3
    SPANISH = 4
    FRENCH = 6
    POLISH = 10
    CHINESE_SIMPLIFIED = 11
    RUSSIAN = 12
    ITALIAN = 13
    ARABIC = 14
    PERSIAN = 15
    GREEK = 16
    PORTUGUESE = 17
    HINDI = 18
    JAPANESE = 19
    SPANISH_REST_OF_LATIN_AMERICA = 20
    SLOVAK = 21
    CZECH = 22
    DANISH = 24
    FINNISH = 25
    HUNGARIAN = 27
    INDONESIAN = 28
    MALAYSIAN = 29
    DUTCH_NETHERLANDS = 30
    NORWEGIAN = 31
    SWEDISH = 32
    THAI = 33
    TURKISH = 34
    VIETNAMESE = 35
    KOREAN = 36
    PORTUGUESE_BRAZIL = 37
    ESTONIAN = 39
    KAZAKH = 41
    LATVIAN = 42
    LITHUANIAN = 43
    UKRAINIAN = 44
    BULGARIAN = 45


class AdminActionTypes(IntEnum):
    RESET = 0
    ADMIN = 1
    MOD = 2
    BAN = 4
    SILENCE = 8
    KICK = 16
    JOIN = 17
    LEAVE = 18


class Role(IntEnum):
    USER = 0
    ADMIN = 1
    MOD = 2
    BANNED = 4
    SILENCED = 8
    KICKED = 16
    OWNER = 32


class GroupType(IntEnum):
    ID = 0
    NAME = 1
