import datetime
from dateutil.parser import parserinfo

# Configs
class Configs:
    def __init__(self, year1st: bool = False, day1st: bool = False) -> None: ...
    @classmethod
    def from_parserinfo(cls, info: parserinfo) -> Configs: ...
    # Property
    @property
    def year1st(self) -> bool: ...
    @property
    def day1st(self) -> bool: ...
    # Pertain
    @property
    def pertain(self) -> set[str]: ...
    def add_pertain(self, *words: str) -> None: ...
    def rem_pertain(self, *words: str) -> None: ...
    def set_pertain(self, *words: str) -> None: ...
    # Jump
    @property
    def jump(self) -> set[str]: ...
    def add_jump(self, *words: str) -> None: ...
    def rem_jump(self, *words: str) -> None: ...
    def set_jump(self, *words: str) -> None: ...
    # UTC
    @property
    def utc(self) -> set[str]: ...
    def add_utc(self, *words: str) -> None: ...
    def rem_utc(self, *words: str) -> None: ...
    def set_utc(self, *words: str) -> None: ...
    # Timezone
    @property
    def tz(self) -> dict[str, int]: ...
    def add_tz(
        self, word: str, hour: int = 0, minute: int = 0, seconds: int = 0
    ) -> None: ...
    def rem_tz(self, *words: str) -> None: ...
    def set_tz(self, **words_and_offsets: int) -> None: ...
    # Month
    @property
    def month(self) -> dict[str, int]: ...
    def add_month(self, month: int, *words: str) -> None: ...
    def rem_month(self, *words: str) -> None: ...
    def set_month(self, **words_and_months: int) -> None: ...
    # Weekday
    @property
    def weekday(self) -> dict[str, int]: ...
    def add_weekday(self, weekday: int, *words: str) -> None: ...
    def rem_weekday(self, *words: str) -> None: ...
    def set_weekday(self, **words_and_weekdays: int) -> None: ...
    # HMS flag
    @property
    def hms_flag(self) -> dict[str, int]: ...
    def add_hms_flag(self, hms_flag: int, *words: str) -> None: ...
    def rem_hms_flag(self, *words: str) -> None: ...
    def set_hms_flag(self, **words_and_hmsflags: int) -> None: ...
    # AM/PM flag
    @property
    def ampm_flag(self) -> dict[str, int]: ...
    def add_ampm_flag(self, ampm_flag: int, *words: str) -> None: ...
    def rem_ampm_flag(self, *words: str) -> None: ...
    def set_ampm(self, **words_and_ampmflags: int) -> None: ...
    # Special methods
    def __repr__(self) -> str: ...

# Timelex
def timelex(dtstr: str) -> list[str]: ...

# Parser
class Parser:
    def __init__(self, cfg: Configs | None = None) -> None: ...
    # Parse
    def parse(
        self,
        dtstr: str,
        default: datetime.date | datetime.datetime | None = None,
        year1st: bool | None = None,
        day1st: bool | None = None,
        ignoretz: bool = True,
        isoformat: bool = True,
    ) -> datetime.datetime: ...

def parse(
    dtstr: str,
    default: datetime.date | datetime.datetime | None = None,
    year1st: bool | None = None,
    day1st: bool | None = None,
    ignoretz: bool = True,
    isoformat: bool = True,
    cfg: Configs | None = None,
) -> datetime.datetime: ...
def parse_dtobj(
    dtobj: object,
    default: datetime.date | datetime.datetime | None = None,
    year1st: bool | None = None,
    day1st: bool | None = None,
    ignoretz: bool = True,
    isoformat: bool = True,
    cfg: Configs | None = None,
) -> datetime.datetime: ...
