"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecureLogBucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_secure_bucket_1 = require("@gammarer/aws-secure-bucket");
const cdk = require("aws-cdk-lib");
const s3 = require("aws-cdk-lib/aws-s3");
class SecureLogBucket extends aws_secure_bucket_1.SecureBucket {
    constructor(scope, id, props) {
        super(scope, id, {
            bucketName: props?.bucketName,
            encryption: aws_secure_bucket_1.SecureBucketEncryption.KMS_MANAGED,
            lifecycleRules: [{
                    id: 'archive-step-lifecycle-rule',
                    enabled: true,
                    transitions: [
                        {
                            storageClass: s3.StorageClass.INFREQUENT_ACCESS,
                            transitionAfter: cdk.Duration.days(props?.changeClassTransition?.infrequentAccessDays ?? 60),
                        },
                        {
                            storageClass: s3.StorageClass.INTELLIGENT_TIERING,
                            transitionAfter: cdk.Duration.days(props?.changeClassTransition?.intelligentTieringDays ?? 120),
                        },
                        {
                            storageClass: s3.StorageClass.GLACIER,
                            transitionAfter: cdk.Duration.days(props?.changeClassTransition?.glacierDays ?? 180),
                        },
                        {
                            storageClass: s3.StorageClass.DEEP_ARCHIVE,
                            transitionAfter: cdk.Duration.days(props?.changeClassTransition?.deepArchiveDays ?? 360),
                        },
                    ],
                }],
        });
    }
}
exports.SecureLogBucket = SecureLogBucket;
_a = JSII_RTTI_SYMBOL_1;
SecureLogBucket[_a] = { fqn: "@gammarer/aws-secure-log-bucket.SecureLogBucket", version: "0.9.6" };
//# sourceMappingURL=data:application/json;base64,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