/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.util.DefaultInstantiatorStrategy;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.RandomAccessOutputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.MissingLibraryException;
import loci.formats.ReaderWrapper;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.services.OMEXMLService;
import loci.formats.services.OMEXMLServiceImpl;
import org.objenesis.strategy.StdInstantiatorStrategy;
import org.perf4j.slf4j.Slf4JStopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Memoizer
extends ReaderWrapper {
    public static final Integer VERSION = 4;
    public static final long DEFAULT_MINIMUM_ELAPSED = 100L;
    private static final Logger LOGGER = LoggerFactory.getLogger(Memoizer.class);
    private final long minimumElapsed;
    private final File directory;
    private boolean doInPlaceCaching = false;
    protected transient Deser ser;
    private transient OMEXMLService service;
    private Location realFile;
    private File memoFile;
    private File tempFile;
    private boolean skipLoad = false;
    private boolean skipSave = false;
    private boolean versionChecking = false;
    private boolean loadedFromMemo = false;
    private boolean savedToMemo = false;
    private MetadataStore userMetadataStore = null;
    private MetadataStore replacementMetadataStore = null;

    public Memoizer() {
        this(100L);
    }

    public Memoizer(long minimumElapsed) {
        this(null, minimumElapsed, null);
        this.doInPlaceCaching = true;
    }

    public Memoizer(long minimumElapsed, File directory) {
        this(null, minimumElapsed, directory);
    }

    public Memoizer(IFormatReader r) {
        this(r, 100L, null);
        this.doInPlaceCaching = true;
    }

    public Memoizer(IFormatReader r, long minimumElapsed) {
        this(r, minimumElapsed, null);
        this.doInPlaceCaching = true;
    }

    public Memoizer(IFormatReader r, File directory) {
        this(r, 100L, directory);
    }

    public Memoizer(IFormatReader r, long minimumElapsed, File directory) {
        this.reader = r == null ? new ImageReader() : r;
        this.minimumElapsed = minimumElapsed;
        this.directory = directory;
    }

    public boolean isLoadedFromMemo() {
        return this.loadedFromMemo;
    }

    public boolean isSavedToMemo() {
        return this.savedToMemo;
    }

    public boolean isVersionChecking() {
        return this.versionChecking;
    }

    public boolean versionMismatch() throws IOException {
        String currentMinor;
        int secondDot;
        String releaseVersion = this.ser.loadReleaseVersion();
        if (!this.isVersionChecking()) {
            return false;
        }
        String minor = releaseVersion;
        int firstDot = minor.indexOf(46);
        if (firstDot >= 0 && (secondDot = minor.indexOf(".", firstDot + 1)) >= 0) {
            minor = minor.substring(0, secondDot);
        }
        if (!(currentMinor = FormatTools.VERSION.substring(0, FormatTools.VERSION.indexOf(".", FormatTools.VERSION.indexOf(46) + 1))).equals(minor)) {
            LOGGER.info("Different release version: {} not {}", (Object)releaseVersion, (Object)FormatTools.VERSION);
            return true;
        }
        if (!this.versionChecking && FormatTools.VERSION.endsWith("-SNAPSHOT")) {
            LOGGER.info("Development version: {}", (Object)FormatTools.VERSION);
            return true;
        }
        return false;
    }

    public void setVersionChecking(boolean version) {
        this.versionChecking = version;
    }

    public void skipSave(boolean skip) {
        this.skipSave = skip;
    }

    protected void cleanup() {
        if (this.ser != null) {
            this.ser.close();
            this.ser = null;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.cleanup();
        }
        finally {
            super.close();
        }
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        try {
            this.cleanup();
        }
        finally {
            super.close(fileOnly);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setId(String id) throws FormatException, IOException {
        Slf4JStopWatch sw = this.stopWatch();
        try {
            this.realFile = new Location(id);
            this.memoFile = this.getMemoFile(id);
            if (this.memoFile == null) {
                if (this.userMetadataStore != null) {
                    this.reader.setMetadataStore(this.userMetadataStore);
                }
                super.setId(id);
                return;
            }
            IFormatReader memo = this.loadMemo();
            this.loadedFromMemo = false;
            this.savedToMemo = false;
            if (memo != null) {
                try {
                    this.loadedFromMemo = true;
                    this.reader = memo;
                    this.reader.reopenFile();
                }
                catch (FileNotFoundException e) {
                    LOGGER.info("could not reopen file - deleting invalid memo file: {}", (Object)this.memoFile);
                    this.deleteQuietly(this.memoFile);
                    memo = null;
                    this.reader.close();
                    this.loadedFromMemo = false;
                }
            }
            if (memo == null) {
                OMEXMLService service = this.getService();
                super.setMetadataStore(service.createOMEXMLMetadata());
                long start = System.currentTimeMillis();
                super.setId(id);
                long elapsed = System.currentTimeMillis() - start;
                this.handleMetadataStore(null);
                if (elapsed < this.minimumElapsed) {
                    LOGGER.debug("skipping save memo. elapsed millis: {}", (Object)elapsed);
                    return;
                }
                this.savedToMemo = this.saveMemo();
            }
        }
        catch (ServiceException e) {
            LOGGER.error("Could not create OMEXMLMetadata", e);
        }
        finally {
            sw.stop("loci.formats.Memoizer.setId");
        }
    }

    @Override
    public void setMetadataStore(MetadataStore store) {
        this.userMetadataStore = store;
    }

    @Override
    public MetadataStore getMetadataStore() {
        if (this.userMetadataStore != null) {
            return this.userMetadataStore;
        }
        return this.reader.getMetadataStore();
    }

    protected boolean deleteQuietly(File file2) {
        try {
            if (file2 != null && file2.exists() && !this.skipSave) {
                if (file2.delete()) {
                    LOGGER.trace("deleted {}", (Object)file2);
                    return true;
                }
                LOGGER.warn("file deletion failed {}", (Object)file2);
            }
        }
        catch (Throwable t) {
            LOGGER.error("file deletion failed: {}", (Object)file2, (Object)t);
        }
        return false;
    }

    protected Deser getDeser() {
        if (this.ser == null) {
            this.ser = new KryoDeser();
        }
        return this.ser;
    }

    protected OMEXMLService getService() throws MissingLibraryException {
        if (this.service == null) {
            try {
                ServiceFactory factory = new ServiceFactory();
                this.service = factory.getInstance(OMEXMLService.class);
            }
            catch (DependencyException de) {
                throw new MissingLibraryException(OMEXMLServiceImpl.NO_OME_XML_MSG, de);
            }
        }
        return this.service;
    }

    protected Slf4JStopWatch stopWatch() {
        return new Slf4JStopWatch(LOGGER, 10000);
    }

    public File getMemoFile(String id) {
        File f = null;
        File writeDirectory = null;
        if (this.directory == null && !this.doInPlaceCaching) {
            LOGGER.debug("skipping memo: no directory given");
            return null;
        }
        id = new File(id).getAbsolutePath();
        String rootPath = id.substring(0, id.indexOf(File.separator) + 1);
        if (this.doInPlaceCaching || this.directory.getAbsolutePath().equals(rootPath)) {
            f = new File(id);
            writeDirectory = new File(f.getParent());
        } else {
            id = id.substring(id.indexOf(File.separator) + 1);
            f = new File(this.directory, id);
            writeDirectory = this.directory;
        }
        if (!this.isWritableDirectory(writeDirectory)) {
            LOGGER.warn("skipping memo: directory not writeable - {}", (Object)writeDirectory);
            return null;
        }
        f.getParentFile().mkdirs();
        String p = f.getParent();
        String n = f.getName();
        return new File(p, "." + n + ".bfmemo");
    }

    protected boolean isWritableDirectory(File writeDirectory) {
        return writeDirectory.canWrite() && writeDirectory.isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFormatReader loadMemo() throws IOException, FormatException {
        long realLast;
        if (this.skipLoad) {
            LOGGER.trace("skip load");
            return null;
        }
        if (!this.memoFile.exists()) {
            LOGGER.trace("Memo file doesn't exist: {}", (Object)this.memoFile);
            return null;
        }
        if (!this.memoFile.canRead()) {
            LOGGER.trace("Can't read memo file: {}", (Object)this.memoFile);
            return null;
        }
        long memoLast = this.memoFile.lastModified();
        if (memoLast < (realLast = this.realFile.lastModified())) {
            LOGGER.debug("memo(lastModified={}) older than real(lastModified={})", (Object)memoLast, (Object)realLast);
            return null;
        }
        Deser ser = this.getDeser();
        Slf4JStopWatch sw = this.stopWatch();
        IFormatReader copy = null;
        ser.loadStart(this.memoFile);
        try {
            Integer version = ser.loadVersion();
            if (!VERSION.equals(version)) {
                LOGGER.info("Old version of memo file: {} not {}", (Object)version, (Object)VERSION);
                IFormatReader iFormatReader = null;
                return iFormatReader;
            }
            if (this.versionMismatch()) {
                IFormatReader iFormatReader = null;
                return iFormatReader;
            }
            try {
                copy = ser.loadReader();
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn("unknown reader type: {}", e);
                IFormatReader iFormatReader = null;
                ser.loadStop();
                sw.stop("loci.formats.Memoizer.loadMemo");
                return iFormatReader;
            }
            boolean equal = false;
            try {
                equal = FormatTools.equalReaders(this.reader, copy);
            }
            catch (RuntimeException rt) {
                copy.close();
                throw rt;
            }
            catch (Error err) {
                copy.close();
                throw err;
            }
            if (!equal) {
                copy.close();
                IFormatReader iFormatReader = null;
                return iFormatReader;
            }
            if ((copy = this.handleMetadataStore(copy)) == null) {
                LOGGER.debug("metadata store invalidated cache: {}", (Object)this.memoFile);
            }
            LOGGER.debug("loaded memo file: {} ({} bytes)", (Object)this.memoFile, (Object)this.memoFile.length());
            IFormatReader iFormatReader = copy;
            return iFormatReader;
        }
        catch (KryoException e) {
            LOGGER.warn("deleting invalid memo file: {}", (Object)this.memoFile, (Object)e);
            LOGGER.debug("Kryo Exception: " + e.getMessage());
            this.deleteQuietly(this.memoFile);
            IFormatReader iFormatReader = null;
            return iFormatReader;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOGGER.warn("deleting invalid memo file: {}", (Object)this.memoFile, (Object)e);
            LOGGER.debug("ArrayIndexOutOfBoundsException: " + e.getMessage());
            this.deleteQuietly(this.memoFile);
            IFormatReader iFormatReader = null;
            return iFormatReader;
        }
        catch (Throwable t) {
            LOGGER.error("deleting invalid memo file: {}", (Object)this.memoFile, (Object)t);
            LOGGER.debug("Other Exception: " + t.getMessage());
            this.deleteQuietly(this.memoFile);
            IFormatReader iFormatReader = null;
            return iFormatReader;
        }
        finally {
            ser.loadStop();
            sw.stop("loci.formats.Memoizer.loadMemo");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveMemo() {
        if (this.skipSave) {
            LOGGER.trace("skip memo");
            return false;
        }
        Deser ser = this.getDeser();
        Slf4JStopWatch sw = this.stopWatch();
        boolean rv = true;
        try {
            this.tempFile = File.createTempFile(this.memoFile.getName(), "", this.memoFile.getParentFile());
            ser.saveStart(this.tempFile);
            ser.saveVersion(VERSION);
            ser.saveReleaseVersion(FormatTools.VERSION);
            ser.saveReader(this.reader);
            ser.saveStop();
            LOGGER.debug("saved to temp file: {}", (Object)this.tempFile);
        }
        catch (Throwable t) {
            LOGGER.warn(String.format("failed to save memo file: %s", this.memoFile), t);
            rv = false;
        }
        finally {
            try {
                ser.saveStop();
                sw.stop("loci.formats.Memoizer.saveMemo");
            }
            catch (Throwable t) {
                LOGGER.error("output close failed", t);
            }
            if (rv) {
                if (!this.tempFile.renameTo(this.memoFile)) {
                    LOGGER.error("temp file rename returned false: {}", (Object)this.tempFile);
                } else {
                    LOGGER.debug("saved memo file: {} ({} bytes)", (Object)this.memoFile, (Object)this.memoFile.length());
                }
            }
            this.deleteQuietly(this.tempFile);
        }
        return rv;
    }

    public boolean deleteMemo() {
        return this.deleteQuietly(this.memoFile);
    }

    public File getMemoFile() {
        return this.memoFile;
    }

    protected IFormatReader handleMetadataStore(IFormatReader memo) throws MissingLibraryException {
        boolean onLoad;
        if (this.userMetadataStore == null) {
            return memo;
        }
        boolean bl = onLoad = memo != null;
        if (onLoad) {
            MetadataStore filledStore = memo.getMetadataStore();
            if (filledStore != null) {
                if (!(filledStore instanceof MetadataRetrieve)) {
                    LOGGER.error("Found non-MetadataRetrieve: {}" + filledStore.getClass());
                } else {
                    OMEXMLService service = this.getService();
                    service.convertMetadata((MetadataRetrieve)((Object)filledStore), this.userMetadataStore);
                }
            }
        } else {
            MetadataStore filledStore = this.reader.getMetadataStore();
            if (this.reader.getMetadataStore() == null) {
                LOGGER.error("Found null-MetadataRetrieve: {}" + filledStore.getClass());
            } else if (!(filledStore instanceof MetadataRetrieve)) {
                LOGGER.error("Found non-MetadataRetrieve: {}" + filledStore.getClass());
            } else {
                OMEXMLService service = this.getService();
                service.convertMetadata((MetadataRetrieve)((Object)filledStore), this.userMetadataStore);
            }
        }
        return memo;
    }

    public boolean generateMemo(String file2) throws IOException {
        try {
            this.setId(file2);
        }
        catch (FormatException e) {
            LOGGER.warn("Could not initialize " + file2, e);
        }
        finally {
            this.close();
        }
        return this.isSavedToMemo();
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args.length > 2) {
            System.err.println("Usage: memoizer file [tmpdir]");
            System.exit(2);
        }
        File tmp = new File(System.getProperty("java.io.tmpdir"));
        if (args.length == 2) {
            tmp = new File(args[1]);
        }
        System.out.println("First load of " + args[0]);
        Memoizer.load(args[0], tmp, true);
        System.out.println("Second load of " + args[0]);
        Memoizer.load(args[0], tmp, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load(String id, File tmp, boolean delete) throws Exception {
        Memoizer m3 = new Memoizer(0L, tmp);
        File memo = m3.getMemoFile(id);
        if (delete && memo != null && memo.exists()) {
            System.out.println("Deleting " + memo);
            memo.delete();
        }
        m3.setVersionChecking(false);
        try {
            m3.setId(id);
            m3.openBytes(0);
            IFormatReader r = m3.getReader();
            r = ((ImageReader)r).getReader();
            System.out.println(r);
        }
        finally {
            m3.close();
        }
    }

    private static abstract class RandomAccessDeser
    implements Deser {
        RandomAccessInputStream loadStream;
        RandomAccessOutputStream saveStream;

        private RandomAccessDeser() {
        }

        @Override
        public void loadStart(File memoFile) throws IOException {
            this.loadStream = new RandomAccessInputStream(memoFile.getAbsolutePath());
        }

        @Override
        public Integer loadVersion() throws IOException {
            return this.loadStream.readInt();
        }

        @Override
        public String loadReleaseVersion() throws IOException {
            int length = this.loadStream.readInt();
            return this.loadStream.readString(length);
        }

        @Override
        public String loadRevision() throws IOException {
            int length = this.loadStream.readInt();
            return this.loadStream.readString(length);
        }

        @Override
        public IFormatReader loadReader() throws IOException, ClassNotFoundException {
            int cSize = this.loadStream.readInt();
            byte[] cArr = new byte[cSize];
            this.loadStream.readFully(cArr);
            Class<IFormatReader> c = Class.forName(new String(cArr, "UTF-8"));
            int rSize = this.loadStream.readInt();
            byte[] rArr = new byte[rSize];
            this.loadStream.readFully(rArr);
            return this.readerFromBytes(c, rArr);
        }

        protected abstract IFormatReader readerFromBytes(Class<IFormatReader> var1, byte[] var2) throws IOException, ClassNotFoundException;

        @Override
        public void loadStop() throws IOException {
            if (this.loadStream != null) {
                this.loadStream.close();
                this.loadStream = null;
            }
        }

        @Override
        public void saveStart(File tempFile) throws IOException {
            this.saveStream = new RandomAccessOutputStream(tempFile.getAbsolutePath());
        }

        @Override
        public void saveVersion(Integer version) throws IOException {
            this.saveStream.writeInt(version);
        }

        @Override
        public void saveReleaseVersion(String version) throws IOException {
            this.saveStream.writeInt(version.length());
            this.saveStream.writeBytes(version);
        }

        @Override
        public void saveRevision(String revision) throws IOException {
            this.saveStream.writeInt(revision.length());
            this.saveStream.writeBytes(revision);
        }

        @Override
        public void saveReader(IFormatReader reader) throws IOException {
            byte[] cArr = reader.getClass().getName().getBytes("UTF-8");
            this.saveStream.write(cArr.length);
            this.saveStream.write(cArr);
            byte[] rArr = this.bytesFromReader(reader);
            this.saveStream.write(rArr.length);
            this.saveStream.write(rArr);
        }

        protected abstract byte[] bytesFromReader(IFormatReader var1) throws IOException;

        @Override
        public void saveStop() throws IOException {
            if (this.saveStream != null) {
                this.saveStream.close();
                this.saveStream = null;
            }
        }
    }

    public static class KryoDeser
    implements Deser {
        public final Kryo kryo = new Kryo();
        FileInputStream fis;
        FileOutputStream fos;
        Input input;
        Output output;

        public KryoDeser() {
            ((DefaultInstantiatorStrategy)this.kryo.getInstantiatorStrategy()).setFallbackInstantiatorStrategy(new StdInstantiatorStrategy());
            this.kryo.setRegistrationRequired(false);
            this.kryo.setReferences(true);
        }

        @Override
        public void close() {
            this.loadStop();
            this.saveStop();
            this.kryo.reset();
        }

        @Override
        public void loadStart(File memoFile) throws FileNotFoundException {
            this.fis = new FileInputStream(memoFile);
            this.input = new Input(this.fis);
        }

        @Override
        public Integer loadVersion() {
            return this.kryo.readObject(this.input, Integer.class);
        }

        @Override
        public String loadReleaseVersion() {
            return this.kryo.readObject(this.input, String.class);
        }

        @Override
        public String loadRevision() {
            return this.kryo.readObject(this.input, String.class);
        }

        @Override
        public IFormatReader loadReader() {
            Class c = this.kryo.readObject(this.input, Class.class);
            return (IFormatReader)this.kryo.readObject(this.input, c);
        }

        @Override
        public void loadStop() {
            if (this.input != null) {
                this.input.close();
                this.input = null;
            }
            if (this.fis != null) {
                try {
                    this.fis.close();
                }
                catch (IOException e) {
                    LOGGER.error("failed to close KryoDeser.fis", e);
                }
                this.fis = null;
            }
        }

        @Override
        public void saveStart(File tempFile) throws FileNotFoundException {
            this.fos = new FileOutputStream(tempFile);
            this.output = new Output(this.fos);
        }

        @Override
        public void saveVersion(Integer version) {
            this.kryo.writeObject(this.output, version);
        }

        @Override
        public void saveReleaseVersion(String version) {
            this.kryo.writeObject(this.output, version);
        }

        @Override
        public void saveRevision(String revision) {
            this.kryo.writeObject(this.output, revision);
        }

        @Override
        public void saveReader(IFormatReader reader) {
            this.kryo.writeObject(this.output, reader.getClass());
            this.kryo.writeObject(this.output, reader);
        }

        @Override
        public void saveStop() {
            if (this.output != null) {
                this.output.close();
                this.output = null;
            }
            if (this.fos != null) {
                try {
                    this.fos.close();
                    this.fos = null;
                }
                catch (IOException e) {
                    LOGGER.error("failed to close KryoDeser.fis", e);
                }
            }
        }
    }

    public static interface Deser {
        public void loadStart(File var1) throws IOException;

        public Integer loadVersion() throws IOException;

        public String loadReleaseVersion() throws IOException;

        public String loadRevision() throws IOException;

        public IFormatReader loadReader() throws IOException, ClassNotFoundException;

        public void loadStop() throws IOException;

        public void saveStart(File var1) throws IOException;

        public void saveVersion(Integer var1) throws IOException;

        public void saveReleaseVersion(String var1) throws IOException;

        public void saveRevision(String var1) throws IOException;

        public void saveReader(IFormatReader var1) throws IOException;

        public void saveStop() throws IOException;

        public void close();
    }
}

