/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.FileNotFoundException;
import java.io.IOException;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.units.unit.Unit;

public class NiftiReader
extends FormatReader {
    private static final int UNITS_METER = 1;
    private static final int UNITS_MM = 2;
    private static final int UNITS_MSEC = 16;
    private static final int UNITS_USEC = 24;
    private int pixelOffset;
    private transient RandomAccessInputStream pixelFile;
    private String pixelsFilename;
    private short nDimensions;
    private String description;
    private double voxelWidth;
    private double voxelHeight;
    private double sliceThickness;
    private double deltaT;
    private Unit<Length> spatialUnit = UNITS.MICROMETER;
    private Unit<Time> timeUnit = UNITS.SECOND;

    public NiftiReader() {
        super("NIfTI", new String[]{"nii", "img", "hdr", "nii.gz"});
        this.suffixSufficient = false;
        this.domains = new String[]{"Medical Imaging", "Unknown"};
        this.hasCompanionFiles = true;
        this.datasetDescription = "A single .nii file or a single .nii.gz file or one .img file and a similarly-named .hdr file";
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return NiftiReader.checkSuffix(id, "nii");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isThisType(String name, boolean open) {
        if (NiftiReader.checkSuffix(name, "nii")) {
            return true;
        }
        int dot = name.lastIndexOf(".");
        if (dot == 0) {
            dot = name.length() - 1;
        }
        if (dot < 0) {
            return false;
        }
        if (!open) {
            return false;
        }
        String headerFile = name.substring(0, dot) + ".hdr";
        try (RandomAccessInputStream header2222 = new RandomAccessInputStream(headerFile);){
            boolean bl = this.isThisType(header2222);
            return bl;
        }
        catch (FileNotFoundException header2222) {
            return false;
        }
        catch (IOException e) {
            LOGGER.debug("", e);
        }
        return false;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 348;
        if (!FormatTools.validStream(stream, 348, false)) {
            return false;
        }
        stream.seek(344L);
        String magic = stream.readString(3);
        return magic.equals("ni1") || magic.equals("n+1");
    }

    @Override
    public String[] getDomains() {
        FormatTools.assertId(this.currentId, true, 1);
        String[] domain = new String[]{this.nDimensions <= 3 ? "Unknown" : "Medical Imaging"};
        return domain;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        long planeSize = FormatTools.getPlaneSize(this);
        long newOffset = (long)this.pixelOffset + (long)no * planeSize;
        if (this.pixelFile.getFilePointer() > newOffset) {
            this.pixelFile.seek(0L);
        }
        this.pixelFile.seek(newOffset);
        this.readPlane(this.pixelFile, x, y, w, h2, buf);
        return buf;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.pixelsFilename.equals(this.currentId) && noPixels) {
            return null;
        }
        if (!noPixels && !this.pixelsFilename.equals(this.currentId)) {
            return new String[]{this.currentId, this.pixelsFilename};
        }
        return new String[]{this.currentId};
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.pixelFile != null) {
            this.pixelFile.close();
        }
        if (!fileOnly) {
            this.pixelOffset = 0;
            this.pixelFile = null;
            this.pixelsFilename = null;
            this.nDimensions = 0;
            this.description = null;
            this.deltaT = 0.0;
            this.sliceThickness = 0.0;
            this.voxelHeight = 0.0;
            this.voxelWidth = 0.0;
            this.spatialUnit = UNITS.MICROMETER;
            this.timeUnit = UNITS.SECOND;
        }
    }

    @Override
    public void reopenFile() throws IOException {
        super.reopenFile();
        if (this.pixelFile == null) {
            this.pixelFile = new RandomAccessInputStream(this.pixelsFilename);
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        boolean little;
        if (id.endsWith(".img")) {
            LOGGER.info("Looking for header file");
            String header = id.substring(0, id.lastIndexOf(".")) + ".hdr";
            if (new Location(header).exists()) {
                this.setId(header);
                return;
            }
            throw new FormatException("Header file not found.");
        }
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m3 = (CoreMetadata)this.core.get(0);
        this.in.seek(40L);
        short check = this.in.readShort();
        boolean bl = little = check < 1 || check > 7;
        if (id.endsWith(".hdr")) {
            this.pixelsFilename = id.substring(0, id.lastIndexOf(".")) + ".img";
            this.pixelFile = new RandomAccessInputStream(this.pixelsFilename);
        } else if (NiftiReader.checkSuffix(id, "nii")) {
            this.pixelsFilename = id;
            this.pixelFile = this.in;
        } else {
            throw new FormatException("File does not have one of the required NIfTI extensions (.img, .hdr, .nii, .nii.gz)");
        }
        this.in.order(little);
        this.pixelFile.order(little);
        m3.littleEndian = little;
        LOGGER.info("Reading header");
        this.nDimensions = !little ? check : DataTools.swap(check);
        m3.sizeX = this.in.readShort();
        m3.sizeY = this.in.readShort();
        m3.sizeZ = this.in.readShort();
        m3.sizeT = this.in.readShort();
        m3.sizeC = 1;
        int[] extraDims = new int[]{this.in.readShort(), this.in.readShort(), this.in.readShort()};
        if (this.nDimensions > 4) {
            LOGGER.debug("nDimensions = {}", (Object)this.nDimensions);
            for (int i = 0; i < this.nDimensions - 4; ++i) {
                LOGGER.debug("  processing dimension = {}, Z = {}, T = {}, C = {}", extraDims[i], this.getSizeZ(), this.getSizeT(), this.getSizeC());
                m3.sizeC *= extraDims[i];
            }
        }
        this.in.skipBytes(14);
        short dataType = this.in.readShort();
        this.in.skipBytes(36);
        this.pixelOffset = (int)this.in.readFloat();
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            this.populateExtendedMetadata();
        }
        LOGGER.info("Populating core metadata");
        if (this.getSizeZ() == 0) {
            m3.sizeZ = 1;
        }
        if (this.getSizeT() == 0) {
            m3.sizeT = 1;
        }
        m3.imageCount = this.getSizeZ() * this.getSizeT() * this.getSizeC();
        m3.indexed = false;
        m3.dimensionOrder = "XYCZT";
        this.populatePixelType(dataType);
        m3.rgb = this.getSizeC() > 1 && this.getImageCount() == this.getSizeZ() * this.getSizeT();
        m3.interleaved = this.isRGB();
        LOGGER.info("Populating MetadataStore");
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            store.setImageDescription(this.description, 0);
            Length sizeX = FormatTools.getPhysicalSizeX(new Double(this.voxelWidth), this.spatialUnit);
            Length sizeY = FormatTools.getPhysicalSizeY(new Double(this.voxelHeight), this.spatialUnit);
            Length sizeZ = FormatTools.getPhysicalSizeZ(new Double(this.sliceThickness), this.spatialUnit);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, 0);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, 0);
            }
            if (sizeZ != null) {
                store.setPixelsPhysicalSizeZ(sizeZ, 0);
            }
            store.setPixelsTimeIncrement(new Time(new Double(this.deltaT), this.timeUnit), 0);
        }
    }

    private void populatePixelType(int dataType) throws FormatException {
        CoreMetadata m3 = (CoreMetadata)this.core.get(0);
        switch (dataType) {
            case 1: 
            case 2: {
                m3.pixelType = 1;
                break;
            }
            case 4: {
                m3.pixelType = 2;
                break;
            }
            case 8: {
                m3.pixelType = 4;
                break;
            }
            case 16: {
                m3.pixelType = 6;
                break;
            }
            case 64: {
                m3.pixelType = 7;
                break;
            }
            case 128: {
                m3.pixelType = 1;
                m3.sizeC = 3;
            }
            case 256: {
                m3.pixelType = 0;
                break;
            }
            case 512: {
                m3.pixelType = 3;
                break;
            }
            case 768: {
                m3.pixelType = 5;
                break;
            }
            case 2304: {
                m3.pixelType = 1;
                m3.sizeC = 4;
            }
            default: {
                throw new FormatException("Unsupported data type: " + dataType);
            }
        }
    }

    private void populateExtendedMetadata() throws IOException {
        this.in.seek(39L);
        byte sliceOrdering = this.in.readByte();
        this.in.skipBytes(8);
        short dim5 = this.in.readShort();
        short dim6 = this.in.readShort();
        short dim7 = this.in.readShort();
        short dim8 = this.in.readShort();
        float intent1 = this.in.readFloat();
        float intent2 = this.in.readFloat();
        float intent3 = this.in.readFloat();
        short intentCode = this.in.readShort();
        short dataType = this.in.readShort();
        short bitpix = this.in.readShort();
        short sliceStart = this.in.readShort();
        this.in.skipBytes(4);
        this.voxelWidth = this.in.readFloat();
        this.voxelHeight = this.in.readFloat();
        this.sliceThickness = this.in.readFloat();
        this.deltaT = this.in.readFloat();
        this.in.skipBytes(16);
        float scaleSlope = this.in.readFloat();
        float scaleIntercept = this.in.readFloat();
        short sliceEnd = this.in.readShort();
        byte sliceCode = this.in.readByte();
        byte units = this.in.readByte();
        int spatialUnits = units & 7;
        int timeUnits = units & 0x38;
        switch (spatialUnits) {
            case 1: {
                this.spatialUnit = UNITS.METER;
                break;
            }
            case 2: {
                this.spatialUnit = UNITS.MILLIMETER;
            }
        }
        switch (timeUnits) {
            case 16: {
                this.timeUnit = UNITS.MILLISECOND;
                break;
            }
            case 24: {
                this.timeUnit = UNITS.MICROSECOND;
            }
        }
        float calMax = this.in.readFloat();
        float calMin = this.in.readFloat();
        float sliceDuration = this.in.readFloat();
        float toffset = this.in.readFloat();
        this.in.skipBytes(8);
        this.description = this.in.readString(80);
        this.in.skipBytes(24);
        short qformCode = this.in.readShort();
        short sformCode = this.in.readShort();
        float quaternionB = this.in.readFloat();
        float quaternionC = this.in.readFloat();
        float quaternionD = this.in.readFloat();
        float quaternionX = this.in.readFloat();
        float quaternionY = this.in.readFloat();
        float quaternionZ = this.in.readFloat();
        float[][] transform = new float[3][4];
        for (int i = 0; i < transform.length; ++i) {
            for (int j = 0; j < transform[i].length; ++j) {
                transform[i][j] = this.in.readFloat();
            }
        }
        String intentName = this.in.readString(16);
        if (this.in.getFilePointer() + 8L < this.in.length()) {
            this.in.skipBytes(4);
            byte extension = this.in.readByte();
            this.in.skipBytes(3);
            if (extension != 0) {
                long max;
                long l = max = this.in.equals(this.pixelFile) ? (long)this.pixelOffset : this.in.length();
                while (this.in.getFilePointer() < max) {
                    long fp = this.in.getFilePointer();
                    int esize = this.in.readInt();
                    int ecode = this.in.readInt();
                    if (ecode == 2 || ecode == 4) {
                        // empty if block
                    }
                    this.in.seek(fp + (long)esize);
                }
            }
        }
        LOGGER.info("Populating metadata table");
        for (int i = 0; i < transform.length; ++i) {
            String axis = i == 0 ? "X" : (i == 1 ? "Y" : "Z");
            for (int j = 0; j < transform[i].length; ++j) {
                this.addGlobalMeta("Affine transform " + axis + "[" + j + "]", transform[i][j]);
            }
        }
        this.addGlobalMeta("Intent name", intentName);
        this.addGlobalMeta("Slice Ordering", sliceOrdering);
        this.addGlobalMeta("Number of dimensions", this.nDimensions);
        this.addGlobalMeta("Width", this.getSizeX());
        this.addGlobalMeta("Height", this.getSizeY());
        this.addGlobalMeta("Number of Z slices", this.getSizeZ());
        this.addGlobalMeta("Number of time points", this.getSizeT());
        this.addGlobalMeta("Dimension 5", dim5);
        this.addGlobalMeta("Dimension 6", dim6);
        this.addGlobalMeta("Dimension 7", dim7);
        this.addGlobalMeta("Dimension 8", dim8);
        this.addGlobalMeta("Intent #1", intent1);
        this.addGlobalMeta("Intent #2", intent2);
        this.addGlobalMeta("Intent #3", intent3);
        this.addGlobalMeta("Intent code", intentCode);
        this.addGlobalMeta("Data type", dataType);
        this.addGlobalMeta("Bits per pixel", bitpix);
        this.addGlobalMeta("Slice start", sliceStart);
        this.addGlobalMeta("Voxel width", this.voxelWidth);
        this.addGlobalMeta("Voxel height", this.voxelHeight);
        this.addGlobalMeta("Slice thickness", this.sliceThickness);
        this.addGlobalMeta("Time increment", this.deltaT);
        this.addGlobalMeta("Scale slope", scaleSlope);
        this.addGlobalMeta("Scale intercept", scaleIntercept);
        this.addGlobalMeta("Slice end", sliceEnd);
        this.addGlobalMeta("Calibrated maximum", calMax);
        this.addGlobalMeta("Calibrated minimum", calMin);
        this.addGlobalMeta("Slice duration", sliceDuration);
        this.addGlobalMeta("Time offset", toffset);
        this.addGlobalMeta("Description", this.description);
        this.addGlobalMeta("Q-form Code", qformCode);
        this.addGlobalMeta("S-form Code", sformCode);
        this.addGlobalMeta("Quaternion b parameter", quaternionB);
        this.addGlobalMeta("Quaternion c parameter", quaternionC);
        this.addGlobalMeta("Quaternion d parameter", quaternionD);
        this.addGlobalMeta("Quaternion x parameter", quaternionX);
        this.addGlobalMeta("Quaternion y parameter", quaternionY);
        this.addGlobalMeta("Quaternion z parameter", quaternionZ);
        this.addGlobalMeta("Slice code", sliceCode);
        this.addGlobalMeta("XYZT units", units);
        this.addGlobalMeta("XYZ units", spatialUnits);
        this.addGlobalMeta("Time units", timeUnits);
    }
}

