/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.common.Region;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.FormatWriter;
import loci.formats.codec.CompressionType;
import loci.formats.gui.AWTImageTools;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffCompression;
import loci.formats.tiff.TiffParser;
import loci.formats.tiff.TiffRational;
import loci.formats.tiff.TiffSaver;
import ome.units.UNITS;
import ome.units.quantity.Length;

public class TiffWriter
extends FormatWriter {
    public static final String COMPRESSION_UNCOMPRESSED = CompressionType.UNCOMPRESSED.getCompression();
    public static final String COMPRESSION_LZW = CompressionType.LZW.getCompression();
    public static final String COMPRESSION_J2K = CompressionType.J2K.getCompression();
    public static final String COMPRESSION_J2K_LOSSY = CompressionType.J2K_LOSSY.getCompression();
    public static final String COMPRESSION_JPEG = CompressionType.JPEG.getCompression();
    public static final String COMPRESSION_ZLIB = CompressionType.ZLIB.getCompression();
    private static final String[] BIG_TIFF_SUFFIXES = new String[]{"tf2", "tf8", "btf"};
    private static final int TILE_GRANULARITY = 16;
    protected boolean isBigTiff;
    protected boolean canDetectBigTiff = true;
    protected TiffSaver tiffSaver;
    protected RandomAccessInputStream in;
    protected boolean checkParams = true;
    protected int tileSizeX;
    protected int tileSizeY;

    private void formatCompression(IFD ifd) throws FormatException {
        if (this.compression == null) {
            this.compression = "";
        }
        TiffCompression compressType = TiffCompression.UNCOMPRESSED;
        if (this.compression.equals(COMPRESSION_LZW)) {
            compressType = TiffCompression.LZW;
        } else if (this.compression.equals(COMPRESSION_J2K)) {
            compressType = TiffCompression.JPEG_2000;
        } else if (this.compression.equals(COMPRESSION_J2K_LOSSY)) {
            compressType = TiffCompression.JPEG_2000_LOSSY;
        } else if (this.compression.equals(COMPRESSION_JPEG)) {
            compressType = TiffCompression.JPEG;
        } else if (this.compression.equals(COMPRESSION_ZLIB)) {
            compressType = TiffCompression.DEFLATE;
        }
        Object v = ifd.get(new Integer(259));
        if (v == null) {
            ifd.put(new Integer(259), compressType.getCode());
        }
    }

    public TiffWriter() {
        this("Tagged Image File Format", new String[]{"tif", "tiff", "tf2", "tf8", "btf"});
    }

    public TiffWriter(String format, String[] exts) {
        super(format, exts);
        this.compressionTypes = new String[]{COMPRESSION_UNCOMPRESSED, COMPRESSION_LZW, COMPRESSION_J2K, COMPRESSION_J2K_LOSSY, COMPRESSION_JPEG, COMPRESSION_ZLIB};
        this.isBigTiff = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setId(String id) throws FormatException, IOException {
        super.setId(id);
        if (!this.isBigTiff) {
            if (TiffWriter.checkSuffix(id, BIG_TIFF_SUFFIXES)) {
                LOGGER.info("Switching to BigTIFF (by file extension)");
                this.isBigTiff = true;
            } else if (this.compression == null || this.compression.equals(COMPRESSION_UNCOMPRESSED)) {
                MetadataRetrieve retrieve = this.getMetadataRetrieve();
                long totalBytes = 0L;
                for (int i = 0; i < retrieve.getImageCount(); ++i) {
                    int sizeX = (Integer)retrieve.getPixelsSizeX(i).getValue();
                    int sizeY = (Integer)retrieve.getPixelsSizeY(i).getValue();
                    int sizeZ = (Integer)retrieve.getPixelsSizeZ(i).getValue();
                    int sizeC = (Integer)retrieve.getPixelsSizeC(i).getValue();
                    int sizeT = (Integer)retrieve.getPixelsSizeT(i).getValue();
                    int type = FormatTools.pixelTypeFromString(retrieve.getPixelsType(i).toString());
                    long bpp = FormatTools.getBytesPerPixel(type);
                    totalBytes += (long)sizeX * (long)sizeY * (long)sizeZ * (long)sizeC * (long)sizeT * bpp;
                }
                if (totalBytes >= 4183818240L) {
                    if (this.canDetectBigTiff) {
                        LOGGER.info("Switching to BigTIFF (by file size)");
                        this.isBigTiff = true;
                    } else {
                        LOGGER.info("Automatic BigTIFF disabled but pixel byte count = {}", (Object)totalBytes);
                    }
                }
            }
        }
        TiffWriter tiffWriter = this;
        synchronized (tiffWriter) {
            this.setupTiffSaver();
        }
    }

    public void saveBytes(int no, byte[] buf, IFD ifd) throws IOException, FormatException {
        int w = this.getSizeX();
        int h2 = this.getSizeY();
        this.saveBytes(no, buf, ifd, 0, 0, w, h2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveBytes(int no, byte[] buf, IFD ifd, int x, int y, int w, int h2) throws IOException, FormatException {
        boolean usingTiling;
        if (this.checkParams) {
            this.checkParams(no, buf, x, y, w, h2);
        }
        if (ifd == null) {
            ifd = new IFD();
        }
        MetadataRetrieve retrieve = this.getMetadataRetrieve();
        int type = FormatTools.pixelTypeFromString(retrieve.getPixelsType(this.series).toString());
        int index = no;
        int currentTileSizeX = this.getTileSizeX();
        int currentTileSizeY = this.getTileSizeY();
        boolean bl = usingTiling = currentTileSizeX > 0 && currentTileSizeY > 0;
        if (usingTiling) {
            ifd.put(new Integer(322), new Long(currentTileSizeX));
            ifd.put(new Integer(323), new Long(currentTileSizeY));
        }
        if (usingTiling && (currentTileSizeX < w || currentTileSizeY < h2)) {
            int numTilesX = (w + x % currentTileSizeX + currentTileSizeX - 1) / currentTileSizeX;
            int numTilesY = (h2 + y % currentTileSizeY + currentTileSizeY - 1) / currentTileSizeY;
            for (int yTileIndex = 0; yTileIndex < numTilesY; ++yTileIndex) {
                for (int xTileIndex = 0; xTileIndex < numTilesX; ++xTileIndex) {
                    Region tileParams = new Region();
                    tileParams.width = xTileIndex < numTilesX - 1 ? currentTileSizeX - x % currentTileSizeX : w - currentTileSizeX * xTileIndex;
                    tileParams.height = yTileIndex < numTilesY - 1 ? currentTileSizeY - y % currentTileSizeY : h2 - currentTileSizeY * yTileIndex;
                    tileParams.x = x + xTileIndex * currentTileSizeX - (xTileIndex > 0 ? x % currentTileSizeX : 0);
                    tileParams.y = y + yTileIndex * currentTileSizeY - (yTileIndex > 0 ? y % currentTileSizeY : 0);
                    byte[] tileBuf = this.getTile(buf, tileParams, new Region(x, y, w, h2));
                    TiffWriter tiffWriter = this;
                    synchronized (tiffWriter) {
                        TiffSaver tiffSaver = this.tiffSaver;
                        synchronized (tiffSaver) {
                            index = this.prepareToWriteImage(no, tileBuf, ifd, tileParams.x, tileParams.y, tileParams.width, tileParams.height);
                            if (index == -1) {
                                return;
                            }
                        }
                    }
                    boolean lastPlane = no == this.getPlaneCount() - 1;
                    boolean lastSeries = this.getSeries() == retrieve.getImageCount() - 1;
                    boolean lastResolution = this.getResolution() == this.getResolutionCount() - 1;
                    this.tiffSaver.writeImage(tileBuf, ifd, index, type, tileParams.x, tileParams.y, tileParams.width, tileParams.height, lastPlane && lastSeries && lastResolution);
                }
            }
        } else {
            TiffWriter numTilesX = this;
            synchronized (numTilesX) {
                TiffSaver numTilesY = this.tiffSaver;
                synchronized (numTilesY) {
                    index = this.prepareToWriteImage(no, buf, ifd, x, y, w, h2);
                    if (index == -1) {
                        return;
                    }
                }
            }
            boolean lastPlane = no == this.getPlaneCount() - 1;
            boolean lastSeries = this.getSeries() == retrieve.getImageCount() - 1;
            boolean lastResolution = this.getResolution() == this.getResolutionCount() - 1;
            this.tiffSaver.writeImage(buf, ifd, index, type, x, y, w, h2, lastPlane && lastSeries && lastResolution);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int prepareToWriteImage(int no, byte[] buf, IFD ifd, int x, int y, int w, int h2) throws IOException, FormatException {
        MetadataRetrieve retrieve = this.getMetadataRetrieve();
        boolean littleEndian = false;
        if (retrieve.getPixelsBigEndian(this.series) != null) {
            littleEndian = retrieve.getPixelsBigEndian(this.series) == false;
        } else if (retrieve.getPixelsBinDataCount(this.series) == 0) {
            littleEndian = retrieve.getPixelsBinDataBigEndian(this.series, 0) == false;
        }
        TiffWriter tiffWriter = this;
        synchronized (tiffWriter) {
            block37: {
                if (!this.initialized[this.series][no]) {
                    this.initialized[this.series][no] = true;
                    try (RandomAccessInputStream tmp = this.createInputStream();){
                        tmp.order(littleEndian);
                        if (tmp.length() != 0L) break block37;
                        TiffWriter tiffWriter2 = this;
                        synchronized (tiffWriter2) {
                            this.tiffSaver.writeHeader();
                        }
                    }
                }
            }
        }
        int c = this.getSamplesPerPixel();
        int type = FormatTools.pixelTypeFromString(retrieve.getPixelsType(this.series).toString());
        int bytesPerPixel = FormatTools.getBytesPerPixel(type);
        int blockSize = w * h2 * c * bytesPerPixel;
        if (blockSize > buf.length) {
            c = buf.length / (w * h2 * bytesPerPixel);
        }
        this.formatCompression(ifd);
        byte[][] lut = AWTImageTools.get8BitLookupTable(this.cm);
        if (lut != null) {
            int[] colorMap = new int[lut.length * lut[0].length];
            for (int i = 0; i < lut.length; ++i) {
                for (int j = 0; j < lut[0].length; ++j) {
                    colorMap[i * lut[0].length + j] = (lut[i][j] & 0xFF) << 8;
                }
            }
            ifd.putIFDValue(320, colorMap);
        } else {
            short[][] lut16 = AWTImageTools.getLookupTable(this.cm);
            if (lut16 != null) {
                int[] colorMap = new int[lut16.length * lut16[0].length];
                for (int i = 0; i < lut16.length; ++i) {
                    for (int j = 0; j < lut16[0].length; ++j) {
                        colorMap[i * lut16[0].length + j] = lut16[i][j] & 0xFFFF;
                    }
                }
                ifd.putIFDValue(320, colorMap);
            }
        }
        int width = this.getSizeX();
        int height = this.getSizeY();
        ifd.put(new Integer(256), new Long(width));
        ifd.put(new Integer(257), new Long(height));
        Length px = retrieve.getPixelsPhysicalSizeX(this.series);
        Double physicalSizeX = px == null || px.value(UNITS.MICROMETER) == null ? null : Double.valueOf(px.value(UNITS.MICROMETER).doubleValue());
        physicalSizeX = physicalSizeX == null || physicalSizeX == 0.0 ? Double.valueOf(0.0) : Double.valueOf(1.0 / physicalSizeX);
        Length py = retrieve.getPixelsPhysicalSizeY(this.series);
        Double physicalSizeY = py == null || py.value(UNITS.MICROMETER) == null ? null : Double.valueOf(py.value(UNITS.MICROMETER).doubleValue());
        physicalSizeY = physicalSizeY == null || physicalSizeY == 0.0 ? Double.valueOf(0.0) : Double.valueOf(1.0 / physicalSizeY);
        ifd.put(296, 3);
        ifd.put(282, new TiffRational((long)(physicalSizeX * 1000.0 * 10000.0), 1000L));
        ifd.put(283, new TiffRational((long)(physicalSizeY * 1000.0 * 10000.0), 1000L));
        if (!this.isBigTiff) {
            boolean bl = this.isBigTiff = this.out.length() + (long)(2 * (width * height * c * bytesPerPixel)) >= 0x100000000L;
            if (this.isBigTiff) {
                throw new FormatException("File is too large; call setBigTiff(true)");
            }
        }
        ifd.put(new Integer(0), new Boolean(littleEndian));
        if (!ifd.containsKey(3)) {
            ifd.put(3, this.out.length());
            this.out.seek(this.out.length());
        } else {
            this.out.seek((Long)ifd.get(3));
        }
        ifd.putIFDValue(284, this.interleaved || this.getSamplesPerPixel() == 1 ? 1 : 2);
        int sampleFormat = 1;
        if (FormatTools.isSigned(type)) {
            sampleFormat = 2;
        }
        if (FormatTools.isFloatingPoint(type)) {
            sampleFormat = 3;
        }
        ifd.putIFDValue(339, sampleFormat);
        int channels = (Integer)retrieve.getPixelsSizeC(this.series).getValue();
        int z = (Integer)retrieve.getPixelsSizeZ(this.series).getValue();
        int t = (Integer)retrieve.getPixelsSizeT(this.series).getValue();
        ifd.putIFDValue(270, "ImageJ=\nhyperstack=true\nimages=" + channels * z * t + "\nchannels=" + channels + "\nslices=" + z + "\nframes=" + t);
        int index = no * this.getResolutionCount() + this.getResolution();
        int currentSeries = this.getSeries();
        int currentResolution = this.getResolution();
        for (int i = 0; i < currentSeries; ++i) {
            this.setSeries(i);
            index += this.getPlaneCount() * this.getResolutionCount();
        }
        this.setSeries(currentSeries);
        this.setResolution(currentResolution);
        return index;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.in != null) {
            this.in.close();
        }
        if (this.tiffSaver != null) {
            this.tiffSaver.close();
        }
    }

    @Override
    public int getPlaneCount() {
        return this.getPlaneCount(this.series);
    }

    @Override
    public void saveBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        IFD ifd = new IFD();
        if (!this.sequential) {
            try (RandomAccessInputStream stream = new RandomAccessInputStream(this.currentId);){
                TiffParser parser = new TiffParser(stream);
                long[] ifdOffsets = parser.getIFDOffsets();
                if (no < ifdOffsets.length) {
                    ifd = parser.getIFD(ifdOffsets[no]);
                }
                this.saveBytes(no, buf, ifd, x, y, w, h2);
            }
        } else {
            this.saveBytes(no, buf, ifd, x, y, w, h2);
        }
    }

    @Override
    public boolean canDoStacks() {
        return true;
    }

    @Override
    public int[] getPixelTypes(String codec) {
        if (codec != null && codec.equals(COMPRESSION_JPEG)) {
            return new int[]{0, 1, 2, 3};
        }
        if (codec != null && codec.equals(COMPRESSION_J2K)) {
            return new int[]{0, 1, 2, 3, 4, 5, 6};
        }
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    }

    public void setBigTiff(boolean bigTiff) {
        FormatTools.assertId(this.currentId, false, 1);
        this.isBigTiff = bigTiff;
    }

    public void setCanDetectBigTiff(boolean detect) {
        FormatTools.assertId(this.currentId, false, 1);
        this.canDetectBigTiff = detect;
    }

    protected void setupTiffSaver() throws IOException {
        this.out.close();
        this.out = this.createOutputStream();
        this.tiffSaver = this.createTiffSaver();
        MetadataRetrieve retrieve = this.getMetadataRetrieve();
        boolean littleEndian = false;
        if (retrieve.getPixelsBigEndian(this.series) != null) {
            littleEndian = retrieve.getPixelsBigEndian(this.series) == false;
        } else if (retrieve.getPixelsBinDataCount(this.series) == 0) {
            littleEndian = retrieve.getPixelsBinDataBigEndian(this.series, 0) == false;
        }
        this.tiffSaver.setWritingSequentially(this.sequential);
        this.tiffSaver.setLittleEndian(littleEndian);
        this.tiffSaver.setBigTiff(this.isBigTiff);
        this.tiffSaver.setCodecOptions(this.options);
    }

    @Override
    public int getTileSizeX() throws FormatException {
        if (this.tileSizeX == 0) {
            return super.getTileSizeX();
        }
        return this.tileSizeX;
    }

    @Override
    public int setTileSizeX(int tileSize) throws FormatException {
        this.tileSizeX = super.setTileSizeX(tileSize);
        this.tileSizeX = tileSize == 0 ? 0 : (tileSize < 16 ? 16 : Math.round((float)tileSize / 16.0f) * 16);
        return this.tileSizeX;
    }

    @Override
    public int getTileSizeY() throws FormatException {
        if (this.tileSizeY == 0) {
            return super.getTileSizeY();
        }
        return this.tileSizeY;
    }

    @Override
    public int setTileSizeY(int tileSize) throws FormatException {
        this.tileSizeY = super.setTileSizeY(tileSize);
        this.tileSizeY = tileSize == 0 ? 0 : (tileSize < 16 ? 16 : Math.round((float)tileSize / 16.0f) * 16);
        return this.tileSizeY;
    }

    private byte[] getTile(byte[] buf, Region tileParams, Region srcParams) {
        MetadataRetrieve retrieve = this.getMetadataRetrieve();
        int type = FormatTools.pixelTypeFromString(retrieve.getPixelsType(this.series).toString());
        int channel_count = this.getSamplesPerPixel();
        int bytesPerPixel = FormatTools.getBytesPerPixel(type);
        int tileSize = tileParams.width * tileParams.height * bytesPerPixel * channel_count;
        byte[] returnBuf = new byte[tileSize];
        for (int row = tileParams.y; row != tileParams.y + tileParams.height; ++row) {
            for (int sampleoffset = 0; sampleoffset < tileParams.width * channel_count; ++sampleoffset) {
                int channel_index = sampleoffset / tileParams.width;
                int channel_offset = (sampleoffset - tileParams.width * channel_index) * bytesPerPixel;
                int full_row_width = srcParams.width * bytesPerPixel;
                int full_plane_size = full_row_width * srcParams.height;
                int xoffset = (tileParams.x - srcParams.x) * bytesPerPixel;
                int yoffset = (row - srcParams.y) * full_row_width;
                int row_offset = (row - tileParams.y) * tileParams.width * bytesPerPixel;
                int src_index = yoffset + xoffset + channel_offset + channel_index * full_plane_size;
                int dest_index = tileParams.height * tileParams.width * channel_index * bytesPerPixel + row_offset;
                for (int pixelByte = 0; pixelByte < bytesPerPixel; ++pixelByte) {
                    returnBuf[dest_index + channel_offset + pixelByte] = buf[src_index + pixelByte];
                }
            }
        }
        return returnBuf;
    }

    protected RandomAccessInputStream createInputStream() throws IOException {
        return new RandomAccessInputStream(this.currentId);
    }

    protected TiffSaver createTiffSaver() {
        return new TiffSaver(this.out, this.currentId);
    }
}

