/*
 * Decompiled with CFR 0.152.
 */
package ome.units.quantity;

import ome.units.quantity.Quantity;
import ome.units.unit.Unit;

public class Power
extends Quantity
implements Comparable<Power> {
    private static final int SEED1 = 56;
    private static final int SEED2 = 67;
    Number value;
    Unit<Power> unit;
    private int hashCodeValue;

    public Power(Number inValue, Unit<Power> inUnit) {
        if (inValue == null) {
            throw new NullPointerException("Power: Power cannot be constructed with a null value.");
        }
        this.value = inValue;
        this.unit = inUnit;
        this.hashCodeValue = 56;
        this.hashCodeValue = 67 * this.hashCodeValue + Float.floatToIntBits(this.value.floatValue());
        this.hashCodeValue = 67 * this.hashCodeValue + this.unit.getSymbol().hashCode();
    }

    @Override
    public Number value() {
        return this.value;
    }

    public Number value(Unit<Power> inUnit) {
        if (this.unit.equals(inUnit)) {
            return this.value;
        }
        if (this.unit.isConvertible(inUnit).booleanValue()) {
            return this.unit.convertValue(this.value, inUnit);
        }
        return null;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        Power otherPower = (Power)other;
        if (this.unit.equals(otherPower.unit)) {
            return this.value.equals(otherPower.value);
        }
        if (this.unit.isConvertible(otherPower.unit).booleanValue()) {
            return this.unit.convertValue(this.value, otherPower.unit).equals(otherPower.value);
        }
        return false;
    }

    @Override
    public int compareTo(Power other) {
        if (this == other) {
            return 0;
        }
        return Double.compare(this.value.doubleValue(), other.value(this.unit).doubleValue());
    }

    public int hashCode() {
        return this.hashCodeValue;
    }

    public String toString() {
        return this.getClass().getName() + ": " + "value[" + this.value + "], unit[" + this.unit.getSymbol() + "] stored as " + this.value.getClass().getName();
    }

    public Unit<Power> unit() {
        return this.unit;
    }
}

