/*
 * Decompiled with CFR 0.152.
 */
package ome.units.quantity;

import ome.units.quantity.Quantity;
import ome.units.unit.Unit;

public class Pressure
extends Quantity
implements Comparable<Pressure> {
    private static final int SEED1 = 67;
    private static final int SEED2 = 78;
    Number value;
    Unit<Pressure> unit;
    private int hashCodeValue;

    public Pressure(Number inValue, Unit<Pressure> inUnit) {
        if (inValue == null) {
            throw new NullPointerException("Pressure: Pressure cannot be constructed with a null value.");
        }
        this.value = inValue;
        this.unit = inUnit;
        this.hashCodeValue = 67;
        this.hashCodeValue = 78 * this.hashCodeValue + Float.floatToIntBits(this.value.floatValue());
        this.hashCodeValue = 78 * this.hashCodeValue + this.unit.getSymbol().hashCode();
    }

    @Override
    public Number value() {
        return this.value;
    }

    public Number value(Unit<Pressure> inUnit) {
        if (this.unit.equals(inUnit)) {
            return this.value;
        }
        if (this.unit.isConvertible(inUnit).booleanValue()) {
            return this.unit.convertValue(this.value, inUnit);
        }
        return null;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        Pressure otherPressure = (Pressure)other;
        if (this.unit.equals(otherPressure.unit)) {
            return this.value.equals(otherPressure.value);
        }
        if (this.unit.isConvertible(otherPressure.unit).booleanValue()) {
            return this.unit.convertValue(this.value, otherPressure.unit).equals(otherPressure.value);
        }
        return false;
    }

    @Override
    public int compareTo(Pressure other) {
        if (this == other) {
            return 0;
        }
        return Double.compare(this.value.doubleValue(), other.value(this.unit).doubleValue());
    }

    public int hashCode() {
        return this.hashCodeValue;
    }

    public String toString() {
        return this.getClass().getName() + ": " + "value[" + this.value + "], unit[" + this.unit.getSymbol() + "] stored as " + this.value.getClass().getName();
    }

    public Unit<Pressure> unit() {
        return this.unit;
    }
}

